<?php

$web = 'index.php';

if (in_array('phar', stream_get_wrappers()) && class_exists('Phar', 0)) {
Phar::interceptFileFuncs();
set_include_path('phar://' . __FILE__ . PATH_SEPARATOR . get_include_path());
Phar::webPhar(null, $web);
include 'phar://' . __FILE__ . '/' . Extract_Phar::START;
return;
}

if (@(isset($_SERVER['REQUEST_URI']) && isset($_SERVER['REQUEST_METHOD']) && ($_SERVER['REQUEST_METHOD'] == 'GET' || $_SERVER['REQUEST_METHOD'] == 'POST'))) {
Extract_Phar::go(true);
$mimes = array(
'phps' => 2,
'c' => 'text/plain',
'cc' => 'text/plain',
'cpp' => 'text/plain',
'c++' => 'text/plain',
'dtd' => 'text/plain',
'h' => 'text/plain',
'log' => 'text/plain',
'rng' => 'text/plain',
'txt' => 'text/plain',
'xsd' => 'text/plain',
'php' => 1,
'inc' => 1,
'avi' => 'video/avi',
'bmp' => 'image/bmp',
'css' => 'text/css',
'gif' => 'image/gif',
'htm' => 'text/html',
'html' => 'text/html',
'htmls' => 'text/html',
'ico' => 'image/x-ico',
'jpe' => 'image/jpeg',
'jpg' => 'image/jpeg',
'jpeg' => 'image/jpeg',
'js' => 'application/x-javascript',
'midi' => 'audio/midi',
'mid' => 'audio/midi',
'mod' => 'audio/mod',
'mov' => 'movie/quicktime',
'mp3' => 'audio/mp3',
'mpg' => 'video/mpeg',
'mpeg' => 'video/mpeg',
'pdf' => 'application/pdf',
'png' => 'image/png',
'swf' => 'application/shockwave-flash',
'tif' => 'image/tiff',
'tiff' => 'image/tiff',
'wav' => 'audio/wav',
'xbm' => 'image/xbm',
'xml' => 'text/xml',
);

header("Cache-Control: no-cache, must-revalidate");
header("Pragma: no-cache");

$basename = basename(__FILE__);
if (!strpos($_SERVER['REQUEST_URI'], $basename)) {
chdir(Extract_Phar::$temp);
include $web;
return;
}
$pt = substr($_SERVER['REQUEST_URI'], strpos($_SERVER['REQUEST_URI'], $basename) + strlen($basename));
if (!$pt || $pt == '/') {
$pt = $web;
header('HTTP/1.1 301 Moved Permanently');
header('Location: ' . $_SERVER['REQUEST_URI'] . '/' . $pt);
exit;
}
$a = realpath(Extract_Phar::$temp . DIRECTORY_SEPARATOR . $pt);
if (!$a || strlen(dirname($a)) < strlen(Extract_Phar::$temp)) {
header('HTTP/1.0 404 Not Found');
echo "<html>\n <head>\n  <title>File Not Found<title>\n </head>\n <body>\n  <h1>404 - File ", $pt, " Not Found</h1>\n </body>\n</html>";
exit;
}
$b = pathinfo($a);
if (!isset($b['extension'])) {
header('Content-Type: text/plain');
header('Content-Length: ' . filesize($a));
readfile($a);
exit;
}
if (isset($mimes[$b['extension']])) {
if ($mimes[$b['extension']] === 1) {
include $a;
exit;
}
if ($mimes[$b['extension']] === 2) {
highlight_file($a);
exit;
}
header('Content-Type: ' .$mimes[$b['extension']]);
header('Content-Length: ' . filesize($a));
readfile($a);
exit;
}
}

class Extract_Phar
{
static $temp;
static $origdir;
const GZ = 0x1000;
const BZ2 = 0x2000;
const MASK = 0x3000;
const START = 'index.php';
const LEN = 6685;

static function go($return = false)
{
$fp = fopen(__FILE__, 'rb');
fseek($fp, self::LEN);
$L = unpack('V', $a = (binary)fread($fp, 4));
$m = (binary)'';

do {
$read = 8192;
if ($L[1] - strlen($m) < 8192) {
$read = $L[1] - strlen($m);
}
$last = (binary)fread($fp, $read);
$m .= $last;
} while (strlen($last) && strlen($m) < $L[1]);

if (strlen($m) < $L[1]) {
die('ERROR: manifest length read was "' .
strlen($m) .'" should be "' .
$L[1] . '"');
}

$info = self::_unpack($m);
$f = $info['c'];

if ($f & self::GZ) {
if (!function_exists('gzinflate')) {
die('Error: zlib extension is not enabled -' .
' gzinflate() function needed for zlib-compressed .phars');
}
}

if ($f & self::BZ2) {
if (!function_exists('bzdecompress')) {
die('Error: bzip2 extension is not enabled -' .
' bzdecompress() function needed for bz2-compressed .phars');
}
}

$temp = self::tmpdir();

if (!$temp || !is_writable($temp)) {
$sessionpath = session_save_path();
if (strpos ($sessionpath, ";") !== false)
$sessionpath = substr ($sessionpath, strpos ($sessionpath, ";")+1);
if (!file_exists($sessionpath) || !is_dir($sessionpath)) {
die('Could not locate temporary directory to extract phar');
}
$temp = $sessionpath;
}

$temp .= '/pharextract/'.basename(__FILE__, '.phar');
self::$temp = $temp;
self::$origdir = getcwd();
@mkdir($temp, 0777, true);
$temp = realpath($temp);

if (!file_exists($temp . DIRECTORY_SEPARATOR . md5_file(__FILE__))) {
self::_removeTmpFiles($temp, getcwd());
@mkdir($temp, 0777, true);
@file_put_contents($temp . '/' . md5_file(__FILE__), '');

foreach ($info['m'] as $path => $file) {
$a = !file_exists(dirname($temp . '/' . $path));
@mkdir(dirname($temp . '/' . $path), 0777, true);
clearstatcache();

if ($path[strlen($path) - 1] == '/') {
@mkdir($temp . '/' . $path, 0777);
} else {
file_put_contents($temp . '/' . $path, self::extractFile($path, $file, $fp));
@chmod($temp . '/' . $path, 0666);
}
}
}

chdir($temp);

if (!$return) {
include self::START;
}
}

static function tmpdir()
{
if (strpos(PHP_OS, 'WIN') !== false) {
if ($var = getenv('TMP') ? getenv('TMP') : getenv('TEMP')) {
return $var;
}
if (is_dir('/temp') || mkdir('/temp')) {
return realpath('/temp');
}
return false;
}
if ($var = getenv('TMPDIR')) {
return $var;
}
return realpath('/tmp');
}

static function _unpack($m)
{
$info = unpack('V', substr($m, 0, 4));
 $l = unpack('V', substr($m, 10, 4));
$m = substr($m, 14 + $l[1]);
$s = unpack('V', substr($m, 0, 4));
$o = 0;
$start = 4 + $s[1];
$ret['c'] = 0;

for ($i = 0; $i < $info[1]; $i++) {
 $len = unpack('V', substr($m, $start, 4));
$start += 4;
 $savepath = substr($m, $start, $len[1]);
$start += $len[1];
   $ret['m'][$savepath] = array_values(unpack('Va/Vb/Vc/Vd/Ve/Vf', substr($m, $start, 24)));
$ret['m'][$savepath][3] = sprintf('%u', $ret['m'][$savepath][3]
& 0xffffffff);
$ret['m'][$savepath][7] = $o;
$o += $ret['m'][$savepath][2];
$start += 24 + $ret['m'][$savepath][5];
$ret['c'] |= $ret['m'][$savepath][4] & self::MASK;
}
return $ret;
}

static function extractFile($path, $entry, $fp)
{
$data = '';
$c = $entry[2];

while ($c) {
if ($c < 8192) {
$data .= @fread($fp, $c);
$c = 0;
} else {
$c -= 8192;
$data .= @fread($fp, 8192);
}
}

if ($entry[4] & self::GZ) {
$data = gzinflate($data);
} elseif ($entry[4] & self::BZ2) {
$data = bzdecompress($data);
}

if (strlen($data) != $entry[0]) {
die("Invalid internal .phar file (size error " . strlen($data) . " != " .
$stat[7] . ")");
}

if ($entry[3] != sprintf("%u", crc32((binary)$data) & 0xffffffff)) {
die("Invalid internal .phar file (checksum error)");
}

return $data;
}

static function _removeTmpFiles($temp, $origdir)
{
chdir($temp);

foreach (glob('*') as $f) {
if (file_exists($f)) {
is_dir($f) ? @rmdir($f) : @unlink($f);
if (file_exists($f) && is_dir($f)) {
self::_removeTmpFiles($f, getcwd());
}
}
}

@rmdir($temp);
clearstatcache();
chdir($origdir);
}
}

Extract_Phar::go();
__HALT_COMPILER(); ?>
t~  )          &   a:1:{s:9:"bootstrap";s:9:"index.php";}   custom_config.iniP   ZP   KΟ}  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   lib/classes/class.wizard.php  Z  C9  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   lib/classes/class.nls.php  Z  =[帶  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   lib/classes/class.langtools.php(  Z(  ̛  (   a:1:{s:9:"mime-type";s:10:"text/plain";}(   lib/classes/tests/class.warning_test.php  Z  F  (   a:1:{s:9:"mime-type";s:10:"text/plain";})   lib/classes/tests/class.matchall_test.phpS  ZS  4B  (   a:1:{s:9:"mime-type";s:10:"text/plain";})   lib/classes/tests/class.matchany_test.php  Z  T,  (   a:1:{s:9:"mime-type";s:10:"text/plain";}%   lib/classes/tests/class.test_base.php(  Z(  y::  (   a:1:{s:9:"mime-type";s:10:"text/plain";}.   lib/classes/tests/class.informational_test.php  Z  NA	  (   a:1:{s:9:"mime-type";s:10:"text/plain";}.   lib/classes/tests/class.version_range_test.php  Z  
[4϶  (   a:1:{s:9:"mime-type";s:10:"text/plain";}&   lib/classes/tests/class.range_test.php2  Z2  f  (   a:1:{s:9:"mime-type";s:10:"text/plain";}(   lib/classes/tests/class.boolean_test.php{  Z{    (   a:1:{s:9:"mime-type";s:10:"text/plain";}"   lib/classes/class.http_request.php  Z  YY  (   a:1:{s:9:"mime-type";s:10:"text/plain";}    lib/classes/class.cms_smarty.php  Z  Ho  (   a:1:{s:9:"mime-type";s:10:"text/plain";}"   lib/classes/accessor.functions.php   Z   L  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   lib/classes/class.database.phpx   Zx   `߶  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   lib/classes/class.nlstools.php  Z  {*  (   a:1:{s:9:"mime-type";s:10:"text/plain";}!   lib/classes/class.wizard_step.php(  Z(  o>  (   a:1:{s:9:"mime-type";s:10:"text/plain";}#   lib/classes/base/misc.functions.php   Z   L$&  (   a:1:{s:9:"mime-type";s:10:"text/plain";}"   lib/classes/base/class.request.php	  Z	  _ƶ  (   a:1:{s:9:"mime-type";s:10:"text/plain";}"   lib/classes/base/class.session.php  Z  ]_  (   a:1:{s:9:"mime-type";s:10:"text/plain";}%   lib/classes/base/compat.functions.php   Z   K  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   lib/classes/base/class.app.phpv  Zv  a"  (   a:1:{s:9:"mime-type";s:10:"text/plain";}    lib/classes/base/class.utils.php  Z  k	  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   lib/nls/class.nb_NO.nls.php  Z  m.  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   lib/nls/class.nl_NL.nls.phpS  ZS  vĶ  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   lib/nls/class.de_DE.nls.phpa  Za  Eж  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   lib/nls/class.pt_PT.nls.phpd  Zd  u 0  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   lib/nls/class.fr_FR.nls.phpt  Zt  ׬n  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   lib/nls/class.en_US.nls.php`  Z`    (   a:1:{s:9:"mime-type";s:10:"text/plain";}2   lib/CMSMS/Database/mysqli/class.DataDictionary.php%  Z%  /1  (   a:1:{s:9:"mime-type";s:10:"text/plain";}.   lib/CMSMS/Database/mysqli/class.Connection.php  Z  9  (   a:1:{s:9:"mime-type";s:10:"text/plain";}-   lib/CMSMS/Database/mysqli/class.ResultSet.php  Z  O  (   a:1:{s:9:"mime-type";s:10:"text/plain";}-   lib/CMSMS/Database/mysqli/class.Statement.php  Z   .  (   a:1:{s:9:"mime-type";s:10:"text/plain";}+   lib/CMSMS/Database/class.DataDictionary.phpo  Zo  W  (   a:1:{s:9:"mime-type";s:10:"text/plain";}'   lib/CMSMS/Database/class.Connection.phpY  ZY  )T  (   a:1:{s:9:"mime-type";s:10:"text/plain";}*   lib/CMSMS/Database/class.compatibility.php  Z  +<  (   a:1:{s:9:"mime-type";s:10:"text/plain";}&   lib/CMSMS/Database/class.ResultSet.php  Z  Q  (   a:1:{s:9:"mime-type";s:10:"text/plain";}+   lib/CMSMS/Database/class.EmptyRecordSet.php  Z  ,  (   a:1:{s:9:"mime-type";s:10:"text/plain";}&   lib/CMSMS/Database/class.Statement.php0  Z0  &D,  (   a:1:{s:9:"mime-type";s:10:"text/plain";}+   lib/CMSMS/Database/class.ConnectionSpec.php  Z  A  (   a:1:{s:9:"mime-type";s:10:"text/plain";}-   lib/Smarty/plugins/modifier.regex_replace.php  Z  n  (   a:1:{s:9:"mime-type";s:10:"text/plain";}4   lib/Smarty/plugins/shared.literal_compiler_param.php  Z    (   a:1:{s:9:"mime-type";s:10:"text/plain";}3   lib/Smarty/plugins/modifiercompiler.count_words.php  Z  9  (   a:1:{s:9:"mime-type";s:10:"text/plain";}8   lib/Smarty/plugins/modifiercompiler.count_paragraphs.php  Z  u  (   a:1:{s:9:"mime-type";s:10:"text/plain";}*   lib/Smarty/plugins/function.html_table.php/  Z/  @  (   a:1:{s:9:"mime-type";s:10:"text/plain";}7   lib/Smarty/plugins/modifiercompiler.count_sentences.php  Z  0  (   a:1:{s:9:"mime-type";s:10:"text/plain";}0   lib/Smarty/plugins/modifiercompiler.unescape.php(  Z(  3Qڶ  (   a:1:{s:9:"mime-type";s:10:"text/plain";}/   lib/Smarty/plugins/modifier.debug_print_var.phpD  ZD  7  (   a:1:{s:9:"mime-type";s:10:"text/plain";}8   lib/Smarty/plugins/modifiercompiler.count_characters.php  Z  ".*^  (   a:1:{s:9:"mime-type";s:10:"text/plain";}$   lib/Smarty/plugins/function.math.phpW  ZW  ^.i  (   a:1:{s:9:"mime-type";s:10:"text/plain";}2   lib/Smarty/plugins/modifiercompiler.to_charset.phpS  ZS    (   a:1:{s:9:"mime-type";s:10:"text/plain";}-   lib/Smarty/plugins/modifiercompiler.lower.php8  Z8  	Xu  (   a:1:{s:9:"mime-type";s:10:"text/plain";}2   lib/Smarty/plugins/modifiercompiler.strip_tags.php  Z  o  (   a:1:{s:9:"mime-type";s:10:"text/plain";}/   lib/Smarty/plugins/modifiercompiler.noprint.php  Z  2  (   a:1:{s:9:"mime-type";s:10:"text/plain";}&   lib/Smarty/plugins/function.mailto.php8  Z8  Jӝ  (   a:1:{s:9:"mime-type";s:10:"text/plain";}4   lib/Smarty/plugins/modifiercompiler.from_charset.phpY  ZY  gplǶ  (   a:1:{s:9:"mime-type";s:10:"text/plain";}-   lib/Smarty/plugins/modifiercompiler.strip.php4  Z4  ߹׶  (   a:1:{s:9:"mime-type";s:10:"text/plain";}.   lib/Smarty/plugins/modifiercompiler.indent.php  Z  F  (   a:1:{s:9:"mime-type";s:10:"text/plain";}*   lib/Smarty/plugins/function.html_image.php  Z    (   a:1:{s:9:"mime-type";s:10:"text/plain";}'   lib/Smarty/plugins/block.textformat.php  Z  Ѷ  (   a:1:{s:9:"mime-type";s:10:"text/plain";}'   lib/Smarty/plugins/function.counter.php&  Z&  Q*N  (   a:1:{s:9:"mime-type";s:10:"text/plain";}0   lib/Smarty/plugins/function.html_select_time.php3  Z3  a7&ٶ  (   a:1:{s:9:"mime-type";s:10:"text/plain";}2   lib/Smarty/plugins/outputfilter.trimwhitespace.php  Z  	:  (   a:1:{s:9:"mime-type";s:10:"text/plain";}-   lib/Smarty/plugins/modifiercompiler.upper.php  Z  j  (   a:1:{s:9:"mime-type";s:10:"text/plain";}6   lib/Smarty/plugins/variablefilter.htmlspecialchars.php  Z  nr  (   a:1:{s:9:"mime-type";s:10:"text/plain";}(   lib/Smarty/plugins/modifier.truncate.php  Z  V\  (   a:1:{s:9:"mime-type";s:10:"text/plain";}'   lib/Smarty/plugins/modifier.replace.php  Z  r  (   a:1:{s:9:"mime-type";s:10:"text/plain";},   lib/Smarty/plugins/shared.mb_str_replace.php  Z  ";`  (   a:1:{s:9:"mime-type";s:10:"text/plain";}+   lib/Smarty/plugins/modifier.date_format.phpb  Zb  !  (   a:1:{s:9:"mime-type";s:10:"text/plain";}/   lib/Smarty/plugins/modifiercompiler.default.php3  Z3  /  (   a:1:{s:9:"mime-type";s:10:"text/plain";}0   lib/Smarty/plugins/modifiercompiler.wordwrap.phpx  Zx   @yI  (   a:1:{s:9:"mime-type";s:10:"text/plain";},   lib/Smarty/plugins/function.html_options.php  Z  ^.Ͷ  (   a:1:{s:9:"mime-type";s:10:"text/plain";}.   lib/Smarty/plugins/modifiercompiler.escape.php
  Z
  h  (   a:1:{s:9:"mime-type";s:10:"text/plain";}%   lib/Smarty/plugins/function.fetch.php!  Z!  wy  (   a:1:{s:9:"mime-type";s:10:"text/plain";}/   lib/Smarty/plugins/function.html_checkboxes.php  Z  %Ƕ  (   a:1:{s:9:"mime-type";s:10:"text/plain";}*   lib/Smarty/plugins/modifier.capitalize.phpu
  Zu
  `=ᑶ  (   a:1:{s:9:"mime-type";s:10:"text/plain";}'   lib/Smarty/plugins/modifier.spacify.php  Z  V  (   a:1:{s:9:"mime-type";s:10:"text/plain";}0   lib/Smarty/plugins/function.html_select_date.phpO8  ZO8  +"  (   a:1:{s:9:"mime-type";s:10:"text/plain";}+   lib/Smarty/plugins/modifiercompiler.cat.php  Z  a碶  (   a:1:{s:9:"mime-type";s:10:"text/plain";}5   lib/Smarty/plugins/modifiercompiler.string_format.phpb  Zb  wyJ  (   a:1:{s:9:"mime-type";s:10:"text/plain";}2   lib/Smarty/plugins/shared.escape_special_chars.php  Z  ~  (   a:1:{s:9:"mime-type";s:10:"text/plain";}+   lib/Smarty/plugins/function.html_radios.phpb  Zb  uq  (   a:1:{s:9:"mime-type";s:10:"text/plain";}(   lib/Smarty/plugins/shared.mb_unicode.php  Z  -˶  (   a:1:{s:9:"mime-type";s:10:"text/plain";}&   lib/Smarty/plugins/modifier.escape.php  Z     (   a:1:{s:9:"mime-type";s:10:"text/plain";},   lib/Smarty/plugins/shared.make_timestamp.php  Z  8q(  (   a:1:{s:9:"mime-type";s:10:"text/plain";})   lib/Smarty/plugins/shared.mb_wordwrap.php
  Z
  gÉ$  (   a:1:{s:9:"mime-type";s:10:"text/plain";}%   lib/Smarty/plugins/function.cycle.php  Z  3  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   lib/Smarty/SmartyBC.class.phpg2  Zg2  XT1  (   a:1:{s:9:"mime-type";s:10:"text/plain";}5   lib/Smarty/sysplugins/smarty_cacheresource_custom.php  Z  6q  (   a:1:{s:9:"mime-type";s:10:"text/plain";}:   lib/Smarty/sysplugins/smarty_internal_compile_function.php  Z  Fw  (   a:1:{s:9:"mime-type";s:10:"text/plain";}5   lib/Smarty/sysplugins/smarty_internal_compilebase.php  Z  hȶ  (   a:1:{s:9:"mime-type";s:10:"text/plain";}/   lib/Smarty/sysplugins/smarty_internal_debug.php  Z  Ok  (   a:1:{s:9:"mime-type";s:10:"text/plain";})   lib/Smarty/sysplugins/smarty_security.phpS9  ZS9  Gö  (   a:1:{s:9:"mime-type";s:10:"text/plain";}I   lib/Smarty/sysplugins/smarty_internal_compile_private_function_plugin.php  Z  k@  (   a:1:{s:9:"mime-type";s:10:"text/plain";}9   lib/Smarty/sysplugins/smarty_internal_compile_foreach.php#  Z#    (   a:1:{s:9:"mime-type";s:10:"text/plain";}=   lib/Smarty/sysplugins/smarty_internal_resource_registered.php  Z  !`  (   a:1:{s:9:"mime-type";s:10:"text/plain";}<   lib/Smarty/sysplugins/smarty_cacheresource_keyvaluestore.php?  Z?  <[  (   a:1:{s:9:"mime-type";s:10:"text/plain";}J   lib/Smarty/sysplugins/smarty_internal_compile_private_special_variable.php
  Z
  Gm|  (   a:1:{s:9:"mime-type";s:10:"text/plain";}7   lib/Smarty/sysplugins/smarty_internal_compile_debug.php	  Z	  >;  (   a:1:{s:9:"mime-type";s:10:"text/plain";}:   lib/Smarty/sysplugins/smarty_internal_resource_extends.php  Z  ,  (   a:1:{s:9:"mime-type";s:10:"text/plain";}:   lib/Smarty/sysplugins/smarty_internal_get_include_path.php  Z  \~Z  (   a:1:{s:9:"mime-type";s:10:"text/plain";}6   lib/Smarty/sysplugins/smarty_internal_compile_call.phpc  Zc  ʼM  (   a:1:{s:9:"mime-type";s:10:"text/plain";}>   lib/Smarty/sysplugins/smarty_internal_config_file_compiler.php&  Z&  m}O  (   a:1:{s:9:"mime-type";s:10:"text/plain";}1   lib/Smarty/sysplugins/smarty_internal_utility.php_  Z_  l  (   a:1:{s:9:"mime-type";s:10:"text/plain";}4   lib/Smarty/sysplugins/smarty_resource_recompiled.php8  Z8  U  (   a:1:{s:9:"mime-type";s:10:"text/plain";})   lib/Smarty/sysplugins/smarty_resource.phpDj  ZDj  Ћ,ն  (   a:1:{s:9:"mime-type";s:10:"text/plain";}.   lib/Smarty/sysplugins/smarty_cacheresource.php;,  Z;,  iA޶  (   a:1:{s:9:"mime-type";s:10:"text/plain";}9   lib/Smarty/sysplugins/smarty_internal_compile_section.php
  Z
  8z  (   a:1:{s:9:"mime-type";s:10:"text/plain";}6   lib/Smarty/sysplugins/smarty_internal_compile_eval.php  Z  2l  (   a:1:{s:9:"mime-type";s:10:"text/plain";}4   lib/Smarty/sysplugins/smarty_resource_uncompiled.php  Z  <*  (   a:1:{s:9:"mime-type";s:10:"text/plain";}9   lib/Smarty/sysplugins/smarty_internal_resource_stream.php  Z  >I  (   a:1:{s:9:"mime-type";s:10:"text/plain";}O   lib/Smarty/sysplugins/smarty_internal_compile_private_object_block_function.phpA  ZA  C
e  (   a:1:{s:9:"mime-type";s:10:"text/plain";}4   lib/Smarty/sysplugins/smarty_internal_write_file.php  Z  ʶ  (   a:1:{s:9:"mime-type";s:10:"text/plain";}:   lib/Smarty/sysplugins/smarty_internal_compile_continue.php7	  Z7	  C#  (   a:1:{s:9:"mime-type";s:10:"text/plain";}B   lib/Smarty/sysplugins/smarty_internal_compile_private_modifier.phpb  Zb    (   a:1:{s:9:"mime-type";s:10:"text/plain";}8   lib/Smarty/sysplugins/smarty_internal_nocache_insert.php  Z  bD/  (   a:1:{s:9:"mime-type";s:10:"text/plain";}J   lib/Smarty/sysplugins/smarty_internal_compile_private_registered_block.php  Z  H  (   a:1:{s:9:"mime-type";s:10:"text/plain";};   lib/Smarty/sysplugins/smarty_internal_compile_setfilter.php  Z  QN  (   a:1:{s:9:"mime-type";s:10:"text/plain";}8   lib/Smarty/sysplugins/smarty_internal_compile_ldelim.php  Z  Dr>  (   a:1:{s:9:"mime-type";s:10:"text/plain";}<   lib/Smarty/sysplugins/smarty_internal_cacheresource_file.php'  Z'  3<  (   a:1:{s:9:"mime-type";s:10:"text/plain";}6   lib/Smarty/sysplugins/smarty_internal_templatebase.php+  Z+  ض  (   a:1:{s:9:"mime-type";s:10:"text/plain";}4   lib/Smarty/sysplugins/smarty_internal_compile_if.php"  Z"  ّ=}  (   a:1:{s:9:"mime-type";s:10:"text/plain";}7   lib/Smarty/sysplugins/smarty_internal_compile_break.php	  Z	  GK  (   a:1:{s:9:"mime-type";s:10:"text/plain";}8   lib/Smarty/sysplugins/smarty_internal_filter_handler.phpH
  ZH
  *8M  (   a:1:{s:9:"mime-type";s:10:"text/plain";}I   lib/Smarty/sysplugins/smarty_internal_compile_private_object_function.php	  Z	  #A!  (   a:1:{s:9:"mime-type";s:10:"text/plain";}8   lib/Smarty/sysplugins/smarty_internal_compile_append.php  Z  W  (   a:1:{s:9:"mime-type";s:10:"text/plain";}9   lib/Smarty/sysplugins/smarty_internal_compile_include.php&  Z&  -  (   a:1:{s:9:"mime-type";s:10:"text/plain";}9   lib/Smarty/sysplugins/smarty_internal_resource_string.php
  Z
    (   a:1:{s:9:"mime-type";s:10:"text/plain";}9   lib/Smarty/sysplugins/smarty_internal_configfilelexer.phpG  ZG  4WӶ  (   a:1:{s:9:"mime-type";s:10:"text/plain";}7   lib/Smarty/sysplugins/smarty_internal_compile_while.php
  Z
  p  (   a:1:{s:9:"mime-type";s:10:"text/plain";}.   lib/Smarty/sysplugins/smarty_config_source.php}  Z}  V`
  (   a:1:{s:9:"mime-type";s:10:"text/plain";}=   lib/Smarty/sysplugins/smarty_internal_compile_include_php.php  Z  [fW  (   a:1:{s:9:"mime-type";s:10:"text/plain";}8   lib/Smarty/sysplugins/smarty_internal_compile_insert.php`  Z`  !7  (   a:1:{s:9:"mime-type";s:10:"text/plain";}7   lib/Smarty/sysplugins/smarty_internal_compile_block.php)  Z)  Lƶ  (   a:1:{s:9:"mime-type";s:10:"text/plain";}6   lib/Smarty/sysplugins/smarty_internal_resource_php.php)  Z)  J  (   a:1:{s:9:"mime-type";s:10:"text/plain";}?   lib/Smarty/sysplugins/smarty_internal_function_call_handler.php	  Z	  R%;  (   a:1:{s:9:"mime-type";s:10:"text/plain";}9   lib/Smarty/sysplugins/smarty_internal_compile_nocache.php>  Z>  H  (   a:1:{s:9:"mime-type";s:10:"text/plain";}7   lib/Smarty/sysplugins/smarty_internal_resource_eval.php
  Z
  "  (   a:1:{s:9:"mime-type";s:10:"text/plain";}7   lib/Smarty/sysplugins/smarty_internal_templatelexer.phpI  ZI  X  (   a:1:{s:9:"mime-type";s:10:"text/plain";}M   lib/Smarty/sysplugins/smarty_internal_compile_private_registered_function.php  Z  Q   (   a:1:{s:9:"mime-type";s:10:"text/plain";}:   lib/Smarty/sysplugins/smarty_internal_configfileparser.phpJ  ZJ  5#  (   a:1:{s:9:"mime-type";s:10:"text/plain";}5   lib/Smarty/sysplugins/smarty_internal_compile_for.php  Z  1  (   a:1:{s:9:"mime-type";s:10:"text/plain";}8   lib/Smarty/sysplugins/smarty_internal_compile_assign.phpM  ZM  Pu  (   a:1:{s:9:"mime-type";s:10:"text/plain";}@   lib/Smarty/sysplugins/smarty_internal_smartytemplatecompiler.php  Z  ;o+  (   a:1:{s:9:"mime-type";s:10:"text/plain";}9   lib/Smarty/sysplugins/smarty_internal_compile_extends.php%  Z%  D3K  (   a:1:{s:9:"mime-type";s:10:"text/plain";}J   lib/Smarty/sysplugins/smarty_internal_compile_private_print_expression.php,  Z,  0  (   a:1:{s:9:"mime-type";s:10:"text/plain";}0   lib/Smarty/sysplugins/smarty_internal_config.php%  Z%  k   (   a:1:{s:9:"mime-type";s:10:"text/plain";}.   lib/Smarty/sysplugins/smarty_internal_data.phpB  ZB  hk  (   a:1:{s:9:"mime-type";s:10:"text/plain";}0   lib/Smarty/sysplugins/smarty_resource_custom.php(  Z(  p  (   a:1:{s:9:"mime-type";s:10:"text/plain";}8   lib/Smarty/sysplugins/smarty_internal_compile_rdelim.php  Z  F  (   a:1:{s:9:"mime-type";s:10:"text/plain";}>   lib/Smarty/sysplugins/smarty_internal_templatecompilerbase.phpto  Zto  R  (   a:1:{s:9:"mime-type";s:10:"text/plain";}7   lib/Smarty/sysplugins/smarty_internal_resource_file.php
  Z
  W  (   a:1:{s:9:"mime-type";s:10:"text/plain";}9   lib/Smarty/sysplugins/smarty_internal_compile_capture.php  Z  QUͶ  (   a:1:{s:9:"mime-type";s:10:"text/plain";}F   lib/Smarty/sysplugins/smarty_internal_compile_private_block_plugin.php6
  Z6
  
@  (   a:1:{s:9:"mime-type";s:10:"text/plain";}2   lib/Smarty/sysplugins/smarty_internal_template.phph  Zh  ڶ  (   a:1:{s:9:"mime-type";s:10:"text/plain";}3   lib/Smarty/sysplugins/smarty_internal_parsetree.phpC'  ZC'  R  (   a:1:{s:9:"mime-type";s:10:"text/plain";}=   lib/Smarty/sysplugins/smarty_internal_compile_config_load.phpz	  Zz	   i0  (   a:1:{s:9:"mime-type";s:10:"text/plain";}8   lib/Smarty/sysplugins/smarty_internal_templateparser.phpph Zph z2'  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   lib/Smarty/Smarty.class.php  Z  zA(h  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   lib/Smarty/debug.tpl/  Z/  r܍  (   a:1:{s:9:"mime-type";s:10:"text/plain";}
   README.TXT3  Z3  ^1d  (   a:1:{s:9:"mime-type";s:10:"text/plain";}	   index.php  Z  ^f  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/cli.php    Z    )M7  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/lang/app/ext/da_DK.php*   Z*   V  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/lang/app/ext/it_IT.php	  Z	  
p  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/lang/app/ext/ru_RU.phpy  Zy  ef  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/lang/app/ext/de_DE.php  Z    (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/lang/app/ext/nl_NL.phpW[  ZW[    (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/lang/app/ext/sv_SE.php  Z  +j  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/lang/app/ext/fr_FR.php  Z  r޶  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/lang/app/ext/sk_SK.phpC  ZC  5  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/lang/app/ext/pt_PT.php~  Z~  !  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/lang/app/ext/nb_NO.phpx  Zx  Zue  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/lang/app/en_US.phpGw  ZGw  vP  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/README.txt$  Z$  +l6  (   a:1:{s:9:"mime-type";s:10:"text/plain";}!   app/lib/class.manifest_reader.phpR  ZR  ,51  (   a:1:{s:9:"mime-type";s:10:"text/plain";}%   app/lib/class.install_filehandler.php[  Z[  W=  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/lib/class.wizard_step.phpQ  ZQ  Ū6  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/lib/class.filehandler.php  Z  v'u  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/lib/compat.functions.php   Z     (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/lib/class.utils.php
  Z
    (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/templates/wizard_step9.tpl  Z  iȮ  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/templates/wizard_step7.tpl  Z  I  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/templates/wizard_step1.tpl
  Z
  zf  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/templates/wizard_step8.tpl  Z  5ö  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/templates/wizard_step2.tpl  Z    (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/templates/error.tpl   Z   E  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/templates/index.tpl  Z  )z  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/templates/wizard_step4.tpl  Z    (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/templates/wizard_step5.tplp  Zp  .  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/templates/wizard_step.tpl{   Z{   i^  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/templates/wizard_step6.tpl  Z  X?_f  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/templates/wizard_step3.tpl
  Z
  E%  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/install/initial.php  Z  V  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/install/extra.php Z P  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/install/schema.phpig  Zig  o  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/install/base.phpV#  ZV#  .s~  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/install/createseq.phpi  Zi  p  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/class.cms_install.php2>  Z2>  (_׶  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/assets/images/favicon.ico~  Z~  gܶ  (   a:1:{s:9:"mime-type";s:10:"text/plain";}    app/assets/images/cmsms-logo.png  Z  06  (   a:1:{s:9:"mime-type";s:10:"text/plain";}"   app/assets/js/css3-mediaqueries.js[:  Z[:    (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/assets/js/functions.min.js{  Z{  Co  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/assets/js/html5.js}	  Z}	  J9  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/assets/js/functions.js
  Z
  T  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/assets/css/install.css-g  Z-g  &6b  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/assets/fonts/cmsms-ui.svg  Z  -@  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/assets/fonts/cmsms-ui.eot|
  Z|
  #  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/assets/fonts/selection.jsonm(  Zm(   =  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/assets/fonts/cmsms-ui.ttf  Z  1  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/assets/fonts/cmsms-ui.woff
  Z
  =  (   a:1:{s:9:"mime-type";s:10:"text/plain";}L   app/assets/vendor/jquery-ui/images/ui-bg_highlight-soft_100_eeeeee_1x100.png=  Z=   5  (   a:1:{s:9:"mime-type";s:10:"text/plain";}I   app/assets/vendor/jquery-ui/images/ui-bg_gloss-wave_35_f6a828_500x100.png  Z  K,;  (   a:1:{s:9:"mime-type";s:10:"text/plain";}>   app/assets/vendor/jquery-ui/images/ui-icons_228ef1_256x240.png  Z  $ﳶ  (   a:1:{s:9:"mime-type";s:10:"text/plain";}K   app/assets/vendor/jquery-ui/images/ui-bg_highlight-soft_75_ffe45c_1x100.pngo  Zo  f  (   a:1:{s:9:"mime-type";s:10:"text/plain";}B   app/assets/vendor/jquery-ui/images/ui-bg_glass_65_ffffff_1x400.png   Z   %;%  (   a:1:{s:9:"mime-type";s:10:"text/plain";}>   app/assets/vendor/jquery-ui/images/ui-icons_ef8c08_256x240.png  Z  =  (   a:1:{s:9:"mime-type";s:10:"text/plain";}B   app/assets/vendor/jquery-ui/images/ui-bg_flat_10_000000_40x100.png   Z     (   a:1:{s:9:"mime-type";s:10:"text/plain";}>   app/assets/vendor/jquery-ui/images/ui-icons_ffd27a_256x240.png  Z  \  (   a:1:{s:9:"mime-type";s:10:"text/plain";}C   app/assets/vendor/jquery-ui/images/ui-bg_glass_100_f6f6f6_1x400.png-  Z-  ޶  (   a:1:{s:9:"mime-type";s:10:"text/plain";}L   app/assets/vendor/jquery-ui/images/ui-bg_diagonals-thick_20_666666_40x40.png_  Z_  $ٶ  (   a:1:{s:9:"mime-type";s:10:"text/plain";}C   app/assets/vendor/jquery-ui/images/ui-bg_glass_100_fdf5ce_1x400.png  Z  Η  (   a:1:{s:9:"mime-type";s:10:"text/plain";}>   app/assets/vendor/jquery-ui/images/ui-icons_222222_256x240.png^  Z^  C[Z  (   a:1:{s:9:"mime-type";s:10:"text/plain";}>   app/assets/vendor/jquery-ui/images/ui-icons_ffffff_256x240.pngD  ZD  `   (   a:1:{s:9:"mime-type";s:10:"text/plain";}L   app/assets/vendor/jquery-ui/images/ui-bg_diagonals-thick_18_b81900_40x40.png  Z  <  (   a:1:{s:9:"mime-type";s:10:"text/plain";}-   app/assets/vendor/jquery-ui/jquery-ui.min.cssu  Zu  6E  (   a:1:{s:9:"mime-type";s:10:"text/plain";},   app/assets/vendor/jquery-ui/jquery-ui.min.jş Z̧ 8=o&  (   a:1:{s:9:"mime-type";s:10:"text/plain";}&   app/assets/vendor/jquery-1.11.2.min.jsv Zv oY  (   a:1:{s:9:"mime-type";s:10:"text/plain";}!   app/wizard/class.wizard_step9.php$  Z$  v  (   a:1:{s:9:"mime-type";s:10:"text/plain";}!   app/wizard/class.wizard_step1.php:  Z:  wfx=  (   a:1:{s:9:"mime-type";s:10:"text/plain";}!   app/wizard/class.wizard_step6.php
  Z
  g  (   a:1:{s:9:"mime-type";s:10:"text/plain";}!   app/wizard/class.wizard_step7.php  Z  B  (   a:1:{s:9:"mime-type";s:10:"text/plain";}!   app/wizard/class.wizard_step8.php
*  Z
*  Lg  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/wizard/msg_functions.phpC  ZC  vKm  (   a:1:{s:9:"mime-type";s:10:"text/plain";}&   app/wizard/.class.wizard_step3.php.swp P  Z P  H  (   a:1:{s:9:"mime-type";s:10:"text/plain";}!   app/wizard/class.wizard_step5.php  Z  Eж  (   a:1:{s:9:"mime-type";s:10:"text/plain";}!   app/wizard/class.wizard_step3.phpA  ZA  c  (   a:1:{s:9:"mime-type";s:10:"text/plain";}!   app/wizard/class.wizard_step4.php1!  Z1!  E  (   a:1:{s:9:"mime-type";s:10:"text/plain";}!   app/wizard/class.wizard_step2.phpl  Zl  @9  (   a:1:{s:9:"mime-type";s:10:"text/plain";}!   app/upgrade/2.2.7/MANIFEST.DAT.gz#  Z#  _  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/upgrade/2.2.7/changelog.txt?  Z?  56  (   a:1:{s:9:"mime-type";s:10:"text/plain";}!   app/upgrade/2.2.3/MANIFEST.DAT.gz  Z  (͙~  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/upgrade/2.2.3/changelog.txt   Z     (   a:1:{s:9:"mime-type";s:10:"text/plain";}!   app/upgrade/2.1.4/MANIFEST.DAT.gz  Z  ~x  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/upgrade/2.1.4/changelog.txt_  Z_  R(K	  (   a:1:{s:9:"mime-type";s:10:"text/plain";}!   app/upgrade/2.2.5/MANIFEST.DAT.gzK  ZK  ,  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/upgrade/2.2.5/changelog.txt  Z  R  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/upgrade/2.0/upgrade.phpY  ZY  /%T  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/upgrade/2.0/MANIFEST.DAT.gz^  Z^  3ā  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/upgrade/2.0/readme.txt!(  Z!(  >T  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/upgrade/2.0/tmp.txt    Z          (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/upgrade/2.1.5/upgrade.php  Z  ض  (   a:1:{s:9:"mime-type";s:10:"text/plain";}!   app/upgrade/2.1.5/MANIFEST.DAT.gz  Z  43  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/upgrade/2.1.5/changelog.txt;  Z;    (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/upgrade/2.2/upgrade.phpS	  ZS	  O	G  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/upgrade/2.2/MANIFEST.DAT.gzk  Zk  j{  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/upgrade/2.2/changelog.txt#6  Z#6  <l  (   a:1:{s:9:"mime-type";s:10:"text/plain";}#   app/upgrade/2.0.1.1/MANIFEST.DAT.gz   Z   V8  (   a:1:{s:9:"mime-type";s:10:"text/plain";}!   app/upgrade/2.0.1.1/changelog.txt   Z   4  (   a:1:{s:9:"mime-type";s:10:"text/plain";}#   app/upgrade/2.2.3.1/MANIFEST.DAT.gz  Z  Z  (   a:1:{s:9:"mime-type";s:10:"text/plain";}!   app/upgrade/2.2.3.1/changelog.txt   Z   ELf#  (   a:1:{s:9:"mime-type";s:10:"text/plain";}!   app/upgrade/2.1.6/MANIFEST.DAT.gz%  Z%    (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/upgrade/2.1.6/changelog.txtx  Zx  c  (   a:1:{s:9:"mime-type";s:10:"text/plain";}!   app/upgrade/2.1.3/MANIFEST.DAT.gz$  Z$  "`  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/upgrade/2.1.3/changelog.txt  Z  w  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/upgrade/2.2.1/upgrade.php  Z  TX  (   a:1:{s:9:"mime-type";s:10:"text/plain";}!   app/upgrade/2.2.1/MANIFEST.DAT.gz  Z    (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/upgrade/2.2.1/changelog.txt  Z  K  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/upgrade/2.2.2/upgrade.php.  Z.  \~U  (   a:1:{s:9:"mime-type";s:10:"text/plain";}!   app/upgrade/2.2.2/MANIFEST.DAT.gzk  Zk    (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/upgrade/2.2.2/changelog.txt	  Z	  ӌ  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/upgrade/2.2.2/readme.txth
  Zh
  b(t  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/upgrade/2.0.1/upgrade.php   Z   W  (   a:1:{s:9:"mime-type";s:10:"text/plain";}!   app/upgrade/2.0.1/MANIFEST.DAT.gzG  ZG  u  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/upgrade/2.0.1/changelog.txt
  Z
  =  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/upgrade/2.0.1/readme.txtX
  ZX
  @  (   a:1:{s:9:"mime-type";s:10:"text/plain";}!   app/upgrade/2.2.6/MANIFEST.DAT.gz"  Z"    (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/upgrade/2.2.6/changelog.txt  Z  vi  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/upgrade/2.2.4/upgrade.php1  Z1  #0  (   a:1:{s:9:"mime-type";s:10:"text/plain";}!   app/upgrade/2.2.4/MANIFEST.DAT.gz
  Z
  sDD  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/upgrade/2.2.4/changelog.txt    Z          (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/upgrade/2.1.2/upgrade.php  Z  yն  (   a:1:{s:9:"mime-type";s:10:"text/plain";}!   app/upgrade/2.1.2/MANIFEST.DAT.gz+  Z+  6V3  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/upgrade/2.1.2/changelog.txt  Z  Q  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/upgrade/2.1.1/upgrade.php  Z  hȶ  (   a:1:{s:9:"mime-type";s:10:"text/plain";}!   app/upgrade/2.1.1/MANIFEST.DAT.gz  Z  `  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/upgrade/2.1.1/changelog.txt  Z  w  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/upgrade/2.1.1/readme.txt[  Z[  Gv)/  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/upgrade/2.1/upgrade.php  Z    (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/upgrade/2.1/MANIFEST.DAT.gz  Z  h  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/upgrade/2.1/changelog.txt  Z  9x  (   a:1:{s:9:"mime-type";s:10:"text/plain";}
   app/build.iniO   ZO   |  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   app/config.ini   Z     (   a:1:{s:9:"mime-type";s:10:"text/plain";}   README-PHAR.TXT-4  Z-4  x  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   data/version.phpz  Zz  kǶ  (   a:1:{s:9:"mime-type";s:10:"text/plain";}   data/data.tar.gzo@ Zo@ ^ܶ  (   a:1:{s:9:"mime-type";s:10:"text/plain";}[settings]
dest=/var/www/html/cms2_tmp
dbname=foobar
sitename="this is a test";
<?php

namespace __appbase;

class wizard
{
  private static $_instance = null;
  private $_name = null;
  private $_stepvar = 's';
  private $_steps;
  private $_stepobj;
  private $_classdir;
  private $_namespace;
  private $_initialized;

  const STATUS_OK    = 'OK';
  const STATUS_ERROR = 'ERROR';
  const STATUS_BACK  = 'BACK';
  const STATUS_NEXT  = 'NEXT';

  private function __construct($classdir,$namespace)
  {
    $this->_namespace = $namespace;
    if( !is_dir($classdir) ) throw new \Exception('Could not find wizard steps in '.$classdir);

    $this->_classdir = $classdir;
    $this->_name = basename($classdir);

  }

  final public static function &get_instance($classdir = '', $namespace = '')
  {
    if( !self::$_instance ) self::$_instance = new wizard($classdir,$namespace);
    return self::$_instance;
  }

  private function _init()
  {
      if( $this->_initialized ) return;
      $this->_initialized = true;

      // find all of the classes in the wizard directory.
      $di = new \DirectoryIterator($this->_classdir);
      $ri = new \RegexIterator($di,'/^class\.wizard.*\.php$/');
      $files = array();
      foreach( $ri as $one ) {
          $files[] = $one->getFilename();
      }
      if( !count($files) ) throw new \Exception('Could not find wizard steps in '.$classdir);
      sort($files);

      $_data = array();
      for( $i = 0; $i < count($files); $i++ ) {
          $idx = $i+1;
          $filename = $files[$i];
          $classname = substr($filename,6,strlen($filename)-10);
          $rec = array('fn'=>$filename,'class'=>'','name'=>'','description'=>'','active'=>'');
          $fullclass = $classname;

          if( $this->_namespace ) $fullclass = $this->_namespace.'\\'.$classname;
          $rec['classname'] = $classname;
          $rec['class'] = $fullclass;
          $rec['active'] = ($idx == $this->cur_step())?1:0;
          $_data[$idx] = $rec;
      }
      $this->_steps = $_data;
  }

  final public function get_nav()
  {
    $this->_init();
    return $this->_steps;
  }

  final public function get_step_var()
  {
    return $this->_stepvar;
  }

  final public function set_step_var($str)
  {
    if( $str ) $this->_stepvar = $str;
  }

  final public function cur_step()
  {
    $val = 1;
    if( $this->_stepvar && isset($_GET[$this->_stepvar]) ) $val = (int)$_GET[$this->_stepvar];
    return $val;
  }

  final public function finished()
  {
    $this->_init();
    return $this->cur_step() > $this->num_steps();
  }

  final public function num_steps()
  {
    $this->_init();
    return count($this->_steps);
  }

  final public function &get_step()
  {
    $this->_init();
    if( is_object($this->_stepobj) ) return $this->_stepobj;

    $rec = $this->_steps[$this->cur_step()];
    if( isset($rec['class']) && class_exists($rec['class']) ) {
      $obj = new $rec['class'];
      if( is_object($obj) ) {
	$this->_stepobj = $obj;
	return $obj;
      }
    }
  }

  public function get_data($key,$dflt = null)
  {
      $sess = session::get();
      if( !isset($sess[$key]) ) return $dflt;
      return $sess[$key];
  }

  public function set_data($key,$value)
  {
      $sess = session::get();
      $sess[$key] = $value;
  }

  public function clear_data($key)
  {
      $sess = session::get();
      if( isset($sess[$key]) ) unset($sess[$key]);
  }

  public function process()
  {
      $this->_init();
      $res = $this->get_step()->run();
      return $res;
  }

  final public function step_url($idx)
  {
      $this->_init();

      // get the url to the specified step index
      $idx = (int)$idx;
      if( $idx < 1 || $idx > $this->num_steps() ) return;

      $request = request::get();
      $url = $request->raw_server('REQUEST_URI');
      $urlmain = explode('?',$url);

      $parts = parse_str($url);
      $parts[$this->_stepvar] = $idx;

      $tmp = array();
      foreach( $parts as $k => $v ) {
          $tmp[] = $k.'='.$v;
      }
      $url = $urlmain[0].'?'.implode('&',$tmp);
      return $url;
  }

  final public function next_url()
  {
      $this->_init();
      $request = request::get();
      $url = $request->raw_server('REQUEST_URI');
      $urlmain = explode('?',$url);

      $parts = parse_str($url);
      $parts[$this->_stepvar] = $this->cur_step() + 1;
      if( $parts[$this->_stepvar] > $this->num_steps() ) return;

      $tmp = array();
      foreach( $parts as $k => $v ) {
          $tmp[] = $k.'='.$v;
      }
      $url = $urlmain[0].'?'.implode('&',$tmp);
      return $url;
  }

  final public function prev_url()
  {
      $this->_init();
      $request = request::get();
      $url = $request->raw_server('REQUEST_URI');
      $urlmain = explode('?',$url);

      $parts = parse_str($url);
      $parts[$this->_stepvar] = $this->cur_step() - 1;
      if( $parts[$this->_stepvar] <= 0 ) return;

      $tmp = array();
      if( count($parts) ) {
          foreach( $parts as $k => $v ) {
              $tmp[] = $k.'='.$v;
          }
      }
      $url = $urlmain[0].'?'.implode('&',$tmp);
      return $url;
  }

} // end of class
?><?php

namespace __appbase;

abstract class nls
{
  protected $_isocode;
  protected $_locale;
  protected $_fullname;
  protected $_encoding;
  protected $_aliases;
  protected $_display;

  abstract public function __construct();

  public function matches($str)
  {
    if( $str == $this->name() ) return TRUE;
    if( $str == $this->locale() ) return TRUE;
    if( $str == $this->isocode() ) return TRUE;
    if( $str == $this->fullname() ) return TRUE;
    $aliases = $this->aliases();
    if( !is_array($aliases) ) $aliases = explode(',',$aliases);
    if( is_array($aliases) && count($aliases) )
      {
	for( $i = 0; $i < count($aliases); $i++ )
	  {
	    if( $aliases[$i] == $str ) return TRUE;
	  }
      }
    return FALSE;
  }

  public function name()
  {
    $name = get_class();
    if( endswith($name,'_nls') )
      {
	$name = substr($name,0,strlen($name)-4);
      }
    return $name;
  }

  public function isocode()
  {
    if( !$this->_isocode )
      {
	return substr($this->name,0,2);
      }
    return $this->_isocode;
  }

  public function display()
  {
    if( !$this->_display )
      {
	return $this->fullname();
      }
    return $this->_display;
  }

  public function locale()
  {
    if( !$this->_locale )
      return $this->name();
    return $this->_locale;
  }

  public function encoding()
  {
    if( !$this->_encoding )
      return 'UTF-8';
    return $this->_encoding;
  }

  public function fullname()
  {
    if( !$this->_fullname ) return $this->name();
    return $this->_fullname;
  }

  public function aliases()
  {
    if( $this->_aliases )
      {
	if( is_array($this->_aliases) )
	  return $this->_aliases;
	return explode(',',$this->_aliases);
      }
  }

} // end of class
?><?php

namespace __appbase;

class langtools_Exception extends \Exception {}

class langtools
{
  const DFLT_REALM = '__:DFLT:__';
  private static $_instance;
  private $_allowed_languages;
  private $_dflt_language;
  private $_cur_language;
  private $_langdata;
  private $_realm = '__:DFLT:__';

  protected function __construct() {}

  public static function &get_instance()
  {
    if( !is_object(self::$_instance) ) self::$_instance = new langtools();
    return self::$_instance;
  }


  public static function set_translator(langtools &$obj)
  {
    self::$_instance = $obj;
  }


  /**
   * Get the language(s) that the browser allows
   *
   * @return array of hashes.  Each element of the array will have members lang, and priority, where priority is between 0 and 1
   */
  final public static function get_browser_langs()
  {
    $request = request::get();
    $langs = $request->accept_language();
    $tmp = explode(',',$langs);

    $out = array();
    for( $i = 0; $i < count($tmp); $i++ ) {
      $tmp2 = explode(';q=',$tmp[$i],2);
      if( $tmp2[0] == '' || $tmp2[0] == '*' ) continue;
      $priority = 1;
      if( isset($tmp2[1]) && $tmp2[1] != '' ) $priority = floatval($tmp2[1]);
      $out[] = array('lang'=>$tmp2[0],'priority'=>$priority);
    }

    // todo: sort by priority.
    return $out;
  }


  /**
   * Test if a language is available
   *
   * @param string The language naem
   * @return boolean
   */
  final public function language_available($str)
  {
    $tmp = nlstools::get_instance()->find($str);
    if( is_object($tmp) ) return TRUE;
    return FALSE;
  }


  /**
   * Get the list of available languages
   *
   * @return array of available languages
   */
  final public function get_available_languages()
  {
    die('not implemented');
  }


  /**
   * Set the allowed languages.
   *
   * @param mixed String of comma delimited languages, or array of languages
   * @return void
   */
  final public function set_allowed_languages($data)
  {
    if( !is_array($data) ) $data = explode(',',$data);

    $out = array();
    for( $i = 0; $i < count($data); $i++ ) {
      if( $this->language_available($data[$i]) )  $out[] = $data[$i];
    }

    if( count($out) == 0 ) throw new langtools_Exception('set_allowed_languages no matches with available languages');

    $this->_allowed_languages = $out;
  }


  /**
   * Get list of allowed languages
   *
   * @return array of language strings
   */
  final public function get_allowed_languages()
  {
    return $this->_allowed_languages;
  }


  /**
   * Test if a language is allowed
   *
   * @param string language string
   * @return boolean TRUE if no allowed languages are set, TRUE if the specified language is allowed, false if not in the allowed list.
   */
  final public function language_allowed($str)
  {
    if( is_array($this->_allowed_languages) && count($this->_allowed_languages) ) {
      if( in_array($str,$this->_allowed_languages) ) return TRUE;
      return FALSE;
    }
    return TRUE;
  }


  /**
   * Find the first allowed language that the browser supports
   *
   * @return mixed lang string, or null
   */
  final public function match_browser_lang()
  {
    $langs = $this->get_browser_langs();
    if( is_array($langs) && count($langs) ) {
      for( $i = 0; $i < count($langs); $i++ ) {
	$obj = nlstools::get_instance()->find($langs[$i]['lang']); // does alias lookup.
	if( $obj ) {
	  // it's available... now check if it's allowed.
	  if( $this->language_allowed($obj->name()) ) return $obj->name();
	}
      }
    }
  }


  /**
   * Set the default language
   * Throws an exception if the specified language is not available, or not allowed.
   *
   * @param string language name.
   * @return void
   */
  final public function set_default_language($str)
  {
    if( !$this->language_available($str) || !$this->language_allowed($str) ) {
      throw new langtools_Exception('default language is not in list of allowed langages');
    }

    $this->_dflt_language = $str;
  }


  /**
   * Get the default language
   * Throws an exception of no default language has been set.
   *
   * @return string
   */
  final public function get_default_language()
  {
    if( !$this->_dflt_language ) throw new langtools_Exception('cannot get the default language, if it is not set');

    return $this->_dflt_language;
  }


  /**
   * Get the users selected language.  May use advanced methods to store the users selected language
   * or retrieve it from cookies, session variables, or the request.
   *
   * @virtual
   * @return string
   */
  public function get_selected_language()
  {
    $request = request::get();
    $session = session::get();

    // get the users preferred language.
    $lang = null;
    if( isset($request['curlang']) ) $lang = $request['curlang']; // it's stored in the get (or post)
    if( !$lang && isset($session['current_language']) )	$lang = $session['current_language']; // it's stored in the session
    if( !$lang ) $lang = $this->match_browser_lang(); // not set anywhere. get it from the browser.

    // match available languages.
    return $lang;
  }


  /**
   * Set the current language
   * Throws a new exception if the specified language is not available or allowed
   * This method sets the 'current' language, and also updates the locale for the selected language.
   *
   * @virtual
   * @param string the requested language
   */
  public function set_current_language($str)
  {
    if( !$this->language_available($str) || !$this->language_allowed($str) ) {
      throw new langtools_Exception('default language is not in list of allowed langages');
    }

    $this->_cur_language = $str;
    $obj = nlstools::get_instance()->find($str);
    $locale = $obj->locale();
    if( !is_array($locale) ) $locale = explode(',',$locale);
    $old = setlocale(LC_ALL,'0');
    $tmp = setlocale(LC_ALL,$locale);
    if( $tmp === FALSE ) setlocale(LC_ALL,$old);
  }


  /**
   * Get the current language
   * Throws an exception if the current language and the default language has not been set
   *
   * @virtual
   * @returns string The current language, if set, otherwise the default language.
   */
  public function get_current_language()
  {
    if( !$this->_cur_language ) {
      if( !$this->_dflt_language ) throw new langtools_Exception('cannot get language, no default set');
      return $this->_dflt_language;
    }
    return $this->_cur_language;
  }

  /**
   * Get a hash of languages suitable for display in a dropdown
   *
   * @virtual
   * @returns a hash
   */
  public function get_language_list($langs)
  {
    $outp = null;
    foreach( $langs as $one ) {
      $tmp = nls()->find($one);
      if( !is_object($tmp) ) continue;

      if( !is_array($outp) ) $outp = array();
      $outp[$one] = $tmp->display();
    }
    return $outp;
  }

  /**
   * Set the selected language
   * This method may store the selected language in the session, or a cookie etc.
   *
   * @virtual
   * @param string The user selected language
   */
  public function set_selected_language($str)
  {
    if( !$this->language_available($str) ) throw new langtools_Exception('cannot set selected language to a language that is not available');
    if( !$this->language_allowed($str) ) throw new langtools_Exception('cannot set selected language to a language that is not allowed');

    $session = session::get();
    $session['current_language'] = $str;
    $this->set_current_language($str);
  }

  /**
   * Set the language realm
   *
   * @param string the realm name, if empty the default realm will be used.
   */
  final public function set_realm($str = '')
  {
    if( !$str ) $str = self::DFLT_REALM;
    $this->_realm = $realm;
  }

  /**
   * Return the current realm name
   *
   * @return string
   */
  final public function get_realm()
  {
    return $this->_realm;
  }


  /**
   * Return the absolute path to the language directory.
   * Throws an exception if the realm directory does not exist.
   *
   * @param string The realm name.  If empty, the default realm can be assumed.
   * @returns string
   */
  public function get_lang_dir($realm = '')
  {
    if( !$realm ) $realm = self::DFLT_REALM;
    if( $realm == self::DFLT_REALM ) $realm = 'app';
    $dir = app::get_appdir()."/lang/$realm";
    if( !is_dir($dir) )	throw new langtools_Exception('Language directory '.$dir.' not found');

    return $dir;
  }


  /**
   * Load a language realm.
   *
   * @param string, The realm name.  If empty the default realm is assumed.
   * @return array of translated lang strings.
   */
  public function load_realm($realm = '')
  {
    // load the realm.
    $fns = array();
    $fns[] = $this->get_lang_dir($realm)."/en_US.php";
    $fns[] = $this->get_lang_dir($realm)."/ext/".$this->get_current_language().'.php';
    $fns[] = $this->get_lang_dir($realm)."/custom/".$this->get_current_language().'.php';

    $lang = array();
    foreach( $fns as $fn ) {
      if( file_exists($fn) ) include_once($fn);
    }

    return $lang;
  }

  /**
   * Unload the realm
   *
   * @param string, The realm name. If empty, the default realm is assumed.
   */
  public function unload_realm($realm = '')
  {
    if( !$realm ) $realm = self::DFLT_REALM;
    if( isset($this->_langdata[$realm]) ) unset($this->_langdata[$realm]);
  }

  /**
   * Translate a string
   * uses the current realm, and the currently selected language.
   *
   * @param mixed - uses sprintf formatting,
   * @return string
   */
  public function translate()
  {
    $args = func_get_args();
    if( count($args) == 0 ) return;
    if( count($args) == 1 && is_array($args[0]) ) $args = $args[0];

    if( !$this->_langdata ) $this->_langdata = array();
    if( !isset($this->_langdata[$this->_realm]) ) $this->_langdata[$this->_realm] = $this->load_realm($this->_realm);

    // check to see if the key is available.
    $key = array_shift($args);
    if( !$key ) return;

    if( !isset($this->_langdata[$this->_realm][$key]) ) {
      return '-- Missing Languagestring - '.$key.' --';
    }
    else if( count($args) ) {
      return vsprintf($this->_langdata[$this->_realm][$key], $args);
    }
    else {
      return $this->_langdata[$this->_realm][$key];
    }
  }
} // end of class


function lang()
{
  try {
    $args = func_get_args();
    return langtools::get_instance()->translate($args);
  }
  catch( Exception $e ) {
    // nothing here.
  }
}

?><?php

namespace __appbase\tests;

// just like a boolean test, but uses TEST_WARN instaed of TESt_FAIL
class warning_test extends test_base
{
  private $_data = array();

  public function __construct($name,$value)
  {
    $value = (bool)$value;
    parent::__construct($name,$value);
  }

  public function execute()
  {
    $val = \__appbase\utils::to_bool($this->value);
    if( $val ) return self::TEST_PASS;
    return self::TEST_WARN;
  }
}
<?php

namespace __appbase\tests;

class matchall_test extends test_base
{
    private $_children;

    public function __construct($name)
    {
        parent::__construct($name,'');
    }

    public function add_child(test_base $obj)
    {
        if( !is_array($this->_children) ) $this->_children = array();
        $this->_children[] = $obj;
    }


    public function __set($key,$value)
    {
        switch( $key ){
        case 'minimum':
        case 'maximum':
        case 'recommended':
        case 'success_key':
        case 'pass_key':
        case 'fail_key':
            $this->$key = $value;
            break;

        default:
            parent::__set($key,$value);
        }
    }

    public function execute()
    {
        $out = self::TEST_PASS;
        if( count($this->_children) ) {
            for( $i = 0; $i < count($this->_children); $i++ ) {
                $res = $this->_children[$i]->run();
                if( $res == self::TEST_FAIL ) {
                    // test failed.... if this test is not required, we can continue
                    if( $this->required ) return $res;
                    $out = self::TEST_WARN;
                }
            }
        }
        return $out;
    }

    public function msg()
    {
        switch( $this->status ) {
        case self::TEST_FAIL:
            for( $i = 0; $i < count($this->_children); $i++ ) {
                $obj = $this->_children[$i];
                if( $obj->status == self::TEST_FAIL ) {
                    if( $obj->fail_msg ) return $obj->fail_msg;
                    if( $obj->fail_key ) return \__appbase\lang($obj->fail_key);
                }
            }
            break;

        case self::TEST_WARN:
            for( $i = 0; $i < count($this->_children); $i++ ) {
                $obj = $this->_children[$i];
                if( $obj->status == self::TEST_FAIL ) {
                    if( $obj->warn_msg ) return $obj->warn_msg;
                    if( $obj->warn_key ) return \__appbase\lang($obj->warn_key);
                }
            }
        }

        return parent::msg();
    }
} // end of class

?><?php

namespace __appbase\tests;

class matchany_test extends test_base
{
  private $_children;

  public function __construct($name)
  {
    parent::__construct($name,'');
  }

  public function add_child(test_base $obj)
  {
    if( !is_array($this->_children) )
      $this->_children = array();

    $this->_children[] = $obj;
  }

  public function __set($key,$value)
  {
    switch( $key )
      {
      case 'minimum':
      case 'maximum':
      case 'recommended':
      case 'success_key':
      case 'pass_key':
      case 'fail_key':
	$this->$key = $value;
	break;

      default:
	parent::__set($key,$value);
      }
  }


  public function execute()
  {
    if( count($this->_children) )
      {
	for( $i = 0; $i < count($this->_children); $i++ )
	  {
	    $res = $this->_children[$i]->execute();
	    if( $res == self::TEST_PASS )
	      {
		return self::TEST_PASS;
	      }
	  }
      }
    return self::TEST_FAIL;
  }
}

?><?php

namespace __appbase\tests;

function test_extension_loaded($name)
{
  $a = extension_loaded(strtoupper($name));
  $b = extension_loaded(strtoupper($name));
  return $a || $b;
}


function test_apache_module($name)
{
  if( !$name ) return FALSE;
  if( !function_exists('apache_get_modules') ) return FALSE;
  $modules = apache_get_modules();
  if( in_array($name,$modules) ) return TRUE;
  return FALSE;
}


function test_is_false($val)
{
  return (\__appbase\utils::to_bool($val) == FALSE);
}


function test_is_true($val)
{
  return (\__appbase\utils::to_bool($val) == TRUE);
}


function test_remote_file($url,$timeout = 3,$searchString = '')
{
  $timeout = max(1,min(360,$timeout));
  $req = new \__appbase\http_request;
  $req->setTarget($url);
  $req->setTimeout($timeout);
  $req->execute();
  if( $req->getStatus() != 200 ) return FALSE;
  if( $searchString && strpos($req->getResult(),$searchString) === FALSE ) return FALSE;
  return TRUE;
}

abstract class test_base
{
  const TEST_UNTESTED = 'test_untested';
  const TEST_PASS = 'test_pass';
  const TEST_FAIL = 'test_fail';
  const TEST_WARN = 'test_warn';

  private static $_keys = array('name','name_key','status','value','required','minimum','maximum','recommended','pass_key','pass_msg','fail_msg',
				'fail_key','warn_key','warn_msg','msg_key','msg');
  private $_data = array();

  public function __construct($name,$value,$key = '')
  {
    if( !$name ) throw new Exception(\__appbase\lang('error_test_name'));
    $this->name = $name;
    $this->name_key = $name;
    $this->value = $value;
    if( $key ) $this->name_key = $key;
    $this->status = self::TEST_UNTESTED;
    $this->required = 0;
  }

  public function __get($key)
  {
    if( !in_array($key,self::$_keys) ) throw new \Exception(\__appbase\lang('error_invalidkey',$key,__CLASS__));
    if( isset($this->_data[$key]) ) return $this->_data[$key];
  }

  public function __isset($key)
  {
    if( !in_array($key,self::$_keys) ) throw new \Exception(\__appbase\lang('error_invalidkey',$key,__CLASS__));
    return isset($this->_data[$key]);
  }

  public function __set($key,$value)
  {
    if( !in_array($key,self::$_keys) ) throw new \Exception(\__appbase\lang('error_invalidkey',$key,__CLASS__));
    if( is_null($value) || $value === '' ) {
      unset($this->_data[$key]);
      return;
    }

    $this->_data[$key] = $value;
  }

  public function __unset($key)
  {
    if( !in_array($key,self::$_keys) ) throw new \Exception(\__appbase\lang('error_invalidkey',$key,__CLASS__));
    unset($this->_data[$key]);
  }

  abstract public function execute();

  public function run()
  {
    $res = $this->execute();
    switch( $res ) {
    case self::TEST_PASS:
    case self::TEST_FAIL:
    case self::TEST_WARN:
      $this->status = $res;
      break;

    case self::TEST_UNTESTED:
    default:
      throw new \Exception(\__appbase\lang('error_test_invalidresult').' '.$res);
    }

    return $this->status;
  }

  public function msg()
  {
    if( $this->msg ) return $this->msg;
    if( $this->msg_key ) return $this->msg_key;

    switch( $this->status ) {
    case self::TEST_PASS:
      if( $this->pass_msg ) return $this->pass_msg;
      if( $this->pass_key ) return \__appbase\lang($this->pass_key);
      break;

    case self::TEST_FAIL:
      if( $this->fail_msg ) return $this->fail_msg;
      if( $this->fail_key ) return \__appbase\lang($this->fail_key);
      break;

    case self::TEST_WARN:
      if( $this->warn_msg ) return $this->warn_msg;
      if( $this->warn_key ) return \__appbase\lang($this->warn_key);
      break;

    default:
      throw new \Exception(\__appbase\lang('error_test_invalidstatus'));
    }
  }

  protected function returnBytes($val)
  {
      if(is_string($val) && $val != '') {
          $val = trim($val);
          $last = strtolower(substr($val,-1));
          $val = (float) substr($val,0,-1);
          switch($last) {
          case 'g':
              $val *= 1024.0;
          case 'm':
              $val *= 1024.0;
          case 'k':
              $val *= 1024.0;
          }
      }

      return $val;
  }
} // end of class

?><?php

namespace __appbase\tests;

class informational_test extends test_base
{
  public function __construct($name,$value,$message = '',$key = '')
  {
    parent::__construct($name,$value,$key);
    if( $message )
      {
	$this->msg_key = $message;
      }
  }

  /**
   * Execute the test
   *
   * @return integer -1 for fail
   */
  public function execute() {}
} // end of class

?><?php

namespace __appbase\tests;

class version_range_test extends test_base
{
  public function __construct($name,$value)
  {
    parent::__construct($name,$value);
  }

  public function __set($key,$value)
  {
    switch( $key )
      {
      case 'minimum':
      case 'maximum':
      case 'recommended':
      case 'success_key':
      case 'pass_key':
      case 'fail_key':
	$this->$key = $value;
	break;

      default:
	parent::__set($key,$value);
      }
  }

  public function execute()
  {
    // make sure we have all of the information.
    // do the test
    // set the result.
    if( $this->minimum ) {
      if( version_compare($this->value,$this->minimum) < 0 ) return self::TEST_FAIL;
    }
    if( $this->maximum ) {
      if( version_compare($this->value,$this->maximum) > 0 ) return self::TEST_FAIL;
    }
    if( $this->recommended ) {
      if( version_compare($this->value,$this->recommended) < 0 ) return self::TEST_WARN;
    }
    return self::TEST_PASS;
  }
}

?><?php

namespace __appbase\tests;

class range_test extends test_base
{
  public function __construct($name,$value)
  {
      parent::__construct($name,$value);
  }


  public function __set($key,$value)
  {
      switch( $key )
      {
      case 'minimum':
      case 'maximum':
          $this->$key = $value;
          break;

      default:
          parent::__set($key,$value);
      }
  }


  public function execute()
  {
      if( $this->minimum )
      {
          $min = $this->returnBytes($this->minimum);
          $val = $this->returnBytes($this->value);
          if( $val < $min ) return self::TEST_FAIL;
      }
      if( $this->recommended )
      {
          $rec = $this->returnBytes($this->recommended);
          $val = $this->returnBytes($this->value);
          if( $val < $rec ) return self::TEST_WARN;
      }
      if( $this->maximum )
      {
          $max = $this->returnBytes($this->maximum);
          $val = $this->returnBytes($this->value);
          if( $val > $max ) return self::TEST_FAIL;
      }
      return self::TEST_PASS;
  }
}

?><?php

namespace __appbase\tests;

class boolean_test extends test_base
{
  private $_data = array();

  public function __construct($name,$value)
  {
    $value = (bool)$value;
    parent::__construct($name,$value);
  }

  public function execute()
  {
    $val = \__appbase\utils::to_bool($this->value);
    if( $val ) return self::TEST_PASS;
    return self::TEST_FAIL;
  }
}
<?php

namespace __appbase;

/**
 * @package CMS
 */

/**
 * HTTP Class
 *
 * This is a wrapper HTTP class that uses either cURL or fsockopen to
 * harvest resources from web. This can be used with scripts that need
 * a way to communicate with various APIs who support REST.
 *
 * @author      Md Emran Hasan <phpfour@gmail.com>
 * @package     HTTP Library
 * @copyright   2007-2008 Md Emran Hasan
 * @link        http://www.phpfour.com/lib/http
 * @since       Version 0.1
 *
 * Modified by Robert Campbell (calguy1000@cmsmadesimple.org)
 * Renamed the class to cms_http_request
 * Fixed some bugs.
 */

class http_request
{
    /**
     * Contains the target URL
     *
     * @var string
     */
    private $target;

    /**
     * socket
     *
     */
    private $_socket;

    /**
     * Contains the target host
     *
     * @var string
     */
    private $host;

    /**
     * Contains the target port
     *
     * @var integer
     */
    private $port;

    /**
     * Contains the target path
     *
     * @var string
     */
    private $path;

    /**
     * Contains the target schema
     *
     * @var string
     */
    private $schema;

    /**
     * Contains the http method (GET or POST)
     *
     * @var string
     */
    private $method;

    /**
     * Contains raw post data
     *
     * @var str
     */
    private $rawPostData;

    /**
     * Contains the parameters for request
     *
     * @var array
     */
    private $params;

    /**
     * Contains the cookies for request
     *
     * @var array
     */
    private $cookies;

    /**
     * Contains the cookies retrieved from response
     *
     * @var array
     */
    private $_cookies;

    /**
     * Number of seconds to timeout
     *
     * @var integer
     */
    private $timeout;

    /**
     * Whether to use cURL or not
     *
     * @var boolean
     */
    private $useCurl;

    /**
     * Contains the referrer URL
     *
     * @var string
     */
    private $referrer;

    /**
     * Contains the User agent string
     *
     * @var string
     */
    private $userAgent;

    /**
     * Contains the cookie path (to be used with cURL)
     *
     * @var string
     */
    private $cookiePath;

    /**
     * Whether to use cookie at all
     *
     * @var boolean
     */
    private $useCookie;

    /**
     * Whether to store cookie for subsequent requests
     *
     * @var boolean
     */
    private $saveCookie;

    /**
     * Contains the Username (for authentication)
     *
     * @var string
     */
    private $username;

    /**
     * Contains the Password (for authentication)
     *
     * @var string
     */
    private $password;

    /**
     * Contains the fetched web source
     *
     * @var string
     */
    private $result;

    /**
     * Contains the last headers
     *
     * @var string
     */
    private $headers;

    /**
     * Contains the last call's http status code
     *
     * @var string
     */
    private $status;

    /**
     * Whether to follow http redirect or not
     *
     * @var boolean
     */
    private $redirect;

    /**
     * The maximum number of redirect to follow
     *
     * @var integer
     */
    private $maxRedirect;

    /**
     * The current number of redirects
     *
     * @var integer
     */
    private $curRedirect;

    /**
     * Contains any error occurred
     *
     * @var string
     */
    private $error;

    /**
     * Store the next token
     *
     * @var string
     */
    private $nextToken;

    /**
     * Whether to keep debug messages
     *
     * @var boolean
     */
    private $debug;

    /**
     * Stores optional http headers
     *
     * @var array
     */
    private $headerArray;

    /**
     * Stores the debug messages
     *
     * @var array
     * @todo will keep debug messages
     */
    private $debugMsg;

    /**
     * Stores proxy information (host:port)
     *
     * @var string
     */
    private $proxy;

    /**
     * Constructor for initializing the class with default values.
     *
     * @return void
     */
    public function __construct()
    {
        $this->clear();
    }

    /**
     * Initialize preferences
     *
     * This function will take an associative array of config values and
     * will initialize the class variables using them.
     *
     * Example use:
     *
     * <pre>
     * $httpConfig['method']     = 'GET';
     * $httpConfig['target']     = 'http://www.somedomain.com/index.html';
     * $httpConfig['referrer']   = 'http://www.somedomain.com';
     * $httpConfig['user_agent'] = 'My Crawler';
     * $httpConfig['timeout']    = '30';
     * $httpConfig['params']     = array('var1' => 'testvalue', 'var2' => 'somevalue');
     *
     * $http = new Http();
     * $http->initialize($httpConfig);
     * </pre>
     *
     * @param array Config values as associative array
     * @return void
     */
    function initialize($config = array())
    {
        $this->clear();
        foreach ($config as $key => $val)
        {
            if (isset($this->$key))
            {
                $method = 'set' . ucfirst(str_replace('_', '', $key));

                if (method_exists($this, $method))
                {
                    $this->$method($val);
                }
                else
                {
                    $this->$key = $val;
                }
            }
        }
    }

    /**
     * Clear Everything
     *
     * Clears all the properties of the class and sets the object to
     * the beginning state. Very handy if you are doing subsequent calls
     * with different data.
     *
     * @return void
     */
    function clear()
    {
        // Set the request defaults
        $this->host         = '';
        $this->port         = 0;
        $this->path         = '';
        $this->target       = '';
        $this->method       = 'GET';
        $this->schema       = 'http';
        $this->params       = array();
        $this->headers      = array();
        $this->cookies      = array();
        $this->_cookies     = array();
        $this->headerArray  = array();
        $this->proxy        = null;

        // Set the config details
        $this->debug        = FALSE;
        $this->error        = '';
        $this->status       = 0;
        $this->timeout      = '25';
        $this->useCurl      = TRUE;
        $this->referrer     = '';
        $this->username     = '';
        $this->password     = '';
        $this->redirect     = FALSE;
        $this->result       = null;

        // Set the cookie and agent defaults
        $app = get_app();
        $this->nextToken    = '';
        $this->useCookie    = TRUE;
        $this->saveCookie   = TRUE;
        $this->maxRedirect  = 3;
        $this->cookiePath   = $app->get_tmpdir().'/c'.md5(get_class().session_id()).'.dat'; // by default, use a cookie file that is unique only to this session.
        $this->userAgent    = 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.6) Gecko/20070725 Firefox/2.0.0.9';
    }

    /**
     * Clear all cookies
     *
     * @return void
     * @author Robert Campbell (calguy1000@gmail.com)
     */
    function resetCookies()
    {
      if( $this->cookiePath ) @unlink($this->cookiePath);
    }

    /**
     * Set target URL
     *
     * @param string URL of target resource
     * @return void
     */
    function setTarget($url)
    {
        if ($url)
        {
            $this->target = $url;
        }
    }

    /**
     * Set http method
     *
     * @param string HTTP method to use (GET or POST)
     * @return void
     */
    function setMethod($method)
    {
        if ($method == 'GET' || $method == 'POST')
        {
            $this->method = $method;
        }
    }

    /**
     * Set referrer URL
     *
     * @param string URL of referrer page
     * @return void
     */
    function setReferrer($referrer)
    {
        if ($referrer)
        {
            $this->referrer = $referrer;
        }
    }

    /**
     * Set User agent string
     *
     * @param string Full user agent string
     * @return void
     */
    function setUseragent($agent)
    {
        if ($agent)
        {
            $this->userAgent = $agent;
        }
    }

    /**
     * Set timeout of execution
     *
     * @param integer Timeout delay in seconds
     * @return void
     */
    function setTimeout($seconds)
    {
        if ($seconds > 0)
        {
            $this->timeout = $seconds;
        }
    }

    /**
     * Set cookie path (cURL only)
     *
     * @param string File location of cookiejar
     * @return void
     */
    function setCookiepath($path)
    {
        if ($path)
        {
            $this->cookiePath = $path;
        }
    }

    function setRawPostData($data)
    {
      $this->rawPostData = $data;
    }

    /**
     * Set request parameters
     *
     * @param array All the parameters for GET or POST
     * @return void
     */
    function setParams($dataArray)
    {
      if( !is_array($dataArray) )
	{
	  $this->setRawPostData($dataArray);
	}
      else if (is_array($dataArray))
        {
	  $this->params = array_merge($this->params, $dataArray);
        }
    }

    /**
     * Set basic http authentication realm
     *
     * @param string Username for authentication
     * @param string Password for authentication
     * @return void
     */
    function setAuth($username, $password)
    {
        if (!empty($username) && !empty($password))
        {
            $this->username = $username;
            $this->password = $password;
        }
    }

    /**
     * Set maximum number of redirection to follow
     *
     * @param integer Maximum number of redirects
     * @return void
     */
    function setMaxredirect($value)
    {
        if (!empty($value))
        {
            $this->maxRedirect = $value;
        }
    }

    /**
     * Add request parameters
     *
     * @param string Name of the parameter
     * @param string Value of the parameter
     * @return void
     */
    function addParam($name, $value)
    {
        if (!empty($name) && $value !== '')
        {
            $this->params[$name] = $value;
        }
    }

    /**
     * Add a cookie to the request
     *
     * @param string Name of cookie
     * @param string Value of cookie
     * @return void
     */
    function addCookie($name, $value)
    {
        if (!empty($name) && !empty($value))
        {
            $this->cookies[$name] = $value;
        }
    }

    /**
     * Whether to use cURL or not
     *
     * @param boolean Whether to use cURL or not
     * @return void
     */
    function useCurl($value = TRUE)
    {
        if (is_bool($value))
        {
            $this->useCurl = $value;
        }
    }

    /**
     * Whether to use cookies or not
     *
     * @param boolean Whether to use cookies or not
     * @return void
     */
    function useCookie($value = TRUE)
    {
        if (is_bool($value))
        {
            $this->useCookie = $value;
        }
    }

    /**
     * Whether to save persistent cookies in subsequent calls
     *
     * @param boolean Whether to save persistent cookies or not
     * @return void
     */
    function saveCookie($value = TRUE)
    {
        if (is_bool($value))
        {
            $this->saveCookie = $value;
        }
    }

    /**
     * Whether to follow HTTP redirects
     *
     * @param boolean Whether to follow HTTP redirects or not
     * @return void
     */
    function followRedirects($value = TRUE)
    {
        if (is_bool($value))
        {
            $this->redirect = $value;
        }
    }

    /**
     * Get execution result body
     *
     * @return string output of execution
     */
    function getResult()
    {
        return $this->result;
    }

    /**
     * Get execution result headers
     *
     * @return array last headers of execution
     */
    function getHeaders()
    {
        return $this->headers;
    }

    /**
     * Get execution status code
     *
     * @return integer last http status code
     */
    function getStatus()
    {
        return $this->status;
    }

    /**
     * Get last execution error
     *
     * @return string last error message (if any)
     */
    function getError()
    {
        return $this->error;
    }

    /**
     * Request Header Exists?
     */
    function requestHeaderExists($key)
    {
      if( !is_array($this->headerArray) )
	{
	  $this->headerArray = array();
	}
      if( strpos($key,':') !== FALSE )
	{
	  $tmp = explode(':',$key);
	  $key = trim($tmp[0]);
	}
      for( $i = 0; $i < count($this->headerArray); $i++ )
	{
	  $tmp = explode(':',$this->headerArray[$i],1);
	  $key2 = trim($tmp[0]);
	  if( $key2 == $key ) return TRUE;
	}
      return FALSE;
    }

    /**
     * Add a request header
     *
     */
    function addRequestHeader($str,$prepend = false)
    {
      if( !is_array($this->headerArray) )
	{
	  $this->headerArray = array();
	}

      $f = 0;
      if( strpos($str,':') !== FALSE )
	{
	  $tmp = explode(':',$str,1);
	  $key = trim($tmp[0]);
	  for( $i = 0; $i < count($this->headerArray); $i++ )
	    {
	      $tmp = explode(':',$this->headerArray[$i],1);
	      $key2 = trim($tmp[0]);
	      if( $key2 == $key )
		{
		  // found a duplicate.
		  $this->headerArray[$i] = $str;
		  $f = 1;
		  break;
		}
	    }
	}
      if( !$f )
	{
	  if( $prepend )
	    {
	      array_unshift($this->headerArray,$str);
	    }
	  else
	    {
	      $this->headerArray[] = $str;
	    }
	}
    }


    private function _isCurlSuitable()
    {
      static $_curlgood = -1;

      if( $_curlgood == -1 )
	{
	  $_curlgood = 0;
	  if( in_array('curl',get_loaded_extensions()) )
	    {
	      if( function_exists('curl_version') )
		{
		  $tmp = curl_version();
		  if( isset($tmp['version']) )
		    {
		      if( version_compare($tmp['version'],'7.19.7') >= 0 )
			{
			  $_curlgood = 1;
			}
		    }
		}
	    }
	}

      return $_curlgood;
    }

    /**
     * Execute a HTTP request
     *
     * Executes the http fetch using all the set properties. Intellegently
     * switch to fsockopen if cURL is not present. And be smart to follow
     * redirects (if asked so).
     *
     * @param string URL of the target page (optional)
     * @param string URL of the referrer page (optional)
     * @param string The http method (GET or POST) (optional)
     * @param array Parameter array for GET or POST (optional)
     * @return string Response body of the target page
     */
    public function execute($target = '', $referrer = '', $method = '', $data = array())
    {
        // Populate the properties
        $this->target = ($target) ? $target : $this->target;
        $this->method = ($method) ? $method : $this->method;

        $this->referrer = ($referrer) ? $referrer : $this->referrer;

        // Add the new params
        if (is_array($data) && count($data) > 0)
        {
            $this->params = array_merge($this->params, $data);
        }

        // Process data, if presented
	$queryString = '';
	if($this->rawPostData)
	{
	  $queryString = $this->rawPostData;
	}
        else if(is_array($this->params) && count($this->params) > 0)
        {
	    $queryString = http_build_query($this->params,'','&');
        }

        // If cURL is not installed, we'll force fscokopen
	$this->useCurl = $this->useCurl && $this->_isCurlSuitable();

        // GET method configuration
        if($this->method == 'GET')
        {
            if($queryString)
            {
                $this->target = $this->target . "?" . $queryString;
            }
        }

        // Parse target URL
        $urlParsed = parse_url($this->target);
	if( $this->port == 0 && isset($urlParsed['port']) && $urlParsed['port'] > 0 )
	  {
	    $this->port = $urlParsed['port'];
	  }

        // Handle SSL connection request
        if ($urlParsed['scheme'] == 'https')
        {
            $this->host = $urlParsed['host'];
            $this->port = ($this->port != 0) ? $this->port : 443;
	    $this->_socket = 'ssl://'.$urlParsed['host'].':'.$this->port;
        }
        else
        {
            $this->host = $urlParsed['host'];
            $this->port = ($this->port != 0) ? $this->port : 80;
	    $this->_socket = 'tcp://'.$urlParsed['host'].':'.$this->port;
        }

        // Finalize the target path
        $this->path   = (isset($urlParsed['path']) ? $urlParsed['path'] : '/') . (isset($urlParsed['query']) ? '?' . $urlParsed['query'] : '');
        $this->schema = $urlParsed['scheme'];

        // Pass the requred cookies
        $this->_passCookies();

        // Process cookies, if requested
	$cookieString = '';
        if(is_array($this->cookies) && count($this->cookies) > 0)
        {
            // Get a blank slate
            $tempString   = array();

            // Convert cookiesa array into a query string (ie animal=dog&sport=baseball)
            foreach ($this->cookies as $key => $value)
            {
                if(strlen(trim($value)) > 0)
                {
                    $tempString[] = $key . "=" . urlencode($value);
                }
            }

            $cookieString = join('&', $tempString);
        }

        // Do we need to use cURL
        if ($this->useCurl)
        {
            // Initialize PHP cURL handle
            $ch = curl_init();

            // GET method configuration
            if($this->method == 'GET')
            {
                curl_setopt ($ch, CURLOPT_HTTPGET, TRUE);
                curl_setopt ($ch, CURLOPT_POST, FALSE);
            }
            // POST method configuration
            else
            {
                curl_setopt ($ch, CURLOPT_POST, TRUE);
                curl_setopt ($ch, CURLOPT_HTTPGET, FALSE);

                if(isset($queryString))
                {
                    curl_setopt ($ch, CURLOPT_POSTFIELDS, $queryString);
                }
            }

            // Basic Authentication configuration
            if ($this->username && $this->password)
            {
                curl_setopt($ch, CURLOPT_USERPWD, $this->username . ':' . $this->password);
            }

	    if ($this->proxy)
	    {
	        curl_setop($ch,CURL_PROXY,$this->proxy);
	    }

            // Custom cookie configuration
            if($this->useCookie)
            {
	      // we are sending cookies.
	      if(isset($cookieString))
		{
		  curl_setopt ($ch, CURLOPT_COOKIE, $cookieString);
		}
	      else
		{
		  curl_setopt($ch, CURLOPT_COOKIEFILE, $this->cookiePath);
		}
            }
            if($this->saveCookie)
	    {
	      curl_setopt($ch, CURLOPT_COOKIEJAR,      $this->cookiePath);    // Save cookies here.
	    }

	    curl_setopt($ch, CURLOPT_HEADER,     TRUE);                 // No need of headers
	    if( is_array($this->headerArray) )
	      {
		curl_setopt($ch,CURLOPT_HTTPHEADER,$this->headerArray);
	      }
	    else
	      {
		curl_setopt($ch, CURLOPT_HEADER,     TRUE);                 // No need of headers
	      }
	    curl_setopt($ch, CURLOPT_NOBODY,         FALSE);                // Return body
            curl_setopt($ch, CURLOPT_TIMEOUT,        $this->timeout);       // Timeout
            curl_setopt($ch, CURLOPT_USERAGENT,      $this->userAgent);     // Webbot name
            curl_setopt($ch, CURLOPT_URL,            $this->target);        // Target site
            curl_setopt($ch, CURLOPT_REFERER,        $this->referrer);      // Referer value

            curl_setopt($ch, CURLOPT_VERBOSE,        FALSE);                // Minimize logs
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);                // No certificate
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, $this->redirect);      // Follow redirects
            curl_setopt($ch, CURLOPT_MAXREDIRS,      $this->maxRedirect);   // Limit redirections to four
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);                 // Return in string

            // Get the target contents
            $content = curl_exec($ch);
	    if( !empty($content) )
	      {
		$tmp = explode("\r\n\r\n", $content,2);
		for( $i = 0; $i < count($tmp); $i++ )
		  {
		    if( empty($tmp[$i]) ) unset($tmp[$i]);
		  }

		if( count($tmp) > 1 )
		  {
		    // Store the contents
		    $this->result = $tmp[1];
		  }

		// Parse the headers
		$this->_parseHeaders($tmp[0]);
	      }

            // Get the request info
            $status  = curl_getinfo($ch);

            // Store the error (is any)
            $this->_setError(curl_error($ch));

            // Close PHP cURL handle
            curl_close($ch);
        }
        else
        {
	  // Get a file pointer
	  $filePointer = @stream_socket_client($this->_socket, $errorNumber, $errorString, $this->timeout);

	  // We have an error if pointer is not there
	  if (!$filePointer)
            {
	      $this->_setError('Failed opening http socket connection: ' . $errorString . ' (' . $errorNumber . ')');
	      return FALSE;
            }

            // Set http headers with host, user-agent and content type
            $this->addRequestHeader($this->method .' '. $this->path. "  HTTP/1.1",true);
	    $this->addRequestHeader("Host: " . $this->host);
	    $this->addRequestHeader('Accept: */*');
 	    $this->addRequestHeader("User-Agent: " . $this->userAgent);
	    if( !$this->requestHeaderExists('Content-Type') )
	      {
		$this->addRequestHeader("Content-Type: application/x-www-form-urlencoded");
	      }

            // Specify the custom cookies
            if ($this->useCookie && $cookieString != '')
            {
	      $this->addRequestHeader("Cookie: " . $cookieString);
            }

            // POST method configuration
            if ($this->method == "POST")
            {
              $this->addRequestHeader("Content-Length: " . strlen($queryString));
            }

            // Specify the referrer
	    $this->addRequestHeader("Referer: " . $this->referrer);
            if ($this->referrer != '')
            {
	      $this->addRequestHeader("Referer: " . $this->referrer);
            }

            // Specify http authentication (basic)
            if ($this->username && $this->password)
            {
	      $this->addRequestheader("Authorization: Basic " . base64_encode($this->username . ':' . $this->password));
            }

	    $this->addRequestHeader("Connection: close");

            // POST method configuration
	    $requestHeader = implode("\r\n",$this->headerArray)."\r\n\r\n";
            if ($this->method == "POST")
            {
                $requestHeader .= $queryString;
            }

            // We're ready to launch
            fwrite($filePointer, $requestHeader);


            // Clean the slate
            $responseHeader = '';
            $responseContent = '';

            // 3...2...1...Launch !
	    $n = 0;
            do
            {
                $responseHeader .= fread($filePointer, 1);
            }
            while (!preg_match('/\\r\\n\\r\\n$/', $responseHeader) && !feof($filePointer));

            // Parse the headers
            $this->_parseHeaders($responseHeader);

            // Do we have a 301/302 redirect ?
            if (($this->status == '301' || $this->status == '302') && $this->redirect == TRUE)
            {
                if ($this->curRedirect < $this->maxRedirect)
                {
                    // Let's find out the new redirect URL
                    $newUrlParsed = parse_url($this->headers['location']);

                    if ($newUrlParsed['host'])
                    {
                        $newTarget = $this->headers['location'];
                    }
                    else
                    {
                        $newTarget = $this->schema . '://' . $this->host . '/' . $this->headers['location'];
                    }

                    // Reset some of the properties
                    $this->port   = 0;
                    $this->status = 0;
                    $this->params = array();
                    $this->method = 'POST';
                    $this->referrer = $this->target;

                    // Increase the redirect counter
                    $this->curRedirect++;

                    // Let's go, go, go !
                    $this->result = $this->execute($newTarget);
                }
                else
                {
                    $this->_setError('Too many redirects.');
                    return FALSE;
                }
            }
            else
            {
                // Nope...so lets get the rest of the contents (non-chunked)
	      if (!isset($this->headers['transfer-encoding']) || $this->headers['transfer-encoding'] != 'chunked')
                {
                    while (!feof($filePointer))
                    {
                        $responseContent .= fgets($filePointer, 128);
                    }
                }
                else
		  {
                    // Get the contents (chunked)
		    while (!feof($filePointer) && $chunkLength = hexdec(fgets($filePointer)))
                    {
                        $responseContentChunk = '';
                        $readLength = 0;

                        while ($readLength < $chunkLength)
                        {
                            $responseContentChunk .= fread($filePointer, $chunkLength - $readLength);
                            $readLength = strlen($responseContentChunk);
                        }

                        $responseContent .= $responseContentChunk;
                        fgets($filePointer);
                    }
                }

                // Store the target contents
                $this->result = chop($responseContent);
            }
        }

        // There it is! We have it!! Return to base !!!
        return $this->result;
    }

    /**
     * Parse Headers (internal)
     *
     * Parse the response headers and store them for finding the resposne
     * status, redirection location, cookies, etc.
     *
     * @param string Raw header response
     * @return void
     * @access private
     */
    function _parseHeaders($responseHeader)
    {
        // Break up the headers
        $headers = explode("\r\n", $responseHeader);

        // Clear the header array
        $this->_clearHeaders();

        // Get resposne status
        if($this->status == 0)
        {
            // Oooops !
            if(!preg_match("/http\/[0-9]+\.[0-9]+[ \t]+([0-9]+)[ \t]*(.*)\$/i", $headers[0], $matches))
            {
                $this->_setError('Unexpected HTTP response status');
                return FALSE;
            }

            // Gotcha!
            $this->status = $matches[1];
            array_shift($headers);
        }

        // Prepare all the other headers
        foreach ($headers as $header)
        {
            // Get name and value
            $headerName  = strtolower($this->_tokenize($header, ':'));
            $headerValue = trim(chop($this->_tokenize("\r\n")));

            // If its already there, then add as an array. Otherwise, just keep there
            if(isset($this->headers[$headerName]))
            {
                if(gettype($this->headers[$headerName]) == "string")
                {
                    $this->headers[$headerName] = array($this->headers[$headerName]);
                }

                $this->headers[$headerName][] = $headerValue;
            }
            else
            {
                $this->headers[$headerName] = $headerValue;
            }
        }

        // Save cookies if asked
        if ($this->saveCookie && isset($this->headers['set-cookie']))
        {
            $this->_parseCookie();
        }
    }

    /**
     * Clear the headers array (internal)
     *
     * @return void
     * @access private
     */
    function _clearHeaders()
    {
        $this->headers = array();
    }

    /**
     * Parse Cookies (internal)
     *
     * Parse the set-cookie headers from response and add them for inclusion.
     *
     * @return void
     * @access private
     */
    function _parseCookie()
    {
        // Get the cookie header as array
        if(gettype($this->headers['set-cookie']) == "array")
        {
            $cookieHeaders = $this->headers['set-cookie'];
        }
        else
        {
            $cookieHeaders = array($this->headers['set-cookie']);
        }

        // Loop through the cookies
        for ($cookie = 0; $cookie < count($cookieHeaders); $cookie++)
        {
            $cookieName  = trim($this->_tokenize($cookieHeaders[$cookie], "="));
            $cookieValue = $this->_tokenize(";");

            $urlParsed   = parse_url($this->target);

            $domain      = $urlParsed['host'];
            $secure      = '0';

            $path        = "/";
            $expires     = "";

            while(($name = trim(urldecode($this->_tokenize("=")))) != "")
            {
                $value = urldecode($this->_tokenize(";"));

                switch($name)
                {
                    case "path"     : $path     = $value; break;
                    case "domain"   : $domain   = $value; break;
                    case "secure"   : $secure   = ($value != '') ? '1' : '0'; break;
                }
            }

            $this->_setCookie($cookieName, $cookieValue, $expires, $path , $domain, $secure);
        }
    }

    /**
     * Set cookie (internal)
     *
     * Populate the internal _cookies array for future inclusion in
     * subsequent requests. This actually validates and then populates
     * the object properties with a dimensional entry for cookie.
     *
     * @param string Cookie name
     * @param string Cookie value
     * @param string Cookie expire date
     * @param string Cookie path
     * @param string Cookie domain
     * @param string Cookie security (0 = non-secure, 1 = secure)
     * @return void
     * @access private
     */
    function _setCookie($name, $value, $expires = "" , $path = "/" , $domain = "" , $secure = 0)
    {
        if(strlen($name) == 0)
        {
            return($this->_setError("No valid cookie name was specified."));
        }

        if(strlen($path) == 0 || strcmp($path[0], "/"))
        {
            return($this->_setError("$path is not a valid path for setting cookie $name."));
        }

        if($domain == "" || !strpos($domain, ".", $domain[0] == "." ? 1 : 0))
        {
            return($this->_setError("$domain is not a valid domain for setting cookie $name."));
        }

        $domain = strtolower($domain);

        if(!strcmp($domain[0], "."))
        {
            $domain = substr($domain, 1);
        }

        $name  = $this->_encodeCookie($name, true);
        $value = $this->_encodeCookie($value, false);

        $secure = intval($secure);

        $this->_cookies[] = array( "name"      =>  $name,
                                   "value"     =>  $value,
                                   "domain"    =>  $domain,
                                   "path"      =>  $path,
                                   "expires"   =>  $expires,
                                   "secure"    =>  $secure
                                 );
    }

    /**
     * Encode cookie name/value (internal)
     *
     * @param string Value of cookie to encode
     * @param string Name of cookie to encode
     * @return string encoded string
     * @access private
     */
    function _encodeCookie($value, $name)
    {
        return($name ? str_replace("=", "%25", $value) : str_replace(";", "%3B", $value));
    }

    /**
     * Pass Cookies (internal)
     *
     * Get the cookies which are valid for the current request. Checks
     * domain and path to decide the return.
     *
     * @return void
     * @access private
     */
    function _passCookies()
    {
        if (is_array($this->_cookies) && count($this->_cookies) > 0)
        {
            $urlParsed = parse_url($this->target);
            $tempCookies = array();

            foreach($this->_cookies as $cookie)
            {
                if ($this->_domainMatch($urlParsed['host'], $cookie['domain']) && (0 === strpos($urlParsed['path'], $cookie['path']))
                    && (empty($cookie['secure']) || $urlParsed['protocol'] == 'https'))
                {
                    $tempCookies[$cookie['name']][strlen($cookie['path'])] = $cookie['value'];
                }
            }

            // cookies with longer paths go first
            foreach ($tempCookies as $name => $values)
            {
                krsort($values);
                foreach ($values as $value)
                {
                    $this->addCookie($name, $value);
                }
            }
        }
    }

    /**
    * Checks if cookie domain matches a request host (internal)
    *
    * Cookie domain can begin with a dot, it also must contain at least
    * two dots.
    *
    * @param string Request host
    * @param string Cookie domain
    * @return bool Match success
     * @access private
    */
    function _domainMatch($requestHost, $cookieDomain)
    {
        if ('.' != $cookieDomain{0})
        {
            return $requestHost == $cookieDomain;
        }
        elseif (substr_count($cookieDomain, '.') < 2)
        {
            return false;
        }
        else
        {
            return substr('.'. $requestHost, - strlen($cookieDomain)) == $cookieDomain;
        }
    }

    /**
     * Tokenize String (internal)
     *
     * Tokenize string for various internal usage. Omit the second parameter
     * to tokenize the previous string that was provided in the prior call to
     * the function.
     *
     * @param string The string to tokenize
     * @param string The seperator to use
     * @return string Tokenized string
     * @access private
     */
    function _tokenize($string, $separator = '')
    {
        if(!strcmp($separator, ''))
        {
            $separator = $string;
            $string = $this->nextToken;
        }

        for($character = 0; $character < strlen($separator); $character++)
        {
            if(gettype($position = strpos($string, $separator[$character])) == "integer")
            {
                $found = (isset($found) ? min($found, $position) : $position);
            }
        }

        if(isset($found))
        {
            $this->nextToken = substr($string, $found + 1);
            return(substr($string, 0, $found));
        }
        else
        {
            $this->nextToken = '';
            return($string);
        }
    }

    /**
     * Set error message (internal)
     *
     * @param string Error message
     * @return string Error message
     * @access private
     */
    function _setError($error)
    {
        if ($error != '')
        {
            $this->error = $error;
            return $error;
        }
    }
}

?>
<?php

namespace __appbase;

require_once(dirname(dirname(__FILE__)).'/Smarty/Smarty.class.php');

class cms_smarty extends \Smarty
{
  private static $_instance;

  public function __construct()
  {
    parent::__construct();

    $app = get_app();
    $rootdir = $app->get_rootdir();
    $tmpdir = $app->get_tmpdir().'/m'.md5(__FILE__);
    $appdir = $app->get_appdir();
    $basedir = dirname(dirname(dirname(__FILE__)));

    $this->setTemplateDir($appdir.'/templates');
    $this->setConfigDir($appdir.'/configs');
    $this->setCompileDir($tmpdir.'/templates_c');
    $this->setCacheDir($tmpdir.'/cache');

    $this->registerPlugin('modifier','tr',array($this,'modifier_tr'));
    $dirs = array($this->compile_dir,$this->cache_dir);
    for( $i = 0; $i < count($dirs); $i++ ) {
      @mkdir($dirs[$i],0777,TRUE);
      if( !is_dir($dirs[$i]) ) throw new \Exception('Required directory '.$dirs[$i].' does not exist');
    }
  }

  public static function &get_instance()
  {
    if( !is_object(self::$_instance) ) self::$_instance = new cms_smarty;
    return self::$_instance;
  }

  public function modifier_tr()
  {
    $args = func_get_args();
    return langtools::get_instance()->translate($args);
  }
}

?><?php

namespace __appbase;

function &smarty()
{
  return cms_smarty::get_instance();
}

function &nls()
{
  return nlstools::get_instance();
}

function &translator()
{
  return langtools::get_instance();
}

?><?php

namespace __appbase;

function &get_db()
{
  require_once(dirname(__DIR__).'/adodb_lite/adodb.inc.php');
  
}

?><?php

namespace __appbase;

class nlstools
{
  private static $_instance;
  private $_nls;

  protected function __construct() {}

  public static function &get_instance()
  {
    if( !self::$_instance ) self::$_instance = new nlstools();
    return self::$_instance;
  }

  public static function set_nlshandler(nlstools &$obj)
  {
    self::$_instance = $obj;
  }

  protected function get_nls_dir()
  {
    return app::get_rootdir().'/lib/nls';
  }

  protected function load_nls()
  {
    if( is_array($this->_nls) ) return;

    $rdi = new \RecursiveDirectoryIterator($this->get_nls_dir());
    $rii = new \RecursiveIteratorIterator($rdi);

    $this->_nls = array();
    foreach( $rii as $file => $info ) {
      if( !endswith($file,'.nls.php') ) continue;
      $name = basename($file);
      $name = trim(substr($name,6,strlen($name)-14)).'_nls';

      include($file);

      $tmp = __NAMESPACE__.'\\'.$name;
      $obj = new $tmp;
      if( !is_a($obj,__NAMESPACE__.'\nls') ) {
          unset($obj);
          continue;
      }
      $this->_nls[$name] = $obj;
    }
  }

  public function get_list()
  {
    $this->load_nls();
    return array_keys($this->_nls);
  }

  public function &find($str)
  {
    $this->load_nls();
    foreach( $this->_nls as $name => &$nls ){
      if( $str == $name ) return $nls;
      if( $nls->matches($str) ) return $nls;
    }
    $obj = null;
    return $obj;
  }
} // end of class

?>
<?php

namespace __appbase;

abstract class wizard_step
{
  public function __construct() {
    echo "DEBUG: create wizard step<br/>";
  }

  /**
   * Process the results of this step's form (POST only)
   */
  abstract protected function process();

  /**
   * Display information for this step
   */
  abstract protected function display();

  public function get_name() { return get_class($this); }
  public function get_description() { return null; }

  public function &get_wizard()
  {
    return wizard::get_instance();
  }

  public function cur_step()
  {
    return wizard::get_instance()->cur_step();
  }

  public function run()
  {
    $request = request::get();
    if( $request->is_post() ) $res = $this->process();
    $this->display();
    return wizard::STATUS_OK;
  }
} // end of class

?><?php

namespace __appbase;

function startswith($haystack,$needle)
{
  return (substr($haystack,0,strlen($needle)) == $needle);
}

function endswith($haystack,$needle)
{
  return (substr($haystack,-1*strlen($needle)) == $needle);
}

?>
<?php

namespace __appbase;

class request implements \ArrayAccess
{
  private static $_instance;
  private $_data;
  const METHOD_POST = 'POST';
  const METHOD_GET  = 'GET';

  private function __construct()
  {
  }

  public static function &get()
  {
    if( !self::$_instance ) self::$_instance = new request();
    return self::$_instance;
  }

  public function offsetExists($key)
  {
    if( isset($_REQUEST[$key]) ) return TRUE;
    return FALSE;
  }

  public function offsetGet($key)
  {
    if( isset($_REQUEST[$key]) ) return $_REQUEST[$key];
  }

  public function offsetSet($key,$value)
  {
    if( isset($_REQUEST[$key]) ) return $_REQUEST[$key];
  }


  public function offsetUnset($key)
  {
    throw new \Exception('Attempt to unset a request variable');
  }

  public function raw_server($key)
  {
    if( isset($_SERVER[$key]) )
      return $_SERVER[$key];
  }

  public function __call($fn,$args)
  {
    $key = strtoupper($fn);
    if( isset($_SERVER[$key]) )	return $this->raw_server($key);
    throw new \Exception('Call to unknown method '.$fn.' in request object');
  }

  public function self()
  {
    return $this->raw_server('PHP_SELF');
  }

  public function method()
  {
    if( $this->raw_server('REQUEST_METHOD') == 'POST' ) {
      return self::METHOD_POST;
    }
    elseif( $this->raw_server('REQUEST_METHOD') == 'GET' ) {
      return self::METHOD_GET;
    }
    throw new \Exception('Unhandled request method '.$_SERVER['REQUEST_METHOD']);
  }

  public function is_post()
  {
    return ($this->method() == self::METHOD_POST)?TRUE:FALSE;
  }

  public function is_get()
  {
    return ($this->method() == self::METHOD_GET)?TRUE:FALSE;
  }

  public function accept()
  {
    return $this->raw_server('HTTP_ACCEPT');
  }

  public function accept_charset()
  {
    return $this->raw_server('HTTP_ACCEPT_CHARSET');
  }

  public function accept_encoding()
  {
    return $this->raw_server('HTTP_ACCEPT_ENCODING');
  }

  public function accept_language()
  {
    return $this->raw_server('HTTP_ACCEPT_LANGUAGE');
  }

  public function host()
  {
    return $this->raw_server('HTTP_HOST');
  }

  public function referer()
  {
    return $this->raw_server('HTTP_REFERER');
  }

  public function user_agent()
  {
    return $this->raw_server('HTTP_USER_AGENT');
  }

  public function https()
  {
    if( isset($_SERVER['HTTPS']) && strtolower($_SERVER['HTTPS']) != 'on' ) return TRUE;
    return FALSE;
  }

} // end of class

?><?php

namespace __appbase;

final class session implements \ArrayAccess
{
  private static $_instance;
  private static $_session_id;
  private static $_key;
  private $_data;
  private function __construct() {}

  private static function start()
  {
      if( !self::$_key ) {
          $session_key = substr(md5(__DIR__),0,10);
          @session_name('CMSIC'.$session_key);
          @session_cache_limiter('nocache');
          $res = null;
          if( !@session_id() ) $res = @session_start();
          if( !$res ) throw new \RuntimeException('Problem starting the session (system configuration problem?)');
          self::$_session_id = session_id();
          self::$_key = 'k'.md5(self::$_session_id);
      }
  }

  private function _collapse()
  {
    self::start();
    if( $this->_data ) $_SESSION[self::$_key] = serialize($this->_data);
    $this->_data = null;
  }

  private function _expand()
  {
    self::start();
    if( !is_array($this->_data) ) {
      $this->_data = array();
      if( isset($_SESSION[self::$_key]) ) {
          $this->_data = unserialize($_SESSION[self::$_key]);
      }
    }
  }

  public static function clear()
  {
      self::start();
      unset($_SESSION[self::$_key]);
  }

  public static function get()
  {
    if( !self::$_instance ) self::$_instance = new session;
    return self::$_instance;
  }

  public function reset()
  {
      $this->_data = null;
      self::clear();
      $this->_expand();
  }

  public function offsetExists($key)
  {
    $this->_expand();
    if( isset($this->_data[$key]) ) return TRUE;
    return FALSE;
  }

  public function offsetGet($key)
  {
    $this->_expand();
    if( isset($this->_data[$key]) ) return $this->_data[$key];
  }

  public function offsetSet($key,$value)
  {
    $this->_expand();
    $this->_data[$key] = $value;
    $this->_collapse();
  }

  public function offsetUnset($key)
  {
    $this->_expand();
    if( isset($this->_data[$key]) ) {
      unset($this->_data[$key]);
      $this->_collapse();
    }
  }
} // end of class

?>
<?php

// compatibility stuff
if( !function_exists('gzopen') && function_exists('gzopen64') ) {
    function gzopen($filename , $mode , $use_include_path = 0) {
        return gzopen64($filename, $mode, $use_include_path);
    }
}

?><?php

namespace __appbase;

require_once(__DIR__.'/compat.functions.php');
require_once(__DIR__.'/misc.functions.php');
require_once(dirname(__DIR__).'/accessor.functions.php');

abstract class app
{
    const CONFIG_ROOT_URL = 'root_url';

    private static $_instance;
    private $_config;
    private $_appdir;

    public function __construct($filename)
    {
        if( is_object(self::$_instance) ) throw new \Exception('Cannot create another object of type app');
        self::$_instance = $this;

        spl_autoload_register(__NAMESPACE__.'\app::autoload');

        if( $filename ) {
            $this->_appdir = dirname($filename);
            $config_file = $this->_appdir.'/config.ini';
            if( file_exists($config_file) ) $this->_config = parse_ini_file($config_file);
        }
    }

    public static function &get_instance()
    {
        if( !is_object(self::$_instance) )	throw new \Exception('There is no registered app instance');
        return self::$_instance;
    }

    public function get_name()
    {
        return get_class();
    }

    public function get_tmpdir()
    {
        // not modifyiable, ye
        return \__appbase\utils::get_sys_tmpdir();
    }

    public static function get_appdir()
    {
        return self::$_instance->_appdir;
    }

    public static function get_rootdir()
    {
        return dirname(dirname(dirname(__DIR__)));
    }

    static public function get_rooturl()
    {
        $config = self::$_instance->config();
        if( $config && isset($config[self::CONFIG_ROOT_URL]) ) return $config[self::CONFIG_ROOT_URL];

        $request = request::get();
        $dir = dirname($request['SCRIPT_FILENAME']);
        return $dir;
    }

    public function get_config()
    {
        return $this->_config;
    }

    static public function clear_cache($do_index_html = TRUE)
    {
        $rdi = new \RecursiveDirectoryIterator($this->get_tmpdir());
        $rii = new \RecursiveIteratorIterator($rdi);
        foreach( $rii as $file => $info ) {
            if( $info->isFile() ) @unlink($info->getPathInfo());
        }

        if( $do_index_html ) {
            $rdi = new \RecursiveDirectoryIterator($this->get_tmpdir());
            $rii = new \RecursiveIteratorIterator($rdi);
            foreach( $rii as $file => $info ) {
                if( $info->isFile() ) @touch($info->getPathInfo().'/index.html');
            }
        }
    }

    static public function autoload($classname)
    {
        $dirsuffix = dirname(str_replace('\\','/',$classname));
        $classname = basename(str_replace('\\','/',$classname));
        $dirsuffix = str_replace('__appbase','.',$dirsuffix);
        //if( $dirsuffix == "__appbase" ) $dirsuffix = '.';

        $dirs = array(__DIR__,dirname(__DIR__),dirname(__DIR__).'/tests',dirname(__DIR__).'/base',dirname(dirname(__DIR__)) );
        foreach( $dirs as $dir ) {
            $fn = "$dir/$dirsuffix/class.$classname.php";
            if( file_exists($fn) ) {
                include_once($fn);
                return;
            }
        }
    }

    abstract function run();

} // end of class

function &get_app()
{
    return app::get_instance();
}

?>
<?php

namespace __appbase;

class utils
{
    private static $_writable_error = array();

    private function __construct() {}

    static public function redirect($to)
    {
        $_SERVER['PHP_SELF'] = null;
        $schema = $_SERVER['SERVER_PORT'] == '443' ? 'https' : 'http';
        $host = strlen($_SERVER['HTTP_HOST'])?$_SERVER['HTTP_HOST']:$_SERVER['SERVER_NAME'];

        $components = parse_url($to);
        if (count($components) > 0) {
            $to =  (isset($components['scheme']) && startswith($components['scheme'], 'http') ? $components['scheme'] : $schema) . '://';
            $to .= isset($components['host']) ? $components['host'] : $host;
            $to .= isset($components['port']) ? ':' . $components['port'] : '';
            if(isset($components['path'])) {
                if(in_array(substr($components['path'],0,1),array('\\','/'))) { //Path is absolute, just append.
                    $to .= $components['path'];
                }
                //Path is relative, append current directory first.
                else if (isset($_SERVER['PHP_SELF']) && !is_null($_SERVER['PHP_SELF'])) { //Apache
                    $to .= (strlen(dirname($_SERVER['PHP_SELF'])) > 1 ?  dirname($_SERVER['PHP_SELF']).'/' : '/') . $components['path'];
                }
                else if (isset($_SERVER['REQUEST_URI']) && !is_null($_SERVER['REQUEST_URI'])) { //Lighttpd
                    if (endswith($_SERVER['REQUEST_URI'], '/'))
                        $to .= (strlen($_SERVER['REQUEST_URI']) > 1 ? $_SERVER['REQUEST_URI'] : '/') . $components['path'];
                    else
                        $to .= (strlen(dirname($_SERVER['REQUEST_URI'])) > 1 ? dirname($_SERVER['REQUEST_URI']).'/' : '/') . $components['path'];
                }
            }
            else {
                $to .= $_SERVER['REQUEST_URI'];
            }
            $to .= isset($components['query']) ? '?' . $components['query'] : '';
            $to .= isset($components['fragment']) ? '#' . $components['fragment'] : '';
        }
        else {
            $to = $schema."://".$host."/".$to;
        }

        session_write_close();

        if(headers_sent() ) {
            // use javascript instead
            echo '<script type="text/javascript"><!-- location.replace("'.$to.'"); // --></script><noscript><meta http-equiv="Refresh" content="0;URL='.$to.'"></noscript>';
            exit;
        }
        else {
            header("Location: $to");
            exit();
        }
    }

    public static function to_bool($in,$strict = FALSE)
    {
        $in = strtolower((string) $in);
        if( in_array($in,array('1','y','yes','true','t','on')) ) return TRUE;
        if( in_array($in,array('0','n','no','false','f','off')) ) return FALSE;
        if( $strict ) return null;
        return ($in?TRUE:FALSE);
    }

    public static function clean_string($val)
    {
        if( !$val ) return $val;
        $val = (string) $val;
        $val = preg_replace("/\\\$/", "$", $val);
        $val = preg_replace("/\r/", "", $val);
        $val = str_replace("!", "!", $val);
        $val = str_replace("'", "'", $val);
        return strip_tags($val);
    }

    public static function get_sys_tmpdir()
    {
        $vars = array('TMP','TMPDIR','TEMP');
        foreach( $vars as $var ) {
            if( isset($_ENV[$var]) && $_ENV[$var] ) {
                $tmp = realpath($_ENV[$var]);
                if( $tmp && @is_dir($tmp) && @is_writable($tmp) ) return $tmp;
            }
        }

        $tmpdir = ini_get('upload_tmp_dir');
        if( $tmpdir && @is_dir($tmpdir) && @is_writable($tmpdir) ) return $tmpdir;

        if( function_exists('sys_get_temp_dir') ) {
            $tmp = rtrim(sys_get_temp_dir(),'\\/');
            if( $tmp && @is_dir($tmp) && @is_writable($tmp) ) return $tmp;
        }

        if( ini_get('safe_mode') != '1' ) {
            // last ditch effort to find a place to write to.
            $tmp = @tempnam('','xxx');
            if( $tmp && file_exists($tmp) ) {
                @unlink($tmp);
                return realpath(dirname($tmp));
            }
        }

        throw new \Exception('Could not find a writable location for temporary files');
    }

    public static function is_email($str)
    {
        return filter_var($str,FILTER_VALIDATE_EMAIL);
    }

    /**
     * Check the permissions of a directory recursively to make sure that
     * we have write permission to all files and folders.
     *
     * @param  string  $path Start directory.
     * @param  bool    $ignore_specialfiles  Optionally ignore special system files in the check.  Special files include files beginning with ., and php.ini files.
     * @return bool
     */
    public static function is_directory_writable( $path, $ignore_specialfiles = TRUE )
    {
        if ( substr ( $path , strlen ( $path ) - 1 ) != '/' ) $path .= '/' ;

        $result = TRUE;
        if( $handle = @opendir( $path ) ) {
            while( false !== ( $file = readdir( $handle ) ) ) {
                if( $file == '.' || $file == '..' ) continue;

                // ignore dotfiles, except .htaccess.
                if( $ignore_specialfiles ) {
                    if( $file[0] == '.' && $file != '.htaccess' ) continue;
                    if( $file == 'php.ini' ) continue;
                }

                $p = $path.$file;
                if( !@is_writable( $p ) ) {
                    self::$_writable_error[] = $p;
                    @closedir( $handle );
                    return FALSE;
                }

                if( @is_dir( $p ) ) {
                    $result = self::is_directory_writable( $p, $ignore_specialfiles );
                    if( !$result ) {
                        self::$_writable_error[] = $p;
                        @closedir( $handle );
                        return FALSE;
                    }
                }
            }
            @closedir( $handle );
        }
        else {
            self::$_writable_error[] = $p;
            return FALSE;
        }

        return TRUE;
    }


    public static function get_writable_error()
    {
        return self::$_writable_error;
    }

    public static function rrmdir($dir)
    {
        if (is_dir($dir)) {
            $objects = scandir($dir);
            foreach ($objects as $object) {
                if ($object != "." && $object != "..") {
                    if (filetype($dir."/".$object) == "dir") self::rrmdir($dir."/".$object); else unlink($dir."/".$object);
                }
            }
            reset($objects);
            rmdir($dir);
        }
    }

} // end of class
?>
<?php

namespace __appbase;

final class nb_NO_nls extends nls
{
  public function __construct()
  {
    $this->_fullname = 'Norwegian bokmål';
    $this->_display = 'Norsk bokmål';
    $this->_isocode = 'nb';
    $this->_locale = 'nb_NO';
    $this->_encoding = 'UTF-8';
    $this->_aliases = 'nb_NO.utf8,nb_NO.utf-8,nb_NO.UTF-8,nb_NO,nb_NO.ISO8859-1,nb_NO.ISO8859-15,norwegian,Norwegian_Norway.1252';
  }  
  
  
} // end of class

?>
<?php

namespace __appbase;

final class nl_NL_nls extends nls
{
  public function __construct()
  {
    $this->_fullname = 'Dutch';
    $this->_display = 'Nederlands';
    $this->_isocode = 'nl';
    $this->_locale = 'nl_NL';
    $this->_encoding = 'UTF-8';
    $this->_aliases = 'dutch,nl_NL.ISO8859-1';
  }  
  
  
} // end of class

?><?php

namespace __appbase;

final class de_DE_nls extends nls
{
  public function __construct()
  {
    $this->_fullname = 'German';
    $this->_display = 'Deutsch';
    $this->_isocode = 'de';
    $this->_locale = 'de_DE';
    $this->_encoding = 'UTF-8';
    $this->_aliases = 'german,de_DE.ISO8859-1';
  }

  
} // end of class

?><?php

namespace __appbase;

final class pt_PT_nls extends nls
{
  public function __construct()
  {
    $this->_fullname = 'Portuguese';
    $this->_display = 'Portugu&ecirc;s';
    $this->_isocode = 'pt';
    $this->_locale = 'pt_PT';
    $this->_encoding = 'UTF-8';
    $this->_aliases = 'portugguese,pt_PT.ISO8859-1';
  }  
  
  
} // end of class

?>
<?php

namespace __appbase;

final class fr_FR_nls extends nls
{
  public function __construct()
  {
    $this->_fullname = 'French';
    $this->_display = 'Fran&#231;ais';
    $this->_isocode = 'fr';
    $this->_locale = 'fr_FR';
    $this->_encoding = 'UTF-8';
    $this->_aliases = 'french,fre,fr_BE,fr_CA,fr_LU,fr_CH,fr_FR.ISO8859-1';
  }  
  
  
} // end of class

?><?php

namespace __appbase;

class en_US_nls extends nls
{
  public function __construct()
  {
    $this->_fullname = 'English';
	
    $this->_isocode = 'en';
    $this->_locale = 'en_US';
    $this->_encoding = 'UTF-8';
    $this->_aliases = 'english,eng,en_CA,en_GB,en_US.ISO8859-1';
  }  

  public function foo() { return 1; }
} // end of class

?><?php

namespace CMSMS\Database\mysqli;

class DataDictionary extends \CMSMS\Database\DataDictionary
{
    public function __construct(Connection $conn)
    {
        parent::__construct($conn);
        $this->alterCol = ' MODIFY COLUMN';
        $this->alterTableAddIndex = true;
        $this->dropTable = 'DROP TABLE IF EXISTS %s'; // requires mysql 3.22 or later

        $this->dropIndex = 'DROP INDEX %s ON %s';
        $this->renameColumn = 'ALTER TABLE %s CHANGE COLUMN %s %s %s';	// needs column-definition!
    }

    protected function ActualType($meta)
    {
        switch( $meta ) {
		case 'C': return 'VARCHAR';
		case 'XL':return 'LONGTEXT';
		case 'X': return 'TEXT';

		case 'C2': return 'VARCHAR';
		case 'X2': return 'LONGTEXT';

		case 'B': return 'LONGBLOB';

		case 'D': return 'DATE';
		case 'DT': return 'DATETIME';
		case 'T': return 'TIME';
		case 'TS': return 'TIMESTAMP';
		case 'L': return 'TINYINT';

		case 'R':
		case 'I4':
		case 'I': return 'INTEGER';
		case 'I1': return 'TINYINT';
		case 'I2': return 'SMALLINT';
		case 'I8': return 'BIGINT';

		case 'F': return 'DOUBLE';
		case 'N': return 'NUMERIC';
		default:
			return $meta;
		}
    }

    protected function MetaType($t,$len=-1,$fieldobj=false)
    {
        // $t can be mixed...
        if (is_object($t)) {
            $fieldobj = $t;
            $t = $fieldobj->type;
            $len = $fieldobj->max_length;
        }

        $len = -1; // mysql max_length is not accurate
        switch (strtoupper($t)) {
        case 'STRING':
        case 'CHAR':
        case 'VARCHAR':
        case 'TINYBLOB':
        case 'TINYTEXT':
        case 'ENUM':
        case 'SET':
            if ($len <= $this->blobSize) return 'C';

        case 'TEXT':
        case 'LONGTEXT':
        case 'MEDIUMTEXT':
            return 'X';

            // php_mysql extension always returns 'blob' even if 'text'
            // so we have to check whether binary...
        case 'IMAGE':
        case 'LONGBLOB':
        case 'BLOB':
        case 'MEDIUMBLOB':
            return !empty($fieldobj->binary) ? 'B' : 'X';

        case 'YEAR':
        case 'DATE': return 'D';

        case 'TIME':
        case 'DATETIME':
        case 'TIMESTAMP': return 'T';

        case 'INT':
        case 'INTEGER':
        case 'BIGINT':
        case 'TINYINT':
        case 'MEDIUMINT':
        case 'SMALLINT':
            if (!empty($fieldobj->primary_key)) return 'R';
            return 'I';

        default:
            static $typeMap = array(
                'VARCHAR' => 'C',
                'VARCHAR2' => 'C',
                'CHAR' => 'C',
                'C' => 'C',
                'STRING' => 'C',
                'NCHAR' => 'C',
                'NVARCHAR' => 'C',
                'VARYING' => 'C',
                'BPCHAR' => 'C',
                'CHARACTER' => 'C',
                ##
                'LONGCHAR' => 'X',
                'TEXT' => 'X',
                'NTEXT' => 'X',
                'M' => 'X',
                'X' => 'X',
                'CLOB' => 'X',
                'NCLOB' => 'X',
                'LVARCHAR' => 'X',
                ##
                'BLOB' => 'B',
                'IMAGE' => 'B',
                'BINARY' => 'B',
                'VARBINARY' => 'B',
                'LONGBINARY' => 'B',
                'B' => 'B',
                ##
                'YEAR' => 'D', // mysql
                'DATE' => 'D',
                'D' => 'D',
                ##
                'TIME' => 'T',
                'TIMESTAMP' => 'T',
                'DATETIME' => 'T',
                'TIMESTAMPTZ' => 'T',
                'T' => 'T',
                ##
                'BOOL' => 'L',
                'BOOLEAN' => 'L',
                'BIT' => 'L',
                'L' => 'L',
                ##
                'COUNTER' => 'R',
                'R' => 'R',
                'SERIAL' => 'R', // ifx
                'INT IDENTITY' => 'R',
                ##
                'INT' => 'I',
                'INT2' => 'I',
                'INT4' => 'I',
                'INT8' => 'I',
                'INTEGER' => 'I',
                'INTEGER UNSIGNED' => 'I',
                'SHORT' => 'I',
                'TINYINT' => 'I',
                'SMALLINT' => 'I',
                'I' => 'I',
                ##
                'LONG' => 'N', // interbase is numeric, oci8 is blob
                'BIGINT' => 'N', // this is bigger than PHP 32-bit integers
                'DECIMAL' => 'N',
                'DEC' => 'N',
                'REAL' => 'N',
                'DOUBLE' => 'N',
                'DOUBLE PRECISION' => 'N',
                'SMALLFLOAT' => 'N',
                'FLOAT' => 'N',
                'NUMBER' => 'N',
                'NUM' => 'N',
                'NUMERIC' => 'N',
                'MONEY' => 'N',

                ## informix 9.2
                'SQLINT' => 'I',
                'SQLSERIAL' => 'I',
                'SQLSMINT' => 'I',
                'SQLSMFLOAT' => 'N',
                'SQLFLOAT' => 'N',
                'SQLMONEY' => 'N',
                'SQLDECIMAL' => 'N',
                'SQLDATE' => 'D',
                'SQLVCHAR' => 'C',
                'SQLCHAR' => 'C',
                'SQLDTIME' => 'T',
                'SQLINTERVAL' => 'N',
                'SQLBYTES' => 'B',
                'SQLTEXT' => 'X',
                ## informix 10
                "SQLINT8" => 'I8',
                "SQLSERIAL8" => 'I8',
                "SQLNCHAR" => 'C',
                "SQLNVCHAR" => 'C',
                "SQLLVARCHAR" => 'X',
                "SQLBOOL" => 'L'
                );

            $tmap = false;
            $t = strtoupper($t);
            $tmap = (isset($typeMap[$t])) ? $typeMap[$t] : 'N';
            return $tmap;
        }
    }

    public function MetaTables()
    {
        $sql = 'SHOW TABLES';
        $list = $this->connection->GetCol($sql);
        if( count($list) ) return $list;
    }

    public function MetaColumns($table)
    {
        $table = trim($table);
        if( !$table ) throw new \LogicException('empty table name specified for '.__METHOD__);

        $sql = 'SHOW COLUMNS FROM ?';
        $rs = $this->connection->GetArray($sql,$table);
        if( is_array($rs) && count($rs) ) {
            $out = array();
            foreach( $rs as $row ) {
                $out[] = $row['Field'];
            }
            return $out;
        }
    }

    protected function _CreateSuffix($fname,$ftype,$fnotnull,$fdefault,$fautoinc,$fconstraint,$funsigned)
	{
		$suffix = '';
		if ($funsigned) $suffix .= ' UNSIGNED';
		if ($fnotnull) $suffix .= ' NOT NULL';
		if (strlen($fdefault)) $suffix .= " DEFAULT $fdefault";
		if ($fautoinc) $suffix .= ' AUTO_INCREMENT';
		if ($fconstraint) $suffix .= ' '.$fconstraint;
		return $suffix;
	}

    function _ProcessOptions($opts)
    {
        // fixes for old TYPE= stuff in tabopts.
        if( is_array($opts) && count($opts) ) {
            foreach( $opts as $key => &$val ) {
                if( startswith(strtolower($key),'mysql') ) {
                    $val = preg_replace('/TYPE\s?=/i','ENGINE=',$val);
                }
            }
        }
        return $opts;
    }

	function _IndexSQL($idxname, $tabname, $flds, $idxoptions)
	{
		$sql = array();

		if ( isset($idxoptions['REPLACE']) || isset($idxoptions['DROP']) ) {
			if ($this->alterTableAddIndex) $sql[] = "ALTER TABLE $tabname DROP INDEX $idxname";
			else $sql[] = sprintf($this->dropIndex, $idxname, $tabname);

			if ( isset($idxoptions['DROP']) ) return $sql;
		}

		if ( empty ($flds) ) return $sql;

		if (isset($idxoptions['FULLTEXT'])) {
			$unique = ' FULLTEXT';
		} elseif (isset($idxoptions['UNIQUE'])) {
			$unique = ' UNIQUE';
		} else {
			$unique = '';
		}

		if ( is_array($flds) ) $flds = implode(', ',$flds);

		if ($this->alterTableAddIndex) $s = "ALTER TABLE $tabname ADD $unique INDEX $idxname ";
		else $s = 'CREATE' . $unique . ' INDEX ' . $idxname . ' ON ' . $tabname;

		$s .= ' (' . $flds . ')';

        if( ($opts = $this->get_dbtype_options($idxoptions)) ) $s .= $opts;

		$sql[] = $s;

		return $sql;
	}

	function CreateTableSQL($tabname, $flds, $tableoptions=false)
	{
        $str = 'ENGINE=MyISAM CHARACTER SET utf8 COLLATE utf8_general_ci';
        $dbtype = $this->_DBType();

        // clean up input tableoptions
        if( !$tableoptions ) {
            $tableoptions = [ $dbtype => $str ];
        }
        else if( is_string($tableoptions) ) {
            $tableoptions = [ $dbtype => $tableoptions ];
        }
        else if( is_array($tableoptions) && !isset($tableoptions[$dbtype]) && isset($tableoptions['mysql']) ) {
            $tableoptions[$dbtype] = $tableoptions['mysql'];
        }
        else if( is_array($tableoptions) && !isset($tableoptions[$dbtype]) && isset($tableoptions['MYSQL']) ) {
            $tableoptions[$dbtype] = $tableoptions['MYSQL'];
        }

        foreach( $tableoptions as $key => &$val ) {
            if( strpos($val,'TYPE=') !== FALSE ) $val = str_replace('TYPE=','ENGINE=',$val);
        }
        if( isset($tableoptions[$dbtype]) && strpos($tableoptions[$dbtype],'CHARACTER') === FALSE &&
            strpos($tableoptions[$dbtype],'COLLATE') === FALSE ) {
            // if no character set and collate options specified, force UTF8
            $tableoptions[$dbtype] .= " CHARACTER SET utf8 COLLATE utf8_general_ci";
        }

        return parent::CreateTableSQL($tabname, $flds, $tableoptions);
	}

} // end of class
<?php

namespace CMSMS\Database\mysqli;

class Connection extends \CMSMS\Database\Connection
{
    private $_mysql;
    private $_in_transaction;
    private $_in_smart_transaction;
    private $_transaction_failed;

    public function DbType() { return 'mysqli'; }

    public function Connect()
    {
        if( !class_exists('\mysqli') ) throw new \LogicException("Configuration error... mysqli functions are not available");

        mysqli_report(MYSQLI_REPORT_STRICT);
        try {
            $this->_mysql = new \mysqli( $this->_connectionSpec->host, $this->_connectionSpec->username,
                                         $this->_connectionSpec->password,
                                         $this->_connectionSpec->dbname,
                                         (int) $this->_connectionSpec->port );
            if( $this->_mysql->connect_error ) {
                $this->_mysql = null;
                $this->OnError(self::ERROR_CONNECT,mysqli_connect_errno(),mysqli_connect_error());
                return FALSE;
            }
            return TRUE;
        }
        catch( \Exception $e ) {
            $this->_mysql = null;
            $this->OnError(self::ERROR_CONNECT,mysqli_connect_errno(),mysqli_connect_error());
            return FALSE;
        }
    }

    public function &NewDataDictionary()
    {
        $obj = new DataDictionary($this);
        return $obj;
    }

    public function Disconnect()
    {
        if( $this->_mysql ) {
            $this->_mysql->Close();
            $this->_mysql = null;
        }
    }

    public function &get_inner_mysql()
    {
        return $this->_mysql;
    }

    public function IsConnected()
    {
        return is_object($this->_mysql);
    }

    public function ErrorMsg()
    {
        if( $this->_mysql ) return $this->_mysql->error;
        return mysqli_connect_error();
    }

    public function ErrorNo()
    {
        if( $this->_mysql ) return $this->_mysql->errno;
        return mysqli_connect_errno();
    }

    public function Affected_Rows()
    {
        return $this->_mysql->affected_rows;
    }

    public function Insert_ID()
    {
        $res =  $this->_mysql->insert_id;
        return $res;
    }

    public function qstr($str)
    {
        // note... this could be a two way tcp/ip or socket communication
        return "'".$this->_mysql->escape_string($str)."'";
    }

    public function Concat()
    {
		$arr = func_get_args();
		$list = implode(', ', $arr);

		if (strlen($list) > 0) return "CONCAT($list)";
    }

    public function IfNull( $field, $ifNull )
    {
        return " IFNULL($field, $ifNull)";
    }

    protected function do_multisql($sql)
    {
        // no error checking for this stuff
        // and no return data
        $_t = $this->_mysql->multi_query($sql);
        if( $_t ) {
            do {
                $res = $this->_mysql->store_result();
            } while( $this->_mysql->more_results() && $this->_mysql->next_result() );
        }
    }

    public function &do_sql($sql)
    {
        // execute all queries, but only need the resultset from the last one.
        $resultset = null;
        $this->sql = $sql;
        $time_start = microtime(TRUE);
        $resultid = $this->_mysql->query( $sql );
        $time_total = microtime(TRUE) - $time_start;
        $this->query_time_total += $time_total;
        if( !$resultid ) {
            $this->FailTrans();
            $this->OnError(self::ERROR_EXECUTE,$this->_mysql->errno, $this->_mysql->error);
            return $resultset;
        }
        $this->add_debug_query($sql);
        $resultset = new ResultSet( $this->_mysql, $resultid, $sql );
        return $resultset;
    }

    public function &Prepare($sql)
    {
        $stmt = new Statement($this,$sql);
        return $stmt;
    }

    public function BeginTrans()
    {
        if( $this->_in_transaction ) {
            $this->OnError( self::ERROR_TRANSACTION, -1, 'Transactions cannot be nested');
            return FALSE;
        }
        $this->_in_transaction = TRUE;
        $this->_transaction_failed = FALSE;
        $this->do_multisql('SET AUTOCOMMIT=0; BEGIN');
        return TRUE;
    }

    public function StartTrans()
    {
        if( $this->_in_transaction ) {
            $this->OnError( self::ERROR_TRANSACTION, -1, 'Transactions cannot be nested');
            return FALSE;
        }
        $this->_in_smart_transaction = TRUE;
        $this->BeginTrans();
    }

    public function RollbackTrans()
    {
        if( !$this->_in_transaction ) {
            $this->OnError( self::ERROR_TRANSACTION, -1, 'BeginTrans has not been called');
            return FALSE;
        } else if( $this->_in_smart_transaction ) {
            $this->OnError( self::ERROR_TRANSACTION, -1, 'Smart and simple transactions cannot be mixed.');
            return FALSE;
        }

        $this->do_multisql('ROLLBACK; SET AUTOCOMMIT=1;');
        $this->_in_transaction = FALSE;
        return TRUE;
    }

	function CommitTrans($ok=true)
	{
		if (!$ok) return $this->RollbackTrans();

        if( !$this->_in_transaction ) {
            $this->OnError( self::ERROR_TRANSACTION, -1, 'BeginTrans has not been called');
            return FALSE;
        } else if( $this->_in_smart_transaction ) {
            $this->OnError( self::ERROR_TRANSACTION, -1, 'Smart and simple transactions cannot be mixed.');
            return FALSE;
        }

		$this->do_multisql('COMMIT; SET AUTOCOMMIT=1');
        $this->_in_transaction = FALSE;
		return TRUE;
	}

    public function CompleteTrans()
    {
        if( !$this->_in_transaction ) {
            $this->OnError( self::ERROR_TRANSACTION, -1, 'BeginTrans has not been called');
            return FALSE;
        } else if( !$this->_in_smart_transaction ) {
            $this->OnError( self::ERROR_TRANSACTION, -1, 'StartTrans has not been called');
            return FALSE;
        }

        $this->_in_smart_transaction = FALSE;
        if( $this->HasFailedTrans() ) {
            return $this->RollbackTrans();
        }
        else {
            return $this->CommitTrans();
        }
    }

    public function FailTrans()
    {
        if( $this->_in_transaction ) $this->_tranaction_failed = TRUE;
    }

    function HasFailedTrans()
    {
        if( $this->_in_transaction ) return $this->_transaction_failed;
        return FALSE;
    }

    public function GenID($seqname)
    {
        $sql = sprintf('UPDATE %s SET id=id+1;',$seqname);
        $this->Execute($sql);
        $sql = sprintf('SELECT id FROM %s',$seqname);
        return (int) $this->GetOne($sql);
    }

    public function CreateSequence($seqname,$startID=0)
    {
        $out = array();
        $startID = (int) $startID;
        $out[] = sprintf('CREATE TABLE %s (id int not null) ENGINE MyISAM',$seqname);
        $out[] = sprintf('INSERT INTO %s (id) values (%s)',$seqname,$startID);
        $dict = $this->NewDataDictionary();
        $dict->ExecuteSQLArray($out);
        return TRUE;
    }

    public function DropSequence($seqname)
    {
        return $this->Execute(sprintf('DROP TABLE %s',$seqname));
    }
} // end of class
<?php

namespace CMSMS\Database\mysqli;

class ResultSet extends \CMSMS\Database\ResultSet
{
    private $_connection;
    private $_resultId;
    private $_fields;
    private $_nrows;
    private $_pos;
    private $_sql;

    public function __construct(\mysqli $conn, $resultId, $sql = null)
    {
        $this->_connection = $conn;
        $this->_resultId = $resultId;
        $this->_pos = 0;
        $this->_nrows = 0;
        $this->_sql = $sql;
        if( is_object($resultId) ) $this->_nrows = mysqli_num_rows( $resultId );
        if( !$this->EOF() ) $this->fetch_row();
    }

    public function __destruct()
    {
        if( $this->resultId ) mysqli_free_result( $this->resultId );
    }

    public function Close()
    {
        if( $this->resultId ) mysqli_free_result( $this->resultId );
        $this->_fields = $this->resultId = null;
    }

    public function Fields( $key = null )
    {
        $key = (string) $key;
        if( empty($key) ) return $this->_fields;
        return $this->fields[$key];
    }

    public function RecordCount()
    {
        return $this->_nrows;
    }

    public function EOF()
    {
        return ($this->_nrows == 0 || $this->_pos < 0 || $this->_pos >= $this->_nrows);
    }

    protected function Move($idx)
    {
        if( $idx == $this->_pos ) return TRUE;
        if( $idx >= 0 && $idx < $this->_nrows ) {
            if( mysqli_data_seek($this->_resultId, $idx) ) {
                $this->_pos = $idx;
                $this->fetch_row();
                return TRUE;
            }
        }
        $this->_pos = $this->_nrows;
        return FALSE;
    }

    public function MoveFirst()
    {
        if( $this->_pos == 0 ) return TRUE;
        return $this->Move(0);
    }

    public function MoveNext()
    {
        return $this->Move($this->_pos+1);
    }

    protected function fetch_row()
    {
        if( !$this->EOF() ) $this->_fields = mysqli_fetch_array($this->_resultId, MYSQLI_ASSOC);
    }

} // end of class
<?php

namespace CMSMS\Database\mysqli;

class Statement extends \CMSMS\Database\Statement
{
    private $_data;

    // meta...
    private $_bind;
    private $_bound;
    private $_types;
    private $_stmt; // the statement object.
    private $_meta; // after first execute
    private $_num_rows; // after first execute
    private $_row; // updates after each execute for queries with a resultset
    private $_pos; // updates after each execute for queries with a resultset

    public function __construct(Connection $conn,$sql = null)
    {
        // this is just for type checking.
        parent::__construct($conn,$sql);
    }

    public function __destruct()
    {
        if( $this->_stmt ) {
            $this->_stmt->free_result();
            $this->_stmt->close();
        }
    }

    protected function get_type_char($var)
    {
        $t = gettype($var);
        switch( $t ) {
        case 'double':
            return 'd';
        case 'boolean':
        case 'integer':
            return 'i';
        case 'string':
        default:
            return 's';
        }
    }

    protected function set_bound_data($data)
    {
        $this->_data = $data;
        reset($this->_data);
    }

    protected function bind_params()
    {
        if( !$this->_stmt ) $this->prepare($this->sql);

        // get the type string
        $this->types = '';
        $keys = null;
        $args = func_get_args();
        if( count($args) == 1 && is_array($args) && is_array($args[0]) ) {
            // we expect that the data is an associtive array
            $row = $args[0];
            foreach( $row as $key => $val ) {
            	$this->_types .= $this->get_type_char($val);
            }
            $this->_bind = array_values($row);
            $keys = array_keys($row);
        } else {
            // function called with numerous parameters... get their types
            $keys = array_keys($args);
            foreach( $args as $val ) {
                $this->_types .= $this->get_type_char($val);
            }
            $this->_bind = array_values($args);
        }

        $this->_bound = array();
        $this->_bound[] =& $this->_types;
        for( $i = 0; $i < count($keys); $i++ ) {
            $this->_bound[] =& $this->_bind[$i];
        }
        call_user_func_array(array($this->_stmt,'bind_param'),$this->_bound);
    }

    protected function prepare($sql)
    {
        $conn = $this->db->get_inner_mysql();
        if( !$conn || !$this->db->IsConnected() ) throw new \LogicException('Attempt to create prepared statement when database is not connected');
        $this->_stmt = $conn->prepare( (string) $sql );
        $this->_row = null;
        $this->_pos = 0;
    }

    public function Bind(array $data)
    {
        parent::Bind($data);
        $first = $data[0];
        $this->bind_params($first);
    }

    public function EOF()
    {
        if( $this->_meta ) return ($this->_pos >= $this->_num_rows);
        if( !$this->_data ) return TRUE;
        return (current($this->_data) === FALSE);
    }

    public function MoveFirst()
    {
        if( $this->_meta ) $this->_stmt->data_seek(0);
        if( $this->_data ) reset($this->_data);
    }

    public function MoveNext()
    {
        if( $this->_meta ) $this->_pos = $this->_pos + 1;
        if( $this->_data ) next($this->_data);
    }

    public function Fields($col = null)
    {
        $row = null;
        if( $this->_stmt ) {
            $this->_stmt->fetch();
            $row = $this->_row;
        }
        if( !$row && $this->_data ) $row = current($this->_data);
        if( !$row ) return; // nothing

        if( $col ) {
            if( isset($row[$col]) ) return $row[$col];
        } else {
            return $row;
        }
    }

    public function Execute()
    {
        if( !$this->_stmt ) $this->prepare($this->_sql);
        $args = func_get_args();
        if( count($args) == 1 && is_array($args) && is_array($args[0]) ) $args = $args[0];

        /* if we have param count, find some arguments... either via the execute method... or via bound params */
        $pc = $this->_stmt->param_count;
        $fc = $this->_stmt->field_count;
        if( $args ) {
            $this->_data = $args;
            $this->bind_params($args);
        }
        if( $pc ) {
            // we are expecting paramers
            if( !count($args) ) {
                // get the arguments via the bound data current row.
                if( !$this->_bind ) throw new \LogicException('No bound parameters, and no arguments passed');
                if( count($this->_bind) != $pc ) throw new \LogicException('Incorrect number of bound parameters.  Expecting '.$this->_stmt->field_count);
                $args = $this->Fields();
            }
        }
        if( $pc != count($args) ) throw new \LogicException('Incorrect number of arguments. Expecting '.$pc);

        if( $args ) {
            // update bound values
            $keys = array_keys($args);
            for( $i = 0; $i < count($this->_bind); $i++ ) {
                $this->_bind[$i] = $args[$keys[$i]];
            }
        }

        $res = $this->_stmt->execute();
        if( !$res ) die('ERROR: '.$this->_stmt->error."\n");

        $this->_stmt->store_result();

        $meta = $this->_stmt->result_metadata();
        if( !$this->_meta && $meta ) {
            $this->_num_rows = $this->_stmt->num_rows;
            $this->_meta = $meta;
            $this->_row = array();
            while( $field = $this->_meta->fetch_field() ) {
                $this->_row[$field->name] = null;
                $params[] =& $this->_row[$field->name];
            }
            call_user_func_array(array($this->_stmt,'bind_result'),$params);
        }
    }
}
<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: \CMSMS\Database\DataDictionary (c) 2015 by Robert Campbell
#         (calguy1000@cmsmadesimple.org)
#  A class to define methods of interacting with database tables.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# Visit our homepage at: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

/**
 * This file defines the DataDictionary class.
 *
 * This file is based on the DataDictionary base class from the adodb_lite library
 * which was in turn a fork of the adodb library at approximately 2004.
 *
 * Credits and kudos to the authors of those packages.
 *
 * @package CMS
 */

namespace CMSMS\Database;

// shouldn't need this.
if (!function_exists('ctype_alnum')) {
    /**
     * @ignore
     */
	function ctype_alnum($text) {
		return preg_match('/^[a-z0-9]*$/i', $text);
	}
}

/**
 * @ignore
 */
function _array_change_key_case($an_array)
{
	if (is_array($an_array)) {
		$new_array = array();
		foreach($an_array as $key=>$value)
			$new_array[strtoupper($key)] = $value;

	   	return $new_array;
   }

	return $an_array;
}

/**
 * @ignore
 */
function Lens_ParseArgs($args,$endstmtchar=',',$tokenchars='_.-')
{
	$pos = 0;
	$intoken = false;
	$stmtno = 0;
	$endquote = false;
	$tokens = array();
	$tokens[$stmtno] = array();
	$max = strlen($args);
	$quoted = false;

	while ($pos < $max) {
		$ch = substr($args,$pos,1);
		switch($ch) {
		case ' ':
		case "\t":
		case "\n":
		case "\r":
			if (!$quoted) {
				if ($intoken) {
					$intoken = false;
					$tokens[$stmtno][] = implode('',$tokarr);
				}
				break;
			}
			$tokarr[] = $ch;
			break;
		case '`':
			if ($intoken) $tokarr[] = $ch;
		case '(':
		case ')':
		case '"':
		case "'":
			if ($intoken) {
				if (empty($endquote)) {
					$tokens[$stmtno][] = implode('',$tokarr);
					if ($ch == '(') $endquote = ')';
					else $endquote = $ch;
					$quoted = true;
					$intoken = true;
					$tokarr = array();
				} else if ($endquote == $ch) {
					$ch2 = substr($args,$pos+1,1);
					if ($ch2 == $endquote) {
						$pos += 1;
						$tokarr[] = $ch2;
					} else {
						$quoted = false;
						$intoken = false;
						$tokens[$stmtno][] = implode('',$tokarr);
						$endquote = '';
					}
				} else
					$tokarr[] = $ch;
			}else {
				if ($ch == '(') $endquote = ')';
				else $endquote = $ch;
				$quoted = true;
				$intoken = true;
				$tokarr = array();
				if ($ch == '`') $tokarr[] = '`';
			}
			break;
		default:
			if (!$intoken) {
				if ($ch == $endstmtchar) {
					$stmtno += 1;
					$tokens[$stmtno] = array();
					break;
				}
				$intoken = true;
				$quoted = false;
				$endquote = false;
				$tokarr = array();
			}
			if ($quoted) $tokarr[] = $ch;
			else if (ctype_alnum($ch) || strpos($tokenchars,$ch) !== false) $tokarr[] = $ch;
			else {
				if ($ch == $endstmtchar) {
					$tokens[$stmtno][] = implode('',$tokarr);
					$stmtno += 1;
					$tokens[$stmtno] = array();
					$intoken = false;
					$tokarr = array();
					break;
				}
				$tokens[$stmtno][] = implode('',$tokarr);
				$tokens[$stmtno][] = $ch;
				$intoken = false;
			}
		}
		$pos += 1;
	}
	if ($intoken) $tokens[$stmtno][] = implode('',$tokarr);

	return $tokens;
}


/**
 * A class defining methods to work directly with database tables.
 *
 * This file is based on the DataDictionary base class from the adodb_lite library
 * which was in turn a fork of the adodb library at approximately 2004.
 *
 * Credits and kudos to the authors of those packages.
 *
 * @package CMS
 * @author Robert Campbell
 * @copyright Copyright (c) 2015, Robert Campbell <calguy1000@cmsmadesimple.org>
 * @since 2.2
 */
abstract class DataDictionary
{
    /**
     * The database connection object.
     *
     * @internal
     */
	protected $connection;

    /**
     * The SQL prefix to use when creating a drop table command.
     *
     * @internal
     */
	protected $dropTable = 'DROP TABLE %s';

    /**
     * The SQL prefix to use when renaming a table.
     *
     * @internal
     */
	protected $renameTable = 'RENAME TABLE %s TO %s';

    /**
     * The SQL prefix to use when dropping an index.
     *
     * @internal
     */
	protected $dropIndex = 'DROP INDEX %s';

    /**
     * The SQL string to use (in the alter table command) when adding a column.
     *
     * @internal
     */
	protected $addCol = ' ADD';

    /**
     * The SQL string to use (in the alter table command) when altering a column.
     *
     * @internal
     */
	protected $alterCol = ' ALTER COLUMN';

    /**
     * The SQL string to use (in the alter table command) when dropping a column.
     *
     * @internal
     */
	protected $dropCol = ' DROP COLUMN';

    /**
     * The SQL command template for renaming a column.
     *
     * @internal
     */
	protected $renameColumn = 'ALTER TABLE %s RENAME COLUMN %s TO %s';	// table, old-column, new-column, column-definitions (not used by default)

    /**
     * @ignore
     */
	protected $nameRegex = '\w';

    /**
     * @ignore
     */
	protected $nameRegexBrackets = 'a-zA-Z0-9_\(\)';

    /**
     * @ignore
     */
	protected $autoIncrement = false;

    /**
     * @ignore
     */
	protected $invalidResizeTypes4 = array('CLOB','BLOB','TEXT','DATE','TIME'); // for changetablesql

    /**
     * Constructor
     *
     * @param \CMSMS\Database\Connection $conn
     */
    protected function __construct(Connection $conn)
    {
        $this->connection = $conn;
    }

    /**
     * A function to return the database type.
     *
     * @internal
     * @return string
     */
    protected function _DBType() { return $this->connection->DbType(); }

    /**
     * A function to return the datadictionary meta type for a database column type.
     *
     * @internal
     * @param string $t The database column type
     * @param int $len The length of the field (some database types may ignore this)
     * @param mixed $fieldobj An optional reference to a field object (advanced)
     * @return string
     */
	abstract protected function MetaType($t,$len=-1,$fieldobj=false);

    /**
     * Return the list of tables in the currently connected database.
     *
     * @return string[]
     */
    abstract public function MetaTables();

    /**
     * Return the list of columns in a table within the currently connected database.
     *
     * @param string $table The table name.
     * @return string[]
     */
    abstract public function MetaColumns($table);

    /**
     * Return a database specific column type given a datadictionary meta column type.
     *
     * @internal
     * @param string $meta The datadictionary column type.
     * @return string
     */
	abstract protected function ActualType($meta);

    /**
     * Given a string name, return a quoted name in a form suitable for the database.
     *
     * @internal
     * @param string $name The input name
     * @param bool $allowBrackets wether brackets should be quoted or not.
     * @return string
     */
	protected function NameQuote($name = NULL,$allowBrackets=false)
	{
		if (!is_string($name)) return FALSE;

		$name = trim($name);

		if ( !is_object($this->connection) ) return $name;

		$quote = $this->connection->nameQuote;

		// if name is of the form `name`, quote it
		if ( preg_match('/^`(.+)`$/', $name, $matches) ) return $quote . $matches[1] . $quote;

		// if name contains special characters, quote it
		$regex = ($allowBrackets) ? $this->nameRegexBrackets : $this->nameRegex;

		if ( !preg_match('/^[' . $regex . ']+$/', $name) ) return $quote . $name . $quote;

		return $name;
	}

    /**
     * Given a table name, optionally quote it.
     *
     * @internal
     * @param string $name
     * @return string
     */
	protected function TableName($name)
	{
		return $this->NameQuote($name);
	}

    /**
     * Given an array of SQL commands execute them in sequence.
     *
     * @param string[] $sql An array of sql commands.
     * @param bool $continueOnError wether to continue on errors or not.
     * @return int 2 for no errors, 1 if an error occured.
     */
	public function ExecuteSQLArray($sql, $continueOnError = true)
	{
		$rez = 2;
		$conn = &$this->connection;
		foreach($sql as $line) {
            try {
                $ok = $conn->Execute($line);
                if (!$ok) {
                    if (!$continueOnError) return 0;
                    $rez = 1;
                }
            }
            catch( \Exception $e ) {
                if( !$continueOnError ) throw $e;
                $rez = 1;
                // eat the exception
            }
		}
		return $rez;
	}

    /**
     * Create the SQL commands that will result in a database being created.
     *
     * @param string $dbname
     * @param array  An associative array of database options.
     * @return string[] An array of strings suitable for use with the ExecuteSQLArray method
     */
	public function CreateDatabase($dbname,$options=false)
	{
		$options = $this->_Options($options);
		$sql = array();

		$s = 'CREATE DATABASE ' . $this->NameQuote($dbname);
		if (isset($options[$this->upperName]))
			$s .= ' '.$options[$this->upperName];

		$sql[] = $s;
		return $sql;
	}

	/**
     * Generate the SQL to create an index.
     *
     * @param string $idxname The index name
     * @param string $tabname The table name
     * @param string|string[] $flds A list of the table fields to create the index with.  Either an array of strings or a comma separated list.
     * @param array An associative array of options
     * @return string[] An array of strings suitable for use with the ExecuteSQLArray method
	*/
	public function CreateIndexSQL($idxname, $tabname, $flds, $idxoptions = false)
	{
		if (!is_array($flds)) {
			$flds = explode(',',$flds);
		}
		foreach($flds as $key => $fld) {
			# some indexes can use partial fields, eg. index first 32 chars of "name" with NAME(32)
			$flds[$key] = $this->NameQuote($fld,$allowBrackets=true);
		}
		return $this->_IndexSQL($this->NameQuote($idxname), $this->TableName($tabname), $flds, $this->_Options($idxoptions));
	}

    /**
     * Generate the SQL to drop an index
     *
     * @param string $idxname The index name
     * @param string $tabname The table name
     * @return string[] An array of strings suitable for use with the ExecuteSQLArray method
     */
	public function DropIndexSQL ($idxname, $tabname = NULL)
	{
		return array(sprintf($this->dropIndex, $this->NameQuote($idxname), $this->TableName($tabname)));
	}

    /**
     * Generate the SQL to add columns to a table.
     *
     * @param string $tabname The Table name.
     * @param string $flds The column definitions (using DataDictionary meta types)
     * @return string[] An array of strings suitable for use with the ExecuteSQLArray method
     * @see CreateTableSQL
     */
	public function AddColumnSQL($tabname, $flds)
	{
		$tabname = $this->TableName ($tabname);
		$sql = array();
		list($lines,$pkey) = $this->_GenFields($flds);
		$alter = 'ALTER TABLE ' . $tabname . $this->addCol . ' ';
		foreach($lines as $v) {
			$sql[] = $alter . $v;
		}
		return $sql;
	}

	/**
	 * Change the definition of one column
	 *
	 * @param string $tabname table-name
	 * @param string $flds column-name and type for the changed column.
	 * @param string $tableflds complete defintion of the new table, eg. for postgres, default ''
	 * @param array/string $tableoptions options for the new table see CreateTableSQL, default ''
     * @return string[] An array of strings suitable for use with the ExecuteSQLArray method
	 */
	public function AlterColumnSQL($tabname, $flds, $tableflds='',$tableoptions='')
	{
		$tabname = $this->TableName ($tabname);
		$sql = array();
		list($lines,$pkey) = $this->_GenFields($flds);
		$alter = 'ALTER TABLE ' . $tabname . $this->alterCol . ' ';
		foreach($lines as $v) {
			$sql[] = $alter . $v;
		}
		return $sql;
	}

	/**
	 * Rename one column in a table.
	 *
	 * @param string $tabname table-name
	 * @param string $oldcolumn column-name to be renamed
	 * @param string $newcolumn new column-name
	 * @param string $flds complete column-defintion-string like for AddColumnSQL, only used by mysql atm., default=''
     * @return string[] An array of strings suitable for use with the ExecuteSQLArray method
	 */
	public function RenameColumnSQL($tabname,$oldcolumn,$newcolumn,$flds='')
	{
		$tabname = $this->TableName ($tabname);
		if ($flds) {
			list($lines,$pkey) = $this->_GenFields($flds);
			list(,$first) = each($lines);
			list(,$column_def) = split("[\t ]+",$first,2);
		}
		return array(sprintf($this->renameColumn,$tabname,$this->NameQuote($oldcolumn),$this->NameQuote($newcolumn),$column_def));
	}

	/**
	 * Drop one column from a table.
	 *
	 * @param string $tabname table-name
	 * @param string $flds column-name and type for the changed column
	 * @param string $tableflds complete defintion of the new table, eg. for postgres, default ''
	 * @param array/string $tableoptions options for the new table see CreateTableSQL, default ''
     * @return string[] An array of strings suitable for use with the ExecuteSQLArray method
	 */
	public function DropColumnSQL($tabname, $flds, $tableflds='',$tableoptions='')
	{
		$tabname = $this->TableName ($tabname);
		if (!is_array($flds)) $flds = explode(',',$flds);
		$sql = array();
		$alter = 'ALTER TABLE ' . $tabname . $this->dropCol . ' ';
		foreach($flds as $v) {
			$sql[] = $alter . $this->NameQuote($v);
		}
		return $sql;
	}

    /**
     * Drop one table, and all of it's indexes
     *
     * @param string $tabname The table name to drop.
     * @return string[] An array of strings suitable for use with the ExecuteSQLArray method
     */
	public function DropTableSQL($tabname)
	{
		return array (sprintf($this->dropTable, $this->TableName($tabname)));
	}

    /**
     * Rename a table.
     *
     * @param string $tabname The table name
     * @param string $newname The new table name
     * @return string[] An array of strings suitable for use with the ExecuteSQLArray method
     */
	public function RenameTableSQL($tabname,$newname)
	{
		return array (sprintf($this->renameTable, $this->TableName($tabname),$this->TableName($newname)));
	}

	/**
     * Generate the SQL to create a new table.
     *
     * The flds string is a comma separated of field definitions, where each definition is of the form
     *    fieldname type columnsize otheroptions
     *
     * The type fields are codes that map to real database types as follows:
     * <dl>
     *  <dt>C</dt>
     *  <dd>Varchar, capped to 255 characters.</dd>
     *  <dt>X</dt>
     *  <dd>Text</dd>
     *  <dt>XL</dt>
     *  <dd>LongText</dd>
     *  <dt>C2</dt>
     *  <dd>Varchar, capped to 255 characters</dd>
     *  <dt>XL</dt>
     *  <dd>LongText</dd>
     *  <dt>B</dt>
     *  <dd>LongBlob</dd>
     *  <dt>D</dt>
     *  <dd>Date</dd>
     *  <dt>DT</dt>
     *  <dd>DateTime</dd>
     *  <dt>T</dt>
     *  <dd>Time</dd>
     *  <dt>TS</dt>
     *  <dd>Timestamp</dd>
     *  <dt>L</dt>
     *  <dd>TinyInt</dd>
     *  <dt>R / I4 / I</dt>
     *  <dd>Integer</dd>
     *  <dt>I1</dt>
     *  <dd>TinyInt</dd>
     *  <dt>I2</dt>
     *  <dd>SmallInt</dd>
     *  <dt>I4</dt>
     *  <dd>BigInt</dd>
     *  <dt>F</dt>
     *  <dd>Double</dd>
     *  <dt>N</dt>
     *  <dd>Numeric</dd>
     *</dl>
     *
     * The otheroptions field includes the following options:
     *<dl>
     *  <dt>AUTO</dt>
     *  <dd>Auto increment. Also sets NOTNULL.</dd>
     *  <dt>AUTOINCREMENT</dt>
     *  <dd>Same as AUTO</dd>
     *  <dt>KEY</dt>
     *  <dd>Primary key field.  Also sets NOTNULL. Compound keys are supported.</dd>
     *  <dt>PRImARY</dt>
     *  <dd>Same as KEY</dd>
     *  <dt>DEFAULT</dt>
     *  <dd>The default value.  Character strings are auto-quoted unless the string begins with a space.  i.e: ' SYSDATE '.</dd>
     *  <dt>DEF</dt>
     *  <dd>Same as DEFAULT</dd>
     *  <dt>CONSTRAINTS</dt>
     *  <dd>Additional constraints defined at the end of the field definition.</dd>
     *</dl>
     *
     * @param string $tabname The table name
     * @param string $flds a comma separated list of field definitions using datadictionary syntax.
     * @param mixed  $tableoptions A string specifying table options (database driver specific) for the table creation command.  Or an associative array of table options, keys being the database type (as available).
     * @return string[] An array of strings suitable for use with the ExecuteSQLArray method
     */
	public function CreateTableSQL($tabname, $flds, $tableoptions=false)
	{
        if( $tableoptions && is_string($tableoptions)) {
            $dbtype = $this->_DBType();
            $tableoptions = [ $dbtype => $tableoptions ];
        }

        list($lines,$pkey) = $this->_GenFields($flds, true);
		$taboptions = $this->_Options($tableoptions);
		$tabname = $this->TableName ($tabname);
		$sql = $this->_TableSQL($tabname,$lines,$pkey,$taboptions);
		$tsql = $this->_Triggers($tabname,$taboptions);
		foreach($tsql as $s) $sql[] = $s;

		return $sql;
	}

    /**
     * Part of the process of parsing the datadictionary format into database specific commands.
     *
     * @internal
     */
	protected function _GenFields($flds,$widespacing=false)
	{
		if (is_string($flds)) {
			$padding = '	 ';
			$txt = $flds.$padding;
			$flds = array();
			$flds0 = Lens_ParseArgs($txt,',');
			$hasparam = false;
			foreach($flds0 as $f0) {
                if( !count($f0) ) break;
				$f1 = array();
				foreach($f0 as $token) {
					switch (strtoupper($token)) {
					case 'CONSTRAINT':
					case 'DEFAULT':
						$hasparam = $token;
						break;
					default:
						if ($hasparam) $f1[$hasparam] = $token;
						else $f1[] = $token;
						$hasparam = false;
						break;
					}
				}
				$flds[] = $f1;
			}
		}
		$this->autoIncrement = false;
		$lines = array();
		$pkey = array();
		foreach($flds as $fld) {
			$fld = _array_change_key_case($fld);
			$fname = false;
			$fdefault = false;
			$fautoinc = false;
			$ftype = false;
			$fsize = false;
			$fprec = false;
			$fprimary = false;
			$fnoquote = false;
			$fdefts = false;
			$fdefdate = false;
			$fconstraint = false;
			$fnotnull = false;
			$funsigned = false;

			//-----------------
			// Parse attributes
			foreach($fld as $attr => $v) {
				if ($attr == 2 && is_numeric($v)) $attr = 'SIZE';
				else if (is_numeric($attr) && $attr > 1 && !is_numeric($v)) $attr = strtoupper($v);
				switch($attr) {
					case '0':
					case 'NAME':
						$fname = $v;
						break;
					case '1':
					case 'TYPE':
						$ty = $v; $ftype = $this->ActualType(strtoupper($v));
						break;
					case 'SIZE':
						$dotat = strpos($v,'.');
						if ($dotat === false) $dotat = strpos($v,',');
						if ($dotat === false) $fsize = $v;
						else {
								$fsize = substr($v,0,$dotat);
								$fprec = substr($v,$dotat+1);
							}
						break;
					case 'UNSIGNED':
						$funsigned = true;
						break;
					case 'AUTOINCREMENT':
					case 'AUTO':
						$fautoinc = true;
						$fnotnull = true;
						break;
					case 'KEY':
					case 'PRIMARY':
						$fprimary = $v;
						$fnotnull = true;
						break;
					case 'DEF':
					case 'DEFAULT':
						$fdefault = $v;
						break;
					case 'NOTNULL':
						$fnotnull = $v;
						break;
					case 'NOQUOTE':
						$fnoquote = $v;
						break;
					case 'DEFDATE':
						$fdefdate = $v;
						break;
					case 'DEFTIMESTAMP':
						$fdefts = $v;
						break;
					case 'CONSTRAINT':
						$fconstraint = $v;
						break;
				}
			}

			//--------------------
			// VALIDATE FIELD INFO
			if (!strlen($fname)) {
                die('failed');
				return false;
			}

			$fid = strtoupper(preg_replace('/^`(.+)`$/', '$1', $fname));
			$fname = $this->NameQuote($fname);

			if (!strlen($ftype)) {
				return false;
			} else {
				$ftype = strtoupper($ftype);
			}

			$ftype = $this->_GetSize($ftype, $ty, $fsize, $fprec);

			if ($ty == 'X' || $ty == 'X2' || $ty == 'B') $fnotnull = false; // some blob types do not accept nulls

			if ($fprimary) $pkey[] = $fname;

			// some databases do not allow blobs to have defaults
			if ($ty == 'X') $fdefault = false;

			//--------------------
			// CONSTRUCT FIELD SQL
			if ($fdefts) {
				if (substr($this->_DbType(),0,5) == 'mysql') {
					$ftype = 'TIMESTAMP';
				} else {
					$fdefault = $this->connection->sysTimeStamp;
				}
			} else if ($fdefdate) {
				if (substr($this->_DBType(),0,5) == 'mysql') {
					$ftype = 'TIMESTAMP';
				} else {
					$fdefault = $this->connection->sysDate;
				}
			} else if ($fdefault !== false && !$fnoquote)
				if ($ty == 'C' or $ty == 'X' or
					( substr($fdefault,0,1) != "'" && !is_numeric($fdefault)))
					if (strlen($fdefault) != 1 && substr($fdefault,0,1) == ' ' && substr($fdefault,strlen($fdefault)-1) == ' ')
						$fdefault = trim($fdefault);
					else if (strtolower($fdefault) != 'null')
						$fdefault = $this->connection->qstr($fdefault);
			$suffix = $this->_CreateSuffix($fname,$ftype,$fnotnull,$fdefault,$fautoinc,$fconstraint,$funsigned);

			if ($widespacing) $fname = str_pad($fname,24);
			$lines[$fid] = $fname.' '.$ftype.$suffix;

			if ($fautoinc) $this->autoIncrement = true;
		} // foreach $flds
		return array($lines,$pkey);
	}

	/**
     * Generate the size part of the datatype.
     *
     * @ignore
     * @internal
     */
	protected function _GetSize($ftype, $ty, $fsize, $fprec)
	{
		if (strlen($fsize) && $ty != 'X' && $ty != 'B' && strpos($ftype,'(') === false) {
			$ftype .= "(".$fsize;
			if (strlen($fprec)) $ftype .= ",".$fprec;
			$ftype .= ')';
		}
		return $ftype;
	}

    /**
     * Create a suffix
     *
     * @internal
     */
	protected function _CreateSuffix($fname,$ftype,$fnotnull,$fdefault,$fautoinc,$fconstraint,$funsigned)
	{
		$suffix = '';
		if (strlen($fdefault)) $suffix .= " DEFAULT $fdefault";
		if ($fnotnull) $suffix .= ' NOT NULL';
		if ($fconstraint) $suffix .= ' '.$fconstraint;
		return $suffix;
	}

    /**
     * build SQL commands for indexes.
     *
     * @internal
     */
	protected function _IndexSQL($idxname, $tabname, $flds, $idxoptions)
	{
		$sql = array();

		if ( isset($idxoptions['REPLACE']) || isset($idxoptions['DROP']) ) {
			$sql[] = sprintf ($this->dropIndex, $idxname);
			if ( isset($idxoptions['DROP']) ) return $sql;
		}

		if ( empty ($flds) ) return $sql;

		$unique = isset($idxoptions['UNIQUE']) ? ' UNIQUE' : '';

		$s = 'CREATE' . $unique . ' INDEX ' . $idxname . ' ON ' . $tabname . ' ';

		if ( isset($idxoptions[$this->upperName]) )
			$s .= $idxoptions[$this->upperName];

		if ( is_array($flds) )	$flds = implode(', ',$flds);
		$s .= '(' . $flds . ')';
		$sql[] = $s;

		return $sql;
	}

    /**
     * A method to drop the auto increment column on a table.
     *
     * @internal
     */
	protected function _DropAutoIncrement($tabname)
	{
		return false;
	}

    /**
     * An internal method to get a list of database type specific options for a command.
     *
     * @internal
     */
    protected function get_dbtype_options($opts,$suffix = null)
    {
        $dbtype = $this->_DBType();
        $list = array($dbtype.$suffix,strtoupper($dbtype).$suffix,strtolower($dbtype).$suffix);

        foreach( $list as $one ) {
            if( isset($opts[$one]) && is_string($opts[$one]) && strlen($opts[$one]) ) return $opts[$one];
        }
    }

    /**
     * Build strings for generating tables.
     *
     * @internal
     */
	protected function _TableSQL($tabname,$lines,$pkey,$tableoptions)
	{
		$sql = array();

		if (isset($tableoptions['REPLACE']) || isset ($tableoptions['DROP'])) {
			$sql[] = sprintf($this->dropTable,$tabname);
			if ($this->autoIncrement) {
				$sInc = $this->_DropAutoIncrement($tabname);
				if ($sInc) $sql[] = $sInc;
			}
			if ( isset ($tableoptions['DROP']) ) {
				return $sql;
			}
		}
		$s = "CREATE TABLE $tabname (\n";
		$s .= implode(",\n", $lines);
		if (sizeof($pkey)>0) {
			$s .= ",\n				 PRIMARY KEY (";
			$s .= implode(", ",$pkey).")";
		}
		if (isset($tableoptions['CONSTRAINTS']))
			$s .= "\n".$tableoptions['CONSTRAINTS'];

        $str = $this->get_dbtype_options($tableoptions,'_CONSTRAINTS');
        if( $str ) $s .= "\n".$str;

		$s .= "\n)";
        $str = $this->get_dbtype_options($tableoptions);
        if( $str ) $s .= $str;
		$sql[] = $s;

		return $sql;
	}

    /**
     * Generate triggers if needed.
	 * This is used when table has auto-incrementing field that is emulated using triggers.
     *
     * @internal
     */
	protected function _Triggers($tabname,$taboptions)
	{
		return array();
	}

	/**
     * Sanitize options,
     *
     * @internal
     */
    protected function _ProcessOptions($opts)
    {
        return $opts;
    }

    /**
     * Convert options into a format usable by the system.
     *
     * @internal
     */
	protected function _Options($opts)
	{
        $opts = $this->_ProcessOptions($opts);
		if (!is_array($opts)) return array();
		$newopts = array();
		foreach($opts as $k => $v) {
			if (is_numeric($k)) $newopts[strtoupper($v)] = $v;
			else $newopts[strtoupper($k)] = $v;
		}
		return $newopts;
	}

	/**
     * Add, drop or change columns within a table.
     *
     * This function changes/adds new fields to your table. You don't
     * have to know if the col is new or not. It will check on its own.
     *
     * @param string $tablename The table name
     * @param string $flds The field definitions
     * @param array  $tableoptions Table options
     * @return string[] An array of strings suitable for use with the ExecuteSQLArray method
     */
	public function ChangeTableSQL($tablename, $flds, $tableoptions = false)
	{
		// check table exists
		$cols = $this->MetaColumns($tablename);

		if ( empty($cols)) {
			return $this->CreateTableSQL($tablename, $flds, $tableoptions);
		}

		if (is_array($flds)) {
			// Cycle through the update fields, comparing
			// existing fields to fields to update.
			// if the Metatype and size is exactly the
			// same, ignore - by Mark Newham
			$holdflds = array();
			foreach($flds as $k=>$v) {
				if ( isset($cols[$k]) && is_object($cols[$k]) ) {
					$c = $cols[$k];
					$ml = $c->max_length;
					$mt = &$this->MetaType($c->type,$ml);
					if ($ml == -1) $ml = '';
					if ($mt == 'X') $ml = $v['SIZE'];
					if (($mt != $v['TYPE']) ||  $ml != $v['SIZE']) $holdflds[$k] = $v;
				} else {
					$holdflds[$k] = $v;
				}
			}
			$flds = $holdflds;
		}

		// already exists, alter table instead
		list($lines,$pkey) = $this->_GenFields($flds);
		$alter = 'ALTER TABLE ' . $this->TableName($tablename);
		$sql = array();

		foreach ( $lines as $id => $v ) {
			if ( isset($cols[$id]) && is_object($cols[$id]) ) {
				$flds = Lens_ParseArgs($v,',');
				//  We are trying to change the size of the field, if not allowed, simply ignore the request.
				if ($flds && in_array(strtoupper(substr($flds[0][1],0,4)),$this->invalidResizeTypes4)) continue;

				$sql[] = $alter . $this->alterCol . ' ' . $v;
			} else {
				$sql[] = $alter . $this->addCol . ' ' . $v;
			}
		}
		return $sql;
	}

} // end of class<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: \CMSMS\Database\Connection (c) 2015 by Robert Campbell
#         (calguy1000@cmsmadesimple.org)
#  A class to define interaction with a database.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# Visit our homepage at: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

/**
 * This file defines the abstract database connection class.
 *
 * @package CMS
 */

namespace CMSMS\Database {

    /**
     * A class defining a database connection, and mechanisms for working with a database.
     *
     * This library is largely compatible with adodb_lite with the pear,extended,transaction plugins with a few
     * notable differences:
     *
     * Differences:
     * <ul>
     *  <li>GenID will not automatically create a sequence table.
     *    <p>We encourage you to not use sequence tables and use auto-increment fields instead.</p>
     *  </li>
     * </ul>
     *
     * @package CMS
     * @author Robert Campbell
     * @copyright Copyright (c) 2015, Robert Campbell <calguy1000@cmsmadesimple.org>
     * @since 2.2
     * @property-read float $query_time_total The total query time so far in this request (in seconds)
     * @property-read int $query_count The total number of queries executed so far.
     */
    abstract class Connection
    {
        /**
         * This constant defines an error with connecting to the database.
         */
        const ERROR_CONNECT = 'CONNECT';

        /**
         * This constant defines an error with an execute statement.
         */
        const ERROR_EXECUTE = 'EXECUTE';

        /**
         * This constant defines an error with a transaction.
         */
        const ERROR_TRANSACTION = 'TRANSACTION';

        /**
         * This constant defines an error in a datadictionary command.
         */
        const ERROR_DATADICT = 'DATADICTIONARY';

        /**
         * @ignore
         */
        private $_debug;

        /**
         * @ignore
         */
        private $_debug_cb;

        /**
         * @ignore
         */
        private $_query_count = 0;

        /**
         * @ignore
         */
        private $_queries = array();

        /**
         * @ignore
         */
        private $_errorhandler;

        /**
         * The actual connectionspec object.
         *
         * @internal
         */
        protected $_connectionSpec;

        /**
         * The last SQL command executed
         *
         * @internal
         * @param string $sql
         */
        public $sql;

        /**
         * Accumulated sql query time.
         *
         * @internal
         * @param float $query_time_total
         */
        protected $query_time_total;

        /**
         * Construct a new Connection.
         *
         * @param \CMSMS\Database\ConnectionSpec $spec
         */
        public function __construct(ConnectionSpec $spec)
        {
            $this->_connectionSpec = $spec;
        }

        /**
         * @ignore
         */
        public function __get($key)
        {
            if( $key == 'query_time_total' ) return $this->query_time_total;
            if( $key == 'query_count' ) return $this->_query_count;
        }

        /**
         * @ignore
         */
        public function __isset($key)
        {
            if( $key == 'query_time_total' ) return TRUE;
            if( $key == 'query_count' ) return TRUE;
            return FALSE;
        }

        /**
         * Create a new data dictionary object.
         * Data Dictionary objects are used for manipulating tables, i.e: creating, altering and editing them.
         * @return \CMSMS\Database\DataDictionary
         */
        abstract public function &NewDataDictionary();

        /**
         * Return the database type.
         *
         * @return string
         */
        abstract public function DbType();

        /**
         * Open the database connection.
         *
         * @return bool Success or failure
         */
        abstract public function Connect();

        /**
         * Close the database connection.
         */
        abstract public function Disconnect();

        /**
         * Test if the connection object is connected to the database.
         *
         * @return bool
         */
        abstract public function IsConnected();

        /**
         * An alias for Disconnect.
         */
        final public function Close() { return $this->Disconnect(); }

        //// utilities

        /**
         * Quote a string in a database agnostic manner.
         * Warning: This method may require two way traffic with the database depending upon the database.
         * @param string $str
         * @return string
         */
        abstract public function qstr($str);

        /**
         * output the mysql expression for a string concatenation.
         * This function accepts a variable number of string arguments.
         *
         * @param $str First string to concatenate
         * @param $str,... unlimited number of strings to concatenate.
         * @return string
         */
        abstract public function concat();

        /**
         * Output the mysql expression to test if an item is null.
         *
         * @param string $field The field to test
         * @param string $ifNull The value to use if $field is null.
         * @return string
         */
        abstract public function IfNull( $field, $ifNull );

        /**
         * Output the number of rows affected by the last query.
         *
         * @return int
         */
        abstract public function Affected_Rows();

        /**
         * Return the numeric ID of the last insert query into a table with an auto-increment field.
         * @return int
         */
        abstract public function Insert_ID();

        //// primary query functions

        /**
         * The primary function for communicating with the database.
         *
         * @internal
         * @param string $sql The SQL query
         */
        abstract public function &do_sql($sql);

        /**
         * Create a prepared statement object.
         *
         * @param string $sql The SQL query
         * @return Statement
         */
        abstract public function &Prepare($sql);

        /**
         * Execute an SQL Select and limit the output.
         *
         * @param string $sql
         * @param int $nrows  The number of rows to return
         * @param int $offset The starting offset of rows to return
         * @param array Any additional paramters required by placeholders in the $sql statement.
         * @return \CMSMS\Database\ResultSet
         */
        public function &SelectLimit( $sql, $nrows = -1, $offset = -1, $inputarr = null )
        {
            $limit = null;
            $nrows = (int) $nrows;
            $offset = (int) $offset;
            if( $nrows >= 0 || $offset >= 0 ) {
                $offset = ($offset >= 0) ? $offset . "," : '';
                $nrows = ($nrows >= 0) ? $nrows : '18446744073709551615';
                $limit = ' LIMIT ' . $offset . ' ' . $nrows;
            }

            if ($inputarr && is_array($inputarr)) {
                $sqlarr = explode('?',$sql);
                if( !is_array(reset($inputarr)) ) $inputarr = array($inputarr);
                foreach( $inputarr as $arr ) {
                    $sql = ''; $i = 0;
                    foreach( $arr as $v ) {
                        $sql .= $sqlarr[$i];
                        switch(gettype($v)){
						case 'string':
							$sql .= $this->qstr($v);
							break;
						case 'double':
							$sql .= str_replace(',', '.', $v);
							break;
						case 'boolean':
							$sql .= $v ? 1 : 0;
							break;
						default:
							if ($v === null) $sql .= 'NULL';
							else $sql .= $v;
                        }
                        $i += 1;
                    }
                    $sql .= $sqlarr[$i];
                    if ($i+1 != sizeof($sqlarr)) {
                        $false = null;
                        return $false;
                    }
                }
            }
            $sql .= $limit;

            $rs = $this->do_sql( $sql );
            return $rs;
        }

        /**
         * Execute an SQL Command
         *
         * @param string $sql The SQL statement to execute.
         * @param array $inputarr Any parameters marked as placeholders in the SQL statement.
         * @return \CMSMS\Database\ResultSet
         */
        public function &Execute($sql, $inputarr = null)
        {
            $rs = $this->SelectLimit($sql, -1, -1, $inputarr );
            return $rs;
        }

        /**
         * Execute an SQL Commmand and return all of the results as an array.
         *
         * @param string $sql The SQL statement to execute.
         * @param array $inputarr Any parameters marked as placeholders in the SQL statement.
         * @return array An associative array of matched results.
         */
        public function GetArray($sql, $inputarr = null)
        {
            $result = $this->SelectLimit( $sql, -1, -1, $inputarr );
            if( !$result ) return;
            $data = $result->GetArray();
            return $data;
        }

        /**
         * An alias for the GetArray method.
         *
         * @param string $sql The SQL statement to execute.
         * @param array $inputarr Any parameters marked as placeholders in the SQL statement.
         * @return array
         */
        public function GetAll($sql, $inputarr = null)
        {
            return $this->GetArray($sql, $inputarr);
        }

        /**
         * Execute an SQL statement that returns one column, and return all of the
         * matches as an array.
         *
         * @param string $sql The SQL statement to execute.
         * @param array $inputarr Any parameters marked as placeholders in the SQL statement.
         * @param bool $trim Optionally trim the output results.
         * @return array A single flat array of results, one entry per row matched.
         */
        public function GetCol($sql, $inputarr = null, $trim = false)
        {
            $data = null;
            $result = $this->SelectLimit($sql, -1, -1, $inputarr);
            if ($result) {
                $data = array();
                $key = null;
                while (!$result->EOF) {
                    $row = $result->Fields();
                    if( !$key ) $key = array_keys($row)[0];
                    $data[] = ($trim) ? trim($row[$key]) : $row[$key];
                    $result->MoveNext();
                }
            }
            return $data;
        }

        /**
         * Exeute an SQL statement that returns one row of results, and return that row
         * as an associative array.
         *
         * @param string $sql The SQL statement to execute.
         * @param array $inputarr Any parameters marked as placeholders in the SQL statement.
         * @return array An associative array representing a single resultset row.
         */
        public function GetRow($sql, $inputarr = null)
        {
            $nrows = 1;
            if( stripos( $sql, 'LIMIT' ) !== FALSE ) $nrows = -1;
            $rs = $this->SelectLimit( $sql, $nrows, -1, $inputarr );
            if( !$rs ) return;
            return $rs->Fields();
        }

        /**
         * Execute an SQL statement and return a single value.
         *
         * @param string $sql The SQL statement to execute.
         * @param array $inputarr Any parameters marked as placeholders in the SQL statement.
         * @return mixed
         */
        public function GetOne($sql, $inputarr = null)
        {
            $res = $this->Getrow( $sql, $inputarr );
            if( !$res ) return;
            $key = array_keys($res)[0];
            return $res[$key];
        }

        //// transactions

        /**
         * Begin a transaction
         */
        abstract public function BeginTrans();

        /**
         * Begin a smart transaction
         */
        abstract public function StartTrans();

        /**
         * Complete a smart transaction.
         * This method will either do a rollback or a commit depending upon if errors
         * have been detected.
         */
        abstract public function CompleteTrans();

        /**
         * Commit a simple transaction.
         *
         * @param bool $ok Indicates wether there is success or not.
         */
        abstract public function CommitTrans($ok = true);

        /**
         * Roll back a simple transaction.
         */
        abstract public function RollbackTrans();

        /**
         * Mark a transaction as failed.
         */
        abstract public function FailTrans();

        /**
         * Test if a transaction has failed.
         *
         * @return bool
         */
        abstract public function HasFailedTrans();

        //// sequence table stuff

        /**
         * For use with sequence tables, this method will generate a new ID value.
         *
         * This function will not automatically create the sequence table if not specified.
         *
         * @param string $seqname The name of the sequence table.
         * @return int
         * @deprecated
         */
        abstract public function GenID($seqname);

        // these methods should be in the DataDictionary stuff.

        /**
         * Create a new sequence table.
         *
         * @param string $seqname the name of the sequence table.
         * @param int $startID
         * @return bool
         * @deprecated
         */
        abstract public function CreateSequence($seqname,$startID=0);

        /**
         * Drop a sequence table
         * @param string $seqname The name of the sequence table.
         * @return bool
         */
        abstract public function DropSequence($seqname);

        //// time and date stuff

        /**
         * A utility method to convert a unix timestamp into a database specific string suitable
         * for use in queries.
         *
         * @param int $timestamp
         * @return string
         */
        public function DBTimeStamp($timestamp)
        {
            if (empty($timestamp) && $timestamp !== 0) return 'null';

            // strlen(14) allows YYYYMMDDHHMMSS format
            if( is_string($timestamp) ) {
                if( !preg_match('/[0-9-\s:]*/',$timestamp) ) return 'null';
                $tmp = strtotime($timestamp);
                if( $tmp < 1 ) return;
                $timestamp = $tmp;
            }
            if( $timestamp > 0 ) return date("'Y-m-d H:i:s'",$timestamp);
        }

        /**
         * A convenience method for converting a database specific string representing a date and time
         * into a unix timestamp.
         *
         * @param string $str
         * @return int
         */
        public function UnixTimeStamp($str)
        {
            return strtotime($str);
        }

        /**
         * Convert a date into something that is suitable for writing to a database.
         *
         * @param mixed $date Either a string date, or an integer timestamp
         * @return string
         */
        public function DBDate($date)
        {
            if (empty($date) && $date !== 0) return 'null';

            if (is_string($date) && !is_numeric($date)) {
                if ($date === 'null' || strncmp($date, "'", 1) === 0) return $date;
                $date = $this->UnixDate($date);
            }
            return strftime('%x',$date);
        }

        /**
         * Generate a unix timestamp representing the current date at midnight.
         *
         * @deprecated
         * @return int
         */
        public function UnixDate()
        {
            return strtotime('today midnight');
        }

        /**
         * An alias for the UnixTimestamp method.
         *
         * @return int
         */
        public function Time() { return $this->UnixTimeStamp(); }

        /**
         * An Alias for the UnixDate method.
         *
         * @return int
         */
        public function Date() { return $this->UnixDate(); }

        //// error and debug message handling

        /**
         * Return a string describing the latest error (if any)
         *
         * @return string
         */
        abstract public function ErrorMsg();

        /**
         * Return the latest error number (if any)
         *
         * @return int
         */
        abstract public function ErrorNo();

        /**
         * Set an error handler function
         *
         * @param callable $fn
         */
        public function SetErrorHandler($fn = null)
        {
            $this->_errorhandler = null;
            if( $fn && is_callable($fn) ) $this->_errorhandler = $fn;
        }

        /**
         * Toggle debug mode.
         *
         * @param bool $flag Enable or Disable debug mode.
         * @param callable $debug_handler
         */
        public function SetDebugMode($flag = true,$debug_handler = null)
        {
            $this->_debug = (bool) $flag;
            if( $debug_handler && is_callable($this->_debug_handler) ) $this->_debug_cb = $debug_handler;
        }

        /**
         * Set the debug callback.
         *
         * @param callable $debug_handler
         */
        public function SetDebugCallback(callable $debug_handler = null)
        {
            $this->_debug_cb = $debug_handler;
        }

        /**
         * Add a query to the debug log
         *
         * @internal
         * @param string $sql the SQL statement
         */
        protected function add_debug_query($sql)
        {
            $this->_query_count++;
            if( $this->_debug && $this->_debug_cb ) call_user_func($this->_debug_cb,$sql);
        }

        /**
         * A callback that is called when a database error occurs.
         * This method will by default call the error handler if it has been set.
         * If no error handler is set, an exception will be thrown.
         *
         * @internal
         * @param string $errtype The type of error
         * @param int $error_number The error number
         * @param string $error_message The error message
         */
        public function OnError($errtype, $error_number, $error_message )
        {
            if( $this->_errorhandler && is_callable($this->_errorhandler) ) {
                call_user_func($this->_errorhandler, $this, $errtype, $error_number, $error_message);
                return;
            }

            switch( $errtype ) {
            case self::ERROR_CONNECT:
                throw new DatabaseConnectionException($error_message,$error_number);

            case self::ERROR_EXECUTE:
                throw new DatabaseException($error_message,$error_number,$this->sql,$this->_connectionSpec);
            }
        }

        //// initialization

        /**
         * Create a new database connection object.
         * This is the preferred wa to open a new database connection.
         *
         * @param \CMSMS\Database\Connectionspec $spec An object describing the database to connect to.
         * @return \CMSMS\Database\Connection
	 * @todo  Move this into a factory class
         */
        public static function &Initialize(ConnectionSpec $spec)
        {
            if( !$spec->valid() ) throw new ConnectionSpecException('Invalid or incorrect configuration information');
            $connection_class = '\\CMSMS\\Database\\'.$spec->type.'\\Connection';
            if( !class_exists($connection_class) ) throw new \LogicException('Could not find a database abstraction layer named '.$spec->type);

            $obj = new $connection_class($spec);
            if( !($obj instanceof Connection ) ) throw new \LogicException("$connection_class is not derived from the primary database class.");
            if( $spec->debug ) $obj->SetDebugMode();
            $obj->Connect();

            if( $spec->auto_exec ) $obj->Execute($spec->auto_exec);
            return $obj;
        }

    } // end of class

    /**
     * A special type of exception related to database queries.
     */
    class DatabaseException extends \LogicException
    {
        /**
         * @internal
         */
        protected $_connection;

        /**
         * @internal
         */
        protected $_sql;

        /**
         * Constructor
         *
         * @param string $msg The message string
         * @param int $number The error number
         * @param string $sql The related SQL statement, if any
         * @param \CMSMS\Database\ConnectionSpec The connection specification
         */
        public function __construct($msg,$number,$sql,ConnectionSpec $connection)
        {
            parent::__construct($msg,$number);
            $this->_connection = $connection;
            $this->_sql = $sql;
        }

        /**
         * Get the SQL statement related to this exception.
         * @return string
         */
        public function getSQL() { return $this->_sql; }

        /**
         * Get the Connectionspec that was used when generating the error.
         *
         * @return \CMSMS\Database\ConnectionSpec
         */
        public function getConnectionSpec() { return $this->_connection; }
    }

    /**
     * A special exception indicating a problem connecting to the database.
     */
    class DatabaseConnectionException extends \Exception {}

} // end of Namespace
<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CMSMS\Database\compatibility (c) 2015 by Robert Campbell
#         (calguy1000@cmsmadesimple.org)
# A collection of compatibility tools for the database connectivity layer.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# Visit our homepage at: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

/**
 * This file contains some database connectivity tools.
 *
 * @package CMS
 */

namespace CMSMS\Database {

    /**
     * A class for providing some compatibility functionality with older module code
     *
     * @todo: move this class to a different function and rename.
     */
    final class compatibility
    {
        /**
         * @ignore
         */
        private function __construct() {}

        /**
         * Initialize the database connection according to config settings.
         *
         * @internal
         * @param cms_config $config The config object
         * @return \CMSMS\Database\Connection
         */
        public static function init(\cms_config $config)
        {
            $spec = new ConnectionSpec;
            $spec->type = $config['dbms'];
            $spec->host = $config['db_hostname'];
            $spec->username = $config['db_username'];
            $spec->password = $config['db_password'];
            $spec->dbname = $config['db_name'];
            $spec->port = $config['db_port'];
            $spec->debug = CMS_DEBUG;

            $tmp = [];
            if( $config['set_names'] ) $tmp[] = "NAMES 'utf8'";
            if( $config['set_db_timezone'] ) {
                $dt = new \DateTime();
                $dtz = new \DateTimeZone($config['timezone']);
                $offset = timezone_offset_get($dtz,$dt);
                $symbol = ($offset < 0) ? '-' : '+';
                $hrs = abs((int)($offset / 3600));
                $mins = abs((int)($offset % 3600));
                $tmp[] = sprintf("time_zone = '%s%d:%02d'",$symbol,$hrs,$mins);
            }
            if( count($tmp) ) $spec->auto_exec = 'SET '.implode(',',$tmp);

            $obj = Connection::Initialize($spec);
            $obj->SetErrorHandler( '\\CMSMS\Database\\compatibility::on_error' );
            if( $spec->debug ) $obj->SetDebugCallback('debug_buffer');
            return $obj;
        }

        public static function on_error( Connection $conn, $errtype, $error_number, $error_msg )
        {
            debug_to_log("Database Error: $errtype($error_number) - $error_msg");
            debug_bt_to_log();
            if( !defined('CMS_DEBUG') || CMS_DEBUG == 0 ) return;
            \CmsApp::get_instance()->add_error(debug_display($error_msg, '', false, true));
        }

        /**
         * A static no-op function  that allows the autoloader to load this file
         */
        public static function noop()
        {
            // do nothing
        }
    } // end of class
} // end of namespace

namespace {
    // root namespace stuff

    /**
     * A constant to assist with date and time flags in the data dictionary.
     *
     * @name CMS_ADODB_DT
     */
    define('CMS_ADODB_DT','DT'); // backwards compatibility.

    /**
     * A method to create a new data dictionary object
     *
     * @param \CMSMS\Database\Connection $conn The existing database connection.
     * @return \CMSMS\Database\DataDictionary
     * @deprecated
     */
    function &NewDataDictionary(\CMSMS\Database\Connection $conn)
    {
        // called by module installation routines.
        return $conn->NewDataDictionary();
    }

    /**
     * A function co create a new adodb database connection.
     *
     * @param string $dbms
     * @param string $flags
     * @return \CMSMS\Database\Connection
     * @deprecated
     */
    function &ADONewConnection( $dbms, $flags )
    {
        // now that our connection object is stateless... this is just a wrapper
        // for our global db instance.... but should not be called.
        return \CmsApp::get_instance()->GetDb();
    }

    /**
     * A function to load the adodb library.
     * This method currently has no functionality.
     *
     * @deprecated
     */
    function load_adodb()
    {
        // this should only have been called by the core
        // but now does nothing, just in case it is called.
    }

    /**
     * An old method to ensure that we are re-connected to the proper database
     *
     * @deprecated
     */
    function adodb_connect()
    {
        // this may be called by UDT's etc. that are talking to other databases
        // or using manual mysql methods.
    }

    /**
     * An old function for handling a database error.
     *
     * @param string $dbtype
     * @param string $function_performed
     * @param int    $error_number
     * @param string $error_message
     * @param string $host
     * @param string $database
     * @param mixed  $connection_obj
     * @deprecated
     */
    function adodb_error($dbtype,$function_performed,$error_number,$error_message,
                         $host, $database, &$connection_obj)
    {
        // does nothing.... remove me later.
    }

}
?>
<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: \CMSMS\Database\ConnectionSpec (c) 2015 by Robert Campbell
#         (calguy1000@cmsmadesimple.org)
#  A class to define how to connect to a database.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# Visit our homepage at: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

/**
 * This file defines the base ResultSet class.
 *
 * @package CMS
 */

namespace CMSMS\Database;

/**
 * A class defining a resultset and how to interact with results from a database query.
 *
 * @package CMS
 * @author Robert Campbell
 * @copyright Copyright (c) 2015, Robert Campbell <calguy1000@cmsmadesimple.org>
 * @since 2.2
 * @property-read bool $EOF Test if we are at the end of the current resultset.
 * @property-read array $fields Return the current row of the resultset.
 */
abstract class Resultset
{
    /**
     * @ignore
     */
    public function __destruct()
    {
        $this->Close();
    }

    /**
     * Move to the first row in a resultset.
     */
    abstract public function MoveFirst();

    /**
     * Move to the next row of a resultset.
     */
    abstract public function MoveNext();

    /**
     * Move to a specified index of the resultset.
     *
     * @param int $idx
     */
    abstract protected function Move($idx);

    /**
     * Get all remaining results in this resultset as an array of records.
     *
     * @return array
     */
    public function GetArray()
    {
        $results = array();
        while( !$this->EOF() ) {
            $results[] = $this->fields();
            $this->MoveNext();
        }
        return $results;
    }

    /**
     * An alias for the GetArray method.
     *
     * @see GetArray()
     * @return array
     * @deprecated
     */
    public function GetRows() { return $this->GetArray(); }

    /**
     * An alias for the GetArray method.
     * @see GetArray()
     * @return array
     * @deprecated
     */
    public function GetAll() { return $this->GetArray(); }

    /**
     * An alias for the GetArray method.
     * @see GetArray()
     * @return array
     * @deprecated
     */
    public function GetAssoc() { return $this->GetArray(); }

    /**
     * Test if we are at the end of a resultset, and there are no further matches.
     *
     * @return bool
     */
    abstract public function EOF();

    /**
     * Close the current resultset.
     */
    abstract public function Close();

    /**
     * Return the number of rows in the current resultset.
     *
     * @return int
     */
    abstract public function RecordCount();

    /**
     * Alias for the RecordCount() method.
     *
     * @see RecordCount();
     * @return int
     */
    public function NumRows() { return $this->RecordCount(); }

    /**
     * Return the fields of the current resultset, or a single field of it.
     *
     * @param string $field An optional field name, if not specified, the entire row will be returned.
     * @return mixed|array Either a single value, or an array
     */
    abstract public function Fields( $field = null );

    /**
     * Fetch the current row, and move to the next row.
     *
     * @return array
     */
    public function FetchRow() {
        if( $this->EOF() ) return false;
        $out = $this->fields();
        $this->MoveNext();
        return $out;
    }

    /**
     * @internal
     */
    abstract protected function fetch_row();

    /**
     * @ignore
     */
    public function __get($key)
    {
        if( $key == 'EOF' ) return $this->EOF();
        if( $key == 'fields' ) return $this->Fields();
    }

}
<?php

/**
 * A file to describe an empty recordset
 *
 * @ignore
 */
namespace CMSMS\Database;

/**
 * A final class to describe a special (empty) recordset.
 *
 * @ignore
 */
final class EmptyResultset extends Resultset
{
    /**
     * @ignore
     */
    public function MoveFirst() {}
    /**
     * @ignore
     */
    public function MoveNext() {}

    /**
     * @ignore
     */
    public function GetArray() {}
    /**
     * @ignore
     */
    public function GetRows() {}
    /**
     * @ignore
     */
    public function GetAll() {}
    /**
     * @ignore
     */
    public function GetAssoc() {}

    /**
     * @ignore
     */
    public function EOF() { return TRUE; }
    /**
     * @ignore
     */
    public function Close() {}
    /**
     * @ignore
     */
    public function RecordCount() { return 0; }

    /**
     * @ignore
     */
    public function fields() {}
} // end of class
<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: \CMSMS\Database\Statement (c) 2015 by Robert Campbell
#         (calguy1000@cmsmadesimple.org)
#  A class to represent a prepared SQL statement
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# Visit our homepage at: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

/**
 * This file defines the abstract database statement class.
 *
 * @package CMS
 */

namespace CMSMS\Database;

/**
 * A class defining a prepared database statement.
 *
 * @package CMS
 * @author Robert Campbell
 * @copyright Copyright (c) 2017, Robert Campbell <calguy1000@cmsmadesimple.org>
 * @since 2.2
 * @property-read Connection $db The database connection
 * @property-read string $sql The SQL query.
 */
abstract class Statement
{
    /**
     * @ignore
     */
    private $_conn;

    /**
     * @ignore
     */
    private $_sql;

    /**
     * Constructor
     *
     * @param Connection $conn The database connection
     * @param string $sql The SQL query
     */
    public function __construct(Connection $conn,$sql = null)
    {
        $this->_conn = $conn;
        $this->_sql = $sql;
    }

    /**
     * @ignore
     */
    public function __get($key)
    {
        switch( $key ) {
        case 'db':
        case 'conn':
            return $this->_conn;

        case 'sql':
            return $this->_sql;
        }
    }

    /**
     * Bind data to the sql statements
     *
     * @param array $data An array of arrays of data representing the numerous rows of the input data.
     */
    public function Bind(array $data)
    {
        if( !is_array($data) || count($data) == 0 ) throw new \LogicException('Data passed to '.__METHOD__.' must be an associative array');
        $first = $data[0];
        if( !is_array($first) || count($first) == 0 ) throw new \LogicException('Data passed to '.__METHOD__.' must be an associative array');
        $keys = array_keys($first);
        if( is_numeric($keys[0]) && $keys[0] === 0 )  throw new \LogicException('Data passed to '.__METHOD__.' must be an associative array');

        $this->set_bound_data($data);
    }

    /**
     * Set bound data
     *
     * @see bind
     * @param array $data An array of arrays of data representing the numerous rows of the input data.
     */
    abstract protected function set_bound_data($data);

    /**
     * Test if we are at the end of the resultset.
     *
     * @return bool
     */
    abstract public function EOF();

    /**
     * Move to the first record of the resultset.
     */
    abstract public function MoveFirst();

    /**
     * Move to the next record of the resultset.
     */
    abstract public function MoveNext();

    /**
     * Retrive data fields.
     *
     * @param string $col The column name.  If not specified, all columns will be returned.
     * @return mixed
     */
    abstract public function Fields($col = null);

    /**
     * Execute the query
     */
    abstract public function Execute();
}
<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: \CMSMS\Database\ConnectionSpec (c) 2015 by Robert Campbell
#         (calguy1000@cmsmadesimple.org)
#  A class to define how to connect to a database.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# Visit our homepage at: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

/**
 * This file defines the ConnectionSpec class.
 *
 * @package CMS
 */

namespace CMSMS\Database;

/**
 * A class defining all of the details needed to connect to a database.
 * Some database drivers may not require all of the parameters.
 *
 * @package CMS
 * @author Robert Campbell
 * @copyright Copyright (c) 2015, Robert Campbell <calguy1000@cmsmadesimple.org>
 * @since 2.2
 * @param string $type The database connection type
 * @param string $host The hostname to connect to.
 * @param string $username The authentication username
 * @param string $password The authentication password
 * @param string $dbname The database name
 * @param string $prefix The table name prefix.
 * @param int    $port   The connection port
 * @param bool   $persistent Wether or not to use persistent connections.
 * @param bool   $debug  Enable debug mode.
 */
class ConnectionSpec
{
    /**
     * @ignore
     */
    private $_data = array('type'=>null,'host'=>null,'username'=>null,'password'=>null,
                           'dbname'=>null,'prefix'=>null,'port'=>null,'persistent'=>false,'debug'=>false,
                           'auto_exec'=>null);

    /**
     * @ignore
     */
    public function __get($key)
    {
        if( !array_key_exists($key,$this->_data) ) throw new \InvalidArgumentException("$key is not a valid member of ".__CLASS__);
        return $this->_data[$key];
    }

    /**
     * @ignore
     */
    public function __set($key,$val)
    {
        if( !array_key_exists($key,$this->_data) ) throw new \InvalidArgumentException("$key is not a valid member of ".__CLASS__);
        $this->_data[$key] = trim($val);
    }

    /**
     * Test if this connectionspec is valid.
     * Returns true if there is enough information to connect to the database.
     *
     * @return bool
     */
    public function valid()
    {
        if( !$this->type || !$this->host || !$this->username || !$this->password || !$this->dbname ) return FALSE;
        return TRUE;
    }
}

/**
 * A special exception to indicate a problem with a ConnectionSpec
 */
class ConnectionSpecException extends \Exception {}

?>
<?php
/**
 * Smarty plugin
 *
 * @package Smarty
 * @subpackage PluginsModifier
 */

/**
 * Smarty regex_replace modifier plugin
 *
 * Type:     modifier<br>
 * Name:     regex_replace<br>
 * Purpose:  regular expression search/replace
 *
 * @link http://smarty.php.net/manual/en/language.modifier.regex.replace.php
 *          regex_replace (Smarty online manual)
 * @author Monte Ohrt <monte at ohrt dot com>
 * @param string       $string   input string
 * @param string|array $search   regular expression(s) to search for
 * @param string|array $replace  string(s) that should be replaced
 * @return string
 */
function smarty_modifier_regex_replace($string, $search, $replace)
{
    if(is_array($search)) {
        foreach($search as $idx => $s) {
            $search[$idx] = _smarty_regex_replace_check($s);
        }
    } else {
        $search = _smarty_regex_replace_check($search);
    }
    return preg_replace($search, $replace, $string);
}

/**
 * @param  string $search string(s) that should be replaced
 * @return string
 * @ignore
 */
function _smarty_regex_replace_check($search)
{
    // null-byte injection detection
    // anything behind the first null-byte is ignored
    if (($pos = strpos($search,"\0")) !== false) {
        $search = substr($search,0,$pos);
    }
    // remove eval-modifier from $search
    if (preg_match('!([a-zA-Z\s]+)$!s', $search, $match) && (strpos($match[1], 'e') !== false)) {
        $search = substr($search, 0, -strlen($match[1])) . preg_replace('![e\s]+!', '', $match[1]);
    }
    return $search;
}

?><?php
/**
 * Smarty plugin
 *
 * @package Smarty
 * @subpackage PluginsShared
 */

/**
 * evaluate compiler parameter
 *
 * @param array   $params  paramter array as given to the compiler function
 * @param integer $index   array index of the paramter to convert
 * @param mixed   $default value to be returned if the paramter is not present
 * @return mixed evaluated value of paramter or $default
 * @throws SmartyException if paramter is not a literal (but an expression, variable, …)
 * @author Rodney Rehm
 */
function smarty_literal_compiler_param($params, $index, $default=null)
{
    // not set, go default
    if (!isset($params[$index])) {
        return $default;
    }
    // test if param is a literal
    if (!preg_match('/^([\'"]?)[a-zA-Z0-9]+(\\1)$/', $params[$index])) {
        throw new SmartyException('$param[' . $index . '] is not a literal and is thus not evaluatable at compile time');
    }

    $t = null;
    eval("\$t = " . $params[$index] . ";");
    return $t;
}
<?php
/**
 * Smarty plugin
 *
 * @package Smarty
 * @subpackage PluginsModifierCompiler
 */

/**
 * Smarty count_words modifier plugin
 *
 * Type:     modifier<br>
 * Name:     count_words<br>
 * Purpose:  count the number of words in a text
 *
 * @link http://www.smarty.net/manual/en/language.modifier.count.words.php count_words (Smarty online manual)
 * @author Uwe Tews
 * @param array $params parameters
 * @return string with compiled code
*/
function smarty_modifiercompiler_count_words($params, $compiler)
{
    if (SMARTY_MBSTRING /* ^phpunit */&&empty($_SERVER['SMARTY_PHPUNIT_DISABLE_MBSTRING'])/* phpunit$ */) {
        // return 'preg_match_all(\'#[\w\pL]+#u\', ' . $params[0] . ', $tmp)';
        // expression taken from http://de.php.net/manual/en/function.str-word-count.php#85592
        return 'preg_match_all(\'/\p{L}[\p{L}\p{Mn}\p{Pd}\\\'\x{2019}]*/u\', ' . $params[0] . ', $tmp)';
    }
    // no MBString fallback
    return 'str_word_count(' . $params[0] . ')';
}

?><?php
/**
 * Smarty plugin
 *
 * @package Smarty
 * @subpackage PluginsModifierCompiler
 */

/**
 * Smarty count_paragraphs modifier plugin
 *
 * Type:     modifier<br>
 * Name:     count_paragraphs<br>
 * Purpose:  count the number of paragraphs in a text
 *
 * @link http://www.smarty.net/manual/en/language.modifier.count.paragraphs.php
 *          count_paragraphs (Smarty online manual)
 * @author Uwe Tews
 * @param array $params parameters
 * @return string with compiled code
 */
function smarty_modifiercompiler_count_paragraphs($params, $compiler)
{
    // count \r or \n characters
    return '(preg_match_all(\'#[\r\n]+#\', ' . $params[0] . ', $tmp)+1)';
}

?><?php
/**
 * Smarty plugin
 *
 * @package Smarty
 * @subpackage PluginsFunction
 */

/**
 * Smarty {html_table} function plugin
 *
 * Type:     function<br>
 * Name:     html_table<br>
 * Date:     Feb 17, 2003<br>
 * Purpose:  make an html table from an array of data<br>
 * Params:
 * <pre>
 * - loop       - array to loop through
 * - cols       - number of columns, comma separated list of column names
 *                or array of column names
 * - rows       - number of rows
 * - table_attr - table attributes
 * - th_attr    - table heading attributes (arrays are cycled)
 * - tr_attr    - table row attributes (arrays are cycled)
 * - td_attr    - table cell attributes (arrays are cycled)
 * - trailpad   - value to pad trailing cells with
 * - caption    - text for caption element
 * - vdir       - vertical direction (default: "down", means top-to-bottom)
 * - hdir       - horizontal direction (default: "right", means left-to-right)
 * - inner      - inner loop (default "cols": print $loop line by line,
 *                $loop will be printed column by column otherwise)
 * </pre>
 * Examples:
 * <pre>
 * {table loop=$data}
 * {table loop=$data cols=4 tr_attr='"bgcolor=red"'}
 * {table loop=$data cols="first,second,third" tr_attr=$colors}
 * </pre>
 *
 * @author Monte Ohrt <monte at ohrt dot com>
 * @author credit to Messju Mohr <messju at lammfellpuschen dot de>
 * @author credit to boots <boots dot smarty at yahoo dot com>
 * @version 1.1
 * @link http://www.smarty.net/manual/en/language.function.html.table.php {html_table}
 *          (Smarty online manual)
 * @param array                    $params   parameters
 * @param Smarty_Internal_Template $template template object
 * @return string
 */
function smarty_function_html_table($params, $template)
{
    $table_attr = 'border="1"';
    $tr_attr = '';
    $th_attr = '';
    $td_attr = '';
    $cols = $cols_count = 3;
    $rows = 3;
    $trailpad = '&nbsp;';
    $vdir = 'down';
    $hdir = 'right';
    $inner = 'cols';
    $caption = '';
    $loop = null;

    if (!isset($params['loop'])) {
        trigger_error("html_table: missing 'loop' parameter",E_USER_WARNING);
        return;
    }

    foreach ($params as $_key => $_value) {
        switch ($_key) {
            case 'loop':
                $$_key = (array)$_value;
                break;

            case 'cols':
                if (is_array($_value) && !empty($_value)) {
                    $cols = $_value;
                    $cols_count = count($_value);
                } elseif (!is_numeric($_value) && is_string($_value) && !empty($_value)) {
                    $cols = explode(',', $_value);
                    $cols_count = count($cols);
                } elseif (!empty($_value)) {
                    $cols_count = (int)$_value;
                } else {
                    $cols_count = $cols;
                }
                break;

            case 'rows':
                $$_key = (int)$_value;
                break;

            case 'table_attr':
            case 'trailpad':
            case 'hdir':
            case 'vdir':
            case 'inner':
            case 'caption':
                $$_key = (string)$_value;
                break;

            case 'tr_attr':
            case 'td_attr':
            case 'th_attr':
                $$_key = $_value;
                break;
        }
    }

    $loop_count = count($loop);
    if (empty($params['rows'])) {
        /* no rows specified */
        $rows = ceil($loop_count / $cols_count);
    } elseif (empty($params['cols'])) {
        if (!empty($params['rows'])) {
            /* no cols specified, but rows */
            $cols_count = ceil($loop_count / $rows);
        }
    }

    $output = "<table $table_attr>\n";

    if (!empty($caption)) {
        $output .= '<caption>' . $caption . "</caption>\n";
    }

    if (is_array($cols)) {
        $cols = ($hdir == 'right') ? $cols : array_reverse($cols);
        $output .= "<thead><tr>\n";

        for ($r = 0; $r < $cols_count; $r++) {
            $output .= '<th' . smarty_function_html_table_cycle('th', $th_attr, $r) . '>';
            $output .= $cols[$r];
            $output .= "</th>\n";
        }
        $output .= "</tr></thead>\n";
    }

    $output .= "<tbody>\n";
    for ($r = 0; $r < $rows; $r++) {
        $output .= "<tr" . smarty_function_html_table_cycle('tr', $tr_attr, $r) . ">\n";
        $rx = ($vdir == 'down') ? $r * $cols_count : ($rows-1 - $r) * $cols_count;

        for ($c = 0; $c < $cols_count; $c++) {
            $x = ($hdir == 'right') ? $rx + $c : $rx + $cols_count-1 - $c;
            if ($inner != 'cols') {
                /* shuffle x to loop over rows*/
                $x = floor($x / $cols_count) + ($x % $cols_count) * $rows;
            }

            if ($x < $loop_count) {
                $output .= "<td" . smarty_function_html_table_cycle('td', $td_attr, $c) . ">" . $loop[$x] . "</td>\n";
            } else {
                $output .= "<td" . smarty_function_html_table_cycle('td', $td_attr, $c) . ">$trailpad</td>\n";
            }
        }
        $output .= "</tr>\n";
    }
    $output .= "</tbody>\n";
    $output .= "</table>\n";

    return $output;
}

function smarty_function_html_table_cycle($name, $var, $no)
{
    if (!is_array($var)) {
        $ret = $var;
    } else {
        $ret = $var[$no % count($var)];
    }

    return ($ret) ? ' ' . $ret : '';
}

?><?php
/**
 * Smarty plugin
 *
 * @package Smarty
 * @subpackage PluginsModifierCompiler
 */

/**
 * Smarty count_sentences modifier plugin
 *
 * Type:     modifier<br>
 * Name:     count_sentences
 * Purpose:  count the number of sentences in a text
 *
 * @link http://www.smarty.net/manual/en/language.modifier.count.paragraphs.php
 *          count_sentences (Smarty online manual)
 * @author Uwe Tews
 * @param array $params parameters
 * @return string with compiled code
 */
function smarty_modifiercompiler_count_sentences($params, $compiler)
{
    // find periods, question marks, exclamation marks with a word before but not after.
    return 'preg_match_all("#\w[\.\?\!](\W|$)#uS", ' . $params[0] . ', $tmp)';
}

?><?php
/**
 * Smarty plugin
 *
 * @package Smarty
 * @subpackage PluginsModifierCompiler
 */

/**
 * Smarty unescape modifier plugin
 *
 * Type:     modifier<br>
 * Name:     unescape<br>
 * Purpose:  unescape html entities
 *
 * @author Rodney Rehm
 * @param array $params parameters
 * @return string with compiled code
 */
function smarty_modifiercompiler_unescape($params, $compiler)
{
    if (!isset($params[1])) {
        $params[1] = 'html';
    }
    if (!isset($params[2])) {
        $params[2] = "SMARTY_RESOURCE_CHAR_SET";
    } else {
        $params[2] = "'" . $params[2] . "'";
    }

    switch (trim($params[1], '"\'')) {
        case 'entity':
            return 'mb_convert_encoding(' . $params[0] . ', ' . $params[2] . ', \'HTML-ENTITIES\')';
        case 'htmlall':
            if (SMARTY_MBSTRING /* ^phpunit */&&empty($_SERVER['SMARTY_PHPUNIT_DISABLE_MBSTRING'])/* phpunit$ */) {
                return 'mb_convert_encoding(' . $params[0] . ', ' . $params[2] . ', \'HTML-ENTITIES\')';
            }
            return 'html_entity_decode(' . $params[0] . ', ENT_QUOTES, ' . $params[2] . ')';

        case 'html':
            return 'htmlspecialchars_decode(' . $params[0] . ', ENT_QUOTES)';

        default:
            return $params[0];
    }
}

?><?php
/**
 * Smarty plugin
 * 
 * @package Smarty
 * @subpackage Debug
 */

/**
 * Smarty debug_print_var modifier plugin
 * 
 * Type:     modifier<br>
 * Name:     debug_print_var<br>
 * Purpose:  formats variable contents for display in the console
 *
 * @author Monte Ohrt <monte at ohrt dot com> 
 * @param array|object $var     variable to be formatted
 * @param integer      $depth   maximum recursion depth if $var is an array
 * @param integer      $length  maximum string length if $var is a string
 * @return string 
 */
function smarty_modifier_debug_print_var ($var, $depth = 0, $length = 40)
{
    $_replace = array("\n" => '<i>\n</i>',
        "\r" => '<i>\r</i>',
        "\t" => '<i>\t</i>'
        );

    switch (gettype($var)) {
        case 'array' :
            $results = '<b>Array (' . count($var) . ')</b>';
            foreach ($var as $curr_key => $curr_val) {
                $results .= '<br>' . str_repeat('&nbsp;', $depth * 2)
                 . '<b>' . strtr($curr_key, $_replace) . '</b> =&gt; '
                 . smarty_modifier_debug_print_var($curr_val, ++$depth, $length);
                $depth--;
            } 
            break;
            
        case 'object' :
            $object_vars = get_object_vars($var);
            $results = '<b>' . get_class($var) . ' Object (' . count($object_vars) . ')</b>';
            foreach ($object_vars as $curr_key => $curr_val) {
                $results .= '<br>' . str_repeat('&nbsp;', $depth * 2)
                 . '<b> -&gt;' . strtr($curr_key, $_replace) . '</b> = '
                 . smarty_modifier_debug_print_var($curr_val, ++$depth, $length);
                $depth--;
            } 
            break;
            
        case 'boolean' :
        case 'NULL' :
        case 'resource' :
            if (true === $var) {
                $results = 'true';
            } elseif (false === $var) {
                $results = 'false';
            } elseif (null === $var) {
                $results = 'null';
            } else {
                $results = htmlspecialchars((string) $var);
            } 
            $results = '<i>' . $results . '</i>';
            break;
            
        case 'integer' :
        case 'float' :
            $results = htmlspecialchars((string) $var);
            break;
            
        case 'string' :
            $results = strtr($var, $_replace);
            if (SMARTY_MBSTRING /* ^phpunit */&&empty($_SERVER['SMARTY_PHPUNIT_DISABLE_MBSTRING'])/* phpunit$ */) {
                if (mb_strlen($var, SMARTY_RESOURCE_CHAR_SET) > $length) {
                    $results = mb_substr($var, 0, $length - 3, SMARTY_RESOURCE_CHAR_SET) . '...';
                }
            } else {
                if (isset($var[$length])) {
                    $results = substr($var, 0, $length - 3) . '...';
                }
            }

            $results = htmlspecialchars('"' . $results . '"');
            break;
            
        case 'unknown type' :
        default :
            $results = strtr((string) $var, $_replace);
            if (SMARTY_MBSTRING /* ^phpunit */&&empty($_SERVER['SMARTY_PHPUNIT_DISABLE_MBSTRING'])/* phpunit$ */) {
                if (mb_strlen($results, SMARTY_RESOURCE_CHAR_SET) > $length) {
                    $results = mb_substr($results, 0, $length - 3, SMARTY_RESOURCE_CHAR_SET) . '...';
                }
            } else {
                if (strlen($results) > $length) {
                    $results = substr($results, 0, $length - 3) . '...';
                }
            }
             
            $results = htmlspecialchars($results);
    } 

    return $results;
} 

?><?php
/**
 * Smarty plugin
 *
 * @package Smarty
 * @subpackage PluginsModifierCompiler
 */

/**
 * Smarty count_characters modifier plugin
 *
 * Type:     modifier<br>
 * Name:     count_characteres<br>
 * Purpose:  count the number of characters in a text
 *
 * @link http://www.smarty.net/manual/en/language.modifier.count.characters.php count_characters (Smarty online manual)
 * @author Uwe Tews
 * @param array $params parameters
 * @return string with compiled code
 */
function smarty_modifiercompiler_count_characters($params, $compiler)
{
    if (!isset($params[1]) || $params[1] != 'true') {
        return 'preg_match_all(\'/[^\s]/u\',' . $params[0] . ', $tmp)';
    }
    if (SMARTY_MBSTRING /* ^phpunit */&&empty($_SERVER['SMARTY_PHPUNIT_DISABLE_MBSTRING'])/* phpunit$ */) {
        return 'mb_strlen(' . $params[0] . ', SMARTY_RESOURCE_CHAR_SET)';
    }
    // no MBString fallback
    return 'strlen(' . $params[0] . ')';
}

?><?php
/**
 * Smarty plugin
 *
 * This plugin is only for Smarty2 BC
 * @package Smarty
 * @subpackage PluginsFunction
 */

/**
 * Smarty {math} function plugin
 *
 * Type:     function<br>
 * Name:     math<br>
 * Purpose:  handle math computations in template
 *
 * @link http://www.smarty.net/manual/en/language.function.math.php {math}
 *          (Smarty online manual)
 * @author   Monte Ohrt <monte at ohrt dot com>
 * @param array                    $params   parameters
 * @param Smarty_Internal_Template $template template object
 * @return string|null
 */
function smarty_function_math($params, $template)
{
    static $_allowed_funcs = array(
        'int' => true, 'abs' => true, 'ceil' => true, 'cos' => true, 'exp' => true, 'floor' => true,
        'log' => true, 'log10' => true, 'max' => true, 'min' => true, 'pi' => true, 'pow' => true,
        'rand' => true, 'round' => true, 'sin' => true, 'sqrt' => true, 'srand' => true ,'tan' => true
    );
    // be sure equation parameter is present
    if (empty($params['equation'])) {
        trigger_error("math: missing equation parameter",E_USER_WARNING);
        return;
    }

    $equation = $params['equation'];

    // make sure parenthesis are balanced
    if (substr_count($equation,"(") != substr_count($equation,")")) {
        trigger_error("math: unbalanced parenthesis",E_USER_WARNING);
        return;
    }

    // match all vars in equation, make sure all are passed
    preg_match_all("!(?:0x[a-fA-F0-9]+)|([a-zA-Z][a-zA-Z0-9_]*)!",$equation, $match);

    foreach($match[1] as $curr_var) {
        if ($curr_var && !isset($params[$curr_var]) && !isset($_allowed_funcs[$curr_var])) {
            trigger_error("math: function call $curr_var not allowed",E_USER_WARNING);
            return;
        }
    }

    foreach($params as $key => $val) {
        if ($key != "equation" && $key != "format" && $key != "assign") {
            // make sure value is not empty
            if (strlen($val)==0) {
                trigger_error("math: parameter $key is empty",E_USER_WARNING);
                return;
            }
            if (!is_numeric($val)) {
                trigger_error("math: parameter $key: is not numeric",E_USER_WARNING);
                return;
            }
            $equation = preg_replace("/\b$key\b/", " \$params['$key'] ", $equation);
        }
    }
    $smarty_math_result = null;
    eval("\$smarty_math_result = ".$equation.";");

    if (empty($params['format'])) {
        if (empty($params['assign'])) {
            return $smarty_math_result;
        } else {
            $template->assign($params['assign'],$smarty_math_result);
        }
    } else {
        if (empty($params['assign'])){
            printf($params['format'],$smarty_math_result);
        } else {
            $template->assign($params['assign'],sprintf($params['format'],$smarty_math_result));
        }
    }
}

?><?php
/**
 * Smarty plugin
 *
 * @package Smarty
 * @subpackage PluginsModifierCompiler
 */

/**
 * Smarty to_charset modifier plugin
 *
 * Type:     modifier<br>
 * Name:     to_charset<br>
 * Purpose:  convert character encoding from internal encoding to $charset
 *
 * @author Rodney Rehm
 * @param array $params parameters
 * @return string with compiled code
 */
function smarty_modifiercompiler_to_charset($params, $compiler)
{
    if (!SMARTY_MBSTRING /* ^phpunit */&&empty($_SERVER['SMARTY_PHPUNIT_DISABLE_MBSTRING'])/* phpunit$ */) {
        // FIXME: (rodneyrehm) shouldn't this throw an error?
        return $params[0];
    }

    if (!isset($params[1])) {
        $params[1] = '"ISO-8859-1"';
    }

    return 'mb_convert_encoding(' . $params[0] . ', ' . $params[1] . ', SMARTY_RESOURCE_CHAR_SET)';
}

?><?php
/**
 * Smarty plugin
 * @package Smarty
 * @subpackage PluginsModifierCompiler
 */

/**
 * Smarty lower modifier plugin
 *
 * Type:     modifier<br>
 * Name:     lower<br>
 * Purpose:  convert string to lowercase
 *
 * @link http://www.smarty.net/manual/en/language.modifier.lower.php lower (Smarty online manual)
 * @author Monte Ohrt <monte at ohrt dot com>
 * @author Uwe Tews
 * @param array $params parameters
 * @return string with compiled code
 */

function smarty_modifiercompiler_lower($params, $compiler)
{
    if (SMARTY_MBSTRING /* ^phpunit */&&empty($_SERVER['SMARTY_PHPUNIT_DISABLE_MBSTRING'])/* phpunit$ */) {
        return 'mb_strtolower(' . $params[0] . ',SMARTY_RESOURCE_CHAR_SET)' ;
    }
    // no MBString fallback
    return 'strtolower(' . $params[0] . ')';
}

?><?php
/**
 * Smarty plugin
 *
 * @package Smarty
 * @subpackage PluginsModifierCompiler
 */

/**
 * Smarty strip_tags modifier plugin
 *
 * Type:     modifier<br>
 * Name:     strip_tags<br>
 * Purpose:  strip html tags from text
 *
 * @link http://www.smarty.net/manual/en/language.modifier.strip.tags.php strip_tags (Smarty online manual)
 * @author Uwe Tews
 * @param array $params parameters
 * @return string with compiled code
 */
function smarty_modifiercompiler_strip_tags($params, $compiler)
{
   if (!isset($params[1])) {
        $params[1] = true;
    }
    if ($params[1] === true) {
        return "preg_replace('!<[^>]*?>!', ' ', {$params[0]})";
    } else {
        return 'strip_tags(' . $params[0] . ')';
    }
}

?><?php
/**
 * Smarty plugin
 *
 * @package Smarty
 * @subpackage PluginsModifierCompiler
 */

/**
 * Smarty noprint modifier plugin
 *
 * Type:     modifier<br>
 * Name:     noprint<br>
 * Purpose:  return an empty string
 *
 * @author   Uwe Tews
 * @param array $params parameters
 * @return string with compiled code
 */
function smarty_modifiercompiler_noprint($params, $compiler)
{
    return "''";
}

?><?php
/**
 * Smarty plugin
 *
 * @package Smarty
 * @subpackage PluginsFunction
 */

/**
 * Smarty {mailto} function plugin
 *
 * Type:     function<br>
 * Name:     mailto<br>
 * Date:     May 21, 2002
 * Purpose:  automate mailto address link creation, and optionally encode them.<br>
 * Params:
 * <pre>
 * - address    - (required) - e-mail address
 * - text       - (optional) - text to display, default is address
 * - encode     - (optional) - can be one of:
 *                             * none : no encoding (default)
 *                             * javascript : encode with javascript
 *                             * javascript_charcode : encode with javascript charcode
 *                             * hex : encode with hexidecimal (no javascript)
 * - cc         - (optional) - address(es) to carbon copy
 * - bcc        - (optional) - address(es) to blind carbon copy
 * - subject    - (optional) - e-mail subject
 * - newsgroups - (optional) - newsgroup(s) to post to
 * - followupto - (optional) - address(es) to follow up to
 * - extra      - (optional) - extra tags for the href link
 * </pre>
 * Examples:
 * <pre>
 * {mailto address="me@domain.com"}
 * {mailto address="me@domain.com" encode="javascript"}
 * {mailto address="me@domain.com" encode="hex"}
 * {mailto address="me@domain.com" subject="Hello to you!"}
 * {mailto address="me@domain.com" cc="you@domain.com,they@domain.com"}
 * {mailto address="me@domain.com" extra='class="mailto"'}
 * </pre>
 *
 * @link http://www.smarty.net/manual/en/language.function.mailto.php {mailto}
 *          (Smarty online manual)
 * @version 1.2
 * @author Monte Ohrt <monte at ohrt dot com>
 * @author credits to Jason Sweat (added cc, bcc and subject functionality)
 * @param array                    $params   parameters
 * @param Smarty_Internal_Template $template template object
 * @return string
 */
function smarty_function_mailto($params, $template)
{
    static $_allowed_encoding = array('javascript' => true, 'javascript_charcode' => true, 'hex' => true, 'none' => true);
    $extra = '';

    if (empty($params['address'])) {
        trigger_error("mailto: missing 'address' parameter",E_USER_WARNING);
        return;
    } else {
        $address = $params['address'];
    }

    $text = $address;
    // netscape and mozilla do not decode %40 (@) in BCC field (bug?)
    // so, don't encode it.
    $search = array('%40', '%2C');
    $replace = array('@', ',');
    $mail_parms = array();
    foreach ($params as $var => $value) {
        switch ($var) {
            case 'cc':
            case 'bcc':
            case 'followupto':
                if (!empty($value))
                    $mail_parms[] = $var . '=' . str_replace($search, $replace, rawurlencode($value));
                break;

            case 'subject':
            case 'newsgroups':
                $mail_parms[] = $var . '=' . rawurlencode($value);
                break;

            case 'extra':
            case 'text':
                $$var = $value;

            default:
        }
    }

    if ($mail_parms) {
        $address .= '?' . join('&', $mail_parms);
    }
    
    $encode = (empty($params['encode'])) ? 'none' : $params['encode'];
    if (!isset($_allowed_encoding[$encode])) {
        trigger_error("mailto: 'encode' parameter must be none, javascript, javascript_charcode or hex", E_USER_WARNING);
        return;
    }
    // FIXME: (rodneyrehm) document.write() excues me what? 1998 has passed!
    if ($encode == 'javascript') {
        $string = 'document.write(\'<a href="mailto:' . $address . '" ' . $extra . '>' . $text . '</a>\');';

        $js_encode = '';
        for ($x = 0, $_length = strlen($string); $x < $_length; $x++) {
            $js_encode .= '%' . bin2hex($string[$x]);
        }

        return '<script type="text/javascript">eval(unescape(\'' . $js_encode . '\'))</script>';
    } elseif ($encode == 'javascript_charcode') {
        $string = '<a href="mailto:' . $address . '" ' . $extra . '>' . $text . '</a>';

        for($x = 0, $y = strlen($string); $x < $y; $x++) {
            $ord[] = ord($string[$x]);
        }

        $_ret = "<script type=\"text/javascript\" language=\"javascript\">\n"
            . "{document.write(String.fromCharCode("
            . implode(',', $ord)
            . "))"
            . "}\n"
            . "</script>\n";

        return $_ret;
    } elseif ($encode == 'hex') {
        preg_match('!^(.*)(\?.*)$!', $address, $match);
        if (!empty($match[2])) {
            trigger_error("mailto: hex encoding does not work with extra attributes. Try javascript.",E_USER_WARNING);
            return;
        }
        $address_encode = '';
        for ($x = 0, $_length = strlen($address); $x < $_length; $x++) {
            if (preg_match('!\w!u', $address[$x])) {
                $address_encode .= '%' . bin2hex($address[$x]);
            } else {
                $address_encode .= $address[$x];
            }
        }
        $text_encode = '';
        for ($x = 0, $_length = strlen($text); $x < $_length; $x++) {
            $text_encode .= '&#x' . bin2hex($text[$x]) . ';';
        }

        $mailto = "&#109;&#97;&#105;&#108;&#116;&#111;&#58;";
        return '<a href="' . $mailto . $address_encode . '" ' . $extra . '>' . $text_encode . '</a>';
    } else {
        // no encoding
        return '<a href="mailto:' . $address . '" ' . $extra . '>' . $text . '</a>';
    }
}

?><?php
/**
 * Smarty plugin
 *
 * @package Smarty
 * @subpackage PluginsModifierCompiler
 */

/**
 * Smarty from_charset modifier plugin
 *
 * Type:     modifier<br>
 * Name:     from_charset<br>
 * Purpose:  convert character encoding from $charset to internal encoding
 *
 * @author Rodney Rehm
 * @param array $params parameters
 * @return string with compiled code
 */
function smarty_modifiercompiler_from_charset($params, $compiler)
{
    if (!SMARTY_MBSTRING /* ^phpunit */&&empty($_SERVER['SMARTY_PHPUNIT_DISABLE_MBSTRING'])/* phpunit$ */) {
        // FIXME: (rodneyrehm) shouldn't this throw an error?
        return $params[0];
    }

    if (!isset($params[1])) {
        $params[1] = '"ISO-8859-1"';
    }

    return 'mb_convert_encoding(' . $params[0] . ', SMARTY_RESOURCE_CHAR_SET, ' . $params[1] . ')';
}

?><?php
/**
 * Smarty plugin
 *
 * @package Smarty
 * @subpackage PluginsModifierCompiler
 */

/**
 * Smarty strip modifier plugin
 *
 * Type:     modifier<br>
 * Name:     strip<br>
 * Purpose:  Replace all repeated spaces, newlines, tabs
 *              with a single space or supplied replacement string.<br>
 * Example:  {$var|strip} {$var|strip:"&nbsp;"}<br>
 * Date:     September 25th, 2002
 *
 * @link http://www.smarty.net/manual/en/language.modifier.strip.php strip (Smarty online manual)
 * @author Uwe Tews
 * @param array $params parameters
 * @return string with compiled code
 */

function smarty_modifiercompiler_strip($params, $compiler)
{
    if (!isset($params[1])) {
        $params[1] = "' '";
    }
    return "preg_replace('!\s+!u', {$params[1]},{$params[0]})";
}

?><?php
/**
 * Smarty plugin
 * @package Smarty
 * @subpackage PluginsModifierCompiler
 */

/**
 * Smarty indent modifier plugin
 *
 * Type:     modifier<br>
 * Name:     indent<br>
 * Purpose:  indent lines of text
 *
 * @link http://www.smarty.net/manual/en/language.modifier.indent.php indent (Smarty online manual)
 * @author Uwe Tews
 * @param array $params parameters
 * @return string with compiled code
 */

function smarty_modifiercompiler_indent($params, $compiler)
{
    if (!isset($params[1])) {
        $params[1] = 4;
    }
    if (!isset($params[2])) {
        $params[2] = "' '";
    }
    return 'preg_replace(\'!^!m\',str_repeat(' . $params[2] . ',' . $params[1] . '),' . $params[0] . ')';
}

?><?php
/**
 * Smarty plugin
 * 
 * @package Smarty
 * @subpackage PluginsFunction
 */

/**
 * Smarty {html_image} function plugin
 * 
 * Type:     function<br>
 * Name:     html_image<br>
 * Date:     Feb 24, 2003<br>
 * Purpose:  format HTML tags for the image<br>
 * Examples: {html_image file="/images/masthead.gif"}<br>
 * Output:   <img src="/images/masthead.gif" width=400 height=23><br>
 * Params:
 * <pre>
 * - file        - (required) - file (and path) of image
 * - height      - (optional) - image height (default actual height)
 * - width       - (optional) - image width (default actual width)
 * - basedir     - (optional) - base directory for absolute paths, default is environment variable DOCUMENT_ROOT
 * - path_prefix - prefix for path output (optional, default empty)
 * </pre>
 * 
 * @link http://www.smarty.net/manual/en/language.function.html.image.php {html_image}
 *      (Smarty online manual)
 * @author Monte Ohrt <monte at ohrt dot com> 
 * @author credits to Duda <duda@big.hu> 
 * @version 1.0
 * @param array                    $params   parameters
 * @param Smarty_Internal_Template $template template object
 * @return string 
 * @uses smarty_function_escape_special_chars()
 */
function smarty_function_html_image($params, $template)
{
    require_once(SMARTY_PLUGINS_DIR . 'shared.escape_special_chars.php');
 
    $alt = '';
    $file = '';
    $height = '';
    $width = '';
    $extra = '';
    $prefix = '';
    $suffix = '';
    $path_prefix = '';
    $server_vars = $_SERVER;
    $basedir = isset($server_vars['DOCUMENT_ROOT']) ? $server_vars['DOCUMENT_ROOT'] : '';
    foreach($params as $_key => $_val) {
        switch ($_key) {
            case 'file':
            case 'height':
            case 'width':
            case 'dpi':
            case 'path_prefix':
            case 'basedir':
                $$_key = $_val;
                break;

            case 'alt':
                if (!is_array($_val)) {
                    $$_key = smarty_function_escape_special_chars($_val);
                } else {
                    throw new SmartyException ("html_image: extra attribute '$_key' cannot be an array", E_USER_NOTICE);
                } 
                break;

            case 'link':
            case 'href':
                $prefix = '<a href="' . $_val . '">';
                $suffix = '</a>';
                break;

            default:
                if (!is_array($_val)) {
                    $extra .= ' ' . $_key . '="' . smarty_function_escape_special_chars($_val) . '"';
                } else {
                    throw new SmartyException ("html_image: extra attribute '$_key' cannot be an array", E_USER_NOTICE);
                } 
                break;
        } 
    } 

    if (empty($file)) {
        trigger_error("html_image: missing 'file' parameter", E_USER_NOTICE);
        return;
    } 

    if (substr($file, 0, 1) == '/') {
        $_image_path = $basedir . $file;
    } else {
        $_image_path = $file;
    } 

    if (!isset($params['width']) || !isset($params['height'])) {
        if (!$_image_data = @getimagesize($_image_path)) {
            if (!file_exists($_image_path)) {
                trigger_error("html_image: unable to find '$_image_path'", E_USER_NOTICE);
                return;
            } else if (!is_readable($_image_path)) {
                trigger_error("html_image: unable to read '$_image_path'", E_USER_NOTICE);
                return;
            } else {
                trigger_error("html_image: '$_image_path' is not a valid image file", E_USER_NOTICE);
                return;
            } 
        } 
        if (isset($template->smarty->security_policy)) {
            if (!$template->smarty->security_policy->isTrustedResourceDir($_image_path)) {
                return;
            } 
        } 

        if (!isset($params['width'])) {
            $width = $_image_data[0];
        } 
        if (!isset($params['height'])) {
            $height = $_image_data[1];
        } 
    } 

    if (isset($params['dpi'])) {
        if (strstr($server_vars['HTTP_USER_AGENT'], 'Mac')) {
            $dpi_default = 72;
        } else {
            $dpi_default = 96;
        } 
        $_resize = $dpi_default / $params['dpi'];
        $width = round($width * $_resize);
        $height = round($height * $_resize);
    } 

    return $prefix . '<img src="' . $path_prefix . $file . '" alt="' . $alt . '" width="' . $width . '" height="' . $height . '"' . $extra . ' />' . $suffix;
} 

?><?php
/**
 * Smarty plugin to format text blocks
 *
 * @package Smarty
 * @subpackage PluginsBlock
 */

/**
 * Smarty {textformat}{/textformat} block plugin
 *
 * Type:     block function<br>
 * Name:     textformat<br>
 * Purpose:  format text a certain way with preset styles
 *           or custom wrap/indent settings<br>
 * Params:
 * <pre>
 * - style         - string (email)
 * - indent        - integer (0)
 * - wrap          - integer (80)
 * - wrap_char     - string ("\n")
 * - indent_char   - string (" ")
 * - wrap_boundary - boolean (true)
 * </pre>
 *
 * @link http://www.smarty.net/manual/en/language.function.textformat.php {textformat}
 *       (Smarty online manual)
 * @param array                    $params   parameters
 * @param string                   $content  contents of the block
 * @param Smarty_Internal_Template $template template object
 * @param boolean                  &$repeat  repeat flag
 * @return string content re-formatted
 * @author Monte Ohrt <monte at ohrt dot com>
 */
function smarty_block_textformat($params, $content, $template, &$repeat)
{
    if (is_null($content)) {
        return;
    }

    $style = null;
    $indent = 0;
    $indent_first = 0;
    $indent_char = ' ';
    $wrap = 80;
    $wrap_char = "\n";
    $wrap_cut = false;
    $assign = null;

    foreach ($params as $_key => $_val) {
        switch ($_key) {
            case 'style':
            case 'indent_char':
            case 'wrap_char':
            case 'assign':
                $$_key = (string)$_val;
                break;

            case 'indent':
            case 'indent_first':
            case 'wrap':
                $$_key = (int)$_val;
                break;

            case 'wrap_cut':
                $$_key = (bool)$_val;
                break;

            default:
                trigger_error("textformat: unknown attribute '$_key'");
        }
    }

    if ($style == 'email') {
        $wrap = 72;
    }
    // split into paragraphs
    $_paragraphs = preg_split('![\r\n]{2}!', $content);
    $_output = '';


    foreach ($_paragraphs as &$_paragraph) {
        if (!$_paragraph) {
            continue;
        }
        // convert mult. spaces & special chars to single space
        $_paragraph = preg_replace(array('!\s+!u', '!(^\s+)|(\s+$)!u'), array(' ', ''), $_paragraph);
        // indent first line
        if ($indent_first > 0) {
            $_paragraph = str_repeat($indent_char, $indent_first) . $_paragraph;
        }
        // wordwrap sentences
        if (SMARTY_MBSTRING /* ^phpunit */&&empty($_SERVER['SMARTY_PHPUNIT_DISABLE_MBSTRING'])/* phpunit$ */) {
            require_once(SMARTY_PLUGINS_DIR . 'shared.mb_wordwrap.php');
            $_paragraph = smarty_mb_wordwrap($_paragraph, $wrap - $indent, $wrap_char, $wrap_cut);
        } else {
            $_paragraph = wordwrap($_paragraph, $wrap - $indent, $wrap_char, $wrap_cut);
        }
        // indent lines
        if ($indent > 0) {
            $_paragraph = preg_replace('!^!m', str_repeat($indent_char, $indent), $_paragraph);
        }
    }
    $_output = implode($wrap_char . $wrap_char, $_paragraphs);
    
    if ($assign) {
        $template->assign($assign, $_output);
    } else {
        return $_output;
    }
}

?><?php
/**
 * Smarty plugin
 * @package Smarty
 * @subpackage PluginsFunction
 */

/**
 * Smarty {counter} function plugin
 *
 * Type:     function<br>
 * Name:     counter<br>
 * Purpose:  print out a counter value
 *
 * @author Monte Ohrt <monte at ohrt dot com>
 * @link http://www.smarty.net/manual/en/language.function.counter.php {counter}
 *       (Smarty online manual)
 * @param array                    $params   parameters
 * @param Smarty_Internal_Template $template template object
 * @return string|null
 */
function smarty_function_counter($params, $template)
{
    static $counters = array();

    $name = (isset($params['name'])) ? $params['name'] : 'default';
    if (!isset($counters[$name])) {
        $counters[$name] = array(
            'start'=>1,
            'skip'=>1,
            'direction'=>'up',
            'count'=>1
            );
    }
    $counter =& $counters[$name];

    if (isset($params['start'])) {
        $counter['start'] = $counter['count'] = (int)$params['start'];
    }

    if (!empty($params['assign'])) {
        $counter['assign'] = $params['assign'];
    }

    if (isset($counter['assign'])) {
        $template->assign($counter['assign'], $counter['count']);
    }
    
    if (isset($params['print'])) {
        $print = (bool)$params['print'];
    } else {
        $print = empty($counter['assign']);
    }

    if ($print) {
        $retval = $counter['count'];
    } else {
        $retval = null;
    }

    if (isset($params['skip'])) {
        $counter['skip'] = $params['skip'];
    }
    
    if (isset($params['direction'])) {
        $counter['direction'] = $params['direction'];
    }

    if ($counter['direction'] == "down")
        $counter['count'] -= $counter['skip'];
    else
        $counter['count'] += $counter['skip'];
    
    return $retval;
    
}

?><?php
/**
 * Smarty plugin
 *
 * @package Smarty
 * @subpackage PluginsFunction
 */

/**
 * @ignore
 */
require_once(SMARTY_PLUGINS_DIR . 'shared.escape_special_chars.php');
/**
 * @ignore
 */
require_once(SMARTY_PLUGINS_DIR . 'shared.make_timestamp.php');

/**
 * Smarty {html_select_time} function plugin
 *
 * Type:     function<br>
 * Name:     html_select_time<br>
 * Purpose:  Prints the dropdowns for time selection
 *
 * @link http://www.smarty.net/manual/en/language.function.html.select.time.php {html_select_time}
 *          (Smarty online manual)
 * @author Roberto Berto <roberto@berto.net>
 * @author Monte Ohrt <monte AT ohrt DOT com>
 * @param array                    $params   parameters
 * @param Smarty_Internal_Template $template template object
 * @return string
 * @uses smarty_make_timestamp()
 */
function smarty_function_html_select_time($params, $template)
{
    $prefix = "Time_";
    $field_array = null;
    $field_separator = "\n";
    $option_separator = "\n";
    $time = null;

    $display_hours = true;
    $display_minutes = true;
    $display_seconds = true;
    $display_meridian = true;

    $hour_format = '%02d';
    $hour_value_format = '%02d';
    $minute_format = '%02d';
    $minute_value_format = '%02d';
    $second_format = '%02d';
    $second_value_format = '%02d';

    $hour_size = null;
    $minute_size = null;
    $second_size = null;
    $meridian_size = null;

    $all_empty = null;
    $hour_empty = null;
    $minute_empty = null;
    $second_empty = null;
    $meridian_empty = null;

    $all_id = null;
    $hour_id = null;
    $minute_id = null;
    $second_id = null;
    $meridian_id = null;

    $use_24_hours = true;
    $minute_interval = 1;
    $second_interval = 1;

    $extra_attrs = '';
    $all_extra = null;
    $hour_extra = null;
    $minute_extra = null;
    $second_extra = null;
    $meridian_extra = null;

    foreach ($params as $_key => $_value) {
        switch ($_key) {
            case 'time':
                if (!is_array($_value)) {
                    $time = smarty_make_timestamp($_value);
                }
                break;

            case 'prefix':
            case 'field_array':

            case 'field_separator':
            case 'option_separator':

            case 'all_extra':
            case 'hour_extra':
            case 'minute_extra':
            case 'second_extra':
            case 'meridian_extra':

            case 'all_empty':
            case 'hour_empty':
            case 'minute_empty':
            case 'second_empty':
            case 'meridian_empty':

            case 'all_id':
            case 'hour_id':
            case 'minute_id':
            case 'second_id':
            case 'meridian_id':

            case 'hour_format':
            case 'hour_value_format':
            case 'minute_format':
            case 'minute_value_format':
            case 'second_format':
            case 'second_value_format':
                $$_key = (string)$_value;
                break;

            case 'display_hours':
            case 'display_minutes':
            case 'display_seconds':
            case 'display_meridian':
            case 'use_24_hours':
                $$_key = (bool)$_value;
                break;

            case 'minute_interval':
            case 'second_interval':

            case 'hour_size':
            case 'minute_size':
            case 'second_size':
            case 'meridian_size':
                $$_key = (int)$_value;
                break;

            default:
                if (!is_array($_value)) {
                    $extra_attrs .= ' ' . $_key . '="' . smarty_function_escape_special_chars($_value) . '"';
                } else {
                    trigger_error("html_select_date: extra attribute '$_key' cannot be an array", E_USER_NOTICE);
                }
                break;
        }
    }

    if (isset($params['time']) && is_array($params['time'])) {
        if (isset($params['time'][$prefix . 'Hour'])) {
            // $_REQUEST[$field_array] given
            foreach (array('H' => 'Hour',  'i' => 'Minute', 's' => 'Second') as $_elementKey => $_elementName) {
                $_variableName = '_' . strtolower($_elementName);
                $$_variableName = isset($params['time'][$prefix . $_elementName])
                    ? $params['time'][$prefix . $_elementName]
                    : date($_elementKey);
            }
            $_meridian = isset($params['time'][$prefix . 'Meridian'])
                ? (' ' . $params['time'][$prefix . 'Meridian'])
                : '';
            $time = strtotime( $_hour . ':' . $_minute . ':' . $_second . $_meridian );
            list($_hour, $_minute, $_second) = $time = explode('-', date('H-i-s', $time));
        } elseif (isset($params['time'][$field_array][$prefix . 'Hour'])) {
            // $_REQUEST given
            foreach (array('H' => 'Hour',  'i' => 'Minute', 's' => 'Second') as $_elementKey => $_elementName) {
                $_variableName = '_' . strtolower($_elementName);
                $$_variableName = isset($params['time'][$field_array][$prefix . $_elementName])
                    ? $params['time'][$field_array][$prefix . $_elementName]
                    : date($_elementKey);
            }
            $_meridian = isset($params['time'][$field_array][$prefix . 'Meridian'])
                ? (' ' . $params['time'][$field_array][$prefix . 'Meridian'])
                : '';
            $time = strtotime( $_hour . ':' . $_minute . ':' . $_second . $_meridian );
            list($_hour, $_minute, $_second) = $time = explode('-', date('H-i-s', $time));
        } else {
            // no date found, use NOW
            list($_year, $_month, $_day) = $time = explode('-', date('Y-m-d'));
        }
    } elseif ($time === null) {
        list($_hour, $_minute, $_second) = $time = explode('-', date('H-i-s'));
    } else {
        list($_hour, $_minute, $_second) = $time = explode('-', date('H-i-s', $time));
    }

    // generate hour <select>
    if ($display_hours) {
        $_html_hours = '';
        $_extra = '';
        $_name = $field_array ? ($field_array . '[' . $prefix . 'Hour]') : ($prefix . 'Hour');
        if ($all_extra) {
            $_extra .= ' ' . $all_extra;
        }
        if ($hour_extra) {
            $_extra .= ' ' . $hour_extra;
        }

        $_html_hours = '<select name="' . $_name . '"';
        if ($hour_id !== null || $all_id !== null) {
            $_html_hours .= ' id="' . smarty_function_escape_special_chars(
                $hour_id !== null ? ( $hour_id ? $hour_id : $_name ) : ( $all_id ? ($all_id . $_name) : $_name )
            ) . '"';
        }
        if ($hour_size) {
            $_html_hours .= ' size="' . $hour_size . '"';
        }
        $_html_hours .= $_extra . $extra_attrs . '>' . $option_separator;

        if (isset($hour_empty) || isset($all_empty)) {
            $_html_hours .= '<option value="">' . ( isset($hour_empty) ? $hour_empty : $all_empty ) . '</option>' . $option_separator;
        }

        $start = $use_24_hours ? 0 : 1;
        $end = $use_24_hours ? 23 : 12;
        for ($i=$start; $i <= $end; $i++) {
            $_val = sprintf('%02d', $i);
            $_text = $hour_format == '%02d' ? $_val : sprintf($hour_format, $i);
            $_value = $hour_value_format == '%02d' ? $_val : sprintf($hour_value_format, $i);

            if ($use_24_hours) {
                $selected = $_hour == $_val;
            } else {
                $_hour12 = $_hour == 0
                    ? 12
                    : ($_hour <= 12 ? $_hour : $_hour -12);
            }

            $selected = $use_24_hours ? $_hour == $_val : $_hour12 == $_val;
            $_html_hours .= '<option value="' . $_value . '"'
                . ($selected ? ' selected="selected"' : '')
                . '>' . $_text . '</option>' . $option_separator;
        }

        $_html_hours .= '</select>';
    }

    // generate minute <select>
    if ($display_minutes) {
        $_html_minutes = '';
        $_extra = '';
        $_name = $field_array ? ($field_array . '[' . $prefix . 'Minute]') : ($prefix . 'Minute');
        if ($all_extra) {
            $_extra .= ' ' . $all_extra;
        }
        if ($minute_extra) {
            $_extra .= ' ' . $minute_extra;
        }

        $_html_minutes = '<select name="' . $_name . '"';
        if ($minute_id !== null || $all_id !== null) {
            $_html_minutes .= ' id="' . smarty_function_escape_special_chars(
                $minute_id !== null ? ( $minute_id ? $minute_id : $_name ) : ( $all_id ? ($all_id . $_name) : $_name )
            ) . '"';
        }
        if ($minute_size) {
            $_html_minutes .= ' size="' . $minute_size . '"';
        }
        $_html_minutes .= $_extra . $extra_attrs . '>' . $option_separator;

        if (isset($minute_empty) || isset($all_empty)) {
            $_html_minutes .= '<option value="">' . ( isset($minute_empty) ? $minute_empty : $all_empty ) . '</option>' . $option_separator;
        }

        $selected = $_minute - $_minute % $minute_interval;
        for ($i=0; $i <= 59; $i += $minute_interval) {
            $_val = sprintf('%02d', $i);
            $_text = $minute_format == '%02d' ? $_val : sprintf($minute_format, $i);
            $_value = $minute_value_format == '%02d' ? $_val : sprintf($minute_value_format, $i);
            $_html_minutes .= '<option value="' . $_value . '"'
                . ($selected == $i ? ' selected="selected"' : '')
                . '>' . $_text . '</option>' . $option_separator;
        }

        $_html_minutes .= '</select>';
    }

    // generate second <select>
    if ($display_seconds) {
        $_html_seconds = '';
        $_extra = '';
        $_name = $field_array ? ($field_array . '[' . $prefix . 'Second]') : ($prefix . 'Second');
        if ($all_extra) {
            $_extra .= ' ' . $all_extra;
        }
        if ($second_extra) {
            $_extra .= ' ' . $second_extra;
        }

        $_html_seconds = '<select name="' . $_name . '"';
        if ($second_id !== null || $all_id !== null) {
            $_html_seconds .= ' id="' . smarty_function_escape_special_chars(
                $second_id !== null ? ( $second_id ? $second_id : $_name ) : ( $all_id ? ($all_id . $_name) : $_name )
            ) . '"';
        }
        if ($second_size) {
            $_html_seconds .= ' size="' . $second_size . '"';
        }
        $_html_seconds .= $_extra . $extra_attrs . '>' . $option_separator;

        if (isset($second_empty) || isset($all_empty)) {
            $_html_seconds .= '<option value="">' . ( isset($second_empty) ? $second_empty : $all_empty ) . '</option>' . $option_separator;
        }

        $selected = $_second - $_second % $second_interval;
        for ($i=0; $i <= 59; $i += $second_interval) {
            $_val = sprintf('%02d', $i);
            $_text = $second_format == '%02d' ? $_val : sprintf($second_format, $i);
            $_value = $second_value_format == '%02d' ? $_val : sprintf($second_value_format, $i);
            $_html_seconds .= '<option value="' . $_value . '"'
                . ($selected == $i ? ' selected="selected"' : '')
                . '>' . $_text . '</option>' . $option_separator;
        }

        $_html_seconds .= '</select>';
    }

    // generate meridian <select>
    if ($display_meridian && !$use_24_hours) {
        $_html_meridian = '';
        $_extra = '';
        $_name = $field_array ? ($field_array . '[' . $prefix . 'Meridian]') : ($prefix . 'Meridian');
        if ($all_extra) {
            $_extra .= ' ' . $all_extra;
        }
        if ($meridian_extra) {
            $_extra .= ' ' . $meridian_extra;
        }

        $_html_meridian = '<select name="' . $_name . '"';
        if ($meridian_id !== null || $all_id !== null) {
            $_html_meridian .= ' id="' . smarty_function_escape_special_chars(
                $meridian_id !== null ? ( $meridian_id ? $meridian_id : $_name ) : ( $all_id ? ($all_id . $_name) : $_name )
            ) . '"';
        }
        if ($meridian_size) {
            $_html_meridian .= ' size="' . $meridian_size . '"';
        }
        $_html_meridian .= $_extra . $extra_attrs . '>' . $option_separator;

        if (isset($meridian_empty) || isset($all_empty)) {
            $_html_meridian .= '<option value="">' . ( isset($meridian_empty) ? $meridian_empty : $all_empty ) . '</option>' . $option_separator;
        }

        $_html_meridian .= '<option value="am"'. ($_hour < 12 ? ' selected="selected"' : '') .'>AM</option>' . $option_separator
            . '<option value="pm"'. ($_hour < 12 ? '' : ' selected="selected"') .'>PM</option>' . $option_separator
            . '</select>';
    }

    $_html = '';
    foreach (array('_html_hours', '_html_minutes', '_html_seconds', '_html_meridian') as $k) {
        if (isset($$k)) {
            if ($_html) {
                $_html .= $field_separator;
            }
            $_html .= $$k;
        }
    }

    return $_html;
}

?><?php
/**
 * Smarty plugin
 *
 * @package Smarty
 * @subpackage PluginsFilter
 */

/**
 * Smarty trimwhitespace outputfilter plugin
 *
 * Trim unnecessary whitespace from HTML markup.
 *
 * @author   Rodney Rehm
 * @param string                   $source input string
 * @param Smarty_Internal_Template $smarty Smarty object
 * @return string filtered output
 */
function smarty_outputfilter_trimwhitespace($source, Smarty_Internal_Template $smarty)
{
    $store = array();
    $_store = 0;
    $_offset = 0;

    // Unify Line-Breaks to \n
    $source = preg_replace("/\015\012|\015|\012/", "\n", $source);

    // capture Internet Explorer Conditional Comments
    if (preg_match_all('#<!--\[[^\]]+\]>.*?<!\[[^\]]+\]-->#is', $source, $matches, PREG_OFFSET_CAPTURE | PREG_SET_ORDER)) {
        foreach ($matches as $match) {
            $store[] = $match[0][0];
            $_length = strlen($match[0][0]);
            $replace = '@!@SMARTY:' . $_store . ':SMARTY@!@';
            $source = substr_replace($source, $replace, $match[0][1] - $_offset, $_length);

            $_offset += $_length - strlen($replace);
            $_store++;
        }
    }

    // Strip all HTML-Comments
    $source = preg_replace( '#<!--.*?-->#ms', '', $source );

    // capture html elements not to be messed with
    $_offset = 0;
    if (preg_match_all('#<(script|pre|textarea)[^>]*>.*?</\\1>#is', $source, $matches, PREG_OFFSET_CAPTURE | PREG_SET_ORDER)) {
        foreach ($matches as $match) {
            $store[] = $match[0][0];
            $_length = strlen($match[0][0]);
            $replace = '@!@SMARTY:' . $_store . ':SMARTY@!@';
            $source = substr_replace($source, $replace, $match[0][1] - $_offset, $_length);

            $_offset += $_length - strlen($replace);
            $_store++;
        }
    }

    $expressions = array(
        // replace multiple spaces between tags by a single space
        // can't remove them entirely, becaue that might break poorly implemented CSS display:inline-block elements
        '#(:SMARTY@!@|>)\s+(?=@!@SMARTY:|<)#s' => '\1 \2',
        // remove spaces between attributes (but not in attribute values!)
        '#(([a-z0-9]\s*=\s*(["\'])[^\3]*?\3)|<[a-z0-9_]+)\s+([a-z/>])#is' => '\1 \4',
        // note: for some very weird reason trim() seems to remove spaces inside attributes.
        // maybe a \0 byte or something is interfering?
        '#^\s+<#Ss' => '<',
        '#>\s+$#Ss' => '>',
    );

    $source = preg_replace( array_keys($expressions), array_values($expressions), $source );
    // note: for some very weird reason trim() seems to remove spaces inside attributes.
    // maybe a \0 byte or something is interfering?
    // $source = trim( $source );

    // capture html elements not to be messed with
    $_offset = 0;
    if (preg_match_all('#@!@SMARTY:([0-9]+):SMARTY@!@#is', $source, $matches, PREG_OFFSET_CAPTURE | PREG_SET_ORDER)) {
        foreach ($matches as $match) {
            $store[] = $match[0][0];
            $_length = strlen($match[0][0]);
            $replace = array_shift($store);
            $source = substr_replace($source, $replace, $match[0][1] + $_offset, $_length);

            $_offset += strlen($replace) - $_length;
            $_store++;
        }
    }

    return $source;
}

?><?php
/**
 * Smarty plugin
 *
 * @package Smarty
 * @subpackage PluginsModifierCompiler
 */

/**
 * Smarty upper modifier plugin
 * 
 * Type:     modifier<br>
 * Name:     lower<br>
 * Purpose:  convert string to uppercase
 * 
 * @link http://smarty.php.net/manual/en/language.modifier.upper.php lower (Smarty online manual)
 * @author Uwe Tews 
 * @param array $params parameters
 * @return string with compiled code
 */
function smarty_modifiercompiler_upper($params, $compiler)
{
    if (SMARTY_MBSTRING /* ^phpunit */&&empty($_SERVER['SMARTY_PHPUNIT_DISABLE_MBSTRING'])/* phpunit$ */) {
        return 'mb_strtoupper(' . $params[0] . ',SMARTY_RESOURCE_CHAR_SET)' ;
    }
    // no MBString fallback
    return 'strtoupper(' . $params[0] . ')';
} 

?><?php
/**
 * Smarty plugin
 *
 * @package Smarty
 * @subpackage PluginsFilter
 */

/**
 * Smarty htmlspecialchars variablefilter plugin
 *
 * @param string                   $source input string
 * @param Smarty_Internal_Template $smarty Smarty object
 * @return string filtered output
 */
function smarty_variablefilter_htmlspecialchars($source, $smarty)
{
    return htmlspecialchars($source, ENT_QUOTES, SMARTY_RESOURCE_CHAR_SET);
}

?><?php
/**
 * Smarty plugin
 *
 * @package Smarty
 * @subpackage PluginsModifier
 */
 
/**
 * Smarty truncate modifier plugin
 * 
 * Type:     modifier<br>
 * Name:     truncate<br>
 * Purpose:  Truncate a string to a certain length if necessary,
 *               optionally splitting in the middle of a word, and
 *               appending the $etc string or inserting $etc into the middle.
 * 
 * @link http://smarty.php.net/manual/en/language.modifier.truncate.php truncate (Smarty online manual)
 * @author Monte Ohrt <monte at ohrt dot com> 
 * @param string  $string      input string
 * @param integer $length      length of truncated text
 * @param string  $etc         end string
 * @param boolean $break_words truncate at word boundary
 * @param boolean $middle      truncate in the middle of text
 * @return string truncated string
 */
function smarty_modifier_truncate($string, $length = 80, $etc = '...', $break_words = false, $middle = false) {
    if ($length == 0)
        return '';

    if (SMARTY_MBSTRING /* ^phpunit */&&empty($_SERVER['SMARTY_PHPUNIT_DISABLE_MBSTRING'])/* phpunit$ */) {
        if (mb_strlen($string, SMARTY_RESOURCE_CHAR_SET) > $length) {
            $length -= min($length, mb_strlen($etc, SMARTY_RESOURCE_CHAR_SET));
            if (!$break_words && !$middle) {
                $string = preg_replace('/\s+?(\S+)?$/u', '', mb_substr($string, 0, $length + 1, SMARTY_RESOURCE_CHAR_SET));
            } 
            if (!$middle) {
                return mb_substr($string, 0, $length, SMARTY_RESOURCE_CHAR_SET) . $etc;
            }
            return mb_substr($string, 0, $length / 2, SMARTY_RESOURCE_CHAR_SET) . $etc . mb_substr($string, - $length / 2, $length, SMARTY_RESOURCE_CHAR_SET);
        }
        return $string;
    }
    
    // no MBString fallback
    if (isset($string[$length])) {
        $length -= min($length, strlen($etc));
        if (!$break_words && !$middle) {
            $string = preg_replace('/\s+?(\S+)?$/', '', substr($string, 0, $length + 1));
        } 
        if (!$middle) {
            return substr($string, 0, $length) . $etc;
        }
        return substr($string, 0, $length / 2) . $etc . substr($string, - $length / 2);
    }
    return $string;
} 

?><?php
/**
 * Smarty plugin
 * @package Smarty
 * @subpackage PluginsModifier
 */

/**
 * Smarty replace modifier plugin
 * 
 * Type:     modifier<br>
 * Name:     replace<br>
 * Purpose:  simple search/replace
 * 
 * @link http://smarty.php.net/manual/en/language.modifier.replace.php replace (Smarty online manual)
 * @author Monte Ohrt <monte at ohrt dot com> 
 * @author Uwe Tews 
 * @param string $string  input string
 * @param string $search  text to search for
 * @param string $replace replacement text
 * @return string 
 */
function smarty_modifier_replace($string, $search, $replace)
{
    if (SMARTY_MBSTRING /* ^phpunit */&&empty($_SERVER['SMARTY_PHPUNIT_DISABLE_MBSTRING'])/* phpunit$ */) {
        require_once(SMARTY_PLUGINS_DIR . 'shared.mb_str_replace.php');
        return smarty_mb_str_replace($search, $replace, $string);
    }
    
    return str_replace($search, $replace, $string);
} 

?><?php
/**
 * Smarty shared plugin
 *
 * @package Smarty
 * @subpackage PluginsShared
 */
if (!function_exists('smarty_mb_str_replace')) {

    /**
     * Multibyte string replace
     *
     * @param string $search  the string to be searched
     * @param string $replace the replacement string
     * @param string $subject the source string
     * @param int    &$count  number of matches found
     * @return string replaced string
     * @author Rodney Rehm
     */
    function smarty_mb_str_replace($search, $replace, $subject, &$count=0)
    {
        if (!is_array($search) && is_array($replace)) {
            return false;
        }
        if (is_array($subject)) {
            // call mb_replace for each single string in $subject
            foreach ($subject as &$string) {
                $string = &smarty_mb_str_replace($search, $replace, $string, $c);
                $count += $c;
            }
        } elseif (is_array($search)) {
            if (!is_array($replace)) {
                foreach ($search as &$string) {
                    $subject = smarty_mb_str_replace($string, $replace, $subject, $c);
                    $count += $c;
                }
            } else {
                $n = max(count($search), count($replace));
                while ($n--) {
                    $subject = smarty_mb_str_replace(current($search), current($replace), $subject, $c);
                    $count += $c;
                    next($search);
                    next($replace);
                }
            }
        } else {
            $parts = mb_split(preg_quote($search), $subject);
            $count = count($parts) - 1;
            $subject = implode($replace, $parts);
        }
        return $subject;
    }

}
?><?php
/**
 * Smarty plugin
 * 
 * @package Smarty
 * @subpackage PluginsModifier
 */

/**
 * Smarty date_format modifier plugin
 * 
 * Type:     modifier<br>
 * Name:     date_format<br>
 * Purpose:  format datestamps via strftime<br>
 * Input:<br>
 *          - string: input date string
 *          - format: strftime format for output
 *          - default_date: default date if $string is empty
 * 
 * @link http://www.smarty.net/manual/en/language.modifier.date.format.php date_format (Smarty online manual)
 * @author Monte Ohrt <monte at ohrt dot com> 
 * @param string $string       input date string
 * @param string $format       strftime format for output
 * @param string $default_date default date if $string is empty
 * @param string $formatter    either 'strftime' or 'auto'
 * @return string |void
 * @uses smarty_make_timestamp()
 */
function smarty_modifier_date_format($string, $format = SMARTY_RESOURCE_DATE_FORMAT, $default_date = '',$formatter='auto')
{
    /**
    * Include the {@link shared.make_timestamp.php} plugin
    */
    require_once(SMARTY_PLUGINS_DIR . 'shared.make_timestamp.php');
    if ($string != '') {
        $timestamp = smarty_make_timestamp($string);
    } elseif ($default_date != '') {
        $timestamp = smarty_make_timestamp($default_date);
    } else {
        return;
    } 
    if($formatter=='strftime'||($formatter=='auto'&&strpos($format,'%')!==false)) {
        if (DS == '\\') {
            $_win_from = array('%D', '%h', '%n', '%r', '%R', '%t', '%T');
            $_win_to = array('%m/%d/%y', '%b', "\n", '%I:%M:%S %p', '%H:%M', "\t", '%H:%M:%S');
            if (strpos($format, '%e') !== false) {
                $_win_from[] = '%e';
                $_win_to[] = sprintf('%\' 2d', date('j', $timestamp));
            } 
            if (strpos($format, '%l') !== false) {
                $_win_from[] = '%l';
                $_win_to[] = sprintf('%\' 2d', date('h', $timestamp));
            } 
            $format = str_replace($_win_from, $_win_to, $format);
        } 
        return strftime($format, $timestamp);
    } else {
        return date($format, $timestamp);
    }
} 

?><?php
/**
 * Smarty plugin
 *
 * @package Smarty
 * @subpackage PluginsModifierCompiler
 */

/**
 * Smarty default modifier plugin
 *
 * Type:     modifier<br>
 * Name:     default<br>
 * Purpose:  designate default value for empty variables
 *
 * @link http://www.smarty.net/manual/en/language.modifier.default.php default (Smarty online manual)
 * @author Uwe Tews
 * @param array $params parameters
 * @return string with compiled code
 */
function smarty_modifiercompiler_default ($params, $compiler)
{
    $output = $params[0];
    if (!isset($params[1])) {
        $params[1] = "''";
    }
    
    array_shift($params);
    foreach ($params as $param) {
        $output = '(($tmp = @' . $output . ')===null||$tmp===\'\' ? ' . $param . ' : $tmp)';
    }
    return $output;
}

?><?php
/**
 * Smarty plugin
 *
 * @package Smarty
 * @subpackage PluginsModifierCompiler
 */

/**
 * Smarty wordwrap modifier plugin
 * 
 * Type:     modifier<br>
 * Name:     wordwrap<br>
 * Purpose:  wrap a string of text at a given length
 * 
 * @link http://smarty.php.net/manual/en/language.modifier.wordwrap.php wordwrap (Smarty online manual)
 * @author Uwe Tews 
 * @param array $params parameters
 * @return string with compiled code
 */
function smarty_modifiercompiler_wordwrap($params, $compiler)
{
    if (!isset($params[1])) {
        $params[1] = 80;
    } 
    if (!isset($params[2])) {
        $params[2] = '"\n"';
    } 
    if (!isset($params[3])) {
        $params[3] = 'false';
    } 
    $function = 'wordwrap';
    if (SMARTY_MBSTRING /* ^phpunit */&&empty($_SERVER['SMARTY_PHPUNIT_DISABLE_MBSTRING'])/* phpunit$ */) {
        if ($compiler->tag_nocache | $compiler->nocache) {
            $compiler->template->required_plugins['nocache']['wordwrap']['modifier']['file'] = SMARTY_PLUGINS_DIR .'shared.mb_wordwrap.php';
            $compiler->template->required_plugins['nocache']['wordwrap']['modifier']['function'] = 'smarty_mb_wordwrap';
        } else {
            $compiler->template->required_plugins['compiled']['wordwrap']['modifier']['file'] = SMARTY_PLUGINS_DIR .'shared.mb_wordwrap.php';
            $compiler->template->required_plugins['compiled']['wordwrap']['modifier']['function'] = 'smarty_mb_wordwrap';
        }
        $function = 'smarty_mb_wordwrap';
    }
    return $function . '(' . $params[0] . ',' . $params[1] . ',' . $params[2] . ',' . $params[3] . ')';
} 

?><?php
/**
 * Smarty plugin
 * 
 * @package Smarty
 * @subpackage PluginsFunction
 */

/**
 * Smarty {html_options} function plugin
 * 
 * Type:     function<br>
 * Name:     html_options<br>
 * Purpose:  Prints the list of <option> tags generated from
 *           the passed parameters<br>
 * Params:
 * <pre>
 * - name       (optional) - string default "select"
 * - values     (required) - if no options supplied) - array
 * - options    (required) - if no values supplied) - associative array
 * - selected   (optional) - string default not set
 * - output     (required) - if not options supplied) - array
 * - id         (optional) - string default not set
 * - class      (optional) - string default not set
 * </pre>
 * 
 * @link http://www.smarty.net/manual/en/language.function.html.options.php {html_image}
 *      (Smarty online manual)
 * @author Monte Ohrt <monte at ohrt dot com> 
 * @author Ralf Strehle (minor optimization) <ralf dot strehle at yahoo dot de>
 * @param array                    $params   parameters
 * @param Smarty_Internal_Template $template template object
 * @return string 
 * @uses smarty_function_escape_special_chars()
 */
function smarty_function_html_options($params, $template)
{
    require_once(SMARTY_PLUGINS_DIR . 'shared.escape_special_chars.php');

    $name = null;
    $values = null;
    $options = null;
    $selected = null;
    $output = null;
    $id = null;
    $class = null;

    $extra = '';

    foreach ($params as $_key => $_val) {
        switch ($_key) {
            case 'name':
            case 'class':
            case 'id':
                $$_key = (string) $_val;
                break;

            case 'options':
                $options = (array) $_val;
                break;

            case 'values':
            case 'output':
                $$_key = array_values((array) $_val);
                break;

            case 'selected':
                if (is_array($_val)) {
                    $selected = array();
                    foreach ($_val as $_sel) {
                        if (is_object($_sel)) {
                            if (method_exists($_sel, "__toString")) {
                                $_sel = smarty_function_escape_special_chars((string) $_sel->__toString());
                            } else {
                                trigger_error("html_options: selected attribute contains an object of class '". get_class($_sel) ."' without __toString() method", E_USER_NOTICE);
                                continue;
                            }
                        } else {
                            $_sel = smarty_function_escape_special_chars((string) $_sel);
                        }
                        $selected[$_sel] = true;
                    }
                } elseif (is_object($_val)) {
                    if (method_exists($_val, "__toString")) {
                        $selected = smarty_function_escape_special_chars((string) $_val->__toString());
                    } else {
                        trigger_error("html_options: selected attribute is an object of class '". get_class($_val) ."' without __toString() method", E_USER_NOTICE);
                    }
                } else {
                    $selected = smarty_function_escape_special_chars((string) $_val);
                }
                break;

            default:
                if (!is_array($_val)) {
                    $extra .= ' ' . $_key . '="' . smarty_function_escape_special_chars($_val) . '"';
                } else {
                    trigger_error("html_options: extra attribute '$_key' cannot be an array", E_USER_NOTICE);
                } 
                break;
        } 
    }

    if (!isset($options) && !isset($values)) {
        /* raise error here? */
        return '';
    }

    $_html_result = '';
    $_idx = 0;

    if (isset($options)) {
        foreach ($options as $_key => $_val) {
            $_html_result .= smarty_function_html_options_optoutput($_key, $_val, $selected, $id, $class, $_idx);
        }
    } else {
        foreach ($values as $_i => $_key) {
            $_val = isset($output[$_i]) ? $output[$_i] : '';
            $_html_result .= smarty_function_html_options_optoutput($_key, $_val, $selected, $id, $class, $_idx);
        } 
    }

    if (!empty($name)) {
        $_html_class = !empty($class) ? ' class="'.$class.'"' : '';
        $_html_id = !empty($id) ? ' id="'.$id.'"' : '';
        $_html_result = '<select name="' . $name . '"' . $_html_class . $_html_id . $extra . '>' . "\n" . $_html_result . '</select>' . "\n";
    } 

    return $_html_result;
}

function smarty_function_html_options_optoutput($key, $value, $selected, $id, $class, &$idx)
{
    if (!is_array($value)) {
        $_key = smarty_function_escape_special_chars($key);
        $_html_result = '<option value="' . $_key . '"';
        if (is_array($selected)) {
            if (isset($selected[$_key])) {
                $_html_result .= ' selected="selected"';
            }
        } elseif ($_key === $selected) {
            $_html_result .= ' selected="selected"';
        }
        $_html_class = !empty($class) ? ' class="'.$class.' option"' : '';
        $_html_id = !empty($id) ? ' id="'.$id.'-'.$idx.'"' : '';
        if (is_object($value)) {
            if (method_exists($value, "__toString")) {
                $value = smarty_function_escape_special_chars((string) $value->__toString());
            } else {
                trigger_error("html_options: value is an object of class '". get_class($value) ."' without __toString() method", E_USER_NOTICE);
                return '';
            }
        }
        $_html_result .= $_html_class . $_html_id . '>' . $value . '</option>' . "\n";
        $idx++;
    } else {
        $_idx = 0;
        $_html_result = smarty_function_html_options_optgroup($key, $value, $selected, !empty($id) ? ($id.'-'.$idx) : null, $class, $_idx);
        $idx++;
    }
    return $_html_result;
} 

function smarty_function_html_options_optgroup($key, $values, $selected, $id, $class, &$idx)
{
    $optgroup_html = '<optgroup label="' . smarty_function_escape_special_chars($key) . '">' . "\n";
    foreach ($values as $key => $value) {
        $optgroup_html .= smarty_function_html_options_optoutput($key, $value, $selected, $id, $class, $idx);
    } 
    $optgroup_html .= "</optgroup>\n";
    return $optgroup_html;
} 

?><?php
/**
 * Smarty plugin
 *
 * @package Smarty
 * @subpackage PluginsModifierCompiler
 */

/**
 * @ignore
 */
require_once( SMARTY_PLUGINS_DIR .'shared.literal_compiler_param.php' );

/**
 * Smarty escape modifier plugin
 *
 * Type:     modifier<br>
 * Name:     escape<br>
 * Purpose:  escape string for output
 *
 * @link http://www.smarty.net/docsv2/en/language.modifier.escape count_characters (Smarty online manual)
 * @author Rodney Rehm
 * @param array $params parameters
 * @return string with compiled code
 */
function smarty_modifiercompiler_escape($params, $compiler)
{
    try {
        $esc_type = smarty_literal_compiler_param($params, 1, 'html');
        $char_set = smarty_literal_compiler_param($params, 2, SMARTY_RESOURCE_CHAR_SET);
        $double_encode = smarty_literal_compiler_param($params, 3, true);

        if (!$char_set) {
            $char_set = SMARTY_RESOURCE_CHAR_SET;
        }

        switch ($esc_type) {
            case 'html':
                return 'htmlspecialchars('
                    . $params[0] .', ENT_QUOTES, '
                    . var_export($char_set, true) . ', '
                    . var_export($double_encode, true) . ')';

            case 'htmlall':
                if (SMARTY_MBSTRING /* ^phpunit */&&empty($_SERVER['SMARTY_PHPUNIT_DISABLE_MBSTRING'])/* phpunit$ */) {
                    return 'mb_convert_encoding(htmlspecialchars('
                        . $params[0] .', ENT_QUOTES, '
                        . var_export($char_set, true) . ', '
                        . var_export($double_encode, true)
                        . '), "HTML-ENTITIES", '
                        . var_export($char_set, true) . ')';
                }

                // no MBString fallback
                return 'htmlentities('
                    . $params[0] .', ENT_QUOTES, '
                    . var_export($char_set, true) . ', '
                    . var_export($double_encode, true) . ')';

            case 'url':
                return 'rawurlencode(' . $params[0] . ')';

            case 'urlpathinfo':
                return 'str_replace("%2F", "/", rawurlencode(' . $params[0] . '))';

            case 'quotes':
                // escape unescaped single quotes
                return 'preg_replace("%(?<!\\\\\\\\)\'%", "\\\'",' . $params[0] . ')';

            case 'javascript':
                // escape quotes and backslashes, newlines, etc.
                return 'strtr(' . $params[0] . ', array("\\\\" => "\\\\\\\\", "\'" => "\\\\\'", "\"" => "\\\\\"", "\\r" => "\\\\r", "\\n" => "\\\n", "</" => "<\/" ))';

        }
    } catch(SmartyException $e) {
        // pass through to regular plugin fallback
    }

    // could not optimize |escape call, so fallback to regular plugin
    if ($compiler->tag_nocache | $compiler->nocache) {
        $compiler->template->required_plugins['nocache']['escape']['modifier']['file'] = SMARTY_PLUGINS_DIR .'modifier.escape.php';
        $compiler->template->required_plugins['nocache']['escape']['modifier']['function'] = 'smarty_modifier_escape';
    } else {
        $compiler->template->required_plugins['compiled']['escape']['modifier']['file'] = SMARTY_PLUGINS_DIR .'modifier.escape.php';
        $compiler->template->required_plugins['compiled']['escape']['modifier']['function'] = 'smarty_modifier_escape';
    }
    return 'smarty_modifier_escape(' . join( ', ', $params ) . ')';
}

?><?php
/**
 * Smarty plugin
 *
 * @package Smarty
 * @subpackage PluginsFunction
 */

/**
 * Smarty {fetch} plugin
 *
 * Type:     function<br>
 * Name:     fetch<br>
 * Purpose:  fetch file, web or ftp data and display results
 *
 * @link http://www.smarty.net/manual/en/language.function.fetch.php {fetch}
 *       (Smarty online manual)
 * @author Monte Ohrt <monte at ohrt dot com>
 * @param array                    $params   parameters
 * @param Smarty_Internal_Template $template template object
 * @return string|null if the assign parameter is passed, Smarty assigns the result to a template variable
 */
function smarty_function_fetch($params, $template)
{
    if (empty($params['file'])) {
        trigger_error("[plugin] fetch parameter 'file' cannot be empty",E_USER_NOTICE);
        return;
    }

    $content = '';
    if (isset($template->smarty->security_policy) && !preg_match('!^(http|ftp)://!i', $params['file'])) {
        if(!$template->smarty->security_policy->isTrustedResourceDir($params['file'])) {
            return;
        }

        // fetch the file
        if($fp = @fopen($params['file'],'r')) {
            while(!feof($fp)) {
                $content .= fgets ($fp,4096);
            }
            fclose($fp);
        } else {
            trigger_error('[plugin] fetch cannot read file \'' . $params['file'] . '\'',E_USER_NOTICE);
            return;
        }
    } else {
        // not a local file
        if(preg_match('!^http://!i',$params['file'])) {
            // http fetch
            if($uri_parts = parse_url($params['file'])) {
                // set defaults
                $host = $server_name = $uri_parts['host'];
                $timeout = 30;
                $accept = "image/gif, image/x-xbitmap, image/jpeg, image/pjpeg, */*";
                $agent = "Smarty Template Engine ". Smarty::SMARTY_VERSION;
                $referer = "";
                $uri = !empty($uri_parts['path']) ? $uri_parts['path'] : '/';
                $uri .= !empty($uri_parts['query']) ? '?' . $uri_parts['query'] : '';
                $_is_proxy = false;
                if(empty($uri_parts['port'])) {
                    $port = 80;
                } else {
                    $port = $uri_parts['port'];
                }
                if(!empty($uri_parts['user'])) {
                    $user = $uri_parts['user'];
                }
                if(!empty($uri_parts['pass'])) {
                    $pass = $uri_parts['pass'];
                }
                // loop through parameters, setup headers
                foreach($params as $param_key => $param_value) {
                    switch($param_key) {
                        case "file":
                        case "assign":
                        case "assign_headers":
                            break;
                        case "user":
                            if(!empty($param_value)) {
                                $user = $param_value;
                            }
                            break;
                        case "pass":
                            if(!empty($param_value)) {
                                $pass = $param_value;
                            }
                            break;
                        case "accept":
                            if(!empty($param_value)) {
                                $accept = $param_value;
                            }
                            break;
                        case "header":
                            if(!empty($param_value)) {
                                if(!preg_match('![\w\d-]+: .+!',$param_value)) {
                                    trigger_error("[plugin] invalid header format '".$param_value."'",E_USER_NOTICE);
                                    return;
                                } else {
                                    $extra_headers[] = $param_value;
                                }
                            }
                            break;
                        case "proxy_host":
                            if(!empty($param_value)) {
                                $proxy_host = $param_value;
                            }
                            break;
                        case "proxy_port":
                            if(!preg_match('!\D!', $param_value)) {
                                $proxy_port = (int) $param_value;
                            } else {
                                trigger_error("[plugin] invalid value for attribute '".$param_key."'",E_USER_NOTICE);
                                return;
                            }
                            break;
                        case "agent":
                            if(!empty($param_value)) {
                                $agent = $param_value;
                            }
                            break;
                        case "referer":
                            if(!empty($param_value)) {
                                $referer = $param_value;
                            }
                            break;
                        case "timeout":
                            if(!preg_match('!\D!', $param_value)) {
                                $timeout = (int) $param_value;
                            } else {
                                trigger_error("[plugin] invalid value for attribute '".$param_key."'",E_USER_NOTICE);
                                return;
                            }
                            break;
                        default:
                            trigger_error("[plugin] unrecognized attribute '".$param_key."'",E_USER_NOTICE);
                            return;
                    }
                }
                if(!empty($proxy_host) && !empty($proxy_port)) {
                    $_is_proxy = true;
                    $fp = fsockopen($proxy_host,$proxy_port,$errno,$errstr,$timeout);
                } else {
                    $fp = fsockopen($server_name,$port,$errno,$errstr,$timeout);
                }

                if(!$fp) {
                    trigger_error("[plugin] unable to fetch: $errstr ($errno)",E_USER_NOTICE);
                    return;
                } else {
                    if($_is_proxy) {
                        fputs($fp, 'GET ' . $params['file'] . " HTTP/1.0\r\n");
                    } else {
                        fputs($fp, "GET $uri HTTP/1.0\r\n");
                    }
                    if(!empty($host)) {
                        fputs($fp, "Host: $host\r\n");
                    }
                    if(!empty($accept)) {
                        fputs($fp, "Accept: $accept\r\n");
                    }
                    if(!empty($agent)) {
                        fputs($fp, "User-Agent: $agent\r\n");
                    }
                    if(!empty($referer)) {
                        fputs($fp, "Referer: $referer\r\n");
                    }
                    if(isset($extra_headers) && is_array($extra_headers)) {
                        foreach($extra_headers as $curr_header) {
                            fputs($fp, $curr_header."\r\n");
                        }
                    }
                    if(!empty($user) && !empty($pass)) {
                        fputs($fp, "Authorization: BASIC ".base64_encode("$user:$pass")."\r\n");
                    }

                    fputs($fp, "\r\n");
                    while(!feof($fp)) {
                        $content .= fgets($fp,4096);
                    }
                    fclose($fp);
                    $csplit = preg_split("!\r\n\r\n!",$content,2);

                    $content = $csplit[1];

                    if(!empty($params['assign_headers'])) {
                        $template->assign($params['assign_headers'],preg_split("!\r\n!",$csplit[0]));
                    }
                }
            } else {
                trigger_error("[plugin fetch] unable to parse URL, check syntax",E_USER_NOTICE);
                return;
            }
        } else {
            // ftp fetch
            if($fp = @fopen($params['file'],'r')) {
                while(!feof($fp)) {
                    $content .= fgets ($fp,4096);
                }
                fclose($fp);
            } else {
                trigger_error('[plugin] fetch cannot read file \'' . $params['file'] .'\'',E_USER_NOTICE);
                return;
            }
        }

    }


    if (!empty($params['assign'])) {
        $template->assign($params['assign'],$content);
    } else {
        return $content;
    }
}

?><?php
/**
 * Smarty plugin
 *
 * @package Smarty
 * @subpackage PluginsFunction
 */

/**
 * Smarty {html_checkboxes} function plugin
 *
 * File:       function.html_checkboxes.php<br>
 * Type:       function<br>
 * Name:       html_checkboxes<br>
 * Date:       24.Feb.2003<br>
 * Purpose:    Prints out a list of checkbox input types<br>
 * Examples:
 * <pre>
 * {html_checkboxes values=$ids output=$names}
 * {html_checkboxes values=$ids name='box' separator='<br>' output=$names}
 * {html_checkboxes values=$ids checked=$checked separator='<br>' output=$names}
 * </pre>
 * Params:
 * <pre>
 * - name       (optional) - string default "checkbox"
 * - values     (required) - array
 * - options    (optional) - associative array
 * - checked    (optional) - array default not set
 * - separator  (optional) - ie <br> or &nbsp;
 * - output     (optional) - the output next to each checkbox
 * - assign     (optional) - assign the output as an array to this variable
 * </pre>
 *
 * @link http://www.smarty.net/manual/en/language.function.html.checkboxes.php {html_checkboxes}
 *      (Smarty online manual)
 * @author     Christopher Kvarme <christopher.kvarme@flashjab.com>
 * @author credits to Monte Ohrt <monte at ohrt dot com>
 * @version    1.0
 * @param array $params parameters
 * @param object $template template object
 * @return string
 * @uses smarty_function_escape_special_chars()
 */
function smarty_function_html_checkboxes($params, $template)
{
    require_once(SMARTY_PLUGINS_DIR . 'shared.escape_special_chars.php');

    $name = 'checkbox';
    $values = null;
    $options = null;
    $selected = array();
    $separator = '';
    $labels = true;
    $label_ids = false;
    $output = null;

    $extra = '';

    foreach($params as $_key => $_val) {
        switch($_key) {
            case 'name':
            case 'separator':
                $$_key = (string) $_val;
                break;

            case 'labels':
            case 'label_ids':
                $$_key = (bool) $_val;
                break;

            case 'options':
                $$_key = (array) $_val;
                break;

            case 'values':
            case 'output':
                $$_key = array_values((array) $_val);
                break;

            case 'checked':
            case 'selected':
                if (is_array($_val)) {
                    $selected = array();
                    foreach ($_val as $_sel) {
                        if (is_object($_sel)) {
                            if (method_exists($_sel, "__toString")) {
                                $_sel = smarty_function_escape_special_chars((string) $_sel->__toString());
                            } else {
                                trigger_error("html_checkboxes: selected attribute contains an object of class '". get_class($_sel) ."' without __toString() method", E_USER_NOTICE);
                                continue;
                            }
                        } else {
                            $_sel = smarty_function_escape_special_chars((string) $_sel);
                        }
                        $selected[$_sel] = true;
                    }
                } elseif (is_object($_val)) {
                    if (method_exists($_val, "__toString")) {
                        $selected = smarty_function_escape_special_chars((string) $_val->__toString());
                    } else {
                        trigger_error("html_checkboxes: selected attribute is an object of class '". get_class($_val) ."' without __toString() method", E_USER_NOTICE);
                    }
                } else {
                    $selected = smarty_function_escape_special_chars((string) $_val);
                }
                break;

            case 'checkboxes':
                trigger_error('html_checkboxes: the use of the "checkboxes" attribute is deprecated, use "options" instead', E_USER_WARNING);
                $options = (array) $_val;
                break;

            case 'assign':
                break;

            default:
                if(!is_array($_val)) {
                    $extra .= ' '.$_key.'="'.smarty_function_escape_special_chars($_val).'"';
                } else {
                    trigger_error("html_checkboxes: extra attribute '$_key' cannot be an array", E_USER_NOTICE);
                }
                break;
        }
    }

    if (!isset($options) && !isset($values))
        return ''; /* raise error here? */

    $_html_result = array();

    if (isset($options)) {
        foreach ($options as $_key=>$_val) {
            $_html_result[] = smarty_function_html_checkboxes_output($name, $_key, $_val, $selected, $extra, $separator, $labels, $label_ids);
        }
    } else {
        foreach ($values as $_i=>$_key) {
            $_val = isset($output[$_i]) ? $output[$_i] : '';
            $_html_result[] = smarty_function_html_checkboxes_output($name, $_key, $_val, $selected, $extra, $separator, $labels, $label_ids);
        }
    }

    if(!empty($params['assign'])) {
        $template->assign($params['assign'], $_html_result);
    } else {
        return implode("\n", $_html_result);
    }

}

function smarty_function_html_checkboxes_output($name, $value, $output, $selected, $extra, $separator, $labels, $label_ids) {
    $_output = '';
    
    if (is_object($value)) {
        if (method_exists($value, "__toString")) {
            $value = (string) $value->__toString();
        } else {
            trigger_error("html_options: value is an object of class '". get_class($value) ."' without __toString() method", E_USER_NOTICE);
            return '';
        }
    } else {
        $value = (string) $value;
    }
    
    if (is_object($output)) {
        if (method_exists($output, "__toString")) {
            $output = (string) $output->__toString();
        } else {
            trigger_error("html_options: output is an object of class '". get_class($output) ."' without __toString() method", E_USER_NOTICE);
            return '';
        }
    } else {
        $output = (string) $output;
    }
    
    if ($labels) {
        if ($label_ids) {
            $_id = smarty_function_escape_special_chars(preg_replace('![^\w\-\.]!u', '_', $name . '_' . $value));
            $_output .= '<label for="' . $_id . '">';
        } else {
            $_output .= '<label>';
        } 
    }
    
    $name = smarty_function_escape_special_chars($name);
    $value = smarty_function_escape_special_chars($value);
    $output = smarty_function_escape_special_chars($output);
    
    $_output .= '<input type="checkbox" name="' . $name . '[]" value="' . $value . '"';
    
    if ($labels && $label_ids) {
        $_output .= ' id="' . $_id . '"';
    }
    
    if (is_array($selected)) {
        if (isset($selected[$value])) {
            $_output .= ' checked="checked"';
        }
    } elseif ($value === $selected) {
        $_output .= ' checked="checked"';
    }
    
    $_output .= $extra . ' />' . $output;
    if ($labels) {
        $_output .= '</label>';
    }
    
    $_output .=  $separator;
    return $_output;
}

?><?php
/**
 * Smarty plugin
 * 
 * @package Smarty
 * @subpackage PluginsModifier
 */

/**
 * Smarty capitalize modifier plugin
 * 
 * Type:     modifier<br>
 * Name:     capitalize<br>
 * Purpose:  capitalize words in the string
 *
 * {@internal {$string|capitalize:true:true} is the fastest option for MBString enabled systems }}
 *
 * @param string  $string    string to capitalize
 * @param boolean $uc_digits also capitalize "x123" to "X123"
 * @param boolean $lc_rest   capitalize first letters, lowercase all following letters "aAa" to "Aaa"
 * @return string capitalized string
 * @author Monte Ohrt <monte at ohrt dot com> 
 * @author Rodney Rehm
 */
function smarty_modifier_capitalize($string, $uc_digits = false, $lc_rest = false)
{
    if (SMARTY_MBSTRING /* ^phpunit */&&empty($_SERVER['SMARTY_PHPUNIT_DISABLE_MBSTRING'])/* phpunit$ */) {
        if ($lc_rest) {
            // uppercase (including hyphenated words)
            $upper_string = mb_convert_case( $string, MB_CASE_TITLE, SMARTY_RESOURCE_CHAR_SET );
        } else {
            // uppercase word breaks
            $upper_string = preg_replace("!(^|[^\p{L}'])([\p{Ll}])!ueS", "stripslashes('\\1').mb_convert_case(stripslashes('\\2'),MB_CASE_UPPER, SMARTY_RESOURCE_CHAR_SET)", $string);
        }
        // check uc_digits case
        if (!$uc_digits) {
            if (preg_match_all("!\b([\p{L}]*[\p{N}]+[\p{L}]*)\b!u", $string, $matches, PREG_OFFSET_CAPTURE)) {
                foreach($matches[1] as $match) {
                    $upper_string = substr_replace($upper_string, mb_strtolower($match[0], SMARTY_RESOURCE_CHAR_SET), $match[1], strlen($match[0]));
                }
            } 
        }
        $upper_string = preg_replace("!((^|\s)['\"])(\w)!ue", "stripslashes('\\1').mb_convert_case(stripslashes('\\3'),MB_CASE_UPPER, SMARTY_RESOURCE_CHAR_SET)", $upper_string);
        return $upper_string;
    }
    
    // lowercase first
    if ($lc_rest) {
        $string = strtolower($string);
    }
    // uppercase (including hyphenated words)
    $upper_string = preg_replace("!(^|[^\p{L}'])([\p{Ll}])!ueS", "stripslashes('\\1').ucfirst(stripslashes('\\2'))", $string); 
    // check uc_digits case
    if (!$uc_digits) {
        if (preg_match_all("!\b([\p{L}]*[\p{N}]+[\p{L}]*)\b!u", $string, $matches, PREG_OFFSET_CAPTURE)) {
            foreach($matches[1] as $match) {
                $upper_string = substr_replace($upper_string, strtolower($match[0]), $match[1], strlen($match[0]));
            }
        } 
    }
    $upper_string = preg_replace("!((^|\s)['\"])(\w)!ue", "stripslashes('\\1').strtoupper(stripslashes('\\3'))", $upper_string);
    return $upper_string;
} 

?><?php
/**
 * Smarty plugin
 * @package Smarty
 * @subpackage PluginsModifier
 */

/**
 * Smarty spacify modifier plugin
 * 
 * Type:     modifier<br>
 * Name:     spacify<br>
 * Purpose:  add spaces between characters in a string
 * 
 * @link http://smarty.php.net/manual/en/language.modifier.spacify.php spacify (Smarty online manual)
 * @author Monte Ohrt <monte at ohrt dot com> 
 * @param string $string       input string
 * @param string $spacify_char string to insert between characters.
 * @return string
 */
function smarty_modifier_spacify($string, $spacify_char = ' ')
{
    // well… what about charsets besides latin and UTF-8?
    return implode($spacify_char, preg_split('//u', $string, -1, PREG_SPLIT_NO_EMPTY));
} 

?><?php
/**
 * Smarty plugin
 * 
 * @package Smarty
 * @subpackage PluginsFunction
 */

/**
 * @ignore
 */
require_once(SMARTY_PLUGINS_DIR . 'shared.escape_special_chars.php');
/**
 * @ignore
 */
require_once(SMARTY_PLUGINS_DIR . 'shared.make_timestamp.php');

/**
 * Smarty {html_select_date} plugin
 * 
 * Type:     function<br>
 * Name:     html_select_date<br>
 * Purpose:  Prints the dropdowns for date selection.
 * 
 * ChangeLog:
 * <pre>
 *            - 1.0 initial release
 *            - 1.1 added support for +/- N syntax for begin
 *              and end year values. (Monte)
 *            - 1.2 added support for yyyy-mm-dd syntax for
 *              time value. (Jan Rosier)
 *            - 1.3 added support for choosing format for
 *              month values (Gary Loescher)
 *            - 1.3.1 added support for choosing format for
 *              day values (Marcus Bointon)
 *            - 1.3.2 support negative timestamps, force year
 *              dropdown to include given date unless explicitly set (Monte)
 *            - 1.3.4 fix behaviour of 0000-00-00 00:00:00 dates to match that
 *              of 0000-00-00 dates (cybot, boots)
 *            - 2.0 complete rewrite for performance,  
 *              added attributes month_names, *_id
 * </pre>
 * 
 * @link http://www.smarty.net/manual/en/language.function.html.select.date.php {html_select_date}
 *      (Smarty online manual)
 * @version 2.0
 * @author Andrei Zmievski 
 * @author Monte Ohrt <monte at ohrt dot com> 
 * @author Rodney Rehm
 * @param array                    $params   parameters
 * @param Smarty_Internal_Template $template template object
 * @return string 
 */
function smarty_function_html_select_date($params, $template)
{
    // generate timestamps used for month names only
    static $_month_timestamps = null;
    static $_current_year = null;
    if ($_month_timestamps === null) {
        $_current_year = date('Y');
        $_month_timestamps = array();
        for ($i = 1; $i <= 12; $i++) {
            $_month_timestamps[$i] = mktime(0, 0, 0, $i, 1, 2000);
        }
    }

    /* Default values. */
    $prefix = "Date_";
    $start_year = null;
    $end_year = null;
    $display_days = true;
    $display_months = true;
    $display_years = true;
    $month_format = "%B";
    /* Write months as numbers by default  GL */
    $month_value_format = "%m";
    $day_format = "%02d";
    /* Write day values using this format MB */
    $day_value_format = "%d";
    $year_as_text = false;
    /* Display years in reverse order? Ie. 2000,1999,.... */
    $reverse_years = false;
    /* Should the select boxes be part of an array when returned from PHP?
       e.g. setting it to "birthday", would create "birthday[Day]",
       "birthday[Month]" & "birthday[Year]". Can be combined with prefix */
    $field_array = null;
    /* <select size>'s of the different <select> tags.
       If not set, uses default dropdown. */
    $day_size = null;
    $month_size = null;
    $year_size = null;
    /* Unparsed attributes common to *ALL* the <select>/<input> tags.
       An example might be in the template: all_extra ='class ="foo"'. */
    $all_extra = null;
    /* Separate attributes for the tags. */
    $day_extra = null;
    $month_extra = null;
    $year_extra = null;
    /* Order in which to display the fields.
       "D" -> day, "M" -> month, "Y" -> year. */
    $field_order = 'MDY';
    /* String printed between the different fields. */
    $field_separator = "\n";
    $option_separator = "\n";
    $time = null;
    // $all_empty = null;
    // $day_empty = null;
    // $month_empty = null;
    // $year_empty = null;
    $extra_attrs = '';
    $all_id = null;
    $day_id = null;
    $month_id = null;
    $year_id = null;

    foreach ($params as $_key => $_value) {
        switch ($_key) {
            case 'time':
                if (!is_array($_value)) {
                    $time = smarty_make_timestamp($_value);
                }
                break;
                
            case 'month_names':
                if (is_array($_value) && count($_value) == 12) {
                    $$_key = $_value;
                } else {
                    trigger_error("html_select_date: month_names must be an array of 12 strings", E_USER_NOTICE);
                }
                break;
                
            case 'prefix':
            case 'field_array':
            case 'start_year':
            case 'end_year':
            case 'day_format':
            case 'day_value_format':
            case 'month_format':
            case 'month_value_format':
            case 'day_size':
            case 'month_size':
            case 'year_size':
            case 'all_extra':
            case 'day_extra':
            case 'month_extra':
            case 'year_extra':
            case 'field_order':
            case 'field_separator':
            case 'option_separator':
            case 'all_empty':
            case 'month_empty':
            case 'day_empty':
            case 'year_empty':
            case 'all_id':
            case 'month_id':
            case 'day_id':
            case 'year_id':
                $$_key = (string)$_value;
                break;

            case 'display_days':
            case 'display_months':
            case 'display_years':
            case 'year_as_text':
            case 'reverse_years':
                $$_key = (bool)$_value;
                break;

            default:
                if (!is_array($_value)) {
                    $extra_attrs .= ' ' . $_key . '="' . smarty_function_escape_special_chars($_value) . '"';
                } else {
                    trigger_error("html_select_date: extra attribute '$_key' cannot be an array", E_USER_NOTICE);
                } 
                break;
        } 
    }
    
    // Note: date() is faster than strftime()
    // Note: explode(date()) is faster than date() date() date()
    if (isset($params['time']) && is_array($params['time'])) {
        if (isset($params['time'][$prefix . 'Year'])) {
            // $_REQUEST[$field_array] given
            foreach (array('Y' => 'Year',  'm' => 'Month', 'd' => 'Day') as $_elementKey => $_elementName) {
                $_variableName = '_' . strtolower($_elementName);
                $$_variableName = isset($params['time'][$prefix . $_elementName])
                    ? $params['time'][$prefix . $_elementName]
                    : date($_elementKey);
            }
            $time = mktime(0, 0, 0, $_month, $_day, $_year);
        } elseif (isset($params['time'][$field_array][$prefix . 'Year'])) {
            // $_REQUEST given
            foreach (array('Y' => 'Year',  'm' => 'Month', 'd' => 'Day') as $_elementKey => $_elementName) {
                $_variableName = '_' . strtolower($_elementName);
                $$_variableName = isset($params['time'][$field_array][$prefix . $_elementName])
                    ? $params['time'][$field_array][$prefix . $_elementName]
                    : date($_elementKey);
            }
            $time = mktime(0, 0, 0, $_month, $_day, $_year);
        } else {
            // no date found, use NOW
            list($_year, $_month, $_day) = $time = explode('-', date('Y-m-d'));
        }
    } elseif ($time === null) {
        list($_year, $_month, $_day) = $time = explode('-', date('Y-m-d'));
    } else {
        list($_year, $_month, $_day) = $time = explode('-', date('Y-m-d', $time));
    }

    // make syntax "+N" or "-N" work with $start_year and $end_year
    // Note preg_match('!^(\+|\-)\s*(\d+)$!', $end_year, $match) is slower than trim+substr
    foreach (array('start', 'end') as $key) {
        $key .= '_year';
        $t = $$key;
        if ($t === null) {
            $$key = (int)$_current_year;
        } else if ($t[0] == '+') {
            $$key = (int)($_current_year + trim(substr($t, 1)));
        } else if ($t[0] == '-') {
            $$key = (int)($_current_year - trim(substr($t, 1)));
        } else {
            $$key = (int)$$key;
        }
    }

    // flip for ascending or descending
    if (($start_year > $end_year && !$reverse_years) || ($start_year < $end_year && $reverse_years)) {
        $t = $end_year;
        $end_year = $start_year;
        $start_year = $t;
    }

    // generate year <select> or <input>
    if ($display_years) {
        $_html_years = '';
        $_extra = '';
        $_name = $field_array ? ($field_array . '[' . $prefix . 'Year]') : ($prefix . 'Year');
        if ($all_extra) {
            $_extra .= ' ' . $all_extra;
        } 
        if ($year_extra) {
            $_extra .= ' ' . $year_extra;
        }
        
        if ($year_as_text) {
            $_html_years = '<input type="text" name="' . $_name . '" value="' . $_year . '" size="4" maxlength="4"' . $_extra . $extra_attrs . ' />';
        } else {
            $_html_years = '<select name="' . $_name . '"';
            if ($year_id !== null || $all_id !== null) {
                $_html_years .= ' id="' . smarty_function_escape_special_chars( 
                    $year_id !== null ? ( $year_id ? $year_id : $_name ) : ( $all_id ? ($all_id . $_name) : $_name ) 
                ) . '"';
            }
            if ($year_size) {
                $_html_years .= ' size="' . $year_size . '"';
            } 
            $_html_years .= $_extra . $extra_attrs . '>' . $option_separator;
            
            if (isset($year_empty) || isset($all_empty)) {
                $_html_years .= '<option value="">' . ( isset($year_empty) ? $year_empty : $all_empty ) . '</option>' . $option_separator;
            }
            
            $op = $start_year > $end_year ? -1 : 1;
            for ($i=$start_year; $op > 0 ? $i <= $end_year : $i >= $end_year; $i += $op) {
                $_html_years .= '<option value="' . $i . '"'
                    . ($_year == $i ? ' selected="selected"' : '')
                    . '>' . $i . '</option>' . $option_separator;
            }
            
            $_html_years .= '</select>';
        }
    }
    
    // generate month <select> or <input>
    if ($display_months) {
        $_html_month = '';
        $_extra = '';
        $_name = $field_array ? ($field_array . '[' . $prefix . 'Month]') : ($prefix . 'Month');
        if ($all_extra) {
            $_extra .= ' ' . $all_extra;
        } 
        if ($month_extra) {
            $_extra .= ' ' . $month_extra;
        }
        
        $_html_months = '<select name="' . $_name . '"';
        if ($month_id !== null || $all_id !== null) {
            $_html_months .= ' id="' . smarty_function_escape_special_chars( 
                $month_id !== null ? ( $month_id ? $month_id : $_name ) : ( $all_id ? ($all_id . $_name) : $_name ) 
            ) . '"';
        }
        if ($month_size) {
            $_html_months .= ' size="' . $month_size . '"';
        } 
        $_html_months .= $_extra . $extra_attrs . '>' . $option_separator;
        
        if (isset($month_empty) || isset($all_empty)) {
            $_html_months .= '<option value="">' . ( isset($month_empty) ? $month_empty : $all_empty ) . '</option>' . $option_separator;
        }
        
        for ($i = 1; $i <= 12; $i++) {
            $_val = sprintf('%02d', $i);
            $_text = isset($month_names) ? smarty_function_escape_special_chars($month_names[$i]) : ($month_format == "%m" ? $_val : strftime($month_format, $_month_timestamps[$i]));
            $_value = $month_value_format == "%m" ? $_val : strftime($month_value_format, $_month_timestamps[$i]);
            $_html_months .= '<option value="' . $_value . '"'
                . ($_val == $_month ? ' selected="selected"' : '')
                . '>' . $_text . '</option>' . $option_separator;
        }
        
        $_html_months .= '</select>';
    }
    
    // generate day <select> or <input>
    if ($display_days) {
        $_html_day = '';
        $_extra = '';
        $_name = $field_array ? ($field_array . '[' . $prefix . 'Day]') : ($prefix . 'Day');
        if ($all_extra) {
            $_extra .= ' ' . $all_extra;
        } 
        if ($day_extra) {
            $_extra .= ' ' . $day_extra;
        }
        
        $_html_days = '<select name="' . $_name . '"';
        if ($day_id !== null || $all_id !== null) {
            $_html_days .= ' id="' . smarty_function_escape_special_chars( 
                $day_id !== null ? ( $day_id ? $day_id : $_name ) : ( $all_id ? ($all_id . $_name) : $_name ) 
            ) . '"';
        }
        if ($day_size) {
            $_html_days .= ' size="' . $day_size . '"';
        } 
        $_html_days .= $_extra . $extra_attrs . '>' . $option_separator;
        
        if (isset($day_empty) || isset($all_empty)) {
            $_html_days .= '<option value="">' . ( isset($day_empty) ? $day_empty : $all_empty ) . '</option>' . $option_separator;
        }
        
        for ($i = 1; $i <= 31; $i++) {
            $_val = sprintf('%02d', $i);
            $_text = $day_format == '%02d' ? $_val : sprintf($day_format, $i);
            $_value = $day_value_format ==  '%02d' ? $_val : sprintf($day_value_format, $i);
            $_html_days .= '<option value="' . $_value . '"'
                . ($_val == $_day ? ' selected="selected"' : '')
                . '>' . $_text . '</option>' . $option_separator;
        }
        
        $_html_days .= '</select>';
    }

    // order the fields for output
    $_html = '';
    for ($i=0; $i <= 2; $i++) {
        switch ($field_order[$i]) {
            case 'Y':
            case 'y':
                if (isset($_html_years)) {
                    if ($_html) {
                        $_html .= $field_separator;
                    }
                    $_html .= $_html_years;
                }
            break;
            
            case 'm':
            case 'M':
                if (isset($_html_months)) {
                    if ($_html) {
                        $_html .= $field_separator;
                    }
                    $_html .= $_html_months;
                }
            break;
            
            case 'd':
            case 'D':
                if (isset($_html_days)) {
                    if ($_html) {
                        $_html .= $field_separator;
                    }
                    $_html .= $_html_days;
                }
            break;
        }
    }
    return $_html;
}

?><?php
/**
 * Smarty plugin
 *
 * @package Smarty
 * @subpackage PluginsModifierCompiler
 */

/**
 * Smarty cat modifier plugin
 *
 * Type:     modifier<br>
 * Name:     cat<br>
 * Date:     Feb 24, 2003<br>
 * Purpose:  catenate a value to a variable<br>
 * Input:    string to catenate<br>
 * Example:  {$var|cat:"foo"}
 *
 * @link http://smarty.php.net/manual/en/language.modifier.cat.php cat
 *          (Smarty online manual)
 * @author   Uwe Tews
 * @param array $params parameters
 * @return string with compiled code
 */
function smarty_modifiercompiler_cat($params, $compiler)
{
    return '('.implode(').(', $params).')';
}

?><?php
/**
 * Smarty plugin
 *
 * @package Smarty
 * @subpackage PluginsModifierCompiler
 */

/**
 * Smarty string_format modifier plugin
 *
 * Type:     modifier<br>
 * Name:     string_format<br>
 * Purpose:  format strings via sprintf
 *
 * @link http://www.smarty.net/manual/en/language.modifier.string.format.php string_format (Smarty online manual)
 * @author Uwe Tews
 * @param array $params parameters
 * @return string with compiled code
 */
function smarty_modifiercompiler_string_format($params, $compiler)
{
    return 'sprintf(' . $params[1] . ',' . $params[0] . ')';
}

?><?php
/**
 * Smarty shared plugin
 *
 * @package Smarty
 * @subpackage PluginsShared
 */

if (version_compare(PHP_VERSION, '5.2.3', '>=')) {
    /**
     * escape_special_chars common function
     *
     * Function: smarty_function_escape_special_chars<br>
     * Purpose:  used by other smarty functions to escape
     *           special chars except for already escaped ones
     *
     * @author   Monte Ohrt <monte at ohrt dot com>
     * @param string $string text that should by escaped
     * @return string
     */
    function smarty_function_escape_special_chars($string)
    {
        if (!is_array($string)) {
            $string = htmlspecialchars($string, ENT_COMPAT, SMARTY_RESOURCE_CHAR_SET, false);
        }
        return $string;
    }  
} else {         
    /**
     * escape_special_chars common function
     *
     * Function: smarty_function_escape_special_chars<br>
     * Purpose:  used by other smarty functions to escape
     *           special chars except for already escaped ones
     *
     * @author   Monte Ohrt <monte at ohrt dot com>
     * @param string $string text that should by escaped
     * @return string
     */
    function smarty_function_escape_special_chars($string)
    {
        if (!is_array($string)) {
            $string = preg_replace('!&(#?\w+);!', '%%%SMARTY_START%%%\\1%%%SMARTY_END%%%', $string);
            $string = htmlspecialchars($string);
            $string = str_replace(array('%%%SMARTY_START%%%', '%%%SMARTY_END%%%'), array('&', ';'), $string); 
        }
        return $string;
    }                                                                                                             
} 

?><?php
/**
 * Smarty plugin
 * 
 * @package Smarty
 * @subpackage PluginsFunction
 */

/**
 * Smarty {html_radios} function plugin
 * 
 * File:       function.html_radios.php<br>
 * Type:       function<br>
 * Name:       html_radios<br>
 * Date:       24.Feb.2003<br>
 * Purpose:    Prints out a list of radio input types<br>
 * Params:
 * <pre>
 * - name       (optional) - string default "radio"
 * - values     (required) - array
 * - options    (required) - associative array
 * - checked    (optional) - array default not set
 * - separator  (optional) - ie <br> or &nbsp;
 * - output     (optional) - the output next to each radio button
 * - assign     (optional) - assign the output as an array to this variable
 * </pre>
 * Examples:
 * <pre>
 * {html_radios values=$ids output=$names}
 * {html_radios values=$ids name='box' separator='<br>' output=$names}
 * {html_radios values=$ids checked=$checked separator='<br>' output=$names}
 * </pre>
 * 
 * @link http://smarty.php.net/manual/en/language.function.html.radios.php {html_radios}
 *      (Smarty online manual)
 * @author Christopher Kvarme <christopher.kvarme@flashjab.com> 
 * @author credits to Monte Ohrt <monte at ohrt dot com> 
 * @version 1.0
 * @param array                    $params   parameters
 * @param Smarty_Internal_Template $template template object
 * @return string 
 * @uses smarty_function_escape_special_chars()
 */
function smarty_function_html_radios($params, $template)
{
    require_once(SMARTY_PLUGINS_DIR . 'shared.escape_special_chars.php');

    $name = 'radio';
    $values = null;
    $options = null;
    $selected = null;
    $separator = '';
    $labels = true;
    $label_ids = false;
    $output = null;
    $extra = '';

    foreach($params as $_key => $_val) {
        switch ($_key) {
            case 'name':
            case 'separator':
                $$_key = (string) $_val;
                break;

            case 'checked':
            case 'selected':
                if (is_array($_val)) {
                    trigger_error('html_radios: the "' . $_key . '" attribute cannot be an array', E_USER_WARNING);
                } elseif (is_object($_val)) {
                    if (method_exists($_val, "__toString")) {
                        $selected = smarty_function_escape_special_chars((string) $_val->__toString());
                    } else {
                        trigger_error("html_radios: selected attribute is an object of class '". get_class($_val) ."' without __toString() method", E_USER_NOTICE);
                    }
                } else {
                    $selected = (string) $_val;
                } 
                break;

            case 'labels':
            case 'label_ids':
                $$_key = (bool) $_val;
                break;

            case 'options':
                $$_key = (array) $_val;
                break;

            case 'values':
            case 'output':
                $$_key = array_values((array) $_val);
                break;

            case 'radios':
                trigger_error('html_radios: the use of the "radios" attribute is deprecated, use "options" instead', E_USER_WARNING);
                $options = (array) $_val;
                break;

            case 'assign':
                break;

            default:
                if (!is_array($_val)) {
                    $extra .= ' ' . $_key . '="' . smarty_function_escape_special_chars($_val) . '"';
                } else {
                    trigger_error("html_radios: extra attribute '$_key' cannot be an array", E_USER_NOTICE);
                } 
                break;
        } 
    } 

    if (!isset($options) && !isset($values)) {
        /* raise error here? */
        return '';
    }

    $_html_result = array();

    if (isset($options)) {
        foreach ($options as $_key => $_val) {
            $_html_result[] = smarty_function_html_radios_output($name, $_key, $_val, $selected, $extra, $separator, $labels, $label_ids);
        }
    } else {
        foreach ($values as $_i => $_key) {
            $_val = isset($output[$_i]) ? $output[$_i] : '';
            $_html_result[] = smarty_function_html_radios_output($name, $_key, $_val, $selected, $extra, $separator, $labels, $label_ids);
        } 
    } 

    if (!empty($params['assign'])) {
        $template->assign($params['assign'], $_html_result);
    } else {
        return implode("\n", $_html_result);
    } 
} 

function smarty_function_html_radios_output($name, $value, $output, $selected, $extra, $separator, $labels, $label_ids)
{
    $_output = '';
    
    if (is_object($value)) {
        if (method_exists($value, "__toString")) {
            $value = (string) $value->__toString();
        } else {
            trigger_error("html_options: value is an object of class '". get_class($value) ."' without __toString() method", E_USER_NOTICE);
            return '';
        }
    } else {
        $value = (string) $value;
    }
    
    if (is_object($output)) {
        if (method_exists($output, "__toString")) {
            $output = (string) $output->__toString();
        } else {
            trigger_error("html_options: output is an object of class '". get_class($output) ."' without __toString() method", E_USER_NOTICE);
            return '';
        }
    } else {
        $output = (string) $output;
    }
    
    if ($labels) {
        if ($label_ids) {
            $_id = smarty_function_escape_special_chars(preg_replace('![^\w\-\.]!u', '_', $name . '_' . $value));
            $_output .= '<label for="' . $_id . '">';
        } else {
            $_output .= '<label>';
        } 
    }
    
    $name = smarty_function_escape_special_chars($name);
    $value = smarty_function_escape_special_chars($value);
    $output = smarty_function_escape_special_chars($output);
    
    $_output .= '<input type="radio" name="' . $name . '" value="' . $value . '"';

    if ($labels && $label_ids) {
        $_output .= ' id="' . $_id . '"';
    }

    if ($value === $selected) {
        $_output .= ' checked="checked"';
    }
    
    $_output .= $extra . ' />' . $output;
    if ($labels) {
        $_output .= '</label>';
    }
    
    $_output .= $separator;
    return $_output;
} 

?><?php
/**
 * Smarty shared plugin
 *
 * @package Smarty
 * @subpackage PluginsShared
 */

/**
 * convert characters to their decimal unicode equivalents
 *
 * @link http://www.ibm.com/developerworks/library/os-php-unicode/index.html#listing3 for inspiration
 * @param string $string   characters to calculate unicode of
 * @param string $encoding encoding of $string, if null mb_internal_encoding() is used
 * @return array sequence of unicodes
 * @author Rodney Rehm
 */
function smarty_mb_to_unicode($string, $encoding=null) {
    if ($encoding) {
        $expanded = mb_convert_encoding($string, "UTF-32BE", $encoding);
    } else {
        $expanded = mb_convert_encoding($string, "UTF-32BE");
    }
    return unpack("N*", $expanded);
}

/**
 * convert unicodes to the character of given encoding
 *
 * @link http://www.ibm.com/developerworks/library/os-php-unicode/index.html#listing3 for inspiration
 * @param integer|array $unicode  single unicode or list of unicodes to convert
 * @param string        $encoding encoding of returned string, if null mb_internal_encoding() is used
 * @return string unicode as character sequence in given $encoding
 * @author Rodney Rehm
 */
function smarty_mb_from_unicode($unicode, $encoding=null) {
    $t = '';
    if (!$encoding) {
        $encoding = mb_internal_encoding();
    }
    foreach((array) $unicode as $utf32be) {
        $character = pack("N", $utf32be);
        $t .= mb_convert_encoding($character, $encoding, "UTF-32BE");
    }
    return $t;
}

?><?php
/**
 * Smarty plugin
 *
 * @package Smarty
 * @subpackage PluginsModifier
 */

/**
 * Smarty escape modifier plugin
 *
 * Type:     modifier<br>
 * Name:     escape<br>
 * Purpose:  escape string for output
 *
 * @link http://www.smarty.net/manual/en/language.modifier.count.characters.php count_characters (Smarty online manual)
 * @author Monte Ohrt <monte at ohrt dot com>
 * @param string  $string        input string
 * @param string  $esc_type      escape type
 * @param string  $char_set      character set, used for htmlspecialchars() or htmlentities()
 * @param boolean $double_encode encode already encoded entitites again, used for htmlspecialchars() or htmlentities()
 * @return string escaped input string
 */
function smarty_modifier_escape($string, $esc_type = 'html', $char_set = null, $double_encode = true)
{
    if (!$char_set) {
        $char_set = SMARTY_RESOURCE_CHAR_SET;
    }

    switch ($esc_type) {
        case 'html':
            return htmlspecialchars($string, ENT_QUOTES, $char_set, $double_encode);

        case 'htmlall':
            if (SMARTY_MBSTRING /* ^phpunit */ && empty($_SERVER['SMARTY_PHPUNIT_DISABLE_MBSTRING'])/* phpunit$ */) {
                // mb_convert_encoding ignores htmlspecialchars()
                $string = htmlspecialchars($string, ENT_QUOTES, $char_set, $double_encode);
                // htmlentities() won't convert everything, so use mb_convert_encoding
                return mb_convert_encoding($string, 'HTML-ENTITIES', $char_set);
            }

            // no MBString fallback
            return htmlentities($string, ENT_QUOTES, $char_set, $double_encode);

        case 'url':
            return rawurlencode($string);

        case 'urlpathinfo':
            return str_replace('%2F', '/', rawurlencode($string));

        case 'quotes':
            // escape unescaped single quotes
            return preg_replace("%(?<!\\\\)'%", "\\'", $string);

        case 'hex':
            // escape every byte into hex
            // Note that the UTF-8 encoded character ä will be represented as %c3%a4
            $return = '';
            $_length = strlen($string);
            for ($x = 0; $x < $_length; $x++) {
                $return .= '%' . bin2hex($string[$x]);
            }
            return $return;

        case 'hexentity':
            $return = '';
            if (SMARTY_MBSTRING /* ^phpunit */ && empty($_SERVER['SMARTY_PHPUNIT_DISABLE_MBSTRING'])/* phpunit$ */) {
                require_once(SMARTY_PLUGINS_DIR . 'shared.mb_unicode.php');
                $return = '';
                foreach (smarty_mb_to_unicode($string, SMARTY_RESOURCE_CHAR_SET) as $unicode) {
                    $return .= '&#x' . strtoupper(dechex($unicode)) . ';';
                }
                return $return;
            }
            // no MBString fallback
            $_length = strlen($string);
            for ($x = 0; $x < $_length; $x++) {
                $return .= '&#x' . bin2hex($string[$x]) . ';';
            }
            return $return;

        case 'decentity':
            $return = '';
            if (SMARTY_MBSTRING /* ^phpunit */ && empty($_SERVER['SMARTY_PHPUNIT_DISABLE_MBSTRING'])/* phpunit$ */) {
                require_once(SMARTY_PLUGINS_DIR . 'shared.mb_unicode.php');
                $return = '';
                foreach (smarty_mb_to_unicode($string, SMARTY_RESOURCE_CHAR_SET) as $unicode) {
                    $return .= '&#' . $unicode . ';';
                }
                return $return;
            }
            // no MBString fallback
            $_length = strlen($string);
            for ($x = 0; $x < $_length; $x++) {
                $return .= '&#' . ord($string[$x]) . ';';
            }
            return $return;

        case 'javascript':
            // escape quotes and backslashes, newlines, etc.
            return strtr($string, array('\\' => '\\\\', "'" => "\\'", '"' => '\\"', "\r" => '\\r', "\n" => '\\n', '</' => '<\/'));

        case 'mail':
            if (SMARTY_MBSTRING /* ^phpunit */ && empty($_SERVER['SMARTY_PHPUNIT_DISABLE_MBSTRING'])/* phpunit$ */) {
                require_once(SMARTY_PLUGINS_DIR . 'shared.mb_str_replace.php');
                return smarty_mb_str_replace(array('@', '.'), array(' [AT] ', ' [DOT] '), $string);
            }
            // no MBString fallback
            return str_replace(array('@', '.'), array(' [AT] ', ' [DOT] '), $string);

        case 'nonstd':
            // escape non-standard chars, such as ms document quotes
            $return = '';
            if (SMARTY_MBSTRING /* ^phpunit */ && empty($_SERVER['SMARTY_PHPUNIT_DISABLE_MBSTRING'])/* phpunit$ */) {
                require_once(SMARTY_PLUGINS_DIR . 'shared.mb_unicode.php');
                foreach (smarty_mb_to_unicode($string, SMARTY_RESOURCE_CHAR_SET) as $unicode) {
                    if ($unicode >= 126) {
                        $return .= '&#' . $unicode . ';';
                    } else {
                        $return .= chr($unicode);
                    }
                }
                return $return;
            }

            $_length = strlen($string);
            for ($_i = 0; $_i < $_length; $_i++) {
                $_ord = ord(substr($string, $_i, 1));
                // non-standard char, escape it
                if ($_ord >= 126) {
                    $return .= '&#' . $_ord . ';';
                } else {
                    $return .= substr($string, $_i, 1);
                }
            }
            return $return;

        default:
            return $string;
    }
}

?><?php
/**
 * Smarty shared plugin
 *
 * @package Smarty
 * @subpackage PluginsShared
 */

/**
 * Function: smarty_make_timestamp<br>
 * Purpose:  used by other smarty functions to make a timestamp from a string.
 *
 * @author   Monte Ohrt <monte at ohrt dot com>
 * @param DateTime|int|string $string  date object, timestamp or string that can be converted using strtotime()
 * @return int
 */
function smarty_make_timestamp($string)
{
    if (empty($string)) {
        // use "now":
        return time();
    } elseif ($string instanceof DateTime) {
        return $string->getTimestamp();
    } elseif (strlen($string) == 14 && ctype_digit($string)) {
        // it is mysql timestamp format of YYYYMMDDHHMMSS?
        return mktime(substr($string, 8, 2),substr($string, 10, 2),substr($string, 12, 2),
                       substr($string, 4, 2),substr($string, 6, 2),substr($string, 0, 4));
    } elseif (is_numeric($string)) {
        // it is a numeric string, we handle it as timestamp
        return (int) $string;
    } else {
        // strtotime should handle it
        $time = strtotime($string);
        if ($time == -1 || $time === false) {
            // strtotime() was not able to parse $string, use "now":
            return time();
        }
        return $time;
    }
}

?>
<?php
/**
 * Smarty shared plugin
 *
 * @package Smarty
 * @subpackage PluginsShared
 */

if(!function_exists('smarty_mb_wordwrap')) {

    /**
     * Wrap a string to a given number of characters
     *
     * @link http://php.net/manual/en/function.wordwrap.php for similarity
     * @param string  $str   the string to wrap
     * @param int     $width the width of the output
     * @param string  $break the character used to break the line
     * @param boolean $cut   ignored parameter, just for the sake of
     * @return string wrapped string
     * @author Rodney Rehm
     */
    function smarty_mb_wordwrap($str, $width=75, $break="\n", $cut=false)
    {
        // break words into tokens using white space as a delimiter
        $tokens = preg_split('!(\s)!uS', $str, -1, PREG_SPLIT_NO_EMPTY + PREG_SPLIT_DELIM_CAPTURE);
        $length = 0;
        $t = '';
        $_previous = false;

        foreach ($tokens as $_token) {
            $token_length = mb_strlen($_token, SMARTY_RESOURCE_CHAR_SET);
            $_tokens = array($_token);
            if ($token_length > $width) {
                // remove last space
                $t = mb_substr($t, 0, -1, SMARTY_RESOURCE_CHAR_SET);
                $_previous = false;
                $length = 0;

                if ($cut) {
                    $_tokens = preg_split('!(.{' . $width . '})!uS', $_token, -1, PREG_SPLIT_NO_EMPTY + PREG_SPLIT_DELIM_CAPTURE);
                    // broken words go on a new line
                    $t .= $break;
                }
            }

            foreach ($_tokens as $token) {
                $_space = !!preg_match('!^\s$!uS', $token);
                $token_length = mb_strlen($token, SMARTY_RESOURCE_CHAR_SET);
                $length += $token_length;

                if ($length > $width) {
                    // remove space before inserted break
                    if ($_previous && $token_length < $width) {
                        $t = mb_substr($t, 0, -1, SMARTY_RESOURCE_CHAR_SET);
                    }

                    // add the break before the token
                    $t .= $break;
                    $length = $token_length;

                    // skip space after inserting a break
                    if ($_space) {
                        $length = 0;
                        continue;
                    }
                } else if ($token == "\n") {
                    // hard break must reset counters
                    $_previous = 0;
                    $length = 0;
                } else {
                    // remember if we had a space or not
                    $_previous = $_space;
                }
                // add the token
                $t .= $token;
            }
        }

        return $t;
    }

}
?><?php
/**
 * Smarty plugin
 *
 * @package Smarty
 * @subpackage PluginsFunction
 */

/**
 * Smarty {cycle} function plugin
 *
 * Type:     function<br>
 * Name:     cycle<br>
 * Date:     May 3, 2002<br>
 * Purpose:  cycle through given values<br>
 * Params:
 * <pre>
 * - name      - name of cycle (optional)
 * - values    - comma separated list of values to cycle, or an array of values to cycle
 *               (this can be left out for subsequent calls)
 * - reset     - boolean - resets given var to true
 * - print     - boolean - print var or not. default is true
 * - advance   - boolean - whether or not to advance the cycle
 * - delimiter - the value delimiter, default is ","
 * - assign    - boolean, assigns to template var instead of printed.
 * </pre>
 * Examples:<br>
 * <pre>
 * {cycle values="#eeeeee,#d0d0d0d"}
 * {cycle name=row values="one,two,three" reset=true}
 * {cycle name=row}
 * </pre>
 *
 * @link http://www.smarty.net/manual/en/language.function.cycle.php {cycle}
 *       (Smarty online manual)
 * @author Monte Ohrt <monte at ohrt dot com>
 * @author credit to Mark Priatel <mpriatel@rogers.com>
 * @author credit to Gerard <gerard@interfold.com>
 * @author credit to Jason Sweat <jsweat_php@yahoo.com>
 * @version  1.3
 * @param array                    $params   parameters
 * @param Smarty_Internal_Template $template template object
 * @return string|null
 */

function smarty_function_cycle($params, $template)
{
    static $cycle_vars;

    $name = (empty($params['name'])) ? 'default' : $params['name'];
    $print = (isset($params['print'])) ? (bool)$params['print'] : true;
    $advance = (isset($params['advance'])) ? (bool)$params['advance'] : true;
    $reset = (isset($params['reset'])) ? (bool)$params['reset'] : false;

    if (!isset($params['values'])) {
        if(!isset($cycle_vars[$name]['values'])) {
            trigger_error("cycle: missing 'values' parameter");
            return;
        }
    } else {
        if(isset($cycle_vars[$name]['values'])
            && $cycle_vars[$name]['values'] != $params['values'] ) {
            $cycle_vars[$name]['index'] = 0;
        }
        $cycle_vars[$name]['values'] = $params['values'];
    }

    if (isset($params['delimiter'])) {
        $cycle_vars[$name]['delimiter'] = $params['delimiter'];
    } elseif (!isset($cycle_vars[$name]['delimiter'])) {
        $cycle_vars[$name]['delimiter'] = ',';
    }

    if(is_array($cycle_vars[$name]['values'])) {
        $cycle_array = $cycle_vars[$name]['values'];
    } else {
        $cycle_array = explode($cycle_vars[$name]['delimiter'],$cycle_vars[$name]['values']);
    }

    if(!isset($cycle_vars[$name]['index']) || $reset ) {
        $cycle_vars[$name]['index'] = 0;
    }

    if (isset($params['assign'])) {
        $print = false;
        $template->assign($params['assign'], $cycle_array[$cycle_vars[$name]['index']]);
    }

    if($print) {
        $retval = $cycle_array[$cycle_vars[$name]['index']];
    } else {
        $retval = null;
    }

    if($advance) {
        if ( $cycle_vars[$name]['index'] >= count($cycle_array) -1 ) {
            $cycle_vars[$name]['index'] = 0;
        } else {
            $cycle_vars[$name]['index']++;
        }
    }

    return $retval;
}

?><?php
/**
 * Project:     Smarty: the PHP compiling template engine
 * File:        SmartyBC.class.php
 * SVN:         $Id: $
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For questions, help, comments, discussion, etc., please join the
 * Smarty mailing list. Send a blank e-mail to
 * smarty-discussion-subscribe@googlegroups.com
 *
 * @link http://www.smarty.net/
 * @copyright 2008 New Digital Group, Inc.
 * @author Monte Ohrt <monte at ohrt dot com>
 * @author Uwe Tews
 * @author Rodney Rehm
 * @package Smarty
 */
/**
 * @ignore
 */
require(dirname(__FILE__) . '/Smarty.class.php');

/**
 * Smarty Backward Compatability Wrapper Class
 *
 * @package Smarty
 */
class SmartyBC extends Smarty {

    /**
     * Smarty 2 BC
     * @var string
     */
    public $_version = self::SMARTY_VERSION;

    /**
     * Initialize new SmartyBC object
     *
     * @param array $options options to set during initialization, e.g. array( 'forceCompile' => false )
     */
    public function __construct(array $options=array())
    {
        parent::__construct($options);
        // register {php} tag
        $this->registerPlugin('block', 'php', 'smarty_php_tag');
    }

    /**
     * wrapper for assign_by_ref
     *
     * @param string $tpl_var the template variable name
     * @param mixed  &$value  the referenced value to assign
     */
    public function assign_by_ref($tpl_var, &$value)
    {
        $this->assignByRef($tpl_var, $value);
    }

    /**
     * wrapper for append_by_ref
     *
     * @param string  $tpl_var the template variable name
     * @param mixed   &$value  the referenced value to append
     * @param boolean $merge   flag if array elements shall be merged
     */
    public function append_by_ref($tpl_var, &$value, $merge = false)
    {
        $this->appendByRef($tpl_var, $value, $merge);
    }

    /**
     * clear the given assigned template variable.
     *
     * @param string $tpl_var the template variable to clear
     */
    public function clear_assign($tpl_var)
    {
        $this->clearAssign($tpl_var);
    }

    /**
     * Registers custom function to be used in templates
     *
     * @param string $function      the name of the template function
     * @param string $function_impl the name of the PHP function to register
     * @param bool   $cacheable
     * @param mixed  $cache_attrs
     */
    public function register_function($function, $function_impl, $cacheable=true, $cache_attrs=null)
    {
        $this->registerPlugin('function', $function, $function_impl, $cacheable, $cache_attrs);
    }

    /**
     * Unregisters custom function
     *
     * @param string $function name of template function
     */
    public function unregister_function($function)
    {
        $this->unregisterPlugin('function', $function);
    }

    /**
     * Registers object to be used in templates
     *
     * @param string  $object      name of template object
     * @param object  $object_impl the referenced PHP object to register
     * @param array   $allowed     list of allowed methods (empty = all)
     * @param boolean $smarty_args smarty argument format, else traditional
     * @param array   $block_functs list of methods that are block format
     */
    public function register_object($object, $object_impl, $allowed = array(), $smarty_args = true, $block_methods = array())
    {
        settype($allowed, 'array');
        settype($smarty_args, 'boolean');
        $this->registerObject($object, $object_impl, $allowed, $smarty_args, $block_methods);
    }

    /**
     * Unregisters object
     *
     * @param string $object name of template object
     */
    public function unregister_object($object)
    {
        $this->unregisterObject($object);
    }

    /**
     * Registers block function to be used in templates
     *
     * @param string $block      name of template block
     * @param string $block_impl PHP function to register
     * @param bool   $cacheable
     * @param mixed  $cache_attrs
     */
    public function register_block($block, $block_impl, $cacheable=true, $cache_attrs=null)
    {
        $this->registerPlugin('block', $block, $block_impl, $cacheable, $cache_attrs);
    }

    /**
     * Unregisters block function
     *
     * @param string $block name of template function
     */
    public function unregister_block($block)
    {
        $this->unregisterPlugin('block', $block);
    }

    /**
     * Registers compiler function
     *
     * @param string $function      name of template function
     * @param string $function_impl name of PHP function to register
     * @param bool   $cacheable
     */
    public function register_compiler_function($function, $function_impl, $cacheable=true)
    {
        $this->registerPlugin('compiler', $function, $function_impl, $cacheable);
    }

    /**
     * Unregisters compiler function
     *
     * @param string $function name of template function
     */
    public function unregister_compiler_function($function)
    {
        $this->unregisterPlugin('compiler', $function);
    }

    /**
     * Registers modifier to be used in templates
     *
     * @param string $modifier name of template modifier
     * @param string $modifier_impl name of PHP function to register
     */
    public function register_modifier($modifier, $modifier_impl)
    {
        $this->registerPlugin('modifier', $modifier, $modifier_impl);
    }

    /**
     * Unregisters modifier
     *
     * @param string $modifier name of template modifier
     */
    public function unregister_modifier($modifier)
    {
        $this->unregisterPlugin('modifier', $modifier);
    }

    /**
     * Registers a resource to fetch a template
     *
     * @param string $type      name of resource
     * @param array  $functions array of functions to handle resource
     */
    public function register_resource($type, $functions)
    {
        $this->registerResource($type, $functions);
    }

    /**
     * Unregisters a resource
     *
     * @param string $type name of resource
     */
    public function unregister_resource($type)
    {
        $this->unregisterResource($type);
    }

    /**
     * Registers a prefilter function to apply
     * to a template before compiling
     *
     * @param callable $function
     */
    public function register_prefilter($function)
    {
        $this->registerFilter('pre', $function);
    }

    /**
     * Unregisters a prefilter function
     *
     * @param callable $function
     */
    public function unregister_prefilter($function)
    {
        $this->unregisterFilter('pre', $function);
    }

    /**
     * Registers a postfilter function to apply
     * to a compiled template after compilation
     *
     * @param callable $function
     */
    public function register_postfilter($function)
    {
        $this->registerFilter('post', $function);
    }

    /**
     * Unregisters a postfilter function
     *
     * @param callable $function
     */
    public function unregister_postfilter($function)
    {
        $this->unregisterFilter('post', $function);
    }

    /**
     * Registers an output filter function to apply
     * to a template output
     *
     * @param callable $function
     */
    public function register_outputfilter($function)
    {
        $this->registerFilter('output', $function);
    }

    /**
     * Unregisters an outputfilter function
     *
     * @param callable $function
     */
    public function unregister_outputfilter($function)
    {
        $this->unregisterFilter('output', $function);
    }

    /**
     * load a filter of specified type and name
     *
     * @param string $type filter type
     * @param string $name filter name
     */
    public function load_filter($type, $name)
    {
        $this->loadFilter($type, $name);
    }

    /**
     * clear cached content for the given template and cache id
     *
     * @param string $tpl_file   name of template file
     * @param string $cache_id   name of cache_id
     * @param string $compile_id name of compile_id
     * @param string $exp_time   expiration time
     * @return boolean
     */
    public function clear_cache($tpl_file = null, $cache_id = null, $compile_id = null, $exp_time = null)
    {
        return $this->clearCache($tpl_file, $cache_id, $compile_id, $exp_time);
    }

    /**
     * clear the entire contents of cache (all templates)
     *
     * @param string $exp_time expire time
     * @return boolean
     */
    public function clear_all_cache($exp_time = null)
    {
        return $this->clearCache(null, null, null, $exp_time);
    }

    /**
     * test to see if valid cache exists for this template
     *
     * @param string $tpl_file name of template file
     * @param string $cache_id
     * @param string $compile_id
     * @return boolean
     */
    public function is_cached($tpl_file, $cache_id = null, $compile_id = null)
    {
        return $this->isCached($tpl_file, $cache_id, $compile_id);
    }

    /**
     * clear all the assigned template variables.
     */
    public function clear_all_assign()
    {
        $this->clearAllAssign();
    }

    /**
     * clears compiled version of specified template resource,
     * or all compiled template files if one is not specified.
     * This function is for advanced use only, not normally needed.
     *
     * @param string $tpl_file
     * @param string $compile_id
     * @param string $exp_time
     * @return boolean results of {@link smarty_core_rm_auto()}
     */
    public function clear_compiled_tpl($tpl_file = null, $compile_id = null, $exp_time = null)
    {
        return $this->clearCompiledTemplate($tpl_file, $compile_id, $exp_time);
    }

    /**
     * Checks whether requested template exists.
     *
     * @param string $tpl_file
     * @return boolean
     */
    public function template_exists($tpl_file)
    {
        return $this->templateExists($tpl_file);
    }

    /**
     * Returns an array containing template variables
     *
     * @param string $name
     * @return array
     */
    public function get_template_vars($name=null)
    {
        return $this->getTemplateVars($name);
    }

    /**
     * Returns an array containing config variables
     *
     * @param string $name
     * @return array
     */
    public function get_config_vars($name=null)
    {
        return $this->getConfigVars($name);
    }

    /**
     * load configuration values
     *
     * @param string $file
     * @param string $section
     * @param string $scope
     */
    public function config_load($file, $section = null, $scope = 'global')
    {
        $this->ConfigLoad($file, $section, $scope);
    }

    /**
     * return a reference to a registered object
     *
     * @param string $name
     * @return object
     */
    public function get_registered_object($name)
    {
        return $this->getRegisteredObject($name);
    }

    /**
     * clear configuration values
     *
     * @param string $var
     */
    public function clear_config($var = null)
    {
        $this->clearConfig($var);
    }

    /**
     * trigger Smarty error
     *
     * @param string $error_msg
     * @param integer $error_type
     */
    public function trigger_error($error_msg, $error_type = E_USER_WARNING)
    {
        trigger_error("Smarty error: $error_msg", $error_type);
    }

}

/**
 * Smarty {php}{/php} block function
 *
 * @param array   $params   parameter list
 * @param string  $content  contents of the block
 * @param object  $template template object
 * @param boolean &$repeat  repeat flag
 * @return string content re-formatted
 */
function smarty_php_tag($params, $content, $template, &$repeat)
{
    eval($content);
    return '';
}

?><?php
/**
 * Smarty Internal Plugin
 *
 * @package Smarty
 * @subpackage Cacher
 */

/**
 * Cache Handler API
 *
 * @package Smarty
 * @subpackage Cacher
 * @author Rodney Rehm
 */
abstract class Smarty_CacheResource_Custom extends Smarty_CacheResource {

    /**
     * fetch cached content and its modification time from data source
     *
     * @param string $id         unique cache content identifier
     * @param string $name       template name
     * @param string $cache_id   cache id
     * @param string $compile_id compile id
     * @param string $content    cached content
     * @param integer $mtime cache modification timestamp (epoch)
     * @return void
     */
    protected abstract function fetch($id, $name, $cache_id, $compile_id, &$content, &$mtime);

    /**
     * Fetch cached content's modification timestamp from data source
     *
     * {@internal implementing this method is optional.
     *  Only implement it if modification times can be accessed faster than loading the complete cached content.}}
     *
     * @param string $id         unique cache content identifier
     * @param string $name       template name
     * @param string $cache_id   cache id
     * @param string $compile_id compile id
     * @return integer|boolean timestamp (epoch) the template was modified, or false if not found
     */
    protected function fetchTimestamp($id, $name, $cache_id, $compile_id)
    {
        return null;
    }

    /**
     * Save content to cache
     *
     * @param string       $id         unique cache content identifier
     * @param string       $name       template name
     * @param string       $cache_id   cache id
     * @param string       $compile_id compile id
     * @param integer|null $exp_time   seconds till expiration or null
     * @param string $content content to cache
     * @return boolean success
     */
    protected abstract function save($id, $name, $cache_id, $compile_id, $exp_time, $content);

    /**
     * Delete content from cache
     *
     * @param string       $name       template name
     * @param string       $cache_id   cache id
     * @param string       $compile_id compile id
     * @param integer|null $exp_time   seconds till expiration time in seconds or null
     * @return integer number of deleted caches
     */
    protected abstract function delete($name, $cache_id, $compile_id, $exp_time);

    /**
     * populate Cached Object with meta data from Resource
     *
     * @param Smarty_Template_Cached   $cached    cached object
     * @param Smarty_Internal_Template $_template template object
     * @return void
     */
    public function populate(Smarty_Template_Cached $cached, Smarty_Internal_Template $_template)
    {
        $_cache_id = isset($cached->cache_id) ? preg_replace('![^\w\|]+!', '_', $cached->cache_id) : null;
        $_compile_id = isset($cached->compile_id) ? preg_replace('![^\w\|]+!', '_', $cached->compile_id) : null;

        $cached->filepath = sha1($cached->source->filepath . $_cache_id . $_compile_id);
        $this->populateTimestamp($cached);
    }

    /**
     * populate Cached Object with timestamp and exists from Resource
     *
     * @param Smarty_Template_Cached $source cached object
     * @return void
     */
    public function populateTimestamp(Smarty_Template_Cached $cached)
    {
        $mtime = $this->fetchTimestamp($cached->filepath, $cached->source->name, $cached->cache_id, $cached->compile_id);
        if ($mtime !== null) {
            $cached->timestamp = $mtime;
            $cached->exists = !!$cached->timestamp;
            return;
        }
        $timestamp = null;
        $this->fetch($cached->filepath, $cached->source->name, $cached->cache_id, $cached->compile_id, $cached->content, $timestamp);
        $cached->timestamp = isset($timestamp) ? $timestamp : false;
        $cached->exists = !!$cached->timestamp;
    }

    /**
     * Read the cached template and process the header
     *
     * @param Smarty_Internal_Template $_template template object
     * @param Smarty_Template_Cached $cached cached object
     * @return booelan true or false if the cached content does not exist
     */
    public function process(Smarty_Internal_Template $_template, Smarty_Template_Cached $cached=null)
    {
        if (!$cached) {
            $cached = $_template->cached;
        }
        $content = $cached->content ? $cached->content : null;
        $timestamp = $cached->timestamp ? $cached->timestamp : null;
        if ($content === null || !$timestamp) {
            $this->fetch(
                $_template->cached->filepath,
                $_template->source->name,
                $_template->cache_id,
                $_template->compile_id,
                $content,
                $timestamp
            );
        }
        if (isset($content)) {
            $_smarty_tpl = $_template;
            eval("?>" . $content);
            return true;
        }
        return false;
    }

    /**
     * Write the rendered template output to cache
     *
     * @param Smarty_Internal_Template $_template template object
     * @param string                   $content   content to cache
     * @return boolean success
     */
    public function writeCachedContent(Smarty_Internal_Template $_template, $content)
    {
        return $this->save(
            $_template->cached->filepath,
            $_template->source->name,
            $_template->cache_id,
            $_template->compile_id,
            $_template->properties['cache_lifetime'],
            $content
        );
    }

    /**
     * Empty cache
     *
     * @param Smarty  $smarty   Smarty object
     * @param integer $exp_time expiration time (number of seconds, not timestamp)
     * @return integer number of cache files deleted
     */
    public function clearAll(Smarty $smarty, $exp_time=null)
    {
        $this->cache = array();
        return $this->delete(null, null, null, $exp_time);
    }

    /**
     * Empty cache for a specific template
     *
     * @param Smarty  $smarty        Smarty object
     * @param string  $resource_name template name
     * @param string  $cache_id      cache id
     * @param string  $compile_id    compile id
     * @param integer $exp_time      expiration time (number of seconds, not timestamp)
     * @return integer number of cache files deleted
     */
    public function clear(Smarty $smarty, $resource_name, $cache_id, $compile_id, $exp_time)
    {
        $this->cache = array();
        return $this->delete($resource_name, $cache_id, $compile_id, $exp_time);
    }
    
    /**
     * Check is cache is locked for this template
     *
     * @param Smarty $smarty Smarty object
     * @param Smarty_Template_Cached $cached cached object
     * @return booelan true or false if cache is locked
     */
    public function hasLock(Smarty $smarty, Smarty_Template_Cached $cached)
    {
        $id = $cached->filepath;
        $name = $cached->source->name . '.lock';
        
        $mtime = $this->fetchTimestamp($id, $name, null, null);
        if ($mtime === null) {
            $this->fetch($id, $name, null, null, $content, $mtime);
        }
        
        return $mtime && time() - $mtime < $smarty->locking_timeout;
    }

    /**
     * Lock cache for this template
     *
     * @param Smarty $smarty Smarty object
     * @param Smarty_Template_Cached $cached cached object
     */
    public function acquireLock(Smarty $smarty, Smarty_Template_Cached $cached)
    {
        $cached->is_locked = true;
        
        $id = $cached->filepath;
        $name = $cached->source->name . '.lock';
        $this->save($id, $name, null, null, $smarty->locking_timeout, '');
    }

    /**
     * Unlock cache for this template
     *
     * @param Smarty $smarty Smarty object
     * @param Smarty_Template_Cached $cached cached object
     */
    public function releaseLock(Smarty $smarty, Smarty_Template_Cached $cached)
    {
        $cached->is_locked = false;
        
        $id = $cached->filepath;
        $name = $cached->source->name . '.lock';
        $this->delete($name, null, null, null);
    }
}
?><?php
/**
 * Smarty Internal Plugin Compile Function
 *
 * Compiles the {function} {/function} tags
 *
 * @package Smarty
 * @subpackage Compiler
 * @author Uwe Tews
 */

/**
 * Smarty Internal Plugin Compile Function Class
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_Function extends Smarty_Internal_CompileBase {

    /**
     * Attribute definition: Overwrites base class.
     *
     * @var array
     * @see Smarty_Internal_CompileBase
     */
    public $required_attributes = array('name');
    /**
     * Attribute definition: Overwrites base class.
     *
     * @var array
     * @see Smarty_Internal_CompileBase
     */
    public $shorttag_order = array('name');
    /**
     * Attribute definition: Overwrites base class.
     *
     * @var array
     * @see Smarty_Internal_CompileBase
     */
    public $optional_attributes = array('_any');

    /**
     * Compiles code for the {function} tag
     *
     * @param array $args array with attributes from parser
     * @param object $compiler compiler object
     * @param array $parameter array with compilation parameter
     * @return boolean true
     */
    public function compile($args, $compiler, $parameter)
    {
        // check and get attributes
        $_attr = $this->getAttributes($compiler, $args);

        if ($_attr['nocache'] === true) {
            $compiler->trigger_template_error('nocache option not allowed', $compiler->lex->taglineno);
        }
        unset($_attr['nocache']);
        $save = array($_attr, $compiler->parser->current_buffer,
            $compiler->template->has_nocache_code, $compiler->template->required_plugins);
        $this->openTag($compiler, 'function', $save);
        $_name = trim($_attr['name'], "'\"");
        unset($_attr['name']);
        // set flag that we are compiling a template function
        $compiler->compiles_template_function = true;
        $compiler->template->properties['function'][$_name]['parameter'] = array();
        $_smarty_tpl = $compiler->template;
        foreach ($_attr as $_key => $_data) {
            eval ('$tmp='.$_data.';');
            $compiler->template->properties['function'][$_name]['parameter'][$_key] = $tmp;
        }
        $compiler->smarty->template_functions[$_name]['parameter'] = $compiler->template->properties['function'][$_name]['parameter'];
        if ($compiler->template->caching) {
            $output = '';
        } else {
            $output = "<?php if (!function_exists('smarty_template_function_{$_name}')) {
    function smarty_template_function_{$_name}(\$_smarty_tpl,\$params) {
    \$saved_tpl_vars = \$_smarty_tpl->tpl_vars;
    foreach (\$_smarty_tpl->smarty->template_functions['{$_name}']['parameter'] as \$key => \$value) {\$_smarty_tpl->tpl_vars[\$key] = new Smarty_variable(\$value);};
    foreach (\$params as \$key => \$value) {\$_smarty_tpl->tpl_vars[\$key] = new Smarty_variable(\$value);}?>";
        }
        // Init temporay context
        $compiler->template->required_plugins = array('compiled' => array(), 'nocache' => array());
        $compiler->parser->current_buffer = new _smarty_template_buffer($compiler->parser);
        $compiler->parser->current_buffer->append_subtree(new _smarty_tag($compiler->parser, $output));
        $compiler->template->has_nocache_code = false;
        $compiler->has_code = false;
        $compiler->template->properties['function'][$_name]['compiled'] = '';
        return true;
    }

}

/**
 * Smarty Internal Plugin Compile Functionclose Class
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_Functionclose extends Smarty_Internal_CompileBase {

    /**
     * Compiles code for the {/function} tag
     *
     * @param array $args array with attributes from parser
     * @param object $compiler compiler object
     * @param array $parameter array with compilation parameter
     * @return boolean true
     */
    public function compile($args, $compiler, $parameter)
    {
        $_attr = $this->getAttributes($compiler, $args);
        $saved_data = $this->closeTag($compiler, array('function'));
        $_name = trim($saved_data[0]['name'], "'\"");
        // build plugin include code
        $plugins_string = '';
        if (!empty($compiler->template->required_plugins['compiled'])) {
            $plugins_string = '<?php ';
            foreach($compiler->template->required_plugins['compiled'] as $tmp) {
                foreach($tmp as $data) {
                    $plugins_string .= "if (!is_callable('{$data['function']}')) include '{$data['file']}';\n";
                }
            }
            $plugins_string .= '?>';
        }
        if (!empty($compiler->template->required_plugins['nocache'])) {
            $plugins_string .= "<?php echo '/*%%SmartyNocache:{$compiler->template->properties['nocache_hash']}%%*/<?php ";
            foreach($compiler->template->required_plugins['nocache'] as $tmp) {
                foreach($tmp as $data) {
                    $plugins_string .= "if (!is_callable(\'{$data['function']}\')) include \'{$data['file']}\';\n";
                }
            }
            $plugins_string .= "?>/*/%%SmartyNocache:{$compiler->template->properties['nocache_hash']}%%*/';?>\n";
        }
         // remove last line break from function definition
         $last = count($compiler->parser->current_buffer->subtrees) - 1;
         if ($compiler->parser->current_buffer->subtrees[$last] instanceof _smarty_linebreak) {
             unset($compiler->parser->current_buffer->subtrees[$last]);
         }
        // if caching save template function for possible nocache call
        if ($compiler->template->caching) {
            $compiler->template->properties['function'][$_name]['compiled'] .= $plugins_string
             . $compiler->parser->current_buffer->to_smarty_php();
            $compiler->template->properties['function'][$_name]['nocache_hash'] = $compiler->template->properties['nocache_hash'];
            $compiler->template->properties['function'][$_name]['has_nocache_code'] = $compiler->template->has_nocache_code;
            $compiler->template->properties['function'][$_name]['called_functions'] = $compiler->called_functions;
            $compiler->called_functions = array();
            $compiler->smarty->template_functions[$_name] = $compiler->template->properties['function'][$_name];
            $compiler->has_code = false;
            $output = true;
        } else {
            $output = $plugins_string . $compiler->parser->current_buffer->to_smarty_php() . "<?php \$_smarty_tpl->tpl_vars = \$saved_tpl_vars;}}?>\n";
        }
        // reset flag that we are compiling a template function
        $compiler->compiles_template_function = false;
        // restore old compiler status
        $compiler->parser->current_buffer = $saved_data[1];
        $compiler->template->has_nocache_code = $compiler->template->has_nocache_code | $saved_data[2];
        $compiler->template->required_plugins = $saved_data[3];
        return $output;
    }

}

?><?php
/**
 * Smarty Internal Plugin CompileBase
 *
 * @package Smarty
 * @subpackage Compiler
 * @author Uwe Tews
 */

/**
 * This class does extend all internal compile plugins
 *
 * @package Smarty
 * @subpackage Compiler
 */
abstract class Smarty_Internal_CompileBase {

    /**
     * Array of names of required attribute required by tag
     *
     * @var array
     */
    public $required_attributes = array();
    /**
     * Array of names of optional attribute required by tag
     * use array('_any') if there is no restriction of attributes names
     *
     * @var array
     */
    public $optional_attributes = array();
    /**
     * Shorttag attribute order defined by its names
     *
     * @var array
     */
    public $shorttag_order = array();
    /**
     * Array of names of valid option flags
     *
     * @var array
     */
    public $option_flags = array('nocache');

    /**
     * This function checks if the attributes passed are valid
     *
     * The attributes passed for the tag to compile are checked against the list of required and
     * optional attributes. Required attributes must be present. Optional attributes are check against
     * the corresponding list. The keyword '_any' specifies that any attribute will be accepted
     * as valid
     *
     * @param object $compiler   compiler object
     * @param array  $attributes attributes applied to the tag
     * @return array of mapped attributes for further processing
     */
    public function getAttributes($compiler, $attributes)
    {
        $_indexed_attr = array();
        // loop over attributes
        foreach ($attributes as $key => $mixed) {
            // shorthand ?
            if (!is_array($mixed)) {
                // option flag ?
                if (in_array(trim($mixed, '\'"'), $this->option_flags)) {
                    $_indexed_attr[trim($mixed, '\'"')] = true;
                    // shorthand attribute ?
                } else if (isset($this->shorttag_order[$key])) {
                    $_indexed_attr[$this->shorttag_order[$key]] = $mixed;
                } else {
                    // too many shorthands
                    $compiler->trigger_template_error('too many shorthand attributes', $compiler->lex->taglineno);
                }
                // named attribute
            } else {
                $kv = each($mixed);
                // option flag?
                if (in_array($kv['key'], $this->option_flags)) {
                    if (is_bool($kv['value'])) {
                        $_indexed_attr[$kv['key']] = $kv['value'];
                    } else if (is_string($kv['value']) && in_array(trim($kv['value'], '\'"'), array('true', 'false'))) {
                        if (trim($kv['value']) == 'true') {
                            $_indexed_attr[$kv['key']] = true;
                        } else {
                            $_indexed_attr[$kv['key']] = false;
                        }
                    } else if (is_numeric($kv['value']) && in_array($kv['value'], array(0, 1))) {
                        if ($kv['value'] == 1) {
                            $_indexed_attr[$kv['key']] = true;
                        } else {
                            $_indexed_attr[$kv['key']] = false;
                        }
                    } else {
                        $compiler->trigger_template_error("illegal value of option flag \"{$kv['key']}\"", $compiler->lex->taglineno);
                    }
                    // must be named attribute
                } else {
                    reset($mixed);
                    $_indexed_attr[key($mixed)] = $mixed[key($mixed)];
                }
            }
        }
        // check if all required attributes present
        foreach ($this->required_attributes as $attr) {
            if (!array_key_exists($attr, $_indexed_attr)) {
                $compiler->trigger_template_error("missing \"" . $attr . "\" attribute", $compiler->lex->taglineno);
            }
        }
        // check for unallowed attributes
        if ($this->optional_attributes != array('_any')) {
            $tmp_array = array_merge($this->required_attributes, $this->optional_attributes, $this->option_flags);
            foreach ($_indexed_attr as $key => $dummy) {
                if (!in_array($key, $tmp_array) && $key !== 0) {
                    $compiler->trigger_template_error("unexpected \"" . $key . "\" attribute", $compiler->lex->taglineno);
                }
            }
        }
        // default 'false' for all option flags not set
        foreach ($this->option_flags as $flag) {
            if (!isset($_indexed_attr[$flag])) {
                $_indexed_attr[$flag] = false;
            }
        }

        return $_indexed_attr;
    }

    /**
     * Push opening tag name on stack
     *
     * Optionally additional data can be saved on stack
     *
     * @param object    $compiler   compiler object
     * @param string    $openTag    the opening tag's name
     * @param mixed     $data       optional data saved
     */
    public function openTag($compiler, $openTag, $data = null)
    {
        array_push($compiler->_tag_stack, array($openTag, $data));
    }

    /**
     * Pop closing tag
     *
     * Raise an error if this stack-top doesn't match with expected opening tags
     *
     * @param object       $compiler    compiler object
     * @param array|string $expectedTag the expected opening tag names
     * @return mixed any type the opening tag's name or saved data
     */
    public function closeTag($compiler, $expectedTag)
    {
        if (count($compiler->_tag_stack) > 0) {
            // get stacked info
            list($_openTag, $_data) = array_pop($compiler->_tag_stack);
            // open tag must match with the expected ones
            if (in_array($_openTag, (array) $expectedTag)) {
                if (is_null($_data)) {
                    // return opening tag
                    return $_openTag;
                } else {
                    // return restored data
                    return $_data;
                }
            }
            // wrong nesting of tags
            $compiler->trigger_template_error("unclosed {" . $_openTag . "} tag");
            return;
        }
        // wrong nesting of tags
        $compiler->trigger_template_error("unexpected closing tag", $compiler->lex->taglineno);
        return;
    }

}

?><?php
/**
 * Smarty Internal Plugin Debug
 *
 * Class to collect data for the Smarty Debugging Consol
 *
 * @package Smarty
 * @subpackage Debug
 * @author Uwe Tews
 */

/**
 * Smarty Internal Plugin Debug Class
 *
 * @package Smarty
 * @subpackage Debug
 */
class Smarty_Internal_Debug extends Smarty_Internal_Data {

    /**
     * template data
     *
     * @var array
     */
    public static $template_data = array();

    /**
     * Start logging of compile time
     *
     * @param object $template
     */
    public static function start_compile($template)
    {
        $key = self::get_key($template);
        self::$template_data[$key]['start_time'] = microtime(true);
    }

    /**
     * End logging of compile time
     *
     * @param object $template
     */
    public static function end_compile($template)
    {
        $key = self::get_key($template);
        self::$template_data[$key]['compile_time'] += microtime(true) - self::$template_data[$key]['start_time'];
    }

    /**
     * Start logging of render time
     *
     * @param object $template
     */
    public static function start_render($template)
    {
        $key = self::get_key($template);
        self::$template_data[$key]['start_time'] = microtime(true);
    }

    /**
     * End logging of compile time
     *
     * @param object $template
     */
    public static function end_render($template)
    {
        $key = self::get_key($template);
        self::$template_data[$key]['render_time'] += microtime(true) - self::$template_data[$key]['start_time'];
    }

    /**
     * Start logging of cache time
     *
     * @param object $template cached template
     */
    public static function start_cache($template)
    {
        $key = self::get_key($template);
        self::$template_data[$key]['start_time'] = microtime(true);
    }

    /**
     * End logging of cache time
     *
     * @param object $template cached template
     */
    public static function end_cache($template)
    {
        $key = self::get_key($template);
        self::$template_data[$key]['cache_time'] += microtime(true) - self::$template_data[$key]['start_time'];
    }

    /**
     * Opens a window for the Smarty Debugging Consol and display the data
     *
     * @param Smarty_Internal_Template|Smarty $obj object to debug
     */
    public static function display_debug($obj)
    {
        // prepare information of assigned variables
        $ptr = self::get_debug_vars($obj);
        if ($obj instanceof Smarty) {
            $smarty = clone $obj;
        } else {
            $smarty = clone $obj->smarty;
        }
        $_assigned_vars = $ptr->tpl_vars;
        ksort($_assigned_vars);
        $_config_vars = $ptr->config_vars;
        ksort($_config_vars);
        $smarty->registered_filters = array();
        $smarty->autoload_filters = array();
        $smarty->default_modifiers = array();
        $smarty->force_compile = false;
        $smarty->left_delimiter = '{';
        $smarty->right_delimiter = '}';
        $smarty->debugging = false;
        $smarty->force_compile = false;
        $_template = new Smarty_Internal_Template($smarty->debug_tpl, $smarty);
        $_template->caching = false;
        $_template->disableSecurity();
        $_template->cache_id = null;
        $_template->compile_id = null;
        if ($obj instanceof Smarty_Internal_Template) {
            $_template->assign('template_name', $obj->source->type . ':' . $obj->source->name);
        }
        if ($obj instanceof Smarty) {
            $_template->assign('template_data', self::$template_data);
        } else {
            $_template->assign('template_data', null);
        }
        $_template->assign('assigned_vars', $_assigned_vars);
        $_template->assign('config_vars', $_config_vars);
        $_template->assign('execution_time', microtime(true) - $smarty->start_time);
        echo $_template->fetch();
    }

    /**
     * Recursively gets variables from all template/data scopes
     *
     * @param Smarty_Internal_Template|Smarty_Data $obj object to debug
     * @return StdClass
     */
    public static function get_debug_vars($obj)
    {
        $config_vars = $obj->config_vars;
        $tpl_vars = array();
        foreach ($obj->tpl_vars as $key => $var) {
            $tpl_vars[$key] = clone $var;
            if ($obj instanceof Smarty_Internal_Template) {
                $tpl_vars[$key]->scope = $obj->source->type . ':' . $obj->source->name;
            } elseif ($obj instanceof Smarty_Data) {
                $tpl_vars[$key]->scope = 'Data object';
            } else {
                $tpl_vars[$key]->scope = 'Smarty root';
            }
        }

        if (isset($obj->parent)) {
            $parent = self::get_debug_vars($obj->parent);
            $tpl_vars = array_merge($parent->tpl_vars, $tpl_vars);
            $config_vars = array_merge($parent->config_vars, $config_vars);
        } else {
            foreach (Smarty::$global_tpl_vars as $name => $var) {
                if (!array_key_exists($name, $tpl_vars)) {
                    $clone = clone $var;
                    $clone->scope = 'Global';
                    $tpl_vars[$name] = $clone;
                }
            }
        }
        return (object) array('tpl_vars' => $tpl_vars, 'config_vars' => $config_vars);
    }

    /**
     * Return key into $template_data for template
     *
     * @param object $template  template object
     * @return string   key into $template_data
     */
    private static function get_key($template)
    {
        static $_is_stringy = array('string' => true, 'eval' => true);
        // calculate Uid if not already done
        if ($template->source->uid == '') {
            $template->source->filepath;
        }
        $key = $template->source->uid;
        if (isset(self::$template_data[$key])) {
            return $key;
        } else {
            if (isset($_is_stringy[$template->source->type])) {
                self::$template_data[$key]['name'] = '\''.substr($template->source->name,0,25).'...\'';
            } else {
                self::$template_data[$key]['name'] = $template->source->filepath;
            }
            self::$template_data[$key]['compile_time'] = 0;
            self::$template_data[$key]['render_time'] = 0;
            self::$template_data[$key]['cache_time'] = 0;
            return $key;
        }
    }

}

?><?php
/**
 * Smarty plugin
 *
 * @package Smarty
 * @subpackage Security
 * @author Uwe Tews
 */
 
/*
 * FIXME: Smarty_Security API
 *      - getter and setter instead of public properties would allow cultivating an internal cache properly
 *      - current implementation of isTrustedResourceDir() assumes that Smarty::$template_dir and Smarty::$config_dir are immutable
 *        the cache is killed every time either of the variables change. That means that two distinct Smarty objects with differing
 *        $template_dir or $config_dir should NOT share the same Smarty_Security instance, 
 *        as this would lead to (severe) performance penalty! how should this be handled? 
 */

/**
 * This class does contain the security settings
 */
class Smarty_Security {

    /**
     * This determines how Smarty handles "<?php ... ?>" tags in templates.
     * possible values:
     * <ul>
     *   <li>Smarty::PHP_PASSTHRU -> echo PHP tags as they are</li>
     *   <li>Smarty::PHP_QUOTE    -> escape tags as entities</li>
     *   <li>Smarty::PHP_REMOVE   -> remove php tags</li>
     *   <li>Smarty::PHP_ALLOW    -> execute php tags</li>
     * </ul>
     *
     * @var integer
     */
    public $php_handling = Smarty::PHP_PASSTHRU;
    /**
     * This is the list of template directories that are considered secure.
     * $template_dir is in this list implicitly.
     *
     * @var array
     */
    public $secure_dir = array();
    /**
     * This is an array of directories where trusted php scripts reside.
     * {@link $security} is disabled during their inclusion/execution.
     *
     * @var array
     */
    public $trusted_dir = array();
    /**
     * This is an array of trusted static classes.
     *
     * If empty access to all static classes is allowed.
     * If set to 'none' none is allowed.
     * @var array
     */
    public $static_classes = array();
    /**
     * This is an array of trusted PHP functions.
     *
     * If empty all functions are allowed.
     * To disable all PHP functions set $php_functions = null.
     * @var array
     */
    public $php_functions = array(
        'isset', 'empty',
        'count', 'sizeof',
        'in_array', 'is_array',
        'time',
        'nl2br',
    );
    /**
     * This is an array of trusted PHP modifers.
     *
     * If empty all modifiers are allowed.
     * To disable all modifier set $modifiers = null.
     * @var array
     */
    public $php_modifiers = array(
        'escape',
        'count'
    );
    /**
     * This is an array of allowed tags.
     *
     * If empty no restriction by allowed_tags.
     * @var array
     */
    public $allowed_tags = array();
    /**
     * This is an array of disabled tags.
     *
     * If empty no restriction by disabled_tags.
     * @var array
     */
    public $disabled_tags = array();
    /**
     * This is an array of allowed modifier plugins.
     *
     * If empty no restriction by allowed_modifiers.
     * @var array
     */
    public $allowed_modifiers = array();
    /**
     * This is an array of disabled modifier plugins.
     *
     * If empty no restriction by disabled_modifiers.
     * @var array
     */
    public $disabled_modifiers = array();
    /**
     * This is an array of trusted streams.
     *
     * If empty all streams are allowed.
     * To disable all streams set $streams = null.
     * @var array
     */
    public $streams = array('file');
    /**
     * + flag if constants can be accessed from template
     * @var boolean
     */
    public $allow_constants = true;
    /**
     * + flag if super globals can be accessed from template
     * @var boolean
     */
    public $allow_super_globals = true;

    /**
     * Cache for $resource_dir lookups
     * @var array
     */
    protected $_resource_dir = null;
    /**
     * Cache for $template_dir lookups
     * @var array
     */
    protected $_template_dir = null;
    /**
     * Cache for $config_dir lookups
     * @var array
     */
    protected $_config_dir = null;
    /**
     * Cache for $secure_dir lookups
     * @var array
     */
    protected $_secure_dir = null;
    /**
     * Cache for $php_resource_dir lookups
     * @var array
     */
    protected $_php_resource_dir = null;
    /**
     * Cache for $trusted_dir lookups
     * @var array
     */
    protected $_trusted_dir = null;
    
    
    /**
     * @param Smarty $smarty
     */
    public function __construct($smarty)
    {
        $this->smarty = $smarty;
    }
    
    /**
     * Check if PHP function is trusted.
     *
     * @param string $function_name
     * @param object $compiler compiler object
     * @return boolean true if function is trusted
     * @throws SmartyCompilerException if php function is not trusted
     */
    public function isTrustedPhpFunction($function_name, $compiler)
    {
        if (isset($this->php_functions) && (empty($this->php_functions) || in_array($function_name, $this->php_functions))) {
            return true;
        }

        $compiler->trigger_template_error("PHP function '{$function_name}' not allowed by security setting");
        return false; // should not, but who knows what happens to the compiler in the future?
    }

    /**
     * Check if static class is trusted.
     *
     * @param string $class_name
     * @param object $compiler compiler object
     * @return boolean true if class is trusted
     * @throws SmartyCompilerException if static class is not trusted
     */
    public function isTrustedStaticClass($class_name, $compiler)
    {
        if (isset($this->static_classes) && (empty($this->static_classes) || in_array($class_name, $this->static_classes))) {
            return true;
        }

        $compiler->trigger_template_error("access to static class '{$class_name}' not allowed by security setting");
        return false; // should not, but who knows what happens to the compiler in the future?
    }

    /**
     * Check if PHP modifier is trusted.
     *
     * @param string $modifier_name
     * @param object $compiler compiler object
     * @return boolean true if modifier is trusted
     * @throws SmartyCompilerException if modifier is not trusted
     */
    public function isTrustedPhpModifier($modifier_name, $compiler)
    {
        if (isset($this->php_modifiers) && (empty($this->php_modifiers) || in_array($modifier_name, $this->php_modifiers))) {
            return true;
        }

        $compiler->trigger_template_error("modifier '{$modifier_name}' not allowed by security setting");
        return false; // should not, but who knows what happens to the compiler in the future?
    }

    /**
     * Check if tag is trusted.
     *
     * @param string $tag_name
     * @param object $compiler compiler object
     * @return boolean true if tag is trusted
     * @throws SmartyCompilerException if modifier is not trusted
     */
    public function isTrustedTag($tag_name, $compiler)
    {
        // check for internal always required tags
        if (in_array($tag_name, array('assign', 'call', 'private_filter', 'private_block_plugin', 'private_function_plugin', 'private_object_block_function',
                    'private_object_function', 'private_registered_function', 'private_registered_block', 'private_special_variable', 'private_print_expression', 'private_modifier'))) {
            return true;
        }
        // check security settings
        if (empty($this->allowed_tags)) {
            if (empty($this->disabled_tags) || !in_array($tag_name, $this->disabled_tags)) {
                return true;
            } else {
                $compiler->trigger_template_error("tag '{$tag_name}' disabled by security setting", $compiler->lex->taglineno);
            }
        } else if (in_array($tag_name, $this->allowed_tags) && !in_array($tag_name, $this->disabled_tags)) {
            return true;
        } else {
            $compiler->trigger_template_error("tag '{$tag_name}' not allowed by security setting", $compiler->lex->taglineno);
        }
        return false; // should not, but who knows what happens to the compiler in the future?
    }

    /**
     * Check if modifier plugin is trusted.
     *
     * @param string $modifier_name
     * @param object $compiler compiler object
     * @return boolean true if tag is trusted
     * @throws SmartyCompilerException if modifier is not trusted
     */
    public function isTrustedModifier($modifier_name, $compiler)
    {
        // check for internal always allowed modifier
        if (in_array($modifier_name, array('default'))) {
            return true;
        }
        // check security settings
        if (empty($this->allowed_modifiers)) {
            if (empty($this->disabled_modifiers) || !in_array($modifier_name, $this->disabled_modifiers)) {
                return true;
            } else {
                $compiler->trigger_template_error("modifier '{$modifier_name}' disabled by security setting", $compiler->lex->taglineno);
            }
        } else if (in_array($modifier_name, $this->allowed_modifiers) && !in_array($modifier_name, $this->disabled_modifiers)) {
            return true;
        } else {
            $compiler->trigger_template_error("modifier '{$modifier_name}' not allowed by security setting", $compiler->lex->taglineno);
        }
        return false; // should not, but who knows what happens to the compiler in the future?
    }

    /**
     * Check if stream is trusted.
     *
     * @param string $stream_name
     * @return boolean true if stream is trusted
     * @throws SmartyException if stream is not trusted
     */
    public function isTrustedStream($stream_name)
    {
        if (isset($this->streams) && (empty($this->streams) || in_array($stream_name, $this->streams))) {
            return true;
        }

        throw new SmartyException("stream '{$stream_name}' not allowed by security setting");
    }

    /**
     * Check if directory of file resource is trusted.
     *
     * @param string $filepath
     * @return boolean true if directory is trusted
     * @throws SmartyException if directory is not trusted
     */
    public function isTrustedResourceDir($filepath)
    {
        $_template = false;
        $_config = false;
        $_secure = false;

        $_template_dir = $this->smarty->getTemplateDir();
        $_config_dir = $this->smarty->getConfigDir();

        // check if index is outdated
        if ((!$this->_template_dir || $this->_template_dir !== $_template_dir)
                || (!$this->_config_dir || $this->_config_dir !== $_config_dir)
                || (!empty($this->secure_dir) && (!$this->_secure_dir || $this->_secure_dir !== $this->secure_dir))
        ) {
            $this->_resource_dir = array();
            $_template = true;
            $_config = true;
            $_secure = !empty($this->secure_dir);
        }

        // rebuild template dir index
        if ($_template) {
            $this->_template_dir = $_template_dir;
            foreach ($_template_dir as $directory) {
                $directory = realpath($directory);
                $this->_resource_dir[$directory] = true;
            }
        }

        // rebuild config dir index
        if ($_config) {
            $this->_config_dir = $_config_dir;
            foreach ($_config_dir as $directory) {
                $directory = realpath($directory);
                $this->_resource_dir[$directory] = true;
            }
        }

        // rebuild secure dir index
        if ($_secure) {
            $this->_secure_dir = $this->secure_dir;
            foreach ((array) $this->secure_dir as $directory) {
                $directory = realpath($directory);
                $this->_resource_dir[$directory] = true;
            }
        }

        $_filepath = realpath($filepath);
        $directory = dirname($_filepath);
        $_directory = array();
        while (true) {
            // remember the directory to add it to _resource_dir in case we're successful
            $_directory[] = $directory;
            // test if the directory is trusted
            if (isset($this->_resource_dir[$directory])) {
                // merge sub directories of current $directory into _resource_dir to speed up subsequent lookups
                $this->_resource_dir = array_merge($this->_resource_dir, $_directory);
                return true;
            }
            // abort if we've reached root
            if (($pos = strrpos($directory, DS)) === false || !isset($directory[1])) {
                break;
            }
            // bubble up one level
            $directory = substr($directory, 0, $pos);
        }

        // give up
        throw new SmartyException("directory '{$_filepath}' not allowed by security setting");
    }

    /**
     * Check if directory of file resource is trusted.
     *
     * @param string $filepath
     * @return boolean true if directory is trusted
     * @throws SmartyException if PHP directory is not trusted
     */
    public function isTrustedPHPDir($filepath)
    {
        if (empty($this->trusted_dir)) {
            throw new SmartyException("directory '{$filepath}' not allowed by security setting (no trusted_dir specified)");
        }

        // check if index is outdated
        if (!$this->_trusted_dir || $this->_trusted_dir !== $this->trusted_dir) {
            $this->_php_resource_dir = array();

            $this->_trusted_dir = $this->trusted_dir;
            foreach ((array) $this->trusted_dir as $directory) {
                $directory = realpath($directory);
                $this->_php_resource_dir[$directory] = true;
            }
        }

        $_filepath = realpath($filepath);
        $directory = dirname($_filepath);
        $_directory = array();
        while (true) {
            // remember the directory to add it to _resource_dir in case we're successful
            $_directory[] = $directory;
            // test if the directory is trusted
            if (isset($this->_php_resource_dir[$directory])) {
                // merge sub directories of current $directory into _resource_dir to speed up subsequent lookups
                $this->_php_resource_dir = array_merge($this->_php_resource_dir, $_directory);
                return true;
            }
            // abort if we've reached root
            if (($pos = strrpos($directory, DS)) === false || !isset($directory[2])) {
                break;
            }
            // bubble up one level
            $directory = substr($directory, 0, $pos);
        }

        throw new SmartyException("directory '{$_filepath}' not allowed by security setting");
    }

}

?><?php
/**
 * Smarty Internal Plugin Compile Function Plugin
 *
 * Compiles code for the execution of function plugin
 *
 * @package Smarty
 * @subpackage Compiler
 * @author Uwe Tews
 */

/**
 * Smarty Internal Plugin Compile Function Plugin Class
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_Private_Function_Plugin extends Smarty_Internal_CompileBase {

    /**
     * Attribute definition: Overwrites base class.
     *
     * @var array
     * @see Smarty_Internal_CompileBase
     */
    public $required_attributes = array();
    /**
     * Attribute definition: Overwrites base class.
     *
     * @var array
     * @see Smarty_Internal_CompileBase
     */
    public $optional_attributes = array('_any');

    /**
     * Compiles code for the execution of function plugin
     *
     * @param array $args array with attributes from parser
     * @param object $compiler compiler object
     * @param array $parameter array with compilation parameter
     * @param string $tag name of function plugin
     * @param string $function PHP function name
     * @return string compiled code
     */
    public function compile($args, $compiler, $parameter, $tag, $function)
    {
        // This tag does create output
        $compiler->has_output = true;

        // check and get attributes
        $_attr = $this->getAttributes($compiler, $args);
        if ($_attr['nocache'] === true) {
            $compiler->tag_nocache = true;
        }
        unset($_attr['nocache']);
        // convert attributes into parameter array string
        $_paramsArray = array();
        foreach ($_attr as $_key => $_value) {
            if (is_int($_key)) {
                $_paramsArray[] = "$_key=>$_value";
            } else {
                $_paramsArray[] = "'$_key'=>$_value";
            }
        }
        $_params = 'array(' . implode(",", $_paramsArray) . ')';
        // compile code
        $output = "<?php echo {$function}({$_params},\$_smarty_tpl);?>\n";
        return $output;
    }

}

?><?php
/**
 * Smarty Internal Plugin Compile Foreach
 *
 * Compiles the {foreach} {foreachelse} {/foreach} tags
 *
 * @package Smarty
 * @subpackage Compiler
 * @author Uwe Tews
 */

/**
 * Smarty Internal Plugin Compile Foreach Class
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_Foreach extends Smarty_Internal_CompileBase {
    /**
     * Attribute definition: Overwrites base class.
     *
     * @var array
     * @see Smarty_Internal_CompileBase
     */
    public $required_attributes = array('from', 'item');
    /**
     * Attribute definition: Overwrites base class.
     *
     * @var array
     * @see Smarty_Internal_CompileBase
     */
    public $optional_attributes = array('name', 'key');
    /**
     * Attribute definition: Overwrites base class.
     *
     * @var array
     * @see Smarty_Internal_CompileBase
     */
    public $shorttag_order = array('from','item','key','name');

    /**
     * Compiles code for the {foreach} tag
     *
     * @param array  $args      array with attributes from parser
     * @param object $compiler  compiler object
     * @param array  $parameter array with compilation parameter
     * @return string compiled code
     */
    public function compile($args, $compiler, $parameter)
    {
        $tpl = $compiler->template;
        // check and get attributes
        $_attr = $this->getAttributes($compiler, $args);

        $from = $_attr['from'];
        $item = $_attr['item'];
        if (!strncmp("\$_smarty_tpl->tpl_vars[$item]", $from, strlen($item) + 24)) {
            $compiler->trigger_template_error("item variable {$item} may not be the same variable as at 'from'", $compiler->lex->taglineno);
        }

        if (isset($_attr['key'])) {
            $key = $_attr['key'];
        } else {
            $key = null;
        }

        $this->openTag($compiler, 'foreach', array('foreach', $compiler->nocache, $item, $key));
        // maybe nocache because of nocache variables
        $compiler->nocache = $compiler->nocache | $compiler->tag_nocache;

        if (isset($_attr['name'])) {
            $name = $_attr['name'];
            $has_name = true;
            $SmartyVarName = '$smarty.foreach.' . trim($name, '\'"') . '.';
        } else {
            $name = null;
            $has_name = false;
        }
        $ItemVarName = '$' . trim($item, '\'"') . '@';
        // evaluates which Smarty variables and properties have to be computed
        if ($has_name) {
            $usesSmartyFirst = strpos($tpl->source->content, $SmartyVarName . 'first') !== false;
            $usesSmartyLast = strpos($tpl->source->content, $SmartyVarName . 'last') !== false;
            $usesSmartyIndex = strpos($tpl->source->content, $SmartyVarName . 'index') !== false;
            $usesSmartyIteration = strpos($tpl->source->content, $SmartyVarName . 'iteration') !== false;
            $usesSmartyShow = strpos($tpl->source->content, $SmartyVarName . 'show') !== false;
            $usesSmartyTotal = strpos($tpl->source->content, $SmartyVarName . 'total') !== false;
        } else {
            $usesSmartyFirst = false;
            $usesSmartyLast = false;
            $usesSmartyTotal = false;
            $usesSmartyShow = false;
        }

        $usesPropFirst = $usesSmartyFirst || strpos($tpl->source->content, $ItemVarName . 'first') !== false;
        $usesPropLast = $usesSmartyLast || strpos($tpl->source->content, $ItemVarName . 'last') !== false;
        $usesPropIndex = $usesPropFirst || strpos($tpl->source->content, $ItemVarName . 'index') !== false;
        $usesPropIteration = $usesPropLast || strpos($tpl->source->content, $ItemVarName . 'iteration') !== false;
        $usesPropShow = strpos($tpl->source->content, $ItemVarName . 'show') !== false;
        $usesPropTotal = $usesSmartyTotal || $usesSmartyShow || $usesPropShow || $usesPropLast || strpos($tpl->source->content, $ItemVarName . 'total') !== false;
        // generate output code
        $output = "<?php ";
        $output .= " \$_smarty_tpl->tpl_vars[$item] = new Smarty_Variable; \$_smarty_tpl->tpl_vars[$item]->_loop = false;\n";
        if ($key != null) {
            $output .= " \$_smarty_tpl->tpl_vars[$key] = new Smarty_Variable;\n";
        }
        $output .= " \$_from = $from; if (!is_array(\$_from) && !is_object(\$_from)) { settype(\$_from, 'array');}\n";
        if ($usesPropTotal) {
            $output .= " \$_smarty_tpl->tpl_vars[$item]->total= \$_smarty_tpl->_count(\$_from);\n";
        }
        if ($usesPropIteration) {
            $output .= " \$_smarty_tpl->tpl_vars[$item]->iteration=0;\n";
        }
        if ($usesPropIndex) {
            $output .= " \$_smarty_tpl->tpl_vars[$item]->index=-1;\n";
        }
        if ($usesPropShow) {
            $output .= " \$_smarty_tpl->tpl_vars[$item]->show = (\$_smarty_tpl->tpl_vars[$item]->total > 0);\n";
        }
        if ($has_name) {
            if ($usesSmartyTotal) {
                $output .= " \$_smarty_tpl->tpl_vars['smarty']->value['foreach'][$name]['total'] = \$_smarty_tpl->tpl_vars[$item]->total;\n";
            }
            if ($usesSmartyIteration) {
                $output .= " \$_smarty_tpl->tpl_vars['smarty']->value['foreach'][$name]['iteration']=0;\n";
            }
            if ($usesSmartyIndex) {
                $output .= " \$_smarty_tpl->tpl_vars['smarty']->value['foreach'][$name]['index']=-1;\n";
            }
            if ($usesSmartyShow) {
                $output .= " \$_smarty_tpl->tpl_vars['smarty']->value['foreach'][$name]['show']=(\$_smarty_tpl->tpl_vars[$item]->total > 0);\n";
            }
        }
        $output .= "foreach (\$_from as \$_smarty_tpl->tpl_vars[$item]->key => \$_smarty_tpl->tpl_vars[$item]->value){\n\$_smarty_tpl->tpl_vars[$item]->_loop = true;\n";
        if ($key != null) {
            $output .= " \$_smarty_tpl->tpl_vars[$key]->value = \$_smarty_tpl->tpl_vars[$item]->key;\n";
        }
        if ($usesPropIteration) {
            $output .= " \$_smarty_tpl->tpl_vars[$item]->iteration++;\n";
        }
        if ($usesPropIndex) {
            $output .= " \$_smarty_tpl->tpl_vars[$item]->index++;\n";
        }
        if ($usesPropFirst) {
            $output .= " \$_smarty_tpl->tpl_vars[$item]->first = \$_smarty_tpl->tpl_vars[$item]->index === 0;\n";
        }
        if ($usesPropLast) {
            $output .= " \$_smarty_tpl->tpl_vars[$item]->last = \$_smarty_tpl->tpl_vars[$item]->iteration === \$_smarty_tpl->tpl_vars[$item]->total;\n";
        }
        if ($has_name) {
            if ($usesSmartyFirst) {
                $output .= " \$_smarty_tpl->tpl_vars['smarty']->value['foreach'][$name]['first'] = \$_smarty_tpl->tpl_vars[$item]->first;\n";
            }
            if ($usesSmartyIteration) {
                $output .= " \$_smarty_tpl->tpl_vars['smarty']->value['foreach'][$name]['iteration']++;\n";
            }
            if ($usesSmartyIndex) {
                $output .= " \$_smarty_tpl->tpl_vars['smarty']->value['foreach'][$name]['index']++;\n";
            }
            if ($usesSmartyLast) {
                $output .= " \$_smarty_tpl->tpl_vars['smarty']->value['foreach'][$name]['last'] = \$_smarty_tpl->tpl_vars[$item]->last;\n";
            }
        }
        $output .= "?>";

        return $output;
    }
}

/**
 * Smarty Internal Plugin Compile Foreachelse Class
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_Foreachelse extends Smarty_Internal_CompileBase {

    /**
     * Compiles code for the {foreachelse} tag
     *
     * @param array  $args array with attributes from parser
     * @param object $compiler compiler object
     * @param array  $parameter array with compilation parameter
     * @return string compiled code
     */
    public function compile($args, $compiler, $parameter)
    {
        // check and get attributes
        $_attr = $this->getAttributes($compiler, $args);

        list($openTag, $nocache, $item, $key) = $this->closeTag($compiler, array('foreach'));
        $this->openTag($compiler, 'foreachelse', array('foreachelse', $nocache, $item, $key));

        return "<?php }\nif (!\$_smarty_tpl->tpl_vars[$item]->_loop) {\n?>";
    }

}

/**
 * Smarty Internal Plugin Compile Foreachclose Class
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_Foreachclose extends Smarty_Internal_CompileBase {

    /**
     * Compiles code for the {/foreach} tag
     *
     * @param array  $args      array with attributes from parser
     * @param object $compiler  compiler object
     * @param array  $parameter array with compilation parameter
     * @return string compiled code
     */
    public function compile($args, $compiler, $parameter)
    {
        // check and get attributes
        $_attr = $this->getAttributes($compiler, $args);
        // must endblock be nocache?
        if ($compiler->nocache) {
            $compiler->tag_nocache = true;
        }

        list($openTag, $compiler->nocache, $item, $key) = $this->closeTag($compiler, array('foreach', 'foreachelse'));

        return "<?php } ?>";
    }

}

?><?php
/**
 * Smarty Internal Plugin Resource Registered
 *
 * @package Smarty
 * @subpackage TemplateResources
 * @author Uwe Tews
 * @author Rodney Rehm
 */

/**
 * Smarty Internal Plugin Resource Registered
 *
 * Implements the registered resource for Smarty template
 *
 * @package Smarty
 * @subpackage TemplateResources
 * @deprecated
 */
class Smarty_Internal_Resource_Registered extends Smarty_Resource {

    /**
     * populate Source Object with meta data from Resource
     *
     * @param Smarty_Template_Source   $source    source object
     * @param Smarty_Internal_Template $_template template object
     * @return void
     */
    public function populate(Smarty_Template_Source $source, Smarty_Internal_Template $_template=null)
    {
        $source->filepath = $source->type . ':' . $source->name;
        $source->uid = sha1($source->filepath);
        if ($source->smarty->compile_check) {
            $source->timestamp = $this->getTemplateTimestamp($source);
            $source->exists = !!$source->timestamp;
        }
    }

    /**
     * populate Source Object with timestamp and exists from Resource
     *
     * @param Smarty_Template_Source $source source object
     * @return void
     */
    public function populateTimestamp(Smarty_Template_Source $source)
    {
        $source->timestamp = $this->getTemplateTimestamp($source);
        $source->exists = !!$source->timestamp;
    }

    /**
     * Get timestamp (epoch) the template source was modified
     *
     * @param Smarty_Template_Source $source source object
     * @return integer|boolean timestamp (epoch) the template was modified, false if resources has no timestamp
     */
    public function getTemplateTimestamp(Smarty_Template_Source $source)
    {
        // return timestamp
        $time_stamp = false;
        call_user_func_array($source->smarty->registered_resources[$source->type][0][1], array($source->name, &$time_stamp, $source->smarty));
        return is_numeric($time_stamp) ? (int) $time_stamp : $time_stamp;
    }

    /**
     * Load template's source by invoking the registered callback into current template object
     *
     * @param Smarty_Template_Source $source source object
     * @return string template source
     * @throws SmartyException if source cannot be loaded
     */
    public function getContent(Smarty_Template_Source $source)
    {
        // return template string
        $t = call_user_func_array($source->smarty->registered_resources[$source->type][0][0], array($source->name, &$source->content, $source->smarty));
        if (is_bool($t) && !$t) {
            throw new SmartyException("Unable to read template {$source->type} '{$source->name}'");
        }
        return $source->content;
    }

    /**
     * Determine basename for compiled filename
     *
     * @param Smarty_Template_Source $source source object
     * @return string resource's basename
     */
    protected function getBasename(Smarty_Template_Source $source)
    {
        return basename($source->name);
    }

}

?><?php
/**
 * Smarty Internal Plugin
 *
 * @package Smarty
 * @subpackage Cacher
 */

/**
 * Smarty Cache Handler Base for Key/Value Storage Implementations
 *
 * This class implements the functionality required to use simple key/value stores
 * for hierarchical cache groups. key/value stores like memcache or APC do not support
 * wildcards in keys, therefore a cache group cannot be cleared like "a|*" - which
 * is no problem to filesystem and RDBMS implementations.
 *
 * This implementation is based on the concept of invalidation. While one specific cache
 * can be identified and cleared, any range of caches cannot be identified. For this reason
 * each level of the cache group hierarchy can have its own value in the store. These values
 * are nothing but microtimes, telling us when a particular cache group was cleared for the
 * last time. These keys are evaluated for every cache read to determine if the cache has
 * been invalidated since it was created and should hence be treated as inexistent.
 *
 * Although deep hierarchies are possible, they are not recommended. Try to keep your
 * cache groups as shallow as possible. Anything up 3-5 parents should be ok. So
 * »a|b|c« is a good depth where »a|b|c|d|e|f|g|h|i|j|k« isn't. Try to join correlating
 * cache groups: if your cache groups look somewhat like »a|b|$page|$items|$whatever«
 * consider using »a|b|c|$page-$items-$whatever« instead.
 *
 * @package Smarty
 * @subpackage Cacher
 * @author Rodney Rehm
 */
abstract class Smarty_CacheResource_KeyValueStore extends Smarty_CacheResource {

    /**
     * cache for contents
     * @var array
     */
    protected $contents = array();
    /**
     * cache for timestamps
     * @var array
     */
    protected $timestamps = array();

    /**
     * populate Cached Object with meta data from Resource
     *
     * @param Smarty_Template_Cached   $cached    cached object
     * @param Smarty_Internal_Template $_template template object
     * @return void
     */
    public function populate(Smarty_Template_Cached $cached, Smarty_Internal_Template $_template)
    {
        $cached->filepath = $_template->source->uid
                . '#' . $this->sanitize($cached->source->name)
                . '#' . $this->sanitize($cached->cache_id)
                . '#' . $this->sanitize($cached->compile_id);

        $this->populateTimestamp($cached);
    }

    /**
     * populate Cached Object with timestamp and exists from Resource
     *
     * @param Smarty_Template_Cached $cached cached object
     * @return void
     */
    public function populateTimestamp(Smarty_Template_Cached $cached)
    {
        if (!$this->fetch($cached->filepath, $cached->source->name, $cached->cache_id, $cached->compile_id, $content, $timestamp, $cached->source->uid)) {
            return;
        }
        $cached->content = $content;
        $cached->timestamp = (int) $timestamp;
        $cached->exists = $cached->timestamp;
    }

    /**
     * Read the cached template and process the header
     *
     * @param Smarty_Internal_Template $_template template object
     * @param Smarty_Template_Cached $cached cached object
     * @return booelan true or false if the cached content does not exist
     */
    public function process(Smarty_Internal_Template $_template, Smarty_Template_Cached $cached=null)
    {
        if (!$cached) {
            $cached = $_template->cached;
        }
        $content = $cached->content ? $cached->content : null;
        $timestamp = $cached->timestamp ? $cached->timestamp : null;
        if ($content === null || !$timestamp) {
            if (!$this->fetch($_template->cached->filepath, $_template->source->name, $_template->cache_id, $_template->compile_id, $content, $timestamp, $_template->source->uid)) {
                return false;
            }
        }
        if (isset($content)) {
            $_smarty_tpl = $_template;
            eval("?>" . $content);
            return true;
        }
        return false;
    }

    /**
     * Write the rendered template output to cache
     *
     * @param Smarty_Internal_Template $_template template object
     * @param string $content content to cache
     * @return boolean success
     */
    public function writeCachedContent(Smarty_Internal_Template $_template, $content)
    {
        $this->addMetaTimestamp($content);
        return $this->write(array($_template->cached->filepath => $content), $_template->properties['cache_lifetime']);
    }

    /**
     * Empty cache
     *
     * {@internal the $exp_time argument is ignored altogether }}
     *
     * @param Smarty  $smarty   Smarty object
     * @param integer $exp_time expiration time [being ignored]
     * @return integer number of cache files deleted [always -1]
     * @uses purge() to clear the whole store
     * @uses invalidate() to mark everything outdated if purge() is inapplicable
     */
    public function clearAll(Smarty $smarty, $exp_time=null)
    {
        if (!$this->purge()) {
            $this->invalidate(null);
        }
        return -1;
    }

    /**
     * Empty cache for a specific template
     *
     * {@internal the $exp_time argument is ignored altogether}}
     *
     * @param Smarty  $smarty        Smarty object
     * @param string  $resource_name template name
     * @param string  $cache_id      cache id
     * @param string  $compile_id    compile id
     * @param integer $exp_time      expiration time [being ignored]
     * @return integer number of cache files deleted [always -1]
     * @uses buildCachedFilepath() to generate the CacheID
     * @uses invalidate() to mark CacheIDs parent chain as outdated
     * @uses delete() to remove CacheID from cache
     */
    public function clear(Smarty $smarty, $resource_name, $cache_id, $compile_id, $exp_time)
    {
        $uid = $this->getTemplateUid($smarty, $resource_name, $cache_id, $compile_id);
        $cid = $uid . '#' . $this->sanitize($resource_name) . '#' . $this->sanitize($cache_id) . '#' . $this->sanitize($compile_id);
        $this->delete(array($cid));
        $this->invalidate($cid, $resource_name, $cache_id, $compile_id, $uid);
        return -1;
    }
    /**
     * Get template's unique ID
     *
     * @param Smarty $smarty        Smarty object
     * @param string $resource_name template name
     * @param string $cache_id      cache id
     * @param string $compile_id    compile id
     * @return string filepath of cache file
     */
    protected function getTemplateUid(Smarty $smarty, $resource_name, $cache_id, $compile_id)
    {
        $uid = '';
        if (isset($resource_name)) {
            $tpl = new $smarty->template_class($resource_name, $smarty);
            if ($tpl->source->exists) {
                $uid = $tpl->source->uid;
            }
            
            // remove from template cache
            $_templateId = sha1($tpl->source->unique_resource . $tpl->cache_id . $tpl->compile_id);
            unset($smarty->template_objects[$_templateId]);
        }
        return $uid;
    }

    /**
     * Sanitize CacheID components
     *
     * @param string $string CacheID component to sanitize
     * @return string sanitized CacheID component
     */
    protected function sanitize($string)
    {
        // some poeple smoke bad weed
        $string = trim($string, '|');
        if (!$string) {
            return null;
        }
        return preg_replace('#[^\w\|]+#S', '_', $string);
    }

    /**
     * Fetch and prepare a cache object.
     *
     * @param string  $cid           CacheID to fetch
     * @param string  $resource_name template name
     * @param string  $cache_id      cache id
     * @param string  $compile_id    compile id
     * @param string  $content       cached content
     * @param integer &$timestamp    cached timestamp (epoch)
     * @param string  $resource_uid  resource's uid
     * @return boolean success
     */
    protected function fetch($cid, $resource_name = null, $cache_id = null, $compile_id = null, &$content = null, &$timestamp = null, $resource_uid = null)
    {
        $t = $this->read(array($cid));
        $content = !empty($t[$cid]) ? $t[$cid] : null;
        $timestamp = null;

        if ($content && ($timestamp = $this->getMetaTimestamp($content))) {
            $invalidated = $this->getLatestInvalidationTimestamp($cid, $resource_name, $cache_id, $compile_id, $resource_uid);
            if ($invalidated > $timestamp) {
                $timestamp = null;
                $content = null;
            }
        }

        return !!$content;
    }

    /**
     * Add current microtime to the beginning of $cache_content
     *
     * {@internal the header uses 8 Bytes, the first 4 Bytes are the seconds, the second 4 Bytes are the microseconds}}
     *
     * @param string &$content the content to be cached
     */
    protected function addMetaTimestamp(&$content)
    {
        $mt = explode(" ", microtime());
        $ts = pack("NN", $mt[1], (int) ($mt[0] * 100000000));
        $content = $ts . $content;
    }

    /**
     * Extract the timestamp the $content was cached
     *
     * @param string &$content the cached content
     * @return float the microtime the content was cached
     */
    protected function getMetaTimestamp(&$content)
    {
        $s = unpack("N", substr($content, 0, 4));
        $m = unpack("N", substr($content, 4, 4));
        $content = substr($content, 8);
        return $s[1] + ($m[1] / 100000000);
    }

    /**
     * Invalidate CacheID
     *
     * @param string $cid           CacheID
     * @param string $resource_name template name
     * @param string $cache_id      cache id
     * @param string $compile_id    compile id
     * @param string $resource_uid  source's uid
     * @return void
     */
    protected function invalidate($cid = null, $resource_name = null, $cache_id = null, $compile_id = null, $resource_uid = null)
    {
        $now = microtime(true);
        $key = null;
        // invalidate everything
        if (!$resource_name && !$cache_id && !$compile_id) {
            $key = 'IVK#ALL';
        }
        // invalidate all caches by template
        else if ($resource_name && !$cache_id && !$compile_id) {
            $key = 'IVK#TEMPLATE#' . $resource_uid . '#' . $this->sanitize($resource_name);
        }
        // invalidate all caches by cache group
        else if (!$resource_name && $cache_id && !$compile_id) {
            $key = 'IVK#CACHE#' . $this->sanitize($cache_id);
        }
        // invalidate all caches by compile id
        else if (!$resource_name && !$cache_id && $compile_id) {
            $key = 'IVK#COMPILE#' . $this->sanitize($compile_id);
        }
        // invalidate by combination
        else {
            $key = 'IVK#CID#' . $cid;
        }
        $this->write(array($key => $now));
    }

    /**
     * Determine the latest timestamp known to the invalidation chain
     *
     * @param string $cid           CacheID to determine latest invalidation timestamp of
     * @param string $resource_name template name
     * @param string $cache_id      cache id
     * @param string $compile_id    compile id
     * @param string $resource_uid  source's filepath
     * @return float the microtime the CacheID was invalidated
     */
    protected function getLatestInvalidationTimestamp($cid, $resource_name = null, $cache_id = null, $compile_id = null, $resource_uid = null)
    {
        // abort if there is no CacheID
        if (false && !$cid) {
            return 0;
        }
        // abort if there are no InvalidationKeys to check
        if (!($_cid = $this->listInvalidationKeys($cid, $resource_name, $cache_id, $compile_id, $resource_uid))) {
            return 0;
        }
        
        // there are no InValidationKeys
        if (!($values = $this->read($_cid))) {
            return 0;
        }
        // make sure we're dealing with floats
        $values = array_map('floatval', $values);
        return max($values);
    }

    /**
     * Translate a CacheID into the list of applicable InvalidationKeys.
     *
     * Splits "some|chain|into|an|array" into array( '#clearAll#', 'some', 'some|chain', 'some|chain|into', ... )
     *
     * @param string $cid           CacheID to translate
     * @param string $resource_name template name
     * @param string $cache_id      cache id
     * @param string $compile_id    compile id
     * @param string $resource_uid  source's filepath
     * @return array list of InvalidationKeys
     * @uses $invalidationKeyPrefix to prepend to each InvalidationKey
     */
    protected function listInvalidationKeys($cid, $resource_name = null, $cache_id = null, $compile_id = null, $resource_uid = null)
    {
        $t = array('IVK#ALL');
        $_name = $_compile = '#';
        if ($resource_name) {
            $_name .= $resource_uid . '#' . $this->sanitize($resource_name);
            $t[] = 'IVK#TEMPLATE' . $_name;
        }
        if ($compile_id) {
            $_compile .= $this->sanitize($compile_id);
            $t[] = 'IVK#COMPILE' . $_compile;
        }
        $_name .= '#';
        // some poeple smoke bad weed
        $cid = trim($cache_id, '|');
        if (!$cid) {
            return $t;
        }
        $i = 0;
        while (true) {
            // determine next delimiter position
            $i = strpos($cid, '|', $i);
            // add complete CacheID if there are no more delimiters
            if ($i === false) {
                $t[] = 'IVK#CACHE#' . $cid;
                $t[] = 'IVK#CID' . $_name . $cid . $_compile;
                $t[] = 'IVK#CID' . $_name . $_compile;
                break;
            }
            $part = substr($cid, 0, $i);
            // add slice to list
            $t[] = 'IVK#CACHE#' . $part;
            $t[] = 'IVK#CID' . $_name . $part . $_compile;
            // skip past delimiter position
            $i++;
        }
        return $t;
    }

    /**
     * Check is cache is locked for this template
     *
     * @param Smarty $smarty Smarty object
     * @param Smarty_Template_Cached $cached cached object
     * @return booelan true or false if cache is locked
     */
    public function hasLock(Smarty $smarty, Smarty_Template_Cached $cached)
    {
        $key = 'LOCK#' . $cached->filepath;
        $data = $this->read(array($key));
        return $data && time() - $data[$key] < $smarty->locking_timeout;
    }

    /**
     * Lock cache for this template
     *
     * @param Smarty $smarty Smarty object
     * @param Smarty_Template_Cached $cached cached object
     */
    public function acquireLock(Smarty $smarty, Smarty_Template_Cached $cached)
    {
        $cached->is_locked = true;
        $key = 'LOCK#' . $cached->filepath;
        $this->write(array($key => time()), $smarty->locking_timeout);
    }

    /**
     * Unlock cache for this template
     *
     * @param Smarty $smarty Smarty object
     * @param Smarty_Template_Cached $cached cached object
     */
    public function releaseLock(Smarty $smarty, Smarty_Template_Cached $cached)
    {
        $cached->is_locked = false;
        $key = 'LOCK#' . $cached->filepath;
        $this->delete(array($key));
    }

    /**
     * Read values for a set of keys from cache
     *
     * @param array $keys list of keys to fetch
     * @return array list of values with the given keys used as indexes
     */
    protected abstract function read(array $keys);

    /**
     * Save values for a set of keys to cache
     *
     * @param array $keys   list of values to save
     * @param int   $expire expiration time
     * @return boolean true on success, false on failure
     */
    protected abstract function write(array $keys, $expire=null);

    /**
     * Remove values from cache
     *
     * @param array $keys list of keys to delete
     * @return boolean true on success, false on failure
     */
    protected abstract function delete(array $keys);

    /**
     * Remove *all* values from cache
     *
     * @return boolean true on success, false on failure
     */
    protected function purge()
    {
        return false;
    }

}

?><?php
/**
 * Smarty Internal Plugin Compile Special Smarty Variable
 *
 * Compiles the special $smarty variables
 *
 * @package Smarty
 * @subpackage Compiler
 * @author Uwe Tews
 */

/**
 * Smarty Internal Plugin Compile special Smarty Variable Class
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_Private_Special_Variable extends Smarty_Internal_CompileBase {

    /**
     * Compiles code for the speical $smarty variables
     *
     * @param array  $args     array with attributes from parser
     * @param object $compiler compiler object
     * @return string compiled code
     */
    public function compile($args, $compiler, $parameter)
    {
        $_index = preg_split("/\]\[/",substr($parameter, 1, strlen($parameter)-2));
        $compiled_ref = ' ';
        $variable = trim($_index[0], "'");
        switch ($variable) {
            case 'foreach':
                return "\$_smarty_tpl->getVariable('smarty')->value$parameter";
            case 'section':
                return "\$_smarty_tpl->getVariable('smarty')->value$parameter";
            case 'capture':
                return "Smarty::\$_smarty_vars$parameter";
            case 'now':
                return 'time()';
            case 'cookies':
                if (isset($compiler->smarty->security_policy) && !$compiler->smarty->security_policy->allow_super_globals) {
                    $compiler->trigger_template_error("(secure mode) super globals not permitted");
                    break;
                }
                $compiled_ref = '$_COOKIE';
                break;

            case 'get':
            case 'post':
            case 'env':
            case 'server':
            case 'session':
            case 'request':
                if (isset($compiler->smarty->security_policy) && !$compiler->smarty->security_policy->allow_super_globals) {
                    $compiler->trigger_template_error("(secure mode) super globals not permitted");
                    break;
                }
                $compiled_ref = '$_'.strtoupper($variable);
                break;

            case 'template':
                return 'basename($_smarty_tpl->source->filepath)';

            case 'current_dir':
                return 'dirname($_smarty_tpl->source->filepath)';

            case 'version':
                $_version = Smarty::SMARTY_VERSION;
                return "'$_version'";

            case 'const':
                if (isset($compiler->smarty->security_policy) && !$compiler->smarty->security_policy->allow_constants) {
                    $compiler->trigger_template_error("(secure mode) constants not permitted");
                    break;
                }
                return '@' . trim($_index[1], "'");

            case 'config':
                return "\$_smarty_tpl->getConfigVariable($_index[1])";
            case 'ldelim':
                $_ldelim = $compiler->smarty->left_delimiter;
                return "'$_ldelim'";

            case 'rdelim':
                $_rdelim = $compiler->smarty->right_delimiter;
                return "'$_rdelim'";

            default:
                $compiler->trigger_template_error('$smarty.' . trim($_index[0], "'") . ' is invalid');
                break;
        }
        if (isset($_index[1])) {
            array_shift($_index);
            foreach ($_index as $_ind) {
                $compiled_ref = $compiled_ref . "[$_ind]";
            }
        }
        return $compiled_ref;
    }

}

?><?php
/**
 * Smarty Internal Plugin Compile Debug
 *
 * Compiles the {debug} tag.
 * It opens a window the the Smarty Debugging Console.
 *
 * @package Smarty
 * @subpackage Compiler
 * @author Uwe Tews
 */

/**
 * Smarty Internal Plugin Compile Debug Class
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_Debug extends Smarty_Internal_CompileBase {

    /**
     * Compiles code for the {debug} tag
     *
     * @param array  $args     array with attributes from parser
     * @param object $compiler compiler object
     * @return string compiled code
     */
    public function compile($args, $compiler)
    {
        // check and get attributes
        $_attr = $this->getAttributes($compiler, $args);

        // compile always as nocache
        $compiler->tag_nocache = true;

        // display debug template
        $_output = "<?php \$_smarty_tpl->smarty->loadPlugin('Smarty_Internal_Debug'); Smarty_Internal_Debug::display_debug(\$_smarty_tpl); ?>";
        return $_output;
    }

}

?><?php
/**
* Smarty Internal Plugin Resource Extends
*
* @package Smarty
* @subpackage TemplateResources
* @author Uwe Tews
* @author Rodney Rehm
*/

/**
* Smarty Internal Plugin Resource Extends
*
* Implements the file system as resource for Smarty which {extend}s a chain of template files templates
*
* @package Smarty
* @subpackage TemplateResources
*/
class Smarty_Internal_Resource_Extends extends Smarty_Resource {

    /**
    * populate Source Object with meta data from Resource
    *
    * @param Smarty_Template_Source   $source    source object
    * @param Smarty_Internal_Template $_template template object
    */
    public function populate(Smarty_Template_Source $source, Smarty_Internal_Template $_template=null)
    {
        $uid = '';
        $sources = array();
        $components = explode('|', $source->name);
        $exists = true;
        foreach ($components as $component) {
            $s = Smarty_Resource::source(null, $source->smarty, $component);
            if ($s->type == 'php') {
                throw new SmartyException("Resource type {$s->type} cannot be used with the extends resource type");
            }
            $sources[$s->uid] = $s;
            $uid .= $s->filepath;
            if ($_template && $_template->smarty->compile_check) {
                $exists == $exists && $s->exists;
            }
        }
        $source->components = $sources;
        $source->filepath = $s->filepath;
        $source->uid = sha1($uid);
        if ($_template && $_template->smarty->compile_check) {
            $source->timestamp = $s->timestamp;
            $source->exists = $exists;
        }
        // need the template at getContent()
        $source->template = $_template;
    }

    /**
    * populate Source Object with timestamp and exists from Resource
    *
    * @param Smarty_Template_Source $source source object
    */
    public function populateTimestamp(Smarty_Template_Source $source)
    {
        $source->exists = true;
        foreach ($source->components as $s) {
            $source->exists == $source->exists && $s->exists;
        }
        $source->timestamp = $s->timestamp;
    }

    /**
    * Load template's source from files into current template object
    *
    * @param Smarty_Template_Source $source source object
    * @return string template source
    * @throws SmartyException if source cannot be loaded
    */
    public function getContent(Smarty_Template_Source $source)
    {
        if (!$source->exists) {
            throw new SmartyException("Unable to read template {$source->type} '{$source->name}'");
        }

        $_rdl = preg_quote($source->smarty->right_delimiter);
        $_ldl = preg_quote($source->smarty->left_delimiter);
        $_components = array_reverse($source->components);
        $_first = reset($_components);
        $_last = end($_components);

        foreach ($_components as $_component) {
            // register dependency
            if ($_component != $_first) {
                $source->template->properties['file_dependency'][$_component->uid] = array($_component->filepath, $_component->timestamp, $_component->type);
            }

            // read content
            $source->filepath = $_component->filepath;
            $_content = $_component->content;

            // extend sources
            if ($_component != $_last) {
                if (preg_match_all("!({$_ldl}block\s(.+?){$_rdl})!", $_content, $_open) !=
                preg_match_all("!({$_ldl}/block{$_rdl})!", $_content, $_close)) {
                    throw new SmartyException("unmatched {block} {/block} pairs in template {$_component->type} '{$_component->name}'");
                }
                preg_match_all("!{$_ldl}block\s(.+?){$_rdl}|{$_ldl}/block{$_rdl}|{$_ldl}\*([\S\s]*?)\*{$_rdl}!", $_content, $_result, PREG_OFFSET_CAPTURE);
                $_result_count = count($_result[0]);
                $_start = 0;
                while ($_start+1 < $_result_count) {
                    $_end = 0;
                    $_level = 1;
                    if (substr($_result[0][$_start][0],0,strlen($source->smarty->left_delimiter)+1) == $source->smarty->left_delimiter.'*') {
                        $_start++;
                        continue;
                    }
                    while ($_level != 0) {
                        $_end++;
                        if (substr($_result[0][$_start + $_end][0],0,strlen($source->smarty->left_delimiter)+1) == $source->smarty->left_delimiter.'*') {
                            continue;
                        }
                        if (!strpos($_result[0][$_start + $_end][0], '/')) {
                            $_level++;
                        } else {
                            $_level--;
                        }
                    }
                    $_block_content = str_replace($source->smarty->left_delimiter . '$smarty.block.parent' . $source->smarty->right_delimiter, '%%%%SMARTY_PARENT%%%%', substr($_content, $_result[0][$_start][1] + strlen($_result[0][$_start][0]), $_result[0][$_start + $_end][1] - $_result[0][$_start][1] - + strlen($_result[0][$_start][0])));
                    Smarty_Internal_Compile_Block::saveBlockData($_block_content, $_result[0][$_start][0], $source->template, $_component->filepath);
                    $_start = $_start + $_end + 1;
                }
            } else {
                return $_content;
            }
        }
    }

    /**
    * Determine basename for compiled filename
    *
    * @param Smarty_Template_Source $source source object
    * @return string resource's basename
    */
    public function getBasename(Smarty_Template_Source $source)
    {
        return str_replace(':', '.', basename($source->filepath));
    }

}

?><?php
/**
 * Smarty read include path plugin
 *
 * @package Smarty
 * @subpackage PluginsInternal
 * @author Monte Ohrt
 */

/**
 * Smarty Internal Read Include Path Class
 *
 * @package Smarty
 * @subpackage PluginsInternal
 */
class Smarty_Internal_Get_Include_Path {

    /**
     * Return full file path from PHP include_path
     *
     * @param string $filepath filepath
     * @return string|boolean full filepath or false
     */
    public static function getIncludePath($filepath)
    {
        static $_include_path = null;

        if ($_path_array === null) {
            $_include_path = explode(PATH_SEPARATOR, get_include_path());
        }

        foreach ($_include_path as $_path) {
            if (file_exists($_path . DS . $filepath)) {
                return $_path . DS . $filepath;
            }
        }
        
        return false;
    }

}

?><?php
/**
 * Smarty Internal Plugin Compile Function_Call
 *
 * Compiles the calls of user defined tags defined by {function}
 *
 * @package Smarty
 * @subpackage Compiler
 * @author Uwe Tews
 */

/**
 * Smarty Internal Plugin Compile Function_Call Class
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_Call extends Smarty_Internal_CompileBase {

    /**
     * Attribute definition: Overwrites base class.
     *
     * @var array
     * @see Smarty_Internal_CompileBase
     */
    public $required_attributes = array('name');
    /**
     * Attribute definition: Overwrites base class.
     *
     * @var array
     * @see Smarty_Internal_CompileBase
     */
    public $shorttag_order = array('name');
    /**
     * Attribute definition: Overwrites base class.
     *
     * @var array
     * @see Smarty_Internal_CompileBase
     */
    public $optional_attributes = array('_any');

    /**
     * Compiles the calls of user defined tags defined by {function}
     *
     * @param array  $args      array with attributes from parser
     * @param object $compiler  compiler object
     * @param array  $parameter array with compilation parameter
     * @return string compiled code
     */
    public function compile($args, $compiler)
    {
        // check and get attributes
        $_attr = $this->getAttributes($compiler, $args);
        // save possible attributes
        if (isset($_attr['assign'])) {
            // output will be stored in a smarty variable instead of beind displayed
            $_assign = $_attr['assign'];
        }
        $_name = $_attr['name'];
        if ($compiler->compiles_template_function) {
            $compiler->called_functions[] = trim($_name, "'\"");
        }
        unset($_attr['name'], $_attr['assign'], $_attr['nocache']);
        // set flag (compiled code of {function} must be included in cache file
        if ($compiler->nocache || $compiler->tag_nocache) {
            $_nocache = 'true';
        } else {
            $_nocache = 'false';
        }
        $_paramsArray = array();
        foreach ($_attr as $_key => $_value) {
            if (is_int($_key)) {
                $_paramsArray[] = "$_key=>$_value";
            } else {
                $_paramsArray[] = "'$_key'=>$_value";
            }
        }
        if (isset($compiler->template->properties['function'][$_name]['parameter'])) {
            foreach ($compiler->template->properties['function'][$_name]['parameter'] as $_key => $_value) {
                if (!isset($_attr[$_key])) {
                    if (is_int($_key)) {
                        $_paramsArray[] = "$_key=>$_value";
                    } else {
                        $_paramsArray[] = "'$_key'=>$_value";
                    }
                }
            }
        } elseif (isset($compiler->smarty->template_functions[$_name]['parameter'])) {
            foreach ($compiler->smarty->template_functions[$_name]['parameter'] as $_key => $_value) {
                if (!isset($_attr[$_key])) {
                    if (is_int($_key)) {
                        $_paramsArray[] = "$_key=>$_value";
                    } else {
                        $_paramsArray[] = "'$_key'=>$_value";
                    }
                }
            }
        }
        //varibale name?
        if (!(strpos($_name, '$') === false)) {
            $call_cache = $_name;
            $call_function = '$tmp = "smarty_template_function_".' . $_name . '; $tmp';
        } else {
            $_name = trim($_name, "'\"");
            $call_cache = "'{$_name}'";
            $call_function = 'smarty_template_function_' . $_name;
        }

        $_params = 'array(' . implode(",", $_paramsArray) . ')';
        $_hash = str_replace('-', '_', $compiler->template->properties['nocache_hash']);
        // was there an assign attribute
        if (isset($_assign)) {
            if ($compiler->template->caching) {
                $_output = "<?php ob_start(); Smarty_Internal_Function_Call_Handler::call ({$call_cache},\$_smarty_tpl,{$_params},'{$_hash}',{$_nocache}); \$_smarty_tpl->assign({$_assign}, ob_get_clean());?>\n";
            } else {
                $_output = "<?php ob_start(); {$call_function}(\$_smarty_tpl,{$_params}); \$_smarty_tpl->assign({$_assign}, ob_get_clean());?>\n";
            }
        } else {
            if ($compiler->template->caching) {
                $_output = "<?php Smarty_Internal_Function_Call_Handler::call ({$call_cache},\$_smarty_tpl,{$_params},'{$_hash}',{$_nocache});?>\n";
            } else {
                $_output = "<?php {$call_function}(\$_smarty_tpl,{$_params});?>\n";
            }
        }
        return $_output;
    }

}

?><?php
/**
 * Smarty Internal Plugin Config File Compiler
 *
 * This is the config file compiler class. It calls the lexer and parser to
 * perform the compiling.
 *
 * @package Smarty
 * @subpackage Config
 * @author Uwe Tews
 */

/**
 * Main config file compiler class
 *
 * @package Smarty
 * @subpackage Config
 */
class Smarty_Internal_Config_File_Compiler {

    /**
     * Lexer object
     *
     * @var object
     */
    public $lex;

    /**
     * Parser object
     *
     * @var object
     */
    public $parser;

    /**
     * Smarty object
     *
     * @var Smarty object
     */
    public $smarty;

    /**
     * Smarty object
     *
     * @var Smarty_Internal_Config object
     */
    public $config;

    /**
     * Compiled config data sections and variables
     *
     * @var array
     */
    public $config_data = array();

    /**
     * Initialize compiler
     *
     * @param Smarty $smarty base instance
     */
    public function __construct($smarty)
    {
        $this->smarty = $smarty;
        $this->config_data['sections'] = array();
        $this->config_data['vars'] = array();
    }

    /**
     * Method to compile a Smarty template.
     *
     * @param  Smarty_Internal_Config $config config object
     * @return bool true if compiling succeeded, false if it failed
     */
    public function compileSource(Smarty_Internal_Config $config)
    {
        /* here is where the compiling takes place. Smarty
          tags in the templates are replaces with PHP code,
          then written to compiled files. */
        $this->config = $config;
        // get config file source
        $_content = $config->source->content . "\n";
        // on empty template just return
        if ($_content == '') {
            return true;
        }
        // init the lexer/parser to compile the config file
        $lex = new Smarty_Internal_Configfilelexer($_content, $this->smarty);
        $parser = new Smarty_Internal_Configfileparser($lex, $this);
        if ($this->smarty->_parserdebug) $parser->PrintTrace();
        // get tokens from lexer and parse them
        while ($lex->yylex()) {
            if ($this->smarty->_parserdebug) echo "<br>Parsing  {$parser->yyTokenName[$lex->token]} Token {$lex->value} Line {$lex->line} \n";
            $parser->doParse($lex->token, $lex->value);
        }
        // finish parsing process
        $parser->doParse(0, 0);
        $config->compiled_config = '<?php $_config_vars = ' . var_export($this->config_data, true) . '; ?>';
    }

    /**
     * display compiler error messages without dying
     *
     * If parameter $args is empty it is a parser detected syntax error.
     * In this case the parser is called to obtain information about exspected tokens.
     *
     * If parameter $args contains a string this is used as error message
     *
     * @param string $args individual error message or null
     */
    public function trigger_config_file_error($args = null)
    {
        $this->lex = Smarty_Internal_Configfilelexer::instance();
        $this->parser = Smarty_Internal_Configfileparser::instance();
        // get template source line which has error
        $line = $this->lex->line;
        if (isset($args)) {
            // $line--;
        }
        $match = preg_split("/\n/", $this->lex->data);
        $error_text = "Syntax error in config file '{$this->config->source->filepath}' on line {$line} '{$match[$line-1]}' ";
        if (isset($args)) {
            // individual error message
            $error_text .= $args;
        } else {
            // exspected token from parser
            foreach ($this->parser->yy_get_expected_tokens($this->parser->yymajor) as $token) {
                $exp_token = $this->parser->yyTokenName[$token];
                if (isset($this->lex->smarty_token_names[$exp_token])) {
                    // token type from lexer
                    $expect[] = '"' . $this->lex->smarty_token_names[$exp_token] . '"';
                } else {
                    // otherwise internal token name
                    $expect[] = $this->parser->yyTokenName[$token];
                }
            }
            // output parser error message
            $error_text .= ' - Unexpected "' . $this->lex->value . '", expected one of: ' . implode(' , ', $expect);
        }
        throw new SmartyCompilerException($error_text);
    }

}

?><?php
/**
 * Project:     Smarty: the PHP compiling template engine
 * File:        smarty_internal_utility.php
 * SVN:         $Id: $
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For questions, help, comments, discussion, etc., please join the
 * Smarty mailing list. Send a blank e-mail to
 * smarty-discussion-subscribe@googlegroups.com
 *
 * @link http://www.smarty.net/
 * @copyright 2008 New Digital Group, Inc.
 * @author Monte Ohrt <monte at ohrt dot com>
 * @author Uwe Tews
 * @package Smarty
 * @subpackage PluginsInternal
 * @version 3-SVN$Rev: 3286 $
 */


/**
 * Utility class
 *
 * @package Smarty
 * @subpackage Security
 */
class Smarty_Internal_Utility {

    /**
     * private constructor to prevent calls creation of new instances
     */
    private final function __construct()
    {
        // intentionally left blank
    }

    /**
     * Compile all template files
     *
     * @param string $extension     template file name extension
     * @param bool   $force_compile force all to recompile
     * @param int    $time_limit    set maximum execution time
     * @param int    $max_errors    set maximum allowed errors
     * @param Smarty $smarty        Smarty instance
     * @return integer number of template files compiled
     */
    public static function compileAllTemplates($extention, $force_compile, $time_limit, $max_errors, Smarty $smarty)
    {
        // switch off time limit
        if (function_exists('set_time_limit')) {
            @set_time_limit($time_limit);
        }
        $smarty->force_compile = $force_compile;
        $_count = 0;
        $_error_count = 0;
        // loop over array of template directories
        foreach($smarty->getTemplateDir() as $_dir) {
            $_compileDirs = new RecursiveDirectoryIterator($_dir);
            $_compile = new RecursiveIteratorIterator($_compileDirs);
            foreach ($_compile as $_fileinfo) {
                if (substr($_fileinfo->getBasename(),0,1) == '.' || strpos($_fileinfo, '.svn') !== false) continue;
                $_file = $_fileinfo->getFilename();
                if (!substr_compare($_file, $extention, - strlen($extention)) == 0) continue;
                if ($_fileinfo->getPath() == substr($_dir, 0, -1)) {
                   $_template_file = $_file;
                } else {
                   $_template_file = substr($_fileinfo->getPath(), strlen($_dir)) . DS . $_file;
                }
                echo '<br>', $_dir, '---', $_template_file;
                flush();
                $_start_time = microtime(true);
                try {
                    $_tpl = $smarty->createTemplate($_template_file,null,null,null,false);
                    if ($_tpl->mustCompile()) {
                        $_tpl->compileTemplateSource();
                        echo ' compiled in  ', microtime(true) - $_start_time, ' seconds';
                        flush();
                    } else {
                        echo ' is up to date';
                        flush();
                    }
                }
                catch (Exception $e) {
                    echo 'Error: ', $e->getMessage(), "<br><br>";
                    $_error_count++;
                }
                // free memory
                $smarty->template_objects = array();
                $_tpl->smarty->template_objects = array();
                $_tpl = null;
                if ($max_errors !== null && $_error_count == $max_errors) {
                    echo '<br><br>too many errors';
                    exit();
                }
            }
        }
        return $_count;
    }

    /**
     * Compile all config files
     *
     * @param string $extension     config file name extension
     * @param bool   $force_compile force all to recompile
     * @param int    $time_limit    set maximum execution time
     * @param int    $max_errors    set maximum allowed errors
     * @param Smarty $smarty        Smarty instance
     * @return integer number of config files compiled
     */
    public static function compileAllConfig($extention, $force_compile, $time_limit, $max_errors, Smarty $smarty)
    {
        // switch off time limit
        if (function_exists('set_time_limit')) {
            @set_time_limit($time_limit);
        }
        $smarty->force_compile = $force_compile;
        $_count = 0;
        $_error_count = 0;
        // loop over array of template directories
        foreach($smarty->getConfigDir() as $_dir) {
            $_compileDirs = new RecursiveDirectoryIterator($_dir);
            $_compile = new RecursiveIteratorIterator($_compileDirs);
            foreach ($_compile as $_fileinfo) {
                if (substr($_fileinfo->getBasename(),0,1) == '.' || strpos($_fileinfo, '.svn') !== false) continue;
                $_file = $_fileinfo->getFilename();
                if (!substr_compare($_file, $extention, - strlen($extention)) == 0) continue;
                if ($_fileinfo->getPath() == substr($_dir, 0, -1)) {
                    $_config_file = $_file;
                } else {
                    $_config_file = substr($_fileinfo->getPath(), strlen($_dir)) . DS . $_file;
                }
                echo '<br>', $_dir, '---', $_config_file;
                flush();
                $_start_time = microtime(true);
                try {
                    $_config = new Smarty_Internal_Config($_config_file, $smarty);
                    if ($_config->mustCompile()) {
                        $_config->compileConfigSource();
                        echo ' compiled in  ', microtime(true) - $_start_time, ' seconds';
                        flush();
                    } else {
                        echo ' is up to date';
                        flush();
                    }
                }
                catch (Exception $e) {
                    echo 'Error: ', $e->getMessage(), "<br><br>";
                    $_error_count++;
                }
                if ($max_errors !== null && $_error_count == $max_errors) {
                    echo '<br><br>too many errors';
                    exit();
                }
            }
        }
        return $_count;
    }

    /**
     * Delete compiled template file
     *
     * @param string  $resource_name template name
     * @param string  $compile_id    compile id
     * @param integer $exp_time      expiration time
     * @param Smarty  $smarty        Smarty instance
     * @return integer number of template files deleted
     */
    public static function clearCompiledTemplate($resource_name, $compile_id, $exp_time, Smarty $smarty)
    {
        $_compile_dir = $smarty->getCompileDir();
        $_compile_id = isset($compile_id) ? preg_replace('![^\w\|]+!', '_', $compile_id) : null;
        $_dir_sep = $smarty->use_sub_dirs ? DS : '^';
        if (isset($resource_name)) {
            $_save_stat = $smarty->caching;
            $smarty->caching = false;
            $tpl = new $smarty->template_class($resource_name, $smarty);
            $smarty->caching = $_save_stat;
            
            // remove from template cache
            $tpl->source; // have the template registered before unset()
            $_templateId = sha1($tpl->source->unique_resource . $tpl->cache_id . $tpl->compile_id);
            unset($smarty->template_objects[$_templateId]);
            
            if ($tpl->source->exists) {
                 $_resource_part_1 = basename(str_replace('^', '/', $tpl->compiled->filepath));
                 $_resource_part_1_length = strlen($_resource_part_1);
            } else {
                return 0;
            }
            
            $_resource_part_2 = str_replace('.php','.cache.php',$_resource_part_1);
            $_resource_part_2_length = strlen($_resource_part_2);
        } else {
            $_resource_part = '';
        }
        $_dir = $_compile_dir;
        if ($smarty->use_sub_dirs && isset($_compile_id)) {
            $_dir .= $_compile_id . $_dir_sep;
        }
        if (isset($_compile_id)) {
            $_compile_id_part = $_compile_dir . $_compile_id . $_dir_sep;
            $_compile_id_part_length = strlen($_compile_id_part);
        }
        $_count = 0;
        $_compileDirs = new RecursiveDirectoryIterator($_dir);
        $_compile = new RecursiveIteratorIterator($_compileDirs, RecursiveIteratorIterator::CHILD_FIRST);
        foreach ($_compile as $_file) {
            if (substr($_file->getBasename(), 0, 1) == '.' || strpos($_file, '.svn') !== false)
                continue;
            
            $_filepath = (string) $_file;
            
            if ($_file->isDir()) {
                if (!$_compile->isDot()) {
                    // delete folder if empty
                    @rmdir($_file->getPathname());
                }
            } else {
                $unlink = false;
                if ((!isset($_compile_id) || (isset($_filepath[$_compile_id_part_length]) && !strncmp($_filepath, $_compile_id_part, $_compile_id_part_length)))
                    && (!isset($resource_name) 
                        || (isset($_filepath[$_resource_part_1_length]) 
                            && substr_compare($_filepath, $_resource_part_1, -$_resource_part_1_length, $_resource_part_1_length) == 0) 
                        || (isset($_filepath[$_resource_part_2_length]) 
                            && substr_compare($_filepath, $_resource_part_2, -$_resource_part_2_length, $_resource_part_2_length) == 0))) {
                    if (isset($exp_time)) {
                        if (time() - @filemtime($_filepath) >= $exp_time) {
                            $unlink = true;
                        }
                    } else {
                        $unlink = true;
                    }
                }
                
                if ($unlink && @unlink($_filepath)) {
                    $_count++;
                }
            }
        }
        // clear compiled cache
        Smarty_Resource::$sources = array();
        Smarty_Resource::$compileds = array();
        return $_count;
    }

    /**
     * Return array of tag/attributes of all tags used by an template
     *
     * @param Smarty_Internal_Template $templae template object
     * @return array of tag/attributes
     */
    public static function getTags(Smarty_Internal_Template $template)
    {
        $template->smarty->get_used_tags = true;
        $template->compileTemplateSource();
        return $template->used_tags;
    }


    /**
     * diagnose Smarty setup
     *
     * If $errors is secified, the diagnostic report will be appended to the array, rather than being output.
     *
     * @param Smarty $smarty  Smarty instance to test
     * @param array  $errors array to push results into rather than outputting them
     * @return bool status, true if everything is fine, false else
     */
    public static function testInstall(Smarty $smarty, &$errors=null)
    {
        $status = true;

        if ($errors === null) {
            echo "<PRE>\n";
            echo "Smarty Installation test...\n";
            echo "Testing template directory...\n";
        }

        // test if all registered template_dir are accessible
        foreach($smarty->getTemplateDir() as $template_dir) {
            $_template_dir = $template_dir;
            $template_dir = realpath($template_dir);
            // resolve include_path or fail existance
            if (!$template_dir) {
                if ($smarty->use_include_path && !preg_match('/^([\/\\\\]|[a-zA-Z]:[\/\\\\])/', $_template_dir)) {
                    // try PHP include_path
                    if (($template_dir = Smarty_Internal_Get_Include_Path::getIncludePath($_template_dir)) !== false) {
                        if ($errors === null) {
                            echo "$template_dir is OK.\n";
                        }
                        
                        continue;
                    } else {
                        $status = false;
                        $message = "FAILED: $_template_dir does not exist (and couldn't be found in include_path either)";
                        if ($errors === null) {
                            echo $message . ".\n";
                        } else {
                            $errors['template_dir'] = $message;
                        }

                        continue;
                    }
                } else {
                    $status = false;
                    $message = "FAILED: $_template_dir does not exist";
                    if ($errors === null) {
                        echo $message . ".\n";
                    } else {
                        $errors['template_dir'] = $message;
                    }
                    
                    continue;
                }
            }
            
            if (!is_dir($template_dir)) {
                $status = false;
                $message = "FAILED: $template_dir is not a directory";
                if ($errors === null) {
                    echo $message . ".\n";
                } else {
                    $errors['template_dir'] = $message;
                }
            } elseif (!is_readable($template_dir)) {
                $status = false;
                $message = "FAILED: $template_dir is not readable";
                if ($errors === null) {
                    echo $message . ".\n";
                } else {
                    $errors['template_dir'] = $message;
                }
            } else {
                if ($errors === null) {
                    echo "$template_dir is OK.\n";
                }
            }
        }


        if ($errors === null) {
            echo "Testing compile directory...\n";
        }

        // test if registered compile_dir is accessible
        $__compile_dir = $smarty->getCompileDir();
        $_compile_dir = realpath($__compile_dir);
        if (!$_compile_dir) {
            $status = false;
            $message = "FAILED: {$__compile_dir} does not exist";
            if ($errors === null) {
                echo $message . ".\n";
            } else {
                $errors['compile_dir'] = $message;
            }
        } elseif (!is_dir($_compile_dir)) {
            $status = false;
            $message = "FAILED: {$_compile_dir} is not a directory";
            if ($errors === null) {
                echo $message . ".\n";
            } else {
                $errors['compile_dir'] = $message;
            }
        } elseif (!is_readable($_compile_dir)) {
            $status = false;
            $message = "FAILED: {$_compile_dir} is not readable";
            if ($errors === null) {
                echo $message . ".\n";
            } else {
                $errors['compile_dir'] = $message;
            }
        } elseif (!is_writable($_compile_dir)) {
            $status = false;
            $message = "FAILED: {$_compile_dir} is not writable";
            if ($errors === null) {
                echo $message . ".\n";
            } else {
                $errors['compile_dir'] = $message;
            }
        } else {
            if ($errors === null) {
                echo "{$_compile_dir} is OK.\n";
            }
        }


        if ($errors === null) {
            echo "Testing plugins directory...\n";
        }

        // test if all registered plugins_dir are accessible
        // and if core plugins directory is still registered
        $_core_plugins_dir = realpath(dirname(__FILE__) .'/../plugins');
        $_core_plugins_available = false;
        foreach($smarty->getPluginsDir() as $plugin_dir) {
            $_plugin_dir = $plugin_dir;
            $plugin_dir = realpath($plugin_dir);
            // resolve include_path or fail existance
            if (!$plugin_dir) {
                if ($smarty->use_include_path && !preg_match('/^([\/\\\\]|[a-zA-Z]:[\/\\\\])/', $_plugin_dir)) {
                    // try PHP include_path
                    if (($plugin_dir = Smarty_Internal_Get_Include_Path::getIncludePath($_plugin_dir)) !== false) {
                        if ($errors === null) {
                            echo "$plugin_dir is OK.\n";
                        }
                        
                        continue;
                    } else {
                        $status = false;
                        $message = "FAILED: $_plugin_dir does not exist (and couldn't be found in include_path either)";
                        if ($errors === null) {
                            echo $message . ".\n";
                        } else {
                            $errors['plugins_dir'] = $message;
                        }

                        continue;
                    }
                } else {
                    $status = false;
                    $message = "FAILED: $_plugin_dir does not exist";
                    if ($errors === null) {
                        echo $message . ".\n";
                    } else {
                        $errors['plugins_dir'] = $message;
                    }
                    
                    continue;
                }
            }
            
            if (!is_dir($plugin_dir)) {
                $status = false;
                $message = "FAILED: $plugin_dir is not a directory";
                if ($errors === null) {
                    echo $message . ".\n";
                } else {
                    $errors['plugins_dir'] = $message;
                }
            } elseif (!is_readable($plugin_dir)) {
                $status = false;
                $message = "FAILED: $plugin_dir is not readable";
                if ($errors === null) {
                    echo $message . ".\n";
                } else {
                    $errors['plugins_dir'] = $message;
                }
            } elseif ($_core_plugins_dir && $_core_plugins_dir == realpath($plugin_dir)) {
                $_core_plugins_available = true;
                if ($errors === null) {
                    echo "$plugin_dir is OK.\n";
                }
            } else {
                if ($errors === null) {
                    echo "$plugin_dir is OK.\n";
                }
            }
        }
        if (!$_core_plugins_available) {
            $status = false;
            $message = "WARNING: Smarty's own libs/plugins is not available";
            if ($errors === null) {
                echo $message . ".\n";
            } elseif (!isset($errors['plugins_dir'])) {
                $errors['plugins_dir'] = $message;
            }
        }

        if ($errors === null) {
            echo "Testing cache directory...\n";
        }

        
        // test if all registered cache_dir is accessible
        $__cache_dir = $smarty->getCacheDir();
        $_cache_dir = realpath($__cache_dir);
        if (!$_cache_dir) {
            $status = false;
            $message = "FAILED: {$__cache_dir} does not exist";
            if ($errors === null) {
                echo $message . ".\n";
            } else {
                $errors['cache_dir'] = $message;
            }
        } elseif (!is_dir($_cache_dir)) {
            $status = false;
            $message = "FAILED: {$_cache_dir} is not a directory";
            if ($errors === null) {
                echo $message . ".\n";
            } else {
                $errors['cache_dir'] = $message;
            }
        } elseif (!is_readable($_cache_dir)) {
            $status = false;
            $message = "FAILED: {$_cache_dir} is not readable";
            if ($errors === null) {
                echo $message . ".\n";
            } else {
                $errors['cache_dir'] = $message;
            }
        } elseif (!is_writable($_cache_dir)) {
            $status = false;
            $message = "FAILED: {$_cache_dir} is not writable";
            if ($errors === null) {
                echo $message . ".\n";
            } else {
                $errors['cache_dir'] = $message;
            }
        } else {
            if ($errors === null) {
                echo "{$_cache_dir} is OK.\n";
            }
        }


        if ($errors === null) {
            echo "Testing configs directory...\n";
        }

        // test if all registered config_dir are accessible
        foreach($smarty->getConfigDir() as $config_dir) {
            $_config_dir = $config_dir;
            $config_dir = realpath($config_dir);
            // resolve include_path or fail existance
            if (!$config_dir) {
                if ($smarty->use_include_path && !preg_match('/^([\/\\\\]|[a-zA-Z]:[\/\\\\])/', $_config_dir)) {
                    // try PHP include_path
                    if (($config_dir = Smarty_Internal_Get_Include_Path::getIncludePath($_config_dir)) !== false) {
                        if ($errors === null) {
                            echo "$config_dir is OK.\n";
                        }
                        
                        continue;
                    } else {
                        $status = false;
                        $message = "FAILED: $_config_dir does not exist (and couldn't be found in include_path either)";
                        if ($errors === null) {
                            echo $message . ".\n";
                        } else {
                            $errors['config_dir'] = $message;
                        }

                        continue;
                    }
                } else {
                    $status = false;
                    $message = "FAILED: $_config_dir does not exist";
                    if ($errors === null) {
                        echo $message . ".\n";
                    } else {
                        $errors['config_dir'] = $message;
                    }
                    
                    continue;
                }
            }
            
            if (!is_dir($config_dir)) {
                $status = false;
                $message = "FAILED: $config_dir is not a directory";
                if ($errors === null) {
                    echo $message . ".\n";
                } else {
                    $errors['config_dir'] = $message;
                }
            } elseif (!is_readable($config_dir)) {
                $status = false;
                $message = "FAILED: $config_dir is not readable";
                if ($errors === null) {
                    echo $message . ".\n";
                } else {
                    $errors['config_dir'] = $message;
                }
            } else {
                if ($errors === null) {
                    echo "$config_dir is OK.\n";
                }
            }
        }


        if ($errors === null) {
            echo "Testing sysplugin files...\n";
        }
        // test if sysplugins are available
        $source = SMARTY_SYSPLUGINS_DIR;
        if (is_dir($source)) {
            $expected = array(
                "smarty_cacheresource.php" => true,
                "smarty_cacheresource_custom.php" => true,
                "smarty_cacheresource_keyvaluestore.php" => true,
                "smarty_config_source.php" => true,
                "smarty_internal_cacheresource_file.php" => true,
                "smarty_internal_compile_append.php" => true,
                "smarty_internal_compile_assign.php" => true,
                "smarty_internal_compile_block.php" => true,
                "smarty_internal_compile_break.php" => true,
                "smarty_internal_compile_call.php" => true,
                "smarty_internal_compile_capture.php" => true,
                "smarty_internal_compile_config_load.php" => true,
                "smarty_internal_compile_continue.php" => true,
                "smarty_internal_compile_debug.php" => true,
                "smarty_internal_compile_eval.php" => true,
                "smarty_internal_compile_extends.php" => true,
                "smarty_internal_compile_for.php" => true,
                "smarty_internal_compile_foreach.php" => true,
                "smarty_internal_compile_function.php" => true,
                "smarty_internal_compile_if.php" => true,
                "smarty_internal_compile_include.php" => true,
                "smarty_internal_compile_include_php.php" => true,
                "smarty_internal_compile_insert.php" => true,
                "smarty_internal_compile_ldelim.php" => true,
                "smarty_internal_compile_nocache.php" => true,
                "smarty_internal_compile_private_block_plugin.php" => true,
                "smarty_internal_compile_private_function_plugin.php" => true,
                "smarty_internal_compile_private_modifier.php" => true,
                "smarty_internal_compile_private_object_block_function.php" => true,
                "smarty_internal_compile_private_object_function.php" => true,
                "smarty_internal_compile_private_print_expression.php" => true,
                "smarty_internal_compile_private_registered_block.php" => true,
                "smarty_internal_compile_private_registered_function.php" => true,
                "smarty_internal_compile_private_special_variable.php" => true,
                "smarty_internal_compile_rdelim.php" => true,
                "smarty_internal_compile_section.php" => true,
                "smarty_internal_compile_setfilter.php" => true,
                "smarty_internal_compile_while.php" => true,
                "smarty_internal_compilebase.php" => true,
                "smarty_internal_config.php" => true,
                "smarty_internal_config_file_compiler.php" => true,
                "smarty_internal_configfilelexer.php" => true,
                "smarty_internal_configfileparser.php" => true,
                "smarty_internal_data.php" => true,
                "smarty_internal_debug.php" => true,
                "smarty_internal_filter_handler.php" => true,
                "smarty_internal_function_call_handler.php" => true,
                "smarty_internal_get_include_path.php" => true,
                "smarty_internal_nocache_insert.php" => true,
                "smarty_internal_parsetree.php" => true,
                "smarty_internal_resource_eval.php" => true,
                "smarty_internal_resource_extends.php" => true,
                "smarty_internal_resource_file.php" => true,
                "smarty_internal_resource_registered.php" => true,
                "smarty_internal_resource_stream.php" => true,
                "smarty_internal_resource_string.php" => true,
                "smarty_internal_smartytemplatecompiler.php" => true,
                "smarty_internal_template.php" => true,
                "smarty_internal_templatebase.php" => true,
                "smarty_internal_templatecompilerbase.php" => true,
                "smarty_internal_templatelexer.php" => true,
                "smarty_internal_templateparser.php" => true,
                "smarty_internal_utility.php" => true,
                "smarty_internal_write_file.php" => true,
                "smarty_resource.php" => true,
                "smarty_resource_custom.php" => true,
                "smarty_resource_recompiled.php" => true,
                "smarty_resource_uncompiled.php" => true,
                "smarty_security.php" => true,
            );
            $iterator = new DirectoryIterator($source);
            foreach ($iterator as $file) {
                if (!$file->isDot()) {
                    $filename = $file->getFilename();
                    if (isset($expected[$filename])) {
                        unset($expected[$filename]);
                    }
                }
            }
            if ($expected) {
                $status = false;
                $message = "FAILED: files missing from libs/sysplugins: ". join(', ', array_keys($expected));
                if ($errors === null) {
                    echo $message . ".\n";
                } else {
                    $errors['sysplugins'] = $message;
                }
            } elseif ($errors === null) {
                echo "... OK\n";
            }
        } else {
            $status = false;
            $message = "FAILED: ". SMARTY_SYSPLUGINS_DIR .' is not a directory';
            if ($errors === null) {
                echo $message . ".\n";
            } else {
                $errors['sysplugins_dir_constant'] = $message;
            }
        }

        if ($errors === null) {
            echo "Testing plugin files...\n";
        }
        // test if core plugins are available
        $source = SMARTY_PLUGINS_DIR;
        if (is_dir($source)) {
            $expected = array(
                "block.textformat.php" => true,
                "function.counter.php" => true,
                "function.cycle.php" => true,
                "function.fetch.php" => true,
                "function.html_checkboxes.php" => true,
                "function.html_image.php" => true,
                "function.html_options.php" => true,
                "function.html_radios.php" => true,
                "function.html_select_date.php" => true,
                "function.html_select_time.php" => true,
                "function.html_table.php" => true,
                "function.mailto.php" => true,
                "function.math.php" => true,
                "modifier.capitalize.php" => true,
                "modifier.date_format.php" => true,
                "modifier.debug_print_var.php" => true,
                "modifier.escape.php" => true,
                "modifier.regex_replace.php" => true,
                "modifier.replace.php" => true,
                "modifier.spacify.php" => true,
                "modifier.truncate.php" => true,
                "modifiercompiler.cat.php" => true,
                "modifiercompiler.count_characters.php" => true,
                "modifiercompiler.count_paragraphs.php" => true,
                "modifiercompiler.count_sentences.php" => true,
                "modifiercompiler.count_words.php" => true,
                "modifiercompiler.default.php" => true,
                "modifiercompiler.escape.php" => true,
                "modifiercompiler.from_charset.php" => true,
                "modifiercompiler.indent.php" => true,
                "modifiercompiler.lower.php" => true,
                "modifiercompiler.noprint.php" => true,
                "modifiercompiler.string_format.php" => true,
                "modifiercompiler.strip.php" => true,
                "modifiercompiler.strip_tags.php" => true,
                "modifiercompiler.to_charset.php" => true,
                "modifiercompiler.unescape.php" => true,
                "modifiercompiler.upper.php" => true,
                "modifiercompiler.wordwrap.php" => true,
                "outputfilter.trimwhitespace.php" => true,
                "shared.escape_special_chars.php" => true,
                "shared.literal_compiler_param.php" => true,
                "shared.make_timestamp.php" => true,
                "shared.mb_str_replace.php" => true,
                "shared.mb_unicode.php" => true,
                "shared.mb_wordwrap.php" => true,
                "variablefilter.htmlspecialchars.php" => true,
            );
            $iterator = new DirectoryIterator($source);
            foreach ($iterator as $file) {
                if (!$file->isDot()) {
                    $filename = $file->getFilename();
                    if (isset($expected[$filename])) {
                        unset($expected[$filename]);
                    }
                }
            }
            if ($expected) {
                $status = false;
                $message = "FAILED: files missing from libs/plugins: ". join(', ', array_keys($expected));
                if ($errors === null) {
                    echo $message . ".\n";
                } else {
                    $errors['plugins'] = $message;
                }
            } elseif ($errors === null) {
                echo "... OK\n";
            }
        } else {
            $status = false;
            $message = "FAILED: ". SMARTY_PLUGINS_DIR .' is not a directory';
            if ($errors === null) {
                echo $message . ".\n";
            } else {
                $errors['plugins_dir_constant'] = $message;
            }
        }

        if ($errors === null) {
            echo "Tests complete.\n";
            echo "</PRE>\n";
        }

        return $status;
    }

}

?><?php
/**
 * Smarty Resource Plugin
 *
 * @package Smarty
 * @subpackage TemplateResources
 * @author Rodney Rehm
 */

/**
 * Smarty Resource Plugin
 *
 * Base implementation for resource plugins that don't compile cache
 *
 * @package Smarty
 * @subpackage TemplateResources
 */
abstract class Smarty_Resource_Recompiled extends Smarty_Resource {

    /**
     * populate Compiled Object with compiled filepath
     *
     * @param Smarty_Template_Compiled $compiled compiled object
     * @param Smarty_Internal_Template $_template template object
     * @return void
     */
    public function populateCompiledFilepath(Smarty_Template_Compiled $compiled, Smarty_Internal_Template $_template)
    {
        $compiled->filepath = false;
        $compiled->timestamp = false;
        $compiled->exists = false;
    }

}

?><?php
/**
 * Smarty Resource Plugin
 *
 * @package Smarty
 * @subpackage TemplateResources
 * @author Rodney Rehm
 */

/**
 * Smarty Resource Plugin
 *
 * Base implementation for resource plugins
 *
 * @package Smarty
 * @subpackage TemplateResources
 */
abstract class Smarty_Resource {
    /**
     * cache for Smarty_Template_Source instances
     * @var array
     */
    public static $sources = array();
    /**
     * cache for Smarty_Template_Compiled instances
     * @var array
     */
    public static $compileds = array();
    /**
     * cache for Smarty_Resource instances
     * @var array
     */
    public static $resources = array();
    /**
     * resource types provided by the core
     * @var array
     */
    protected static $sysplugins = array(
        'file' => true,
        'string' => true,
        'extends' => true,
        'stream' => true,
        'eval' => true,
        'php' => true
    );

    /**
     * Name of the Class to compile this resource's contents with
     * @var string
     */
    public $compiler_class = 'Smarty_Internal_SmartyTemplateCompiler';

    /**
     * Name of the Class to tokenize this resource's contents with
     * @var string
     */
    public $template_lexer_class = 'Smarty_Internal_Templatelexer';

    /**
     * Name of the Class to parse this resource's contents with
     * @var string
     */
    public $template_parser_class = 'Smarty_Internal_Templateparser';

    /**
     * Load template's source into current template object
     *
     * {@internal The loaded source is assigned to $_template->source->content directly.}}
     *
     * @param Smarty_Template_Source $source source object
     * @return string template source
     * @throws SmartyException if source cannot be loaded
     */
    public abstract function getContent(Smarty_Template_Source $source);

    /**
     * populate Source Object with meta data from Resource
     *
     * @param Smarty_Template_Source   $source source object
     * @param Smarty_Internal_Template $_template     template object
     */
    public abstract function populate(Smarty_Template_Source $source, Smarty_Internal_Template $_template=null);

    /**
     * populate Source Object with timestamp and exists from Resource
     *
     * @param Smarty_Template_Source $source source object
     */
    public function populateTimestamp(Smarty_Template_Source $source)
    {
        // intentionally left blank
    }
    
    
    /**
     * modify resource_name according to resource handlers specifications
     *
     * @param Smarty $smarty        Smarty instance
     * @param string $resource_name resource_name to make unique
     * @return string unique resource name
     */
    protected function buildUniqueResourceName(Smarty $smarty, $resource_name)
    {
        return get_class($this) . '#' . $smarty->joined_template_dir . '#' . $resource_name;
    }
    
    /**
     * populate Compiled Object with compiled filepath
     *
     * @param Smarty_Template_Compiled $compiled  compiled object
     * @param Smarty_Internal_Template $_template template object
     */
    public function populateCompiledFilepath(Smarty_Template_Compiled $compiled, Smarty_Internal_Template $_template)
    {
        $_compile_id = isset($_template->compile_id) ? preg_replace('![^\w\|]+!', '_', $_template->compile_id) : null;
        $_filepath = $compiled->source->uid;
        // if use_sub_dirs, break file into directories
        if ($_template->smarty->use_sub_dirs) {
            $_filepath = substr($_filepath, 0, 2) . DS
             . substr($_filepath, 2, 2) . DS
             . substr($_filepath, 4, 2) . DS
             . $_filepath;
        }
        $_compile_dir_sep = $_template->smarty->use_sub_dirs ? DS : '^';
        if (isset($_compile_id)) {
            $_filepath = $_compile_id . $_compile_dir_sep . $_filepath;
        }
        // caching token
        if ($_template->caching) {
            $_cache = '.cache';
        } else {
            $_cache = '';
        }
        $_compile_dir = $_template->smarty->getCompileDir();
        // set basename if not specified
        $_basename = $this->getBasename($compiled->source);
        if ($_basename === null) {
            $_basename = basename( preg_replace('![^\w\/]+!', '_', $compiled->source->name) );
        }
        // separate (optional) basename by dot
        if ($_basename) {
            $_basename = '.' . $_basename;
        }

        $compiled->filepath = $_compile_dir . $_filepath . '.' . $compiled->source->type . $_basename . $_cache . '.php';
    }

    /**
     * build template filepath by traversing the template_dir array
     *
     * @param Smarty_Template_Source   $source    source object
     * @param Smarty_Internal_Template $_template template object
     * @return string fully qualified filepath
     * @throws SmartyException if default template handler is registered but not callable
     */
    protected function buildFilepath(Smarty_Template_Source $source, Smarty_Internal_Template $_template=null)
    {
        $file = $source->name;
        if ($source instanceof Smarty_Config_Source) {
            $_directories = $source->smarty->getConfigDir();
            $_default_handler = $source->smarty->default_config_handler_func;
        } else {
            $_directories = $source->smarty->getTemplateDir();
            $_default_handler = $source->smarty->default_template_handler_func;
        }

        // go relative to a given template?
        $_file_is_dotted = $file[0] == '.' && ($file[1] == '.' || $file[1] == '/' || $file[1] == "\\");
        if ($_template && $_template->parent instanceof Smarty_Internal_Template && $_file_is_dotted) {
            if ($_template->parent->source->type != 'file' && $_template->parent->source->type != 'extends' && !$_template->parent->allow_relative_path) {
                throw new SmartyException("Template '{$file}' cannot be relative to template of resource type '{$_template->parent->source->type}'");
            }
            $file = dirname($_template->parent->source->filepath) . DS . $file;
            $_file_exact_match = true;
            if (!preg_match('/^([\/\\\\]|[a-zA-Z]:[\/\\\\])/', $file)) {
                // the path gained from the parent template is relative to the current working directory
                // as expansions (like include_path) have already been done
                $file = getcwd() . DS . $file;
            }
        }

        // resolve relative path
        if (!preg_match('/^([\/\\\\]|[a-zA-Z]:[\/\\\\])/', $file)) {
            $_was_relative_prefix = $file[0] == '.' ? substr($file, 0, strpos($file, '|')) : null;
            $_path = DS . trim($file, '/\\');
            $_was_relative = true;
        } else {
            $_path = $file;
        }
        // don't we all just love windows?
        $_path = str_replace('\\', '/', $_path);
        // resolve simples
        $_path = preg_replace('#(/\./(\./)*)|/{2,}#', '/', $_path);
        // resolve parents
        while (true) {
            $_parent = strpos($_path, '/../');
            if ($_parent === false) {
                break;
            } else if ($_parent === 0) {
                $_path = substr($_path, 3);
                break;
            }
            $_pos = strrpos($_path, '/', $_parent - strlen($_path) - 1);
            if ($_pos === false) {
                // don't we all just love windows?
                $_pos = $_parent;
            }
            $_path = substr_replace($_path, '', $_pos, $_parent + 3 - $_pos);
        }
        if (DS != '/') {
            // don't we all just love windows?
            $_path = str_replace('/', '\\', $_path);
        }
        // revert to relative
        if (isset($_was_relative)) {
            if (isset($_was_relative_prefix)){
                $_path = $_was_relative_prefix . $_path;
            } else {
                $_path = substr($_path, 1);
            }
        }

        // this is only required for directories
        $file = rtrim($_path, '/\\');

        // files relative to a template only get one shot
        if (isset($_file_exact_match)) {
            return $this->fileExists($source, $file) ? $file : false;
        }

        // template_dir index?
        if (preg_match('#^\[(?P<key>[^\]]+)\](?P<file>.+)$#', $file, $match)) {
            $_directory = null;
            // try string indexes
            if (isset($_directories[$match['key']])) {
                $_directory = $_directories[$match['key']];
            } else if (is_numeric($match['key'])) {
                // try numeric index
                $match['key'] = (int) $match['key'];
                if (isset($_directories[$match['key']])) {
                    $_directory = $_directories[$match['key']];
                } else {
                    // try at location index
                    $keys = array_keys($_directories);
                    $_directory = $_directories[$keys[$match['key']]];
                }
            }

            if ($_directory) {
                $_file = substr($file, strpos($file, ']') + 1);
                $_filepath = $_directory . $_file;
                if ($this->fileExists($source, $_filepath)) {
                    return $_filepath;
                }
            }
        }

        // relative file name?
        if (!preg_match('/^([\/\\\\]|[a-zA-Z]:[\/\\\\])/', $file)) {
            foreach ($_directories as $_directory) {
                $_filepath = $_directory . $file;
                if ($this->fileExists($source, $_filepath)) {
                    return $_filepath;
                }
                if ($source->smarty->use_include_path && !preg_match('/^([\/\\\\]|[a-zA-Z]:[\/\\\\])/', $_directory)) {
                    // try PHP include_path
                    if (($_filepath = Smarty_Internal_Get_Include_Path::getIncludePath($_filepath)) !== false) {
                        return $_filepath;
                    }
                }
            }
        }

        // try absolute filepath
        if ($this->fileExists($source, $file)) {
            return $file;
        }

        // no tpl file found
        if ($_default_handler) {
            if (!is_callable($_default_handler)) {
                if ($source instanceof Smarty_Config_Source) {
                    throw new SmartyException("Default config handler not callable");
                } else {
                    throw new SmartyException("Default template handler not callable");
                }
            }
            $_return = call_user_func_array($_default_handler,
                array($source->type, $source->name, &$_content, &$_timestamp, $source->smarty));
            if (is_string($_return)) {
                $source->timestamp = @filemtime($_return);
                $source->exists = !!$source->timestamp;
                return $_return;
            } elseif ($_return === true) {
                $source->content = $_content;
                $source->timestamp = $_timestamp;
                $source->exists = true;
                return $_filepath;
            }
        }

        // give up
        return false;
    }

    /**
     * test is file exists and save timestamp
     *
     * @param Smarty_Template_Source   $source    source object
     * @param string $file file name
     * @return bool  true if file exists
     */
    protected function fileExists(Smarty_Template_Source $source, $file)
    {
        $source->timestamp = @filemtime($file);
        return $source->exists = !!$source->timestamp;

    }

    /**
     * Determine basename for compiled filename
     *
     * @param Smarty_Template_Source $source source object
     * @return string resource's basename
     */
    protected function getBasename(Smarty_Template_Source $source)
    {
        return null;
    }

    /**
     * Load Resource Handler
     *
     * @param Smarty $smarty    smarty object
     * @param string $type      name of the resource
     * @return Smarty_Resource Resource Handler
     */
    public static function load(Smarty $smarty, $type)
    {
        // try smarty's cache
        if (isset($smarty->_resource_handlers[$type])) {
            return $smarty->_resource_handlers[$type];
        }

        // try registered resource
        if (isset($smarty->registered_resources[$type])) {
            if ($smarty->registered_resources[$type] instanceof Smarty_Resource) {
                $smarty->_resource_handlers[$type] = $smarty->registered_resources[$type];
                // note registered to smarty is not kept unique!
                return $smarty->_resource_handlers[$type];
            }
            if (!isset(self::$resources['registered'])) {
                self::$resources['registered'] = new Smarty_Internal_Resource_Registered();
                $smarty->_resource_handlers[$type] = self::$resources['registered'];
            }
            return $smarty->_resource_handlers[$type];
        }

        // try sysplugins dir
        if (isset(self::$sysplugins[$type])) {
            if (!isset(self::$resources[$type])) {
                $_resource_class = 'Smarty_Internal_Resource_' . ucfirst($type);
                self::$resources[$type] = new $_resource_class();
            }
            return $smarty->_resource_handlers[$type] = self::$resources[$type];
        }

        // try plugins dir
        $_resource_class = 'Smarty_Resource_' . ucfirst($type);
        if ($smarty->loadPlugin($_resource_class)) {
            if (isset(self::$resources[$type])) {
                return $smarty->_resource_handlers[$type] = self::$resources[$type];
            }
            
            if (class_exists($_resource_class, false)) {
                self::$resources[$type] = new $_resource_class();
                return $smarty->_resource_handlers[$type] = self::$resources[$type];
            } else {
                $smarty->registerResource($type, array(
                    "smarty_resource_{$type}_source",
                    "smarty_resource_{$type}_timestamp",
                    "smarty_resource_{$type}_secure",
                    "smarty_resource_{$type}_trusted"
                ));

                // give it another try, now that the resource is registered properly
                return self::load($smarty, $type);
            }
        }

        // try streams
        $_known_stream = stream_get_wrappers();
        if (in_array($type, $_known_stream)) {
            // is known stream
            if (is_object($smarty->security_policy)) {
                $smarty->security_policy->isTrustedStream($type);
            }
            if (!isset(self::$resources['stream'])) {
                self::$resources['stream'] = new Smarty_Internal_Resource_Stream();
            }
            return $smarty->_resource_handlers[$type] = self::$resources['stream'];
        }

        // TODO: try default_(template|config)_handler

        // give up
        throw new SmartyException("Unkown resource type '{$type}'");
    }
    
    /**
     * extract resource_type and resource_name from template_resource and config_resource
     *
     * @note "C:/foo.tpl" was forced to file resource up till Smarty 3.1.3 (including).
     * @param string  $resource_name    template_resource or config_resource to parse
     * @param string  $default_resource the default resource_type defined in $smarty
     * @param string &$name             the parsed resource name
     * @param string &$type             the parsed resource type
     * @return void
     */
    protected static function parseResourceName($resource_name, $default_resource, &$name, &$type)
    {
        $parts = explode(':', $resource_name, 2);
        if (!isset($parts[1]) || !isset($parts[0][1])) {
            // no resource given, use default
            // or single character before the colon is not a resource type, but part of the filepath
            $type = $default_resource;
            $name = $resource_name;
        } else {
            $type = $parts[0];
            $name = $parts[1];
        }
    }
    
    
    /**
     * modify resource_name according to resource handlers specifications
     *
     * @param Smarty $smarty        Smarty instance
     * @param string $resource_name resource_name to make unique
     * @return string unique resource name
     */
     
    /**
     * modify template_resource according to resource handlers specifications
     *
     * @param string $smarty            Smarty instance 
     * @param string $template_resource template_resource to extracate resource handler and name of
     * @return string unique resource name
     */
    public static function getUniqueTemplateName($smarty, $template_resource)
    {
        self::parseResourceName($template_resource, $smarty->default_resource_type, $name, $type);
        // TODO: optimize for Smarty's internal resource types
        $resource = Smarty_Resource::load($smarty, $type);
        return $resource->buildUniqueResourceName($smarty, $name);
    }
    
    /**
     * initialize Source Object for given resource
     *
     * Either [$_template] or [$smarty, $template_resource] must be specified
     *
     * @param Smarty_Internal_Template $_template         template object
     * @param Smarty                   $smarty            smarty object
     * @param string                   $template_resource resource identifier
     * @return Smarty_Template_Source Source Object
     */
    public static function source(Smarty_Internal_Template $_template=null, Smarty $smarty=null, $template_resource=null)
    {
        if ($_template) {
            $smarty = $_template->smarty;
            $template_resource = $_template->template_resource;
        }
        
        // parse resource_name, load resource handler, identify unique resource name
        self::parseResourceName($template_resource, $smarty->default_resource_type, $name, $type);
        $resource = Smarty_Resource::load($smarty, $type);
        $unique_resource_name = $resource->buildUniqueResourceName($smarty, $name);

        // check runtime cache
        $_cache_key = 'template|' . $unique_resource_name;
        if (isset(self::$sources[$_cache_key])) {
            return self::$sources[$_cache_key];
        }
        
        // create source
        $source = new Smarty_Template_Source($resource, $smarty, $template_resource, $type, $name, $unique_resource_name);
        $resource->populate($source, $_template);

        // runtime cache
        self::$sources[$_cache_key] = $source;
        return $source;
    }

    /**
     * initialize Config Source Object for given resource
     *
     * @param Smarty_Internal_Config $_config config object
     * @return Smarty_Config_Source Source Object
     */
    public static function config(Smarty_Internal_Config $_config)
    {
        static $_incompatible_resources = array('eval' => true, 'string' => true, 'extends' => true, 'php' => true);
        $config_resource = $_config->config_resource;
        $smarty = $_config->smarty;
        
        // parse resource_name
        self::parseResourceName($config_resource, $smarty->default_config_type, $name, $type);
        
        // make sure configs are not loaded via anything smarty can't handle
        if (isset($_incompatible_resources[$type])) {
            throw new SmartyException ("Unable to use resource '{$type}' for config");
        }

        // load resource handler, identify unique resource name
        $resource = Smarty_Resource::load($smarty, $type);
        $unique_resource_name = $resource->buildUniqueResourceName($smarty, $name);
        
        // check runtime cache
        $_cache_key = 'config|' . $unique_resource_name;
        if (isset(self::$sources[$_cache_key])) {
            return self::$sources[$_cache_key];
        }
        
        // create source
        $source = new Smarty_Config_Source($resource, $smarty, $config_resource, $type, $name, $unique_resource_name);
        $resource->populate($source, null);
        
        // runtime cache
        self::$sources[$_cache_key] = $source;
        return $source;
    }

}

/**
 * Smarty Resource Data Object
 *
 * Meta Data Container for Template Files
 *
 * @package Smarty
 * @subpackage TemplateResources
 * @author Rodney Rehm
 *
 * @property integer $timestamp Source Timestamp
 * @property boolean $exists    Source Existance
 * @property boolean $template  Extended Template reference
 * @property string  $content   Source Content
 */
class Smarty_Template_Source {

    /**
     * Name of the Class to compile this resource's contents with
     * @var string
     */
    public $compiler_class = null;

    /**
     * Name of the Class to tokenize this resource's contents with
     * @var string
     */
    public $template_lexer_class = null;

    /**
     * Name of the Class to parse this resource's contents with
     * @var string
     */
    public $template_parser_class = null;

    /**
     * Unique Template ID
     * @var string
     */
    public $uid = null;

    /**
     * Template Resource (Smarty_Internal_Template::$template_resource)
     * @var string
     */
    public $resource = null;

    /**
     * Resource Type
     * @var string
     */
    public $type = null;

    /**
     * Resource Name
     * @var string
     */
    public $name = null;
    
    /**
     * Unique Resource Name
     * @var string
     */
    public $unique_resource = null;

    /**
     * Source Filepath
     * @var string
     */
    public $filepath = null;

    /**
     * Source is bypassing compiler
     * @var boolean
     */
    public $uncompiled = null;

    /**
     * Source must be recompiled on every occasion
     * @var boolean
     */
    public $recompiled = null;

    /**
     * The Components an extended template is made of
     * @var array
     */
    public $components = null;

    /**
     * Resource Handler
     * @var Smarty_Resource
     */
    public $handler = null;

    /**
     * Smarty instance
     * @var Smarty
     */
    public $smarty = null;

    /**
     * create Source Object container
     *
     * @param Smarty_Resource $handler          Resource Handler this source object communicates with
     * @param Smarty          $smarty           Smarty instance this source object belongs to
     * @param string          $resource         full template_resource
     * @param string          $type             type of resource
     * @param string          $name             resource name
     * @param string          $unique_resource  unqiue resource name
     */
    public function __construct(Smarty_Resource $handler, Smarty $smarty, $resource, $type, $name, $unique_resource)
    {
        $this->handler = $handler; // Note: prone to circular references

        $this->compiler_class = $handler->compiler_class;
        $this->template_lexer_class = $handler->template_lexer_class;
        $this->template_parser_class = $handler->template_parser_class;
        $this->uncompiled = $this->handler instanceof Smarty_Resource_Uncompiled;
        $this->recompiled = $this->handler instanceof Smarty_Resource_Recompiled;

        $this->smarty = $smarty;
        $this->resource = $resource;
        $this->type = $type;
        $this->name = $name;
        $this->unique_resource = $unique_resource;
    }

    /**
     * get a Compiled Object of this source
     *
     * @param Smarty_Internal_Template $_template template objet
     * @return Smarty_Template_Compiled compiled object
     */
    public function getCompiled(Smarty_Internal_Template $_template)
    {
        // check runtime cache
        $_cache_key = $this->unique_resource . '#' . $_template->compile_id;
        if (isset(Smarty_Resource::$compileds[$_cache_key])) {
            return Smarty_Resource::$compileds[$_cache_key];
        }

        $compiled = new Smarty_Template_Compiled($this);
        $this->handler->populateCompiledFilepath($compiled, $_template);
        $compiled->timestamp = @filemtime($compiled->filepath);
        $compiled->exists = !!$compiled->timestamp;

        // runtime cache
        Smarty_Resource::$compileds[$_cache_key] = $compiled;

        return $compiled;
    }

    /**
     * render the uncompiled source
     *
     * @param Smarty_Internal_Template $_template template object
     */
    public function renderUncompiled(Smarty_Internal_Template $_template)
    {
        return $this->handler->renderUncompiled($this, $_template);
    }

    /**
     * <<magic>> Generic Setter.
     *
     * @param string $property_name valid: timestamp, exists, content, template
     * @param mixed  $value        new value (is not checked)
     * @throws SmartyException if $property_name is not valid
     */
    public function __set($property_name, $value)
    {
        switch ($property_name) {
            // regular attributes
            case 'timestamp':
            case 'exists':
            case 'content':
            // required for extends: only
            case 'template':
                $this->$property_name = $value;
                break;

            default:
                throw new SmartyException("invalid source property '$property_name'.");
        }
    }

    /**
     * <<magic>> Generic getter.
     *
     * @param string $property_name valid: timestamp, exists, content
     * @return mixed
     * @throws SmartyException if $property_name is not valid
     */
    public function __get($property_name)
    {
        switch ($property_name) {
            case 'timestamp':
            case 'exists':
                $this->handler->populateTimestamp($this);
                return $this->$property_name;

            case 'content':
                return $this->content = $this->handler->getContent($this);

            default:
                throw new SmartyException("source property '$property_name' does not exist.");
        }
    }

}

/**
 * Smarty Resource Data Object
 *
 * Meta Data Container for Template Files
 *
 * @package Smarty
 * @subpackage TemplateResources
 * @author Rodney Rehm
 *
 * @property string $content compiled content
 */
class Smarty_Template_Compiled {

    /**
     * Compiled Filepath
     * @var string
     */
    public $filepath = null;

    /**
     * Compiled Timestamp
     * @var integer
     */
    public $timestamp = null;

    /**
     * Compiled Existance
     * @var boolean
     */
    public $exists = false;

    /**
     * Compiled Content Loaded
     * @var boolean
     */
    public $loaded = false;

    /**
     * Template was compiled
     * @var boolean
     */
    public $isCompiled = false;

    /**
     * Source Object
     * @var Smarty_Template_Source
     */
    public $source = null;

    /**
     * Metadata properties
     *
     * populated by Smarty_Internal_Template::decodeProperties()
     * @var array
     */
    public $_properties = null;

    /**
     * create Compiled Object container
     *
     * @param Smarty_Template_Source $source source object this compiled object belongs to
     */
    public function __construct(Smarty_Template_Source $source)
    {
        $this->source = $source;
    }

}

?><?php
/**
* Smarty Internal Plugin
*
* @package Smarty
* @subpackage Cacher
*/

/**
* Cache Handler API
*
* @package Smarty
* @subpackage Cacher
* @author Rodney Rehm
*/
abstract class Smarty_CacheResource {
    /**
    * cache for Smarty_CacheResource instances
    * @var array
    */
    public static $resources = array();

    /**
    * resource types provided by the core
    * @var array
    */
    protected static $sysplugins = array(
        'file' => true,
    );

    /**
    * populate Cached Object with meta data from Resource
    *
    * @param Smarty_Template_Cached $cached cached object
    * @param Smarty_Internal_Template $_template template object
    * @return void
    */
    public abstract function populate(Smarty_Template_Cached $cached, Smarty_Internal_Template $_template);

    /**
    * populate Cached Object with timestamp and exists from Resource
    *
    * @param Smarty_Template_Cached $source cached object
    * @return void
    */
    public abstract function populateTimestamp(Smarty_Template_Cached $cached);

    /**
    * Read the cached template and process header
    *
    * @param Smarty_Internal_Template $_template template object
    * @param Smarty_Template_Cached $cached cached object
    * @return booelan true or false if the cached content does not exist
    */
    public abstract function process(Smarty_Internal_Template $_template, Smarty_Template_Cached $cached=null);

    /**
    * Write the rendered template output to cache
    *
    * @param Smarty_Internal_Template $_template template object
    * @param string $content content to cache
    * @return boolean success
    */
    public abstract function writeCachedContent(Smarty_Internal_Template $_template, $content);

    /**
    * Return cached content
    *
    * @param Smarty_Internal_Template $_template template object
    * @param string $content content of cache
    */
    public function getCachedContent(Smarty_Internal_Template $_template)
    {
        if ($_template->cached->handler->process($_template)) {
            ob_start();
            $_template->properties['unifunc']($_template);
            return ob_get_clean();
        }
        return null;
    }

    /**
    * Empty cache
    *
    * @param Smarty $smarty Smarty object
    * @param integer $exp_time expiration time (number of seconds, not timestamp)
    * @return integer number of cache files deleted
    */
    public abstract function clearAll(Smarty $smarty, $exp_time=null);

    /**
    * Empty cache for a specific template
    *
    * @param Smarty $smarty Smarty object
    * @param string $resource_name template name
    * @param string $cache_id cache id
    * @param string $compile_id compile id
    * @param integer $exp_time expiration time (number of seconds, not timestamp)
    * @return integer number of cache files deleted
    */
    public abstract function clear(Smarty $smarty, $resource_name, $cache_id, $compile_id, $exp_time);


    public function locked(Smarty $smarty, Smarty_Template_Cached $cached)
    {
        // theoretically locking_timeout should be checked against time_limit (max_execution_time)
        $start = microtime(true);
        $hadLock = null;
        while ($this->hasLock($smarty, $cached)) {
            $hadLock = true;
            if (microtime(true) - $start > $smarty->locking_timeout) {
                // abort waiting for lock release
                return false;
            }
            sleep(1);
        }
        return $hadLock;
    }

    public function hasLock(Smarty $smarty, Smarty_Template_Cached $cached)
    {
        // check if lock exists
        return false;
    }

    public function acquireLock(Smarty $smarty, Smarty_Template_Cached $cached)
    {
        // create lock
        return true;
    }

    public function releaseLock(Smarty $smarty, Smarty_Template_Cached $cached)
    {
        // release lock
        return true;
    }


    /**
    * Load Cache Resource Handler
    *
    * @param Smarty $smarty Smarty object
    * @param string $type name of the cache resource
    * @return Smarty_CacheResource Cache Resource Handler
    */
    public static function load(Smarty $smarty, $type = null)
    {
        if (!isset($type)) {
            $type = $smarty->caching_type;
        }

        // try smarty's cache
        if (isset($smarty->_cacheresource_handlers[$type])) {
            return $smarty->_cacheresource_handlers[$type];
        }
        
        // try registered resource
        if (isset($smarty->registered_cache_resources[$type])) {
            // do not cache these instances as they may vary from instance to instance
            return $smarty->_cacheresource_handlers[$type] = $smarty->registered_cache_resources[$type];
        }
        // try sysplugins dir
        if (isset(self::$sysplugins[$type])) {
            if (!isset(self::$resources[$type])) {
                $cache_resource_class = 'Smarty_Internal_CacheResource_' . ucfirst($type);
                self::$resources[$type] = new $cache_resource_class();
            }
            return $smarty->_cacheresource_handlers[$type] = self::$resources[$type];
        }
        // try plugins dir
        $cache_resource_class = 'Smarty_CacheResource_' . ucfirst($type);
        if ($smarty->loadPlugin($cache_resource_class)) {
            if (!isset(self::$resources[$type])) {
                self::$resources[$type] = new $cache_resource_class();
            }
            return $smarty->_cacheresource_handlers[$type] = self::$resources[$type];
        }
        // give up
        throw new SmartyException("Unable to load cache resource '{$type}'");
    }

    /**
    * Invalid Loaded Cache Files
    *
    * @param Smarty $smarty Smarty object
    */
    public static function invalidLoadedCache(Smarty $smarty)
    {
        foreach ($smarty->template_objects as $tpl) {
            if (isset($tpl->cached)) {
                $tpl->cached->valid = false;
                $tpl->cached->processed = false;
            }
        }
    }
}

/**
* Smarty Resource Data Object
*
* Cache Data Container for Template Files
*
* @package Smarty
* @subpackage TemplateResources
* @author Rodney Rehm
*/
class Smarty_Template_Cached {
    /**
    * Source Filepath
    * @var string
    */
    public $filepath = false;

    /**
    * Source Content
    * @var string
    */
    public $content = null;

    /**
    * Source Timestamp
    * @var integer
    */
    public $timestamp = false;

    /**
    * Source Existance
    * @var boolean
    */
    public $exists = false;

    /**
    * Cache Is Valid
    * @var boolean
    */
    public $valid = false;

    /**
    * Cache was processed
    * @var boolean
    */
    public $processed = false;

    /**
    * CacheResource Handler
    * @var Smarty_CacheResource
    */
    public $handler = null;

    /**
    * Template Compile Id (Smarty_Internal_Template::$compile_id)
    * @var string
    */
    public $compile_id = null;

    /**
    * Template Cache Id (Smarty_Internal_Template::$cache_id)
    * @var string
    */
    public $cache_id = null;

    /**
    * Id for cache locking
    * @var string
    */
    public $lock_id = null;

    /**
    * flag that cache is locked by this instance
    * @var bool
    */
    public $is_locked = false;

    /**
    * Source Object
    * @var Smarty_Template_Source
    */
    public $source = null;

    /**
    * create Cached Object container
    *
    * @param Smarty_Internal_Template $_template template object
    */
    public function __construct(Smarty_Internal_Template $_template)
    {
        $this->compile_id = $_template->compile_id;
        $this->cache_id = $_template->cache_id;
        $this->source = $_template->source;
        $_template->cached = $this;
        $smarty = $_template->smarty;

        //
        // load resource handler
        //
        $this->handler = $handler = Smarty_CacheResource::load($smarty); // Note: prone to circular references

        //
        //    check if cache is valid
        //
        if (!($_template->caching == Smarty::CACHING_LIFETIME_CURRENT || $_template->caching == Smarty::CACHING_LIFETIME_SAVED) || $_template->source->recompiled) {
            return;
        }
        while (true) {
            while (true) {
                $handler->populate($this, $_template);
                if ($this->timestamp === false || $smarty->force_compile || $smarty->force_cache) {
                    $this->valid = false;
                } else {
                    $this->valid = true;
                }
                if ($this->valid && $_template->caching == Smarty::CACHING_LIFETIME_CURRENT && $_template->cache_lifetime >= 0 && time() > ($this->timestamp + $_template->cache_lifetime)) {
                    // lifetime expired
                    $this->valid = false;
                }
                if ($this->valid || !$_template->smarty->cache_locking) {
                    break;
                }
                if (!$this->handler->locked($_template->smarty, $this)) {
                    $this->handler->acquireLock($_template->smarty, $this);
                    break 2;
                }
            }
            if ($this->valid) {
                if (!$_template->smarty->cache_locking || $this->handler->locked($_template->smarty, $this) === null) {
                    // load cache file for the following checks
                    if ($smarty->debugging) {
                        Smarty_Internal_Debug::start_cache($_template);
                    }
                    if($handler->process($_template, $this) === false) {
                        $this->valid = false;
                    } else {
                        $this->processed = true;
                    }
                    if ($smarty->debugging) {
                        Smarty_Internal_Debug::end_cache($_template);
                    }
                } else {
                    continue;
                }
            } else {
                return;
            }
            if ($this->valid && $_template->caching === Smarty::CACHING_LIFETIME_SAVED && $_template->properties['cache_lifetime'] >= 0 && (time() > ($_template->cached->timestamp + $_template->properties['cache_lifetime']))) {
                $this->valid = false;
            }
            if (!$this->valid && $_template->smarty->cache_locking) {
                $this->handler->acquireLock($_template->smarty, $this);
                return;
            } else {
                return;
            }
        }
    }

    /**
    * Write this cache object to handler
    *
    * @param Smarty_Internal_Template $_template template object
    * @param string $content content to cache
    * @return boolean success
    */
    public function write(Smarty_Internal_Template $_template, $content)
    {
        if (!$_template->source->recompiled) {
            if ($this->handler->writeCachedContent($_template, $content)) {
                $this->timestamp = time();
                $this->exists = true;
                $this->valid = true;
                if ($_template->smarty->cache_locking) {
                    $this->handler->releaseLock($_template->smarty, $this);
                }
                return true;
            }
        }
        return false;
    }

}
?><?php
/**
 * Smarty Internal Plugin Compile Section
 *
 * Compiles the {section} {sectionelse} {/section} tags
 *
 * @package Smarty
 * @subpackage Compiler
 * @author Uwe Tews
 */

/**
 * Smarty Internal Plugin Compile Section Class
 * 
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_Section extends Smarty_Internal_CompileBase {

    /**
     * Attribute definition: Overwrites base class.
     *
     * @var array
     * @see Smarty_Internal_CompileBase
     */
    public $required_attributes = array('name', 'loop');
    /**
     * Attribute definition: Overwrites base class.
     *
     * @var array
     * @see Smarty_Internal_CompileBase
     */
    public $shorttag_order = array('name', 'loop');
    /**
     * Attribute definition: Overwrites base class.
     *
     * @var array
     * @see Smarty_Internal_CompileBase
     */
    public $optional_attributes = array('start', 'step', 'max', 'show');

    /**
     * Compiles code for the {section} tag
     *
     * @param array  $args     array with attributes from parser
     * @param object $compiler compiler object
     * @return string compiled code
     */
    public function compile($args, $compiler)
    {
        // check and get attributes
        $_attr = $this->getAttributes($compiler, $args);

        $this->openTag($compiler, 'section', array('section', $compiler->nocache));
        // maybe nocache because of nocache variables
        $compiler->nocache = $compiler->nocache | $compiler->tag_nocache;

        $output = "<?php ";

        $section_name = $_attr['name'];

        $output .= "if (isset(\$_smarty_tpl->tpl_vars['smarty']->value['section'][$section_name])) unset(\$_smarty_tpl->tpl_vars['smarty']->value['section'][$section_name]);\n";
        $section_props = "\$_smarty_tpl->tpl_vars['smarty']->value['section'][$section_name]";

        foreach ($_attr as $attr_name => $attr_value) {
            switch ($attr_name) {
                case 'loop':
                    $output .= "{$section_props}['loop'] = is_array(\$_loop=$attr_value) ? count(\$_loop) : max(0, (int)\$_loop); unset(\$_loop);\n";
                    break;

                case 'show':
                    if (is_bool($attr_value))
                        $show_attr_value = $attr_value ? 'true' : 'false';
                    else
                        $show_attr_value = "(bool)$attr_value";
                    $output .= "{$section_props}['show'] = $show_attr_value;\n";
                    break;

                case 'name':
                    $output .= "{$section_props}['$attr_name'] = $attr_value;\n";
                    break;

                case 'max':
                case 'start':
                    $output .= "{$section_props}['$attr_name'] = (int)$attr_value;\n";
                    break;

                case 'step':
                    $output .= "{$section_props}['$attr_name'] = ((int)$attr_value) == 0 ? 1 : (int)$attr_value;\n";
                    break;
            }
        }

        if (!isset($_attr['show']))
            $output .= "{$section_props}['show'] = true;\n";

        if (!isset($_attr['loop']))
            $output .= "{$section_props}['loop'] = 1;\n";

        if (!isset($_attr['max']))
            $output .= "{$section_props}['max'] = {$section_props}['loop'];\n";
        else
            $output .= "if ({$section_props}['max'] < 0)\n" . "    {$section_props}['max'] = {$section_props}['loop'];\n";

        if (!isset($_attr['step']))
            $output .= "{$section_props}['step'] = 1;\n";

        if (!isset($_attr['start']))
            $output .= "{$section_props}['start'] = {$section_props}['step'] > 0 ? 0 : {$section_props}['loop']-1;\n";
        else {
            $output .= "if ({$section_props}['start'] < 0)\n" . "    {$section_props}['start'] = max({$section_props}['step'] > 0 ? 0 : -1, {$section_props}['loop'] + {$section_props}['start']);\n" . "else\n" . "    {$section_props}['start'] = min({$section_props}['start'], {$section_props}['step'] > 0 ? {$section_props}['loop'] : {$section_props}['loop']-1);\n";
        }

        $output .= "if ({$section_props}['show']) {\n";
        if (!isset($_attr['start']) && !isset($_attr['step']) && !isset($_attr['max'])) {
            $output .= "    {$section_props}['total'] = {$section_props}['loop'];\n";
        } else {
            $output .= "    {$section_props}['total'] = min(ceil(({$section_props}['step'] > 0 ? {$section_props}['loop'] - {$section_props}['start'] : {$section_props}['start']+1)/abs({$section_props}['step'])), {$section_props}['max']);\n";
        }
        $output .= "    if ({$section_props}['total'] == 0)\n" . "        {$section_props}['show'] = false;\n" . "} else\n" . "    {$section_props}['total'] = 0;\n";

        $output .= "if ({$section_props}['show']):\n";
        $output .= "
            for ({$section_props}['index'] = {$section_props}['start'], {$section_props}['iteration'] = 1;
                 {$section_props}['iteration'] <= {$section_props}['total'];
                 {$section_props}['index'] += {$section_props}['step'], {$section_props}['iteration']++):\n";
        $output .= "{$section_props}['rownum'] = {$section_props}['iteration'];\n";
        $output .= "{$section_props}['index_prev'] = {$section_props}['index'] - {$section_props}['step'];\n";
        $output .= "{$section_props}['index_next'] = {$section_props}['index'] + {$section_props}['step'];\n";
        $output .= "{$section_props}['first']      = ({$section_props}['iteration'] == 1);\n";
        $output .= "{$section_props}['last']       = ({$section_props}['iteration'] == {$section_props}['total']);\n";

        $output .= "?>";
        return $output;
    }

}

/**
 * Smarty Internal Plugin Compile Sectionelse Class
 * 
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_Sectionelse extends Smarty_Internal_CompileBase {

    /**
     * Compiles code for the {sectionelse} tag
     *
     * @param array  $args     array with attributes from parser
     * @param object $compiler compiler object
     * @return string compiled code
     */
    public function compile($args, $compiler)
    {
        // check and get attributes
        $_attr = $this->getAttributes($compiler, $args);

        list($openTag, $nocache) = $this->closeTag($compiler, array('section'));
        $this->openTag($compiler, 'sectionelse', array('sectionelse', $nocache));

        return "<?php endfor; else: ?>";
    }

}

/**
 * Smarty Internal Plugin Compile Sectionclose Class
 * 
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_Sectionclose extends Smarty_Internal_CompileBase {

    /**
     * Compiles code for the {/section} tag
     *
     * @param array  $args     array with attributes from parser
     * @param object $compiler compiler object
     * @return string compiled code
     */
    public function compile($args, $compiler)
    {
        // check and get attributes
        $_attr = $this->getAttributes($compiler, $args);

        // must endblock be nocache?
        if ($compiler->nocache) {
            $compiler->tag_nocache = true;
        }

        list($openTag, $compiler->nocache) = $this->closeTag($compiler, array('section', 'sectionelse'));

        if ($openTag == 'sectionelse') {
            return "<?php endif; ?>";
        } else {
            return "<?php endfor; endif; ?>";
        }
    }

}

?><?php
/**
 * Smarty Internal Plugin Compile Eval
 *
 * Compiles the {eval} tag.
 *
 * @package Smarty
 * @subpackage Compiler
 * @author Uwe Tews
 */

/**
 * Smarty Internal Plugin Compile Eval Class
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_Eval extends Smarty_Internal_CompileBase {

    /**
     * Attribute definition: Overwrites base class.
     *
     * @var array
     * @see Smarty_Internal_CompileBase
     */
    public $required_attributes = array('var');
    /**
     * Attribute definition: Overwrites base class.
     *
     * @var array
     * @see Smarty_Internal_CompileBase
     */
    public $optional_attributes = array('assign');
    /**
     * Attribute definition: Overwrites base class.
     *
     * @var array
     * @see Smarty_Internal_CompileBase
     */
    public $shorttag_order = array('var','assign');

    /**
     * Compiles code for the {eval} tag
     *
     * @param array  $args     array with attributes from parser
     * @param object $compiler compiler object
     * @return string compiled code
     */
    public function compile($args, $compiler)
    {
        $this->required_attributes = array('var');
        $this->optional_attributes = array('assign');
        // check and get attributes
        $_attr = $this->getAttributes($compiler, $args);
        if (isset($_attr['assign'])) {
              // output will be stored in a smarty variable instead of beind displayed
            $_assign = $_attr['assign'];
        }

        // create template object
        $_output = "\$_template = new {$compiler->smarty->template_class}('eval:'.".$_attr['var'].", \$_smarty_tpl->smarty, \$_smarty_tpl);";
        //was there an assign attribute?
        if (isset($_assign)) {
            $_output .= "\$_smarty_tpl->assign($_assign,\$_template->fetch());";
        } else {
            $_output .= "echo \$_template->fetch();";
        }
        return "<?php $_output ?>";
    }

}

?><?php
/**
 * Smarty Resource Plugin
 *
 * @package Smarty
 * @subpackage TemplateResources
 * @author Rodney Rehm
 */

/**
 * Smarty Resource Plugin
 *
 * Base implementation for resource plugins that don't use the compiler
 *
 * @package Smarty
 * @subpackage TemplateResources
 */
abstract class Smarty_Resource_Uncompiled extends Smarty_Resource {

    /**
     * Render and output the template (without using the compiler)
     *
     * @param Smarty_Template_Source   $source    source object
     * @param Smarty_Internal_Template $_template template object
     * @throws SmartyException on failure
     */
    public abstract function renderUncompiled(Smarty_Template_Source $source, Smarty_Internal_Template $_template);

    /**
     * populate compiled object with compiled filepath
     *
     * @param Smarty_Template_Compiled $compiled  compiled object
     * @param Smarty_Internal_Template $_template template object (is ignored)
     */
    public function populateCompiledFilepath(Smarty_Template_Compiled $compiled, Smarty_Internal_Template $_template)
    {
        $compiled->filepath = false;
        $compiled->timestamp = false;
        $compiled->exists = false;
    }

}

?><?php
/**
 * Smarty Internal Plugin Resource Stream
 *
 * Implements the streams as resource for Smarty template
 *
 * @package Smarty
 * @subpackage TemplateResources
 * @author Uwe Tews
 * @author Rodney Rehm
 */

/**
 * Smarty Internal Plugin Resource Stream
 *
 * Implements the streams as resource for Smarty template
 *
 * @link http://php.net/streams
 * @package Smarty
 * @subpackage TemplateResources
 */
class Smarty_Internal_Resource_Stream extends Smarty_Resource_Recompiled {

    /**
     * populate Source Object with meta data from Resource
     *
     * @param Smarty_Template_Source   $source    source object
     * @param Smarty_Internal_Template $_template template object
     * @return void
     */
    public function populate(Smarty_Template_Source $source, Smarty_Internal_Template $_template=null)
    {
        $source->filepath = str_replace(':', '://', $source->resource);
        $source->uid = false;
        $source->content = $this->getContent($source);
        $source->timestamp = false;
        $source->exists = !!$source->content;
    }

    /**
     * Load template's source from stream into current template object
     *
     * @param Smarty_Template_Source $source source object
     * @return string template source
     * @throws SmartyException if source cannot be loaded
     */
    public function getContent(Smarty_Template_Source $source)
    {
        $t = '';
        // the availability of the stream has already been checked in Smarty_Resource::fetch()
        $fp = fopen($source->filepath, 'r+');
        if ($fp) {
            while (!feof($fp) && ($current_line = fgets($fp)) !== false) {
                $t .= $current_line;
            }
            fclose($fp);
            return $t;
        } else {
            return false;
        }
    }
    
    /**
     * modify resource_name according to resource handlers specifications
     *
     * @param Smarty $smarty        Smarty instance
     * @param string $resource_name resource_name to make unique
     * @return string unique resource name
     */
    protected function buildUniqueResourceName(Smarty $smarty, $resource_name)
    {
        return get_class($this) . '#' . $resource_name;
    }
}

?><?php
/**
 * Smarty Internal Plugin Compile Object Block Function
 *
 * Compiles code for registered objects as block function
 *
 * @package Smarty
 * @subpackage Compiler
 * @author Uwe Tews
 */

/**
 * Smarty Internal Plugin Compile Object Block Function Class
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_Private_Object_Block_Function extends Smarty_Internal_CompileBase {

    /**
     * Attribute definition: Overwrites base class.
     *
     * @var array
     * @see Smarty_Internal_CompileBase
     */
    public $optional_attributes = array('_any');

    /**
     * Compiles code for the execution of block plugin
     *
     * @param array  $args      array with attributes from parser
     * @param object $compiler  compiler object
     * @param array  $parameter array with compilation parameter
     * @param string $tag       name of block object
     * @param string $method    name of method to call
     * @return string compiled code
     */
    public function compile($args, $compiler, $parameter, $tag, $method)
    {
        if (!isset($tag[5]) || substr($tag, -5) != 'close') {
            // opening tag of block plugin
            // check and get attributes
            $_attr = $this->getAttributes($compiler, $args);
            if ($_attr['nocache'] === true) {
                $compiler->tag_nocache = true;
            }
            unset($_attr['nocache']);
            // convert attributes into parameter array string
            $_paramsArray = array();
            foreach ($_attr as $_key => $_value) {
                if (is_int($_key)) {
                    $_paramsArray[] = "$_key=>$_value";
                } else {
                    $_paramsArray[] = "'$_key'=>$_value";
                }
            }
            $_params = 'array(' . implode(",", $_paramsArray) . ')';

            $this->openTag($compiler, $tag . '->' . $method, array($_params, $compiler->nocache));
            // maybe nocache because of nocache variables or nocache plugin
            $compiler->nocache = $compiler->nocache | $compiler->tag_nocache;
            // compile code
            $output = "<?php \$_smarty_tpl->smarty->_tag_stack[] = array('{$tag}->{$method}', {$_params}); \$_block_repeat=true; echo \$_smarty_tpl->smarty->registered_objects['{$tag}'][0]->{$method}({$_params}, null, \$_smarty_tpl, \$_block_repeat);while (\$_block_repeat) { ob_start();?>";
        } else {
            $base_tag = substr($tag, 0, -5);
            // must endblock be nocache?
            if ($compiler->nocache) {
                $compiler->tag_nocache = true;
            }
            // closing tag of block plugin, restore nocache
            list($_params, $compiler->nocache) = $this->closeTag($compiler, $base_tag . '->' . $method);
            // This tag does create output
            $compiler->has_output = true;
            // compile code
            if (!isset($parameter['modifier_list'])) {
                $mod_pre = $mod_post = '';
            } else {
                $mod_pre = ' ob_start(); ';
                $mod_post = 'echo ' . $compiler->compileTag('private_modifier', array(), array('modifierlist' => $parameter['modifier_list'], 'value' => 'ob_get_clean()')) . ';';
            }
            $output = "<?php \$_block_content = ob_get_contents(); ob_end_clean(); \$_block_repeat=false;" . $mod_pre . " echo \$_smarty_tpl->smarty->registered_objects['{$base_tag}'][0]->{$method}({$_params}, \$_block_content, \$_smarty_tpl, \$_block_repeat); " . $mod_post . "  } array_pop(\$_smarty_tpl->smarty->_tag_stack);?>";
        }
        return $output . "\n";
    }

}

?><?php
/**
 * Smarty write file plugin
 *
 * @package Smarty
 * @subpackage PluginsInternal
 * @author Monte Ohrt
 */

/**
 * Smarty Internal Write File Class
 *
 * @package Smarty
 * @subpackage PluginsInternal
 */
class Smarty_Internal_Write_File {

    /**
     * Writes file in a safe way to disk
     *
     * @param string $_filepath complete filepath
     * @param string $_contents file content
     * @param Smarty $smarty    smarty instance
     * @return boolean true
     */
    public static function writeFile($_filepath, $_contents, Smarty $smarty)
    {
        $_error_reporting = error_reporting();
        error_reporting($_error_reporting & ~E_NOTICE & ~E_WARNING);
        if ($smarty->_file_perms !== null) {
            $old_umask = umask(0);
        }

        $_dirpath = dirname($_filepath);
        // if subdirs, create dir structure
        if ($_dirpath !== '.' && !file_exists($_dirpath)) {
            mkdir($_dirpath, $smarty->_dir_perms === null ? 0777 : $smarty->_dir_perms, true);
        }

        // write to tmp file, then move to overt file lock race condition
        $_tmp_file = $_dirpath . DS . uniqid('wrt');
        if (!file_put_contents($_tmp_file, $_contents)) {
            error_reporting($_error_reporting);
            throw new SmartyException("unable to write file {$_tmp_file}");
            return false;
        }

        // remove original file
        unlink($_filepath);

        // rename tmp file
        $success = rename($_tmp_file, $_filepath);
        if (!$success) {
            error_reporting($_error_reporting);
            throw new SmartyException("unable to write file {$_filepath}");
            return false;
        }

        if ($smarty->_file_perms !== null) {
            // set file permissions
            chmod($_filepath, $smarty->_file_perms);
            umask($old_umask);
        }
        error_reporting($_error_reporting);
        return true;
    }

}

?><?php
/**
 * Smarty Internal Plugin Compile Continue
 *
 * Compiles the {continue} tag
 *
 * @package Smarty
 * @subpackage Compiler
 * @author Uwe Tews
 */

/**
 * Smarty Internal Plugin Compile Continue Class
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_Continue extends Smarty_Internal_CompileBase {

    /**
     * Attribute definition: Overwrites base class.
     *
     * @var array
     * @see Smarty_Internal_CompileBase
     */
    public $optional_attributes = array('levels');
    /**
     * Attribute definition: Overwrites base class.
     *
     * @var array
     * @see Smarty_Internal_CompileBase
     */
    public $shorttag_order = array('levels');

    /**
     * Compiles code for the {continue} tag
     *
     * @param array  $args      array with attributes from parser
     * @param object $compiler  compiler object
     * @param array  $parameter array with compilation parameter
     * @return string compiled code
     */
    public function compile($args, $compiler, $parameter)
    {
        static $_is_loopy = array('for' => true, 'foreach' => true, 'while' => true, 'section' => true);
        // check and get attributes
        $_attr = $this->getAttributes($compiler, $args);

        if ($_attr['nocache'] === true) {
            $compiler->trigger_template_error('nocache option not allowed', $compiler->lex->taglineno);
        }

        if (isset($_attr['levels'])) {
            if (!is_numeric($_attr['levels'])) {
                $compiler->trigger_template_error('level attribute must be a numeric constant', $compiler->lex->taglineno);
            }
            $_levels = $_attr['levels'];
        } else {
            $_levels = 1;
        }
        $level_count = $_levels;
        $stack_count = count($compiler->_tag_stack) - 1;
        while ($level_count > 0 && $stack_count >= 0) {
            if (isset($_is_loopy[$compiler->_tag_stack[$stack_count][0]])) {
                $level_count--;
            }
            $stack_count--;
        }
        if ($level_count != 0) {
            $compiler->trigger_template_error("cannot continue {$_levels} level(s)", $compiler->lex->taglineno);
        }
        $compiler->has_code = true;
        return "<?php continue {$_levels}?>";
    }

}

?><?php

/**
 * Smarty Internal Plugin Compile Modifier
 *
 * Compiles code for modifier execution
 *
 * @package Smarty
 * @subpackage Compiler
 * @author Uwe Tews
 */

/**
 * Smarty Internal Plugin Compile Modifier Class
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_Private_Modifier extends Smarty_Internal_CompileBase {

    /**
     * Compiles code for modifier execution
     *
     * @param array  $args      array with attributes from parser
     * @param object $compiler  compiler object
     * @param array  $parameter array with compilation parameter
     * @return string compiled code
     */
    public function compile($args, $compiler, $parameter)
    {
        // check and get attributes
        $_attr = $this->getAttributes($compiler, $args);
        $output = $parameter['value'];
        // loop over list of modifiers
        foreach ($parameter['modifierlist'] as $single_modifier) {
            $modifier = $single_modifier[0];
            $single_modifier[0] = $output;
            $params = implode(',', $single_modifier);
            // check for registered modifier
            if (isset($compiler->smarty->registered_plugins[Smarty::PLUGIN_MODIFIER][$modifier])) {
                $function = $compiler->smarty->registered_plugins[Smarty::PLUGIN_MODIFIER][$modifier][0];
                if (!is_array($function)) {
                    $output = "{$function}({$params})";
                } else {
                    if (is_object($function[0])) {
                        $output = '$_smarty_tpl->smarty->registered_plugins[Smarty::PLUGIN_MODIFIER][\'' . $modifier . '\'][0][0]->' . $function[1] . '(' . $params . ')';
                    } else {
                        $output = $function[0] . '::' . $function[1] . '(' . $params . ')';
                    }
                }
            } else if (isset($compiler->smarty->registered_plugins[Smarty::PLUGIN_MODIFIERCOMPILER][$modifier][0])) {
                $output = call_user_func($compiler->smarty->registered_plugins[Smarty::PLUGIN_MODIFIERCOMPILER][$modifier][0], $single_modifier, $compiler->smarty);
                // check for plugin modifiercompiler
            } else if ($compiler->smarty->loadPlugin('smarty_modifiercompiler_' . $modifier)) {
                // check if modifier allowed
                if (!is_object($compiler->smarty->security_policy) || $compiler->smarty->security_policy->isTrustedModifier($modifier, $compiler)) {
                    $plugin = 'smarty_modifiercompiler_' . $modifier;
                    $output = $plugin($single_modifier, $compiler);
                }
                // check for plugin modifier
            } else if ($function = $compiler->getPlugin($modifier, Smarty::PLUGIN_MODIFIER)) {
                // check if modifier allowed
                if (!is_object($compiler->smarty->security_policy) || $compiler->smarty->security_policy->isTrustedModifier($modifier, $compiler)) {
                    $output = "{$function}({$params})";
                }
                // check if trusted PHP function
            } else if (is_callable($modifier)) {
                // check if modifier allowed
                if (!is_object($compiler->smarty->security_policy) || $compiler->smarty->security_policy->isTrustedPhpModifier($modifier, $compiler)) {
                    $output = "{$modifier}({$params})";
                }
            } else {
                $compiler->trigger_template_error("unknown modifier \"" . $modifier . "\"", $compiler->lex->taglineno);
            }
        }
        return $output;
    }

}

?><?php
/**
 * Smarty Internal Plugin Nocache Insert
 *
 * Compiles the {insert} tag into the cache file
 *
 * @package Smarty
 * @subpackage Compiler
 * @author Uwe Tews
 */

/**
 * Smarty Internal Plugin Compile Insert Class
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Nocache_Insert {

    /**
     * Compiles code for the {insert} tag into cache file
     *
     * @param string                   $_function insert function name
     * @param array                    $_attr     array with paramter
     * @param Smarty_Internal_Template $_template template object
     * @param string                   $_script   script name to load or 'null'
     * @param string                   $_assign   optional variable name
     * @return string compiled code
     */
    public static function compile($_function, $_attr, $_template, $_script, $_assign = null)
    {
        $_output = '<?php ';
        if ($_script != 'null') {
            // script which must be included
            // code for script file loading
            $_output .= "require_once '{$_script}';";
        }
        // call insert
        if (isset($_assign)) {
            $_output .= "\$_smarty_tpl->assign('{$_assign}' , {$_function} (" . var_export($_attr, true) . ",\$_smarty_tpl), true);?>";
        } else {
            $_output .= "echo {$_function}(" . var_export($_attr, true) . ",\$_smarty_tpl);?>";
        }
        $_tpl = $_template;
        while ($_tpl->parent instanceof Smarty_Internal_Template) {
            $_tpl = $_tpl->parent;
        }
        return "/*%%SmartyNocache:{$_tpl->properties['nocache_hash']}%%*/" . $_output . "/*/%%SmartyNocache:{$_tpl->properties['nocache_hash']}%%*/";
    }

}

?><?php
/**
 * Smarty Internal Plugin Compile Registered Block
 *
 * Compiles code for the execution of a registered block function
 *
 * @package Smarty
 * @subpackage Compiler
 * @author Uwe Tews
 */

/**
 * Smarty Internal Plugin Compile Registered Block Class
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_Private_Registered_Block extends Smarty_Internal_CompileBase {

    /**
     * Attribute definition: Overwrites base class.
     *
     * @var array
     * @see Smarty_Internal_CompileBase
     */
    public $optional_attributes = array('_any');

    /**
     * Compiles code for the execution of a block function
     *
     * @param array  $args      array with attributes from parser
     * @param object $compiler  compiler object
     * @param array  $parameter array with compilation parameter
     * @param string $tag       name of block function
     * @return string compiled code
     */
    public function compile($args, $compiler, $parameter, $tag)
    {
        if (!isset($tag[5]) || substr($tag,-5) != 'close') {
            // opening tag of block plugin
            // check and get attributes
            $_attr = $this->getAttributes($compiler, $args);
            if ($_attr['nocache']) {
                $compiler->tag_nocache = true;
            }
               unset($_attr['nocache']);
               if (isset($compiler->smarty->registered_plugins[Smarty::PLUGIN_BLOCK][$tag])) {
                   $tag_info = $compiler->smarty->registered_plugins[Smarty::PLUGIN_BLOCK][$tag];
               } else {
                   $tag_info = $compiler->default_handler_plugins[Smarty::PLUGIN_BLOCK][$tag];
               }
            // convert attributes into parameter array string
            $_paramsArray = array();
            foreach ($_attr as $_key => $_value) {
                if (is_int($_key)) {
                    $_paramsArray[] = "$_key=>$_value";
                } elseif ($compiler->template->caching && in_array($_key,$tag_info[2])) {
                    $_value = str_replace("'","^#^",$_value);
                    $_paramsArray[] = "'$_key'=>^#^.var_export($_value,true).^#^";
                } else {
                    $_paramsArray[] = "'$_key'=>$_value";
                }
            }
            $_params = 'array(' . implode(",", $_paramsArray) . ')';

            $this->openTag($compiler, $tag, array($_params, $compiler->nocache));
            // maybe nocache because of nocache variables or nocache plugin
            $compiler->nocache = !$tag_info[1] | $compiler->nocache | $compiler->tag_nocache;
            $function = $tag_info[0];
            // compile code
            if (!is_array($function)) {
                $output = "<?php \$_smarty_tpl->smarty->_tag_stack[] = array('{$tag}', {$_params}); \$_block_repeat=true; echo {$function}({$_params}, null, \$_smarty_tpl, \$_block_repeat);while (\$_block_repeat) { ob_start();?>";
            } else if (is_object($function[0])) {
                $output = "<?php \$_smarty_tpl->smarty->_tag_stack[] = array('{$tag}', {$_params}); \$_block_repeat=true; echo \$_smarty_tpl->smarty->registered_plugins['block']['{$tag}'][0][0]->{$function[1]}({$_params}, null, \$_smarty_tpl, \$_block_repeat);while (\$_block_repeat) { ob_start();?>";
            } else {
                $output = "<?php \$_smarty_tpl->smarty->_tag_stack[] = array('{$tag}', {$_params}); \$_block_repeat=true; echo {$function[0]}::{$function[1]}({$_params}, null, \$_smarty_tpl, \$_block_repeat);while (\$_block_repeat) { ob_start();?>";
            }
        } else {
            // must endblock be nocache?
            if ($compiler->nocache) {
                $compiler->tag_nocache = true;
            }
            $base_tag = substr($tag, 0, -5);
            // closing tag of block plugin, restore nocache
            list($_params, $compiler->nocache) = $this->closeTag($compiler, $base_tag);
            // This tag does create output
            $compiler->has_output = true;
               if (isset($compiler->smarty->registered_plugins[Smarty::PLUGIN_BLOCK][$base_tag])) {
                   $function = $compiler->smarty->registered_plugins[Smarty::PLUGIN_BLOCK][$base_tag][0];
               } else {
                   $function = $compiler->default_handler_plugins[Smarty::PLUGIN_BLOCK][$base_tag][0];
               }
            // compile code
            if (!isset($parameter['modifier_list'])) {
                $mod_pre = $mod_post ='';
            } else {
                $mod_pre = ' ob_start(); ';
                $mod_post = 'echo '.$compiler->compileTag('private_modifier',array(),array('modifierlist'=>$parameter['modifier_list'],'value'=>'ob_get_clean()')).';';
            }
            if (!is_array($function)) {
                $output = "<?php \$_block_content = ob_get_clean(); \$_block_repeat=false;".$mod_pre." echo {$function}({$_params}, \$_block_content, \$_smarty_tpl, \$_block_repeat);".$mod_post." } array_pop(\$_smarty_tpl->smarty->_tag_stack);?>";
            } else if (is_object($function[0])) {
                $output = "<?php \$_block_content = ob_get_clean(); \$_block_repeat=false;".$mod_pre." echo \$_smarty_tpl->smarty->registered_plugins['block']['{$base_tag}'][0][0]->{$function[1]}({$_params}, \$_block_content, \$_smarty_tpl, \$_block_repeat); ".$mod_post."} array_pop(\$_smarty_tpl->smarty->_tag_stack);?>";
            } else {
                $output = "<?php \$_block_content = ob_get_clean(); \$_block_repeat=false;".$mod_pre." echo {$function[0]}::{$function[1]}({$_params}, \$_block_content, \$_smarty_tpl, \$_block_repeat); ".$mod_post."} array_pop(\$_smarty_tpl->smarty->_tag_stack);?>";
            }
        }
        return $output . "\n";
    }

}

?><?php
/**
 * Smarty Internal Plugin Compile Setfilter
 *
 * Compiles code for setfilter tag
 *
 * @package Smarty
 * @subpackage Compiler
 * @author Uwe Tews
 */

/**
 * Smarty Internal Plugin Compile Setfilter Class
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_Setfilter extends Smarty_Internal_CompileBase {

    /**
     * Compiles code for setfilter tag
     *
     * @param array  $args      array with attributes from parser
     * @param object $compiler  compiler object
     * @param array  $parameter array with compilation parameter
     * @return string compiled code
     */
    public function compile($args, $compiler, $parameter)
    {
        $compiler->variable_filter_stack[] = $compiler->template->variable_filters;
        $compiler->template->variable_filters = $parameter['modifier_list'];
        // this tag does not return compiled code
        $compiler->has_code = false;
        return true;
    }

}

/**
 * Smarty Internal Plugin Compile Setfilterclose Class
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_Setfilterclose extends Smarty_Internal_CompileBase {

    /**
     * Compiles code for the {/setfilter} tag
     *
     * This tag does not generate compiled output. It resets variable filter.
     *
     * @param array  $args     array with attributes from parser
     * @param object $compiler compiler object
     * @return string compiled code
     */
    public function compile($args, $compiler)
    {
        $_attr = $this->getAttributes($compiler, $args);
        // reset variable filter to previous state
        if (count($compiler->variable_filter_stack)) {
            $compiler->template->variable_filters = array_pop($compiler->variable_filter_stack);
        } else {
            $compiler->template->variable_filters = array();
        }
        // this tag does not return compiled code
        $compiler->has_code = false;
        return true;
    }

}

?><?php
/**
 * Smarty Internal Plugin Compile Ldelim
 *
 * Compiles the {ldelim} tag
 *
 * @package Smarty
 * @subpackage Compiler
 * @author Uwe Tews
 */

/**
 * Smarty Internal Plugin Compile Ldelim Class
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_Ldelim extends Smarty_Internal_CompileBase {

    /**
     * Compiles code for the {ldelim} tag
     *
     * This tag does output the left delimiter
     * @param array  $args     array with attributes from parser
     * @param object $compiler compiler object
     * @return string compiled code
     */
    public function compile($args, $compiler)
    {
        $_attr = $this->getAttributes($compiler, $args);
        if ($_attr['nocache'] === true) {
            $compiler->trigger_template_error('nocache option not allowed', $compiler->lex->taglineno);
        }
        // this tag does not return compiled code
        $compiler->has_code = true;
        return $compiler->smarty->left_delimiter;
    }

}

?>
<?php
/**
 * Smarty Internal Plugin CacheResource File
 *
 * @package Smarty
 * @subpackage Cacher
 * @author Uwe Tews
 * @author Rodney Rehm
 */

/**
 * This class does contain all necessary methods for the HTML cache on file system
 *
 * Implements the file system as resource for the HTML cache Version ussing nocache inserts.
 *
 * @package Smarty
 * @subpackage Cacher
 */
class Smarty_Internal_CacheResource_File extends Smarty_CacheResource {

    /**
     * populate Cached Object with meta data from Resource
     *
     * @param Smarty_Template_Cached   $cached    cached object
     * @param Smarty_Internal_Template $_template template object
     * @return void
     */
    public function populate(Smarty_Template_Cached $cached, Smarty_Internal_Template $_template)
    {
        $_source_file_path = str_replace(':', '.', $_template->source->filepath);
        $_cache_id = isset($_template->cache_id) ? preg_replace('![^\w\|]+!', '_', $_template->cache_id) : null;
        $_compile_id = isset($_template->compile_id) ? preg_replace('![^\w\|]+!', '_', $_template->compile_id) : null;
        $_filepath = $_template->source->uid;
        // if use_sub_dirs, break file into directories
        if ($_template->smarty->use_sub_dirs) {
            $_filepath = substr($_filepath, 0, 2) . DS
                . substr($_filepath, 2, 2) . DS
                . substr($_filepath, 4, 2) . DS
                . $_filepath;
        }
        $_compile_dir_sep = $_template->smarty->use_sub_dirs ? DS : '^';
        if (isset($_cache_id)) {
            $_cache_id = str_replace('|', $_compile_dir_sep, $_cache_id) . $_compile_dir_sep;
        } else {
            $_cache_id = '';
        }
        if (isset($_compile_id)) {
            $_compile_id = $_compile_id . $_compile_dir_sep;
        } else {
            $_compile_id = '';
        }
        $_cache_dir = $_template->smarty->getCacheDir();
        if ($_template->smarty->cache_locking) {
            // create locking file name
            // relative file name?
            if (!preg_match('/^([\/\\\\]|[a-zA-Z]:[\/\\\\])/', $_cache_dir)) {
                $_lock_dir = rtrim(getcwd(), '/\\') . DS . $_cache_dir;
            } else {
                $_lock_dir = $_cache_dir;
            }
            $cached->lock_id = $_lock_dir.sha1($_cache_id.$_compile_id.$_template->source->uid).'.lock';
        }
        $cached->filepath = $_cache_dir . $_cache_id . $_compile_id . $_filepath . '.' . basename($_source_file_path) . '.php';
        $cached->timestamp = @filemtime($cached->filepath);
        $cached->exists = !!$cached->timestamp;
    }

    /**
     * populate Cached Object with timestamp and exists from Resource
     *
     * @param Smarty_Template_Cached $cached cached object
     * @return void
     */
    public function populateTimestamp(Smarty_Template_Cached $cached)
    {
        $cached->timestamp = @filemtime($cached->filepath);
        $cached->exists = !!$cached->timestamp;
    }

    /**
     * Read the cached template and process its header
     *
     * @param Smarty_Internal_Template $_template template object
     * @param Smarty_Template_Cached $cached cached object
     * @return booelan true or false if the cached content does not exist
     */
    public function process(Smarty_Internal_Template $_template, Smarty_Template_Cached $cached=null)
    {
        $_smarty_tpl = $_template;
        return @include $_template->cached->filepath;
    }

    /**
     * Write the rendered template output to cache
     *
     * @param Smarty_Internal_Template $_template template object
     * @param string                   $content   content to cache
     * @return boolean success
     */
    public function writeCachedContent(Smarty_Internal_Template $_template, $content)
    {
        if (Smarty_Internal_Write_File::writeFile($_template->cached->filepath, $content, $_template->smarty) === true) {
            $_template->cached->timestamp = filemtime($_template->cached->filepath);
            $_template->cached->exists = !!$_template->cached->timestamp;
            return true;
        }
        return false;
    }

    /**
     * Empty cache
     *
     * @param Smarty_Internal_Template $_template template object
     * @param integer                  $exp_time  expiration time (number of seconds, not timestamp)
     * @return integer number of cache files deleted
     */
    public function clearAll(Smarty $smarty, $exp_time = null)
    {
        return $this->clear($smarty, null, null, null, $exp_time);
    }

    /**
     * Empty cache for a specific template
     *
     * @param Smarty  $_template     template object
     * @param string  $resource_name template name
     * @param string  $cache_id      cache id
     * @param string  $compile_id    compile id
     * @param integer $exp_time      expiration time (number of seconds, not timestamp)
     * @return integer number of cache files deleted
    */
    public function clear(Smarty $smarty, $resource_name, $cache_id, $compile_id, $exp_time)
    {
        $_cache_id = isset($cache_id) ? preg_replace('![^\w\|]+!', '_', $cache_id) : null;
        $_compile_id = isset($compile_id) ? preg_replace('![^\w\|]+!', '_', $compile_id) : null;
        $_dir_sep = $smarty->use_sub_dirs ? '/' : '^';
        $_compile_id_offset = $smarty->use_sub_dirs ? 3 : 0;
        $_dir = $smarty->getCacheDir();
        $_dir_length = strlen($_dir);
        if (isset($_cache_id)) {
            $_cache_id_parts = explode('|', $_cache_id);
            $_cache_id_parts_count = count($_cache_id_parts);
            if ($smarty->use_sub_dirs) {
                foreach ($_cache_id_parts as $id_part) {
                    $_dir .= $id_part . DS;
                }
            }
        }
        if (isset($resource_name)) {
            $_save_stat = $smarty->caching;
            $smarty->caching = true;
            $tpl = new $smarty->template_class($resource_name, $smarty);
            $smarty->caching = $_save_stat;

            // remove from template cache
            $tpl->source; // have the template registered before unset()
            $_templateId = sha1($tpl->source->unique_resource . $tpl->cache_id . $tpl->compile_id);
            unset($smarty->template_objects[$_templateId]);

            if ($tpl->source->exists) {
                $_resourcename_parts = basename(str_replace('^', '/', $tpl->cached->filepath));
            } else {
                return 0;
            }
        }
        $_count = 0;
        $_time = time();
        if (file_exists($_dir)) {
            $_cacheDirs = new RecursiveDirectoryIterator($_dir);
            $_cache = new RecursiveIteratorIterator($_cacheDirs, RecursiveIteratorIterator::CHILD_FIRST);
            foreach ($_cache as $_file) {
                if (substr($_file->getBasename(),0,1) == '.' || strpos($_file, '.svn') !== false) continue;
                // directory ?
                if ($_file->isDir()) {
                    if (!$_cache->isDot()) {
                        // delete folder if empty
                        @rmdir($_file->getPathname());
                    }
                } else {
                    $_parts = explode($_dir_sep, str_replace('\\', '/', substr((string)$_file, $_dir_length)));
                    $_parts_count = count($_parts);
                    // check name
                    if (isset($resource_name)) {
                        if ($_parts[$_parts_count-1] != $_resourcename_parts) {
                            continue;
                        }
                    }
                    // check compile id
                    if (isset($_compile_id) && (!isset($_parts[$_parts_count-2 - $_compile_id_offset]) || $_parts[$_parts_count-2 - $_compile_id_offset] != $_compile_id)) {
                        continue;
                    }
                    // check cache id
                    if (isset($_cache_id)) {
                        // count of cache id parts
                        $_parts_count = (isset($_compile_id)) ? $_parts_count - 2 - $_compile_id_offset : $_parts_count - 1 - $_compile_id_offset;
                        if ($_parts_count < $_cache_id_parts_count) {
                            continue;
                        }
                        for ($i = 0; $i < $_cache_id_parts_count; $i++) {
                            if ($_parts[$i] != $_cache_id_parts[$i]) continue 2;
                        }
                    }
                    // expired ?
                    if (isset($exp_time) && $_time - @filemtime($_file) < $exp_time) {
                        continue;
                    }
                    $_count += @unlink((string) $_file) ? 1 : 0;
                }
            }
        }
        return $_count;
    }

    /**
     * Check is cache is locked for this template
     *
     * @param Smarty $smarty Smarty object
     * @param Smarty_Template_Cached $cached cached object
     * @return booelan true or false if cache is locked
     */
    public function hasLock(Smarty $smarty, Smarty_Template_Cached $cached)
    {
        if (version_compare(PHP_VERSION, '5.3.0', '>=')) {
            clearstatcache(true, $cached->lock_id);
        } else {
            clearstatcache();
        }
        $t = @filemtime($cached->lock_id);
        return $t && (time() - $t < $smarty->locking_timeout);
    }

    /**
     * Lock cache for this template
     *
     * @param Smarty $smarty Smarty object
     * @param Smarty_Template_Cached $cached cached object
     */
    public function acquireLock(Smarty $smarty, Smarty_Template_Cached $cached)
    {
        $cached->is_locked = true;
        touch($cached->lock_id);
    }

    /**
     * Unlock cache for this template
     *
     * @param Smarty $smarty Smarty object
     * @param Smarty_Template_Cached $cached cached object
     */
    public function releaseLock(Smarty $smarty, Smarty_Template_Cached $cached)
    {
        $cached->is_locked = false;
        @unlink($cached->lock_id);
    }
}

?><?php
/**
 * Smarty Internal Plugin Smarty Template  Base
 *
 * This file contains the basic shared methodes for template handling
 *
 * @package Smarty
 * @subpackage Template
 * @author Uwe Tews
 */

/**
 * Class with shared template methodes
 *
 * @package Smarty
 * @subpackage Template
 */
abstract class Smarty_Internal_TemplateBase extends Smarty_Internal_Data {

    /**
     * fetches a rendered Smarty template
     *
     * @param string $template          the resource handle of the template file or template object
     * @param mixed  $cache_id          cache id to be used with this template
     * @param mixed  $compile_id        compile id to be used with this template
     * @param object $parent            next higher level of Smarty variables
     * @param bool   $display           true: display, false: fetch
     * @param bool   $merge_tpl_vars    if true parent template variables merged in to local scope
     * @param bool   $no_output_filter  if true do not run output filter
     * @return string rendered template output
     */
    public function fetch($template = null, $cache_id = null, $compile_id = null, $parent = null, $display = false, $merge_tpl_vars = true, $no_output_filter = false)
    {
        if ($template === null && $this instanceof $this->template_class) {
            $template = $this;
        }
        if (!empty($cache_id) && is_object($cache_id)) {
            $parent = $cache_id;
            $cache_id = null;
        }
        if ($parent === null && ($this instanceof Smarty || is_string($template))) {
            $parent = $this;
        }
        // create template object if necessary
        $_template = ($template instanceof $this->template_class)
            ? $template
            : $this->smarty->createTemplate($template, $cache_id, $compile_id, $parent, false);
        // if called by Smarty object make sure we use current caching status
        if ($this instanceof Smarty) {
            $_template->caching = $this->caching;
        }
        // merge all variable scopes into template
        if ($merge_tpl_vars) {
            // save local variables
            $save_tpl_vars = $_template->tpl_vars;
            $save_config_vars = $_template->config_vars;
            $ptr_array = array($_template);
            $ptr = $_template;
            while (isset($ptr->parent)) {
                $ptr_array[] = $ptr = $ptr->parent;
            }
            $ptr_array = array_reverse($ptr_array);
            $parent_ptr = reset($ptr_array);
            $tpl_vars = $parent_ptr->tpl_vars;
            $config_vars = $parent_ptr->config_vars;
            while ($parent_ptr = next($ptr_array)) {
                if (!empty($parent_ptr->tpl_vars)) {
                    $tpl_vars = array_merge($tpl_vars, $parent_ptr->tpl_vars);
                }
                if (!empty($parent_ptr->config_vars)) {
                    $config_vars = array_merge($config_vars, $parent_ptr->config_vars);
                }
            }
            if (!empty(Smarty::$global_tpl_vars)) {
                $tpl_vars = array_merge(Smarty::$global_tpl_vars, $tpl_vars);
            }
            $_template->tpl_vars = $tpl_vars;
            $_template->config_vars = $config_vars;
        }
        // dummy local smarty variable
        if (!isset($_template->tpl_vars['smarty'])) {
            $_template->tpl_vars['smarty'] = new Smarty_Variable;
        }
        if (isset($this->smarty->error_reporting)) {
            $_smarty_old_error_level = error_reporting($this->smarty->error_reporting);
        }
        // check URL debugging control
        if (!$this->smarty->debugging && $this->smarty->debugging_ctrl == 'URL') {
            if (isset($_SERVER['QUERY_STRING'])) {
                $_query_string = $_SERVER['QUERY_STRING'];
            } else {
                $_query_string = '';
            }
            if (false !== strpos($_query_string, $this->smarty->smarty_debug_id)) {
                if (false !== strpos($_query_string, $this->smarty->smarty_debug_id . '=on')) {
                    // enable debugging for this browser session
                    setcookie('SMARTY_DEBUG', true);
                    $this->smarty->debugging = true;
                } elseif (false !== strpos($_query_string, $this->smarty->smarty_debug_id . '=off')) {
                    // disable debugging for this browser session
                    setcookie('SMARTY_DEBUG', false);
                    $this->smarty->debugging = false;
                } else {
                    // enable debugging for this page
                    $this->smarty->debugging = true;
                }
            } else {
                if (isset($_COOKIE['SMARTY_DEBUG'])) {
                    $this->smarty->debugging = true;
                }
            }
        }
        // must reset merge template date
        $_template->smarty->merged_templates_func = array();
        // get rendered template
        // disable caching for evaluated code
        if ($_template->source->recompiled) {
            $_template->caching = false;
        }
        // checks if template exists
        if (!$_template->source->exists) {
            if ($_template->parent instanceof Smarty_Internal_Template) {
                $parent_resource = " in '{$_template->parent->template_resource}'";
            } else {
                $parent_resource = '';
            }
            throw new SmartyException("Unable to load template {$_template->source->type} '{$_template->source->name}'{$parent_resource}");
        }
        // read from cache or render
        if (!($_template->caching == Smarty::CACHING_LIFETIME_CURRENT || $_template->caching == Smarty::CACHING_LIFETIME_SAVED) || !$_template->cached->valid) {
            // render template (not loaded and not in cache)
            if (!$_template->source->uncompiled) {
                $_smarty_tpl = $_template;
                if ($_template->source->recompiled) {
                    if ($this->smarty->debugging) {
                        Smarty_Internal_Debug::start_compile($_template);
                    }
                    $code = $_template->compiler->compileTemplate($_template);
                    if ($this->smarty->debugging) {
                        Smarty_Internal_Debug::end_compile($_template);
                    }
                    if ($this->smarty->debugging) {
                        Smarty_Internal_Debug::start_render($_template);
                    }
                    try {
                        ob_start();
                        eval("?>" . $code);
                        unset($code);
                    } catch (Exception $e) {
                        ob_get_clean();
                        throw $e;
                    }
                } else {
                    if (!$_template->compiled->exists || ($_template->smarty->force_compile && !$_template->compiled->isCompiled)) {
                        $_template->compileTemplateSource();
                    }
                    if ($this->smarty->debugging) {
                        Smarty_Internal_Debug::start_render($_template);
                    }
                    if (!$_template->compiled->loaded) {
                        include($_template->compiled->filepath);
                        if ($_template->mustCompile) {
                            // recompile and load again
                            $_template->compileTemplateSource();
                            include($_template->compiled->filepath);
                        }
                        $_template->compiled->loaded = true;
                    } else {
                        $_template->decodeProperties($_template->compiled->_properties, false);
                    }
                    try {
                        ob_start();
                        if (empty($_template->properties['unifunc']) || !is_callable($_template->properties['unifunc'])) {
                            throw new SmartyException("Invalid compiled template for '{$_template->template_resource}'");
                        }
                        $_template->properties['unifunc']($_template);
                        if (isset($_template->_capture_stack[0])) {
                            $_template->capture_error();
                        }
                    } catch (Exception $e) {
                        ob_get_clean();
                        throw $e;
                    }
                }
            } else {
                if ($_template->source->uncompiled) {
                    if ($this->smarty->debugging) {
                        Smarty_Internal_Debug::start_render($_template);
                    }
                    try {
                        ob_start();
                        $_template->source->renderUncompiled($_template);
                    } catch (Exception $e) {
                        ob_get_clean();
                        throw $e;
                    }
                } else {
                    throw new SmartyException("Resource '$_template->source->type' must have 'renderUncompiled' method");
                }
            }
            $_output = ob_get_clean();
            if (!$_template->source->recompiled && empty($_template->properties['file_dependency'][$_template->source->uid])) {
                $_template->properties['file_dependency'][$_template->source->uid] = array($_template->source->filepath, $_template->source->timestamp, $_template->source->type);
            }
            if ($_template->parent instanceof Smarty_Internal_Template) {
                $_template->parent->properties['file_dependency'] = array_merge($_template->parent->properties['file_dependency'], $_template->properties['file_dependency']);
                foreach ($_template->required_plugins as $code => $tmp1) {
                    foreach ($tmp1 as $name => $tmp) {
                        foreach ($tmp as $type => $data) {
                            $_template->parent->required_plugins[$code][$name][$type] = $data;
                        }
                    }
                }
            }
            if ($this->smarty->debugging) {
                Smarty_Internal_Debug::end_render($_template);
            }
            // write to cache when nessecary
            if (!$_template->source->recompiled && ($_template->caching == Smarty::CACHING_LIFETIME_SAVED || $_template->caching == Smarty::CACHING_LIFETIME_CURRENT)) {
                if ($this->smarty->debugging) {
                    Smarty_Internal_Debug::start_cache($_template);
                }
                $_template->properties['has_nocache_code'] = false;
                // get text between non-cached items
                $cache_split = preg_split("!/\*%%SmartyNocache:{$_template->properties['nocache_hash']}%%\*\/(.+?)/\*/%%SmartyNocache:{$_template->properties['nocache_hash']}%%\*/!s", $_output);
                // get non-cached items
                preg_match_all("!/\*%%SmartyNocache:{$_template->properties['nocache_hash']}%%\*\/(.+?)/\*/%%SmartyNocache:{$_template->properties['nocache_hash']}%%\*/!s", $_output, $cache_parts);
                $output = '';
                // loop over items, stitch back together
                foreach ($cache_split as $curr_idx => $curr_split) {
                    // escape PHP tags in template content
                    $output .= preg_replace('/(<%|%>|<\?php|<\?|\?>)/', '<?php echo \'$1\'; ?>', $curr_split);
                    if (isset($cache_parts[0][$curr_idx])) {
                        $_template->properties['has_nocache_code'] = true;
                        // remove nocache tags from cache output
                        $output .= preg_replace("!/\*/?%%SmartyNocache:{$_template->properties['nocache_hash']}%%\*/!", '', $cache_parts[0][$curr_idx]);
                    }
                }
                if (!$no_output_filter && (isset($this->smarty->autoload_filters['output']) || isset($this->smarty->registered_filters['output']))) {
                    $output = Smarty_Internal_Filter_Handler::runFilter('output', $output, $_template);
                }
                // rendering (must be done before writing cache file because of {function} nocache handling)
                $_smarty_tpl = $_template;
                try {
                    ob_start();
                    eval("?>" . $output);
                    $_output = ob_get_clean();
                } catch (Exception $e) {
                    ob_get_clean();
                    throw $e;
                }
                // write cache file content
                $_template->writeCachedContent($output);
                if ($this->smarty->debugging) {
                    Smarty_Internal_Debug::end_cache($_template);
                }
            } else {
                // var_dump('renderTemplate', $_template->has_nocache_code, $_template->template_resource, $_template->properties['nocache_hash'], $_template->parent->properties['nocache_hash'], $_output);
                if (!empty($_template->properties['nocache_hash']) && !empty($_template->parent->properties['nocache_hash'])) {
                    // replace nocache_hash
                    $_output = preg_replace("/{$_template->properties['nocache_hash']}/", $_template->parent->properties['nocache_hash'], $_output);
                    $_template->parent->has_nocache_code = $_template->parent->has_nocache_code || $_template->has_nocache_code;
                }
            }
        } else {
            if ($this->smarty->debugging) {
                Smarty_Internal_Debug::start_cache($_template);
            }
            try {
                ob_start();
                $_template->properties['unifunc']($_template);
                if (isset($_template->_capture_stack[0])) {
                    $_template->capture_error();
                }
                $_output = ob_get_clean();
            } catch (Exception $e) {
                ob_get_clean();
                throw $e;
            }
            if ($this->smarty->debugging) {
                Smarty_Internal_Debug::end_cache($_template);
            }
        }
        if ((!$this->caching || $_template->source->recompiled) && !$no_output_filter && (isset($this->smarty->autoload_filters['output']) || isset($this->smarty->registered_filters['output']))) {
            $_output = Smarty_Internal_Filter_Handler::runFilter('output', $_output, $_template);
        }
        if (isset($this->error_reporting)) {
            error_reporting($_smarty_old_error_level);
        }
        // display or fetch
        if ($display) {
            if ($this->caching && $this->cache_modified_check) {
                $_isCached = $_template->isCached() && !$_template->has_nocache_code;
                $_last_modified_date = @substr($_SERVER['HTTP_IF_MODIFIED_SINCE'], 0, strpos($_SERVER['HTTP_IF_MODIFIED_SINCE'], 'GMT') + 3);
                if ($_isCached && $_template->cached->timestamp <= strtotime($_last_modified_date)) {
                    switch (PHP_SAPI) {
                        case 'cgi':         // php-cgi < 5.3
                        case 'cgi-fcgi':    // php-cgi >= 5.3
                        case 'fpm-fcgi':    // php-fpm >= 5.3.3
                            header('Status: 304 Not Modified');
                            break;

                        case 'cli':
                            if (/* ^phpunit */!empty($_SERVER['SMARTY_PHPUNIT_DISABLE_HEADERS'])/* phpunit$ */) {
                                $_SERVER['SMARTY_PHPUNIT_HEADERS'][] = '304 Not Modified';
                            }
                            break;

                        default:
                            header('HTTP/1.1 304 Not Modified');
                            break;
                    }
                } else {
                    switch (PHP_SAPI) {
                        case 'cli':
                            if (/* ^phpunit */!empty($_SERVER['SMARTY_PHPUNIT_DISABLE_HEADERS'])/* phpunit$ */) {
                                $_SERVER['SMARTY_PHPUNIT_HEADERS'][] = 'Last-Modified: ' . gmdate('D, d M Y H:i:s', $_template->cached->timestamp) . ' GMT';
                            }
                            break;

                        default:
                            header('Last-Modified: ' . gmdate('D, d M Y H:i:s', $_template->cached->timestamp) . ' GMT');
                            break;
                    }
                    echo $_output;
                }
            } else {
                echo $_output;
            }
            // debug output
            if ($this->smarty->debugging) {
                Smarty_Internal_Debug::display_debug($this);
            }
            if ($merge_tpl_vars) {
                // restore local variables
                $_template->tpl_vars = $save_tpl_vars;
                $_template->config_vars =  $save_config_vars;
            }
            return;
        } else {
            if ($merge_tpl_vars) {
                // restore local variables
                $_template->tpl_vars = $save_tpl_vars;
                $_template->config_vars =  $save_config_vars;
            }
            // return fetched content
            return $_output;
        }
    }

    /**
     * displays a Smarty template
     *
     * @param string $template   the resource handle of the template file or template object
     * @param mixed  $cache_id   cache id to be used with this template
     * @param mixed  $compile_id compile id to be used with this template
     * @param object $parent     next higher level of Smarty variables
     */
    public function display($template = null, $cache_id = null, $compile_id = null, $parent = null)
    {
        // display template
        $this->fetch($template, $cache_id, $compile_id, $parent, true);
    }

    /**
     * test if cache is valid
     *
     * @param string|object $template   the resource handle of the template file or template object
     * @param mixed         $cache_id   cache id to be used with this template
     * @param mixed         $compile_id compile id to be used with this template
     * @param object        $parent     next higher level of Smarty variables
     * @return boolean cache status
     */
    public function isCached($template = null, $cache_id = null, $compile_id = null, $parent = null)
    {
        if ($template === null && $this instanceof $this->template_class) {
            return $this->cached->valid;
        }
        if (!($template instanceof $this->template_class)) {
            if ($parent === null) {
                $parent = $this;
            }
            $template = $this->smarty->createTemplate($template, $cache_id, $compile_id, $parent, false);
        }
        // return cache status of template
        return $template->cached->valid;
    }

    /**
     * creates a data object
     *
     * @param object $parent next higher level of Smarty variables
     * @returns Smarty_Data data object
     */
    public function createData($parent = null)
    {
        return new Smarty_Data($parent, $this);
    }

    /**
     * Registers plugin to be used in templates
     *
     * @param string   $type       plugin type
     * @param string   $tag        name of template tag
     * @param callback $callback   PHP callback to register
     * @param boolean  $cacheable  if true (default) this fuction is cachable
     * @param array    $cache_attr caching attributes if any
     * @throws SmartyException when the plugin tag is invalid
     */
    public function registerPlugin($type, $tag, $callback, $cacheable = true, $cache_attr = null)
    {
        if (isset($this->smarty->registered_plugins[$type][$tag])) {
            throw new SmartyException("Plugin tag \"{$tag}\" already registered");
        } elseif (!is_callable($callback)) {
            throw new SmartyException("Plugin \"{$tag}\" not callable");
        } else {
            $this->smarty->registered_plugins[$type][$tag] = array($callback, (bool) $cacheable, (array) $cache_attr);
        }
    }

    /**
     * Unregister Plugin
     *
     * @param string $type of plugin
     * @param string $tag name of plugin
     */
    public function unregisterPlugin($type, $tag)
    {
        if (isset($this->smarty->registered_plugins[$type][$tag])) {
            unset($this->smarty->registered_plugins[$type][$tag]);
        }
    }

    /**
     * Registers a resource to fetch a template
     *
     * @param string $type name of resource type
     * @param Smarty_Resource|array $callback or instance of Smarty_Resource, or array of callbacks to handle resource (deprecated)
     */
    public function registerResource($type, $callback)
    {
        $this->smarty->registered_resources[$type] = $callback instanceof Smarty_Resource ? $callback : array($callback, false);
    }

    /**
     * Unregisters a resource
     *
     * @param string $type name of resource type
     */
    public function unregisterResource($type)
    {
        if (isset($this->smarty->registered_resources[$type])) {
            unset($this->smarty->registered_resources[$type]);
        }
    }

    /**
     * Registers a cache resource to cache a template's output
     *
     * @param string               $type     name of cache resource type
     * @param Smarty_CacheResource $callback instance of Smarty_CacheResource to handle output caching
     */
    public function registerCacheResource($type, Smarty_CacheResource $callback)
    {
        $this->smarty->registered_cache_resources[$type] = $callback;
    }

    /**
     * Unregisters a cache resource
     *
     * @param string $type name of cache resource type
     */
    public function unregisterCacheResource($type)
    {
        if (isset($this->smarty->registered_cache_resources[$type])) {
            unset($this->smarty->registered_cache_resources[$type]);
        }
    }

    /**
     * Registers object to be used in templates
     *
     * @param string  $object        name of template object
     * @param object  $object_impl   the referenced PHP object to register
     * @param array   $allowed       list of allowed methods (empty = all)
     * @param boolean $smarty_args   smarty argument format, else traditional
     * @param array   $block_methods list of block-methods
     * @param array $block_functs list of methods that are block format
     * @throws SmartyException if any of the methods in $allowed or $block_methods are invalid
     */
    public function registerObject($object_name, $object_impl, $allowed = array(), $smarty_args = true, $block_methods = array())
    {
        // test if allowed methodes callable
        if (!empty($allowed)) {
            foreach ((array) $allowed as $method) {
                if (!is_callable(array($object_impl, $method))) {
                    throw new SmartyException("Undefined method '$method' in registered object");
                }
            }
        }
        // test if block methodes callable
        if (!empty($block_methods)) {
            foreach ((array) $block_methods as $method) {
                if (!is_callable(array($object_impl, $method))) {
                    throw new SmartyException("Undefined method '$method' in registered object");
                }
            }
        }
        // register the object
        $this->smarty->registered_objects[$object_name] =
            array($object_impl, (array) $allowed, (boolean) $smarty_args, (array) $block_methods);
    }

    /**
     * return a reference to a registered object
     *
     * @param string $name object name
     * @return object
     * @throws SmartyException if no such object is found
     */
    public function getRegisteredObject($name)
    {
        if (!isset($this->smarty->registered_objects[$name])) {
            throw new SmartyException("'$name' is not a registered object");
        }
        if (!is_object($this->smarty->registered_objects[$name][0])) {
            throw new SmartyException("registered '$name' is not an object");
        }
        return $this->smarty->registered_objects[$name][0];
    }

    /**
     * unregister an object
     *
     * @param string $name object name
     * @throws SmartyException if no such object is found
     */
    public function unregisterObject($name)
    {
        unset($this->smarty->registered_objects[$name]);
        return;
    }

    /**
     * Registers static classes to be used in templates
     *
     * @param string $class name of template class
     * @param string $class_impl the referenced PHP class to register
     * @throws SmartyException if $class_impl does not refer to an existing class
     */
    public function registerClass($class_name, $class_impl)
    {
        // test if exists
        if (!class_exists($class_impl)) {
            throw new SmartyException("Undefined class '$class_impl' in register template class");
        }
        // register the class
        $this->smarty->registered_classes[$class_name] = $class_impl;
    }

    /**
     * Registers a default plugin handler
     *
     * @param callable $callback class/method name
     * @throws SmartyException if $callback is not callable
     */
    public function registerDefaultPluginHandler($callback)
    {
        if (is_callable($callback)) {
            $this->smarty->default_plugin_handler_func = $callback;
        } else {
            throw new SmartyException("Default plugin handler '$callback' not callable");
        }
    }

    /**
     * Registers a default template handler
     *
     * @param callable $callback class/method name
     * @throws SmartyException if $callback is not callable
     */
    public function registerDefaultTemplateHandler($callback)
    {
        if (is_callable($callback)) {
            $this->smarty->default_template_handler_func = $callback;
        } else {
            throw new SmartyException("Default template handler '$callback' not callable");
        }
    }

    /**
     * Registers a default template handler
     *
     * @param callable $callback class/method name
     * @throws SmartyException if $callback is not callable
     */
    public function registerDefaultConfigHandler($callback)
    {
        if (is_callable($callback)) {
            $this->smarty->default_config_handler_func = $callback;
        } else {
            throw new SmartyException("Default config handler '$callback' not callable");
        }
    }

    /**
     * Registers a filter function
     *
     * @param string $type filter type
     * @param callback $callback
     */
    public function registerFilter($type, $callback)
    {
        $this->smarty->registered_filters[$type][$this->_get_filter_name($callback)] = $callback;
    }

    /**
     * Unregisters a filter function
     *
     * @param string $type filter type
     * @param callback $callback
     */
    public function unregisterFilter($type, $callback)
    {
        $name = $this->_get_filter_name($callback);
        if (isset($this->smarty->registered_filters[$type][$name])) {
            unset($this->smarty->registered_filters[$type][$name]);
        }
    }

    /**
     * Return internal filter name
     *
     * @param callback $function_name
     */
    public function _get_filter_name($function_name)
    {
        if (is_array($function_name)) {
            $_class_name = (is_object($function_name[0]) ?
                            get_class($function_name[0]) : $function_name[0]);
            return $_class_name . '_' . $function_name[1];
        } else {
            return $function_name;
        }
    }

    /**
     * load a filter of specified type and name
     *
     * @param string $type filter type
     * @param string $name filter name
     * @return bool
     */
    public function loadFilter($type, $name)
    {
        $_plugin = "smarty_{$type}filter_{$name}";
        $_filter_name = $_plugin;
        if ($this->smarty->loadPlugin($_plugin)) {
            if (class_exists($_plugin, false)) {
                $_plugin = array($_plugin, 'execute');
            }
            if (is_callable($_plugin)) {
                $this->smarty->registered_filters[$type][$_filter_name] = $_plugin;
                return true;
            }
        }
        throw new SmartyException("{$type}filter \"{$name}\" not callable");
        return false;
    }

    /**
     * unload a filter of specified type and name
     *
     * @param string $type filter type
     * @param string $name filter name
     * @return bool
     */
    public function unloadFilter($type, $name)
    {
        $_filter_name = "smarty_{$type}filter_{$name}";
        if (isset($this->smarty->registered_filters[$type][$_filter_name])) {
            unset ($this->smarty->registered_filters[$type][$_filter_name]);
            return true;
        } else {
            return false;
        }
    }

    /**
     * preg_replace callback to convert camelcase getter/setter to underscore property names
     *
     * @param string $match match string
     * @return string  replacemant
     */
    private function replaceCamelcase($match) {
        return "_" . strtolower($match[1]);
    }

    /**
     * Handle unknown class methods
     *
     * @param string $name unknown method-name
     * @param array  $args argument array
     */
    public function __call($name, $args)
    {
        static $_prefixes = array('set' => true, 'get' => true);
        static $_resolved_property_name = array();
        static $_resolved_property_source = array();

        // method of Smarty object?
        if (method_exists($this->smarty, $name)) {
            return call_user_func_array(array($this->smarty, $name), $args);
        }
        // see if this is a set/get for a property
        $first3 = strtolower(substr($name, 0, 3));
        if (isset($_prefixes[$first3]) && isset($name[3]) && $name[3] !== '_') {
            if (isset($_resolved_property_name[$name])) {
                $property_name = $_resolved_property_name[$name];
            } else {
                // try to keep case correct for future PHP 6.0 case-sensitive class methods
                // lcfirst() not available < PHP 5.3.0, so improvise
                $property_name = strtolower(substr($name, 3, 1)) . substr($name, 4);
                // convert camel case to underscored name
                $property_name = preg_replace_callback('/([A-Z])/', array($this,'replaceCamelcase'), $property_name);
                $_resolved_property_name[$name] = $property_name;
            }
            if (isset($_resolved_property_source[$property_name])) {
                $_is_this = $_resolved_property_source[$property_name];
            } else {
                $_is_this = null;
                if (property_exists($this, $property_name)) {
                    $_is_this = true;
                } else if (property_exists($this->smarty, $property_name)) {
                    $_is_this = false;
                }
                $_resolved_property_source[$property_name] = $_is_this;
            }
            if ($_is_this) {
                if ($first3 == 'get')
                    return $this->$property_name;
                else
                    return $this->$property_name = $args[0];
            } else if ($_is_this === false) {
                if ($first3 == 'get')
                    return $this->smarty->$property_name;
                else
                    return $this->smarty->$property_name = $args[0];
            } else {
                throw new SmartyException("property '$property_name' does not exist.");
                return false;
            }
        }
        // must be unknown
        throw new SmartyException("Call of unknown method '$name'.");
    }

}

?><?php
/**
 * Smarty Internal Plugin Compile If
 *
 * Compiles the {if} {else} {elseif} {/if} tags
 *
 * @package Smarty
 * @subpackage Compiler
 * @author Uwe Tews
 */

/**
 * Smarty Internal Plugin Compile If Class
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_If extends Smarty_Internal_CompileBase {

    /**
     * Compiles code for the {if} tag
     *
     * @param array  $args       array with attributes from parser
     * @param object $compiler   compiler object
     * @param array  $parameter  array with compilation parameter
     * @return string compiled code
     */
    public function compile($args, $compiler, $parameter)
    {
        // check and get attributes
        $_attr = $this->getAttributes($compiler, $args);
        $this->openTag($compiler, 'if', array(1, $compiler->nocache));
        // must whole block be nocache ?
        $compiler->nocache = $compiler->nocache | $compiler->tag_nocache;
        if (is_array($parameter['if condition'])) {
            if ($compiler->nocache) {
                $_nocache = ',true';
                // create nocache var to make it know for further compiling
                if (is_array($parameter['if condition']['var'])) {
                    $compiler->template->tpl_vars[trim($parameter['if condition']['var']['var'], "'")] = new Smarty_variable(null, true);
                } else {
                    $compiler->template->tpl_vars[trim($parameter['if condition']['var'], "'")] = new Smarty_variable(null, true);
                }
            } else {
                $_nocache = '';
            }
            if (is_array($parameter['if condition']['var'])) {
                $_output = "<?php if (!isset(\$_smarty_tpl->tpl_vars[".$parameter['if condition']['var']['var']."]) || !is_array(\$_smarty_tpl->tpl_vars[".$parameter['if condition']['var']['var']."]->value)) \$_smarty_tpl->createLocalArrayVariable(".$parameter['if condition']['var']['var']."$_nocache);\n";
                $_output .= "if (\$_smarty_tpl->tpl_vars[".$parameter['if condition']['var']['var']."]->value".$parameter['if condition']['var']['smarty_internal_index']." = ".$parameter['if condition']['value']."){?>";
            } else {
                $_output = "<?php if (!isset(\$_smarty_tpl->tpl_vars[".$parameter['if condition']['var']."])) \$_smarty_tpl->tpl_vars[".$parameter['if condition']['var']."] = new Smarty_Variable(null{$_nocache});";
                $_output .= "if (\$_smarty_tpl->tpl_vars[".$parameter['if condition']['var']."]->value = ".$parameter['if condition']['value']."){?>";
            }
            return $_output;
        } else {
            return "<?php if ({$parameter['if condition']}){?>";
        }
    }

}

/**
 * Smarty Internal Plugin Compile Else Class
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_Else extends Smarty_Internal_CompileBase {

    /**
     * Compiles code for the {else} tag
     *
     * @param array  $args       array with attributes from parser
     * @param object $compiler   compiler object
     * @param array  $parameter  array with compilation parameter
     * @return string compiled code
     */
    public function compile($args, $compiler, $parameter)
    {
        list($nesting, $compiler->tag_nocache) = $this->closeTag($compiler, array('if', 'elseif'));
        $this->openTag($compiler, 'else', array($nesting, $compiler->tag_nocache));

        return "<?php }else{ ?>";
    }

}

/**
 * Smarty Internal Plugin Compile ElseIf Class
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_Elseif extends Smarty_Internal_CompileBase {

    /**
     * Compiles code for the {elseif} tag
     *
     * @param array  $args       array with attributes from parser
     * @param object $compiler   compiler object
     * @param array  $parameter  array with compilation parameter
     * @return string compiled code
     */
    public function compile($args, $compiler, $parameter)
    {
        // check and get attributes
        $_attr = $this->getAttributes($compiler, $args);

        list($nesting, $compiler->tag_nocache) = $this->closeTag($compiler, array('if', 'elseif'));

        if (is_array($parameter['if condition'])) {
            $condition_by_assign = true;
            if ($compiler->nocache) {
                $_nocache = ',true';
                // create nocache var to make it know for further compiling
                if (is_array($parameter['if condition']['var'])) {
                    $compiler->template->tpl_vars[trim($parameter['if condition']['var']['var'], "'")] = new Smarty_variable(null, true);
                } else {
                    $compiler->template->tpl_vars[trim($parameter['if condition']['var'], "'")] = new Smarty_variable(null, true);
                }
            } else {
                $_nocache = '';
            }
        } else {
            $condition_by_assign = false;
        }

        if (empty($compiler->prefix_code)) {
            if ($condition_by_assign) {
                $this->openTag($compiler, 'elseif', array($nesting + 1, $compiler->tag_nocache));
                if (is_array($parameter['if condition']['var'])) {
                    $_output = "<?php }else{ if (!isset(\$_smarty_tpl->tpl_vars[" . $parameter['if condition']['var']['var'] . "]) || !is_array(\$_smarty_tpl->tpl_vars[" . $parameter['if condition']['var']['var'] . "]->value)) \$_smarty_tpl->createLocalArrayVariable(" . $parameter['if condition']['var']['var'] . "$_nocache);\n";
                    $_output .= "if (\$_smarty_tpl->tpl_vars[" . $parameter['if condition']['var']['var'] . "]->value" . $parameter['if condition']['var']['smarty_internal_index'] . " = " . $parameter['if condition']['value'] . "){?>";
                } else {
                    $_output = "<?php  }else{ if (!isset(\$_smarty_tpl->tpl_vars[" . $parameter['if condition']['var'] . "])) \$_smarty_tpl->tpl_vars[" . $parameter['if condition']['var'] . "] = new Smarty_Variable(null{$_nocache});";
                    $_output .= "if (\$_smarty_tpl->tpl_vars[" . $parameter['if condition']['var'] . "]->value = " . $parameter['if condition']['value'] . "){?>";
                }
                return $_output;
            } else {
                $this->openTag($compiler, 'elseif', array($nesting, $compiler->tag_nocache));
                return "<?php }elseif({$parameter['if condition']}){?>";
            }
        } else {
            $tmp = '';
            foreach ($compiler->prefix_code as $code)
                $tmp .= $code;
            $compiler->prefix_code = array();
            $this->openTag($compiler, 'elseif', array($nesting + 1, $compiler->tag_nocache));
            if ($condition_by_assign) {
                if (is_array($parameter['if condition']['var'])) {
                    $_output = "<?php }else{?>{$tmp}<?php  if (!isset(\$_smarty_tpl->tpl_vars[" . $parameter['if condition']['var']['var'] . "]) || !is_array(\$_smarty_tpl->tpl_vars[" . $parameter['if condition']['var']['var'] . "]->value)) \$_smarty_tpl->createLocalArrayVariable(" . $parameter['if condition']['var']['var'] . "$_nocache);\n";
                    $_output .= "if (\$_smarty_tpl->tpl_vars[" . $parameter['if condition']['var']['var'] . "]->value" . $parameter['if condition']['var']['smarty_internal_index'] . " = " . $parameter['if condition']['value'] . "){?>";
                } else {
                    $_output = "<?php }else{?>{$tmp}<?php if (!isset(\$_smarty_tpl->tpl_vars[" . $parameter['if condition']['var'] . "])) \$_smarty_tpl->tpl_vars[" . $parameter['if condition']['var'] . "] = new Smarty_Variable(null{$_nocache});";
                    $_output .= "if (\$_smarty_tpl->tpl_vars[" . $parameter['if condition']['var'] . "]->value = " . $parameter['if condition']['value'] . "){?>";
                }
                return $_output;
            } else {
                return "<?php }else{?>{$tmp}<?php if ({$parameter['if condition']}){?>";
            }
        }
    }

}

/**
 * Smarty Internal Plugin Compile Ifclose Class
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_Ifclose extends Smarty_Internal_CompileBase {

    /**
     * Compiles code for the {/if} tag
     *
     * @param array  $args       array with attributes from parser
     * @param object $compiler   compiler object
     * @param array  $parameter  array with compilation parameter
     * @return string compiled code
     */
    public function compile($args, $compiler, $parameter)
    {
        // must endblock be nocache?
        if ($compiler->nocache) {
            $compiler->tag_nocache = true;
        }
        list($nesting, $compiler->nocache) = $this->closeTag($compiler, array('if', 'else', 'elseif'));
        $tmp = '';
        for ($i = 0; $i < $nesting; $i++) {
            $tmp .= '}';
        }
        return "<?php {$tmp}?>";
    }

}

?><?php
/**
 * Smarty Internal Plugin Compile Break
 *
 * Compiles the {break} tag
 *
 * @package Smarty
 * @subpackage Compiler
 * @author Uwe Tews
 */
/**
 * Smarty Internal Plugin Compile Break Class
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_Break extends Smarty_Internal_CompileBase {

    /**
     * Attribute definition: Overwrites base class.
     *
     * @var array
     * @see Smarty_Internal_CompileBase
     */
    public $optional_attributes = array('levels');
    /**
     * Attribute definition: Overwrites base class.
     *
     * @var array
     * @see Smarty_Internal_CompileBase
     */
    public $shorttag_order = array('levels');

    /**
     * Compiles code for the {break} tag
     *
     * @param array  $args array with attributes from parser
     * @param object $compiler   compiler object
     * @param array  $parameter  array with compilation parameter
     * @return string compiled code
     */
    public function compile($args, $compiler, $parameter)
    {
        static $_is_loopy = array('for' => true, 'foreach' => true, 'while' => true, 'section' => true);
        // check and get attributes
        $_attr = $this->getAttributes($compiler, $args);

        if ($_attr['nocache'] === true) {
            $compiler->trigger_template_error('nocache option not allowed', $compiler->lex->taglineno);
        }

        if (isset($_attr['levels'])) {
            if (!is_numeric($_attr['levels'])) {
                $compiler->trigger_template_error('level attribute must be a numeric constant', $compiler->lex->taglineno);
            }
            $_levels = $_attr['levels'];
        } else {
            $_levels = 1;
        }
        $level_count = $_levels;
        $stack_count = count($compiler->_tag_stack) - 1;
        while ($level_count > 0 && $stack_count >= 0) {
            if (isset($_is_loopy[$compiler->_tag_stack[$stack_count][0]])) {
                $level_count--;
            }
            $stack_count--;
        }
        if ($level_count != 0) {
            $compiler->trigger_template_error("cannot break {$_levels} level(s)", $compiler->lex->taglineno);
        }
        $compiler->has_code = true;
        return "<?php break {$_levels}?>";
    }

}

?><?php
/**
 * Smarty Internal Plugin Filter Handler
 *
 * Smarty filter handler class
 *
 * @package Smarty
 * @subpackage PluginsInternal
 * @author Uwe Tews
 */

/**
 * Class for filter processing
 *
 * @package Smarty
 * @subpackage PluginsInternal
 */
class Smarty_Internal_Filter_Handler {

    /**
     * Run filters over content
     *
     * The filters will be lazy loaded if required
     * class name format: Smarty_FilterType_FilterName
     * plugin filename format: filtertype.filtername.php
     * Smarty2 filter plugins could be used
     *
     * @param string                   $type     the type of filter ('pre','post','output') which shall run
     * @param string                   $content  the content which shall be processed by the filters
     * @param Smarty_Internal_Template $template template object
     * @return string the filtered content
     */
    public static function runFilter($type, $content, Smarty_Internal_Template $template)
    {
        $output = $content;
        // loop over autoload filters of specified type
        if (!empty($template->smarty->autoload_filters[$type])) {
            foreach ((array)$template->smarty->autoload_filters[$type] as $name) {
                $plugin_name = "Smarty_{$type}filter_{$name}";
                if ($template->smarty->loadPlugin($plugin_name)) {
                    if (function_exists($plugin_name)) {
                        // use loaded Smarty2 style plugin
                        $output = $plugin_name($output, $template);
                    } elseif (class_exists($plugin_name, false)) {
                        // loaded class of filter plugin
                        $output = call_user_func(array($plugin_name, 'execute'), $output, $template);
                    }
                } else {
                    // nothing found, throw exception
                    throw new SmartyException("Unable to load filter {$plugin_name}");
                }
            }
        }
        // loop over registerd filters of specified type
        if (!empty($template->smarty->registered_filters[$type])) {
            foreach ($template->smarty->registered_filters[$type] as $key => $name) {
                if (is_array($template->smarty->registered_filters[$type][$key])) {
                    $output = call_user_func($template->smarty->registered_filters[$type][$key], $output, $template);
                } else {
                    $output = $template->smarty->registered_filters[$type][$key]($output, $template);
                }
            }
        }
        // return filtered output
        return $output;
    }

}

?><?php
/**
 * Smarty Internal Plugin Compile Object Funtion
 *
 * Compiles code for registered objects as function
 *
 * @package Smarty
 * @subpackage Compiler
 * @author Uwe Tews
 */

/**
 * Smarty Internal Plugin Compile Object Function Class
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_Private_Object_Function extends Smarty_Internal_CompileBase {

    /**
     * Attribute definition: Overwrites base class.
     *
     * @var array
     * @see Smarty_Internal_CompileBase
     */
    public $optional_attributes = array('_any');

    /**
     * Compiles code for the execution of function plugin
     *
     * @param array  $args      array with attributes from parser
     * @param object $compiler  compiler object
     * @param array  $parameter array with compilation parameter
     * @param string $tag       name of function
     * @param string $method    name of method to call
     * @return string compiled code
     */
    public function compile($args, $compiler, $parameter, $tag, $method)
    {
        // check and get attributes
        $_attr = $this->getAttributes($compiler, $args);
        if ($_attr['nocache'] === true) {
            $compiler->tag_nocache = true;
        }
        unset($_attr['nocache']);
        $_assign = null;
        if (isset($_attr['assign'])) {
            $_assign = $_attr['assign'];
            unset($_attr['assign']);
        }
        // convert attributes into parameter array string
        if ($compiler->smarty->registered_objects[$tag][2]) {
            $_paramsArray = array();
            foreach ($_attr as $_key => $_value) {
                if (is_int($_key)) {
                    $_paramsArray[] = "$_key=>$_value";
                } else {
                    $_paramsArray[] = "'$_key'=>$_value";
                }
            }
            $_params = 'array(' . implode(",", $_paramsArray) . ')';
            $return = "\$_smarty_tpl->smarty->registered_objects['{$tag}'][0]->{$method}({$_params},\$_smarty_tpl)";
        } else {
            $_params = implode(",", $_attr);
            $return = "\$_smarty_tpl->smarty->registered_objects['{$tag}'][0]->{$method}({$_params})";
        }
        if (empty($_assign)) {
            // This tag does create output
            $compiler->has_output = true;
            $output = "<?php echo {$return};?>\n";
        } else {
            $output = "<?php \$_smarty_tpl->assign({$_assign},{$return});?>\n";
        }
        return $output;
    }

}

?><?php
/**
 * Smarty Internal Plugin Compile Append
 *
 * Compiles the {append} tag
 *
 * @package Smarty
 * @subpackage Compiler
 * @author Uwe Tews
 */

/**
 * Smarty Internal Plugin Compile Append Class
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_Append extends Smarty_Internal_Compile_Assign {

    /**
     * Compiles code for the {append} tag
     *
     * @param array $args array with attributes from parser
     * @param object $compiler compiler object
     * @param array $parameter array with compilation parameter
     * @return string compiled code
     */
    public function compile($args, $compiler, $parameter)
    {
        // the following must be assigned at runtime because it will be overwritten in parent class
        $this->required_attributes = array('var', 'value');
        $this->shorttag_order = array('var', 'value');
        $this->optional_attributes = array('scope', 'index');
        // check and get attributes
        $_attr = $this->getAttributes($compiler, $args);
        // map to compile assign attributes
        if (isset($_attr['index'])) {
            $_params['smarty_internal_index'] = '[' . $_attr['index'] . ']';
            unset($_attr['index']);
        } else {
            $_params['smarty_internal_index'] = '[]';
        }
        $_new_attr = array();
        foreach ($_attr as $key => $value) {
            $_new_attr[] = array($key => $value);
        }
        // call compile assign
        return parent::compile($_new_attr, $compiler, $_params);
    }

}

?><?php
/**
* Smarty Internal Plugin Compile Include
*
* Compiles the {include} tag
*
* @package Smarty
* @subpackage Compiler
* @author Uwe Tews
*/

/**
* Smarty Internal Plugin Compile Include Class
*
* @package Smarty
* @subpackage Compiler
*/
class Smarty_Internal_Compile_Include extends Smarty_Internal_CompileBase {

    /**
    * caching mode to create nocache code but no cache file
    */
    const CACHING_NOCACHE_CODE = 9999;
    /**
    * Attribute definition: Overwrites base class.
    *
    * @var array
    * @see Smarty_Internal_CompileBase
    */
    public $required_attributes = array('file');
    /**
    * Attribute definition: Overwrites base class.
    *
    * @var array
    * @see Smarty_Internal_CompileBase
    */
    public $shorttag_order = array('file');
    /**
    * Attribute definition: Overwrites base class.
    *
    * @var array
    * @see Smarty_Internal_CompileBase
    */
    public $option_flags = array('nocache', 'inline', 'caching');
    /**
    * Attribute definition: Overwrites base class.
    *
    * @var array
    * @see Smarty_Internal_CompileBase
    */
    public $optional_attributes = array('_any');

    /**
    * Compiles code for the {include} tag
    *
     * @param array $args array with attributes from parser
     * @param object $compiler compiler object
     * @param array $parameter array with compilation parameter
     * @return string compiled code
     */
    public function compile($args, $compiler, $parameter)
    {
        // check and get attributes
        $_attr = $this->getAttributes($compiler, $args);
        // save posible attributes
        $include_file = $_attr['file'];

        if (isset($_attr['assign'])) {
            // output will be stored in a smarty variable instead of beind displayed
            $_assign = $_attr['assign'];
        }

        $_parent_scope = Smarty::SCOPE_LOCAL;
        if (isset($_attr['scope'])) {
            $_attr['scope'] = trim($_attr['scope'], "'\"");
            if ($_attr['scope'] == 'parent') {
                $_parent_scope = Smarty::SCOPE_PARENT;
            } elseif ($_attr['scope'] == 'root') {
                $_parent_scope = Smarty::SCOPE_ROOT;
            } elseif ($_attr['scope'] == 'global') {
                $_parent_scope = Smarty::SCOPE_GLOBAL;
            }
        }
        $_caching = 'null';
        if ($compiler->nocache || $compiler->tag_nocache) {
            $_caching = Smarty::CACHING_OFF;
        }
        // default for included templates
        if ($compiler->template->caching && !$compiler->nocache && !$compiler->tag_nocache) {
            $_caching = self::CACHING_NOCACHE_CODE;
        }
        /*
        * if the {include} tag provides individual parameter for caching
        * it will not be included into the common cache file and treated like
        * a nocache section
        */
        if (isset($_attr['cache_lifetime'])) {
            $_cache_lifetime = $_attr['cache_lifetime'];
            $compiler->tag_nocache = true;
            $_caching = Smarty::CACHING_LIFETIME_CURRENT;
        } else {
            $_cache_lifetime = 'null';
        }
        if (isset($_attr['cache_id'])) {
            $_cache_id = $_attr['cache_id'];
            $compiler->tag_nocache = true;
            $_caching = Smarty::CACHING_LIFETIME_CURRENT;
        } else {
            $_cache_id = '$_smarty_tpl->cache_id';
        }
        if (isset($_attr['compile_id'])) {
            $_compile_id = $_attr['compile_id'];
        } else {
            $_compile_id = '$_smarty_tpl->compile_id';
        }
        if ($_attr['caching'] === true) {
            $_caching = Smarty::CACHING_LIFETIME_CURRENT;
        }
        if ($_attr['nocache'] === true) {
            $compiler->tag_nocache = true;
            $_caching = Smarty::CACHING_OFF;
        }

        $has_compiled_template = false;
        if (($compiler->smarty->merge_compiled_includes || $_attr['inline'] === true) && !$compiler->template->source->recompiled
            && !($compiler->template->caching && ($compiler->tag_nocache || $compiler->nocache)) && $_caching != Smarty::CACHING_LIFETIME_CURRENT) {
            // check if compiled code can be merged (contains no variable part)
            if (!$compiler->has_variable_string && (substr_count($include_file, '"') == 2 or substr_count($include_file, "'") == 2)
               and substr_count($include_file, '(') == 0 and substr_count($include_file, '$_smarty_tpl->') == 0) {
                $tpl_name = null;
                eval("\$tpl_name = $include_file;");
                if (!isset($compiler->smarty->merged_templates_func[$tpl_name]) || $compiler->inheritance) {
                    $tpl = new $compiler->smarty->template_class ($tpl_name, $compiler->smarty, $compiler->template, $compiler->template->cache_id, $compiler->template->compile_id);
                    // save unique function name
                    $compiler->smarty->merged_templates_func[$tpl_name]['func'] = $tpl->properties['unifunc'] = 'content_'.uniqid();
                    // use current nocache hash for inlined code
                    $compiler->smarty->merged_templates_func[$tpl_name]['nocache_hash'] = $tpl->properties['nocache_hash'] = $compiler->template->properties['nocache_hash'];
                    if ($compiler->template->caching) {
                        // needs code for cached page but no cache file
                        $tpl->caching = self::CACHING_NOCACHE_CODE;
                    }
                    // make sure whole chain gest compiled
                    $tpl->mustCompile = true;
                    if (!($tpl->source->uncompiled) && $tpl->source->exists) {
                        // get compiled code
                        $compiled_code = $tpl->compiler->compileTemplate($tpl);
                        // release compiler object to free memory
                        unset($tpl->compiler);
                        // merge compiled code for {function} tags
                        $compiler->template->properties['function'] = array_merge($compiler->template->properties['function'], $tpl->properties['function']);
                        // merge filedependency
                        $tpl->properties['file_dependency'][$tpl->source->uid] = array($tpl->source->filepath, $tpl->source->timestamp,$tpl->source->type);
                        $compiler->template->properties['file_dependency'] = array_merge($compiler->template->properties['file_dependency'], $tpl->properties['file_dependency']);
                        // remove header code
                        $compiled_code = preg_replace("/(<\?php \/\*%%SmartyHeaderCode:{$tpl->properties['nocache_hash']}%%\*\/(.+?)\/\*\/%%SmartyHeaderCode%%\*\/\?>\n)/s", '', $compiled_code);
                        if ($tpl->has_nocache_code) {
                            // replace nocache_hash
                            $compiled_code = preg_replace("/{$tpl->properties['nocache_hash']}/", $compiler->template->properties['nocache_hash'], $compiled_code);
                            $compiler->template->has_nocache_code = true;
                        }
                        $compiler->merged_templates[$tpl->properties['unifunc']] = $compiled_code;
                        $has_compiled_template = true;
                    }
                } else {
                    $has_compiled_template = true;
                }
            }
        }
        // delete {include} standard attributes
        unset($_attr['file'], $_attr['assign'], $_attr['cache_id'], $_attr['compile_id'], $_attr['cache_lifetime'], $_attr['nocache'], $_attr['caching'], $_attr['scope'], $_attr['inline']);
        // remaining attributes must be assigned as smarty variable
        if (!empty($_attr)) {
            if ($_parent_scope == Smarty::SCOPE_LOCAL) {
                // create variables
                foreach ($_attr as $key => $value) {
                    $_pairs[] = "'$key'=>$value";
                }
                $_vars = 'array('.join(',',$_pairs).')';
                $_has_vars = true;
            } else {
                $compiler->trigger_template_error('variable passing not allowed in parent/global scope', $compiler->lex->taglineno);
            }
        } else {
            $_vars = 'array()';
            $_has_vars = false;
        }
        if ($has_compiled_template) {
            $_hash = $compiler->smarty->merged_templates_func[$tpl_name]['nocache_hash'];
            $_output = "<?php /*  Call merged included template \"" . $tpl_name . "\" */\n";
            $_output .= "\$_tpl_stack[] = \$_smarty_tpl;\n";
            $_output .= " \$_smarty_tpl = \$_smarty_tpl->setupInlineSubTemplate($include_file, $_cache_id, $_compile_id, $_caching, $_cache_lifetime, $_vars, $_parent_scope, '$_hash');\n";
            if (isset($_assign)) {
                $_output .= 'ob_start(); ';
            }
            $_output .= $compiler->smarty->merged_templates_func[$tpl_name]['func']. "(\$_smarty_tpl);\n";
            $_output .= "\$_smarty_tpl = array_pop(\$_tpl_stack); ";
            if (isset($_assign)) {
                $_output .= " \$_smarty_tpl->tpl_vars[$_assign] = new Smarty_variable(ob_get_clean());";
            }
            $_output .= "/*  End of included template \"" . $tpl_name . "\" */?>";
            return $_output;
        }

        // was there an assign attribute
        if (isset($_assign)) {
            $_output = "<?php \$_smarty_tpl->tpl_vars[$_assign] = new Smarty_variable(\$_smarty_tpl->getSubTemplate ($include_file, $_cache_id, $_compile_id, $_caching, $_cache_lifetime, $_vars, $_parent_scope));?>\n";;
        } else {
            $_output = "<?php echo \$_smarty_tpl->getSubTemplate ($include_file, $_cache_id, $_compile_id, $_caching, $_cache_lifetime, $_vars, $_parent_scope);?>\n";
        }
        return $_output;
    }

}

?><?php
/**
 * Smarty Internal Plugin Resource String
 *
 * @package Smarty
 * @subpackage TemplateResources
 * @author Uwe Tews
 * @author Rodney Rehm
 */

/**
 * Smarty Internal Plugin Resource String
 *
 * Implements the strings as resource for Smarty template
 *
 * {@internal unlike eval-resources the compiled state of string-resources is saved for subsequent access}}
 *
 * @package Smarty
 * @subpackage TemplateResources
 */
class Smarty_Internal_Resource_String extends Smarty_Resource {

    /**
     * populate Source Object with meta data from Resource
     *
     * @param Smarty_Template_Source   $source    source object
     * @param Smarty_Internal_Template $_template template object
     * @return void
     */
    public function populate(Smarty_Template_Source $source, Smarty_Internal_Template $_template=null)
    {
        $source->uid = $source->filepath = sha1($source->name);
        $source->timestamp = 0;
        $source->exists = true;
    }

    /**
     * Load template's source from $resource_name into current template object
     *
     * @uses decode() to decode base64 and urlencoded template_resources
     * @param Smarty_Template_Source $source source object
     * @return string template source
     */
    public function getContent(Smarty_Template_Source $source)
    {
        return $this->decode($source->name);
    }
    
    /**
     * decode base64 and urlencode
     *
     * @param string $string template_resource to decode
     * @return string decoded template_resource
     */
    protected function decode($string)
    {
        // decode if specified
        if (($pos = strpos($string, ':')) !== false) {
            if (!strncmp($string, 'base64', 6)) {
                return base64_decode(substr($string, 7));
            } elseif (!strncmp($string, 'urlencode', 9)) {
                return urldecode(substr($string, 10));
            }
        }
        
        return $string;
    }
    
    /**
     * modify resource_name according to resource handlers specifications
     *
     * @param Smarty $smarty        Smarty instance
     * @param string $resource_name resource_name to make unique
     * @return string unique resource name
     */
    protected function buildUniqueResourceName(Smarty $smarty, $resource_name)
    {
        return get_class($this) . '#' .$this->decode($resource_name);
    }

    /**
     * Determine basename for compiled filename
     *
     * Always returns an empty string.
     *
     * @param Smarty_Template_Source $source source object
     * @return string resource's basename
     */
    protected function getBasename(Smarty_Template_Source $source)
    {
        return '';
    }

}

?><?php
/**
* Smarty Internal Plugin Configfilelexer
*
* This is the lexer to break the config file source into tokens
* @package Smarty
* @subpackage Config
* @author Uwe Tews
*/
/**
* Smarty Internal Plugin Configfilelexer
*/
class Smarty_Internal_Configfilelexer
{

    public $data;
    public $counter;
    public $token;
    public $value;
    public $node;
    public $line;
    private $state = 1;
    public $smarty_token_names = array (		// Text for parser error messages
   				);


    function __construct($data, $smarty)
    {
        // set instance object
        self::instance($this);
        $this->data = $data . "\n"; //now all lines are \n-terminated
        $this->counter = 0;
        $this->line = 1;
        $this->smarty = $smarty;
        $this->mbstring_overload = ini_get('mbstring.func_overload') & 2;
    }
    public static function &instance($new_instance = null)
    {
        static $instance = null;
        if (isset($new_instance) && is_object($new_instance))
            $instance = $new_instance;
        return $instance;
    }



    private $_yy_state = 1;
    private $_yy_stack = array();

    function yylex()
    {
        return $this->{'yylex' . $this->_yy_state}();
    }

    function yypushstate($state)
    {
        array_push($this->_yy_stack, $this->_yy_state);
        $this->_yy_state = $state;
    }

    function yypopstate()
    {
        $this->_yy_state = array_pop($this->_yy_stack);
    }

    function yybegin($state)
    {
        $this->_yy_state = $state;
    }




    function yylex1()
    {
        $tokenMap = array (
              1 => 0,
              2 => 0,
              3 => 0,
              4 => 0,
              5 => 0,
              6 => 0,
              7 => 0,
            );
        if ($this->counter >= strlen($this->data)) {
            return false; // end of input
        }
        $yy_global_pattern = "/\G(#|;)|\G(\\[)|\G(\\])|\G(=)|\G([ \t\r]+)|\G(\n)|\G([0-9]*[a-zA-Z_]\\w*)/iS";

        do {
            if ($this->mbstring_overload ? preg_match($yy_global_pattern, substr($this->data, $this->counter), $yymatches) : preg_match($yy_global_pattern,$this->data, $yymatches, null, $this->counter)) {
                $yysubmatches = $yymatches;
                $yymatches = array_filter($yymatches, 'strlen'); // remove empty sub-patterns
                if (!count($yymatches)) {
                    throw new Exception('Error: lexing failed because a rule matched' .
                        ' an empty string.  Input "' . substr($this->data,
                        $this->counter, 5) . '... state START');
                }
                next($yymatches); // skip global match
                $this->token = key($yymatches); // token number
                if ($tokenMap[$this->token]) {
                    // extract sub-patterns for passing to lex function
                    $yysubmatches = array_slice($yysubmatches, $this->token + 1,
                        $tokenMap[$this->token]);
                } else {
                    $yysubmatches = array();
                }
                $this->value = current($yymatches); // token value
                $r = $this->{'yy_r1_' . $this->token}($yysubmatches);
                if ($r === null) {
                    $this->counter += strlen($this->value);
                    $this->line += substr_count($this->value, "\n");
                    // accept this token
                    return true;
                } elseif ($r === true) {
                    // we have changed state
                    // process this token in the new state
                    return $this->yylex();
                } elseif ($r === false) {
                    $this->counter += strlen($this->value);
                    $this->line += substr_count($this->value, "\n");
                    if ($this->counter >= strlen($this->data)) {
                        return false; // end of input
                    }
                    // skip this token
                    continue;
                }            } else {
                throw new Exception('Unexpected input at line' . $this->line .
                    ': ' . $this->data[$this->counter]);
            }
            break;
        } while (true);

    } // end function


    const START = 1;
    function yy_r1_1($yy_subpatterns)
    {

    $this->token = Smarty_Internal_Configfileparser::TPC_COMMENTSTART;
    $this->yypushstate(self::COMMENT);
    }
    function yy_r1_2($yy_subpatterns)
    {

    $this->token = Smarty_Internal_Configfileparser::TPC_OPENB;
    $this->yypushstate(self::SECTION);
    }
    function yy_r1_3($yy_subpatterns)
    {

    $this->token = Smarty_Internal_Configfileparser::TPC_CLOSEB;
    }
    function yy_r1_4($yy_subpatterns)
    {

    $this->token = Smarty_Internal_Configfileparser::TPC_EQUAL;
    $this->yypushstate(self::VALUE);
    }
    function yy_r1_5($yy_subpatterns)
    {

    return false;
    }
    function yy_r1_6($yy_subpatterns)
    {

    $this->token = Smarty_Internal_Configfileparser::TPC_NEWLINE;
    }
    function yy_r1_7($yy_subpatterns)
    {

    $this->token = Smarty_Internal_Configfileparser::TPC_ID;
    }



    function yylex2()
    {
        $tokenMap = array (
              1 => 0,
              2 => 0,
              3 => 0,
              4 => 0,
              5 => 0,
              6 => 1,
              8 => 0,
              9 => 0,
              10 => 0,
            );
        if ($this->counter >= strlen($this->data)) {
            return false; // end of input
        }
        $yy_global_pattern = "/\G([ \t\r]+)|\G(\\d+\\.\\d+(?=[ \t\r]*[\n#;]))|\G(\\d+(?=[ \t\r]*[\n#;]))|\G('[^'\\\\]*(?:\\\\.[^'\\\\]*)*'(?=[ \t\r]*[\n#;]))|\G(\"[^\"\\\\]*(?:\\\\.[^\"\\\\]*)*\"(?=[ \t\r]*[\n#;]))|\G(\"\"\"(\\w+|[^\"]|\\\\\"|\"{1,2}[^\"])*\"\"\"(?=[ \t\r]*[\n#;]))|\G([a-zA-Z]+(?=[ \t\r]*[\n#;]))|\G([^\n]+?(?=[ \t\r]*\n))|\G(\n)/iS";

        do {
            if ($this->mbstring_overload ? preg_match($yy_global_pattern, substr($this->data, $this->counter), $yymatches) : preg_match($yy_global_pattern,$this->data, $yymatches, null, $this->counter)) {
                $yysubmatches = $yymatches;
                $yymatches = array_filter($yymatches, 'strlen'); // remove empty sub-patterns
                if (!count($yymatches)) {
                    throw new Exception('Error: lexing failed because a rule matched' .
                        ' an empty string.  Input "' . substr($this->data,
                        $this->counter, 5) . '... state VALUE');
                }
                next($yymatches); // skip global match
                $this->token = key($yymatches); // token number
                if ($tokenMap[$this->token]) {
                    // extract sub-patterns for passing to lex function
                    $yysubmatches = array_slice($yysubmatches, $this->token + 1,
                        $tokenMap[$this->token]);
                } else {
                    $yysubmatches = array();
                }
                $this->value = current($yymatches); // token value
                $r = $this->{'yy_r2_' . $this->token}($yysubmatches);
                if ($r === null) {
                    $this->counter += strlen($this->value);
                    $this->line += substr_count($this->value, "\n");
                    // accept this token
                    return true;
                } elseif ($r === true) {
                    // we have changed state
                    // process this token in the new state
                    return $this->yylex();
                } elseif ($r === false) {
                    $this->counter += strlen($this->value);
                    $this->line += substr_count($this->value, "\n");
                    if ($this->counter >= strlen($this->data)) {
                        return false; // end of input
                    }
                    // skip this token
                    continue;
                }            } else {
                throw new Exception('Unexpected input at line' . $this->line .
                    ': ' . $this->data[$this->counter]);
            }
            break;
        } while (true);

    } // end function


    const VALUE = 2;
    function yy_r2_1($yy_subpatterns)
    {

    return false;
    }
    function yy_r2_2($yy_subpatterns)
    {

    $this->token = Smarty_Internal_Configfileparser::TPC_FLOAT;
    $this->yypopstate();
    }
    function yy_r2_3($yy_subpatterns)
    {

    $this->token = Smarty_Internal_Configfileparser::TPC_INT;
    $this->yypopstate();
    }
    function yy_r2_4($yy_subpatterns)
    {

    $this->token = Smarty_Internal_Configfileparser::TPC_SINGLE_QUOTED_STRING;
    $this->yypopstate();
    }
    function yy_r2_5($yy_subpatterns)
    {

    $this->token = Smarty_Internal_Configfileparser::TPC_DOUBLE_QUOTED_STRING;
    $this->yypopstate();
    }
    function yy_r2_6($yy_subpatterns)
    {

    $this->token = Smarty_Internal_Configfileparser::TPC_TRIPPLE_DOUBLE_QUOTED_STRING;
    $this->yypopstate();
    }
    function yy_r2_8($yy_subpatterns)
    {

    if (!$this->smarty->config_booleanize || !in_array(strtolower($this->value), Array("true", "false", "on", "off", "yes", "no")) ) {
        $this->yypopstate();
        $this->yypushstate(self::NAKED_STRING_VALUE);
        return true; //reprocess in new state
    } else {
        $this->token = Smarty_Internal_Configfileparser::TPC_BOOL;
        $this->yypopstate();
    }
    }
    function yy_r2_9($yy_subpatterns)
    {

    $this->token = Smarty_Internal_Configfileparser::TPC_NAKED_STRING;
    $this->yypopstate();
    }
    function yy_r2_10($yy_subpatterns)
    {

    $this->token = Smarty_Internal_Configfileparser::TPC_NAKED_STRING;
    $this->value = "";
    $this->yypopstate();
    }



    function yylex3()
    {
        $tokenMap = array (
              1 => 0,
            );
        if ($this->counter >= strlen($this->data)) {
            return false; // end of input
        }
        $yy_global_pattern = "/\G([^\n]+?(?=[ \t\r]*\n))/iS";

        do {
            if ($this->mbstring_overload ? preg_match($yy_global_pattern, substr($this->data, $this->counter), $yymatches) : preg_match($yy_global_pattern,$this->data, $yymatches, null, $this->counter)) {
                $yysubmatches = $yymatches;
                $yymatches = array_filter($yymatches, 'strlen'); // remove empty sub-patterns
                if (!count($yymatches)) {
                    throw new Exception('Error: lexing failed because a rule matched' .
                        ' an empty string.  Input "' . substr($this->data,
                        $this->counter, 5) . '... state NAKED_STRING_VALUE');
                }
                next($yymatches); // skip global match
                $this->token = key($yymatches); // token number
                if ($tokenMap[$this->token]) {
                    // extract sub-patterns for passing to lex function
                    $yysubmatches = array_slice($yysubmatches, $this->token + 1,
                        $tokenMap[$this->token]);
                } else {
                    $yysubmatches = array();
                }
                $this->value = current($yymatches); // token value
                $r = $this->{'yy_r3_' . $this->token}($yysubmatches);
                if ($r === null) {
                    $this->counter += strlen($this->value);
                    $this->line += substr_count($this->value, "\n");
                    // accept this token
                    return true;
                } elseif ($r === true) {
                    // we have changed state
                    // process this token in the new state
                    return $this->yylex();
                } elseif ($r === false) {
                    $this->counter += strlen($this->value);
                    $this->line += substr_count($this->value, "\n");
                    if ($this->counter >= strlen($this->data)) {
                        return false; // end of input
                    }
                    // skip this token
                    continue;
                }            } else {
                throw new Exception('Unexpected input at line' . $this->line .
                    ': ' . $this->data[$this->counter]);
            }
            break;
        } while (true);

    } // end function


    const NAKED_STRING_VALUE = 3;
    function yy_r3_1($yy_subpatterns)
    {

    $this->token = Smarty_Internal_Configfileparser::TPC_NAKED_STRING;
    $this->yypopstate();
    }



    function yylex4()
    {
        $tokenMap = array (
              1 => 0,
              2 => 0,
              3 => 0,
            );
        if ($this->counter >= strlen($this->data)) {
            return false; // end of input
        }
        $yy_global_pattern = "/\G([ \t\r]+)|\G([^\n]+?(?=[ \t\r]*\n))|\G(\n)/iS";

        do {
            if ($this->mbstring_overload ? preg_match($yy_global_pattern, substr($this->data, $this->counter), $yymatches) : preg_match($yy_global_pattern,$this->data, $yymatches, null, $this->counter)) {
                $yysubmatches = $yymatches;
                $yymatches = array_filter($yymatches, 'strlen'); // remove empty sub-patterns
                if (!count($yymatches)) {
                    throw new Exception('Error: lexing failed because a rule matched' .
                        ' an empty string.  Input "' . substr($this->data,
                        $this->counter, 5) . '... state COMMENT');
                }
                next($yymatches); // skip global match
                $this->token = key($yymatches); // token number
                if ($tokenMap[$this->token]) {
                    // extract sub-patterns for passing to lex function
                    $yysubmatches = array_slice($yysubmatches, $this->token + 1,
                        $tokenMap[$this->token]);
                } else {
                    $yysubmatches = array();
                }
                $this->value = current($yymatches); // token value
                $r = $this->{'yy_r4_' . $this->token}($yysubmatches);
                if ($r === null) {
                    $this->counter += strlen($this->value);
                    $this->line += substr_count($this->value, "\n");
                    // accept this token
                    return true;
                } elseif ($r === true) {
                    // we have changed state
                    // process this token in the new state
                    return $this->yylex();
                } elseif ($r === false) {
                    $this->counter += strlen($this->value);
                    $this->line += substr_count($this->value, "\n");
                    if ($this->counter >= strlen($this->data)) {
                        return false; // end of input
                    }
                    // skip this token
                    continue;
                }            } else {
                throw new Exception('Unexpected input at line' . $this->line .
                    ': ' . $this->data[$this->counter]);
            }
            break;
        } while (true);

    } // end function


    const COMMENT = 4;
    function yy_r4_1($yy_subpatterns)
    {

    return false;
    }
    function yy_r4_2($yy_subpatterns)
    {

    $this->token = Smarty_Internal_Configfileparser::TPC_NAKED_STRING;
    }
    function yy_r4_3($yy_subpatterns)
    {

    $this->token = Smarty_Internal_Configfileparser::TPC_NEWLINE;
    $this->yypopstate();
    }



    function yylex5()
    {
        $tokenMap = array (
              1 => 0,
              2 => 0,
            );
        if ($this->counter >= strlen($this->data)) {
            return false; // end of input
        }
        $yy_global_pattern = "/\G(\\.)|\G(.*?(?=[\.=[\]\r\n]))/iS";

        do {
            if ($this->mbstring_overload ? preg_match($yy_global_pattern, substr($this->data, $this->counter), $yymatches) : preg_match($yy_global_pattern,$this->data, $yymatches, null, $this->counter)) {
                $yysubmatches = $yymatches;
                $yymatches = array_filter($yymatches, 'strlen'); // remove empty sub-patterns
                if (!count($yymatches)) {
                    throw new Exception('Error: lexing failed because a rule matched' .
                        ' an empty string.  Input "' . substr($this->data,
                        $this->counter, 5) . '... state SECTION');
                }
                next($yymatches); // skip global match
                $this->token = key($yymatches); // token number
                if ($tokenMap[$this->token]) {
                    // extract sub-patterns for passing to lex function
                    $yysubmatches = array_slice($yysubmatches, $this->token + 1,
                        $tokenMap[$this->token]);
                } else {
                    $yysubmatches = array();
                }
                $this->value = current($yymatches); // token value
                $r = $this->{'yy_r5_' . $this->token}($yysubmatches);
                if ($r === null) {
                    $this->counter += strlen($this->value);
                    $this->line += substr_count($this->value, "\n");
                    // accept this token
                    return true;
                } elseif ($r === true) {
                    // we have changed state
                    // process this token in the new state
                    return $this->yylex();
                } elseif ($r === false) {
                    $this->counter += strlen($this->value);
                    $this->line += substr_count($this->value, "\n");
                    if ($this->counter >= strlen($this->data)) {
                        return false; // end of input
                    }
                    // skip this token
                    continue;
                }            } else {
                throw new Exception('Unexpected input at line' . $this->line .
                    ': ' . $this->data[$this->counter]);
            }
            break;
        } while (true);

    } // end function


    const SECTION = 5;
    function yy_r5_1($yy_subpatterns)
    {

    $this->token = Smarty_Internal_Configfileparser::TPC_DOT;
    }
    function yy_r5_2($yy_subpatterns)
    {

    $this->token = Smarty_Internal_Configfileparser::TPC_SECTION;
    $this->yypopstate();
    }


}
?><?php
/**
 * Smarty Internal Plugin Compile While
 *
 * Compiles the {while} tag
 *
 * @package Smarty
 * @subpackage Compiler
 * @author Uwe Tews
 */

/**
 * Smarty Internal Plugin Compile While Class
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_While extends Smarty_Internal_CompileBase {

    /**
     * Compiles code for the {while} tag
     *
     * @param array  $args      array with attributes from parser
     * @param object $compiler  compiler object
     * @param array  $parameter array with compilation parameter
     * @return string compiled code
     */
    public function compile($args, $compiler, $parameter)
    {
        // check and get attributes
        $_attr = $this->getAttributes($compiler, $args);
        $this->openTag($compiler, 'while', $compiler->nocache);

        // maybe nocache because of nocache variables
        $compiler->nocache = $compiler->nocache | $compiler->tag_nocache;
        if (is_array($parameter['if condition'])) {
            if ($compiler->nocache) {
                $_nocache = ',true';
                // create nocache var to make it know for further compiling
                if (is_array($parameter['if condition']['var'])) {
                    $compiler->template->tpl_vars[trim($parameter['if condition']['var']['var'], "'")] = new Smarty_variable(null, true);
                } else {
                    $compiler->template->tpl_vars[trim($parameter['if condition']['var'], "'")] = new Smarty_variable(null, true);
                }
            } else {
                $_nocache = '';
            }
            if (is_array($parameter['if condition']['var'])) {
                $_output = "<?php if (!isset(\$_smarty_tpl->tpl_vars[" . $parameter['if condition']['var']['var'] . "]) || !is_array(\$_smarty_tpl->tpl_vars[" . $parameter['if condition']['var']['var'] . "]->value)) \$_smarty_tpl->createLocalArrayVariable(" . $parameter['if condition']['var']['var'] . "$_nocache);\n";
                $_output .= "while (\$_smarty_tpl->tpl_vars[" . $parameter['if condition']['var']['var'] . "]->value" . $parameter['if condition']['var']['smarty_internal_index'] . " = " . $parameter['if condition']['value'] . "){?>";
            } else {
                $_output = "<?php if (!isset(\$_smarty_tpl->tpl_vars[" . $parameter['if condition']['var'] . "])) \$_smarty_tpl->tpl_vars[" . $parameter['if condition']['var'] . "] = new Smarty_Variable(null{$_nocache});";
                $_output .= "while (\$_smarty_tpl->tpl_vars[" . $parameter['if condition']['var'] . "]->value = " . $parameter['if condition']['value'] . "){?>";
            }
            return $_output;
        } else {
            return "<?php while ({$parameter['if condition']}){?>";
        }
    }

}

/**
 * Smarty Internal Plugin Compile Whileclose Class
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_Whileclose extends Smarty_Internal_CompileBase {

    /**
     * Compiles code for the {/while} tag
     *
     * @param array  $args     array with attributes from parser
     * @param object $compiler compiler object
     * @return string compiled code
     */
    public function compile($args, $compiler)
    {
        // must endblock be nocache?
        if ($compiler->nocache) {
            $compiler->tag_nocache = true;
        }
        $compiler->nocache = $this->closeTag($compiler, array('while'));
        return "<?php }?>";
    }

}

?><?php
/**
 * Smarty Internal Plugin
 *
 * @package Smarty
 * @subpackage TemplateResources
 */

/**
 * Smarty Resource Data Object
 *
 * Meta Data Container for Config Files
 *
 * @package Smarty
 * @subpackage TemplateResources
 * @author Rodney Rehm
 *
 * @property string $content
 * @property int    $timestamp
 * @property bool   $exists
 */
class Smarty_Config_Source extends Smarty_Template_Source {

    /**
     * create Config Object container
     *
     * @param Smarty_Resource $handler          Resource Handler this source object communicates with
     * @param Smarty          $smarty           Smarty instance this source object belongs to
     * @param string          $resource         full config_resource
     * @param string          $type             type of resource
     * @param string          $name             resource name
     * @param string          $unique_resource  unqiue resource name
     */
    public function __construct(Smarty_Resource $handler, Smarty $smarty, $resource, $type, $name, $unique_resource)
    {
        $this->handler = $handler; // Note: prone to circular references

        // Note: these may be ->config_compiler_class etc in the future
        //$this->config_compiler_class = $handler->config_compiler_class;
        //$this->config_lexer_class = $handler->config_lexer_class;
        //$this->config_parser_class = $handler->config_parser_class;

        $this->smarty = $smarty;
        $this->resource = $resource;
        $this->type = $type;
        $this->name = $name;
        $this->unique_resource = $unique_resource;
    }

    /**
     * <<magic>> Generic setter.
     *
     * @param string $property_name valid: content, timestamp, exists
     * @param mixed  $value         newly assigned value (not check for correct type)
     * @throws SmartyException when the given property name is not valid
     */
    public function __set($property_name, $value)
    {
        switch ($property_name) {
            case 'content':
            case 'timestamp':
            case 'exists':
                $this->$property_name = $value;
                break;

            default:
                throw new SmartyException("invalid config property '$property_name'.");
        }
    }

    /**
     * <<magic>> Generic getter.
     *
     * @param string $property_name valid: content, timestamp, exists
     * @throws SmartyException when the given property name is not valid
     */
    public function __get($property_name)
    {
        switch ($property_name) {
            case 'timestamp':
            case 'exists':
                $this->handler->populateTimestamp($this);
                return $this->$property_name;

            case 'content':
                return $this->content = $this->handler->getContent($this);

            default:
                throw new SmartyException("config property '$property_name' does not exist.");
        }
    }

}

?><?php
/**
 * Smarty Internal Plugin Compile Include PHP
 *
 * Compiles the {include_php} tag
 *
 * @package Smarty
 * @subpackage Compiler
 * @author Uwe Tews
 */

/**
 * Smarty Internal Plugin Compile Insert Class
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_Include_Php extends Smarty_Internal_CompileBase {

    /**
     * Attribute definition: Overwrites base class.
     *
     * @var array
     * @see Smarty_Internal_CompileBase
     */
    public $required_attributes = array('file');
    /**
     * Attribute definition: Overwrites base class.
     *
     * @var array
     * @see Smarty_Internal_CompileBase
     */
    public $shorttag_order = array('file');
    /**
     * Attribute definition: Overwrites base class.
     *
     * @var array
     * @see Smarty_Internal_CompileBase
     */
    public $optional_attributes = array('once', 'assign');

    /**
     * Compiles code for the {include_php} tag
     *
     * @param array  $args     array with attributes from parser
     * @param object $compiler compiler object
     * @return string compiled code
     */
    public function compile($args, $compiler)
    {
        if (!($compiler->smarty instanceof SmartyBC)) {
            throw new SmartyException("{include_php} is deprecated, use SmartyBC class to enable");
        }
        // check and get attributes
        $_attr = $this->getAttributes($compiler, $args);

        $_output = '<?php ';

        $_smarty_tpl = $compiler->template;
        $_filepath = false;
        eval('$_file = ' . $_attr['file'] . ';');
        if (!isset($compiler->smarty->security_policy) && file_exists($_file)) {
            $_filepath = $_file;
        } else {
            if (isset($compiler->smarty->security_policy)) {
                $_dir = $compiler->smarty->security_policy->trusted_dir;
            } else {
                $_dir = $compiler->smarty->trusted_dir;
            }
            if (!empty($_dir)) {
                foreach((array)$_dir as $_script_dir) {
                    $_script_dir = rtrim($_script_dir, '/\\') . DS;
                    if (file_exists($_script_dir . $_file)) {
                        $_filepath = $_script_dir .  $_file;
                        break;
                    }
                }
            }
        }
        if ($_filepath == false) {
            $compiler->trigger_template_error("{include_php} file '{$_file}' is not readable", $compiler->lex->taglineno);
        }

        if (isset($compiler->smarty->security_policy)) {
            $compiler->smarty->security_policy->isTrustedPHPDir($_filepath);
        }

        if (isset($_attr['assign'])) {
            // output will be stored in a smarty variable instead of being displayed
            $_assign = $_attr['assign'];
        }
        $_once = '_once';
        if (isset($_attr['once'])) {
            if ($_attr['once'] == 'false') {
                $_once = '';
            }
        }

        if (isset($_assign)) {
            return "<?php ob_start(); include{$_once} ('{$_filepath}'); \$_smarty_tpl->assign({$_assign},ob_get_contents()); ob_end_clean();?>";
        } else {
            return "<?php include{$_once} ('{$_filepath}');?>\n";
        }
    }

}

?><?php

/**
 * Smarty Internal Plugin Compile Insert
 *
 * Compiles the {insert} tag
 *
 * @package Smarty
 * @subpackage Compiler
 * @author Uwe Tews
 */

/**
 * Smarty Internal Plugin Compile Insert Class
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_Insert extends Smarty_Internal_CompileBase {

    /**
     * Attribute definition: Overwrites base class.
     *
     * @var array
     * @see Smarty_Internal_CompileBase
     */
    public $required_attributes = array('name');
    /**
     * Attribute definition: Overwrites base class.
     *
     * @var array
     * @see Smarty_Internal_CompileBase
     */
    public $shorttag_order = array('name');
    /**
     * Attribute definition: Overwrites base class.
     *
     * @var array
     * @see Smarty_Internal_CompileBase
     */
    public $optional_attributes = array('_any');

    /**
     * Compiles code for the {insert} tag
     *
     * @param array  $args     array with attributes from parser
     * @param object $compiler compiler object
     * @return string compiled code
     */
    public function compile($args, $compiler)
    {
        // check and get attributes
        $_attr = $this->getAttributes($compiler, $args);
        // never compile as nocache code
        $compiler->suppressNocacheProcessing = true;
        $compiler->tag_nocache = true;
        $_smarty_tpl = $compiler->template;
        $_name = null;
        $_script = null;

        $_output = '<?php ';
        // save posible attributes
        eval('$_name = ' . $_attr['name'] . ';');
        if (isset($_attr['assign'])) {
            // output will be stored in a smarty variable instead of being displayed
            $_assign = $_attr['assign'];
            // create variable to make shure that the compiler knows about its nocache status
            $compiler->template->tpl_vars[trim($_attr['assign'], "'")] = new Smarty_Variable(null, true);
        }
        if (isset($_attr['script'])) {
            // script which must be included
            $_function = "smarty_insert_{$_name}";
            $_smarty_tpl = $compiler->template;
            $_filepath = false;
            eval('$_script = ' . $_attr['script'] . ';');
            if (!isset($compiler->smarty->security_policy) && file_exists($_script)) {
                $_filepath = $_script;
            } else {
                if (isset($compiler->smarty->security_policy)) {
                    $_dir = $compiler->smarty->security_policy->trusted_dir;
                } else {
                    $_dir = $compiler->smarty->trusted_dir;
                }
                if (!empty($_dir)) {
                    foreach((array)$_dir as $_script_dir) {
                        $_script_dir = rtrim($_script_dir, '/\\') . DS;
                        if (file_exists($_script_dir . $_script)) {
                            $_filepath = $_script_dir . $_script;
                            break;
                        }
                    }
                }
            }
            if ($_filepath == false) {
                $compiler->trigger_template_error("{insert} missing script file '{$_script}'", $compiler->lex->taglineno);
            }
            // code for script file loading
            $_output .= "require_once '{$_filepath}' ;";
            require_once $_filepath;
            if (!is_callable($_function)) {
                $compiler->trigger_template_error(" {insert} function '{$_function}' is not callable in script file '{$_script}'", $compiler->lex->taglineno);
            }
        } else {
            $_filepath = 'null';
            $_function = "insert_{$_name}";
            // function in PHP script ?
            if (!is_callable($_function)) {
                // try plugin
                if (!$_function = $compiler->getPlugin($_name, 'insert')) {
                    $compiler->trigger_template_error("{insert} no function or plugin found for '{$_name}'", $compiler->lex->taglineno);
                }
            }
        }
        // delete {insert} standard attributes
        unset($_attr['name'], $_attr['assign'], $_attr['script'], $_attr['nocache']);
        // convert attributes into parameter array string
        $_paramsArray = array();
        foreach ($_attr as $_key => $_value) {
            $_paramsArray[] = "'$_key' => $_value";
        }
        $_params = 'array(' . implode(", ", $_paramsArray) . ')';
        // call insert
        if (isset($_assign)) {
            if ($_smarty_tpl->caching) {
                $_output .= "echo Smarty_Internal_Nocache_Insert::compile ('{$_function}',{$_params}, \$_smarty_tpl, '{$_filepath}',{$_assign});?>";
            } else {
                $_output .= "\$_smarty_tpl->assign({$_assign} , {$_function} ({$_params},\$_smarty_tpl), true);?>";
            }
        } else {
            $compiler->has_output = true;
            if ($_smarty_tpl->caching) {
                $_output .= "echo Smarty_Internal_Nocache_Insert::compile ('{$_function}',{$_params}, \$_smarty_tpl, '{$_filepath}');?>";
            } else {
                $_output .= "echo {$_function}({$_params},\$_smarty_tpl);?>";
            }
        }
        return $_output;
    }

}

?><?php
/**
 * Smarty Internal Plugin Compile Block
 *
 * Compiles the {block}{/block} tags
 *
 * @package Smarty
 * @subpackage Compiler
 * @author Uwe Tews
 */

/**
 * Smarty Internal Plugin Compile Block Class
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_Block extends Smarty_Internal_CompileBase {

    /**
     * Attribute definition: Overwrites base class.
     *
     * @var array
     * @see Smarty_Internal_CompileBase
     */
    public $required_attributes = array('name');
    /**
     * Attribute definition: Overwrites base class.
     *
     * @var array
     * @see Smarty_Internal_CompileBase
     */
    public $shorttag_order = array('name', 'hide');
    /**
     * Attribute definition: Overwrites base class.
     *
     * @var array
     * @see Smarty_Internal_CompileBase
     */
    public $optional_attributes = array('hide');

    /**
     * Compiles code for the {block} tag
     *
     * @param array  $args     array with attributes from parser
     * @param object $compiler compiler object
     * @return boolean true
     */
    public function compile($args, $compiler)
    {
        // check and get attributes
        $_attr = $this->getAttributes($compiler, $args);
        $save = array($_attr, $compiler->parser->current_buffer, $compiler->nocache, $compiler->smarty->merge_compiled_includes);
        $this->openTag($compiler, 'block', $save);
        if ($_attr['nocache'] == true) {
            $compiler->nocache = true;
        }
        // set flag for {block} tag
        $compiler->inheritance = true;
        // must merge includes
        $compiler->smarty->merge_compiled_includes = true;

        $compiler->parser->current_buffer = new _smarty_template_buffer($compiler->parser);
        $compiler->has_code = false;
        return true;
    }

    /**
     * Save or replace child block source by block name during parsing
     *
     * @param string $block_content     block source content
     * @param string $block_tag         opening block tag
     * @param object $template          template object
     * @param string $filepath          filepath of template source
     */
    public static function saveBlockData($block_content, $block_tag, $template, $filepath)
    {
        $_rdl = preg_quote($template->smarty->right_delimiter);
        $_ldl = preg_quote($template->smarty->left_delimiter);

        if (0 == preg_match("!({$_ldl}block\s+)(name=)?(\w+|'.*'|\".*\")(\s*?)?((append|prepend|nocache)?(\s*)?(hide)?)?(\s*{$_rdl})!", $block_tag, $_match)) {
            $error_text = 'Syntax Error in template "' . $template->source->filepath . '"   "' . htmlspecialchars($block_tag) . '" illegal options';
            throw new SmartyCompilerException($error_text);
        } else {
            $_name = trim($_match[3], '\'"');
            if ($_match[8] != 'hide' || isset($template->block_data[$_name])) {        // replace {$smarty.block.child}
                if (strpos($block_content, $template->smarty->left_delimiter . '$smarty.block.child' . $template->smarty->right_delimiter) !== false) {
                    if (isset($template->block_data[$_name])) {
                        $block_content = str_replace($template->smarty->left_delimiter . '$smarty.block.child' . $template->smarty->right_delimiter,
                        $template->block_data[$_name]['source'], $block_content);
                        unset($template->block_data[$_name]);
                    } else {
                        $block_content = str_replace($template->smarty->left_delimiter . '$smarty.block.child' . $template->smarty->right_delimiter,
                        '', $block_content);
                    }
                }
                if (isset($template->block_data[$_name])) {
                    if (strpos($template->block_data[$_name]['source'], '%%%%SMARTY_PARENT%%%%') !== false) {
                        $template->block_data[$_name]['source'] =
                        str_replace('%%%%SMARTY_PARENT%%%%', $block_content, $template->block_data[$_name]['source']);
                    } elseif ($template->block_data[$_name]['mode'] == 'prepend') {
                        $template->block_data[$_name]['source'] .= $block_content;
                    } elseif ($template->block_data[$_name]['mode'] == 'append') {
                        $template->block_data[$_name]['source'] = $block_content . $template->block_data[$_name]['source'];
                    }
                } else {
                    $template->block_data[$_name]['source'] = $block_content;
                    $template->block_data[$_name]['file'] = $filepath;
                }
                if ($_match[6] == 'append') {
                    $template->block_data[$_name]['mode'] = 'append';
                } elseif ($_match[6] == 'prepend') {
                    $template->block_data[$_name]['mode'] = 'prepend';
                } else {
                    $template->block_data[$_name]['mode'] = 'replace';
                }
            }
        }
    }

    /**
     * Compile saved child block source
     *
     * @param object $compiler  compiler object
     * @param string $_name     optional name of child block
     * @return string   compiled code of schild block
     */
    public static function compileChildBlock($compiler, $_name = null)
    {
        $_output = '';
        // if called by {$smarty.block.child} we must search the name of enclosing {block}
        if ($_name == null) {
            $stack_count = count($compiler->_tag_stack);
            while (--$stack_count >= 0) {
                if ($compiler->_tag_stack[$stack_count][0] == 'block') {
                    $_name = trim($compiler->_tag_stack[$stack_count][1][0]['name'] ,"'\"");
                    break;
                }
            }
            // flag that child is already compile by {$smarty.block.child} inclusion
            $compiler->template->block_data[$_name]['compiled'] = true;
        }
        if ($_name == null) {
            $compiler->trigger_template_error('{$smarty.block.child} used out of context', $compiler->lex->taglineno);
        }
        // undefined child?
        if (!isset($compiler->template->block_data[$_name]['source'])) {
            return '';
        }
        $_tpl = new Smarty_Internal_template ('string:' . $compiler->template->block_data[$_name]['source'], $compiler->smarty, $compiler->template, $compiler->template->cache_id,
        $compiler->template->compile_id = null, $compiler->template->caching, $compiler->template->cache_lifetime);
        $_tpl->variable_filters = $compiler->template->variable_filters;
        $_tpl->properties['nocache_hash'] = $compiler->template->properties['nocache_hash'];
        $_tpl->source->filepath = $compiler->template->block_data[$_name]['file'];
        $_tpl->allow_relative_path = true;
        if ($compiler->nocache) {
            $_tpl->compiler->forceNocache = 2;
        } else {
            $_tpl->compiler->forceNocache = 1;
        }
        $_tpl->compiler->suppressHeader = true;
        $_tpl->compiler->suppressTemplatePropertyHeader = true;
        $_tpl->compiler->suppressMergedTemplates = true;
        if (strpos($compiler->template->block_data[$_name]['source'], '%%%%SMARTY_PARENT%%%%') !== false) {
            $_output = str_replace('%%%%SMARTY_PARENT%%%%', $compiler->parser->current_buffer->to_smarty_php(), $_tpl->compiler->compileTemplate($_tpl));
        } elseif ($compiler->template->block_data[$_name]['mode'] == 'prepend') {
            $_output = $_tpl->compiler->compileTemplate($_tpl) . $compiler->parser->current_buffer->to_smarty_php();
        } elseif ($compiler->template->block_data[$_name]['mode'] == 'append') {
            $_output = $compiler->parser->current_buffer->to_smarty_php() . $_tpl->compiler->compileTemplate($_tpl);
        } elseif (!empty($compiler->template->block_data[$_name])) {
            $_output = $_tpl->compiler->compileTemplate($_tpl);
        }
        $compiler->template->properties['file_dependency'] = array_merge($compiler->template->properties['file_dependency'], $_tpl->properties['file_dependency']);
        $compiler->template->properties['function'] = array_merge($compiler->template->properties['function'], $_tpl->properties['function']);
        $compiler->merged_templates = array_merge($compiler->merged_templates, $_tpl->compiler->merged_templates);
        $compiler->template->variable_filters = $_tpl->variable_filters;
        if ($_tpl->has_nocache_code) {
            $compiler->template->has_nocache_code = true;
        }
        foreach($_tpl->required_plugins as $code => $tmp1) {
            foreach($tmp1 as $name => $tmp) {
                foreach($tmp as $type => $data) {
                    $compiler->template->required_plugins[$code][$name][$type] = $data;
                }
            }
        }
        unset($_tpl);
        return $_output;
    }

}

/**
 * Smarty Internal Plugin Compile BlockClose Class
 *
 * @package Smarty
 * @subpackage Compiler
*/
class Smarty_Internal_Compile_Blockclose extends Smarty_Internal_CompileBase {

    /**
     * Compiles code for the {/block} tag
     *
     * @param array  $args     array with attributes from parser
     * @param object $compiler compiler object
     * @return string compiled code
     */
    public function compile($args, $compiler)
    {
        $compiler->has_code = true;
        // check and get attributes
        $_attr = $this->getAttributes($compiler, $args);
        $saved_data = $this->closeTag($compiler, array('block'));
        $_name = trim($saved_data[0]['name'], "\"'");
        if (isset($compiler->template->block_data[$_name]) && !isset($compiler->template->block_data[$_name]['compiled'])) {
            $_output = Smarty_Internal_Compile_Block::compileChildBlock($compiler, $_name);
        } else {
            if (isset($saved_data[0]['hide']) && !isset($compiler->template->block_data[$_name]['source'])) {
                $_output = '';
            } else {
                $_output = $compiler->parser->current_buffer->to_smarty_php();
            }
            unset ($compiler->template->block_data[$_name]['compiled']);
        }
        // reset flags
        $compiler->parser->current_buffer = $saved_data[1];
        $compiler->nocache = $saved_data[2];
        $compiler->smarty->merge_compiled_includes = $saved_data[3];
        // reset flag for {block} tag
        $compiler->inheritance = false;
        // $_output content has already nocache code processed
        $compiler->suppressNocacheProcessing = true;
        return $_output;
    }

}

?><?php

/**
 * Smarty Internal Plugin Resource PHP
 *
 * Implements the file system as resource for PHP templates
 *
 * @package Smarty
 * @subpackage TemplateResources
 * @author Uwe Tews
 * @author Rodney Rehm
 */
class Smarty_Internal_Resource_PHP extends Smarty_Resource_Uncompiled {
    /**
     * container for short_open_tag directive's value before executing PHP templates
     * @var string
     */
    protected $short_open_tag;

    /**
     * Create a new PHP Resource
     *
     */
    public function __construct()
    {
        $this->short_open_tag = ini_get( 'short_open_tag' );
    }

    /**
     * populate Source Object with meta data from Resource
     *
     * @param Smarty_Template_Source $source source object
     * @param Smarty_Internal_Template $_template template object
     * @return void
     */
    public function populate(Smarty_Template_Source $source, Smarty_Internal_Template $_template=null)
    {
        $source->filepath = $this->buildFilepath($source, $_template);

        if ($source->filepath !== false) {
            if (is_object($source->smarty->security_policy)) {
                $source->smarty->security_policy->isTrustedResourceDir($source->filepath);
            }

            $source->uid = sha1($source->filepath);
            if ($source->smarty->compile_check) {
                $source->timestamp = @filemtime($source->filepath);
                $source->exists = !!$source->timestamp;
            }
        }
    }

    /**
     * populate Source Object with timestamp and exists from Resource
     *
     * @param Smarty_Template_Source $source source object
     * @return void
     */
    public function populateTimestamp(Smarty_Template_Source $source)
    {
        $source->timestamp = @filemtime($source->filepath);
        $source->exists = !!$source->timestamp;
    }

    /**
     * Load template's source from file into current template object
     *
     * @param Smarty_Template_Source $source source object
     * @return string template source
     * @throws SmartyException if source cannot be loaded
     */
    public function getContent(Smarty_Template_Source $source)
    {
        if ($source->timestamp) {
            return '';
        }
        throw new SmartyException("Unable to read template {$source->type} '{$source->name}'");
    }

    /**
     * Render and output the template (without using the compiler)
     *
     * @param Smarty_Template_Source $source source object
     * @param Smarty_Internal_Template $_template template object
     * @return void
     * @throws SmartyException if template cannot be loaded or allow_php_templates is disabled
     */
    public function renderUncompiled(Smarty_Template_Source $source, Smarty_Internal_Template $_template)
    {
        $_smarty_template = $_template;

        if (!$source->smarty->allow_php_templates) {
            throw new SmartyException("PHP templates are disabled");
        }
        if (!$source->exists) {
            if ($_template->parent instanceof Smarty_Internal_Template) {
                $parent_resource = " in '{$_template->parent->template_resource}'";
            } else {
                $parent_resource = '';
            }
            throw new SmartyException("Unable to load template {$source->type} '{$source->name}'{$parent_resource}");
        }

        // prepare variables
        extract($_template->getTemplateVars());

        // include PHP template with short open tags enabled
        ini_set( 'short_open_tag', '1' );
        include($source->filepath);
        ini_set( 'short_open_tag', $this->short_open_tag );
    }
}

?><?php
/**
 * Smarty Internal Plugin Function Call Handler
 *
 * @package Smarty
 * @subpackage PluginsInternal
 * @author Uwe Tews
 */

/**
 * This class does call function defined with the {function} tag
 *
 * @package Smarty
 * @subpackage PluginsInternal
 */
class Smarty_Internal_Function_Call_Handler {

    /**
     * This function handles calls to template functions defined by {function}
     * It does create a PHP function at the first call
     *
     * @param string                   $_name       template function name
     * @param Smarty_Internal_Template $_template   template object
     * @param array                    $_params     Smarty variables passed as call paramter
     * @param string                   $_hash       nocache hash value
     * @param bool                     $_nocache    nocache flag
     */
    public static function call($_name, Smarty_Internal_Template $_template, $_params, $_hash, $_nocache)
    {
        if ($_nocache) {
            $_function = "smarty_template_function_{$_name}_nocache";
        } else {
            $_function = "smarty_template_function_{$_hash}_{$_name}";
        }
        if (!is_callable($_function)) {
            $_code = "function {$_function}(\$_smarty_tpl,\$params) {
    \$saved_tpl_vars = \$_smarty_tpl->tpl_vars;
    foreach (\$_smarty_tpl->smarty->template_functions['{$_name}']['parameter'] as \$key => \$value) {\$_smarty_tpl->tpl_vars[\$key] = new Smarty_variable(\$value);};
    foreach (\$params as \$key => \$value) {\$_smarty_tpl->tpl_vars[\$key] = new Smarty_variable(\$value);}?>";
            if ($_nocache) {
                $_code .= preg_replace(array("!<\?php echo \\'/\*%%SmartyNocache:{$_template->smarty->template_functions[$_name]['nocache_hash']}%%\*/|/\*/%%SmartyNocache:{$_template->smarty->template_functions[$_name]['nocache_hash']}%%\*/\\';\?>!",
                        "!\\\'!"), array('', "'"), $_template->smarty->template_functions[$_name]['compiled']);
                $_template->smarty->template_functions[$_name]['called_nocache'] = true;
            } else {
                $_code .= preg_replace("/{$_template->smarty->template_functions[$_name]['nocache_hash']}/", $_template->properties['nocache_hash'], $_template->smarty->template_functions[$_name]['compiled']);
            }
            $_code .= "<?php \$_smarty_tpl->tpl_vars = \$saved_tpl_vars;}";
            eval($_code);
        }
        $_function($_template, $_params);
    }

}

?><?php
/**
 * Smarty Internal Plugin Compile Nocache
 *
 * Compiles the {nocache} {/nocache} tags.
 *
 * @package Smarty
 * @subpackage Compiler
 * @author Uwe Tews
 */

/**
 * Smarty Internal Plugin Compile Nocache Classv
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_Nocache extends Smarty_Internal_CompileBase {

    /**
     * Compiles code for the {nocache} tag
     *
     * This tag does not generate compiled output. It only sets a compiler flag.
     *
     * @param array  $args     array with attributes from parser
     * @param object $compiler compiler object
     * @return bool
     */
    public function compile($args, $compiler)
    {
        $_attr = $this->getAttributes($compiler, $args);
        if ($_attr['nocache'] === true) {
            $compiler->trigger_template_error('nocache option not allowed', $compiler->lex->taglineno);
        }
        // enter nocache mode
        $compiler->nocache = true;
        // this tag does not return compiled code
        $compiler->has_code = false;
        return true;
    }

}

/**
 * Smarty Internal Plugin Compile Nocacheclose Class
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_Nocacheclose extends Smarty_Internal_CompileBase {

    /**
     * Compiles code for the {/nocache} tag
     *
     * This tag does not generate compiled output. It only sets a compiler flag.
     *
     * @param array  $args     array with attributes from parser
     * @param object $compiler compiler object
     * @return bool
     */
    public function compile($args, $compiler)
    {
        $_attr = $this->getAttributes($compiler, $args);
        // leave nocache mode
        $compiler->nocache = false;
        // this tag does not return compiled code
        $compiler->has_code = false;
        return true;
    }

}

?><?php
/**
 * Smarty Internal Plugin Resource Eval
 *
 * @package Smarty
 * @subpackage TemplateResources
 * @author Uwe Tews
 * @author Rodney Rehm
 */

/**
 * Smarty Internal Plugin Resource Eval
 *
 * Implements the strings as resource for Smarty template
 *
 * {@internal unlike string-resources the compiled state of eval-resources is NOT saved for subsequent access}}
 *
 * @package Smarty
 * @subpackage TemplateResources
 */
class Smarty_Internal_Resource_Eval extends Smarty_Resource_Recompiled {

    /**
     * populate Source Object with meta data from Resource
     *
     * @param Smarty_Template_Source   $source    source object
     * @param Smarty_Internal_Template $_template template object
     * @return void
     */
    public function populate(Smarty_Template_Source $source, Smarty_Internal_Template $_template=null)
    {
        $source->uid = $source->filepath = sha1($source->name);
        $source->timestamp = false;
        $source->exists = true;
    }

    /**
     * Load template's source from $resource_name into current template object
     *
     * @uses decode() to decode base64 and urlencoded template_resources
     * @param Smarty_Template_Source $source source object
     * @return string template source
     */
    public function getContent(Smarty_Template_Source $source)
    {
        return $this->decode($source->name);
    }
    
    /**
     * decode base64 and urlencode
     *
     * @param string $string template_resource to decode
     * @return string decoded template_resource
     */
    protected function decode($string)
    {
        // decode if specified
        if (($pos = strpos($string, ':')) !== false) {
            if (!strncmp($string, 'base64', 6)) {
                return base64_decode(substr($string, 7));
            } elseif (!strncmp($string, 'urlencode', 9)) {
                return urldecode(substr($string, 10));
            }
        }
        
        return $string;
    }
    
    /**
     * modify resource_name according to resource handlers specifications
     *
     * @param Smarty $smarty        Smarty instance
     * @param string $resource_name resource_name to make unique
     * @return string unique resource name
     */
    protected function buildUniqueResourceName(Smarty $smarty, $resource_name)
    {
        return get_class($this) . '#' .$this->decode($resource_name);
    }

    /**
     * Determine basename for compiled filename
     *
     * @param Smarty_Template_Source $source source object
     * @return string resource's basename
     */
    protected function getBasename(Smarty_Template_Source $source)
    {
        return '';
    }

}

?><?php
/**
* Smarty Internal Plugin Templatelexer
*
* This is the lexer to break the template source into tokens
* @package Smarty
* @subpackage Compiler
* @author Uwe Tews
*/
/**
* Smarty Internal Plugin Templatelexer
*/
class Smarty_Internal_Templatelexer
{
    public $data;
    public $counter;
    public $token;
    public $value;
    public $node;
    public $line;
    public $taglineno;
    public $state = 1;
    public $strip = false;
    private $heredoc_id_stack = Array();
    public $smarty_token_names = array (		// Text for parser error messages
    				'IDENTITY'	=> '===',
    				'NONEIDENTITY'	=> '!==',
    				'EQUALS'	=> '==',
    				'NOTEQUALS'	=> '!=',
    				'GREATEREQUAL' => '(>=,ge)',
    				'LESSEQUAL' => '(<=,le)',
    				'GREATERTHAN' => '(>,gt)',
    				'LESSTHAN' => '(<,lt)',
    				'MOD' => '(%,mod)',
    				'NOT'			=> '(!,not)',
    				'LAND'		=> '(&&,and)',
    				'LOR'			=> '(||,or)',
    				'LXOR'			=> 'xor',
    				'OPENP'		=> '(',
    				'CLOSEP'	=> ')',
    				'OPENB'		=> '[',
    				'CLOSEB'	=> ']',
    				'PTR'			=> '->',
    				'APTR'		=> '=>',
    				'EQUAL'		=> '=',
    				'NUMBER'	=> 'number',
    				'UNIMATH'	=> '+" , "-',
    				'MATH'		=> '*" , "/" , "%',
    				'INCDEC'	=> '++" , "--',
    				'SPACE'		=> ' ',
    				'DOLLAR'	=> '$',
    				'SEMICOLON' => ';',
    				'COLON'		=> ':',
    				'DOUBLECOLON'		=> '::',
    				'AT'		=> '@',
    				'HATCH'		=> '#',
    				'QUOTE'		=> '"',
    				'BACKTICK'		=> '`',
    				'VERT'		=> '|',
    				'DOT'			=> '.',
    				'COMMA'		=> '","',
    				'ANDSYM'		=> '"&"',
    				'QMARK'		=> '"?"',
    				'ID'			=> 'identifier',
    				'OTHER'		=> 'text',
    				'LINEBREAK'		=> 'newline',
     				'FAKEPHPSTARTTAG'	=> 'Fake PHP start tag',
     				'PHPSTARTTAG'	=> 'PHP start tag',
     				'PHPENDTAG'	=> 'PHP end tag',
 						'LITERALSTART'  => 'Literal start',
 						'LITERALEND'    => 'Literal end',
    				'LDELSLASH' => 'closing tag',
    				'COMMENT' => 'comment',
    				'AS' => 'as',
    				'TO' => 'to',
    				);


    function __construct($data,$compiler)
    {
//        $this->data = preg_replace("/(\r\n|\r|\n)/", "\n", $data);
        $this->data = $data;
        $this->counter = 0;
        $this->line = 1;
        $this->smarty = $compiler->smarty;
        $this->compiler = $compiler;
        $this->ldel = preg_quote($this->smarty->left_delimiter,'/');
        $this->ldel_length = strlen($this->smarty->left_delimiter);
        $this->rdel = preg_quote($this->smarty->right_delimiter,'/');
        $this->smarty_token_names['LDEL'] =	$this->smarty->left_delimiter;
        $this->smarty_token_names['RDEL'] =	$this->smarty->right_delimiter;
        $this->mbstring_overload = ini_get('mbstring.func_overload') & 2;
     }


    private $_yy_state = 1;
    private $_yy_stack = array();

    function yylex()
    {
        return $this->{'yylex' . $this->_yy_state}();
    }

    function yypushstate($state)
    {
        array_push($this->_yy_stack, $this->_yy_state);
        $this->_yy_state = $state;
    }

    function yypopstate()
    {
        $this->_yy_state = array_pop($this->_yy_stack);
    }

    function yybegin($state)
    {
        $this->_yy_state = $state;
    }



    function yylex1()
    {
        $tokenMap = array (
              1 => 0,
              2 => 0,
              3 => 1,
              5 => 0,
              6 => 0,
              7 => 0,
              8 => 0,
              9 => 0,
              10 => 0,
              11 => 0,
              12 => 1,
              14 => 0,
              15 => 0,
              16 => 0,
              17 => 0,
              18 => 0,
              19 => 0,
              20 => 0,
              21 => 0,
              22 => 0,
              23 => 0,
              24 => 2,
              27 => 0,
              28 => 0,
            );
        if ($this->counter >= strlen($this->data)) {
            return false; // end of input
        }
        $yy_global_pattern = "/\G(".$this->ldel."[$]smarty\\.block\\.child".$this->rdel.")|\G(\\{\\})|\G(".$this->ldel."\\*([\S\s]*?)\\*".$this->rdel.")|\G([\t ]*[\r\n]+[\t ]*)|\G(".$this->ldel."strip".$this->rdel.")|\G(".$this->ldel."\\s{1,}strip\\s{1,}".$this->rdel.")|\G(".$this->ldel."\/strip".$this->rdel.")|\G(".$this->ldel."\\s{1,}\/strip\\s{1,}".$this->rdel.")|\G(".$this->ldel."\\s*literal\\s*".$this->rdel.")|\G(".$this->ldel."\\s{1,}\/)|\G(".$this->ldel."\\s*(if|elseif|else if|while)\\s+)|\G(".$this->ldel."\\s*for\\s+)|\G(".$this->ldel."\\s*foreach(?![^\s]))|\G(".$this->ldel."\\s*setfilter\\s+)|\G(".$this->ldel."\\s{1,})|\G(".$this->ldel."\/)|\G(".$this->ldel.")|\G(<\\?(?:php\\w+|=|[a-zA-Z]+)?)|\G(\\?>)|\G(<%)|\G(%>)|\G(([\S\s]*?)(?=([\t ]*[\r\n]+[\t ]*|".$this->ldel."|<\\?|\\?>|<%|%>)))|\G([\S\s]+)|\G(.)/iS";

        do {
            if ($this->mbstring_overload ? preg_match($yy_global_pattern, substr($this->data, $this->counter), $yymatches) : preg_match($yy_global_pattern,$this->data, $yymatches, null, $this->counter)) {
                $yysubmatches = $yymatches;
                $yymatches = array_filter($yymatches, 'strlen'); // remove empty sub-patterns
                if (!count($yymatches)) {
                    throw new Exception('Error: lexing failed because a rule matched' .
                        ' an empty string.  Input "' . substr($this->data,
                        $this->counter, 5) . '... state TEXT');
                }
                next($yymatches); // skip global match
                $this->token = key($yymatches); // token number
                if ($tokenMap[$this->token]) {
                    // extract sub-patterns for passing to lex function
                    $yysubmatches = array_slice($yysubmatches, $this->token + 1,
                        $tokenMap[$this->token]);
                } else {
                    $yysubmatches = array();
                }
                $this->value = current($yymatches); // token value
                $r = $this->{'yy_r1_' . $this->token}($yysubmatches);
                if ($r === null) {
                    $this->counter += strlen($this->value);
                    $this->line += substr_count($this->value, "\n");
                    // accept this token
                    return true;
                } elseif ($r === true) {
                    // we have changed state
                    // process this token in the new state
                    return $this->yylex();
                } elseif ($r === false) {
                    $this->counter += strlen($this->value);
                    $this->line += substr_count($this->value, "\n");
                    if ($this->counter >= strlen($this->data)) {
                        return false; // end of input
                    }
                    // skip this token
                    continue;
                }            } else {
                throw new Exception('Unexpected input at line' . $this->line .
                    ': ' . $this->data[$this->counter]);
            }
            break;
        } while (true);

    } // end function


    const TEXT = 1;
    function yy_r1_1($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_SMARTYBLOCKCHILD;
    }
    function yy_r1_2($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_OTHER;
    }
    function yy_r1_3($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_COMMENT;
    }
    function yy_r1_5($yy_subpatterns)
    {

  if ($this->strip) {
     return false;
  } else {
     $this->token = Smarty_Internal_Templateparser::TP_LINEBREAK;
  }
    }
    function yy_r1_6($yy_subpatterns)
    {

  $this->strip = true;
  return false;
    }
    function yy_r1_7($yy_subpatterns)
    {

  if ($this->smarty->auto_literal) {
     $this->token = Smarty_Internal_Templateparser::TP_OTHER;
  } else {
    $this->strip = true;
    return false;
  }
    }
    function yy_r1_8($yy_subpatterns)
    {

  $this->strip = false;
  return false;
    }
    function yy_r1_9($yy_subpatterns)
    {

  if ($this->smarty->auto_literal) {
     $this->token = Smarty_Internal_Templateparser::TP_OTHER;
  } else {
    $this->strip = false;
    return false;
  }
    }
    function yy_r1_10($yy_subpatterns)
    {

   $this->token = Smarty_Internal_Templateparser::TP_LITERALSTART;
   $this->yypushstate(self::LITERAL);
    }
    function yy_r1_11($yy_subpatterns)
    {

  if ($this->smarty->auto_literal) {
     $this->token = Smarty_Internal_Templateparser::TP_OTHER;
  } else {
     $this->token = Smarty_Internal_Templateparser::TP_LDELSLASH;
     $this->yypushstate(self::SMARTY);
     $this->taglineno = $this->line;
  }
    }
    function yy_r1_12($yy_subpatterns)
    {

  if ($this->smarty->auto_literal && trim(substr($this->value,$this->ldel_length,1)) == '') {
     $this->token = Smarty_Internal_Templateparser::TP_OTHER;
  } else {
     $this->token = Smarty_Internal_Templateparser::TP_LDELIF;
     $this->yypushstate(self::SMARTY);
     $this->taglineno = $this->line;
  }
    }
    function yy_r1_14($yy_subpatterns)
    {

  if ($this->smarty->auto_literal && trim(substr($this->value,$this->ldel_length,1)) == '') {
     $this->token = Smarty_Internal_Templateparser::TP_OTHER;
  } else {
     $this->token = Smarty_Internal_Templateparser::TP_LDELFOR;
     $this->yypushstate(self::SMARTY);
     $this->taglineno = $this->line;
  }
    }
    function yy_r1_15($yy_subpatterns)
    {

  if ($this->smarty->auto_literal && trim(substr($this->value,$this->ldel_length,1)) == '') {
     $this->token = Smarty_Internal_Templateparser::TP_OTHER;
  } else {
     $this->token = Smarty_Internal_Templateparser::TP_LDELFOREACH;
     $this->yypushstate(self::SMARTY);
     $this->taglineno = $this->line;
  }
    }
    function yy_r1_16($yy_subpatterns)
    {

  if ($this->smarty->auto_literal && trim(substr($this->value,$this->ldel_length,1)) == '') {
     $this->token = Smarty_Internal_Templateparser::TP_OTHER;
  } else {
     $this->token = Smarty_Internal_Templateparser::TP_LDELSETFILTER;
     $this->yypushstate(self::SMARTY);
     $this->taglineno = $this->line;
  }
    }
    function yy_r1_17($yy_subpatterns)
    {

  if ($this->smarty->auto_literal) {
     $this->token = Smarty_Internal_Templateparser::TP_OTHER;
  } else {
     $this->token = Smarty_Internal_Templateparser::TP_LDEL;
     $this->yypushstate(self::SMARTY);
     $this->taglineno = $this->line;
  }
    }
    function yy_r1_18($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_LDELSLASH;
     $this->yypushstate(self::SMARTY);
     $this->taglineno = $this->line;
    }
    function yy_r1_19($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_LDEL;
     $this->yypushstate(self::SMARTY);
     $this->taglineno = $this->line;
    }
    function yy_r1_20($yy_subpatterns)
    {

  if (in_array($this->value, Array('<?', '<?=', '<?php'))) {
    $this->token = Smarty_Internal_Templateparser::TP_PHPSTARTTAG;
  } elseif ($this->value == '<?xml') {
      $this->token = Smarty_Internal_Templateparser::TP_XMLTAG;
  } else {
    $this->token = Smarty_Internal_Templateparser::TP_FAKEPHPSTARTTAG;
    $this->value = substr($this->value, 0, 2);
  }
     }
    function yy_r1_21($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_PHPENDTAG;
    }
    function yy_r1_22($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_ASPSTARTTAG;
    }
    function yy_r1_23($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_ASPENDTAG;
    }
    function yy_r1_24($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_OTHER;
    }
    function yy_r1_27($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_OTHER;
    }
    function yy_r1_28($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_OTHER;
    }


    function yylex2()
    {
        $tokenMap = array (
              1 => 0,
              2 => 0,
              3 => 1,
              5 => 0,
              6 => 0,
              7 => 0,
              8 => 0,
              9 => 0,
              10 => 0,
              11 => 0,
              12 => 0,
              13 => 0,
              14 => 0,
              15 => 0,
              16 => 0,
              17 => 0,
              18 => 0,
              19 => 0,
              20 => 1,
              22 => 1,
              24 => 1,
              26 => 0,
              27 => 0,
              28 => 0,
              29 => 0,
              30 => 0,
              31 => 0,
              32 => 0,
              33 => 0,
              34 => 0,
              35 => 0,
              36 => 0,
              37 => 0,
              38 => 0,
              39 => 0,
              40 => 0,
              41 => 0,
              42 => 0,
              43 => 3,
              47 => 0,
              48 => 0,
              49 => 0,
              50 => 0,
              51 => 0,
              52 => 0,
              53 => 0,
              54 => 0,
              55 => 1,
              57 => 1,
              59 => 0,
              60 => 0,
              61 => 0,
              62 => 0,
              63 => 0,
              64 => 0,
              65 => 0,
              66 => 0,
              67 => 0,
              68 => 0,
              69 => 0,
              70 => 0,
              71 => 0,
              72 => 0,
              73 => 0,
              74 => 0,
              75 => 0,
              76 => 0,
            );
        if ($this->counter >= strlen($this->data)) {
            return false; // end of input
        }
        $yy_global_pattern = "/\G('[^'\\\\]*(?:\\\\.[^'\\\\]*)*')|\G(".$this->ldel."\\s{1,}\/)|\G(".$this->ldel."\\s*(if|elseif|else if|while)\\s+)|\G(".$this->ldel."\\s*for\\s+)|\G(".$this->ldel."\\s*foreach(?![^\s]))|\G(".$this->ldel."\\s{1,})|\G(\\s{1,}".$this->rdel.")|\G(".$this->ldel."\/)|\G(".$this->ldel.")|\G(".$this->rdel.")|\G(\\s+is\\s+in\\s+)|\G(\\s+as\\s+)|\G(\\s+to\\s+)|\G(\\s+step\\s+)|\G(\\s+instanceof\\s+)|\G(\\s*===\\s*)|\G(\\s*!==\\s*)|\G(\\s*==\\s*|\\s+eq\\s+)|\G(\\s*!=\\s*|\\s*<>\\s*|\\s+(ne|neq)\\s+)|\G(\\s*>=\\s*|\\s+(ge|gte)\\s+)|\G(\\s*<=\\s*|\\s+(le|lte)\\s+)|\G(\\s*>\\s*|\\s+gt\\s+)|\G(\\s*<\\s*|\\s+lt\\s+)|\G(\\s+mod\\s+)|\G(!\\s*|not\\s+)|\G(\\s*&&\\s*|\\s*and\\s+)|\G(\\s*\\|\\|\\s*|\\s*or\\s+)|\G(\\s*xor\\s+)|\G(\\s+is\\s+odd\\s+by\\s+)|\G(\\s+is\\s+not\\s+odd\\s+by\\s+)|\G(\\s+is\\s+odd)|\G(\\s+is\\s+not\\s+odd)|\G(\\s+is\\s+even\\s+by\\s+)|\G(\\s+is\\s+not\\s+even\\s+by\\s+)|\G(\\s+is\\s+even)|\G(\\s+is\\s+not\\s+even)|\G(\\s+is\\s+div\\s+by\\s+)|\G(\\s+is\\s+not\\s+div\\s+by\\s+)|\G(\\((int(eger)?|bool(ean)?|float|double|real|string|binary|array|object)\\)\\s*)|\G(\\(\\s*)|\G(\\s*\\))|\G(\\[\\s*)|\G(\\s*\\])|\G(\\s*->\\s*)|\G(\\s*=>\\s*)|\G(\\s*=\\s*)|\G(\\+\\+|--)|\G(\\s*(\\+|-)\\s*)|\G(\\s*(\\*|\/|%)\\s*)|\G(\\$)|\G(\\s*;)|\G(::)|\G(\\s*:\\s*)|\G(@)|\G(#)|\G(\")|\G(`)|\G(\\|)|\G(\\.)|\G(\\s*,\\s*)|\G(\\s*&\\s*)|\G(\\s*\\?\\s*)|\G(0[xX][0-9a-fA-F]+)|\G([0-9]*[a-zA-Z_]\\w*)|\G(\\d+)|\G(\\s+)|\G(.)/iS";

        do {
            if ($this->mbstring_overload ? preg_match($yy_global_pattern, substr($this->data, $this->counter), $yymatches) : preg_match($yy_global_pattern,$this->data, $yymatches, null, $this->counter)) {
                $yysubmatches = $yymatches;
                $yymatches = array_filter($yymatches, 'strlen'); // remove empty sub-patterns
                if (!count($yymatches)) {
                    throw new Exception('Error: lexing failed because a rule matched' .
                        ' an empty string.  Input "' . substr($this->data,
                        $this->counter, 5) . '... state SMARTY');
                }
                next($yymatches); // skip global match
                $this->token = key($yymatches); // token number
                if ($tokenMap[$this->token]) {
                    // extract sub-patterns for passing to lex function
                    $yysubmatches = array_slice($yysubmatches, $this->token + 1,
                        $tokenMap[$this->token]);
                } else {
                    $yysubmatches = array();
                }
                $this->value = current($yymatches); // token value
                $r = $this->{'yy_r2_' . $this->token}($yysubmatches);
                if ($r === null) {
                    $this->counter += strlen($this->value);
                    $this->line += substr_count($this->value, "\n");
                    // accept this token
                    return true;
                } elseif ($r === true) {
                    // we have changed state
                    // process this token in the new state
                    return $this->yylex();
                } elseif ($r === false) {
                    $this->counter += strlen($this->value);
                    $this->line += substr_count($this->value, "\n");
                    if ($this->counter >= strlen($this->data)) {
                        return false; // end of input
                    }
                    // skip this token
                    continue;
                }            } else {
                throw new Exception('Unexpected input at line' . $this->line .
                    ': ' . $this->data[$this->counter]);
            }
            break;
        } while (true);

    } // end function


    const SMARTY = 2;
    function yy_r2_1($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_SINGLEQUOTESTRING;
    }
    function yy_r2_2($yy_subpatterns)
    {

  if ($this->smarty->auto_literal) {
     $this->token = Smarty_Internal_Templateparser::TP_OTHER;
  } else {
     $this->token = Smarty_Internal_Templateparser::TP_LDELSLASH;
     $this->yypushstate(self::SMARTY);
     $this->taglineno = $this->line;
  }
    }
    function yy_r2_3($yy_subpatterns)
    {

  if ($this->smarty->auto_literal && trim(substr($this->value,$this->ldel_length,1)) == '') {
     $this->token = Smarty_Internal_Templateparser::TP_OTHER;
  } else {
     $this->token = Smarty_Internal_Templateparser::TP_LDELIF;
     $this->yypushstate(self::SMARTY);
     $this->taglineno = $this->line;
  }
    }
    function yy_r2_5($yy_subpatterns)
    {

  if ($this->smarty->auto_literal && trim(substr($this->value,$this->ldel_length,1)) == '') {
     $this->token = Smarty_Internal_Templateparser::TP_OTHER;
  } else {
     $this->token = Smarty_Internal_Templateparser::TP_LDELFOR;
     $this->yypushstate(self::SMARTY);
     $this->taglineno = $this->line;
  }
    }
    function yy_r2_6($yy_subpatterns)
    {

  if ($this->smarty->auto_literal && trim(substr($this->value,$this->ldel_length,1)) == '') {
     $this->token = Smarty_Internal_Templateparser::TP_OTHER;
  } else {
     $this->token = Smarty_Internal_Templateparser::TP_LDELFOREACH;
     $this->yypushstate(self::SMARTY);
     $this->taglineno = $this->line;
  }
    }
    function yy_r2_7($yy_subpatterns)
    {

  if ($this->smarty->auto_literal) {
     $this->token = Smarty_Internal_Templateparser::TP_OTHER;
  } else {
     $this->token = Smarty_Internal_Templateparser::TP_LDEL;
     $this->yypushstate(self::SMARTY);
     $this->taglineno = $this->line;
  }
    }
    function yy_r2_8($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_RDEL;
  $this->yypopstate();
    }
    function yy_r2_9($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_LDELSLASH;
     $this->yypushstate(self::SMARTY);
     $this->taglineno = $this->line;
    }
    function yy_r2_10($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_LDEL;
     $this->yypushstate(self::SMARTY);
     $this->taglineno = $this->line;
    }
    function yy_r2_11($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_RDEL;
     $this->yypopstate();
    }
    function yy_r2_12($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_ISIN;
    }
    function yy_r2_13($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_AS;
    }
    function yy_r2_14($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_TO;
    }
    function yy_r2_15($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_STEP;
    }
    function yy_r2_16($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_INSTANCEOF;
    }
    function yy_r2_17($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_IDENTITY;
    }
    function yy_r2_18($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_NONEIDENTITY;
    }
    function yy_r2_19($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_EQUALS;
    }
    function yy_r2_20($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_NOTEQUALS;
    }
    function yy_r2_22($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_GREATEREQUAL;
    }
    function yy_r2_24($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_LESSEQUAL;
    }
    function yy_r2_26($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_GREATERTHAN;
    }
    function yy_r2_27($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_LESSTHAN;
    }
    function yy_r2_28($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_MOD;
    }
    function yy_r2_29($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_NOT;
    }
    function yy_r2_30($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_LAND;
    }
    function yy_r2_31($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_LOR;
    }
    function yy_r2_32($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_LXOR;
    }
    function yy_r2_33($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_ISODDBY;
    }
    function yy_r2_34($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_ISNOTODDBY;
    }
    function yy_r2_35($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_ISODD;
    }
    function yy_r2_36($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_ISNOTODD;
    }
    function yy_r2_37($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_ISEVENBY;
    }
    function yy_r2_38($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_ISNOTEVENBY;
    }
    function yy_r2_39($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_ISEVEN;
    }
    function yy_r2_40($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_ISNOTEVEN;
    }
    function yy_r2_41($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_ISDIVBY;
    }
    function yy_r2_42($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_ISNOTDIVBY;
    }
    function yy_r2_43($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_TYPECAST;
    }
    function yy_r2_47($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_OPENP;
    }
    function yy_r2_48($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_CLOSEP;
    }
    function yy_r2_49($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_OPENB;
    }
    function yy_r2_50($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_CLOSEB;
    }
    function yy_r2_51($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_PTR;
    }
    function yy_r2_52($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_APTR;
    }
    function yy_r2_53($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_EQUAL;
    }
    function yy_r2_54($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_INCDEC;
    }
    function yy_r2_55($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_UNIMATH;
    }
    function yy_r2_57($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_MATH;
    }
    function yy_r2_59($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_DOLLAR;
    }
    function yy_r2_60($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_SEMICOLON;
    }
    function yy_r2_61($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_DOUBLECOLON;
    }
    function yy_r2_62($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_COLON;
    }
    function yy_r2_63($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_AT;
    }
    function yy_r2_64($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_HATCH;
    }
    function yy_r2_65($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_QUOTE;
  $this->yypushstate(self::DOUBLEQUOTEDSTRING);
    }
    function yy_r2_66($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_BACKTICK;
  $this->yypopstate();
    }
    function yy_r2_67($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_VERT;
    }
    function yy_r2_68($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_DOT;
    }
    function yy_r2_69($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_COMMA;
    }
    function yy_r2_70($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_ANDSYM;
    }
    function yy_r2_71($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_QMARK;
    }
    function yy_r2_72($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_HEX;
    }
    function yy_r2_73($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_ID;
    }
    function yy_r2_74($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_INTEGER;
    }
    function yy_r2_75($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_SPACE;
    }
    function yy_r2_76($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_OTHER;
    }



    function yylex3()
    {
        $tokenMap = array (
              1 => 0,
              2 => 0,
              3 => 0,
              4 => 0,
              5 => 0,
              6 => 0,
              7 => 0,
              8 => 2,
              11 => 0,
            );
        if ($this->counter >= strlen($this->data)) {
            return false; // end of input
        }
        $yy_global_pattern = "/\G(".$this->ldel."\\s*literal\\s*".$this->rdel.")|\G(".$this->ldel."\\s*\/literal\\s*".$this->rdel.")|\G([\t ]*[\r\n]+[\t ]*)|\G(<\\?(?:php\\w+|=|[a-zA-Z]+)?)|\G(\\?>)|\G(<%)|\G(%>)|\G(([\S\s]*?)(?=([\t ]*[\r\n]+[\t ]*|".$this->ldel."\/?literal".$this->rdel."|<\\?|<%)))|\G(.)/iS";

        do {
            if ($this->mbstring_overload ? preg_match($yy_global_pattern, substr($this->data, $this->counter), $yymatches) : preg_match($yy_global_pattern,$this->data, $yymatches, null, $this->counter)) {
                $yysubmatches = $yymatches;
                $yymatches = array_filter($yymatches, 'strlen'); // remove empty sub-patterns
                if (!count($yymatches)) {
                    throw new Exception('Error: lexing failed because a rule matched' .
                        ' an empty string.  Input "' . substr($this->data,
                        $this->counter, 5) . '... state LITERAL');
                }
                next($yymatches); // skip global match
                $this->token = key($yymatches); // token number
                if ($tokenMap[$this->token]) {
                    // extract sub-patterns for passing to lex function
                    $yysubmatches = array_slice($yysubmatches, $this->token + 1,
                        $tokenMap[$this->token]);
                } else {
                    $yysubmatches = array();
                }
                $this->value = current($yymatches); // token value
                $r = $this->{'yy_r3_' . $this->token}($yysubmatches);
                if ($r === null) {
                    $this->counter += strlen($this->value);
                    $this->line += substr_count($this->value, "\n");
                    // accept this token
                    return true;
                } elseif ($r === true) {
                    // we have changed state
                    // process this token in the new state
                    return $this->yylex();
                } elseif ($r === false) {
                    $this->counter += strlen($this->value);
                    $this->line += substr_count($this->value, "\n");
                    if ($this->counter >= strlen($this->data)) {
                        return false; // end of input
                    }
                    // skip this token
                    continue;
                }            } else {
                throw new Exception('Unexpected input at line' . $this->line .
                    ': ' . $this->data[$this->counter]);
            }
            break;
        } while (true);

    } // end function


    const LITERAL = 3;
    function yy_r3_1($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_LITERALSTART;
  $this->yypushstate(self::LITERAL);
    }
    function yy_r3_2($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_LITERALEND;
  $this->yypopstate();
    }
    function yy_r3_3($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_LITERAL;
    }
    function yy_r3_4($yy_subpatterns)
    {

  if (in_array($this->value, Array('<?', '<?=', '<?php'))) {
    $this->token = Smarty_Internal_Templateparser::TP_PHPSTARTTAG;
   } else {
    $this->token = Smarty_Internal_Templateparser::TP_FAKEPHPSTARTTAG;
    $this->value = substr($this->value, 0, 2);
   }
    }
    function yy_r3_5($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_PHPENDTAG;
    }
    function yy_r3_6($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_ASPSTARTTAG;
    }
    function yy_r3_7($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_ASPENDTAG;
    }
    function yy_r3_8($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_LITERAL;
    }
    function yy_r3_11($yy_subpatterns)
    {

  $this->compiler->trigger_template_error ("missing or misspelled literal closing tag");
    }


    function yylex4()
    {
        $tokenMap = array (
              1 => 0,
              2 => 1,
              4 => 0,
              5 => 0,
              6 => 0,
              7 => 0,
              8 => 0,
              9 => 0,
              10 => 0,
              11 => 0,
              12 => 0,
              13 => 3,
              17 => 0,
              18 => 0,
            );
        if ($this->counter >= strlen($this->data)) {
            return false; // end of input
        }
        $yy_global_pattern = "/\G(".$this->ldel."\\s{1,}\/)|\G(".$this->ldel."\\s*(if|elseif|else if|while)\\s+)|\G(".$this->ldel."\\s*for\\s+)|\G(".$this->ldel."\\s*foreach(?![^\s]))|\G(".$this->ldel."\\s{1,})|\G(".$this->ldel."\/)|\G(".$this->ldel.")|\G(\")|\G(`\\$)|\G(\\$[0-9]*[a-zA-Z_]\\w*)|\G(\\$)|\G(([^\"\\\\]*?)((?:\\\\.[^\"\\\\]*?)*?)(?=(".$this->ldel."|\\$|`\\$|\")))|\G([\S\s]+)|\G(.)/iS";

        do {
            if ($this->mbstring_overload ? preg_match($yy_global_pattern, substr($this->data, $this->counter), $yymatches) : preg_match($yy_global_pattern,$this->data, $yymatches, null, $this->counter)) {
                $yysubmatches = $yymatches;
                $yymatches = array_filter($yymatches, 'strlen'); // remove empty sub-patterns
                if (!count($yymatches)) {
                    throw new Exception('Error: lexing failed because a rule matched' .
                        ' an empty string.  Input "' . substr($this->data,
                        $this->counter, 5) . '... state DOUBLEQUOTEDSTRING');
                }
                next($yymatches); // skip global match
                $this->token = key($yymatches); // token number
                if ($tokenMap[$this->token]) {
                    // extract sub-patterns for passing to lex function
                    $yysubmatches = array_slice($yysubmatches, $this->token + 1,
                        $tokenMap[$this->token]);
                } else {
                    $yysubmatches = array();
                }
                $this->value = current($yymatches); // token value
                $r = $this->{'yy_r4_' . $this->token}($yysubmatches);
                if ($r === null) {
                    $this->counter += strlen($this->value);
                    $this->line += substr_count($this->value, "\n");
                    // accept this token
                    return true;
                } elseif ($r === true) {
                    // we have changed state
                    // process this token in the new state
                    return $this->yylex();
                } elseif ($r === false) {
                    $this->counter += strlen($this->value);
                    $this->line += substr_count($this->value, "\n");
                    if ($this->counter >= strlen($this->data)) {
                        return false; // end of input
                    }
                    // skip this token
                    continue;
                }            } else {
                throw new Exception('Unexpected input at line' . $this->line .
                    ': ' . $this->data[$this->counter]);
            }
            break;
        } while (true);

    } // end function


    const DOUBLEQUOTEDSTRING = 4;
    function yy_r4_1($yy_subpatterns)
    {

  if ($this->smarty->auto_literal) {
     $this->token = Smarty_Internal_Templateparser::TP_OTHER;
  } else {
     $this->token = Smarty_Internal_Templateparser::TP_LDELSLASH;
     $this->yypushstate(self::SMARTY);
     $this->taglineno = $this->line;
  }
    }
    function yy_r4_2($yy_subpatterns)
    {

  if ($this->smarty->auto_literal && trim(substr($this->value,$this->ldel_length,1)) == '') {
     $this->token = Smarty_Internal_Templateparser::TP_OTHER;
  } else {
     $this->token = Smarty_Internal_Templateparser::TP_LDELIF;
     $this->yypushstate(self::SMARTY);
     $this->taglineno = $this->line;
  }
    }
    function yy_r4_4($yy_subpatterns)
    {

  if ($this->smarty->auto_literal && trim(substr($this->value,$this->ldel_length,1)) == '') {
     $this->token = Smarty_Internal_Templateparser::TP_OTHER;
  } else {
     $this->token = Smarty_Internal_Templateparser::TP_LDELFOR;
     $this->yypushstate(self::SMARTY);
     $this->taglineno = $this->line;
  }
    }
    function yy_r4_5($yy_subpatterns)
    {

  if ($this->smarty->auto_literal && trim(substr($this->value,$this->ldel_length,1)) == '') {
     $this->token = Smarty_Internal_Templateparser::TP_OTHER;
  } else {
     $this->token = Smarty_Internal_Templateparser::TP_LDELFOREACH;
     $this->yypushstate(self::SMARTY);
     $this->taglineno = $this->line;
  }
    }
    function yy_r4_6($yy_subpatterns)
    {

  if ($this->smarty->auto_literal) {
     $this->token = Smarty_Internal_Templateparser::TP_OTHER;
  } else {
     $this->token = Smarty_Internal_Templateparser::TP_LDEL;
     $this->yypushstate(self::SMARTY);
     $this->taglineno = $this->line;
  }
    }
    function yy_r4_7($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_LDELSLASH;
     $this->yypushstate(self::SMARTY);
     $this->taglineno = $this->line;
    }
    function yy_r4_8($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_LDEL;
     $this->yypushstate(self::SMARTY);
     $this->taglineno = $this->line;
    }
    function yy_r4_9($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_QUOTE;
  $this->yypopstate();
    }
    function yy_r4_10($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_BACKTICK;
  $this->value = substr($this->value,0,-1);
  $this->yypushstate(self::SMARTY);
  $this->taglineno = $this->line;
    }
    function yy_r4_11($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_DOLLARID;
    }
    function yy_r4_12($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_OTHER;
    }
    function yy_r4_13($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_OTHER;
    }
    function yy_r4_17($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_OTHER;
    }
    function yy_r4_18($yy_subpatterns)
    {

  $this->token = Smarty_Internal_Templateparser::TP_OTHER;
    }

}
?><?php
/**
 * Smarty Internal Plugin Compile Registered Function
 *
 * Compiles code for the execution of a registered function
 *
 * @package Smarty
 * @subpackage Compiler
 * @author Uwe Tews
 */

/**
 * Smarty Internal Plugin Compile Registered Function Class
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_Private_Registered_Function extends Smarty_Internal_CompileBase {

    /**
     * Attribute definition: Overwrites base class.
     *
     * @var array
     * @see Smarty_Internal_CompileBase
     */
    public $optional_attributes = array('_any');

    /**
     * Compiles code for the execution of a registered function
     *
     * @param array  $args      array with attributes from parser
     * @param object $compiler  compiler object
     * @param array  $parameter array with compilation parameter
     * @param string $tag       name of function
     * @return string compiled code
     */
    public function compile($args, $compiler, $parameter, $tag)
    {
        // This tag does create output
        $compiler->has_output = true;
        // check and get attributes
        $_attr = $this->getAttributes($compiler, $args);
        if ($_attr['nocache']) {
            $compiler->tag_nocache = true;
        }
        unset($_attr['nocache']);
               if (isset($compiler->smarty->registered_plugins[Smarty::PLUGIN_FUNCTION][$tag])) {
                   $tag_info = $compiler->smarty->registered_plugins[Smarty::PLUGIN_FUNCTION][$tag];
               } else {
                   $tag_info = $compiler->default_handler_plugins[Smarty::PLUGIN_FUNCTION][$tag];
               }
        // not cachable?
        $compiler->tag_nocache =  $compiler->tag_nocache || !$tag_info[1];
        // convert attributes into parameter array string
        $_paramsArray = array();
        foreach ($_attr as $_key => $_value) {
            if (is_int($_key)) {
                $_paramsArray[] = "$_key=>$_value";
            } elseif ($compiler->template->caching && in_array($_key,$tag_info[2])) {
                $_value = str_replace("'","^#^",$_value);
                $_paramsArray[] = "'$_key'=>^#^.var_export($_value,true).^#^";
            } else {
                $_paramsArray[] = "'$_key'=>$_value";
            }
        }
        $_params = 'array(' . implode(",", $_paramsArray) . ')';
        $function = $tag_info[0];
        // compile code
        if (!is_array($function)) {
            $output = "<?php echo {$function}({$_params},\$_smarty_tpl);?>\n";
        } else if (is_object($function[0])) {
            $output = "<?php echo \$_smarty_tpl->smarty->registered_plugins[Smarty::PLUGIN_FUNCTION]['{$tag}'][0][0]->{$function[1]}({$_params},\$_smarty_tpl);?>\n";
        } else {
            $output = "<?php echo {$function[0]}::{$function[1]}({$_params},\$_smarty_tpl);?>\n";
        }
        return $output;
    }

}

?><?php
/**
* Smarty Internal Plugin Configfileparser
*
* This is the config file parser.
* It is generated from the internal.configfileparser.y file
* @package Smarty
* @subpackage Compiler
* @author Uwe Tews
*/

class TPC_yyToken implements ArrayAccess
{
    public $string = '';
    public $metadata = array();

    function __construct($s, $m = array())
    {
        if ($s instanceof TPC_yyToken) {
            $this->string = $s->string;
            $this->metadata = $s->metadata;
        } else {
            $this->string = (string) $s;
            if ($m instanceof TPC_yyToken) {
                $this->metadata = $m->metadata;
            } elseif (is_array($m)) {
                $this->metadata = $m;
            }
        }
    }

    function __toString()
    {
        return $this->_string;
    }

    function offsetExists($offset)
    {
        return isset($this->metadata[$offset]);
    }

    function offsetGet($offset)
    {
        return $this->metadata[$offset];
    }

    function offsetSet($offset, $value)
    {
        if ($offset === null) {
            if (isset($value[0])) {
                $x = ($value instanceof TPC_yyToken) ?
                    $value->metadata : $value;
                $this->metadata = array_merge($this->metadata, $x);
                return;
            }
            $offset = count($this->metadata);
        }
        if ($value === null) {
            return;
        }
        if ($value instanceof TPC_yyToken) {
            if ($value->metadata) {
                $this->metadata[$offset] = $value->metadata;
            }
        } elseif ($value) {
            $this->metadata[$offset] = $value;
        }
    }

    function offsetUnset($offset)
    {
        unset($this->metadata[$offset]);
    }
}

class TPC_yyStackEntry
{
    public $stateno;       /* The state-number */
    public $major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
    public $minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};


#line 12 "smarty_internal_configfileparser.y"
class Smarty_Internal_Configfileparser#line 79 "smarty_internal_configfileparser.php"
{
#line 14 "smarty_internal_configfileparser.y"

    // states whether the parse was successful or not
    public $successful = true;
    public $retvalue = 0;
    private $lex;
    private $internalError = false;

    function __construct($lex, $compiler) {
        // set instance object
        self::instance($this);
        $this->lex = $lex;
        $this->smarty = $compiler->smarty;
        $this->compiler = $compiler;
    }
    public static function &instance($new_instance = null)
    {
        static $instance = null;
        if (isset($new_instance) && is_object($new_instance))
            $instance = $new_instance;
        return $instance;
    }

    private function parse_bool($str) {
        if (in_array(strtolower($str) ,array('on','yes','true'))) {
            $res = true;
        } else {
            $res = false;
        }
        return $res;
    }

    private static $escapes_single = Array('\\' => '\\',
                                          '\'' => '\'');
    private static function parse_single_quoted_string($qstr) {
        $escaped_string = substr($qstr, 1, strlen($qstr)-2); //remove outer quotes

        $ss = preg_split('/(\\\\.)/', $escaped_string, -1, PREG_SPLIT_DELIM_CAPTURE);

        $str = "";
        foreach ($ss as $s) {
            if (strlen($s) === 2 && $s[0] === '\\') {
                if (isset(self::$escapes_single[$s[1]])) {
                    $s = self::$escapes_single[$s[1]];
                }
             }

             $str .= $s;
        }

        return $str;
    }

    private static function parse_double_quoted_string($qstr) {
        $inner_str = substr($qstr, 1, strlen($qstr)-2);
        return stripcslashes($inner_str);
    }

    private static function parse_tripple_double_quoted_string($qstr) {
        $inner_str = substr($qstr, 3, strlen($qstr)-6);
        return stripcslashes($inner_str);
    }

    private function set_var(Array $var, Array &$target_array) {
        $key = $var["key"];
        $value = $var["value"];

        if ($this->smarty->config_overwrite || !isset($target_array['vars'][$key])) {
            $target_array['vars'][$key] = $value;
        } else {
            settype($target_array['vars'][$key], 'array');
            $target_array['vars'][$key][] = $value;
        }
    }

    private function add_global_vars(Array $vars) {
        if (!isset($this->compiler->config_data['vars'])) {
      $this->compiler->config_data['vars'] = Array();
        }
        foreach ($vars as $var) {
            $this->set_var($var, $this->compiler->config_data);
        }
    }

    private function add_section_vars($section_name, Array $vars) {
        if (!isset($this->compiler->config_data['sections'][$section_name]['vars'])) {
            $this->compiler->config_data['sections'][$section_name]['vars'] = Array();
        }
        foreach ($vars as $var) {
            $this->set_var($var, $this->compiler->config_data['sections'][$section_name]);
        }
    }
#line 174 "smarty_internal_configfileparser.php"

    const TPC_OPENB                          =  1;
    const TPC_SECTION                        =  2;
    const TPC_CLOSEB                         =  3;
    const TPC_DOT                            =  4;
    const TPC_ID                             =  5;
    const TPC_EQUAL                          =  6;
    const TPC_FLOAT                          =  7;
    const TPC_INT                            =  8;
    const TPC_BOOL                           =  9;
    const TPC_SINGLE_QUOTED_STRING           = 10;
    const TPC_DOUBLE_QUOTED_STRING           = 11;
    const TPC_TRIPPLE_DOUBLE_QUOTED_STRING   = 12;
    const TPC_NAKED_STRING                   = 13;
    const TPC_NEWLINE                        = 14;
    const TPC_COMMENTSTART                   = 15;
    const YY_NO_ACTION = 54;
    const YY_ACCEPT_ACTION = 53;
    const YY_ERROR_ACTION = 52;

    const YY_SZ_ACTTAB = 35;
static public $yy_action = array(
 /*     0 */    26,   27,   21,   30,   29,   28,   31,   16,   53,    8,
 /*    10 */    19,    2,   20,   11,   24,   23,   20,   11,   17,   15,
 /*    20 */     3,   14,   13,   18,    4,    6,    5,    1,   12,   22,
 /*    30 */     9,   47,   10,   25,    7,
    );
    static public $yy_lookahead = array(
 /*     0 */     7,    8,    9,   10,   11,   12,   13,    5,   17,   18,
 /*    10 */    14,   20,   14,   15,   22,   23,   14,   15,    2,    2,
 /*    20 */    20,    4,   13,   14,    6,    3,    3,   20,    1,   24,
 /*    30 */    22,   25,   22,   21,   19,
);
    const YY_SHIFT_USE_DFLT = -8;
    const YY_SHIFT_MAX = 17;
    static public $yy_shift_ofst = array(
 /*     0 */    -8,    2,    2,    2,   -7,   -2,   -2,   27,   -8,   -8,
 /*    10 */    -8,    9,   17,   -4,   16,   23,   18,   22,
);
    const YY_REDUCE_USE_DFLT = -10;
    const YY_REDUCE_MAX = 10;
    static public $yy_reduce_ofst = array(
 /*     0 */    -9,   -8,   -8,   -8,    5,   10,    8,   12,   15,    0,
 /*    10 */     7,
);
    static public $yyExpectedTokens = array(
        /* 0 */ array(),
        /* 1 */ array(5, 14, 15, ),
        /* 2 */ array(5, 14, 15, ),
        /* 3 */ array(5, 14, 15, ),
        /* 4 */ array(7, 8, 9, 10, 11, 12, 13, ),
        /* 5 */ array(14, 15, ),
        /* 6 */ array(14, 15, ),
        /* 7 */ array(1, ),
        /* 8 */ array(),
        /* 9 */ array(),
        /* 10 */ array(),
        /* 11 */ array(13, 14, ),
        /* 12 */ array(2, 4, ),
        /* 13 */ array(14, ),
        /* 14 */ array(2, ),
        /* 15 */ array(3, ),
        /* 16 */ array(6, ),
        /* 17 */ array(3, ),
        /* 18 */ array(),
        /* 19 */ array(),
        /* 20 */ array(),
        /* 21 */ array(),
        /* 22 */ array(),
        /* 23 */ array(),
        /* 24 */ array(),
        /* 25 */ array(),
        /* 26 */ array(),
        /* 27 */ array(),
        /* 28 */ array(),
        /* 29 */ array(),
        /* 30 */ array(),
        /* 31 */ array(),
);
    static public $yy_default = array(
 /*     0 */    40,   36,   33,   37,   52,   52,   52,   32,   35,   40,
 /*    10 */    40,   52,   52,   52,   52,   52,   52,   52,   50,   51,
 /*    20 */    49,   44,   41,   39,   38,   34,   42,   43,   47,   46,
 /*    30 */    45,   48,
);
    const YYNOCODE = 26;
    const YYSTACKDEPTH = 100;
    const YYNSTATE = 32;
    const YYNRULE = 20;
    const YYERRORSYMBOL = 16;
    const YYERRSYMDT = 'yy0';
    const YYFALLBACK = 0;
    static public $yyFallback = array(
    );
    static function Trace($TraceFILE, $zTracePrompt)
    {
        if (!$TraceFILE) {
            $zTracePrompt = 0;
        } elseif (!$zTracePrompt) {
            $TraceFILE = 0;
        }
        self::$yyTraceFILE = $TraceFILE;
        self::$yyTracePrompt = $zTracePrompt;
    }

    static function PrintTrace()
    {
        self::$yyTraceFILE = fopen('php://output', 'w');
        self::$yyTracePrompt = '<br>';
    }

    static public $yyTraceFILE;
    static public $yyTracePrompt;
    public $yyidx;                    /* Index of top element in stack */
    public $yyerrcnt;                 /* Shifts left before out of the error */
    public $yystack = array();  /* The parser's stack */

    public $yyTokenName = array(
  '$',             'OPENB',         'SECTION',       'CLOSEB',
  'DOT',           'ID',            'EQUAL',         'FLOAT',
  'INT',           'BOOL',          'SINGLE_QUOTED_STRING',  'DOUBLE_QUOTED_STRING',
  'TRIPPLE_DOUBLE_QUOTED_STRING',  'NAKED_STRING',  'NEWLINE',       'COMMENTSTART',
  'error',         'start',         'global_vars',   'sections',
  'var_list',      'section',       'newline',       'var',
  'value',
    );

    static public $yyRuleName = array(
 /*   0 */ "start ::= global_vars sections",
 /*   1 */ "global_vars ::= var_list",
 /*   2 */ "sections ::= sections section",
 /*   3 */ "sections ::=",
 /*   4 */ "section ::= OPENB SECTION CLOSEB newline var_list",
 /*   5 */ "section ::= OPENB DOT SECTION CLOSEB newline var_list",
 /*   6 */ "var_list ::= var_list newline",
 /*   7 */ "var_list ::= var_list var",
 /*   8 */ "var_list ::=",
 /*   9 */ "var ::= ID EQUAL value",
 /*  10 */ "value ::= FLOAT",
 /*  11 */ "value ::= INT",
 /*  12 */ "value ::= BOOL",
 /*  13 */ "value ::= SINGLE_QUOTED_STRING",
 /*  14 */ "value ::= DOUBLE_QUOTED_STRING",
 /*  15 */ "value ::= TRIPPLE_DOUBLE_QUOTED_STRING",
 /*  16 */ "value ::= NAKED_STRING",
 /*  17 */ "newline ::= NEWLINE",
 /*  18 */ "newline ::= COMMENTSTART NEWLINE",
 /*  19 */ "newline ::= COMMENTSTART NAKED_STRING NEWLINE",
    );

    function tokenName($tokenType)
    {
        if ($tokenType === 0) {
            return 'End of Input';
        }
        if ($tokenType > 0 && $tokenType < count($this->yyTokenName)) {
            return $this->yyTokenName[$tokenType];
        } else {
            return "Unknown";
        }
    }

    static function yy_destructor($yymajor, $yypminor)
    {
        switch ($yymajor) {
            default:  break;   /* If no destructor action specified: do nothing */
        }
    }

    function yy_pop_parser_stack()
    {
        if (!count($this->yystack)) {
            return;
        }
        $yytos = array_pop($this->yystack);
        if (self::$yyTraceFILE && $this->yyidx >= 0) {
            fwrite(self::$yyTraceFILE,
                self::$yyTracePrompt . 'Popping ' . $this->yyTokenName[$yytos->major] .
                    "\n");
        }
        $yymajor = $yytos->major;
        self::yy_destructor($yymajor, $yytos->minor);
        $this->yyidx--;
        return $yymajor;
    }

    function __destruct()
    {
        while ($this->yystack !== Array()) {
            $this->yy_pop_parser_stack();
        }
        if (is_resource(self::$yyTraceFILE)) {
            fclose(self::$yyTraceFILE);
        }
    }

    function yy_get_expected_tokens($token)
    {
        $state = $this->yystack[$this->yyidx]->stateno;
        $expected = self::$yyExpectedTokens[$state];
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return $expected;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return array_unique($expected);
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate])) {
		        $expected = array_merge($expected, self::$yyExpectedTokens[$nextstate]);
                            if (in_array($token,
                                  self::$yyExpectedTokens[$nextstate], true)) {
                            $this->yyidx = $yyidx;
                            $this->yystack = $stack;
                            return array_unique($expected);
                        }
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new TPC_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return array_unique($expected);
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return $expected;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
	$this->yyidx = $yyidx;
	$this->yystack = $stack;
        return array_unique($expected);
    }

    function yy_is_expected_token($token)
    {
        if ($token === 0) {
            return true; // 0 is not part of this
        }
        $state = $this->yystack[$this->yyidx]->stateno;
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return true;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return true;
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate]) &&
                          in_array($token, self::$yyExpectedTokens[$nextstate], true)) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        return true;
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new TPC_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        if (!$token) {
                            // end of input: this is valid
                            return true;
                        }
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return false;
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return true;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
        $this->yyidx = $yyidx;
        $this->yystack = $stack;
        return true;
    }

   function yy_find_shift_action($iLookAhead)
    {
        $stateno = $this->yystack[$this->yyidx]->stateno;

        /* if ($this->yyidx < 0) return self::YY_NO_ACTION;  */
        if (!isset(self::$yy_shift_ofst[$stateno])) {
            // no shift actions
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_shift_ofst[$stateno];
        if ($i === self::YY_SHIFT_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            if (count(self::$yyFallback) && $iLookAhead < count(self::$yyFallback)
                   && ($iFallback = self::$yyFallback[$iLookAhead]) != 0) {
                if (self::$yyTraceFILE) {
                    fwrite(self::$yyTraceFILE, self::$yyTracePrompt . "FALLBACK " .
                        $this->yyTokenName[$iLookAhead] . " => " .
                        $this->yyTokenName[$iFallback] . "\n");
                }
                return $this->yy_find_shift_action($iFallback);
            }
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    function yy_find_reduce_action($stateno, $iLookAhead)
    {
        /* $stateno = $this->yystack[$this->yyidx]->stateno; */

        if (!isset(self::$yy_reduce_ofst[$stateno])) {
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_reduce_ofst[$stateno];
        if ($i == self::YY_REDUCE_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    function yy_shift($yyNewState, $yyMajor, $yypMinor)
    {
        $this->yyidx++;
        if ($this->yyidx >= self::YYSTACKDEPTH) {
            $this->yyidx--;
            if (self::$yyTraceFILE) {
                fprintf(self::$yyTraceFILE, "%sStack Overflow!\n", self::$yyTracePrompt);
            }
            while ($this->yyidx >= 0) {
                $this->yy_pop_parser_stack();
            }
#line 126 "smarty_internal_configfileparser.y"

    $this->internalError = true;
    $this->compiler->trigger_config_file_error("Stack overflow in configfile parser");
#line 585 "smarty_internal_configfileparser.php"
            return;
        }
        $yytos = new TPC_yyStackEntry;
        $yytos->stateno = $yyNewState;
        $yytos->major = $yyMajor;
        $yytos->minor = $yypMinor;
        array_push($this->yystack, $yytos);
        if (self::$yyTraceFILE && $this->yyidx > 0) {
            fprintf(self::$yyTraceFILE, "%sShift %d\n", self::$yyTracePrompt,
                $yyNewState);
            fprintf(self::$yyTraceFILE, "%sStack:", self::$yyTracePrompt);
            for($i = 1; $i <= $this->yyidx; $i++) {
                fprintf(self::$yyTraceFILE, " %s",
                    $this->yyTokenName[$this->yystack[$i]->major]);
            }
            fwrite(self::$yyTraceFILE,"\n");
        }
    }

    static public $yyRuleInfo = array(
  array( 'lhs' => 17, 'rhs' => 2 ),
  array( 'lhs' => 18, 'rhs' => 1 ),
  array( 'lhs' => 19, 'rhs' => 2 ),
  array( 'lhs' => 19, 'rhs' => 0 ),
  array( 'lhs' => 21, 'rhs' => 5 ),
  array( 'lhs' => 21, 'rhs' => 6 ),
  array( 'lhs' => 20, 'rhs' => 2 ),
  array( 'lhs' => 20, 'rhs' => 2 ),
  array( 'lhs' => 20, 'rhs' => 0 ),
  array( 'lhs' => 23, 'rhs' => 3 ),
  array( 'lhs' => 24, 'rhs' => 1 ),
  array( 'lhs' => 24, 'rhs' => 1 ),
  array( 'lhs' => 24, 'rhs' => 1 ),
  array( 'lhs' => 24, 'rhs' => 1 ),
  array( 'lhs' => 24, 'rhs' => 1 ),
  array( 'lhs' => 24, 'rhs' => 1 ),
  array( 'lhs' => 24, 'rhs' => 1 ),
  array( 'lhs' => 22, 'rhs' => 1 ),
  array( 'lhs' => 22, 'rhs' => 2 ),
  array( 'lhs' => 22, 'rhs' => 3 ),
    );

    static public $yyReduceMap = array(
        0 => 0,
        2 => 0,
        3 => 0,
        17 => 0,
        18 => 0,
        19 => 0,
        1 => 1,
        4 => 4,
        5 => 5,
        6 => 6,
        7 => 7,
        8 => 8,
        9 => 9,
        10 => 10,
        11 => 11,
        12 => 12,
        13 => 13,
        14 => 14,
        15 => 15,
        16 => 16,
    );
#line 132 "smarty_internal_configfileparser.y"
    function yy_r0(){
    $this->_retvalue = null;
    }
#line 654 "smarty_internal_configfileparser.php"
#line 137 "smarty_internal_configfileparser.y"
    function yy_r1(){
    $this->add_global_vars($this->yystack[$this->yyidx + 0]->minor); $this->_retvalue = null;
    }
#line 659 "smarty_internal_configfileparser.php"
#line 150 "smarty_internal_configfileparser.y"
    function yy_r4(){
    $this->add_section_vars($this->yystack[$this->yyidx + -3]->minor, $this->yystack[$this->yyidx + 0]->minor);
    $this->_retvalue = null;
    }
#line 665 "smarty_internal_configfileparser.php"
#line 155 "smarty_internal_configfileparser.y"
    function yy_r5(){
    if ($this->smarty->config_read_hidden) {
        $this->add_section_vars($this->yystack[$this->yyidx + -3]->minor, $this->yystack[$this->yyidx + 0]->minor);
    }
    $this->_retvalue = null;
    }
#line 673 "smarty_internal_configfileparser.php"
#line 163 "smarty_internal_configfileparser.y"
    function yy_r6(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;
    }
#line 678 "smarty_internal_configfileparser.php"
#line 167 "smarty_internal_configfileparser.y"
    function yy_r7(){
    $this->_retvalue = array_merge($this->yystack[$this->yyidx + -1]->minor, Array($this->yystack[$this->yyidx + 0]->minor));
    }
#line 683 "smarty_internal_configfileparser.php"
#line 171 "smarty_internal_configfileparser.y"
    function yy_r8(){
    $this->_retvalue = Array();
    }
#line 688 "smarty_internal_configfileparser.php"
#line 177 "smarty_internal_configfileparser.y"
    function yy_r9(){
    $this->_retvalue = Array("key" => $this->yystack[$this->yyidx + -2]->minor, "value" => $this->yystack[$this->yyidx + 0]->minor);
    }
#line 693 "smarty_internal_configfileparser.php"
#line 182 "smarty_internal_configfileparser.y"
    function yy_r10(){
    $this->_retvalue = (float) $this->yystack[$this->yyidx + 0]->minor;
    }
#line 698 "smarty_internal_configfileparser.php"
#line 186 "smarty_internal_configfileparser.y"
    function yy_r11(){
    $this->_retvalue = (int) $this->yystack[$this->yyidx + 0]->minor;
    }
#line 703 "smarty_internal_configfileparser.php"
#line 190 "smarty_internal_configfileparser.y"
    function yy_r12(){
    $this->_retvalue = $this->parse_bool($this->yystack[$this->yyidx + 0]->minor);
    }
#line 708 "smarty_internal_configfileparser.php"
#line 194 "smarty_internal_configfileparser.y"
    function yy_r13(){
    $this->_retvalue = self::parse_single_quoted_string($this->yystack[$this->yyidx + 0]->minor);
    }
#line 713 "smarty_internal_configfileparser.php"
#line 198 "smarty_internal_configfileparser.y"
    function yy_r14(){
    $this->_retvalue = self::parse_double_quoted_string($this->yystack[$this->yyidx + 0]->minor);
    }
#line 718 "smarty_internal_configfileparser.php"
#line 202 "smarty_internal_configfileparser.y"
    function yy_r15(){
    $this->_retvalue = self::parse_tripple_double_quoted_string($this->yystack[$this->yyidx + 0]->minor);
    }
#line 723 "smarty_internal_configfileparser.php"
#line 206 "smarty_internal_configfileparser.y"
    function yy_r16(){
    $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 728 "smarty_internal_configfileparser.php"

    private $_retvalue;

    function yy_reduce($yyruleno)
    {
        $yymsp = $this->yystack[$this->yyidx];
        if (self::$yyTraceFILE && $yyruleno >= 0
              && $yyruleno < count(self::$yyRuleName)) {
            fprintf(self::$yyTraceFILE, "%sReduce (%d) [%s].\n",
                self::$yyTracePrompt, $yyruleno,
                self::$yyRuleName[$yyruleno]);
        }

        $this->_retvalue = $yy_lefthand_side = null;
        if (array_key_exists($yyruleno, self::$yyReduceMap)) {
            // call the action
            $this->_retvalue = null;
            $this->{'yy_r' . self::$yyReduceMap[$yyruleno]}();
            $yy_lefthand_side = $this->_retvalue;
        }
        $yygoto = self::$yyRuleInfo[$yyruleno]['lhs'];
        $yysize = self::$yyRuleInfo[$yyruleno]['rhs'];
        $this->yyidx -= $yysize;
        for($i = $yysize; $i; $i--) {
            // pop all of the right-hand side parameters
            array_pop($this->yystack);
        }
        $yyact = $this->yy_find_reduce_action($this->yystack[$this->yyidx]->stateno, $yygoto);
        if ($yyact < self::YYNSTATE) {
            if (!self::$yyTraceFILE && $yysize) {
                $this->yyidx++;
                $x = new TPC_yyStackEntry;
                $x->stateno = $yyact;
                $x->major = $yygoto;
                $x->minor = $yy_lefthand_side;
                $this->yystack[$this->yyidx] = $x;
            } else {
                $this->yy_shift($yyact, $yygoto, $yy_lefthand_side);
            }
        } elseif ($yyact == self::YYNSTATE + self::YYNRULE + 1) {
            $this->yy_accept();
        }
    }

    function yy_parse_failed()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sFail!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
    }

    function yy_syntax_error($yymajor, $TOKEN)
    {
#line 119 "smarty_internal_configfileparser.y"

    $this->internalError = true;
    $this->yymajor = $yymajor;
    $this->compiler->trigger_config_file_error();
#line 791 "smarty_internal_configfileparser.php"
    }

    function yy_accept()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sAccept!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $stack = $this->yy_pop_parser_stack();
        }
#line 111 "smarty_internal_configfileparser.y"

    $this->successful = !$this->internalError;
    $this->internalError = false;
    $this->retvalue = $this->_retvalue;
    //echo $this->retvalue."\n\n";
#line 809 "smarty_internal_configfileparser.php"
    }

    function doParse($yymajor, $yytokenvalue)
    {
        $yyerrorhit = 0;   /* True if yymajor has invoked an error */

        if ($this->yyidx === null || $this->yyidx < 0) {
            $this->yyidx = 0;
            $this->yyerrcnt = -1;
            $x = new TPC_yyStackEntry;
            $x->stateno = 0;
            $x->major = 0;
            $this->yystack = array();
            array_push($this->yystack, $x);
        }
        $yyendofinput = ($yymajor==0);

        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sInput %s\n",
                self::$yyTracePrompt, $this->yyTokenName[$yymajor]);
        }

        do {
            $yyact = $this->yy_find_shift_action($yymajor);
            if ($yymajor < self::YYERRORSYMBOL &&
                  !$this->yy_is_expected_token($yymajor)) {
                // force a syntax error
                $yyact = self::YY_ERROR_ACTION;
            }
            if ($yyact < self::YYNSTATE) {
                $this->yy_shift($yyact, $yymajor, $yytokenvalue);
                $this->yyerrcnt--;
                if ($yyendofinput && $this->yyidx >= 0) {
                    $yymajor = 0;
                } else {
                    $yymajor = self::YYNOCODE;
                }
            } elseif ($yyact < self::YYNSTATE + self::YYNRULE) {
                $this->yy_reduce($yyact - self::YYNSTATE);
            } elseif ($yyact == self::YY_ERROR_ACTION) {
                if (self::$yyTraceFILE) {
                    fprintf(self::$yyTraceFILE, "%sSyntax Error!\n",
                        self::$yyTracePrompt);
                }
                if (self::YYERRORSYMBOL) {
                    if ($this->yyerrcnt < 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $yymx = $this->yystack[$this->yyidx]->major;
                    if ($yymx == self::YYERRORSYMBOL || $yyerrorhit ){
                        if (self::$yyTraceFILE) {
                            fprintf(self::$yyTraceFILE, "%sDiscard input token %s\n",
                                self::$yyTracePrompt, $this->yyTokenName[$yymajor]);
                        }
                        $this->yy_destructor($yymajor, $yytokenvalue);
                        $yymajor = self::YYNOCODE;
                    } else {
                        while ($this->yyidx >= 0 &&
                                 $yymx != self::YYERRORSYMBOL &&
        ($yyact = $this->yy_find_shift_action(self::YYERRORSYMBOL)) >= self::YYNSTATE
                              ){
                            $this->yy_pop_parser_stack();
                        }
                        if ($this->yyidx < 0 || $yymajor==0) {
                            $this->yy_destructor($yymajor, $yytokenvalue);
                            $this->yy_parse_failed();
                            $yymajor = self::YYNOCODE;
                        } elseif ($yymx != self::YYERRORSYMBOL) {
                            $u2 = 0;
                            $this->yy_shift($yyact, self::YYERRORSYMBOL, $u2);
                        }
                    }
                    $this->yyerrcnt = 3;
                    $yyerrorhit = 1;
                } else {
                    if ($this->yyerrcnt <= 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $this->yyerrcnt = 3;
                    $this->yy_destructor($yymajor, $yytokenvalue);
                    if ($yyendofinput) {
                        $this->yy_parse_failed();
                    }
                    $yymajor = self::YYNOCODE;
                }
            } else {
                $this->yy_accept();
                $yymajor = self::YYNOCODE;
            }
        } while ($yymajor != self::YYNOCODE && $this->yyidx >= 0);
    }
}
?><?php
/**
 * Smarty Internal Plugin Compile For
 *
 * Compiles the {for} {forelse} {/for} tags
 *
 * @package Smarty
 * @subpackage Compiler
 * @author Uwe Tews
 */

/**
 * Smarty Internal Plugin Compile For Class
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_For extends Smarty_Internal_CompileBase {

    /**
     * Compiles code for the {for} tag
     *
     * Smarty 3 does implement two different sytaxes:
     *
     * - {for $var in $array}
     * For looping over arrays or iterators
     *
     * - {for $x=0; $x<$y; $x++}
     * For general loops
     *
     * The parser is gereration different sets of attribute by which this compiler can
     * determin which syntax is used.
     *
     * @param array  $args      array with attributes from parser
     * @param object $compiler  compiler object
     * @param array  $parameter array with compilation parameter
     * @return string compiled code
     */
    public function compile($args, $compiler, $parameter)
    {
        if ($parameter == 0) {
            $this->required_attributes = array('start', 'to');
            $this->optional_attributes = array('max', 'step');
        } else {
            $this->required_attributes = array('start', 'ifexp', 'var', 'step');
            $this->optional_attributes = array();
        }
        // check and get attributes
        $_attr = $this->getAttributes($compiler, $args);

        $output = "<?php ";
        if ($parameter == 1) {
            foreach ($_attr['start'] as $_statement) {
                $output .= " \$_smarty_tpl->tpl_vars[$_statement[var]] = new Smarty_Variable;";
                $output .= " \$_smarty_tpl->tpl_vars[$_statement[var]]->value = $_statement[value];\n";
            }
            $output .= "  if ($_attr[ifexp]){ for (\$_foo=true;$_attr[ifexp]; \$_smarty_tpl->tpl_vars[$_attr[var]]->value$_attr[step]){\n";
        } else {
            $_statement = $_attr['start'];
            $output .= "\$_smarty_tpl->tpl_vars[$_statement[var]] = new Smarty_Variable;";
            if (isset($_attr['step'])) {
                $output .= "\$_smarty_tpl->tpl_vars[$_statement[var]]->step = $_attr[step];";
            } else {
                $output .= "\$_smarty_tpl->tpl_vars[$_statement[var]]->step = 1;";
            }
            if (isset($_attr['max'])) {
                $output .= "\$_smarty_tpl->tpl_vars[$_statement[var]]->total = (int)min(ceil((\$_smarty_tpl->tpl_vars[$_statement[var]]->step > 0 ? $_attr[to]+1 - ($_statement[value]) : $_statement[value]-($_attr[to])+1)/abs(\$_smarty_tpl->tpl_vars[$_statement[var]]->step)),$_attr[max]);\n";
            } else {
                $output .= "\$_smarty_tpl->tpl_vars[$_statement[var]]->total = (int)ceil((\$_smarty_tpl->tpl_vars[$_statement[var]]->step > 0 ? $_attr[to]+1 - ($_statement[value]) : $_statement[value]-($_attr[to])+1)/abs(\$_smarty_tpl->tpl_vars[$_statement[var]]->step));\n";
            }
            $output .= "if (\$_smarty_tpl->tpl_vars[$_statement[var]]->total > 0){\n";
            $output .= "for (\$_smarty_tpl->tpl_vars[$_statement[var]]->value = $_statement[value], \$_smarty_tpl->tpl_vars[$_statement[var]]->iteration = 1;\$_smarty_tpl->tpl_vars[$_statement[var]]->iteration <= \$_smarty_tpl->tpl_vars[$_statement[var]]->total;\$_smarty_tpl->tpl_vars[$_statement[var]]->value += \$_smarty_tpl->tpl_vars[$_statement[var]]->step, \$_smarty_tpl->tpl_vars[$_statement[var]]->iteration++){\n";
            $output .= "\$_smarty_tpl->tpl_vars[$_statement[var]]->first = \$_smarty_tpl->tpl_vars[$_statement[var]]->iteration == 1;";
            $output .= "\$_smarty_tpl->tpl_vars[$_statement[var]]->last = \$_smarty_tpl->tpl_vars[$_statement[var]]->iteration == \$_smarty_tpl->tpl_vars[$_statement[var]]->total;";
        }
        $output .= "?>";

        $this->openTag($compiler, 'for', array('for', $compiler->nocache));
        // maybe nocache because of nocache variables
        $compiler->nocache = $compiler->nocache | $compiler->tag_nocache;
        // return compiled code
        return $output;
    }

}

/**
 * Smarty Internal Plugin Compile Forelse Class
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_Forelse extends Smarty_Internal_CompileBase {

    /**
     * Compiles code for the {forelse} tag
     *
     * @param array  $args      array with attributes from parser
     * @param object $compiler  compiler object
     * @param array  $parameter array with compilation parameter
     * @return string compiled code
     */
    public function compile($args, $compiler, $parameter)
    {
        // check and get attributes
        $_attr  = $this->getAttributes($compiler, $args);

        list($openTag, $nocache) = $this->closeTag($compiler, array('for'));
        $this->openTag($compiler, 'forelse', array('forelse', $nocache));
        return "<?php }} else { ?>";
    }

}

/**
 * Smarty Internal Plugin Compile Forclose Class
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_Forclose extends Smarty_Internal_CompileBase {

    /**
     * Compiles code for the {/for} tag
     *
     * @param array  $args      array with attributes from parser
     * @param object $compiler  compiler object
     * @param array  $parameter array with compilation parameter
     * @return string compiled code
     */
    public function compile($args, $compiler, $parameter)
    {
        // check and get attributes
        $_attr = $this->getAttributes($compiler, $args);
        // must endblock be nocache?
        if ($compiler->nocache) {
            $compiler->tag_nocache = true;
        }

        list($openTag, $compiler->nocache) = $this->closeTag($compiler, array('for', 'forelse'));

        if ($openTag == 'forelse') {
            return "<?php }  ?>";
        } else {
            return "<?php }} ?>";
        }
    }

}

?><?php
/**
 * Smarty Internal Plugin Compile Assign
 *
 * Compiles the {assign} tag
 *
 * @package Smarty
 * @subpackage Compiler
 * @author Uwe Tews
 */

/**
 * Smarty Internal Plugin Compile Assign Class
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_Assign extends Smarty_Internal_CompileBase {

    /**
     * Compiles code for the {assign} tag
     *
     * @param array  $args      array with attributes from parser
     * @param object $compiler  compiler object
     * @param array  $parameter array with compilation parameter
     * @return string compiled code
     */
    public function compile($args, $compiler, $parameter)
    {
        // the following must be assigned at runtime because it will be overwritten in Smarty_Internal_Compile_Append
        $this->required_attributes = array('var', 'value');
        $this->shorttag_order = array('var', 'value');
        $this->optional_attributes = array('scope');
        $_nocache = 'null';
        $_scope = Smarty::SCOPE_LOCAL;
        // check and get attributes
        $_attr = $this->getAttributes($compiler, $args);
        // nocache ?
        if ($compiler->tag_nocache || $compiler->nocache) {
            $_nocache = 'true';
            // create nocache var to make it know for further compiling
            $compiler->template->tpl_vars[trim($_attr['var'], "'")] = new Smarty_variable(null, true);
        }
        // scope setup
        if (isset($_attr['scope'])) {
            $_attr['scope'] = trim($_attr['scope'], "'\"");
            if ($_attr['scope'] == 'parent') {
                $_scope = Smarty::SCOPE_PARENT;
            } elseif ($_attr['scope'] == 'root') {
                $_scope = Smarty::SCOPE_ROOT;
            } elseif ($_attr['scope'] == 'global') {
                $_scope = Smarty::SCOPE_GLOBAL;
            } else {
                $compiler->trigger_template_error('illegal value for "scope" attribute', $compiler->lex->taglineno);
            }
        }
        // compiled output
        if (isset($parameter['smarty_internal_index'])) {
            $output = "<?php \$_smarty_tpl->createLocalArrayVariable($_attr[var], $_nocache, $_scope);\n\$_smarty_tpl->tpl_vars[$_attr[var]]->value$parameter[smarty_internal_index] = $_attr[value];";
        } else {
            $output = "<?php \$_smarty_tpl->tpl_vars[$_attr[var]] = new Smarty_variable($_attr[value], $_nocache, $_scope);";
        }
        if ($_scope == Smarty::SCOPE_PARENT) {
            $output .= "\nif (\$_smarty_tpl->parent != null) \$_smarty_tpl->parent->tpl_vars[$_attr[var]] = clone \$_smarty_tpl->tpl_vars[$_attr[var]];";
        } elseif ($_scope == Smarty::SCOPE_ROOT || $_scope == Smarty::SCOPE_GLOBAL) {
            $output .= "\n\$_ptr = \$_smarty_tpl->parent; while (\$_ptr != null) {\$_ptr->tpl_vars[$_attr[var]] = clone \$_smarty_tpl->tpl_vars[$_attr[var]]; \$_ptr = \$_ptr->parent; }";
        }
        if ( $_scope == Smarty::SCOPE_GLOBAL) {
            $output .= "\nSmarty::\$global_tpl_vars[$_attr[var]] = clone \$_smarty_tpl->tpl_vars[$_attr[var]];";
        }
        $output .= '?>';
        return $output;
    }

}

?><?php
/**
 * Smarty Internal Plugin Smarty Template Compiler Base
 *
 * This file contains the basic classes and methodes for compiling Smarty templates with lexer/parser
 *
 * @package Smarty
 * @subpackage Compiler
 * @author Uwe Tews
 */

/**
 * @ignore
 */
include_once ("smarty_internal_parsetree.php"); // calguy1000 (was just include)

/**
 * Class SmartyTemplateCompiler
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_SmartyTemplateCompiler extends Smarty_Internal_TemplateCompilerBase {

    /**
     * Lexer class name
     *
     * @var string
     */
    public $lexer_class;

    /**
     * Parser class name
     *
     * @var string
     */
    public $parser_class;

    /**
     * Lexer object
     *
     * @var object
     */
    public $lex;

    /**
     * Parser object
     *
     * @var object
     */
    public $parser;

    /**
     * Smarty object
     *
     * @var object
     */
    public $smarty;

    /**
     * array of vars which can be compiled in local scope
     *
     * @var array
     */
    public $local_var = array();

    /**
     * Initialize compiler
     *
     * @param string $lexer_class  class name
     * @param string $parser_class class name
     * @param Smarty $smarty       global instance
     */
    public function __construct($lexer_class, $parser_class, $smarty)
    {
        $this->smarty = $smarty;
        parent::__construct();
        // get required plugins
        $this->lexer_class = $lexer_class;
        $this->parser_class = $parser_class;
    }

    /**
     * Methode to compile a Smarty template
     *
     * @param  mixed $_content template source
     * @return bool true if compiling succeeded, false if it failed
     */
    protected function doCompile($_content)
    {
        /* here is where the compiling takes place. Smarty
          tags in the templates are replaces with PHP code,
          then written to compiled files. */
        // init the lexer/parser to compile the template
        $this->lex = new $this->lexer_class($_content, $this);
        $this->parser = new $this->parser_class($this->lex, $this);
        if ($this->smarty->_parserdebug)
            $this->parser->PrintTrace();
        // get tokens from lexer and parse them
        while ($this->lex->yylex() && !$this->abort_and_recompile) {
            if ($this->smarty->_parserdebug) {
                echo "<pre>Line {$this->lex->line} Parsing  {$this->parser->yyTokenName[$this->lex->token]} Token " .
                    htmlentities($this->lex->value) . "</pre>";
            }
            $this->parser->doParse($this->lex->token, $this->lex->value);
        }

        if ($this->abort_and_recompile) {
            // exit here on abort
            return false;
        }
        // finish parsing process
        $this->parser->doParse(0, 0);
        // check for unclosed tags
        if (count($this->_tag_stack) > 0) {
            // get stacked info
            list($openTag, $_data) = array_pop($this->_tag_stack);
            $this->trigger_template_error("unclosed {" . $openTag . "} tag");
        }
        // return compiled code
        // return str_replace(array("? >\n<?php","? ><?php"), array('',''), $this->parser->retvalue);
        return $this->parser->retvalue;
    }

}

?>
<?php

/**
* Smarty Internal Plugin Compile extend
*
* Compiles the {extends} tag
*
* @package Smarty
* @subpackage Compiler
* @author Uwe Tews
*/

/**
* Smarty Internal Plugin Compile extend Class
*
* @package Smarty
* @subpackage Compiler
*/
class Smarty_Internal_Compile_Extends extends Smarty_Internal_CompileBase {

    /**
    * Attribute definition: Overwrites base class.
    *
    * @var array
    * @see Smarty_Internal_CompileBase
    */
    public $required_attributes = array('file');
    /**
    * Attribute definition: Overwrites base class.
    *
    * @var array
    * @see Smarty_Internal_CompileBase
    */
    public $shorttag_order = array('file');

    /**
    * Compiles code for the {extends} tag
    *
    * @param array  $args     array with attributes from parser
    * @param object $compiler compiler object
    * @return string compiled code
    */
    public function compile($args, $compiler)
    {
        static $_is_stringy = array('string' => true, 'eval' => true);
        $this->_rdl = preg_quote($compiler->smarty->right_delimiter);
        $this->_ldl = preg_quote($compiler->smarty->left_delimiter);
        $filepath = $compiler->template->source->filepath;
        // check and get attributes
        $_attr = $this->getAttributes($compiler, $args);
        if ($_attr['nocache'] === true) {
            $compiler->trigger_template_error('nocache option not allowed', $compiler->lex->taglineno);
        }

        $_smarty_tpl = $compiler->template;
        $include_file = null;
        if (strpos($_attr['file'], '$_tmp') !== false) {
            $compiler->trigger_template_error('illegal value for file attribute', $compiler->lex->taglineno);
        }
        eval('$include_file = ' . $_attr['file'] . ';');
        // create template object
        $_template = new $compiler->smarty->template_class($include_file, $compiler->smarty, $compiler->template);
        // save file dependency
        if (isset($_is_stringy[$_template->source->type])) {
            $template_sha1 = sha1($include_file);
        } else {
            $template_sha1 = sha1($_template->source->filepath);
        }
        if (isset($compiler->template->properties['file_dependency'][$template_sha1])) {
            $compiler->trigger_template_error("illegal recursive call of \"{$include_file}\"", $compiler->lex->line - 1);
        }
        $compiler->template->properties['file_dependency'][$template_sha1] = array($_template->source->filepath, $_template->source->timestamp, $_template->source->type);
        $_content = substr($compiler->template->source->content, $compiler->lex->counter - 1);
        if (preg_match_all("!({$this->_ldl}block\s(.+?){$this->_rdl})!", $_content, $s) !=
        preg_match_all("!({$this->_ldl}/block{$this->_rdl})!", $_content, $c)) {
            $compiler->trigger_template_error('unmatched {block} {/block} pairs');
        }
        preg_match_all("!{$this->_ldl}block\s(.+?){$this->_rdl}|{$this->_ldl}/block{$this->_rdl}|{$this->_ldl}\*([\S\s]*?)\*{$this->_rdl}!", $_content, $_result, PREG_OFFSET_CAPTURE);
        $_result_count = count($_result[0]);
        $_start = 0;
        while ($_start+1 < $_result_count) {
            $_end = 0;
            $_level = 1;
            if (substr($_result[0][$_start][0],0,strlen($compiler->smarty->left_delimiter)+1) == $compiler->smarty->left_delimiter.'*') {
                $_start++;
                continue;
            }
            while ($_level != 0) {
                $_end++;
                if (substr($_result[0][$_start + $_end][0],0,strlen($compiler->smarty->left_delimiter)+1) == $compiler->smarty->left_delimiter.'*') {
                    continue;
                }
                if (!strpos($_result[0][$_start + $_end][0], '/')) {
                    $_level++;
                } else {
                    $_level--;
                }
            }
            $_block_content = str_replace($compiler->smarty->left_delimiter . '$smarty.block.parent' . $compiler->smarty->right_delimiter, '%%%%SMARTY_PARENT%%%%',
            substr($_content, $_result[0][$_start][1] + strlen($_result[0][$_start][0]), $_result[0][$_start + $_end][1] - $_result[0][$_start][1] - + strlen($_result[0][$_start][0])));
            Smarty_Internal_Compile_Block::saveBlockData($_block_content, $_result[0][$_start][0], $compiler->template, $filepath);
            $_start = $_start + $_end + 1;
        }
        if ($_template->source->type == 'extends') {
            $_template->block_data = $compiler->template->block_data;
        }
        $compiler->template->source->content = $_template->source->content;
        if ($_template->source->type == 'extends') {
            $compiler->template->block_data = $_template->block_data;
            foreach ($_template->source->components as $key => $component) {
                $compiler->template->properties['file_dependency'][$key] = array($component->filepath, $component->timestamp, $component->type);
            }
        }
        $compiler->template->source->filepath = $_template->source->filepath;
        $compiler->abort_and_recompile = true;
        return '';
    }

}

?><?php
/**
* Smarty Internal Plugin Compile Print Expression
*
* Compiles any tag which will output an expression or variable
*
* @package Smarty
* @subpackage Compiler
* @author Uwe Tews
*/

/**
* Smarty Internal Plugin Compile Print Expression Class
*
* @package Smarty
* @subpackage Compiler
*/
class Smarty_Internal_Compile_Private_Print_Expression extends Smarty_Internal_CompileBase {

    /**
    * Attribute definition: Overwrites base class.
    *
    * @var array
    * @see Smarty_Internal_CompileBase
    */
    public $optional_attributes = array('assign');
    /**
    * Attribute definition: Overwrites base class.
    *
    * @var array
    * @see Smarty_Internal_CompileBase
    */
    public $option_flags = array('nocache', 'nofilter');

    /**
    * Compiles code for gererting output from any expression
    *
    * @param array  $args      array with attributes from parser
    * @param object $compiler  compiler object
    * @param array  $parameter array with compilation parameter
    * @return string compiled code
    */
    public function compile($args, $compiler, $parameter)
    {
        // check and get attributes
        $_attr = $this->getAttributes($compiler, $args);
        // nocache option
        if ($_attr['nocache'] === true) {
            $compiler->tag_nocache = true;
        }
        // filter handling
        if ($_attr['nofilter'] === true) {
            $_filter = 'false';
        } else {
            $_filter = 'true';
        }
        if (isset($_attr['assign'])) {
            // assign output to variable
            $output = "<?php \$_smarty_tpl->assign({$_attr['assign']},{$parameter['value']});?>";
        } else {
            // display value
            $output = $parameter['value'];
            // tag modifier
            if (!empty($parameter['modifierlist'])) {
                $output = $compiler->compileTag('private_modifier', array(), array('modifierlist' => $parameter['modifierlist'], 'value' => $output));
            }
            if (!$_attr['nofilter']) {
                // default modifier
                if (!empty($compiler->smarty->default_modifiers)) {
                    if (empty($compiler->default_modifier_list)) {
                        $modifierlist = array();
                        foreach ($compiler->smarty->default_modifiers as $key => $single_default_modifier) {
                            preg_match_all('/(\'[^\'\\\\]*(?:\\\\.[^\'\\\\]*)*\'|"[^"\\\\]*(?:\\\\.[^"\\\\]*)*"|:|[^:]+)/', $single_default_modifier, $mod_array);
                            for ($i = 0, $count = count($mod_array[0]);$i < $count;$i++) {
                                if ($mod_array[0][$i] != ':') {
                                    $modifierlist[$key][] = $mod_array[0][$i];
                                }
                            }
                        }
                        $compiler->default_modifier_list  = $modifierlist;
                    }
                    $output = $compiler->compileTag('private_modifier', array(), array('modifierlist' => $compiler->default_modifier_list, 'value' => $output));
                }
                // autoescape html
                if ($compiler->template->smarty->escape_html) {
                    $output = "htmlspecialchars({$output}, ENT_QUOTES, SMARTY_RESOURCE_CHAR_SET)";
                }
                // loop over registerd filters
                if (!empty($compiler->template->smarty->registered_filters[Smarty::FILTER_VARIABLE])) {
                    foreach ($compiler->template->smarty->registered_filters[Smarty::FILTER_VARIABLE] as $key => $function) {
                        if (!is_array($function)) {
                            $output = "{$function}({$output},\$_smarty_tpl)";
                        } else if (is_object($function[0])) {
                            $output = "\$_smarty_tpl->smarty->registered_filters[Smarty::FILTER_VARIABLE][{$key}][0]->{$function[1]}({$output},\$_smarty_tpl)";
                        } else {
                            $output = "{$function[0]}::{$function[1]}({$output},\$_smarty_tpl)";
                        }
                    }
                }
                // auto loaded filters
                if (isset($compiler->smarty->autoload_filters[Smarty::FILTER_VARIABLE])) {
                    foreach ((array)$compiler->template->smarty->autoload_filters[Smarty::FILTER_VARIABLE] as $name) {
                        $result = $this->compile_output_filter($compiler, $name, $output);
                        if ($result !== false) {
                            $output = $result;
                        } else {
                            // not found, throw exception
                            throw new SmartyException("Unable to load filter '{$name}'");
                        }
                    }
                }
                if (isset($compiler->template->variable_filters)) {
                    foreach ($compiler->template->variable_filters as $filter) {
                        if (count($filter) == 1 && ($result = $this->compile_output_filter($compiler, $filter[0], $output)) !== false) {
                            $output = $result;
                        } else {
                            $output = $compiler->compileTag('private_modifier', array(), array('modifierlist' => array($filter), 'value' => $output));
                        }
                    }
                }
            }

            $compiler->has_output = true;
            $output = "<?php echo {$output};?>";
        }
        return $output;
    }

    /**
    * @param object $compiler compiler object
    * @param string $name     name of variable filter
    * @param type   $output   embedded output
    * @return string
    */
    private function compile_output_filter($compiler, $name, $output)
    {
        $plugin_name = "smarty_variablefilter_{$name}";
        $path = $compiler->smarty->loadPlugin($plugin_name, false);
        if ($path) {
            if ($compiler->template->caching) {
                $compiler->template->required_plugins['nocache'][$name][Smarty::FILTER_VARIABLE]['file'] = $path;
                $compiler->template->required_plugins['nocache'][$name][Smarty::FILTER_VARIABLE]['function'] = $plugin_name;
            } else {
                $compiler->template->required_plugins['compiled'][$name][Smarty::FILTER_VARIABLE]['file'] = $path;
                $compiler->template->required_plugins['compiled'][$name][Smarty::FILTER_VARIABLE]['function'] = $plugin_name;
            }
        } else {
            // not found
            return false;
        }
        return "{$plugin_name}({$output},\$_smarty_tpl)";
    }

}

?><?php
/**
 * Smarty Internal Plugin Config
 *
 * @package Smarty
 * @subpackage Config
 * @author Uwe Tews
 */

/**
 * Smarty Internal Plugin Config
 *
 * Main class for config variables
 *
 * @package Smarty
 * @subpackage Config
 *
 * @property Smarty_Config_Source   $source
 * @property Smarty_Config_Compiled $compiled
 * @ignore
 */
class Smarty_Internal_Config {

    /**
     * Samrty instance
     *
     * @var Smarty object
     */
    public $smarty = null;
    /**
     * Object of config var storage
     *
     * @var object
     */
    public $data = null;
    /**
     * Config resource
     * @var string
     */
    public $config_resource = null;
    /**
     * Compiled config file
     *
     * @var string
     */
    public $compiled_config = null;
    /**
     * filepath of compiled config file
     *
     * @var string
     */
    public $compiled_filepath = null;
    /**
     * Filemtime of compiled config Filemtime
     *
     * @var int
     */
    public $compiled_timestamp = null;
    /**
     * flag if compiled config file is invalid and must be (re)compiled
     * @var bool
     */
    public $mustCompile = null;
    /**
     * Config file compiler object
     *
     * @var Smarty_Internal_Config_File_Compiler object
     */
    public $compiler_object = null;

    /**
     * Constructor of config file object
     *
     * @param string $config_resource config file resource name
     * @param Smarty $smarty Smarty instance
     * @param object $data object for config vars storage
     */
    public function __construct($config_resource, $smarty, $data = null)
    {
        $this->data = $data;
        $this->smarty = $smarty;
        $this->config_resource = $config_resource;
    }

    /**
     * Returns the compiled  filepath
     *
     * @return string the compiled filepath
     */
    public function getCompiledFilepath()
    {
        return $this->compiled_filepath === null ?
                ($this->compiled_filepath = $this->buildCompiledFilepath()) :
                $this->compiled_filepath;
    }

    /**
     * Get file path.
     *
     * @return string
     */
    public function buildCompiledFilepath()
    {
        $_compile_id = isset($this->smarty->compile_id) ? preg_replace('![^\w\|]+!', '_', $this->smarty->compile_id) : null;
        $_flag = (int) $this->smarty->config_read_hidden + (int) $this->smarty->config_booleanize * 2
                + (int) $this->smarty->config_overwrite * 4;
        $_filepath = sha1($this->source->name . $_flag);
        // if use_sub_dirs, break file into directories
        if ($this->smarty->use_sub_dirs) {
            $_filepath = substr($_filepath, 0, 2) . DS
                    . substr($_filepath, 2, 2) . DS
                    . substr($_filepath, 4, 2) . DS
                    . $_filepath;
        }
        $_compile_dir_sep = $this->smarty->use_sub_dirs ? DS : '^';
        if (isset($_compile_id)) {
            $_filepath = $_compile_id . $_compile_dir_sep . $_filepath;
        }
        $_compile_dir = $this->smarty->getCompileDir();
        return $_compile_dir . $_filepath . '.' . basename($this->source->name) . '.config' . '.php';
    }

    /**
     * Returns the timpestamp of the compiled file
     *
     * @return integer the file timestamp
     */
    public function getCompiledTimestamp()
    {
        return $this->compiled_timestamp === null
            ? ($this->compiled_timestamp = (file_exists($this->getCompiledFilepath())) ? filemtime($this->getCompiledFilepath()) : false)
            : $this->compiled_timestamp;
    }

    /**
     * Returns if the current config file must be compiled
     *
     * It does compare the timestamps of config source and the compiled config and checks the force compile configuration
     *
     * @return boolean true if the file must be compiled
     */
    public function mustCompile()
    {
        return $this->mustCompile === null ?
            $this->mustCompile = ($this->smarty->force_compile || $this->getCompiledTimestamp () === false || $this->smarty->compile_check && $this->getCompiledTimestamp () < $this->source->timestamp):
            $this->mustCompile;
    }

    /**
     * Returns the compiled config file
     *
     * It checks if the config file must be compiled or just read the compiled version
     *
     * @return string the compiled config file
     */
    public function getCompiledConfig()
    {
        if ($this->compiled_config === null) {
            // see if template needs compiling.
            if ($this->mustCompile()) {
                $this->compileConfigSource();
            } else {
                $this->compiled_config = file_get_contents($this->getCompiledFilepath());
            }
        }
        return $this->compiled_config;
    }

    /**
     * Compiles the config files
     *
     * @throws Exception
     */
    public function compileConfigSource()
    {
        // compile template
        if (!is_object($this->compiler_object)) {
            // load compiler
            $this->compiler_object = new Smarty_Internal_Config_File_Compiler($this->smarty);
        }
        // compile locking
        if ($this->smarty->compile_locking) {
            if ($saved_timestamp = $this->getCompiledTimestamp()) {
                touch($this->getCompiledFilepath());
            }
        }
        // call compiler
        try {
            $this->compiler_object->compileSource($this);
        } catch (Exception $e) {
            // restore old timestamp in case of error
            if ($this->smarty->compile_locking && $saved_timestamp) {
                touch($this->getCompiledFilepath(), $saved_timestamp);
            }
            throw $e;
        }
        // compiling succeded
        // write compiled template
        Smarty_Internal_Write_File::writeFile($this->getCompiledFilepath(), $this->getCompiledConfig(), $this->smarty);
    }

    /**
     * load config variables
     *
     * @param mixed $sections array of section names, single section or null
     * @param object $scope global,parent or local
     */
    public function loadConfigVars($sections = null, $scope = 'local')
    {
        if ($this->data instanceof Smarty_Internal_Template) {
            $this->data->properties['file_dependency'][sha1($this->source->filepath)] = array($this->source->filepath, $this->source->timestamp, 'file');
        }
        if ($this->mustCompile()) {
            $this->compileConfigSource();
        }
        // pointer to scope
        if ($scope == 'local') {
            $scope_ptr = $this->data;
        } elseif ($scope == 'parent') {
            if (isset($this->data->parent)) {
                $scope_ptr = $this->data->parent;
            } else {
                $scope_ptr = $this->data;
            }
        } elseif ($scope == 'root' || $scope == 'global') {
            $scope_ptr = $this->data;
            while (isset($scope_ptr->parent)) {
                $scope_ptr = $scope_ptr->parent;
            }
        }
        $_config_vars = array();
        include($this->getCompiledFilepath());
        // copy global config vars
        foreach ($_config_vars['vars'] as $variable => $value) {
            if ($this->smarty->config_overwrite || !isset($scope_ptr->config_vars[$variable])) {
                $scope_ptr->config_vars[$variable] = $value;
            } else {
                $scope_ptr->config_vars[$variable] = array_merge((array) $scope_ptr->config_vars[$variable], (array) $value);
            }
        }
        // scan sections
        if (!empty($sections)) {
            $sections = array_flip((array) $sections);
            foreach ($_config_vars['sections'] as $this_section => $dummy) {
                if (isset($sections[$this_section])) {
                    foreach ($_config_vars['sections'][$this_section]['vars'] as $variable => $value) {
                        if ($this->smarty->config_overwrite || !isset($scope_ptr->config_vars[$variable])) {
                            $scope_ptr->config_vars[$variable] = $value;
                        } else {
                            $scope_ptr->config_vars[$variable] = array_merge((array) $scope_ptr->config_vars[$variable], (array) $value);
                        }
                    }
                }
            }
        }
    }

    /**
     * set Smarty property in template context
     *
     * @param string $property_name property name
     * @param mixed  $value         value
     * @throws SmartyException if $property_name is not valid
     */
    public function __set($property_name, $value)
    {
        switch ($property_name) {
            case 'source':
            case 'compiled':
                $this->$property_name = $value;
                return;
        }

        throw new SmartyException("invalid config property '$property_name'.");
    }

    /**
     * get Smarty property in template context
     *
     * @param string $property_name property name
     * @throws SmartyException if $property_name is not valid
     */
    public function __get($property_name)
    {
        switch ($property_name) {
            case 'source':
                if (empty($this->config_resource)) {
                    throw new SmartyException("Unable to parse resource name \"{$this->config_resource}\"");
                }
                $this->source = Smarty_Resource::config($this);
                return $this->source;

            case 'compiled':
                $this->compiled = $this->source->getCompiled($this);
                return $this->compiled;
        }

        throw new SmartyException("config attribute '$property_name' does not exist.");
    }

}

?><?php
/**
 * Smarty Internal Plugin Data
 *
 * This file contains the basic classes and methodes for template and variable creation
 *
 * @package Smarty
 * @subpackage Template
 * @author Uwe Tews
 */

/**
 * Base class with template and variable methodes
 *
 * @package Smarty
 * @subpackage Template
 */
class Smarty_Internal_Data {

    /**
     * name of class used for templates
     *
     * @var string
     */
    public $template_class = 'Smarty_Internal_Template';
    /**
     * template variables
     *
     * @var array
     */
    public $tpl_vars = array();
    /**
     * parent template (if any)
     *
     * @var Smarty_Internal_Template
     */
    public $parent = null;
    /**
     * configuration settings
     *
     * @var array
     */
    public $config_vars = array();

    /**
     * assigns a Smarty variable
     *
     * @param array|string $tpl_var the template variable name(s)
     * @param mixed        $value   the value to assign
     * @param boolean      $nocache if true any output of this variable will be not cached
     * @param boolean $scope the scope the variable will have  (local,parent or root)
     * @return Smarty_Internal_Data current Smarty_Internal_Data (or Smarty or Smarty_Internal_Template) instance for chaining
     */
    public function assign($tpl_var, $value = null, $nocache = false)
    {
        if (is_array($tpl_var)) {
            foreach ($tpl_var as $_key => $_val) {
                if ($_key != '') {
                    $this->tpl_vars[$_key] = new Smarty_variable($_val, $nocache);
                }
            }
        } else {
            if ($tpl_var != '') {
                $this->tpl_vars[$tpl_var] = new Smarty_variable($value, $nocache);
            }
        }

        return $this;
    }

    /**
     * assigns a global Smarty variable
     *
     * @param string $varname the global variable name
     * @param mixed  $value   the value to assign
     * @param boolean $nocache if true any output of this variable will be not cached
     * @return Smarty_Internal_Data current Smarty_Internal_Data (or Smarty or Smarty_Internal_Template) instance for chaining
     */
    public function assignGlobal($varname, $value = null, $nocache = false)
    {
        if ($varname != '') {
            Smarty::$global_tpl_vars[$varname] = new Smarty_variable($value, $nocache);
        }

        return $this;
    }
    /**
     * assigns values to template variables by reference
     *
     * @param string $tpl_var the template variable name
     * @param mixed $ &$value the referenced value to assign
     * @param boolean $nocache if true any output of this variable will be not cached
     * @return Smarty_Internal_Data current Smarty_Internal_Data (or Smarty or Smarty_Internal_Template) instance for chaining
     */
    public function assignByRef($tpl_var, &$value, $nocache = false)
    {
        if ($tpl_var != '') {
            $this->tpl_vars[$tpl_var] = new Smarty_variable(null, $nocache);
            $this->tpl_vars[$tpl_var]->value = &$value;
        }

        return $this;
    }

    /**
     * appends values to template variables
     *
     * @param array|string $tpl_var the template variable name(s)
     * @param mixed        $value   the value to append
     * @param boolean      $merge   flag if array elements shall be merged
     * @param boolean $nocache if true any output of this variable will be not cached
     * @return Smarty_Internal_Data current Smarty_Internal_Data (or Smarty or Smarty_Internal_Template) instance for chaining
     */
    public function append($tpl_var, $value = null, $merge = false, $nocache = false)
    {
        if (is_array($tpl_var)) {
            // $tpl_var is an array, ignore $value
            foreach ($tpl_var as $_key => $_val) {
                if ($_key != '') {
                    if (!isset($this->tpl_vars[$_key])) {
                        $tpl_var_inst = $this->getVariable($_key, null, true, false);
                        if ($tpl_var_inst instanceof Undefined_Smarty_Variable) {
                            $this->tpl_vars[$_key] = new Smarty_variable(null, $nocache);
                        } else {
                            $this->tpl_vars[$_key] = clone $tpl_var_inst;
                        }
                    }
                    if (!(is_array($this->tpl_vars[$_key]->value) || $this->tpl_vars[$_key]->value instanceof ArrayAccess)) {
                        settype($this->tpl_vars[$_key]->value, 'array');
                    }
                    if ($merge && is_array($_val)) {
                        foreach($_val as $_mkey => $_mval) {
                            $this->tpl_vars[$_key]->value[$_mkey] = $_mval;
                        }
                    } else {
                        $this->tpl_vars[$_key]->value[] = $_val;
                    }
                }
            }
        } else {
            if ($tpl_var != '' && isset($value)) {
                if (!isset($this->tpl_vars[$tpl_var])) {
                    $tpl_var_inst = $this->getVariable($tpl_var, null, true, false);
                    if ($tpl_var_inst instanceof Undefined_Smarty_Variable) {
                        $this->tpl_vars[$tpl_var] = new Smarty_variable(null, $nocache);
                    } else {
                        $this->tpl_vars[$tpl_var] = clone $tpl_var_inst;
                    }
                }
                if (!(is_array($this->tpl_vars[$tpl_var]->value) || $this->tpl_vars[$tpl_var]->value instanceof ArrayAccess)) {
                    settype($this->tpl_vars[$tpl_var]->value, 'array');
                }
                if ($merge && is_array($value)) {
                    foreach($value as $_mkey => $_mval) {
                        $this->tpl_vars[$tpl_var]->value[$_mkey] = $_mval;
                    }
                } else {
                    $this->tpl_vars[$tpl_var]->value[] = $value;
                }
            }
        }

        return $this;
    }

    /**
     * appends values to template variables by reference
     *
     * @param string $tpl_var the template variable name
     * @param mixed  &$value  the referenced value to append
     * @param boolean $merge  flag if array elements shall be merged
     * @return Smarty_Internal_Data current Smarty_Internal_Data (or Smarty or Smarty_Internal_Template) instance for chaining
     */
    public function appendByRef($tpl_var, &$value, $merge = false)
    {
        if ($tpl_var != '' && isset($value)) {
            if (!isset($this->tpl_vars[$tpl_var])) {
                $this->tpl_vars[$tpl_var] = new Smarty_variable();
            }
            if (!is_array($this->tpl_vars[$tpl_var]->value)) {
                settype($this->tpl_vars[$tpl_var]->value, 'array');
            }
            if ($merge && is_array($value)) {
                foreach($value as $_key => $_val) {
                    $this->tpl_vars[$tpl_var]->value[$_key] = &$value[$_key];
                }
            } else {
                $this->tpl_vars[$tpl_var]->value[] = &$value;
            }
        }

        return $this;
    }

    /**
     * Returns a single or all template variables
     *
     * @param string  $varname        variable name or null
     * @param string  $_ptr           optional pointer to data object
     * @param boolean $search_parents include parent templates?
     * @return string variable value or or array of variables
     */
    public function getTemplateVars($varname = null, $_ptr = null, $search_parents = true)
    {
        if (isset($varname)) {
            $_var = $this->getVariable($varname, $_ptr, $search_parents, false);
            if (is_object($_var)) {
                return $_var->value;
            } else {
                return null;
            }
        } else {
            $_result = array();
            if ($_ptr === null) {
                $_ptr = $this;
            } while ($_ptr !== null) {
                foreach ($_ptr->tpl_vars AS $key => $var) {
                    if (!array_key_exists($key, $_result)) {
                        $_result[$key] = $var->value;
                    }
                }
                // not found, try at parent
                if ($search_parents) {
                    $_ptr = $_ptr->parent;
                } else {
                    $_ptr = null;
                }
            }
            if ($search_parents && isset(Smarty::$global_tpl_vars)) {
                foreach (Smarty::$global_tpl_vars AS $key => $var) {
                    if (!array_key_exists($key, $_result)) {
                        $_result[$key] = $var->value;
                    }
                }
            }
            return $_result;
        }
    }

    /**
     * clear the given assigned template variable.
     *
     * @param string|array $tpl_var the template variable(s) to clear
     * @return Smarty_Internal_Data current Smarty_Internal_Data (or Smarty or Smarty_Internal_Template) instance for chaining
     */
    public function clearAssign($tpl_var)
    {
        if (is_array($tpl_var)) {
            foreach ($tpl_var as $curr_var) {
                unset($this->tpl_vars[$curr_var]);
            }
        } else {
            unset($this->tpl_vars[$tpl_var]);
        }

        return $this;
    }

    /**
     * clear all the assigned template variables.
     * @return Smarty_Internal_Data current Smarty_Internal_Data (or Smarty or Smarty_Internal_Template) instance for chaining
     */
    public function clearAllAssign()
    {
        $this->tpl_vars = array();
        return $this;
    }

    /**
     * load a config file, optionally load just selected sections
     *
     * @param string $config_file filename
     * @param mixed  $sections    array of section names, single section or null
     * @return Smarty_Internal_Data current Smarty_Internal_Data (or Smarty or Smarty_Internal_Template) instance for chaining
     */
    public function configLoad($config_file, $sections = null)
    {
        // load Config class
        $config = new Smarty_Internal_Config($config_file, $this->smarty, $this);
        $config->loadConfigVars($sections);
        return $this;
    }

    /**
     * gets the object of a Smarty variable
     *
     * @param string  $variable the name of the Smarty variable
     * @param object  $_ptr     optional pointer to data object
     * @param boolean $search_parents search also in parent data
     * @return object the object of the variable
     */
    public function getVariable($variable, $_ptr = null, $search_parents = true, $error_enable = true)
    {
        if ($_ptr === null) {
            $_ptr = $this;
        } while ($_ptr !== null) {
            if (isset($_ptr->tpl_vars[$variable])) {
                // found it, return it
                return $_ptr->tpl_vars[$variable];
            }
            // not found, try at parent
            if ($search_parents) {
                $_ptr = $_ptr->parent;
            } else {
                $_ptr = null;
            }
        }
        if (isset(Smarty::$global_tpl_vars[$variable])) {
            // found it, return it
            return Smarty::$global_tpl_vars[$variable];
        }
        if ($this->smarty->error_unassigned && $error_enable) {
            // force a notice
            $x = $$variable;
        }
        return new Undefined_Smarty_Variable;
    }

    /**
     * gets  a config variable
     *
     * @param string $variable the name of the config variable
     * @return mixed the value of the config variable
     */
    public function getConfigVariable($variable, $error_enable = true)
    {
        $_ptr = $this;
        while ($_ptr !== null) {
            if (isset($_ptr->config_vars[$variable])) {
                // found it, return it
                return $_ptr->config_vars[$variable];
            }
            // not found, try at parent
            $_ptr = $_ptr->parent;
        }
        if ($this->smarty->error_unassigned && $error_enable) {
            // force a notice
            $x = $$variable;
        }
        return null;
    }

    /**
     * gets  a stream variable
     *
     * @param string $variable the stream of the variable
     * @return mixed the value of the stream variable
     */
    public function getStreamVariable($variable)
    {
        $_result = '';
        $fp = fopen($variable, 'r+');
        if ($fp) {
            while (!feof($fp) && ($current_line = fgets($fp)) !== false ) {
                $_result .= $current_line;
            }
            fclose($fp);
            return $_result;
        }

        if ($this->smarty->error_unassigned) {
            throw new SmartyException('Undefined stream variable "' . $variable . '"');
        } else {
            return null;
        }
    }

    /**
     * Returns a single or all config variables
     *
     * @param string $varname variable name or null
     * @return string variable value or or array of variables
     */
    public function getConfigVars($varname = null, $search_parents = true)
    {
        $_ptr = $this;
        $var_array = array();
        while ($_ptr !== null) {
            if (isset($varname)) {
                if (isset($_ptr->config_vars[$varname])) {
                    return $_ptr->config_vars[$varname];
                }
            } else {
                $var_array = array_merge($_ptr->config_vars, $var_array);
            }
             // not found, try at parent
            if ($search_parents) {
                $_ptr = $_ptr->parent;
            } else {
                $_ptr = null;
            }
        }
        if (isset($varname)) {
            return '';
        } else {
            return $var_array;
        }
    }

    /**
     * Deassigns a single or all config variables
     *
     * @param string $varname variable name or null
     * @return Smarty_Internal_Data current Smarty_Internal_Data (or Smarty or Smarty_Internal_Template) instance for chaining
     */
    public function clearConfig($varname = null)
    {
        if (isset($varname)) {
            unset($this->config_vars[$varname]);
        } else {
            $this->config_vars = array();
        }
        return $this;
    }

}

/**
 * class for the Smarty data object
 *
 * The Smarty data object will hold Smarty variables in the current scope
 *
 * @package Smarty
 * @subpackage Template
 */
class Smarty_Data extends Smarty_Internal_Data {

    /**
     * Smarty object
     *
     * @var Smarty
     */
    public $smarty = null;

    /**
     * create Smarty data object
     *
     * @param Smarty|array $_parent  parent template
     * @param Smarty       $smarty   global smarty instance
     */
    public function __construct ($_parent = null, $smarty = null)
    {
        $this->smarty = $smarty;
        if (is_object($_parent)) {
            // when object set up back pointer
            $this->parent = $_parent;
        } elseif (is_array($_parent)) {
            // set up variable values
            foreach ($_parent as $_key => $_val) {
                $this->tpl_vars[$_key] = new Smarty_variable($_val);
            }
        } elseif ($_parent != null) {
            throw new SmartyException("Wrong type for template variables");
        }
    }

}

/**
 * class for the Smarty variable object
 *
 * This class defines the Smarty variable object
 *
 * @package Smarty
 * @subpackage Template
 */
class Smarty_Variable {

    /**
     * template variable
     *
     * @var mixed
     */
    public $value = null;
    /**
     * if true any output of this variable will be not cached
     *
     * @var boolean
     */
    public $nocache = false;
    /**
     * the scope the variable will have  (local,parent or root)
     *
     * @var int
     */
    public $scope = Smarty::SCOPE_LOCAL;

    /**
     * create Smarty variable object
     *
     * @param mixed   $value   the value to assign
     * @param boolean $nocache if true any output of this variable will be not cached
     * @param int     $scope   the scope the variable will have  (local,parent or root)
     */
    public function __construct($value = null, $nocache = false, $scope = Smarty::SCOPE_LOCAL)
    {
        $this->value = $value;
        $this->nocache = $nocache;
        $this->scope = $scope;
    }

    /**
     * <<magic>> String conversion
     *
     * @return string
     */
    public function __toString()
    {
        return (string) $this->value;
    }

}

/**
 * class for undefined variable object
 *
 * This class defines an object for undefined variable handling
 *
 * @package Smarty
 * @subpackage Template
 */
class Undefined_Smarty_Variable {

    /**
     * Returns FALSE for 'nocache' and NULL otherwise.
     *
     * @param string $name
     * @return bool
     */
    public function __get($name)
    {
        if ($name == 'nocache') {
            return false;
        } else {
            return null;
        }
    }

    /**
     * Always returns an empty string.
     *
     * @return string
     */
    public function __toString()
    {
        return "";
    }

}

?><?php
/**
 * Smarty Resource Plugin
 *
 * @package Smarty
 * @subpackage TemplateResources
 * @author Rodney Rehm
 */

/**
 * Smarty Resource Plugin
 *
 * Wrapper Implementation for custom resource plugins
 *
 * @package Smarty
 * @subpackage TemplateResources
 */
abstract class Smarty_Resource_Custom extends Smarty_Resource {

    /**
     * fetch template and its modification time from data source
     *
     * @param string  $name    template name
     * @param string  &$source template source
     * @param integer &$mtime  template modification timestamp (epoch)
     */
    protected abstract function fetch($name, &$source, &$mtime);

    /**
     * Fetch template's modification timestamp from data source
     *
     * {@internal implementing this method is optional.
     *  Only implement it if modification times can be accessed faster than loading the complete template source.}}
     *
     * @param string $name template name
     * @return integer|boolean timestamp (epoch) the template was modified, or false if not found
     */
    protected function fetchTimestamp($name)
    {
        return null;
    }

    /**
     * populate Source Object with meta data from Resource
     *
     * @param Smarty_Template_Source   $source    source object
     * @param Smarty_Internal_Template $_template template object
     */
    public function populate(Smarty_Template_Source $source, Smarty_Internal_Template $_template=null)
    {
        $source->filepath = strtolower($source->type . ':' . $source->name);
        $source->uid = sha1($source->type . ':' . $source->name);

        $mtime = $this->fetchTimestamp($source->name);
        if ($mtime !== null) {
            $source->timestamp = $mtime;
        } else {
            $this->fetch($source->name, $content, $timestamp);
            $source->timestamp = isset($timestamp) ? $timestamp : false;
            if( isset($content) )
                $source->content = $content;
        }
        $source->exists = !!$source->timestamp;
    }

    /**
     * Load template's source into current template object
     *
     * @param Smarty_Template_Source $source source object
     * @return string template source
     * @throws SmartyException if source cannot be loaded
     */
    public function getContent(Smarty_Template_Source $source)
    {
        $this->fetch($source->name, $content, $timestamp);
        if (isset($content)) {
            return $content;
        }

        throw new SmartyException("Unable to read template {$source->type} '{$source->name}'");
    }

    /**
     * Determine basename for compiled filename
     *
     * @param Smarty_Template_Source $source source object
     * @return string resource's basename
     */
    protected function getBasename(Smarty_Template_Source $source)
    {
        return basename($source->name);
    }

}

?><?php
/**
 * Smarty Internal Plugin Compile Rdelim
 *
 * Compiles the {rdelim} tag
 * @package Smarty
 * @subpackage Compiler
 * @author Uwe Tews
 */

/**
 * Smarty Internal Plugin Compile Rdelim Class
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_Rdelim extends Smarty_Internal_CompileBase {

    /**
     * Compiles code for the {rdelim} tag
     *
     * This tag does output the right delimiter.
     *
     * @param array  $args     array with attributes from parser
     * @param object $compiler compiler object
     * @return string compiled code
     */
    public function compile($args, $compiler)
    {
        $_attr = $this->getAttributes($compiler, $args);
        if ($_attr['nocache'] === true) {
            $compiler->trigger_template_error('nocache option not allowed', $compiler->lex->taglineno);
        }
        // this tag does not return compiled code
        $compiler->has_code = true;
        return $compiler->smarty->right_delimiter;
    }

}

?><?php
/**
 * Smarty Internal Plugin Smarty Template Compiler Base
 *
 * This file contains the basic classes and methodes for compiling Smarty templates with lexer/parser
 *
 * @package Smarty
 * @subpackage Compiler
 * @author Uwe Tews
 */

/**
 * Main abstract compiler class
 *
 * @package Smarty
 * @subpackage Compiler
 */
abstract class Smarty_Internal_TemplateCompilerBase {

    /**
     * hash for nocache sections
     *
     * @var mixed
     */
    private $nocache_hash = null;
    /**
     * suppress generation of nocache code
     *
     * @var bool
     */
    public $suppressNocacheProcessing = false;
    /**
     * suppress generation of merged template code
     *
     * @var bool
     */
    public $suppressMergedTemplates = false;
    /**
     * compile tag objects
     *
     * @var array
     */
    public static $_tag_objects = array();
    /**
     * tag stack
     *
     * @var array
     */
    public $_tag_stack = array();
    /**
     * current template
     *
     * @var Smarty_Internal_Template
     */
    public $template = null;
    /**
     * merged templates
     *
     * @var array
     */
    public $merged_templates = array();
    /**
     * flag when compiling {block}
     *
     * @var bool
     */
    public $inheritance = false;
    /**
     * plugins loaded by default plugin handler
     *
     * @var array
     */
    public $default_handler_plugins = array();
    /**
     * saved preprocessed modifier list
     *
     * @var mixed
     */
    public $default_modifier_list = null;
    /**
     * force compilation of complete template as nocache
     * @var boolean
     */
    public $forceNocache = false;
    /**
     * suppress Smarty header code in compiled template
     * @var bool
     */
    public $suppressHeader = false;
    /**
     * suppress template property header code in compiled template
     * @var bool
     */
    public $suppressTemplatePropertyHeader = false;
    /**
     * flag if compiled template file shall we written
     * @var bool
     */
    public $write_compiled_code = true;
    /**
     * flag if currently a template function is compiled
     * @var bool
     */
    public $compiles_template_function = false;
    /**
     * called subfuntions from template function
     * @var array
     */
    public $called_functions = array();
    /**
     * flags for used modifier plugins
     * @var array
     */
    public $modifier_plugins = array();

    /**
     * Initialize compiler
     */
    public function __construct()
    {
        $this->nocache_hash = str_replace('.', '-', uniqid(rand(), true));
    }

    /**
     * Method to compile a Smarty template
     *
     * @param  Smarty_Internal_Template $template template object to compile
     * @return bool true if compiling succeeded, false if it failed
     */
    public function compileTemplate(Smarty_Internal_Template $template)
    {
        if (empty($template->properties['nocache_hash'])) {
            $template->properties['nocache_hash'] = $this->nocache_hash;
        } else {
            $this->nocache_hash = $template->properties['nocache_hash'];
        }
        // flag for nochache sections
        $this->nocache = false;
        $this->tag_nocache = false;
        // save template object in compiler class
        $this->template = $template;
        // reset has noche code flag
        $this->template->has_nocache_code = false; 
        $this->smarty->_current_file = $saved_filepath = $this->template->source->filepath;
        // template header code
        $template_header = '';
        if (!$this->suppressHeader) {
            $template_header .= "<?php /* Smarty version " . Smarty::SMARTY_VERSION . ", created on " . strftime("%Y-%m-%d %H:%M:%S") . "\n";
            $template_header .= "         compiled from \"" . $this->template->source->filepath . "\" */ ?>\n";
        }

        do {
            // flag for aborting current and start recompile
            $this->abort_and_recompile = false;
            // get template source
            $_content = $template->source->content;
            // run prefilter if required
            if (isset($this->smarty->autoload_filters['pre']) || isset($this->smarty->registered_filters['pre'])) {
                $template->source->content = $_content = Smarty_Internal_Filter_Handler::runFilter('pre', $_content, $template);
            }
            // on empty template just return header
            if ($_content == '') {
                if ($this->suppressTemplatePropertyHeader) {
                    $code = '';
                } else {
                    $code = $template_header . $template->createTemplateCodeFrame();
                }
                return $code;
            }
            // call compiler
            $_compiled_code = $this->doCompile($_content);
        } while ($this->abort_and_recompile);
        $this->template->source->filepath = $saved_filepath;
        // free memory
        unset($this->parser->root_buffer, $this->parser->current_buffer, $this->parser, $this->lex, $this->template);
        self::$_tag_objects = array();
        // return compiled code to template object
        $merged_code = '';
        if (!$this->suppressMergedTemplates) {
            foreach ($this->merged_templates as $code) {
                $merged_code .= $code;
            }
        }
        if ($this->suppressTemplatePropertyHeader) {
            $code = $_compiled_code . $merged_code;
        } else {
            $code = $template_header . $template->createTemplateCodeFrame($_compiled_code) . $merged_code;
        }
        // run postfilter if required
        if (isset($this->smarty->autoload_filters['post']) || isset($this->smarty->registered_filters['post'])) {
            $code = Smarty_Internal_Filter_Handler::runFilter('post', $code, $template);
        }
        return $code;
    }

    /**
     * Compile Tag
     *
     * This is a call back from the lexer/parser
     * It executes the required compile plugin for the Smarty tag
     *
     * @param string $tag       tag name
     * @param array  $args      array with tag attributes
     * @param array  $parameter array with compilation parameter
     * @return string compiled code
     */
    public function compileTag($tag, $args, $parameter = array())
    {
        // $args contains the attributes parsed and compiled by the lexer/parser
        // assume that tag does compile into code, but creates no HTML output
        $this->has_code = true;
        $this->has_output = false;
        // log tag/attributes
        if (isset($this->smarty->get_used_tags) && $this->smarty->get_used_tags) {
            $this->template->used_tags[] = array($tag, $args);
        }
        // check nocache option flag
        if (in_array("'nocache'",$args) || in_array(array('nocache'=>'true'),$args)
        || in_array(array('nocache'=>'"true"'),$args) || in_array(array('nocache'=>"'true'"),$args)) {
            $this->tag_nocache = true;
        }
        // compile the smarty tag (required compile classes to compile the tag are autoloaded)
        if (($_output = $this->callTagCompiler($tag, $args, $parameter)) === false) {
            if (isset($this->smarty->template_functions[$tag])) {
                // template defined by {template} tag
                $args['_attr']['name'] = "'" . $tag . "'";
                $_output = $this->callTagCompiler('call', $args, $parameter);
            }
        }
        if ($_output !== false) {
            if ($_output !== true) {
                // did we get compiled code
                if ($this->has_code) {
                    // Does it create output?
                    if ($this->has_output) {
                        $_output .= "\n";
                    }
                    // return compiled code
                    return $_output;
                }
            }
            // tag did not produce compiled code
            return '';
        } else {
            // map_named attributes
            if (isset($args['_attr'])) {
                foreach ($args['_attr'] as $key => $attribute) {
                    if (is_array($attribute)) {
                        $args = array_merge($args, $attribute);
                    }
                }
            }
            // not an internal compiler tag
            if (strlen($tag) < 6 || substr($tag, -5) != 'close') {
                // check if tag is a registered object
                if (isset($this->smarty->registered_objects[$tag]) && isset($parameter['object_methode'])) {
                    $methode = $parameter['object_methode'];
                    if (!in_array($methode, $this->smarty->registered_objects[$tag][3]) &&
                    (empty($this->smarty->registered_objects[$tag][1]) || in_array($methode, $this->smarty->registered_objects[$tag][1]))) {
                        return $this->callTagCompiler('private_object_function', $args, $parameter, $tag, $methode);
                    } elseif (in_array($methode, $this->smarty->registered_objects[$tag][3])) {
                        return $this->callTagCompiler('private_object_block_function', $args, $parameter, $tag, $methode);
                    } else {
                        return $this->trigger_template_error ('unallowed methode "' . $methode . '" in registered object "' . $tag . '"', $this->lex->taglineno);
                    }
                }
                // check if tag is registered
                foreach (array(Smarty::PLUGIN_COMPILER, Smarty::PLUGIN_FUNCTION, Smarty::PLUGIN_BLOCK) as $plugin_type) {
                    if (isset($this->smarty->registered_plugins[$plugin_type][$tag])) {
                        // if compiler function plugin call it now
                        if ($plugin_type == Smarty::PLUGIN_COMPILER) {
                            $new_args = array();
                            foreach ($args as $key => $mixed) {
                            	if (is_array($mixed)) {
                                	$new_args = array_merge($new_args, $mixed);
                                } else {
                                	$new_args[$key] = $mixed;
                                }
                            }
                            if (!$this->smarty->registered_plugins[$plugin_type][$tag][1]) {
                                $this->tag_nocache = true;
                            }
                            $function = $this->smarty->registered_plugins[$plugin_type][$tag][0];
                            if (!is_array($function)) {
                                return $function($new_args, $this);
                            } else if (is_object($function[0])) {
                                return $this->smarty->registered_plugins[$plugin_type][$tag][0][0]->$function[1]($new_args, $this);
                            } else {
                                return call_user_func_array($function, array($new_args, $this));
                            }
                        }
                        // compile registered function or block function
                        if ($plugin_type == Smarty::PLUGIN_FUNCTION || $plugin_type == Smarty::PLUGIN_BLOCK) {
                            return $this->callTagCompiler('private_registered_' . $plugin_type, $args, $parameter, $tag);
                        }

                    }
                }
                // check plugins from plugins folder
                foreach ($this->smarty->plugin_search_order as $plugin_type) {
                    if ($plugin_type == Smarty::PLUGIN_BLOCK && $this->smarty->loadPlugin('smarty_compiler_' . $tag) && (!isset($this->smarty->security_policy) || $this->smarty->security_policy->isTrustedTag($tag, $this))) {
                        $plugin = 'smarty_compiler_' . $tag;
                        if (is_callable($plugin)) {
                            // convert arguments format for old compiler plugins
                            $new_args = array();
                            foreach ($args as $key => $mixed) {
                            	if (is_array($mixed)) {
                                	$new_args = array_merge($new_args, $mixed);
                                } else {
                                	$new_args[$key] = $mixed;
                                }
                            }
                            return $plugin($new_args, $this->smarty);
                        }
                        if (class_exists($plugin, false)) {
                            $plugin_object = new $plugin;
                            if (method_exists($plugin_object, 'compile')) {
                                return $plugin_object->compile($args, $this);
                            }
                        }
                        throw new SmartyException("Plugin \"{$tag}\" not callable");
                    } else {
                        if ($function = $this->getPlugin($tag, $plugin_type)) {
                            if(!isset($this->smarty->security_policy) || $this->smarty->security_policy->isTrustedTag($tag, $this)) {
                                return $this->callTagCompiler('private_' . $plugin_type . '_plugin', $args, $parameter, $tag, $function);
                            }
                        }
                    }
                }
                if (is_callable($this->smarty->default_plugin_handler_func)) {
                    $found = false;
                    // look for already resolved tags
                    foreach ($this->smarty->plugin_search_order as $plugin_type) {
                        if (isset($this->default_handler_plugins[$plugin_type][$tag])) {
                            $found = true;
                            break;
                        }
                    }
                    if (!$found) {
                        // call default handler
                        foreach ($this->smarty->plugin_search_order as $plugin_type) {
                            if ($this->getPluginFromDefaultHandler($tag, $plugin_type)) {
                                $found = true;
                                break;
                            }
                        }
                    }
                    if ($found) {
                        // if compiler function plugin call it now
                        if ($plugin_type == Smarty::PLUGIN_COMPILER) {
                            $new_args = array();
                            foreach ($args as $mixed) {
                                $new_args = array_merge($new_args, $mixed);
                            }
                            $function = $this->default_handler_plugins[$plugin_type][$tag][0];
                            if (!is_array($function)) {
                                return $function($new_args, $this);
                            } else if (is_object($function[0])) {
                                return $this->default_handler_plugins[$plugin_type][$tag][0][0]->$function[1]($new_args, $this);
                            } else {
                                return call_user_func_array($function, array($new_args, $this));
                            }
                        } else {
                            return $this->callTagCompiler('private_registered_' . $plugin_type, $args, $parameter, $tag);
                        }
                    }
                }
            } else {
                // compile closing tag of block function
                $base_tag = substr($tag, 0, -5);
                // check if closing tag is a registered object
                if (isset($this->smarty->registered_objects[$base_tag]) && isset($parameter['object_methode'])) {
                    $methode = $parameter['object_methode'];
                    if (in_array($methode, $this->smarty->registered_objects[$base_tag][3])) {
                        return $this->callTagCompiler('private_object_block_function', $args, $parameter, $tag, $methode);
                    } else {
                        return $this->trigger_template_error ('unallowed closing tag methode "' . $methode . '" in registered object "' . $base_tag . '"', $this->lex->taglineno);
                    }
                }
                // registered block tag ?
                if (isset($this->smarty->registered_plugins[Smarty::PLUGIN_BLOCK][$base_tag]) || isset($this->default_handler_plugins[Smarty::PLUGIN_BLOCK][$base_tag])) {
                    return $this->callTagCompiler('private_registered_block', $args, $parameter, $tag);
                }
                // block plugin?
                if ($function = $this->getPlugin($base_tag, Smarty::PLUGIN_BLOCK)) {
                    return $this->callTagCompiler('private_block_plugin', $args, $parameter, $tag, $function);
                }
                if ($this->smarty->loadPlugin('smarty_compiler_' . $tag)) {
                    $plugin = 'smarty_compiler_' . $tag;
                    if (is_callable($plugin)) {
                        return $plugin($args, $this->smarty);
                    }
                    if (class_exists($plugin, false)) {
                        $plugin_object = new $plugin;
                        if (method_exists($plugin_object, 'compile')) {
                            return $plugin_object->compile($args, $this);
                        }
                    }
                    throw new SmartyException("Plugin \"{$tag}\" not callable");
                }
            }
            $this->trigger_template_error ("unknown tag \"" . $tag . "\"", $this->lex->taglineno);
        }
    }

    /**
     * lazy loads internal compile plugin for tag and calls the compile methode
     *
     * compile objects cached for reuse.
     * class name format:  Smarty_Internal_Compile_TagName
     * plugin filename format: Smarty_Internal_Tagname.php
     *
     * @param string $tag   tag name
     * @param array $args   list of tag attributes
     * @param mixed $param1 optional parameter
     * @param mixed $param2 optional parameter
     * @param mixed $param3 optional parameter
     * @return string compiled code
     */
    public function callTagCompiler($tag, $args, $param1 = null, $param2 = null, $param3 = null)
    {
        // re-use object if already exists
        if (isset(self::$_tag_objects[$tag])) {
            // compile this tag
            return self::$_tag_objects[$tag]->compile($args, $this, $param1, $param2, $param3);
        }
        // lazy load internal compiler plugin
        $class_name = 'Smarty_Internal_Compile_' . $tag;
        if ($this->smarty->loadPlugin($class_name)) {
            // check if tag allowed by security
            if (!isset($this->smarty->security_policy) || $this->smarty->security_policy->isTrustedTag($tag, $this)) {
            // use plugin if found
            self::$_tag_objects[$tag] = new $class_name;
            // compile this tag
            return self::$_tag_objects[$tag]->compile($args, $this, $param1, $param2, $param3);
            }
        }
        // no internal compile plugin for this tag
        return false;
    }

    /**
     * Check for plugins and return function name
     *
     * @param string $pugin_name  name of plugin or function
     * @param string $plugin_type type of plugin
     * @return string call name of function
     */
    public function getPlugin($plugin_name, $plugin_type)
    {
        $function = null;
        if ($this->template->caching && ($this->nocache || $this->tag_nocache)) {
            if (isset($this->template->required_plugins['nocache'][$plugin_name][$plugin_type])) {
                $function = $this->template->required_plugins['nocache'][$plugin_name][$plugin_type]['function'];
            } else if (isset($this->template->required_plugins['compiled'][$plugin_name][$plugin_type])) {
                $this->template->required_plugins['nocache'][$plugin_name][$plugin_type] = $this->template->required_plugins['compiled'][$plugin_name][$plugin_type];
                $function = $this->template->required_plugins['nocache'][$plugin_name][$plugin_type]['function'];
            }
        } else {
            if (isset($this->template->required_plugins['compiled'][$plugin_name][$plugin_type])) {
                $function = $this->template->required_plugins['compiled'][$plugin_name][$plugin_type]['function'];
            } else if (isset($this->template->required_plugins['nocache'][$plugin_name][$plugin_type])) {
                $this->template->required_plugins['compiled'][$plugin_name][$plugin_type] = $this->template->required_plugins['nocache'][$plugin_name][$plugin_type];
                $function = $this->template->required_plugins['compiled'][$plugin_name][$plugin_type]['function'];
            }
        }
        if (isset($function)) {
            if ($plugin_type == 'modifier') {
                $this->modifier_plugins[$plugin_name] = true;
            }
            return $function;
        }
        // loop through plugin dirs and find the plugin
        $function = 'smarty_' . $plugin_type . '_' . $plugin_name;
        $file = $this->smarty->loadPlugin($function, false);

        if (is_string($file)) {
            if ($this->template->caching && ($this->nocache || $this->tag_nocache)) {
                $this->template->required_plugins['nocache'][$plugin_name][$plugin_type]['file'] = $file;
                $this->template->required_plugins['nocache'][$plugin_name][$plugin_type]['function'] = $function;
            } else {
                $this->template->required_plugins['compiled'][$plugin_name][$plugin_type]['file'] = $file;
                $this->template->required_plugins['compiled'][$plugin_name][$plugin_type]['function'] = $function;
            }
            if ($plugin_type == 'modifier') {
                $this->modifier_plugins[$plugin_name] = true;
            }
            return $function;
        }
        if (is_callable($function)) {
            // plugin function is defined in the script
            return $function;
        }
        return false;
    }

    /**
     * Check for plugins by default plugin handler
     *
     * @param string $tag         name of tag
     * @param string $plugin_type type of plugin
     * @return boolean true if found
     */
    public function getPluginFromDefaultHandler($tag, $plugin_type)
    {
        $callback = null;
        $script = null;
        $result = call_user_func_array(
            $this->smarty->default_plugin_handler_func,
            array($tag, $plugin_type, $this->template, &$callback, &$script)
        );
        if ($result) {
            if ($script !== null) {
                if (is_file($script)) {
                    if ($this->template->caching && ($this->nocache || $this->tag_nocache)) {
                        $this->template->required_plugins['nocache'][$tag][$plugin_type]['file'] = $script;
                        $this->template->required_plugins['nocache'][$tag][$plugin_type]['function'] = $callback;
                    } else {
                        $this->template->required_plugins['compiled'][$tag][$plugin_type]['file'] = $script;
                        $this->template->required_plugins['compiled'][$tag][$plugin_type]['function'] = $callback;
                    }
                    include_once $script;
                }  else {
                    throw new SmartyCompilerException("Plugin or modifer script file $script not found");
                }
            }
            if (is_callable($callback)) {
                $this->default_handler_plugins[$plugin_type][$tag] = array($callback, true, array());
                return true;
            } else {
                throw new SmartyCompilerException("Function for plugin or modifier $tag not callable");
            }
        }
        return false;
    }

    /**
     * Inject inline code for nocache template sections
     *
     * This method gets the content of each template element from the parser.
     * If the content is compiled code and it should be not cached the code is injected
     * into the rendered output.
     *
     * @param string  $content content of template element
     * @param boolean $is_code true if content is compiled code
     * @return string content
     */
    public function processNocacheCode($content, $is_code)
    {
        // If the template is not evaluated and we have a nocache section and or a nocache tag
        if ($is_code && !empty($content)) {
            // generate replacement code
            if ((!($this->template->source->recompiled) || $this->forceNocache) && $this->template->caching && !$this->suppressNocacheProcessing &&
            ($this->nocache || $this->tag_nocache || $this->forceNocache == 2)) {
                $this->template->has_nocache_code = true;
                $_output = str_replace("'", "\'", $content);
                $_output = str_replace('\\\\', '\\\\\\\\', $_output);
                $_output = str_replace("^#^", "'", $_output);
                $_output = "<?php echo '/*%%SmartyNocache:{$this->nocache_hash}%%*/" . $_output . "/*/%%SmartyNocache:{$this->nocache_hash}%%*/';?>\n";
                // make sure we include modifer plugins for nocache code
                foreach ($this->modifier_plugins as $plugin_name => $dummy) {
                    if (isset($this->template->required_plugins['compiled'][$plugin_name]['modifier'])) {
                        $this->template->required_plugins['nocache'][$plugin_name]['modifier'] = $this->template->required_plugins['compiled'][$plugin_name]['modifier'];
                    }
                }
            } else {
                $_output = $content;
            }
        } else {
            $_output = $content;
        }
        $this->suppressNocacheProcessing = false;
        $this->tag_nocache = false;
        return $_output;
    }

    /**
     * display compiler error messages without dying
     *
     * If parameter $args is empty it is a parser detected syntax error.
     * In this case the parser is called to obtain information about expected tokens.
     *
     * If parameter $args contains a string this is used as error message
     *
     * @param string $args individual error message or null
     * @param string $line line-number
     * @throws SmartyCompilerException when an unexpected token is found
     */
    public function trigger_template_error($args = null, $line = null)
    {
        // get template source line which has error
        if (!isset($line)) {
            $line = $this->lex->line;
        }
        $match = preg_split("/\n/", $this->lex->data);
        $error_text = 'Syntax Error in template "' . $this->template->source->filepath . '"  on line ' . $line . ' "' . htmlspecialchars(trim(preg_replace('![\t\r\n]+!',' ',$match[$line-1]))) . '" ';
        if (isset($args)) {
            // individual error message
            $error_text .= $args;
        } else {
            // expected token from parser
            $error_text .= ' - Unexpected "' . $this->lex->value.'"';
            if (count($this->parser->yy_get_expected_tokens($this->parser->yymajor)) <= 4 ) {
                foreach ($this->parser->yy_get_expected_tokens($this->parser->yymajor) as $token) {
                    $exp_token = $this->parser->yyTokenName[$token];
                    if (isset($this->lex->smarty_token_names[$exp_token])) {
                        // token type from lexer
                        $expect[] = '"' . $this->lex->smarty_token_names[$exp_token] . '"';
                    } else {
                        // otherwise internal token name
                        $expect[] = $this->parser->yyTokenName[$token];
                    }
                }
                $error_text .= ', expected one of: ' . implode(' , ', $expect);
            }
        }
        throw new SmartyCompilerException($error_text);
    }

}

?><?php
/**
 * Smarty Internal Plugin Resource File
 *
 * @package Smarty
 * @subpackage TemplateResources
 * @author Uwe Tews
 * @author Rodney Rehm
 */

/**
 * Smarty Internal Plugin Resource File
 *
 * Implements the file system as resource for Smarty templates
 *
 * @package Smarty
 * @subpackage TemplateResources
 */
class Smarty_Internal_Resource_File extends Smarty_Resource {

    /**
     * populate Source Object with meta data from Resource
     *
     * @param Smarty_Template_Source   $source    source object
     * @param Smarty_Internal_Template $_template template object
     */
    public function populate(Smarty_Template_Source $source, Smarty_Internal_Template $_template=null)
    {
        $source->filepath = $this->buildFilepath($source, $_template);

        if ($source->filepath !== false) {
            if (is_object($source->smarty->security_policy)) {
                $source->smarty->security_policy->isTrustedResourceDir($source->filepath);
            }

            $source->uid = sha1($source->filepath);
            if ($source->smarty->compile_check && !isset($source->timestamp)) {
                $source->timestamp = @filemtime($source->filepath);
                $source->exists = !!$source->timestamp;
            }
        }
    }

    /**
     * populate Source Object with timestamp and exists from Resource
     *
     * @param Smarty_Template_Source $source source object
     */
    public function populateTimestamp(Smarty_Template_Source $source)
    {
        $source->timestamp = @filemtime($source->filepath);
        $source->exists = !!$source->timestamp;
    }

    /**
     * Load template's source from file into current template object
     *
     * @param Smarty_Template_Source $source source object
     * @return string template source
     * @throws SmartyException if source cannot be loaded
     */
    public function getContent(Smarty_Template_Source $source)
    {
        if ($source->timestamp) {
            return file_get_contents($source->filepath);
        }
        if ($source instanceof Smarty_Config_Source) {
            throw new SmartyException("Unable to read config {$source->type} '{$source->name}'");
        }
        throw new SmartyException("Unable to read template {$source->type} '{$source->name}'");
    }

    /**
     * Determine basename for compiled filename
     *
     * @param Smarty_Template_Source $source source object
     * @return string resource's basename
     */
    public function getBasename(Smarty_Template_Source $source)
    {
        $_file = $source->name;
        if (($_pos = strpos($_file, ']')) !== false) {
            $_file = substr($_file, $_pos + 1);
        }
        return basename($_file);
    }

}

?><?php
/**
 * Smarty Internal Plugin Compile Capture
 *
 * Compiles the {capture} tag
 *
 * @package Smarty
 * @subpackage Compiler
 * @author Uwe Tews
 */

/**
 * Smarty Internal Plugin Compile Capture Class
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_Capture extends Smarty_Internal_CompileBase {

    /**
     * Attribute definition: Overwrites base class.
     *
     * @var array
     * @see Smarty_Internal_CompileBase
     */
    public $shorttag_order = array('name');
    /**
     * Attribute definition: Overwrites base class.
     *
     * @var array
     * @see Smarty_Internal_CompileBase
     */
    public $optional_attributes = array('name', 'assign', 'append');

    /**
     * Compiles code for the {capture} tag
     *
     * @param array  $args     array with attributes from parser
     * @param object $compiler compiler object
     * @return string compiled code
     */
    public function compile($args, $compiler)
    {
        // check and get attributes
        $_attr = $this->getAttributes($compiler, $args);

        $buffer = isset($_attr['name']) ? $_attr['name'] : "'default'";
        $assign = isset($_attr['assign']) ? $_attr['assign'] : 'null';
        $append = isset($_attr['append']) ? $_attr['append'] : 'null';

        $compiler->_capture_stack[] = array($buffer, $assign, $append, $compiler->nocache);
        // maybe nocache because of nocache variables
        $compiler->nocache = $compiler->nocache | $compiler->tag_nocache;
        $_output = "<?php \$_smarty_tpl->_capture_stack[] = array($buffer, $assign, $append); ob_start(); ?>";

        return $_output;
    }

}

/**
 * Smarty Internal Plugin Compile Captureclose Class
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_CaptureClose extends Smarty_Internal_CompileBase {

    /**
     * Compiles code for the {/capture} tag
     *
     * @param array  $args     array with attributes from parser
     * @param object $compiler compiler object
     * @return string compiled code
     */
    public function compile($args, $compiler)
    {
        // check and get attributes
        $_attr = $this->getAttributes($compiler, $args);
        // must endblock be nocache?
        if ($compiler->nocache) {
            $compiler->tag_nocache = true;
        }

        list($buffer, $assign, $append, $compiler->nocache) = array_pop($compiler->_capture_stack);

        $_output = "<?php list(\$_capture_buffer, \$_capture_assign, \$_capture_append) = array_pop(\$_smarty_tpl->_capture_stack);\n";
        $_output .= "if (!empty(\$_capture_buffer)) {\n";
        $_output .= " if (isset(\$_capture_assign)) \$_smarty_tpl->assign(\$_capture_assign, ob_get_contents());\n";
        $_output .= " if (isset( \$_capture_append)) \$_smarty_tpl->append( \$_capture_append, ob_get_contents());\n";
        $_output .= " Smarty::\$_smarty_vars['capture'][\$_capture_buffer]=ob_get_clean();\n";
        $_output .= "} else \$_smarty_tpl->capture_error();?>";
        return $_output;
    }

}

?><?php
/**
 * Smarty Internal Plugin Compile Block Plugin
 *
 * Compiles code for the execution of block plugin
 *
 * @package Smarty
 * @subpackage Compiler
 * @author Uwe Tews
 */

/**
 * Smarty Internal Plugin Compile Block Plugin Class
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_Private_Block_Plugin extends Smarty_Internal_CompileBase {

    /**
     * Attribute definition: Overwrites base class.
     *
     * @var array
     * @see Smarty_Internal_CompileBase
     */
    public $optional_attributes = array('_any');

    /**
     * Compiles code for the execution of block plugin
     *
     * @param array  $args      array with attributes from parser
     * @param object $compiler  compiler object
     * @param array  $parameter array with compilation parameter
     * @param string $tag       name of block plugin
     * @param string $function  PHP function name
     * @return string compiled code
     */
    public function compile($args, $compiler, $parameter, $tag, $function)
    {
        if (!isset($tag[5]) || substr($tag, -5) != 'close') {
            // opening tag of block plugin
            // check and get attributes
            $_attr = $this->getAttributes($compiler, $args);
            if ($_attr['nocache'] === true) {
                $compiler->tag_nocache = true;
            }
               unset($_attr['nocache']);
            // convert attributes into parameter array string
            $_paramsArray = array();
            foreach ($_attr as $_key => $_value) {
                if (is_int($_key)) {
                    $_paramsArray[] = "$_key=>$_value";
                } else {
                    $_paramsArray[] = "'$_key'=>$_value";
                }
            }
            $_params = 'array(' . implode(",", $_paramsArray) . ')';

            $this->openTag($compiler, $tag, array($_params, $compiler->nocache));
            // maybe nocache because of nocache variables or nocache plugin
            $compiler->nocache = $compiler->nocache | $compiler->tag_nocache;
            // compile code
            $output = "<?php \$_smarty_tpl->smarty->_tag_stack[] = array('{$tag}', {$_params}); \$_block_repeat=true; echo {$function}({$_params}, null, \$_smarty_tpl, \$_block_repeat);while (\$_block_repeat) { ob_start();?>";
        } else {
            // must endblock be nocache?
            if ($compiler->nocache) {
                $compiler->tag_nocache = true;
            }
            // closing tag of block plugin, restore nocache
            list($_params, $compiler->nocache) = $this->closeTag($compiler, substr($tag, 0, -5));
            // This tag does create output
            $compiler->has_output = true;
            // compile code
            if (!isset($parameter['modifier_list'])) {
                $mod_pre = $mod_post ='';
            } else {
                $mod_pre = ' ob_start(); ';
                $mod_post = 'echo '.$compiler->compileTag('private_modifier',array(),array('modifierlist'=>$parameter['modifier_list'],'value'=>'ob_get_clean()')).';';
            }
            $output = "<?php \$_block_content = ob_get_clean(); \$_block_repeat=false;".$mod_pre." echo {$function}({$_params}, \$_block_content, \$_smarty_tpl, \$_block_repeat); ".$mod_post." } array_pop(\$_smarty_tpl->smarty->_tag_stack);?>";
        }
        return $output . "\n";
    }

}

?><?php
/**
 * Smarty Internal Plugin Template
 *
 * This file contains the Smarty template engine
 *
 * @package Smarty
 * @subpackage Template
 * @author Uwe Tews
 */

/**
 * Main class with template data structures and methods
 *
 * @package Smarty
 * @subpackage Template
 *
 * @property Smarty_Template_Source   $source
 * @property Smarty_Template_Compiled $compiled
 * @property Smarty_Template_Cached   $cached
 */
class Smarty_Internal_Template extends Smarty_Internal_TemplateBase {

    /**
     * cache_id
     * @var string
     */
    public $cache_id = null;
    /**
     * $compile_id
     * @var string
     */
    public $compile_id = null;
    /**
     * caching enabled
     * @var boolean
     */
    public $caching = null;
    /**
     * cache lifetime in seconds
     * @var integer
     */
    public $cache_lifetime = null;
    /**
     * Template resource
     * @var string
     */
    public $template_resource = null;
    /**
     * flag if compiled template is invalid and must be (re)compiled
     * @var bool
     */
    public $mustCompile = null;
    /**
     * flag if template does contain nocache code sections
     * @var bool
     */
    public $has_nocache_code = false;
    /**
     * special compiled and cached template properties
     * @var array
     */
    public $properties = array('file_dependency' => array(),
        'nocache_hash' => '',
        'function' => array());
    /**
     * required plugins
     * @var array
     */
    public $required_plugins = array('compiled' => array(), 'nocache' => array());
    /**
     * Global smarty instance
     * @var Smarty
     */
    public $smarty = null;
    /**
     * blocks for template inheritance
     * @var array
     */
    public $block_data = array();
    /**
     * variable filters
     * @var array
     */
    public $variable_filters = array();
    /**
     * optional log of tag/attributes
     * @var array
     */
    public $used_tags = array();
    /**
     * internal flag to allow relative path in child template blocks
     * @var bool
     */
    public $allow_relative_path = false;
    /**
     * internal capture runtime stack
     * @var array
     */
    public $_capture_stack = array();

    /**
     * Create template data object
     *
     * Some of the global Smarty settings copied to template scope
     * It load the required template resources and cacher plugins
     *
     * @param string                   $template_resource template resource string
     * @param Smarty                   $smarty            Smarty instance
     * @param Smarty_Internal_Template $_parent           back pointer to parent object with variables or null
     * @param mixed                    $_cache_id cache   id or null
     * @param mixed                    $_compile_id       compile id or null
     * @param bool                     $_caching          use caching?
     * @param int                      $_cache_lifetime   cache life-time in seconds
     */
    public function __construct($template_resource, $smarty, $_parent = null, $_cache_id = null, $_compile_id = null, $_caching = null, $_cache_lifetime = null)
    {
        $this->smarty = &$smarty;
        // Smarty parameter
        $this->cache_id = $_cache_id === null ? $this->smarty->cache_id : $_cache_id;
        $this->compile_id = $_compile_id === null ? $this->smarty->compile_id : $_compile_id;
        $this->caching = $_caching === null ? $this->smarty->caching : $_caching;
        if ($this->caching === true)
            $this->caching = Smarty::CACHING_LIFETIME_CURRENT;
        $this->cache_lifetime = $_cache_lifetime === null ? $this->smarty->cache_lifetime : $_cache_lifetime;
        $this->parent = $_parent;
        // Template resource
        $this->template_resource = $template_resource;
        // copy block data of template inheritance
        if ($this->parent instanceof Smarty_Internal_Template) {
            $this->block_data = $this->parent->block_data;
        }
    }

    /**
     * Returns if the current template must be compiled by the Smarty compiler
     *
     * It does compare the timestamps of template source and the compiled templates and checks the force compile configuration
     *
     * @return boolean true if the template must be compiled
     */
    public function mustCompile()
    {
        if (!$this->source->exists) {
            if ($this->parent instanceof Smarty_Internal_Template) {
                $parent_resource = " in '$this->parent->template_resource}'";
            } else {
                $parent_resource = '';
            }
            throw new SmartyException("Unable to load template {$this->source->type} '{$this->source->name}'{$parent_resource}");
        }
        if ($this->mustCompile === null) {
            $this->mustCompile = (!$this->source->uncompiled && ($this->smarty->force_compile || $this->source->recompiled || $this->compiled->timestamp === false ||
                    ($this->smarty->compile_check && $this->compiled->timestamp < $this->source->timestamp)));
        }
        return $this->mustCompile;
    }

    /**
     * Compiles the template
     *
     * If the template is not evaluated the compiled template is saved on disk
     */
    public function compileTemplateSource()
    {
        if (!$this->source->recompiled) {
            $this->properties['file_dependency'] = array();
            if ($this->source->components) {
                // uses real resource for file dependency
                $source = end($this->source->components);
                $this->properties['file_dependency'][$this->source->uid] = array($this->source->filepath, $this->source->timestamp, $source->type);
            } else {
                $this->properties['file_dependency'][$this->source->uid] = array($this->source->filepath, $this->source->timestamp, $this->source->type);
            }
        }
        if ($this->smarty->debugging) {
            Smarty_Internal_Debug::start_compile($this);
        }
        // compile locking
        if ($this->smarty->compile_locking && !$this->source->recompiled) {
            if ($saved_timestamp = $this->compiled->timestamp) {
                touch($this->compiled->filepath);
            }
        }
        // call compiler
        try {
            $code = $this->compiler->compileTemplate($this);
        } catch (Exception $e) {
            // restore old timestamp in case of error
            if ($this->smarty->compile_locking && !$this->source->recompiled && $saved_timestamp) {
                touch($this->compiled->filepath, $saved_timestamp);
            }
            throw $e;
        }
        // compiling succeded
        if (!$this->source->recompiled && $this->compiler->write_compiled_code) {
            // write compiled template
            $_filepath = $this->compiled->filepath;
            if ($_filepath === false)
                throw new SmartyException('getCompiledFilepath() did not return a destination to save the compiled template to');
            Smarty_Internal_Write_File::writeFile($_filepath, $code, $this->smarty);
            $this->compiled->exists = true;
            $this->compiled->isCompiled = true;
        }
        if ($this->smarty->debugging) {
            Smarty_Internal_Debug::end_compile($this);
        }
        // release compiler object to free memory
        unset($this->compiler);
    }

    /**
     * Writes the cached template output
     *
     * @return bool
     */
    public function writeCachedContent($content)
    {
        if ($this->source->recompiled || !($this->caching == Smarty::CACHING_LIFETIME_CURRENT || $this->caching == Smarty::CACHING_LIFETIME_SAVED)) {
            // don't write cache file
            return false;
        }
        $this->properties['cache_lifetime'] = $this->cache_lifetime;
        $this->properties['unifunc'] = 'content_' . uniqid();
        $content = $this->createTemplateCodeFrame($content, true);
        $_smarty_tpl = $this;
        eval("?>" . $content);
        $this->cached->valid = true;
        $this->cached->processed = true;
        return $this->cached->write($this, $content);
    }

    /**
     * Template code runtime function to get subtemplate content
     *
     * @param string  $template       the resource handle of the template file
     * @param mixed   $cache_id       cache id to be used with this template
     * @param mixed   $compile_id     compile id to be used with this template
     * @param integer $caching        cache mode
     * @param integer $cache_lifetime life time of cache data
     * @param array   $vars optional  variables to assign
     * @param int     $parent_scope   scope in which {include} should execute
     * @returns string template content
     */
    public function getSubTemplate($template, $cache_id, $compile_id, $caching, $cache_lifetime, $data, $parent_scope)
    {
        // already in template cache?
        $unique_template_name = Smarty_Resource::getUniqueTemplateName($this->smarty, $template);
        $_templateId =  sha1($unique_template_name . $cache_id . $compile_id);
        if (isset($this->smarty->template_objects[$_templateId])) {
            // clone cached template object because of possible recursive call
            $tpl = clone $this->smarty->template_objects[$_templateId];
            $tpl->parent = $this;
            $tpl->caching = $caching;
            $tpl->cache_lifetime = $cache_lifetime;
        } else {
            $tpl = new $this->smarty->template_class($template, $this->smarty, $this, $cache_id, $compile_id, $caching, $cache_lifetime);
        }
        // get variables from calling scope
        if ($parent_scope == Smarty::SCOPE_LOCAL) {
            $tpl->tpl_vars = $this->tpl_vars;
        } elseif ($parent_scope == Smarty::SCOPE_PARENT) {
            $tpl->tpl_vars = &$this->tpl_vars;
        } elseif ($parent_scope == Smarty::SCOPE_GLOBAL) {
            $tpl->tpl_vars = &Smarty::$global_tpl_vars;
        } elseif (($scope_ptr = $this->getScopePointer($parent_scope)) == null) {
            $tpl->tpl_vars = &$this->tpl_vars;
        } else {
            $tpl->tpl_vars = &$scope_ptr->tpl_vars;
        }
        $tpl->config_vars = $this->config_vars;
        if (!empty($data)) {
            // set up variable values
            foreach ($data as $_key => $_val) {
                $tpl->tpl_vars[$_key] = new Smarty_variable($_val);
            }
        }
        return $tpl->fetch(null, null, null, null, false, false, true);
    }

    /**
     * Template code runtime function to set up an inline subtemplate
     *
     * @param string  $template       the resource handle of the template file
     * @param mixed   $cache_id       cache id to be used with this template
     * @param mixed   $compile_id     compile id to be used with this template
     * @param integer $caching        cache mode
     * @param integer $cache_lifetime life time of cache data
     * @param array   $vars optional  variables to assign
     * @param int     $parent_scope   scope in which {include} should execute
     * @param string  $hash           nocache hash code
     * @returns string template content
     */
    public function setupInlineSubTemplate($template, $cache_id, $compile_id, $caching, $cache_lifetime, $data, $parent_scope, $hash)
    {
        $tpl = new $this->smarty->template_class($template, $this->smarty, $this, $cache_id, $compile_id, $caching, $cache_lifetime);
        $tpl->properties['nocache_hash']  = $hash;
        // get variables from calling scope
        if ($parent_scope == Smarty::SCOPE_LOCAL ) {
            $tpl->tpl_vars = $this->tpl_vars;
        } elseif ($parent_scope == Smarty::SCOPE_PARENT) {
            $tpl->tpl_vars = &$this->tpl_vars;
        } elseif ($parent_scope == Smarty::SCOPE_GLOBAL) {
            $tpl->tpl_vars = &Smarty::$global_tpl_vars;
        } elseif (($scope_ptr = $this->getScopePointer($parent_scope)) == null) {
            $tpl->tpl_vars = &$this->tpl_vars;
        } else {
            $tpl->tpl_vars = &$scope_ptr->tpl_vars;
        }
        $tpl->config_vars = $this->config_vars;
        if (!empty($data)) {
            // set up variable values
            foreach ($data as $_key => $_val) {
                $tpl->tpl_vars[$_key] = new Smarty_variable($_val);
            }
        }
        return $tpl;
    }


    /**
     * Create code frame for compiled and cached templates
     *
     * @param string $content   optional template content
     * @param bool   $cache     flag for cache file
     * @return string
     */
    public function createTemplateCodeFrame($content = '', $cache = false)
    {
        $plugins_string = '';
        // include code for plugins
        if (!$cache) {
            if (!empty($this->required_plugins['compiled'])) {
                $plugins_string = '<?php ';
                foreach ($this->required_plugins['compiled'] as $tmp) {
                    foreach ($tmp as $data) {
                        $plugins_string .= "if (!is_callable('{$data['function']}')) include '{$data['file']}';\n";
                    }
                }
                $plugins_string .= '?>';
            }
            if (!empty($this->required_plugins['nocache'])) {
                $this->has_nocache_code = true;
                $plugins_string .= "<?php echo '/*%%SmartyNocache:{$this->properties['nocache_hash']}%%*/<?php \$_smarty = \$_smarty_tpl->smarty; ";
                foreach ($this->required_plugins['nocache'] as $tmp) {
                    foreach ($tmp as $data) {
                        $plugins_string .= "if (!is_callable(\'{$data['function']}\')) include \'{$data['file']}\';\n";
                    }
                }
                $plugins_string .= "?>/*/%%SmartyNocache:{$this->properties['nocache_hash']}%%*/';?>\n";
            }
        }
        // build property code
        $this->properties['has_nocache_code'] = $this->has_nocache_code;
        $output = '';
        if (!$this->source->recompiled) {
            $output = "<?php /*%%SmartyHeaderCode:{$this->properties['nocache_hash']}%%*/";
            if ($this->smarty->direct_access_security) {
                $output .= "if(!defined('SMARTY_DIR')) exit('no direct access allowed');\n";
            }
        }
        if ($cache) {
            // remove compiled code of{function} definition
            unset($this->properties['function']);
            if (!empty($this->smarty->template_functions)) {
                // copy code of {function} tags called in nocache mode
                foreach ($this->smarty->template_functions as $name => $function_data) {
                    if (isset($function_data['called_nocache'])) {
                        foreach ($function_data['called_functions'] as $func_name) {
                            $this->smarty->template_functions[$func_name]['called_nocache'] = true;
                        }
                    }
                }
                 foreach ($this->smarty->template_functions as $name => $function_data) {
                    if (isset($function_data['called_nocache'])) {
                        unset($function_data['called_nocache'], $function_data['called_functions'], $this->smarty->template_functions[$name]['called_nocache']);
                        $this->properties['function'][$name] = $function_data;
                    }
                }
            }
        }
        $this->properties['version'] = Smarty::SMARTY_VERSION;
        if (!isset($this->properties['unifunc'])) {
            $this->properties['unifunc'] = 'content_' . uniqid();
        }
        if (!$this->source->recompiled) {
            $output .= "\$_valid = \$_smarty_tpl->decodeProperties(" . var_export($this->properties, true) . ',' . ($cache ? 'true' : 'false') . "); /*/%%SmartyHeaderCode%%*/?>\n";
        }
        if (!$this->source->recompiled) {
            $output .= '<?php if ($_valid && !is_callable(\'' . $this->properties['unifunc'] . '\')) {function ' . $this->properties['unifunc'] . '($_smarty_tpl) {?>';
        }
        $output .= $plugins_string;
        $output .= $content;
        if (!$this->source->recompiled) {
            $output .= '<?php }} ?>';
        }
        return $output;
    }

    /**
     * This function is executed automatically when a compiled or cached template file is included
     *
     * - Decode saved properties from compiled template and cache files
     * - Check if compiled or cache file is valid
     *
     * @param array $properties     special template properties
     * @param bool  $cache          flag if called from cache file
     * @return bool                 flag if compiled or cache file is valid
     */
    public function decodeProperties($properties, $cache = false)
    {
        $this->has_nocache_code = $properties['has_nocache_code'];
        $this->properties['nocache_hash'] = $properties['nocache_hash'];
        if (isset($properties['cache_lifetime'])) {
            $this->properties['cache_lifetime'] = $properties['cache_lifetime'];
        }
        if (isset($properties['file_dependency'])) {
            $this->properties['file_dependency'] = array_merge($this->properties['file_dependency'], $properties['file_dependency']);
        }
        if (!empty($properties['function'])) {
            $this->properties['function'] = array_merge($this->properties['function'], $properties['function']);
            $this->smarty->template_functions = array_merge($this->smarty->template_functions, $properties['function']);
        }
        $this->properties['version'] = (isset($properties['version'])) ? $properties['version'] : '';
        $this->properties['unifunc'] = $properties['unifunc'];
        // check file dependencies at compiled code
        $is_valid = true;
        if ($this->properties['version'] != Smarty::SMARTY_VERSION) {
            $is_valid = false;
        } else if (((!$cache && $this->smarty->compile_check && empty($this->compiled->_properties) && !$this->compiled->isCompiled) || $cache && ($this->smarty->compile_check === true || $this->smarty->compile_check === Smarty::COMPILECHECK_ON)) && !empty($this->properties['file_dependency'])) {
            foreach ($this->properties['file_dependency'] as $_file_to_check) {
                if ($_file_to_check[2] == 'file' || $_file_to_check[2] == 'php') {
                    if ($this->source->filepath == $_file_to_check[0] && isset($this->source->timestamp)) {
                        // do not recheck current template
                        $mtime = $this->source->timestamp;
                    } else {
                        // file and php types can be checked without loading the respective resource handlers
                        $mtime = filemtime($_file_to_check[0]);
                    }
                } elseif ($_file_to_check[2] == 'string') {
                    continue;
                } else {
                    $source = Smarty_Resource::source(null, $this->smarty, $_file_to_check[0]);
                    $mtime = $source->timestamp;
                }
                if ($mtime > $_file_to_check[1]) {
                    $is_valid = false;
                    break;
                }
            }
        }
        if ($cache) {
            $this->cached->valid = $is_valid;
        } else {
            $this->mustCompile = !$is_valid;
        }
        // store data in reusable Smarty_Template_Compiled
        if (!$cache) {
            $this->compiled->_properties = $properties;
        }
        return $is_valid;
    }

    /**
     * Template code runtime function to create a local Smarty variable for array assignments
     *
     * @param string $tpl_var   tempate variable name
     * @param bool   $nocache   cache mode of variable
     * @param int    $scope     scope of variable
     */
    public function createLocalArrayVariable($tpl_var, $nocache = false, $scope = Smarty::SCOPE_LOCAL)
    {
        if (!isset($this->tpl_vars[$tpl_var])) {
            $this->tpl_vars[$tpl_var] = new Smarty_variable(array(), $nocache, $scope);
        } else {
            $this->tpl_vars[$tpl_var] = clone $this->tpl_vars[$tpl_var];
            if ($scope != Smarty::SCOPE_LOCAL) {
                $this->tpl_vars[$tpl_var]->scope = $scope;
            }
            if (!(is_array($this->tpl_vars[$tpl_var]->value) || $this->tpl_vars[$tpl_var]->value instanceof ArrayAccess)) {
                settype($this->tpl_vars[$tpl_var]->value, 'array');
            }
        }
    }

    /**
     * Template code runtime function to get pointer to template variable array of requested scope
     *
     * @param int $scope    requested variable scope
     * @return array        array of template variables
     */
    public function &getScope($scope)
    {
        if ($scope == Smarty::SCOPE_PARENT && !empty($this->parent)) {
            return $this->parent->tpl_vars;
        } elseif ($scope == Smarty::SCOPE_ROOT && !empty($this->parent)) {
            $ptr = $this->parent;
            while (!empty($ptr->parent)) {
                $ptr = $ptr->parent;
            }
            return $ptr->tpl_vars;
        } elseif ($scope == Smarty::SCOPE_GLOBAL) {
            return Smarty::$global_tpl_vars;
        }
        $null = null;
        return $null;
    }

    /**
     * Get parent or root of template parent chain
     *
     * @param int $scope    pqrent or root scope
     * @return mixed object
     */
    public function getScopePointer($scope)
    {
        if ($scope == Smarty::SCOPE_PARENT && !empty($this->parent)) {
            return $this->parent;
        } elseif ($scope == Smarty::SCOPE_ROOT && !empty($this->parent)) {
            $ptr = $this->parent;
            while (!empty($ptr->parent)) {
                $ptr = $ptr->parent;
            }
            return $ptr;
        }
        return null;
    }

    /**
     * [util function] counts an array, arrayaccess/traversable or PDOStatement object
     *
     * @param mixed $value
     * @return int the count for arrays and objects that implement countable, 1 for other objects that don't, and 0 for empty elements
     */
    public function _count($value)
    {
        if (is_array($value) === true || $value instanceof Countable) {
            return count($value);
        } elseif ($value instanceof IteratorAggregate) {
            // Note: getIterator() returns a Traversable, not an Iterator
            // thus rewind() and valid() methods may not be present
            return iterator_count($value->getIterator());
        } elseif ($value instanceof Iterator) {
            return iterator_count($value);
        } elseif ($value instanceof PDOStatement) {
            return $value->rowCount();
        } elseif ($value instanceof Traversable) {
            return iterator_count($value);
        } elseif ($value instanceof ArrayAccess) {
            if ($value->offsetExists(0)) {
                return 1;
            }
        } elseif (is_object($value)) {
            return count($value);
        }
        return 0;
    }

    /**
     * runtime error not matching capture tags
     *
     */
    public function capture_error()
    {
        throw new SmartyException("Not matching {capture} open/close in \"{$this->template_resource}\"");
    }
    
    /**
    * Empty cache for this template
    *
    * @param integer $exp_time      expiration time
    * @return integer number of cache files deleted
    */
    public function clearCache($exp_time=null)
    {
        Smarty_CacheResource::invalidLoadedCache($this->smarty);
        return $this->cached->handler->clear($this->smarty, $this->template_name, $this->cache_id, $this->compile_id, $exp_time);
    }
    
     /**
     * set Smarty property in template context
     *
     * @param string $property_name property name
     * @param mixed  $value         value
     */
    public function __set($property_name, $value)
    {
        switch ($property_name) {
            case 'source':
            case 'compiled':
            case 'cached':
            case 'compiler':
                $this->$property_name = $value;
                return;

            // FIXME: routing of template -> smarty attributes
            default:
                if (property_exists($this->smarty, $property_name)) {
                    $this->smarty->$property_name = $value;
                    return;
                }
        }

        throw new SmartyException("invalid template property '$property_name'.");
    }

    /**
     * get Smarty property in template context
     *
     * @param string $property_name property name
     */
    public function __get($property_name)
    {
        switch ($property_name) {
            case 'source':
                if (empty($this->template_resource)) {
                    throw new SmartyException("Unable to parse resource name \"{$this->template_resource}\"");
                }
                $this->source = Smarty_Resource::source($this);
                // cache template object under a unique ID
                // do not cache eval resources
                if ($this->source->type != 'eval') {
                    $_templateId = sha1($this->source->unique_resource . $this->cache_id . $this->compile_id);
                    $this->smarty->template_objects[$_templateId] = $this;
                }
                return $this->source;

            case 'compiled':
                $this->compiled = $this->source->getCompiled($this);
                return $this->compiled;

            case 'cached':
                if (!class_exists('Smarty_Template_Cached')) {
                    include SMARTY_SYSPLUGINS_DIR . 'smarty_cacheresource.php';
                }
                $this->cached = new Smarty_Template_Cached($this);
                return $this->cached;

            case 'compiler':
                $this->smarty->loadPlugin($this->source->compiler_class);
                $this->compiler = new $this->source->compiler_class($this->source->template_lexer_class, $this->source->template_parser_class, $this->smarty);
                return $this->compiler;

            // FIXME: routing of template -> smarty attributes
            default:
                if (property_exists($this->smarty, $property_name)) {
                    return $this->smarty->$property_name;
                }
        }

        throw new SmartyException("template property '$property_name' does not exist.");
    }

    /**
     * Template data object destrutor
     *
     */
    public function __destruct()
    {
        if ($this->smarty->cache_locking && isset($this->cached) && $this->cached->is_locked) {
            $this->cached->handler->releaseLock($this->smarty, $this->cached);
        }
    }

}

?><?php
/**
 * Smarty Internal Plugin Templateparser Parsetrees
 *
 * These are classes to build parsetrees in the template parser
 *
 * @package Smarty
 * @subpackage Compiler
 * @author Thue Kristensen
 * @author Uwe Tews
 */

/**
 * @package Smarty
 * @subpackage Compiler
 * @ignore
 */
abstract class _smarty_parsetree {

    /**
     * Parser object
     * @var object
     */
    public $parser;
    /**
     * Buffer content
     * @var mixed
     */
    public $data;

    /**
     * Return buffer
     *
     * @return string  buffer content
     */
    abstract public function to_smarty_php();

}

/**
 * A complete smarty tag.
 *
 * @package Smarty
 * @subpackage Compiler
 * @ignore
 */
class _smarty_tag extends _smarty_parsetree {

    /**
     * Saved block nesting level
     * @var int
     */
    public $saved_block_nesting;

    /**
     * Create parse tree buffer for Smarty tag
     *
     * @param object $parser    parser object
     * @param string $data      content
     */
    public function __construct($parser, $data)
    {
        $this->parser = $parser;
        $this->data = $data;
        $this->saved_block_nesting = $parser->block_nesting_level;
    }

    /**
     * Return buffer content
     *
     * @return string  content
     */
    public function to_smarty_php()
    {
        return $this->data;
    }

    /**
     * Return complied code that loads the evaluated outout of buffer content into a temporary variable
     *
     * @return string template code
     */
    public function assign_to_var()
    {
        $var = sprintf('$_tmp%d', ++$this->parser->prefix_number);
        $this->parser->compiler->prefix_code[] = sprintf('<?php ob_start();?>%s<?php %s=ob_get_clean();?>', $this->data, $var);
        return $var;
    }

}

/**
 * Code fragment inside a tag.
 *
 * @package Smarty
 * @subpackage Compiler
 * @ignore
 */
class _smarty_code extends _smarty_parsetree {


    /**
     * Create parse tree buffer for code fragment
     *
     * @param object $parser    parser object
     * @param string $data      content
     */
    public function __construct($parser, $data)
    {
        $this->parser = $parser;
        $this->data = $data;
    }

    /**
     * Return buffer content in parentheses
     *
     * @return string  content
     */
    public function to_smarty_php()
    {
        return sprintf("(%s)", $this->data);
    }

}

/**
 * Double quoted string inside a tag.
 *
 * @package Smarty
 * @subpackage Compiler
 * @ignore
 */
class _smarty_doublequoted extends _smarty_parsetree {

    /**
     * Create parse tree buffer for double quoted string subtrees
     *
     * @param object $parser    parser object
     * @param _smarty_parsetree $subtree    parsetree buffer
     */
    public function __construct($parser, _smarty_parsetree $subtree)
    {
        $this->parser = $parser;
        $this->subtrees[] = $subtree;
        if ($subtree instanceof _smarty_tag) {
            $this->parser->block_nesting_level = count($this->parser->compiler->_tag_stack);
        }
    }

    /**
     * Append buffer to subtree
     *
     * @param _smarty_parsetree $subtree  parsetree buffer
     */
    public function append_subtree(_smarty_parsetree $subtree)
    {
        $last_subtree = count($this->subtrees) - 1;
        if ($last_subtree >= 0 && $this->subtrees[$last_subtree] instanceof _smarty_tag && $this->subtrees[$last_subtree]->saved_block_nesting < $this->parser->block_nesting_level) {
            if ($subtree instanceof _smarty_code) {
                $this->subtrees[$last_subtree]->data .= '<?php echo ' . $subtree->data . ';?>';
            } elseif ($subtree instanceof _smarty_dq_content) {
                $this->subtrees[$last_subtree]->data .= '<?php echo "' . $subtree->data . '";?>';
            } else {
                $this->subtrees[$last_subtree]->data .= $subtree->data;
            }
        } else {
            $this->subtrees[] = $subtree;
        }
        if ($subtree instanceof _smarty_tag) {
            $this->parser->block_nesting_level = count($this->parser->compiler->_tag_stack);
        }
    }

    /**
     * Merge subtree buffer content together
     *
     * @return string  compiled template code
     */
    public function to_smarty_php()
    {
        $code = '';
        foreach ($this->subtrees as $subtree) {
            if ($code !== "") {
                $code .= ".";
            }
            if ($subtree instanceof _smarty_tag) {
                $more_php = $subtree->assign_to_var();
            } else {
                $more_php = $subtree->to_smarty_php();
            }

            $code .= $more_php;

            if (!$subtree instanceof _smarty_dq_content) {
                $this->parser->compiler->has_variable_string = true;
            }
        }
        return $code;
    }

}

/**
 * Raw chars as part of a double quoted string.
 *
 * @package Smarty
 * @subpackage Compiler
 * @ignore
 */
class _smarty_dq_content extends _smarty_parsetree {


    /**
     * Create parse tree buffer with string content
     *
     * @param object $parser  parser object
     * @param string $data    string section
     */
    public function __construct($parser, $data)
    {
        $this->parser = $parser;
        $this->data = $data;
    }

    /**
     * Return content as double quoted string
     *
     * @return string doubled quoted string
     */
    public function to_smarty_php()
    {
        return '"' . $this->data . '"';
    }

}

/**
 * Template element
 *
 * @package Smarty
 * @subpackage Compiler
 * @ignore
 */
class _smarty_template_buffer extends _smarty_parsetree {

    /**
     * Array of template elements
     *
     * @var array
     */
    public $subtrees = Array();

    /**
     * Create root of parse tree for template elements
     *
     * @param object $parser    parse object
     */
    public function __construct($parser)
    {
        $this->parser = $parser;
    }

    /**
     * Append buffer to subtree
     *
     * @param _smarty_parsetree $subtree
     */
    public function append_subtree(_smarty_parsetree $subtree)
    {
        $this->subtrees[] = $subtree;
    }

    /**
     * Sanitize and merge subtree buffers together
     *
     * @return string template code content
     */
    public function to_smarty_php()
    {
        $code = '';
        for ($key = 0, $cnt = count($this->subtrees); $key < $cnt; $key++) {
            if ($key + 2 < $cnt) {
                if ($this->subtrees[$key] instanceof _smarty_linebreak && $this->subtrees[$key + 1] instanceof _smarty_tag && $this->subtrees[$key + 1]->data == '' && $this->subtrees[$key + 2] instanceof _smarty_linebreak) {
                    $key = $key + 1;
                    continue;
                }
                if (substr($this->subtrees[$key]->data, -1) == '<' && $this->subtrees[$key + 1]->data == '' && substr($this->subtrees[$key + 2]->data, -1) == '?') {
                    $key = $key + 2;
                    continue;
                }
            }
            if (substr($code, -1) == '<') {
                $subtree = $this->subtrees[$key]->to_smarty_php();
                if (substr($subtree, 0, 1) == '?') {
                    $code = substr($code, 0, strlen($code) - 1) . '<<?php ?>?' . substr($subtree, 1);
                } elseif ($this->parser->asp_tags && substr($subtree, 0, 1) == '%') {
                    $code = substr($code, 0, strlen($code) - 1) . '<<?php ?>%' . substr($subtree, 1);
                } else {
                    $code .= $subtree;
                }
                continue;
            }
            if ($this->parser->asp_tags && substr($code, -1) == '%') {
                $subtree = $this->subtrees[$key]->to_smarty_php();
                if (substr($subtree, 0, 1) == '>') {
                    $code = substr($code, 0, strlen($code) - 1) . '%<?php ?>>' . substr($subtree, 1);
                } else {
                    $code .= $subtree;
                }
                continue;
            }
            if (substr($code, -1) == '?') {
                $subtree = $this->subtrees[$key]->to_smarty_php();
                if (substr($subtree, 0, 1) == '>') {
                    $code = substr($code, 0, strlen($code) - 1) . '?<?php ?>>' . substr($subtree, 1);
                } else {
                    $code .= $subtree;
                }
                continue;
            }
            $code .= $this->subtrees[$key]->to_smarty_php();
        }
        return $code;
    }

}

/**
 * template text
 *
 * @package Smarty
 * @subpackage Compiler
 * @ignore
 */
class _smarty_text extends _smarty_parsetree {


    /**
     * Create template text buffer
     *
     * @param object $parser    parser object
     * @param string $data      text
     */
    public function __construct($parser, $data)
    {
        $this->parser = $parser;
        $this->data = $data;
    }

    /**
     * Return buffer content
     *
     * @return strint text
     */
    public function to_smarty_php()
    {
        return $this->data;
    }

}

/**
 * template linebreaks
 *
 * @package Smarty
 * @subpackage Compiler
 * @ignore
 */
class _smarty_linebreak extends _smarty_parsetree {

    /**
     * Create buffer with linebreak content
     *
     * @param object $parser    parser object
     * @param string  $data     linebreak string
     */
    public function __construct($parser, $data)
    {
        $this->parser = $parser;
        $this->data = $data;
    }

    /**
     * Return linebrak
     *
     * @return string linebreak
     */
    public function to_smarty_php()
    {
        return $this->data;
    }

}

?><?php
/**
 * Smarty Internal Plugin Compile Config Load
 *
 * Compiles the {config load} tag
 *
 * @package Smarty
 * @subpackage Compiler
 * @author Uwe Tews
 */

/**
 * Smarty Internal Plugin Compile Config Load Class
 *
 * @package Smarty
 * @subpackage Compiler
 */
class Smarty_Internal_Compile_Config_Load extends Smarty_Internal_CompileBase {

    /**
     * Attribute definition: Overwrites base class.
     *
     * @var array
     * @see Smarty_Internal_CompileBase
     */
    public $required_attributes = array('file');
    /**
     * Attribute definition: Overwrites base class.
     *
     * @var array
     * @see Smarty_Internal_CompileBase
     */
    public $shorttag_order = array('file','section');
    /**
     * Attribute definition: Overwrites base class.
     *
     * @var array
     * @see Smarty_Internal_CompileBase
     */
    public $optional_attributes = array('section', 'scope');

    /**
     * Compiles code for the {config_load} tag
     *
     * @param array  $args     array with attributes from parser
     * @param object $compiler compiler object
     * @return string compiled code
     */
    public function compile($args, $compiler)
    {
        static $_is_legal_scope = array('local' => true,'parent' => true,'root' => true,'global' => true);
        // check and get attributes
        $_attr = $this->getAttributes($compiler, $args);

        if ($_attr['nocache'] === true) {
            $compiler->trigger_template_error('nocache option not allowed', $compiler->lex->taglineno);
        }


        // save posible attributes
        $conf_file = $_attr['file'];
        if (isset($_attr['section'])) {
            $section = $_attr['section'];
        } else {
            $section = 'null';
        }
        $scope = 'local';
        // scope setup
        if (isset($_attr['scope'])) {
            $_attr['scope'] = trim($_attr['scope'], "'\"");
            if (isset($_is_legal_scope[$_attr['scope']])) {
                $scope = $_attr['scope'];
           } else {
                $compiler->trigger_template_error('illegal value for "scope" attribute', $compiler->lex->taglineno);
           }
        }
        // create config object
        $_output = "<?php  \$_config = new Smarty_Internal_Config($conf_file, \$_smarty_tpl->smarty, \$_smarty_tpl);";
        $_output .= "\$_config->loadConfigVars($section, '$scope'); ?>";
        return $_output;
    }

}

?><?php
/**
* Smarty Internal Plugin Templateparser
*
* This is the template parser.
* It is generated from the internal.templateparser.y file
* @package Smarty
* @subpackage Compiler
* @author Uwe Tews
*/

class TP_yyToken implements ArrayAccess
{
    public $string = '';
    public $metadata = array();

    function __construct($s, $m = array())
    {
        if ($s instanceof TP_yyToken) {
            $this->string = $s->string;
            $this->metadata = $s->metadata;
        } else {
            $this->string = (string) $s;
            if ($m instanceof TP_yyToken) {
                $this->metadata = $m->metadata;
            } elseif (is_array($m)) {
                $this->metadata = $m;
            }
        }
    }

    function __toString()
    {
        return $this->_string;
    }

    function offsetExists($offset)
    {
        return isset($this->metadata[$offset]);
    }

    function offsetGet($offset)
    {
        return $this->metadata[$offset];
    }

    function offsetSet($offset, $value)
    {
        if ($offset === null) {
            if (isset($value[0])) {
                $x = ($value instanceof TP_yyToken) ?
                    $value->metadata : $value;
                $this->metadata = array_merge($this->metadata, $x);
                return;
            }
            $offset = count($this->metadata);
        }
        if ($value === null) {
            return;
        }
        if ($value instanceof TP_yyToken) {
            if ($value->metadata) {
                $this->metadata[$offset] = $value->metadata;
            }
        } elseif ($value) {
            $this->metadata[$offset] = $value;
        }
    }

    function offsetUnset($offset)
    {
        unset($this->metadata[$offset]);
    }
}

class TP_yyStackEntry
{
    public $stateno;       /* The state-number */
    public $major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
    public $minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};


#line 12 "smarty_internal_templateparser.y"
class Smarty_Internal_Templateparser#line 79 "smarty_internal_templateparser.php"
{
#line 14 "smarty_internal_templateparser.y"

    const Err1 = "Security error: Call to private object member not allowed";
    const Err2 = "Security error: Call to dynamic object member not allowed";
    const Err3 = "PHP in template not allowed. Use SmartyBC to enable it";
    // states whether the parse was successful or not
    public $successful = true;
    public $retvalue = 0;
    private $lex;
    private $internalError = false;

    function __construct($lex, $compiler) {
        $this->lex = $lex;
        $this->compiler = $compiler;
        $this->smarty = $this->compiler->smarty;
        $this->template = $this->compiler->template;
        $this->compiler->has_variable_string = false;
        $this->compiler->prefix_code = array();
        $this->prefix_number = 0;
        $this->block_nesting_level = 0;
        if ($this->security = isset($this->smarty->security_policy)) {
            $this->php_handling = $this->smarty->security_policy->php_handling;
        } else {
            $this->php_handling = $this->smarty->php_handling;
        }
        $this->is_xml = false;
        $this->asp_tags = (ini_get('asp_tags') != '0');
        $this->current_buffer = $this->root_buffer = new _smarty_template_buffer($this);
    }

    public static function escape_start_tag($tag_text) {
        $tag = preg_replace('/\A<\?(.*)\z/', '<<?php ?>?\1', $tag_text, -1 , $count); //Escape tag
        return $tag;
    }

    public static function escape_end_tag($tag_text) {
        return '?<?php ?>>';
    }

    public function compileVariable($variable) {
        if (strpos($variable,'(') == 0) {
            // not a variable variable
            $var = trim($variable,'\'');
            $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable($var, null, true, false)->nocache;
            $this->template->properties['variables'][$var] = $this->compiler->tag_nocache|$this->compiler->nocache;
        }
//       return '(isset($_smarty_tpl->tpl_vars['. $variable .'])?$_smarty_tpl->tpl_vars['. $variable .']->value:$_smarty_tpl->getVariable('. $variable .')->value)';
        return '$_smarty_tpl->tpl_vars['. $variable .']->value';
    }
#line 131 "smarty_internal_templateparser.php"

    const TP_VERT                           =  1;
    const TP_COLON                          =  2;
    const TP_COMMENT                        =  3;
    const TP_PHPSTARTTAG                    =  4;
    const TP_PHPENDTAG                      =  5;
    const TP_ASPSTARTTAG                    =  6;
    const TP_ASPENDTAG                      =  7;
    const TP_FAKEPHPSTARTTAG                =  8;
    const TP_XMLTAG                         =  9;
    const TP_OTHER                          = 10;
    const TP_LINEBREAK                      = 11;
    const TP_LITERALSTART                   = 12;
    const TP_LITERALEND                     = 13;
    const TP_LITERAL                        = 14;
    const TP_LDEL                           = 15;
    const TP_RDEL                           = 16;
    const TP_DOLLAR                         = 17;
    const TP_ID                             = 18;
    const TP_EQUAL                          = 19;
    const TP_PTR                            = 20;
    const TP_LDELIF                         = 21;
    const TP_LDELFOR                        = 22;
    const TP_SEMICOLON                      = 23;
    const TP_INCDEC                         = 24;
    const TP_TO                             = 25;
    const TP_STEP                           = 26;
    const TP_LDELFOREACH                    = 27;
    const TP_SPACE                          = 28;
    const TP_AS                             = 29;
    const TP_APTR                           = 30;
    const TP_LDELSETFILTER                  = 31;
    const TP_SMARTYBLOCKCHILD               = 32;
    const TP_LDELSLASH                      = 33;
    const TP_INTEGER                        = 34;
    const TP_COMMA                          = 35;
    const TP_OPENP                          = 36;
    const TP_CLOSEP                         = 37;
    const TP_MATH                           = 38;
    const TP_UNIMATH                        = 39;
    const TP_ANDSYM                         = 40;
    const TP_ISIN                           = 41;
    const TP_ISDIVBY                        = 42;
    const TP_ISNOTDIVBY                     = 43;
    const TP_ISEVEN                         = 44;
    const TP_ISNOTEVEN                      = 45;
    const TP_ISEVENBY                       = 46;
    const TP_ISNOTEVENBY                    = 47;
    const TP_ISODD                          = 48;
    const TP_ISNOTODD                       = 49;
    const TP_ISODDBY                        = 50;
    const TP_ISNOTODDBY                     = 51;
    const TP_INSTANCEOF                     = 52;
    const TP_QMARK                          = 53;
    const TP_NOT                            = 54;
    const TP_TYPECAST                       = 55;
    const TP_HEX                            = 56;
    const TP_DOT                            = 57;
    const TP_SINGLEQUOTESTRING              = 58;
    const TP_DOUBLECOLON                    = 59;
    const TP_AT                             = 60;
    const TP_HATCH                          = 61;
    const TP_OPENB                          = 62;
    const TP_CLOSEB                         = 63;
    const TP_EQUALS                         = 64;
    const TP_NOTEQUALS                      = 65;
    const TP_GREATERTHAN                    = 66;
    const TP_LESSTHAN                       = 67;
    const TP_GREATEREQUAL                   = 68;
    const TP_LESSEQUAL                      = 69;
    const TP_IDENTITY                       = 70;
    const TP_NONEIDENTITY                   = 71;
    const TP_MOD                            = 72;
    const TP_LAND                           = 73;
    const TP_LOR                            = 74;
    const TP_LXOR                           = 75;
    const TP_QUOTE                          = 76;
    const TP_BACKTICK                       = 77;
    const TP_DOLLARID                       = 78;
    const YY_NO_ACTION = 590;
    const YY_ACCEPT_ACTION = 589;
    const YY_ERROR_ACTION = 588;

    const YY_SZ_ACTTAB = 2393;
static public $yy_action = array(
 /*     0 */   211,  316,  317,  319,  318,  315,  314,  310,  309,  311,
 /*    10 */   312,  313,  320,  189,  304,  161,   38,  589,   95,  265,
 /*    20 */   317,  319,    7,  106,  289,   37,   26,   30,  146,  283,
 /*    30 */    10,  285,  250,  286,  238,  280,  287,   49,   48,   46,
 /*    40 */    45,   20,   29,  365,  366,   28,   32,  373,  374,   15,
 /*    50 */    11,  328,  323,  322,  324,  327,  231,  211,    4,  189,
 /*    60 */   329,  332,  211,  382,  383,  384,  385,  381,  380,  376,
 /*    70 */   375,  377,  281,  378,  379,  211,  360,  450,  180,  251,
 /*    80 */   117,  144,  196,   74,  135,  260,   17,  451,   26,   30,
 /*    90 */   307,  283,  299,  361,   35,  158,  225,  368,  362,  451,
 /*   100 */   343,   30,   30,  226,   44,  203,  285,    4,   47,  203,
 /*   110 */   218,  259,   49,   48,   46,   45,   20,   29,  365,  366,
 /*   120 */    28,   32,  373,  374,   15,   11,  351,  108,  176,  334,
 /*   130 */   144,  193,  337,   23,  129,  134,  371,  289,  382,  383,
 /*   140 */   384,  385,  381,  380,  376,  375,  377,  281,  378,  379,
 /*   150 */   211,  360,  372,   26,  203,  142,  283,   31,   68,  122,
 /*   160 */   242,   26,  109,  353,  283,  346,  454,  299,  361,   25,
 /*   170 */   185,  225,  368,  362,   30,  343,  239,   30,  454,  289,
 /*   180 */     4,   41,   26,  143,  165,  283,    4,   49,   48,   46,
 /*   190 */    45,   20,   29,  365,  366,   28,   32,  373,  374,   15,
 /*   200 */    11,  101,  160,  144,   26,  208,   34,  283,   31,  144,
 /*   210 */     8,  289,    4,  382,  383,  384,  385,  381,  380,  376,
 /*   220 */   375,  377,  281,  378,  379,  211,  360,  227,  203,  357,
 /*   230 */   142,  197,   19,   73,  135,  144,  211,  302,    9,  158,
 /*   240 */   340,   26,  299,  361,  283,  158,  225,  368,  362,  228,
 /*   250 */   343,  294,   30,    6,  331,  235,  330,  221,  195,  337,
 /*   260 */   126,  240,   49,   48,   46,   45,   20,   29,  365,  366,
 /*   270 */    28,   32,  373,  374,   15,   11,  211,   16,  129,  244,
 /*   280 */   249,  219,  208,  192,  337,  302,  228,    8,  382,  383,
 /*   290 */   384,  385,  381,  380,  376,  375,  377,  281,  378,  379,
 /*   300 */   163,  211,  107,  188,  105,   40,   40,  266,  277,  289,
 /*   310 */   241,  232,  289,   49,   48,   46,   45,   20,   29,  365,
 /*   320 */   366,   28,   32,  373,  374,   15,   11,  211,  168,  203,
 /*   330 */    40,    2,  278,  167,  175,  244,  242,  289,  350,  382,
 /*   340 */   383,  384,  385,  381,  380,  376,  375,  377,  281,  378,
 /*   350 */   379,  191,   47,  184,  204,  234,  169,  198,  287,  386,
 /*   360 */   203,  203,  289,  124,   49,   48,   46,   45,   20,   29,
 /*   370 */   365,  366,   28,   32,  373,  374,   15,   11,  211,  204,
 /*   380 */   182,   26,   26,   26,  283,  212,  224,  118,  131,  289,
 /*   390 */   382,  383,  384,  385,  381,  380,  376,  375,  377,  281,
 /*   400 */   378,  379,  370,  172,  244,  270,  204,  130,  211,  164,
 /*   410 */    26,  287,  289,  229,  178,   49,   48,   46,   45,   20,
 /*   420 */    29,  365,  366,   28,   32,  373,  374,   15,   11,  204,
 /*   430 */   364,  298,    5,   26,  100,   30,  247,  148,  148,   99,
 /*   440 */   159,  382,  383,  384,  385,  381,  380,  376,  375,  377,
 /*   450 */   281,  378,  379,  211,  354,  370,  360,  174,   26,  369,
 /*   460 */   142,  283,  360,   73,  135,  158,  157,  123,   24,  155,
 /*   470 */   135,   30,  299,  361,  211,  190,  225,  368,  362,  272,
 /*   480 */   343,  252,  225,  368,  362,  343,  343,  222,  223,  306,
 /*   490 */    49,   48,   46,   45,   20,   29,  365,  366,   28,   32,
 /*   500 */   373,  374,   15,   11,  129,   43,  236,    9,  269,  258,
 /*   510 */   199,  133,   33,   14,  202,  103,  382,  383,  384,  385,
 /*   520 */   381,  380,  376,  375,  377,  281,  378,  379,  211,  360,
 /*   530 */   370,  170,  262,  142,  360,   36,   73,  135,  151,  141,
 /*   540 */   289,  245,  135,  276,  211,  299,  361,  211,   44,  225,
 /*   550 */   368,  362,  287,  343,  225,  368,  362,  119,  343,  295,
 /*   560 */   216,  267,  282,  296,  211,   49,   48,   46,   45,   20,
 /*   570 */    29,  365,  366,   28,   32,  373,  374,   15,   11,  284,
 /*   580 */   181,  223,  333,  138,  302,  236,  297,    6,  127,  289,
 /*   590 */   116,  382,  383,  384,  385,  381,  380,  376,  375,  377,
 /*   600 */   281,  378,  379,  211,  360,  370,  177,   94,  142,  303,
 /*   610 */   292,   54,  122,  139,  162,  289,  150,  261,  264,  293,
 /*   620 */   299,  361,   30,  289,  225,  368,  362,  287,  343,   30,
 /*   630 */   287,   30,  132,  300,  308,  287,  158,  211,   30,  334,
 /*   640 */    49,   48,   46,   45,   20,   29,  365,  366,   28,   32,
 /*   650 */   373,  374,   15,   11,  211,  204,  166,   12,  275,  287,
 /*   660 */   273,  248,  342,   98,   97,  113,  382,  383,  384,  385,
 /*   670 */   381,  380,  376,  375,  377,  281,  378,  379,  370,  370,
 /*   680 */   370,  110,   18,  321,  324,  324,  324,  324,  324,  324,
 /*   690 */   246,   49,   48,   46,   45,   20,   29,  365,  366,   28,
 /*   700 */    32,  373,  374,   15,   11,  211,  324,  324,  324,  324,
 /*   710 */   324,  324,  324,  324,  112,  136,  104,  382,  383,  384,
 /*   720 */   385,  381,  380,  376,  375,  377,  281,  378,  379,  370,
 /*   730 */   370,  370,  324,  324,  324,  324,  324,  324,  324,  324,
 /*   740 */   324,  256,   49,   48,   46,   45,   20,   29,  365,  366,
 /*   750 */    28,   32,  373,  374,   15,   11,  211,  324,  324,  324,
 /*   760 */   324,  324,  324,  324,  324,  324,  324,  324,  382,  383,
 /*   770 */   384,  385,  381,  380,  376,  375,  377,  281,  378,  379,
 /*   780 */   351,  324,  324,   30,  324,  324,  324,  324,  324,  324,
 /*   790 */   324,  324,  324,   49,   48,   46,   45,   20,   29,  365,
 /*   800 */   366,   28,   32,  373,  374,   15,   11,  211,  324,  324,
 /*   810 */   324,  324,  324,  324,  324,  324,  324,  355,  324,  382,
 /*   820 */   383,  384,  385,  381,  380,  376,  375,  377,  281,  378,
 /*   830 */   379,  324,  324,  324,  324,  324,  324,  324,  324,  324,
 /*   840 */   324,  324,  324,  324,   49,   48,   46,   45,   20,   29,
 /*   850 */   365,  366,   28,   32,  373,  374,   15,   11,  324,  324,
 /*   860 */   324,  324,  324,  324,  324,  324,  324,  324,  324,  257,
 /*   870 */   382,  383,  384,  385,  381,  380,  376,  375,  377,  281,
 /*   880 */   378,  379,  211,  324,  324,  324,  194,  360,  211,  288,
 /*   890 */   255,  145,  324,  352,  336,  135,  324,  200,   42,   22,
 /*   900 */    27,   30,   30,  341,    7,  106,   30,  225,  368,  362,
 /*   910 */   146,  343,  324,  203,  250,  286,  238,  324,  211,   49,
 /*   920 */    48,   46,   45,   20,   29,  365,  366,   28,   32,  373,
 /*   930 */   374,   15,   11,  305,  324,  324,  324,  324,  324,   47,
 /*   940 */   324,  324,  324,  324,  324,  382,  383,  384,  385,  381,
 /*   950 */   380,  376,  375,  377,  281,  378,  379,  211,  324,  359,
 /*   960 */    39,  349,  360,  326,  348,  291,  156,  324,  352,  344,
 /*   970 */   135,  324,  201,   42,  324,   30,   30,   30,  324,    7,
 /*   980 */   106,   30,  225,  368,  362,  146,  343,  324,  324,  250,
 /*   990 */   286,  238,  324,  324,   49,   48,   46,   45,   20,   29,
 /*  1000 */   365,  366,   28,   32,  373,  374,   15,   11,  211,  324,
 /*  1010 */   324,  324,  324,  324,  324,  324,  324,  324,  324,  324,
 /*  1020 */   382,  383,  384,  385,  381,  380,  376,  375,  377,  281,
 /*  1030 */   378,  379,  324,  324,  358,   39,  349,  324,  324,  324,
 /*  1040 */   324,  324,  324,  324,  324,   49,   48,   46,   45,   20,
 /*  1050 */    29,  365,  366,   28,   32,  373,  374,   15,   11,  324,
 /*  1060 */   324,  324,  324,  324,  324,  324,  324,  324,  324,  324,
 /*  1070 */   324,  382,  383,  384,  385,  381,  380,  376,  375,  377,
 /*  1080 */   281,  378,  379,  324,   49,   48,   46,   45,   20,   29,
 /*  1090 */   365,  366,   28,   32,  373,  374,   15,   11,  324,  324,
 /*  1100 */   324,  324,  324,  324,  324,  324,  324,  324,  324,  324,
 /*  1110 */   382,  383,  384,  385,  381,  380,  376,  375,  377,  281,
 /*  1120 */   378,  379,  324,  324,  324,  324,   38,  324,  140,  207,
 /*  1130 */   324,  360,    7,  106,  290,  147,  324,  356,  146,  135,
 /*  1140 */   324,  324,  250,  286,  238,  230,   30,   13,  367,   30,
 /*  1150 */    51,  225,  368,  362,  324,  343,  360,  324,  324,  324,
 /*  1160 */   152,  324,  324,  324,  135,   50,   52,  301,  237,  363,
 /*  1170 */   324,  360,  105,    1,  254,  154,  225,  368,  362,  135,
 /*  1180 */   343,  324,   38,  324,  140,  214,  324,   96,    7,  106,
 /*  1190 */   279,  225,  368,  362,  146,  343,  347,  345,  250,  286,
 /*  1200 */   238,  230,   30,   13,  274,  324,   51,  338,   30,   30,
 /*  1210 */   360,  324,  324,  324,  121,  324,   30,   53,  135,   30,
 /*  1220 */   211,   50,   52,  301,  237,  363,  299,  361,  105,    1,
 /*  1230 */   225,  368,  362,  211,  343,  453,  324,  268,   38,  324,
 /*  1240 */   128,  214,  324,   96,    7,  106,  253,  453,  339,   30,
 /*  1250 */   146,  335,  233,  324,  250,  286,  238,  230,   30,    3,
 /*  1260 */    30,  324,   51,   30,  271,  324,  360,  324,    4,  324,
 /*  1270 */   142,   47,  324,   84,  135,  324,   30,   50,   52,  301,
 /*  1280 */   237,  363,  299,  361,  105,    1,  225,  368,  362,  324,
 /*  1290 */   343,  144,  324,  324,   38,  324,  125,   92,  324,   96,
 /*  1300 */     7,  106,  324,  324,  324,  324,  146,  324,  324,  324,
 /*  1310 */   250,  286,  238,  230,  324,   13,  324,  324,   51,  324,
 /*  1320 */   324,  324,  360,  324,  324,  324,  142,  324,  324,   89,
 /*  1330 */   135,  324,  211,   50,   52,  301,  237,  363,  299,  361,
 /*  1340 */   105,    1,  225,  368,  362,  324,  343,  456,  324,  324,
 /*  1350 */    38,  324,  126,  214,  324,   96,    7,  106,  324,  456,
 /*  1360 */   243,  324,  146,  324,  324,  324,  250,  286,  238,  230,
 /*  1370 */   324,   21,  324,  324,   51,  324,  324,  324,  360,  324,
 /*  1380 */   324,  324,  142,   47,  324,   87,  135,  324,  211,   50,
 /*  1390 */    52,  301,  237,  363,  299,  361,  105,    1,  225,  368,
 /*  1400 */   362,  324,  343,  456,  324,  324,   38,  324,  140,  210,
 /*  1410 */   324,   96,    7,  106,  324,  456,  324,  324,  146,  324,
 /*  1420 */   324,  324,  250,  286,  238,  230,  324,   13,  324,  324,
 /*  1430 */    51,  324,  324,  324,  360,  324,  324,  324,  142,   47,
 /*  1440 */   324,   63,  135,  324,  211,   50,   52,  301,  237,  363,
 /*  1450 */   299,  361,  105,    1,  225,  368,  362,  324,  343,  325,
 /*  1460 */   324,  324,   38,  324,  137,  214,  324,   96,    7,  106,
 /*  1470 */   324,   30,  324,  324,  146,  324,  324,  324,  250,  286,
 /*  1480 */   238,  230,  324,   13,  324,  324,   51,  324,  324,  324,
 /*  1490 */   360,  324,  324,  324,  142,   47,  324,   80,  135,  324,
 /*  1500 */   324,   50,   52,  301,  237,  363,  299,  361,  105,    1,
 /*  1510 */   225,  368,  362,  324,  343,  324,  324,  324,   38,  324,
 /*  1520 */   140,  206,  324,   96,    7,  106,  324,  324,  324,  324,
 /*  1530 */   146,  324,  324,  324,  250,  286,  238,  220,  324,   13,
 /*  1540 */   324,  324,   51,  324,  324,  324,  360,  324,  324,  324,
 /*  1550 */   114,  324,  324,   75,  135,  324,  324,   50,   52,  301,
 /*  1560 */   237,  363,  299,  361,  105,    1,  225,  368,  362,  324,
 /*  1570 */   343,  324,  324,  324,   38,  324,  140,  205,  324,   96,
 /*  1580 */     7,  106,  324,  324,  324,  324,  146,  324,  324,  324,
 /*  1590 */   250,  286,  238,  230,  324,   13,  324,  324,   51,  324,
 /*  1600 */   324,  324,  360,  324,  324,  324,  142,  324,  324,   77,
 /*  1610 */   135,  324,  324,   50,   52,  301,  237,  363,  299,  361,
 /*  1620 */   105,    1,  225,  368,  362,  324,  343,  324,  324,  324,
 /*  1630 */    38,  324,  140,  209,  324,   96,    7,  106,  324,  324,
 /*  1640 */   324,  324,  146,  324,  324,  324,  250,  286,  238,  230,
 /*  1650 */   324,   13,  324,  324,   51,  324,  324,  324,  360,  324,
 /*  1660 */   324,  324,  142,  324,  324,   85,  135,  324,  324,   50,
 /*  1670 */    52,  301,  237,  363,  299,  361,  105,    1,  225,  368,
 /*  1680 */   362,  324,  343,  324,  324,  324,   38,  324,  126,  213,
 /*  1690 */   324,   96,    7,  106,  324,  324,  324,  324,  146,  324,
 /*  1700 */   324,  324,  250,  286,  238,  230,  324,   21,  324,  324,
 /*  1710 */    51,  324,  324,  324,  360,  324,  324,  324,  142,  324,
 /*  1720 */   324,   71,  135,  324,  324,   50,   52,  301,  237,  363,
 /*  1730 */   299,  361,  105,  324,  225,  368,  362,  324,  343,  324,
 /*  1740 */   324,  324,   38,  324,  126,  214,  324,   96,    7,  106,
 /*  1750 */   324,  324,  324,  324,  146,  324,  324,  324,  250,  286,
 /*  1760 */   238,  230,  324,   21,  102,  186,   51,  324,  324,  324,
 /*  1770 */   324,  324,  324,  324,  289,  324,  324,   22,   27,  324,
 /*  1780 */   499,   50,   52,  301,  237,  363,  324,  499,  105,  499,
 /*  1790 */   499,  203,  499,  499,  324,  324,  324,  324,  324,  499,
 /*  1800 */     4,  499,  324,   96,  324,  324,  324,  324,  324,  324,
 /*  1810 */   324,  324,  324,  360,  324,  324,  499,  117,  324,  324,
 /*  1820 */    74,  135,  324,  144,  324,  324,  324,  499,  324,  299,
 /*  1830 */   361,  324,  324,  225,  368,  362,  324,  343,  360,  324,
 /*  1840 */   324,  499,  142,  324,  324,   66,  135,  324,  263,  324,
 /*  1850 */   324,  324,  324,  324,  299,  361,  324,  324,  225,  368,
 /*  1860 */   362,  324,  343,  324,  360,  324,  324,  324,  142,  324,
 /*  1870 */   324,   79,  135,  324,  360,  324,  324,  324,  149,  324,
 /*  1880 */   299,  361,  135,  360,  225,  368,  362,  142,  343,  324,
 /*  1890 */    81,  135,  324,  324,  225,  368,  362,  324,  343,  299,
 /*  1900 */   361,  324,  324,  225,  368,  362,  324,  343,  324,  324,
 /*  1910 */   324,  360,  324,  324,  324,  115,  324,  324,   83,  135,
 /*  1920 */   324,  324,  360,  324,  324,  324,  142,  299,  361,   72,
 /*  1930 */   135,  225,  368,  362,  324,  343,  324,  324,  299,  361,
 /*  1940 */   324,  324,  225,  368,  362,  324,  343,  324,  360,  324,
 /*  1950 */   324,  324,  142,  324,  324,   70,  135,  324,  360,  324,
 /*  1960 */   324,  324,  153,  324,  299,  361,  135,  360,  225,  368,
 /*  1970 */   362,  142,  343,  324,   68,  135,  324,  324,  225,  368,
 /*  1980 */   362,  324,  343,  299,  361,  324,  324,  225,  368,  362,
 /*  1990 */   324,  343,  324,  324,  324,  360,  324,  324,  324,  142,
 /*  2000 */   324,  324,   90,  135,  324,  324,  360,  324,  324,  324,
 /*  2010 */   142,  299,  361,   86,  135,  225,  368,  362,  324,  343,
 /*  2020 */   324,  324,  299,  361,  324,  324,  225,  368,  362,  324,
 /*  2030 */   343,  324,  360,  194,  183,  324,  142,  324,  324,   91,
 /*  2040 */   135,  324,  324,  289,  324,  324,   22,   27,  299,  361,
 /*  2050 */   324,  360,  225,  368,  362,  142,  343,  324,   61,  135,
 /*  2060 */   203,  324,  324,  324,  194,  171,  324,  299,  361,  324,
 /*  2070 */   324,  225,  368,  362,  289,  343,  324,   22,   27,  360,
 /*  2080 */   324,  324,  324,  142,  324,  324,   88,  135,  324,  324,
 /*  2090 */   360,  203,  324,  324,  142,  299,  361,   69,  135,  225,
 /*  2100 */   368,  362,  324,  343,  324,  324,  299,  361,  324,  324,
 /*  2110 */   225,  368,  362,  324,  343,  324,  360,  194,  179,  324,
 /*  2120 */   142,  324,  324,   76,  135,  324,  324,  289,  324,  324,
 /*  2130 */    22,   27,  299,  361,  324,  360,  225,  368,  362,  142,
 /*  2140 */   343,  324,   65,  135,  203,  324,  324,  324,  194,  187,
 /*  2150 */   324,  299,  361,  324,  324,  225,  368,  362,  289,  343,
 /*  2160 */   324,   22,   27,  360,  324,  324,  324,  111,  324,  324,
 /*  2170 */    64,  135,  324,  324,  360,  203,  324,  324,  142,  299,
 /*  2180 */   361,   62,  135,  225,  368,  362,  324,  343,  324,  324,
 /*  2190 */   299,  361,  324,  324,  225,  368,  362,  324,  343,  324,
 /*  2200 */   360,  194,  173,  324,  142,  324,  324,   82,  135,  324,
 /*  2210 */   324,  289,  324,  324,   22,   27,  299,  361,  324,  360,
 /*  2220 */   225,  368,  362,  142,  343,  324,   60,  135,  203,  324,
 /*  2230 */   324,  324,  324,  324,  324,  299,  361,  324,  324,  225,
 /*  2240 */   368,  362,  324,  343,  324,  324,  324,  360,  324,  324,
 /*  2250 */   324,   93,  324,  324,   57,  120,  324,  324,  360,  324,
 /*  2260 */   324,  324,  142,  299,  361,   58,  135,  225,  368,  362,
 /*  2270 */   324,  343,  324,  324,  299,  361,  324,  324,  225,  368,
 /*  2280 */   362,  324,  343,  324,  360,  324,  324,  324,  142,  324,
 /*  2290 */   324,   59,  135,  324,  324,  324,  324,  324,  324,  324,
 /*  2300 */   299,  361,  324,  360,  225,  368,  362,   93,  343,  324,
 /*  2310 */    55,  120,  324,  324,  324,  324,  324,  324,  324,  299,
 /*  2320 */   361,  324,  324,  215,  368,  362,  324,  343,  324,  324,
 /*  2330 */   324,  360,  324,  324,  324,  142,  324,  324,   56,  135,
 /*  2340 */   324,  324,  360,  324,  324,  324,  142,  299,  361,   78,
 /*  2350 */   135,  225,  368,  362,  324,  343,  324,  324,  299,  361,
 /*  2360 */   324,  324,  225,  368,  362,  324,  343,  324,  360,  324,
 /*  2370 */   324,  324,  142,  324,  324,   67,  135,  324,  324,  324,
 /*  2380 */   324,  324,  324,  324,  299,  361,  324,  324,  217,  368,
 /*  2390 */   362,  324,  343,
    );
    static public $yy_lookahead = array(
 /*     0 */     1,   82,   83,   84,    3,    4,    5,    6,    7,    8,
 /*    10 */     9,   10,   11,   12,   18,   89,   15,   80,   81,   82,
 /*    20 */    83,   84,   21,   22,   98,   26,   15,   28,   27,   18,
 /*    30 */    19,  116,   31,   32,   33,   24,  110,   38,   39,   40,
 /*    40 */    41,   42,   43,   44,   45,   46,   47,   48,   49,   50,
 /*    50 */    51,    4,    5,    6,    7,    8,   60,    1,   36,   12,
 /*    60 */    13,   14,    1,   64,   65,   66,   67,   68,   69,   70,
 /*    70 */    71,   72,   73,   74,   75,    1,   83,   16,   88,   57,
 /*    80 */    87,   59,   88,   90,   91,   63,   30,   16,   15,   28,
 /*    90 */    16,   18,   99,  100,   19,   20,  103,  104,  105,   28,
 /*   100 */   107,   28,   28,   30,    2,  115,  116,   36,   52,  115,
 /*   110 */   117,  118,   38,   39,   40,   41,   42,   43,   44,   45,
 /*   120 */    46,   47,   48,   49,   50,   51,   83,   88,   89,  109,
 /*   130 */    59,  111,  112,   15,   59,   17,   18,   98,   64,   65,
 /*   140 */    66,   67,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   150 */     1,   83,   34,   15,  115,   87,   18,   19,   90,   91,
 /*   160 */    92,   15,  119,  120,   18,   16,   16,   99,  100,   19,
 /*   170 */    89,  103,  104,  105,   28,  107,   30,   28,   28,   98,
 /*   180 */    36,   15,   15,   17,   18,   18,   36,   38,   39,   40,
 /*   190 */    41,   42,   43,   44,   45,   46,   47,   48,   49,   50,
 /*   200 */    51,   88,   89,   59,   15,   57,   30,   18,   19,   59,
 /*   210 */    62,   98,   36,   64,   65,   66,   67,   68,   69,   70,
 /*   220 */    71,   72,   73,   74,   75,    1,   83,   60,  115,   16,
 /*   230 */    87,   97,   15,   90,   91,   59,    1,   24,   19,   20,
 /*   240 */    16,   15,   99,  100,   18,   20,  103,  104,  105,   60,
 /*   250 */   107,   16,   28,   36,   84,   20,   86,  114,  111,  112,
 /*   260 */    17,   18,   38,   39,   40,   41,   42,   43,   44,   45,
 /*   270 */    46,   47,   48,   49,   50,   51,    1,    2,   59,   91,
 /*   280 */    92,   93,   57,  111,  112,   24,   60,   62,   64,   65,
 /*   290 */    66,   67,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   300 */    89,    1,   88,   89,   61,   35,   35,   37,   37,   98,
 /*   310 */    17,   18,   98,   38,   39,   40,   41,   42,   43,   44,
 /*   320 */    45,   46,   47,   48,   49,   50,   51,    1,   89,  115,
 /*   330 */    35,   35,   37,   88,   88,   91,   92,   98,   77,   64,
 /*   340 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   350 */    75,   23,   52,   89,  115,   29,  108,   97,  110,   63,
 /*   360 */   115,  115,   98,   35,   38,   39,   40,   41,   42,   43,
 /*   370 */    44,   45,   46,   47,   48,   49,   50,   51,    1,  115,
 /*   380 */    89,   15,   15,   15,   18,   18,   18,   95,   17,   98,
 /*   390 */    64,   65,   66,   67,   68,   69,   70,   71,   72,   73,
 /*   400 */    74,   75,  110,   89,   91,   92,  115,   36,    1,  108,
 /*   410 */    15,  110,   98,   18,  108,   38,   39,   40,   41,   42,
 /*   420 */    43,   44,   45,   46,   47,   48,   49,   50,   51,  115,
 /*   430 */   106,  106,   36,   15,   97,   28,   18,  113,  113,  108,
 /*   440 */    95,   64,   65,   66,   67,   68,   69,   70,   71,   72,
 /*   450 */    73,   74,   75,    1,   77,  110,   83,  108,   15,   18,
 /*   460 */    87,   18,   83,   90,   91,   20,   87,   17,   19,   91,
 /*   470 */    91,   28,   99,  100,    1,   23,  103,  104,  105,  100,
 /*   480 */   107,  103,  103,  104,  105,  107,  107,  114,    2,   16,
 /*   490 */    38,   39,   40,   41,   42,   43,   44,   45,   46,   47,
 /*   500 */    48,   49,   50,   51,   59,   19,   57,   19,   37,   61,
 /*   510 */    18,   17,   53,    2,   18,   95,   64,   65,   66,   67,
 /*   520 */    68,   69,   70,   71,   72,   73,   74,   75,    1,   83,
 /*   530 */   110,   89,   63,   87,   83,   25,   90,   91,   87,   17,
 /*   540 */    98,   18,   91,   16,    1,   99,  100,    1,    2,  103,
 /*   550 */   104,  105,  110,  107,  103,  104,  105,   18,  107,   16,
 /*   560 */   114,   61,   16,   34,    1,   38,   39,   40,   41,   42,
 /*   570 */    43,   44,   45,   46,   47,   48,   49,   50,   51,   16,
 /*   580 */    89,    2,   18,   17,   24,   57,   34,   36,   17,   98,
 /*   590 */    95,   64,   65,   66,   67,   68,   69,   70,   71,   72,
 /*   600 */    73,   74,   75,    1,   83,  110,   89,   18,   87,   18,
 /*   610 */    16,   90,   91,   92,   89,   98,   96,   16,   16,   16,
 /*   620 */    99,  100,   28,   98,  103,  104,  105,  110,  107,   28,
 /*   630 */   110,   28,   18,   18,   98,  110,   20,    1,   28,  109,
 /*   640 */    38,   39,   40,   41,   42,   43,   44,   45,   46,   47,
 /*   650 */    48,   49,   50,   51,    1,  115,  108,   28,  113,  110,
 /*   660 */    28,   94,  112,   95,   95,   95,   64,   65,   66,   67,
 /*   670 */    68,   69,   70,   71,   72,   73,   74,   75,  110,  110,
 /*   680 */   110,   85,   94,   13,  121,  121,  121,  121,  121,  121,
 /*   690 */    37,   38,   39,   40,   41,   42,   43,   44,   45,   46,
 /*   700 */    47,   48,   49,   50,   51,    1,  121,  121,  121,  121,
 /*   710 */   121,  121,  121,  121,   95,   95,   95,   64,   65,   66,
 /*   720 */    67,   68,   69,   70,   71,   72,   73,   74,   75,  110,
 /*   730 */   110,  110,  121,  121,  121,  121,  121,  121,  121,  121,
 /*   740 */   121,   37,   38,   39,   40,   41,   42,   43,   44,   45,
 /*   750 */    46,   47,   48,   49,   50,   51,    1,  121,  121,  121,
 /*   760 */   121,  121,  121,  121,  121,  121,  121,  121,   64,   65,
 /*   770 */    66,   67,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   780 */    83,  121,  121,   28,  121,  121,  121,  121,  121,  121,
 /*   790 */   121,  121,  121,   38,   39,   40,   41,   42,   43,   44,
 /*   800 */    45,   46,   47,   48,   49,   50,   51,    1,  121,  121,
 /*   810 */   121,  121,  121,  121,  121,  121,  121,  120,  121,   64,
 /*   820 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   830 */    75,  121,  121,  121,  121,  121,  121,  121,  121,  121,
 /*   840 */   121,  121,  121,  121,   38,   39,   40,   41,   42,   43,
 /*   850 */    44,   45,   46,   47,   48,   49,   50,   51,  121,  121,
 /*   860 */   121,  121,  121,  121,  121,  121,  121,  121,  121,   63,
 /*   870 */    64,   65,   66,   67,   68,   69,   70,   71,   72,   73,
 /*   880 */    74,   75,    1,  121,  121,  121,   88,   83,    1,   16,
 /*   890 */    16,   87,  121,   10,   16,   91,  121,   16,   15,  101,
 /*   900 */   102,   28,   28,   16,   21,   22,   28,  103,  104,  105,
 /*   910 */    27,  107,  121,  115,   31,   32,   33,  121,    1,   38,
 /*   920 */    39,   40,   41,   42,   43,   44,   45,   46,   47,   48,
 /*   930 */    49,   50,   51,   16,  121,  121,  121,  121,  121,   52,
 /*   940 */   121,  121,  121,  121,  121,   64,   65,   66,   67,   68,
 /*   950 */    69,   70,   71,   72,   73,   74,   75,    1,  121,   76,
 /*   960 */    77,   78,   83,   16,   16,   16,   87,  121,   10,   16,
 /*   970 */    91,  121,   16,   15,  121,   28,   28,   28,  121,   21,
 /*   980 */    22,   28,  103,  104,  105,   27,  107,  121,  121,   31,
 /*   990 */    32,   33,  121,  121,   38,   39,   40,   41,   42,   43,
 /*  1000 */    44,   45,   46,   47,   48,   49,   50,   51,    1,  121,
 /*  1010 */   121,  121,  121,  121,  121,  121,  121,  121,  121,  121,
 /*  1020 */    64,   65,   66,   67,   68,   69,   70,   71,   72,   73,
 /*  1030 */    74,   75,  121,  121,   76,   77,   78,  121,  121,  121,
 /*  1040 */   121,  121,  121,  121,  121,   38,   39,   40,   41,   42,
 /*  1050 */    43,   44,   45,   46,   47,   48,   49,   50,   51,  121,
 /*  1060 */   121,  121,  121,  121,  121,  121,  121,  121,  121,  121,
 /*  1070 */   121,   64,   65,   66,   67,   68,   69,   70,   71,   72,
 /*  1080 */    73,   74,   75,  121,   38,   39,   40,   41,   42,   43,
 /*  1090 */    44,   45,   46,   47,   48,   49,   50,   51,  121,  121,
 /*  1100 */   121,  121,  121,  121,  121,  121,  121,  121,  121,  121,
 /*  1110 */    64,   65,   66,   67,   68,   69,   70,   71,   72,   73,
 /*  1120 */    74,   75,  121,  121,  121,  121,   15,  121,   17,   18,
 /*  1130 */   121,   83,   21,   22,   16,   87,  121,   16,   27,   91,
 /*  1140 */   121,  121,   31,   32,   33,   34,   28,   36,  100,   28,
 /*  1150 */    39,  103,  104,  105,  121,  107,   83,  121,  121,  121,
 /*  1160 */    87,  121,  121,  121,   91,   54,   55,   56,   57,   58,
 /*  1170 */   121,   83,   61,   62,   63,   87,  103,  104,  105,   91,
 /*  1180 */   107,  121,   15,  121,   17,   18,  121,   76,   21,   22,
 /*  1190 */    16,  103,  104,  105,   27,  107,   16,   16,   31,   32,
 /*  1200 */    33,   34,   28,   36,   16,  121,   39,   16,   28,   28,
 /*  1210 */    83,  121,  121,  121,   87,  121,   28,   90,   91,   28,
 /*  1220 */     1,   54,   55,   56,   57,   58,   99,  100,   61,   62,
 /*  1230 */   103,  104,  105,    1,  107,   16,  121,   16,   15,  121,
 /*  1240 */    17,   18,  121,   76,   21,   22,   16,   28,   16,   28,
 /*  1250 */    27,   16,   20,  121,   31,   32,   33,   34,   28,   36,
 /*  1260 */    28,  121,   39,   28,   16,  121,   83,  121,   36,  121,
 /*  1270 */    87,   52,  121,   90,   91,  121,   28,   54,   55,   56,
 /*  1280 */    57,   58,   99,  100,   61,   62,  103,  104,  105,  121,
 /*  1290 */   107,   59,  121,  121,   15,  121,   17,   18,  121,   76,
 /*  1300 */    21,   22,  121,  121,  121,  121,   27,  121,  121,  121,
 /*  1310 */    31,   32,   33,   34,  121,   36,  121,  121,   39,  121,
 /*  1320 */   121,  121,   83,  121,  121,  121,   87,  121,  121,   90,
 /*  1330 */    91,  121,    1,   54,   55,   56,   57,   58,   99,  100,
 /*  1340 */    61,   62,  103,  104,  105,  121,  107,   16,  121,  121,
 /*  1350 */    15,  121,   17,   18,  121,   76,   21,   22,  121,   28,
 /*  1360 */    29,  121,   27,  121,  121,  121,   31,   32,   33,   34,
 /*  1370 */   121,   36,  121,  121,   39,  121,  121,  121,   83,  121,
 /*  1380 */   121,  121,   87,   52,  121,   90,   91,  121,    1,   54,
 /*  1390 */    55,   56,   57,   58,   99,  100,   61,   62,  103,  104,
 /*  1400 */   105,  121,  107,   16,  121,  121,   15,  121,   17,   18,
 /*  1410 */   121,   76,   21,   22,  121,   28,  121,  121,   27,  121,
 /*  1420 */   121,  121,   31,   32,   33,   34,  121,   36,  121,  121,
 /*  1430 */    39,  121,  121,  121,   83,  121,  121,  121,   87,   52,
 /*  1440 */   121,   90,   91,  121,    1,   54,   55,   56,   57,   58,
 /*  1450 */    99,  100,   61,   62,  103,  104,  105,  121,  107,   16,
 /*  1460 */   121,  121,   15,  121,   17,   18,  121,   76,   21,   22,
 /*  1470 */   121,   28,  121,  121,   27,  121,  121,  121,   31,   32,
 /*  1480 */    33,   34,  121,   36,  121,  121,   39,  121,  121,  121,
 /*  1490 */    83,  121,  121,  121,   87,   52,  121,   90,   91,  121,
 /*  1500 */   121,   54,   55,   56,   57,   58,   99,  100,   61,   62,
 /*  1510 */   103,  104,  105,  121,  107,  121,  121,  121,   15,  121,
 /*  1520 */    17,   18,  121,   76,   21,   22,  121,  121,  121,  121,
 /*  1530 */    27,  121,  121,  121,   31,   32,   33,   34,  121,   36,
 /*  1540 */   121,  121,   39,  121,  121,  121,   83,  121,  121,  121,
 /*  1550 */    87,  121,  121,   90,   91,  121,  121,   54,   55,   56,
 /*  1560 */    57,   58,   99,  100,   61,   62,  103,  104,  105,  121,
 /*  1570 */   107,  121,  121,  121,   15,  121,   17,   18,  121,   76,
 /*  1580 */    21,   22,  121,  121,  121,  121,   27,  121,  121,  121,
 /*  1590 */    31,   32,   33,   34,  121,   36,  121,  121,   39,  121,
 /*  1600 */   121,  121,   83,  121,  121,  121,   87,  121,  121,   90,
 /*  1610 */    91,  121,  121,   54,   55,   56,   57,   58,   99,  100,
 /*  1620 */    61,   62,  103,  104,  105,  121,  107,  121,  121,  121,
 /*  1630 */    15,  121,   17,   18,  121,   76,   21,   22,  121,  121,
 /*  1640 */   121,  121,   27,  121,  121,  121,   31,   32,   33,   34,
 /*  1650 */   121,   36,  121,  121,   39,  121,  121,  121,   83,  121,
 /*  1660 */   121,  121,   87,  121,  121,   90,   91,  121,  121,   54,
 /*  1670 */    55,   56,   57,   58,   99,  100,   61,   62,  103,  104,
 /*  1680 */   105,  121,  107,  121,  121,  121,   15,  121,   17,   18,
 /*  1690 */   121,   76,   21,   22,  121,  121,  121,  121,   27,  121,
 /*  1700 */   121,  121,   31,   32,   33,   34,  121,   36,  121,  121,
 /*  1710 */    39,  121,  121,  121,   83,  121,  121,  121,   87,  121,
 /*  1720 */   121,   90,   91,  121,  121,   54,   55,   56,   57,   58,
 /*  1730 */    99,  100,   61,  121,  103,  104,  105,  121,  107,  121,
 /*  1740 */   121,  121,   15,  121,   17,   18,  121,   76,   21,   22,
 /*  1750 */   121,  121,  121,  121,   27,  121,  121,  121,   31,   32,
 /*  1760 */    33,   34,  121,   36,   88,   89,   39,  121,  121,  121,
 /*  1770 */   121,  121,  121,  121,   98,  121,  121,  101,  102,  121,
 /*  1780 */    16,   54,   55,   56,   57,   58,  121,   23,   61,   25,
 /*  1790 */    26,  115,   28,   29,  121,  121,  121,  121,  121,   35,
 /*  1800 */    36,   37,  121,   76,  121,  121,  121,  121,  121,  121,
 /*  1810 */   121,  121,  121,   83,  121,  121,   52,   87,  121,  121,
 /*  1820 */    90,   91,  121,   59,  121,  121,  121,   63,  121,   99,
 /*  1830 */   100,  121,  121,  103,  104,  105,  121,  107,   83,  121,
 /*  1840 */   121,   77,   87,  121,  121,   90,   91,  121,  118,  121,
 /*  1850 */   121,  121,  121,  121,   99,  100,  121,  121,  103,  104,
 /*  1860 */   105,  121,  107,  121,   83,  121,  121,  121,   87,  121,
 /*  1870 */   121,   90,   91,  121,   83,  121,  121,  121,   87,  121,
 /*  1880 */    99,  100,   91,   83,  103,  104,  105,   87,  107,  121,
 /*  1890 */    90,   91,  121,  121,  103,  104,  105,  121,  107,   99,
 /*  1900 */   100,  121,  121,  103,  104,  105,  121,  107,  121,  121,
 /*  1910 */   121,   83,  121,  121,  121,   87,  121,  121,   90,   91,
 /*  1920 */   121,  121,   83,  121,  121,  121,   87,   99,  100,   90,
 /*  1930 */    91,  103,  104,  105,  121,  107,  121,  121,   99,  100,
 /*  1940 */   121,  121,  103,  104,  105,  121,  107,  121,   83,  121,
 /*  1950 */   121,  121,   87,  121,  121,   90,   91,  121,   83,  121,
 /*  1960 */   121,  121,   87,  121,   99,  100,   91,   83,  103,  104,
 /*  1970 */   105,   87,  107,  121,   90,   91,  121,  121,  103,  104,
 /*  1980 */   105,  121,  107,   99,  100,  121,  121,  103,  104,  105,
 /*  1990 */   121,  107,  121,  121,  121,   83,  121,  121,  121,   87,
 /*  2000 */   121,  121,   90,   91,  121,  121,   83,  121,  121,  121,
 /*  2010 */    87,   99,  100,   90,   91,  103,  104,  105,  121,  107,
 /*  2020 */   121,  121,   99,  100,  121,  121,  103,  104,  105,  121,
 /*  2030 */   107,  121,   83,   88,   89,  121,   87,  121,  121,   90,
 /*  2040 */    91,  121,  121,   98,  121,  121,  101,  102,   99,  100,
 /*  2050 */   121,   83,  103,  104,  105,   87,  107,  121,   90,   91,
 /*  2060 */   115,  121,  121,  121,   88,   89,  121,   99,  100,  121,
 /*  2070 */   121,  103,  104,  105,   98,  107,  121,  101,  102,   83,
 /*  2080 */   121,  121,  121,   87,  121,  121,   90,   91,  121,  121,
 /*  2090 */    83,  115,  121,  121,   87,   99,  100,   90,   91,  103,
 /*  2100 */   104,  105,  121,  107,  121,  121,   99,  100,  121,  121,
 /*  2110 */   103,  104,  105,  121,  107,  121,   83,   88,   89,  121,
 /*  2120 */    87,  121,  121,   90,   91,  121,  121,   98,  121,  121,
 /*  2130 */   101,  102,   99,  100,  121,   83,  103,  104,  105,   87,
 /*  2140 */   107,  121,   90,   91,  115,  121,  121,  121,   88,   89,
 /*  2150 */   121,   99,  100,  121,  121,  103,  104,  105,   98,  107,
 /*  2160 */   121,  101,  102,   83,  121,  121,  121,   87,  121,  121,
 /*  2170 */    90,   91,  121,  121,   83,  115,  121,  121,   87,   99,
 /*  2180 */   100,   90,   91,  103,  104,  105,  121,  107,  121,  121,
 /*  2190 */    99,  100,  121,  121,  103,  104,  105,  121,  107,  121,
 /*  2200 */    83,   88,   89,  121,   87,  121,  121,   90,   91,  121,
 /*  2210 */   121,   98,  121,  121,  101,  102,   99,  100,  121,   83,
 /*  2220 */   103,  104,  105,   87,  107,  121,   90,   91,  115,  121,
 /*  2230 */   121,  121,  121,  121,  121,   99,  100,  121,  121,  103,
 /*  2240 */   104,  105,  121,  107,  121,  121,  121,   83,  121,  121,
 /*  2250 */   121,   87,  121,  121,   90,   91,  121,  121,   83,  121,
 /*  2260 */   121,  121,   87,   99,  100,   90,   91,  103,  104,  105,
 /*  2270 */   121,  107,  121,  121,   99,  100,  121,  121,  103,  104,
 /*  2280 */   105,  121,  107,  121,   83,  121,  121,  121,   87,  121,
 /*  2290 */   121,   90,   91,  121,  121,  121,  121,  121,  121,  121,
 /*  2300 */    99,  100,  121,   83,  103,  104,  105,   87,  107,  121,
 /*  2310 */    90,   91,  121,  121,  121,  121,  121,  121,  121,   99,
 /*  2320 */   100,  121,  121,  103,  104,  105,  121,  107,  121,  121,
 /*  2330 */   121,   83,  121,  121,  121,   87,  121,  121,   90,   91,
 /*  2340 */   121,  121,   83,  121,  121,  121,   87,   99,  100,   90,
 /*  2350 */    91,  103,  104,  105,  121,  107,  121,  121,   99,  100,
 /*  2360 */   121,  121,  103,  104,  105,  121,  107,  121,   83,  121,
 /*  2370 */   121,  121,   87,  121,  121,   90,   91,  121,  121,  121,
 /*  2380 */   121,  121,  121,  121,   99,  100,  121,  121,  103,  104,
 /*  2390 */   105,  121,  107,
);
    const YY_SHIFT_USE_DFLT = -5;
    const YY_SHIFT_MAX = 252;
    static public $yy_shift_ofst = array(
 /*     0 */     1, 1391, 1391, 1223, 1167, 1167, 1167, 1223, 1111, 1167,
 /*    10 */  1167, 1167, 1503, 1167, 1559, 1167, 1167, 1167, 1167, 1167,
 /*    20 */  1167, 1167, 1167, 1167, 1167, 1615, 1167, 1167, 1167, 1167,
 /*    30 */  1503, 1167, 1167, 1447, 1167, 1167, 1167, 1167, 1279, 1167,
 /*    40 */  1167, 1167, 1279, 1167, 1335, 1335, 1727, 1671, 1727, 1727,
 /*    50 */  1727, 1727, 1727,  224,   74,  149,   -1,  755,  755,  755,
 /*    60 */   956,  881,  806,  527,  326,  704,  275,  377,  653,  602,
 /*    70 */   452, 1007, 1007, 1007, 1007, 1007, 1007, 1007, 1007, 1007,
 /*    80 */  1007, 1007, 1007, 1007, 1007, 1007, 1007, 1007, 1007, 1007,
 /*    90 */  1046, 1046, 1232, 1443,  407,    1,  958,   73,  146,  225,
 /*   100 */   546,   61,   61,  443,  443,  243,  371,  407,  407,  883,
 /*   110 */    47, 1331,   11,  189, 1387, 1219,  226,   56,  138,  235,
 /*   120 */    75,  887,  219,  366,  371,  367,  366,  366,  368,  293,
 /*   130 */   371,  366,  917,  366,  366,  445,  366,  418,  366, 1248,
 /*   140 */   368,  366,  300,  395,  293,  636,  629,  636,  616,  636,
 /*   150 */   610,  636,  636,  636,  636,  616,  636,   -5,  166,  167,
 /*   160 */   601,  603,  873,  594,  148,  217,  148,  473,  947,  148,
 /*   170 */   874,  878,  948, 1235,  148,  543, 1191, 1221,  148, 1230,
 /*   180 */   563, 1188, 1121, 1118,  953,  949, 1181, 1174, 1180,  670,
 /*   190 */   632,  632,  616,  616,  636,  616,  636,  102,  102,  396,
 /*   200 */    -5,   -5,   -5,   -5,   -5, 1764,  150,   22,  118,   71,
 /*   210 */   176,   -4,  486,  144,  144,  213,  270,  261,  296,  328,
 /*   220 */   449,  271,  295,  615,  579,  560,  566,  441,  564,  396,
 /*   230 */   528,  591,  551,  589,  571,  614,  552,  529,  539,  494,
 /*   240 */   448,  492,  471,  450,  488,  469,  459,  511,  522,  510,
 /*   250 */   496,  523,  500,
);
    const YY_REDUCE_USE_DFLT = -86;
    const YY_REDUCE_MAX = 204;
    static public $yy_reduce_ofst = array(
 /*     0 */   -63,   -7, 1730,   68,  446,  373,  143,  521, 2091, 2117,
 /*    10 */  1800, 1407, 2080, 1884, 1912, 1575, 1949, 1923, 1865, 1968,
 /*    20 */  1996, 2052, 2033, 2007, 1839, 1828, 1351, 1295, 1183, 1239,
 /*    30 */  1463, 1519, 1781, 1755, 1631, 2175, 2248, 2201, 2164, 2285,
 /*    40 */  2259, 2136, 2220, 1127,  379, 1048,  451, 1073,  804,  879,
 /*    50 */  1875, 1791, 1088, 1976, 1945, 1676, 2060, 1676, 2113, 2029,
 /*    60 */   798,  798,  798,  798,  798,  798,  798,  798,  798,  798,
 /*    70 */   798,  798,  798,  798,  798,  798,  798,  798,  798,  798,
 /*    80 */   798,  798,  798,  798,  798,  798,  798,  798,  798,  798,
 /*    90 */   798,  798,   39,  113,  214,  -81,   43,  442,  -74,   20,
 /*   100 */   -10,  239,  264,  525,  517,  378,  188,  314,  291,  697,
 /*   110 */   170,   -6,  520,  248,   -6,   -6,  248,   -6,  248,  246,
 /*   120 */   172,   -6,  172,  568,  313,  495,  495,  569,  570,  324,
 /*   130 */   244,  292,  245,  420,  345,  172,  301,  495,  621,  491,
 /*   140 */   495,  619,   -6,  620,  325,   -6,  211,   -6,  147,   -6,
 /*   150 */    81,   -6,   -6,   -6,   -6,  172,   -6,   -6,  545,  549,
 /*   160 */   536,  536,  536,  536,  530,  548,  530,  540,  536,  530,
 /*   170 */   536,  536,  536,  536,  530,  540,  536,  536,  530,  536,
 /*   180 */   540,  536,  536,  536,  536,  536,  536,  536,  536,  596,
 /*   190 */   567,  588,  550,  550,  540,  550,  540,  -85,  -85,  331,
 /*   200 */   306,  349,  337,  260,  134,
);
    static public $yyExpectedTokens = array(
        /* 0 */ array(3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 15, 21, 22, 27, 31, 32, 33, ),
        /* 1 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 2 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 3 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 4 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 5 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 6 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 7 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 8 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 63, 76, ),
        /* 9 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 10 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 11 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 12 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 13 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 14 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 15 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 16 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 17 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 18 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 19 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 20 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 21 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 22 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 23 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 24 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 25 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 26 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 27 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 28 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 29 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 30 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 31 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 32 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 33 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 34 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 35 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 36 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 37 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 38 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 39 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 40 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 41 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 42 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 43 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 44 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 45 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 62, 76, ),
        /* 46 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 76, ),
        /* 47 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 76, ),
        /* 48 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 76, ),
        /* 49 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 76, ),
        /* 50 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 76, ),
        /* 51 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 76, ),
        /* 52 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 34, 36, 39, 54, 55, 56, 57, 58, 61, 76, ),
        /* 53 */ array(1, 16, 28, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, ),
        /* 54 */ array(1, 16, 28, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, ),
        /* 55 */ array(1, 16, 28, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, ),
        /* 56 */ array(1, 26, 28, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, ),
        /* 57 */ array(1, 28, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, ),
        /* 58 */ array(1, 28, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, ),
        /* 59 */ array(1, 28, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, ),
        /* 60 */ array(1, 16, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, ),
        /* 61 */ array(1, 16, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, ),
        /* 62 */ array(1, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, ),
        /* 63 */ array(1, 16, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, ),
        /* 64 */ array(1, 29, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, ),
        /* 65 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, ),
        /* 66 */ array(1, 2, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, ),
        /* 67 */ array(1, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 77, ),
        /* 68 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, ),
        /* 69 */ array(1, 16, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, ),
        /* 70 */ array(1, 23, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, ),
        /* 71 */ array(1, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, ),
        /* 72 */ array(1, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, ),
        /* 73 */ array(1, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, ),
        /* 74 */ array(1, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, ),
        /* 75 */ array(1, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, ),
        /* 76 */ array(1, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, ),
        /* 77 */ array(1, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, ),
        /* 78 */ array(1, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, ),
        /* 79 */ array(1, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, ),
        /* 80 */ array(1, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, ),
        /* 81 */ array(1, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, ),
        /* 82 */ array(1, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, ),
        /* 83 */ array(1, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, ),
        /* 84 */ array(1, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, ),
        /* 85 */ array(1, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, ),
        /* 86 */ array(1, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, ),
        /* 87 */ array(1, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, ),
        /* 88 */ array(1, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, ),
        /* 89 */ array(1, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, ),
        /* 90 */ array(38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, ),
        /* 91 */ array(38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, ),
        /* 92 */ array(1, 16, 20, 28, 36, 59, ),
        /* 93 */ array(1, 16, 28, 52, ),
        /* 94 */ array(1, 28, ),
        /* 95 */ array(3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 15, 21, 22, 27, 31, 32, 33, ),
        /* 96 */ array(10, 15, 21, 22, 27, 31, 32, 33, 76, 77, 78, ),
        /* 97 */ array(15, 18, 28, 30, ),
        /* 98 */ array(15, 18, 28, 30, ),
        /* 99 */ array(20, 57, 62, ),
        /* 100 */ array(1, 2, 16, ),
        /* 101 */ array(1, 16, 28, ),
        /* 102 */ array(1, 16, 28, ),
        /* 103 */ array(15, 18, 28, ),
        /* 104 */ array(15, 18, 28, ),
        /* 105 */ array(17, 18, 61, ),
        /* 106 */ array(17, 36, ),
        /* 107 */ array(1, 28, ),
        /* 108 */ array(1, 28, ),
        /* 109 */ array(10, 15, 21, 22, 27, 31, 32, 33, 76, 77, 78, ),
        /* 110 */ array(4, 5, 6, 7, 8, 12, 13, 14, ),
        /* 111 */ array(1, 16, 28, 29, 52, ),
        /* 112 */ array(15, 18, 19, 24, ),
        /* 113 */ array(15, 18, 19, 60, ),
        /* 114 */ array(1, 16, 28, 52, ),
        /* 115 */ array(1, 16, 28, 52, ),
        /* 116 */ array(15, 18, 60, ),
        /* 117 */ array(1, 30, 52, ),
        /* 118 */ array(15, 18, 19, ),
        /* 119 */ array(1, 16, 20, ),
        /* 120 */ array(19, 20, 59, ),
        /* 121 */ array(1, 16, 52, ),
        /* 122 */ array(19, 20, 59, ),
        /* 123 */ array(15, 18, ),
        /* 124 */ array(17, 36, ),
        /* 125 */ array(15, 18, ),
        /* 126 */ array(15, 18, ),
        /* 127 */ array(15, 18, ),
        /* 128 */ array(15, 18, ),
        /* 129 */ array(17, 18, ),
        /* 130 */ array(17, 36, ),
        /* 131 */ array(15, 18, ),
        /* 132 */ array(1, 16, ),
        /* 133 */ array(15, 18, ),
        /* 134 */ array(15, 18, ),
        /* 135 */ array(20, 59, ),
        /* 136 */ array(15, 18, ),
        /* 137 */ array(15, 18, ),
        /* 138 */ array(15, 18, ),
        /* 139 */ array(16, 28, ),
        /* 140 */ array(15, 18, ),
        /* 141 */ array(15, 18, ),
        /* 142 */ array(1, 52, ),
        /* 143 */ array(15, 18, ),
        /* 144 */ array(17, 18, ),
        /* 145 */ array(1, ),
        /* 146 */ array(28, ),
        /* 147 */ array(1, ),
        /* 148 */ array(20, ),
        /* 149 */ array(1, ),
        /* 150 */ array(28, ),
        /* 151 */ array(1, ),
        /* 152 */ array(1, ),
        /* 153 */ array(1, ),
        /* 154 */ array(1, ),
        /* 155 */ array(20, ),
        /* 156 */ array(1, ),
        /* 157 */ array(),
        /* 158 */ array(15, 17, 18, ),
        /* 159 */ array(15, 18, 60, ),
        /* 160 */ array(16, 28, ),
        /* 161 */ array(16, 28, ),
        /* 162 */ array(16, 28, ),
        /* 163 */ array(16, 28, ),
        /* 164 */ array(57, 62, ),
        /* 165 */ array(15, 36, ),
        /* 166 */ array(57, 62, ),
        /* 167 */ array(1, 16, ),
        /* 168 */ array(16, 28, ),
        /* 169 */ array(57, 62, ),
        /* 170 */ array(16, 28, ),
        /* 171 */ array(16, 28, ),
        /* 172 */ array(16, 28, ),
        /* 173 */ array(16, 28, ),
        /* 174 */ array(57, 62, ),
        /* 175 */ array(1, 16, ),
        /* 176 */ array(16, 28, ),
        /* 177 */ array(16, 28, ),
        /* 178 */ array(57, 62, ),
        /* 179 */ array(16, 28, ),
        /* 180 */ array(1, 16, ),
        /* 181 */ array(16, 28, ),
        /* 182 */ array(16, 28, ),
        /* 183 */ array(16, 28, ),
        /* 184 */ array(16, 28, ),
        /* 185 */ array(16, 28, ),
        /* 186 */ array(16, 28, ),
        /* 187 */ array(16, 28, ),
        /* 188 */ array(16, 28, ),
        /* 189 */ array(13, ),
        /* 190 */ array(28, ),
        /* 191 */ array(28, ),
        /* 192 */ array(20, ),
        /* 193 */ array(20, ),
        /* 194 */ array(1, ),
        /* 195 */ array(20, ),
        /* 196 */ array(1, ),
        /* 197 */ array(2, ),
        /* 198 */ array(2, ),
        /* 199 */ array(36, ),
        /* 200 */ array(),
        /* 201 */ array(),
        /* 202 */ array(),
        /* 203 */ array(),
        /* 204 */ array(),
        /* 205 */ array(16, 23, 25, 26, 28, 29, 35, 36, 37, 52, 59, 63, 77, ),
        /* 206 */ array(16, 19, 28, 36, 59, ),
        /* 207 */ array(36, 57, 59, 63, ),
        /* 208 */ array(15, 17, 18, 34, ),
        /* 209 */ array(16, 28, 36, 59, ),
        /* 210 */ array(30, 36, 59, ),
        /* 211 */ array(18, 60, ),
        /* 212 */ array(2, 19, ),
        /* 213 */ array(36, 59, ),
        /* 214 */ array(36, 59, ),
        /* 215 */ array(16, 24, ),
        /* 216 */ array(35, 37, ),
        /* 217 */ array(24, 77, ),
        /* 218 */ array(35, 63, ),
        /* 219 */ array(23, 35, ),
        /* 220 */ array(19, 57, ),
        /* 221 */ array(35, 37, ),
        /* 222 */ array(35, 37, ),
        /* 223 */ array(18, ),
        /* 224 */ array(2, ),
        /* 225 */ array(24, ),
        /* 226 */ array(17, ),
        /* 227 */ array(18, ),
        /* 228 */ array(18, ),
        /* 229 */ array(36, ),
        /* 230 */ array(57, ),
        /* 231 */ array(18, ),
        /* 232 */ array(36, ),
        /* 233 */ array(18, ),
        /* 234 */ array(17, ),
        /* 235 */ array(18, ),
        /* 236 */ array(34, ),
        /* 237 */ array(34, ),
        /* 238 */ array(18, ),
        /* 239 */ array(17, ),
        /* 240 */ array(61, ),
        /* 241 */ array(18, ),
        /* 242 */ array(37, ),
        /* 243 */ array(17, ),
        /* 244 */ array(19, ),
        /* 245 */ array(63, ),
        /* 246 */ array(53, ),
        /* 247 */ array(2, ),
        /* 248 */ array(17, ),
        /* 249 */ array(25, ),
        /* 250 */ array(18, ),
        /* 251 */ array(18, ),
        /* 252 */ array(61, ),
        /* 253 */ array(),
        /* 254 */ array(),
        /* 255 */ array(),
        /* 256 */ array(),
        /* 257 */ array(),
        /* 258 */ array(),
        /* 259 */ array(),
        /* 260 */ array(),
        /* 261 */ array(),
        /* 262 */ array(),
        /* 263 */ array(),
        /* 264 */ array(),
        /* 265 */ array(),
        /* 266 */ array(),
        /* 267 */ array(),
        /* 268 */ array(),
        /* 269 */ array(),
        /* 270 */ array(),
        /* 271 */ array(),
        /* 272 */ array(),
        /* 273 */ array(),
        /* 274 */ array(),
        /* 275 */ array(),
        /* 276 */ array(),
        /* 277 */ array(),
        /* 278 */ array(),
        /* 279 */ array(),
        /* 280 */ array(),
        /* 281 */ array(),
        /* 282 */ array(),
        /* 283 */ array(),
        /* 284 */ array(),
        /* 285 */ array(),
        /* 286 */ array(),
        /* 287 */ array(),
        /* 288 */ array(),
        /* 289 */ array(),
        /* 290 */ array(),
        /* 291 */ array(),
        /* 292 */ array(),
        /* 293 */ array(),
        /* 294 */ array(),
        /* 295 */ array(),
        /* 296 */ array(),
        /* 297 */ array(),
        /* 298 */ array(),
        /* 299 */ array(),
        /* 300 */ array(),
        /* 301 */ array(),
        /* 302 */ array(),
        /* 303 */ array(),
        /* 304 */ array(),
        /* 305 */ array(),
        /* 306 */ array(),
        /* 307 */ array(),
        /* 308 */ array(),
        /* 309 */ array(),
        /* 310 */ array(),
        /* 311 */ array(),
        /* 312 */ array(),
        /* 313 */ array(),
        /* 314 */ array(),
        /* 315 */ array(),
        /* 316 */ array(),
        /* 317 */ array(),
        /* 318 */ array(),
        /* 319 */ array(),
        /* 320 */ array(),
        /* 321 */ array(),
        /* 322 */ array(),
        /* 323 */ array(),
        /* 324 */ array(),
        /* 325 */ array(),
        /* 326 */ array(),
        /* 327 */ array(),
        /* 328 */ array(),
        /* 329 */ array(),
        /* 330 */ array(),
        /* 331 */ array(),
        /* 332 */ array(),
        /* 333 */ array(),
        /* 334 */ array(),
        /* 335 */ array(),
        /* 336 */ array(),
        /* 337 */ array(),
        /* 338 */ array(),
        /* 339 */ array(),
        /* 340 */ array(),
        /* 341 */ array(),
        /* 342 */ array(),
        /* 343 */ array(),
        /* 344 */ array(),
        /* 345 */ array(),
        /* 346 */ array(),
        /* 347 */ array(),
        /* 348 */ array(),
        /* 349 */ array(),
        /* 350 */ array(),
        /* 351 */ array(),
        /* 352 */ array(),
        /* 353 */ array(),
        /* 354 */ array(),
        /* 355 */ array(),
        /* 356 */ array(),
        /* 357 */ array(),
        /* 358 */ array(),
        /* 359 */ array(),
        /* 360 */ array(),
        /* 361 */ array(),
        /* 362 */ array(),
        /* 363 */ array(),
        /* 364 */ array(),
        /* 365 */ array(),
        /* 366 */ array(),
        /* 367 */ array(),
        /* 368 */ array(),
        /* 369 */ array(),
        /* 370 */ array(),
        /* 371 */ array(),
        /* 372 */ array(),
        /* 373 */ array(),
        /* 374 */ array(),
        /* 375 */ array(),
        /* 376 */ array(),
        /* 377 */ array(),
        /* 378 */ array(),
        /* 379 */ array(),
        /* 380 */ array(),
        /* 381 */ array(),
        /* 382 */ array(),
        /* 383 */ array(),
        /* 384 */ array(),
        /* 385 */ array(),
        /* 386 */ array(),
);
    static public $yy_default = array(
 /*     0 */   390,  571,  588,  588,  542,  542,  542,  588,  588,  588,
 /*    10 */   588,  588,  588,  588,  588,  588,  588,  588,  588,  588,
 /*    20 */   588,  588,  588,  588,  588,  588,  588,  588,  588,  588,
 /*    30 */   588,  588,  588,  588,  588,  588,  588,  588,  588,  588,
 /*    40 */   588,  588,  588,  588,  588,  588,  588,  588,  588,  588,
 /*    50 */   588,  588,  588,  588,  588,  588,  450,  450,  450,  450,
 /*    60 */   588,  588,  588,  588,  455,  588,  588,  588,  588,  588,
 /*    70 */   588,  573,  457,  541,  574,  455,  471,  460,  540,  480,
 /*    80 */   484,  432,  461,  452,  479,  483,  572,  474,  475,  476,
 /*    90 */   487,  488,  499,  463,  450,  387,  588,  450,  450,  554,
 /*   100 */   588,  507,  470,  450,  450,  588,  588,  450,  450,  588,
 /*   110 */   588,  463,  588,  515,  463,  463,  515,  463,  515,  588,
 /*   120 */   508,  463,  508,  588,  588,  588,  588,  588,  588,  588,
 /*   130 */   588,  588,  588,  588,  588,  508,  515,  588,  588,  588,
 /*   140 */   588,  588,  463,  588,  588,  467,  450,  473,  551,  490,
 /*   150 */   450,  468,  486,  491,  492,  508,  466,  549,  588,  516,
 /*   160 */   588,  588,  588,  588,  533,  515,  532,  588,  588,  513,
 /*   170 */   588,  588,  588,  588,  534,  588,  588,  588,  535,  588,
 /*   180 */   588,  588,  588,  588,  588,  588,  588,  588,  588,  405,
 /*   190 */   587,  587,  529,  555,  470,  552,  507,  543,  544,  515,
 /*   200 */   515,  515,  548,  548,  548,  465,  499,  499,  588,  499,
 /*   210 */   499,  588,  527,  485,  499,  489,  588,  489,  588,  588,
 /*   220 */   495,  588,  588,  588,  527,  489,  588,  588,  588,  527,
 /*   230 */   495,  588,  553,  588,  588,  588,  497,  588,  588,  588,
 /*   240 */   588,  588,  588,  588,  588,  588,  501,  527,  588,  458,
 /*   250 */   588,  588,  588,  435,  524,  439,  501,  523,  511,  569,
 /*   260 */   521,  415,  522,  570,  520,  388,  537,  512,  440,  462,
 /*   270 */   459,  429,  550,  586,  430,  536,  528,  538,  539,  434,
 /*   280 */   433,  565,  441,  527,  442,  547,  443,  526,  438,  449,
 /*   290 */   428,  431,  436,  437,  444,  445,  498,  496,  504,  464,
 /*   300 */   465,  494,  493,  545,  546,  446,  447,  427,  448,  397,
 /*   310 */   396,  398,  399,  400,  395,  394,  389,  391,  392,  393,
 /*   320 */   401,  402,  411,  410,  412,  413,  414,  409,  408,  403,
 /*   330 */   404,  406,  407,  509,  514,  421,  420,  530,  422,  423,
 /*   340 */   419,  418,  531,  510,  416,  417,  583,  424,  426,  581,
 /*   350 */   579,  584,  585,  578,  580,  577,  425,  582,  575,  576,
 /*   360 */   506,  469,  503,  502,  505,  477,  478,  472,  500,  517,
 /*   370 */   525,  518,  519,  481,  482,  563,  562,  564,  566,  567,
 /*   380 */   561,  560,  556,  557,  558,  559,  568,
);
    const YYNOCODE = 122;
    const YYSTACKDEPTH = 100;
    const YYNSTATE = 387;
    const YYNRULE = 201;
    const YYERRORSYMBOL = 79;
    const YYERRSYMDT = 'yy0';
    const YYFALLBACK = 0;
    static public $yyFallback = array(
    );
    static function Trace($TraceFILE, $zTracePrompt)
    {
        if (!$TraceFILE) {
            $zTracePrompt = 0;
        } elseif (!$zTracePrompt) {
            $TraceFILE = 0;
        }
        self::$yyTraceFILE = $TraceFILE;
        self::$yyTracePrompt = $zTracePrompt;
    }

    static function PrintTrace()
    {
        self::$yyTraceFILE = fopen('php://output', 'w');
        self::$yyTracePrompt = '<br>';
    }

    static public $yyTraceFILE;
    static public $yyTracePrompt;
    public $yyidx;                    /* Index of top element in stack */
    public $yyerrcnt;                 /* Shifts left before out of the error */
    public $yystack = array();  /* The parser's stack */

    public $yyTokenName = array(
  '$',             'VERT',          'COLON',         'COMMENT',
  'PHPSTARTTAG',   'PHPENDTAG',     'ASPSTARTTAG',   'ASPENDTAG',
  'FAKEPHPSTARTTAG',  'XMLTAG',        'OTHER',         'LINEBREAK',
  'LITERALSTART',  'LITERALEND',    'LITERAL',       'LDEL',
  'RDEL',          'DOLLAR',        'ID',            'EQUAL',
  'PTR',           'LDELIF',        'LDELFOR',       'SEMICOLON',
  'INCDEC',        'TO',            'STEP',          'LDELFOREACH',
  'SPACE',         'AS',            'APTR',          'LDELSETFILTER',
  'SMARTYBLOCKCHILD',  'LDELSLASH',     'INTEGER',       'COMMA',
  'OPENP',         'CLOSEP',        'MATH',          'UNIMATH',
  'ANDSYM',        'ISIN',          'ISDIVBY',       'ISNOTDIVBY',
  'ISEVEN',        'ISNOTEVEN',     'ISEVENBY',      'ISNOTEVENBY',
  'ISODD',         'ISNOTODD',      'ISODDBY',       'ISNOTODDBY',
  'INSTANCEOF',    'QMARK',         'NOT',           'TYPECAST',
  'HEX',           'DOT',           'SINGLEQUOTESTRING',  'DOUBLECOLON',
  'AT',            'HATCH',         'OPENB',         'CLOSEB',
  'EQUALS',        'NOTEQUALS',     'GREATERTHAN',   'LESSTHAN',
  'GREATEREQUAL',  'LESSEQUAL',     'IDENTITY',      'NONEIDENTITY',
  'MOD',           'LAND',          'LOR',           'LXOR',
  'QUOTE',         'BACKTICK',      'DOLLARID',      'error',
  'start',         'template',      'template_element',  'smartytag',
  'literal',       'literal_elements',  'literal_element',  'value',
  'modifierlist',  'attributes',    'expr',          'varindexed',
  'statement',     'statements',    'optspace',      'varvar',
  'foraction',     'modparameters',  'attribute',     'ternary',
  'array',         'ifcond',        'lop',           'variable',
  'function',      'doublequoted_with_quotes',  'static_class_access',  'object',
  'arrayindex',    'indexdef',      'varvarele',     'objectchain',
  'objectelement',  'method',        'params',        'modifier',
  'modparameter',  'arrayelements',  'arrayelement',  'doublequoted',
  'doublequotedcontent',
    );

    static public $yyRuleName = array(
 /*   0 */ "start ::= template",
 /*   1 */ "template ::= template_element",
 /*   2 */ "template ::= template template_element",
 /*   3 */ "template ::=",
 /*   4 */ "template_element ::= smartytag",
 /*   5 */ "template_element ::= COMMENT",
 /*   6 */ "template_element ::= literal",
 /*   7 */ "template_element ::= PHPSTARTTAG",
 /*   8 */ "template_element ::= PHPENDTAG",
 /*   9 */ "template_element ::= ASPSTARTTAG",
 /*  10 */ "template_element ::= ASPENDTAG",
 /*  11 */ "template_element ::= FAKEPHPSTARTTAG",
 /*  12 */ "template_element ::= XMLTAG",
 /*  13 */ "template_element ::= OTHER",
 /*  14 */ "template_element ::= LINEBREAK",
 /*  15 */ "literal ::= LITERALSTART LITERALEND",
 /*  16 */ "literal ::= LITERALSTART literal_elements LITERALEND",
 /*  17 */ "literal_elements ::= literal_elements literal_element",
 /*  18 */ "literal_elements ::=",
 /*  19 */ "literal_element ::= literal",
 /*  20 */ "literal_element ::= LITERAL",
 /*  21 */ "literal_element ::= PHPSTARTTAG",
 /*  22 */ "literal_element ::= FAKEPHPSTARTTAG",
 /*  23 */ "literal_element ::= PHPENDTAG",
 /*  24 */ "literal_element ::= ASPSTARTTAG",
 /*  25 */ "literal_element ::= ASPENDTAG",
 /*  26 */ "smartytag ::= LDEL value RDEL",
 /*  27 */ "smartytag ::= LDEL value modifierlist attributes RDEL",
 /*  28 */ "smartytag ::= LDEL value attributes RDEL",
 /*  29 */ "smartytag ::= LDEL expr modifierlist attributes RDEL",
 /*  30 */ "smartytag ::= LDEL expr attributes RDEL",
 /*  31 */ "smartytag ::= LDEL DOLLAR ID EQUAL value RDEL",
 /*  32 */ "smartytag ::= LDEL DOLLAR ID EQUAL expr RDEL",
 /*  33 */ "smartytag ::= LDEL DOLLAR ID EQUAL expr attributes RDEL",
 /*  34 */ "smartytag ::= LDEL varindexed EQUAL expr attributes RDEL",
 /*  35 */ "smartytag ::= LDEL ID attributes RDEL",
 /*  36 */ "smartytag ::= LDEL ID RDEL",
 /*  37 */ "smartytag ::= LDEL ID PTR ID attributes RDEL",
 /*  38 */ "smartytag ::= LDEL ID modifierlist attributes RDEL",
 /*  39 */ "smartytag ::= LDEL ID PTR ID modifierlist attributes RDEL",
 /*  40 */ "smartytag ::= LDELIF expr RDEL",
 /*  41 */ "smartytag ::= LDELIF expr attributes RDEL",
 /*  42 */ "smartytag ::= LDELIF statement RDEL",
 /*  43 */ "smartytag ::= LDELIF statement attributes RDEL",
 /*  44 */ "smartytag ::= LDELFOR statements SEMICOLON optspace expr SEMICOLON optspace DOLLAR varvar foraction attributes RDEL",
 /*  45 */ "foraction ::= EQUAL expr",
 /*  46 */ "foraction ::= INCDEC",
 /*  47 */ "smartytag ::= LDELFOR statement TO expr attributes RDEL",
 /*  48 */ "smartytag ::= LDELFOR statement TO expr STEP expr attributes RDEL",
 /*  49 */ "smartytag ::= LDELFOREACH attributes RDEL",
 /*  50 */ "smartytag ::= LDELFOREACH SPACE value AS DOLLAR varvar attributes RDEL",
 /*  51 */ "smartytag ::= LDELFOREACH SPACE value AS DOLLAR varvar APTR DOLLAR varvar attributes RDEL",
 /*  52 */ "smartytag ::= LDELFOREACH SPACE expr AS DOLLAR varvar attributes RDEL",
 /*  53 */ "smartytag ::= LDELFOREACH SPACE expr AS DOLLAR varvar APTR DOLLAR varvar attributes RDEL",
 /*  54 */ "smartytag ::= LDELSETFILTER ID modparameters RDEL",
 /*  55 */ "smartytag ::= LDELSETFILTER ID modparameters modifierlist RDEL",
 /*  56 */ "smartytag ::= SMARTYBLOCKCHILD",
 /*  57 */ "smartytag ::= LDELSLASH ID RDEL",
 /*  58 */ "smartytag ::= LDELSLASH ID modifierlist RDEL",
 /*  59 */ "smartytag ::= LDELSLASH ID PTR ID RDEL",
 /*  60 */ "smartytag ::= LDELSLASH ID PTR ID modifierlist RDEL",
 /*  61 */ "attributes ::= attributes attribute",
 /*  62 */ "attributes ::= attribute",
 /*  63 */ "attributes ::=",
 /*  64 */ "attribute ::= SPACE ID EQUAL ID",
 /*  65 */ "attribute ::= SPACE ID EQUAL expr",
 /*  66 */ "attribute ::= SPACE ID EQUAL value",
 /*  67 */ "attribute ::= SPACE ID",
 /*  68 */ "attribute ::= SPACE expr",
 /*  69 */ "attribute ::= SPACE value",
 /*  70 */ "attribute ::= SPACE INTEGER EQUAL expr",
 /*  71 */ "statements ::= statement",
 /*  72 */ "statements ::= statements COMMA statement",
 /*  73 */ "statement ::= DOLLAR varvar EQUAL expr",
 /*  74 */ "statement ::= varindexed EQUAL expr",
 /*  75 */ "statement ::= OPENP statement CLOSEP",
 /*  76 */ "expr ::= value",
 /*  77 */ "expr ::= ternary",
 /*  78 */ "expr ::= DOLLAR ID COLON ID",
 /*  79 */ "expr ::= expr MATH value",
 /*  80 */ "expr ::= expr UNIMATH value",
 /*  81 */ "expr ::= expr ANDSYM value",
 /*  82 */ "expr ::= array",
 /*  83 */ "expr ::= expr modifierlist",
 /*  84 */ "expr ::= expr ifcond expr",
 /*  85 */ "expr ::= expr ISIN array",
 /*  86 */ "expr ::= expr ISIN value",
 /*  87 */ "expr ::= expr lop expr",
 /*  88 */ "expr ::= expr ISDIVBY expr",
 /*  89 */ "expr ::= expr ISNOTDIVBY expr",
 /*  90 */ "expr ::= expr ISEVEN",
 /*  91 */ "expr ::= expr ISNOTEVEN",
 /*  92 */ "expr ::= expr ISEVENBY expr",
 /*  93 */ "expr ::= expr ISNOTEVENBY expr",
 /*  94 */ "expr ::= expr ISODD",
 /*  95 */ "expr ::= expr ISNOTODD",
 /*  96 */ "expr ::= expr ISODDBY expr",
 /*  97 */ "expr ::= expr ISNOTODDBY expr",
 /*  98 */ "expr ::= value INSTANCEOF ID",
 /*  99 */ "expr ::= value INSTANCEOF value",
 /* 100 */ "ternary ::= OPENP expr CLOSEP QMARK DOLLAR ID COLON expr",
 /* 101 */ "ternary ::= OPENP expr CLOSEP QMARK expr COLON expr",
 /* 102 */ "value ::= variable",
 /* 103 */ "value ::= UNIMATH value",
 /* 104 */ "value ::= NOT value",
 /* 105 */ "value ::= TYPECAST value",
 /* 106 */ "value ::= variable INCDEC",
 /* 107 */ "value ::= HEX",
 /* 108 */ "value ::= INTEGER",
 /* 109 */ "value ::= INTEGER DOT INTEGER",
 /* 110 */ "value ::= INTEGER DOT",
 /* 111 */ "value ::= DOT INTEGER",
 /* 112 */ "value ::= ID",
 /* 113 */ "value ::= function",
 /* 114 */ "value ::= OPENP expr CLOSEP",
 /* 115 */ "value ::= SINGLEQUOTESTRING",
 /* 116 */ "value ::= doublequoted_with_quotes",
 /* 117 */ "value ::= ID DOUBLECOLON static_class_access",
 /* 118 */ "value ::= varindexed DOUBLECOLON static_class_access",
 /* 119 */ "value ::= smartytag",
 /* 120 */ "value ::= value modifierlist",
 /* 121 */ "variable ::= varindexed",
 /* 122 */ "variable ::= DOLLAR varvar AT ID",
 /* 123 */ "variable ::= object",
 /* 124 */ "variable ::= HATCH ID HATCH",
 /* 125 */ "variable ::= HATCH variable HATCH",
 /* 126 */ "varindexed ::= DOLLAR varvar arrayindex",
 /* 127 */ "arrayindex ::= arrayindex indexdef",
 /* 128 */ "arrayindex ::=",
 /* 129 */ "indexdef ::= DOT DOLLAR varvar",
 /* 130 */ "indexdef ::= DOT DOLLAR varvar AT ID",
 /* 131 */ "indexdef ::= DOT ID",
 /* 132 */ "indexdef ::= DOT INTEGER",
 /* 133 */ "indexdef ::= DOT LDEL expr RDEL",
 /* 134 */ "indexdef ::= OPENB ID CLOSEB",
 /* 135 */ "indexdef ::= OPENB ID DOT ID CLOSEB",
 /* 136 */ "indexdef ::= OPENB expr CLOSEB",
 /* 137 */ "indexdef ::= OPENB CLOSEB",
 /* 138 */ "varvar ::= varvarele",
 /* 139 */ "varvar ::= varvar varvarele",
 /* 140 */ "varvarele ::= ID",
 /* 141 */ "varvarele ::= LDEL expr RDEL",
 /* 142 */ "object ::= varindexed objectchain",
 /* 143 */ "objectchain ::= objectelement",
 /* 144 */ "objectchain ::= objectchain objectelement",
 /* 145 */ "objectelement ::= PTR ID arrayindex",
 /* 146 */ "objectelement ::= PTR DOLLAR varvar arrayindex",
 /* 147 */ "objectelement ::= PTR LDEL expr RDEL arrayindex",
 /* 148 */ "objectelement ::= PTR ID LDEL expr RDEL arrayindex",
 /* 149 */ "objectelement ::= PTR method",
 /* 150 */ "function ::= ID OPENP params CLOSEP",
 /* 151 */ "method ::= ID OPENP params CLOSEP",
 /* 152 */ "method ::= DOLLAR ID OPENP params CLOSEP",
 /* 153 */ "params ::= params COMMA expr",
 /* 154 */ "params ::= expr",
 /* 155 */ "params ::=",
 /* 156 */ "modifierlist ::= modifierlist modifier modparameters",
 /* 157 */ "modifierlist ::= modifier modparameters",
 /* 158 */ "modifier ::= VERT AT ID",
 /* 159 */ "modifier ::= VERT ID",
 /* 160 */ "modparameters ::= modparameters modparameter",
 /* 161 */ "modparameters ::=",
 /* 162 */ "modparameter ::= COLON value",
 /* 163 */ "modparameter ::= COLON array",
 /* 164 */ "static_class_access ::= method",
 /* 165 */ "static_class_access ::= method objectchain",
 /* 166 */ "static_class_access ::= ID",
 /* 167 */ "static_class_access ::= DOLLAR ID arrayindex",
 /* 168 */ "static_class_access ::= DOLLAR ID arrayindex objectchain",
 /* 169 */ "ifcond ::= EQUALS",
 /* 170 */ "ifcond ::= NOTEQUALS",
 /* 171 */ "ifcond ::= GREATERTHAN",
 /* 172 */ "ifcond ::= LESSTHAN",
 /* 173 */ "ifcond ::= GREATEREQUAL",
 /* 174 */ "ifcond ::= LESSEQUAL",
 /* 175 */ "ifcond ::= IDENTITY",
 /* 176 */ "ifcond ::= NONEIDENTITY",
 /* 177 */ "ifcond ::= MOD",
 /* 178 */ "lop ::= LAND",
 /* 179 */ "lop ::= LOR",
 /* 180 */ "lop ::= LXOR",
 /* 181 */ "array ::= OPENB arrayelements CLOSEB",
 /* 182 */ "arrayelements ::= arrayelement",
 /* 183 */ "arrayelements ::= arrayelements COMMA arrayelement",
 /* 184 */ "arrayelements ::=",
 /* 185 */ "arrayelement ::= value APTR expr",
 /* 186 */ "arrayelement ::= ID APTR expr",
 /* 187 */ "arrayelement ::= expr",
 /* 188 */ "doublequoted_with_quotes ::= QUOTE QUOTE",
 /* 189 */ "doublequoted_with_quotes ::= QUOTE doublequoted QUOTE",
 /* 190 */ "doublequoted ::= doublequoted doublequotedcontent",
 /* 191 */ "doublequoted ::= doublequotedcontent",
 /* 192 */ "doublequotedcontent ::= BACKTICK variable BACKTICK",
 /* 193 */ "doublequotedcontent ::= BACKTICK expr BACKTICK",
 /* 194 */ "doublequotedcontent ::= DOLLARID",
 /* 195 */ "doublequotedcontent ::= LDEL variable RDEL",
 /* 196 */ "doublequotedcontent ::= LDEL expr RDEL",
 /* 197 */ "doublequotedcontent ::= smartytag",
 /* 198 */ "doublequotedcontent ::= OTHER",
 /* 199 */ "optspace ::= SPACE",
 /* 200 */ "optspace ::=",
    );

    function tokenName($tokenType)
    {
        if ($tokenType === 0) {
            return 'End of Input';
        }
        if ($tokenType > 0 && $tokenType < count($this->yyTokenName)) {
            return $this->yyTokenName[$tokenType];
        } else {
            return "Unknown";
        }
    }

    static function yy_destructor($yymajor, $yypminor)
    {
        switch ($yymajor) {
            default:  break;   /* If no destructor action specified: do nothing */
        }
    }

    function yy_pop_parser_stack()
    {
        if (!count($this->yystack)) {
            return;
        }
        $yytos = array_pop($this->yystack);
        if (self::$yyTraceFILE && $this->yyidx >= 0) {
            fwrite(self::$yyTraceFILE,
                self::$yyTracePrompt . 'Popping ' . $this->yyTokenName[$yytos->major] .
                    "\n");
        }
        $yymajor = $yytos->major;
        self::yy_destructor($yymajor, $yytos->minor);
        $this->yyidx--;
        return $yymajor;
    }

    function __destruct()
    {
        while ($this->yystack !== Array()) {
            $this->yy_pop_parser_stack();
        }
        if (is_resource(self::$yyTraceFILE)) {
            fclose(self::$yyTraceFILE);
        }
    }

    function yy_get_expected_tokens($token)
    {
        $state = $this->yystack[$this->yyidx]->stateno;
        $expected = self::$yyExpectedTokens[$state];
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return $expected;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return array_unique($expected);
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate])) {
		        $expected = array_merge($expected, self::$yyExpectedTokens[$nextstate]);
                            if (in_array($token,
                                  self::$yyExpectedTokens[$nextstate], true)) {
                            $this->yyidx = $yyidx;
                            $this->yystack = $stack;
                            return array_unique($expected);
                        }
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new TP_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return array_unique($expected);
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return $expected;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
	$this->yyidx = $yyidx;
	$this->yystack = $stack;
        return array_unique($expected);
    }

    function yy_is_expected_token($token)
    {
        if ($token === 0) {
            return true; // 0 is not part of this
        }
        $state = $this->yystack[$this->yyidx]->stateno;
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return true;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return true;
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate]) &&
                          in_array($token, self::$yyExpectedTokens[$nextstate], true)) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        return true;
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new TP_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        if (!$token) {
                            // end of input: this is valid
                            return true;
                        }
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return false;
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return true;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
        $this->yyidx = $yyidx;
        $this->yystack = $stack;
        return true;
    }

   function yy_find_shift_action($iLookAhead)
    {
        $stateno = $this->yystack[$this->yyidx]->stateno;

        /* if ($this->yyidx < 0) return self::YY_NO_ACTION;  */
        if (!isset(self::$yy_shift_ofst[$stateno])) {
            // no shift actions
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_shift_ofst[$stateno];
        if ($i === self::YY_SHIFT_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            if (count(self::$yyFallback) && $iLookAhead < count(self::$yyFallback)
                   && ($iFallback = self::$yyFallback[$iLookAhead]) != 0) {
                if (self::$yyTraceFILE) {
                    fwrite(self::$yyTraceFILE, self::$yyTracePrompt . "FALLBACK " .
                        $this->yyTokenName[$iLookAhead] . " => " .
                        $this->yyTokenName[$iFallback] . "\n");
                }
                return $this->yy_find_shift_action($iFallback);
            }
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    function yy_find_reduce_action($stateno, $iLookAhead)
    {
        /* $stateno = $this->yystack[$this->yyidx]->stateno; */

        if (!isset(self::$yy_reduce_ofst[$stateno])) {
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_reduce_ofst[$stateno];
        if ($i == self::YY_REDUCE_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    function yy_shift($yyNewState, $yyMajor, $yypMinor)
    {
        $this->yyidx++;
        if ($this->yyidx >= self::YYSTACKDEPTH) {
            $this->yyidx--;
            if (self::$yyTraceFILE) {
                fprintf(self::$yyTraceFILE, "%sStack Overflow!\n", self::$yyTracePrompt);
            }
            while ($this->yyidx >= 0) {
                $this->yy_pop_parser_stack();
            }
#line 83 "smarty_internal_templateparser.y"

    $this->internalError = true;
    $this->compiler->trigger_template_error("Stack overflow in template parser");
#line 1715 "smarty_internal_templateparser.php"
            return;
        }
        $yytos = new TP_yyStackEntry;
        $yytos->stateno = $yyNewState;
        $yytos->major = $yyMajor;
        $yytos->minor = $yypMinor;
        array_push($this->yystack, $yytos);
        if (self::$yyTraceFILE && $this->yyidx > 0) {
            fprintf(self::$yyTraceFILE, "%sShift %d\n", self::$yyTracePrompt,
                $yyNewState);
            fprintf(self::$yyTraceFILE, "%sStack:", self::$yyTracePrompt);
            for($i = 1; $i <= $this->yyidx; $i++) {
                fprintf(self::$yyTraceFILE, " %s",
                    $this->yyTokenName[$this->yystack[$i]->major]);
            }
            fwrite(self::$yyTraceFILE,"\n");
        }
    }

    static public $yyRuleInfo = array(
  array( 'lhs' => 80, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 2 ),
  array( 'lhs' => 81, 'rhs' => 0 ),
  array( 'lhs' => 82, 'rhs' => 1 ),
  array( 'lhs' => 82, 'rhs' => 1 ),
  array( 'lhs' => 82, 'rhs' => 1 ),
  array( 'lhs' => 82, 'rhs' => 1 ),
  array( 'lhs' => 82, 'rhs' => 1 ),
  array( 'lhs' => 82, 'rhs' => 1 ),
  array( 'lhs' => 82, 'rhs' => 1 ),
  array( 'lhs' => 82, 'rhs' => 1 ),
  array( 'lhs' => 82, 'rhs' => 1 ),
  array( 'lhs' => 82, 'rhs' => 1 ),
  array( 'lhs' => 82, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 2 ),
  array( 'lhs' => 84, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 2 ),
  array( 'lhs' => 85, 'rhs' => 0 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 83, 'rhs' => 3 ),
  array( 'lhs' => 83, 'rhs' => 5 ),
  array( 'lhs' => 83, 'rhs' => 4 ),
  array( 'lhs' => 83, 'rhs' => 5 ),
  array( 'lhs' => 83, 'rhs' => 4 ),
  array( 'lhs' => 83, 'rhs' => 6 ),
  array( 'lhs' => 83, 'rhs' => 6 ),
  array( 'lhs' => 83, 'rhs' => 7 ),
  array( 'lhs' => 83, 'rhs' => 6 ),
  array( 'lhs' => 83, 'rhs' => 4 ),
  array( 'lhs' => 83, 'rhs' => 3 ),
  array( 'lhs' => 83, 'rhs' => 6 ),
  array( 'lhs' => 83, 'rhs' => 5 ),
  array( 'lhs' => 83, 'rhs' => 7 ),
  array( 'lhs' => 83, 'rhs' => 3 ),
  array( 'lhs' => 83, 'rhs' => 4 ),
  array( 'lhs' => 83, 'rhs' => 3 ),
  array( 'lhs' => 83, 'rhs' => 4 ),
  array( 'lhs' => 83, 'rhs' => 12 ),
  array( 'lhs' => 96, 'rhs' => 2 ),
  array( 'lhs' => 96, 'rhs' => 1 ),
  array( 'lhs' => 83, 'rhs' => 6 ),
  array( 'lhs' => 83, 'rhs' => 8 ),
  array( 'lhs' => 83, 'rhs' => 3 ),
  array( 'lhs' => 83, 'rhs' => 8 ),
  array( 'lhs' => 83, 'rhs' => 11 ),
  array( 'lhs' => 83, 'rhs' => 8 ),
  array( 'lhs' => 83, 'rhs' => 11 ),
  array( 'lhs' => 83, 'rhs' => 4 ),
  array( 'lhs' => 83, 'rhs' => 5 ),
  array( 'lhs' => 83, 'rhs' => 1 ),
  array( 'lhs' => 83, 'rhs' => 3 ),
  array( 'lhs' => 83, 'rhs' => 4 ),
  array( 'lhs' => 83, 'rhs' => 5 ),
  array( 'lhs' => 83, 'rhs' => 6 ),
  array( 'lhs' => 89, 'rhs' => 2 ),
  array( 'lhs' => 89, 'rhs' => 1 ),
  array( 'lhs' => 89, 'rhs' => 0 ),
  array( 'lhs' => 98, 'rhs' => 4 ),
  array( 'lhs' => 98, 'rhs' => 4 ),
  array( 'lhs' => 98, 'rhs' => 4 ),
  array( 'lhs' => 98, 'rhs' => 2 ),
  array( 'lhs' => 98, 'rhs' => 2 ),
  array( 'lhs' => 98, 'rhs' => 2 ),
  array( 'lhs' => 98, 'rhs' => 4 ),
  array( 'lhs' => 93, 'rhs' => 1 ),
  array( 'lhs' => 93, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 4 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 1 ),
  array( 'lhs' => 90, 'rhs' => 1 ),
  array( 'lhs' => 90, 'rhs' => 4 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 1 ),
  array( 'lhs' => 90, 'rhs' => 2 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 2 ),
  array( 'lhs' => 90, 'rhs' => 2 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 2 ),
  array( 'lhs' => 90, 'rhs' => 2 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 99, 'rhs' => 8 ),
  array( 'lhs' => 99, 'rhs' => 7 ),
  array( 'lhs' => 87, 'rhs' => 1 ),
  array( 'lhs' => 87, 'rhs' => 2 ),
  array( 'lhs' => 87, 'rhs' => 2 ),
  array( 'lhs' => 87, 'rhs' => 2 ),
  array( 'lhs' => 87, 'rhs' => 2 ),
  array( 'lhs' => 87, 'rhs' => 1 ),
  array( 'lhs' => 87, 'rhs' => 1 ),
  array( 'lhs' => 87, 'rhs' => 3 ),
  array( 'lhs' => 87, 'rhs' => 2 ),
  array( 'lhs' => 87, 'rhs' => 2 ),
  array( 'lhs' => 87, 'rhs' => 1 ),
  array( 'lhs' => 87, 'rhs' => 1 ),
  array( 'lhs' => 87, 'rhs' => 3 ),
  array( 'lhs' => 87, 'rhs' => 1 ),
  array( 'lhs' => 87, 'rhs' => 1 ),
  array( 'lhs' => 87, 'rhs' => 3 ),
  array( 'lhs' => 87, 'rhs' => 3 ),
  array( 'lhs' => 87, 'rhs' => 1 ),
  array( 'lhs' => 87, 'rhs' => 2 ),
  array( 'lhs' => 103, 'rhs' => 1 ),
  array( 'lhs' => 103, 'rhs' => 4 ),
  array( 'lhs' => 103, 'rhs' => 1 ),
  array( 'lhs' => 103, 'rhs' => 3 ),
  array( 'lhs' => 103, 'rhs' => 3 ),
  array( 'lhs' => 91, 'rhs' => 3 ),
  array( 'lhs' => 108, 'rhs' => 2 ),
  array( 'lhs' => 108, 'rhs' => 0 ),
  array( 'lhs' => 109, 'rhs' => 3 ),
  array( 'lhs' => 109, 'rhs' => 5 ),
  array( 'lhs' => 109, 'rhs' => 2 ),
  array( 'lhs' => 109, 'rhs' => 2 ),
  array( 'lhs' => 109, 'rhs' => 4 ),
  array( 'lhs' => 109, 'rhs' => 3 ),
  array( 'lhs' => 109, 'rhs' => 5 ),
  array( 'lhs' => 109, 'rhs' => 3 ),
  array( 'lhs' => 109, 'rhs' => 2 ),
  array( 'lhs' => 95, 'rhs' => 1 ),
  array( 'lhs' => 95, 'rhs' => 2 ),
  array( 'lhs' => 110, 'rhs' => 1 ),
  array( 'lhs' => 110, 'rhs' => 3 ),
  array( 'lhs' => 107, 'rhs' => 2 ),
  array( 'lhs' => 111, 'rhs' => 1 ),
  array( 'lhs' => 111, 'rhs' => 2 ),
  array( 'lhs' => 112, 'rhs' => 3 ),
  array( 'lhs' => 112, 'rhs' => 4 ),
  array( 'lhs' => 112, 'rhs' => 5 ),
  array( 'lhs' => 112, 'rhs' => 6 ),
  array( 'lhs' => 112, 'rhs' => 2 ),
  array( 'lhs' => 104, 'rhs' => 4 ),
  array( 'lhs' => 113, 'rhs' => 4 ),
  array( 'lhs' => 113, 'rhs' => 5 ),
  array( 'lhs' => 114, 'rhs' => 3 ),
  array( 'lhs' => 114, 'rhs' => 1 ),
  array( 'lhs' => 114, 'rhs' => 0 ),
  array( 'lhs' => 88, 'rhs' => 3 ),
  array( 'lhs' => 88, 'rhs' => 2 ),
  array( 'lhs' => 115, 'rhs' => 3 ),
  array( 'lhs' => 115, 'rhs' => 2 ),
  array( 'lhs' => 97, 'rhs' => 2 ),
  array( 'lhs' => 97, 'rhs' => 0 ),
  array( 'lhs' => 116, 'rhs' => 2 ),
  array( 'lhs' => 116, 'rhs' => 2 ),
  array( 'lhs' => 106, 'rhs' => 1 ),
  array( 'lhs' => 106, 'rhs' => 2 ),
  array( 'lhs' => 106, 'rhs' => 1 ),
  array( 'lhs' => 106, 'rhs' => 3 ),
  array( 'lhs' => 106, 'rhs' => 4 ),
  array( 'lhs' => 101, 'rhs' => 1 ),
  array( 'lhs' => 101, 'rhs' => 1 ),
  array( 'lhs' => 101, 'rhs' => 1 ),
  array( 'lhs' => 101, 'rhs' => 1 ),
  array( 'lhs' => 101, 'rhs' => 1 ),
  array( 'lhs' => 101, 'rhs' => 1 ),
  array( 'lhs' => 101, 'rhs' => 1 ),
  array( 'lhs' => 101, 'rhs' => 1 ),
  array( 'lhs' => 101, 'rhs' => 1 ),
  array( 'lhs' => 102, 'rhs' => 1 ),
  array( 'lhs' => 102, 'rhs' => 1 ),
  array( 'lhs' => 102, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 3 ),
  array( 'lhs' => 117, 'rhs' => 1 ),
  array( 'lhs' => 117, 'rhs' => 3 ),
  array( 'lhs' => 117, 'rhs' => 0 ),
  array( 'lhs' => 118, 'rhs' => 3 ),
  array( 'lhs' => 118, 'rhs' => 3 ),
  array( 'lhs' => 118, 'rhs' => 1 ),
  array( 'lhs' => 105, 'rhs' => 2 ),
  array( 'lhs' => 105, 'rhs' => 3 ),
  array( 'lhs' => 119, 'rhs' => 2 ),
  array( 'lhs' => 119, 'rhs' => 1 ),
  array( 'lhs' => 120, 'rhs' => 3 ),
  array( 'lhs' => 120, 'rhs' => 3 ),
  array( 'lhs' => 120, 'rhs' => 1 ),
  array( 'lhs' => 120, 'rhs' => 3 ),
  array( 'lhs' => 120, 'rhs' => 3 ),
  array( 'lhs' => 120, 'rhs' => 1 ),
  array( 'lhs' => 120, 'rhs' => 1 ),
  array( 'lhs' => 94, 'rhs' => 1 ),
  array( 'lhs' => 94, 'rhs' => 0 ),
    );

    static public $yyReduceMap = array(
        0 => 0,
        1 => 1,
        2 => 1,
        4 => 4,
        5 => 5,
        6 => 6,
        7 => 7,
        8 => 8,
        9 => 9,
        10 => 10,
        11 => 11,
        12 => 12,
        13 => 13,
        14 => 14,
        15 => 15,
        18 => 15,
        200 => 15,
        16 => 16,
        75 => 16,
        17 => 17,
        103 => 17,
        105 => 17,
        106 => 17,
        127 => 17,
        165 => 17,
        19 => 19,
        20 => 19,
        46 => 19,
        68 => 19,
        69 => 19,
        76 => 19,
        77 => 19,
        82 => 19,
        102 => 19,
        107 => 19,
        108 => 19,
        113 => 19,
        115 => 19,
        116 => 19,
        123 => 19,
        138 => 19,
        164 => 19,
        166 => 19,
        182 => 19,
        187 => 19,
        199 => 19,
        21 => 21,
        22 => 21,
        23 => 23,
        24 => 24,
        25 => 25,
        26 => 26,
        27 => 27,
        28 => 28,
        30 => 28,
        29 => 29,
        31 => 31,
        32 => 31,
        33 => 33,
        34 => 34,
        35 => 35,
        36 => 36,
        37 => 37,
        38 => 38,
        39 => 39,
        40 => 40,
        41 => 41,
        43 => 41,
        42 => 42,
        44 => 44,
        45 => 45,
        47 => 47,
        48 => 48,
        49 => 49,
        50 => 50,
        51 => 51,
        52 => 52,
        53 => 53,
        54 => 54,
        55 => 55,
        56 => 56,
        57 => 57,
        58 => 58,
        59 => 59,
        60 => 60,
        61 => 61,
        62 => 62,
        71 => 62,
        154 => 62,
        158 => 62,
        162 => 62,
        163 => 62,
        63 => 63,
        155 => 63,
        161 => 63,
        64 => 64,
        65 => 65,
        66 => 65,
        70 => 65,
        67 => 67,
        72 => 72,
        73 => 73,
        74 => 73,
        78 => 78,
        79 => 79,
        80 => 79,
        81 => 79,
        83 => 83,
        120 => 83,
        84 => 84,
        87 => 84,
        98 => 84,
        85 => 85,
        86 => 86,
        88 => 88,
        89 => 89,
        90 => 90,
        95 => 90,
        91 => 91,
        94 => 91,
        92 => 92,
        97 => 92,
        93 => 93,
        96 => 93,
        99 => 99,
        100 => 100,
        101 => 101,
        104 => 104,
        109 => 109,
        110 => 110,
        111 => 111,
        112 => 112,
        114 => 114,
        117 => 117,
        118 => 118,
        119 => 119,
        121 => 121,
        122 => 122,
        124 => 124,
        125 => 125,
        126 => 126,
        128 => 128,
        184 => 128,
        129 => 129,
        130 => 130,
        131 => 131,
        132 => 132,
        133 => 133,
        136 => 133,
        134 => 134,
        135 => 135,
        137 => 137,
        139 => 139,
        140 => 140,
        141 => 141,
        142 => 142,
        143 => 143,
        144 => 144,
        145 => 145,
        146 => 146,
        147 => 147,
        148 => 148,
        149 => 149,
        150 => 150,
        151 => 151,
        152 => 152,
        153 => 153,
        156 => 156,
        157 => 157,
        159 => 159,
        160 => 160,
        167 => 167,
        168 => 168,
        169 => 169,
        170 => 170,
        171 => 171,
        172 => 172,
        173 => 173,
        174 => 174,
        175 => 175,
        176 => 176,
        177 => 177,
        178 => 178,
        179 => 179,
        180 => 180,
        181 => 181,
        183 => 183,
        185 => 185,
        186 => 186,
        188 => 188,
        189 => 189,
        190 => 190,
        191 => 191,
        192 => 192,
        193 => 192,
        195 => 192,
        194 => 194,
        196 => 196,
        197 => 197,
        198 => 198,
    );
#line 94 "smarty_internal_templateparser.y"
    function yy_r0(){
    $this->_retvalue = $this->root_buffer->to_smarty_php();
    }
#line 2145 "smarty_internal_templateparser.php"
#line 102 "smarty_internal_templateparser.y"
    function yy_r1(){
    $this->current_buffer->append_subtree($this->yystack[$this->yyidx + 0]->minor);
    }
#line 2150 "smarty_internal_templateparser.php"
#line 118 "smarty_internal_templateparser.y"
    function yy_r4(){
    if ($this->compiler->has_code) {
        $tmp =''; foreach ($this->compiler->prefix_code as $code) {$tmp.=$code;} $this->compiler->prefix_code=array();
        $this->_retvalue = new _smarty_tag($this, $this->compiler->processNocacheCode($tmp.$this->yystack[$this->yyidx + 0]->minor,true));
    } else {
        $this->_retvalue = new _smarty_tag($this, $this->yystack[$this->yyidx + 0]->minor);
    }
    $this->compiler->has_variable_string = false;
    $this->block_nesting_level = count($this->compiler->_tag_stack);
    }
#line 2162 "smarty_internal_templateparser.php"
#line 130 "smarty_internal_templateparser.y"
    function yy_r5(){
    $this->_retvalue = new _smarty_tag($this, '');
    }
#line 2167 "smarty_internal_templateparser.php"
#line 135 "smarty_internal_templateparser.y"
    function yy_r6(){
    $this->_retvalue = new _smarty_text($this, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 2172 "smarty_internal_templateparser.php"
#line 140 